/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.APair;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.wb_route.LayerSelectorCombo;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import com.sigrity.orbit.ui.wb_route.PadTemplateComboBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RouteLayerAndViaChooserDialog
extends ADialog {
    protected boolean mUserSaidOk = false;
    protected LinkedList<Layer> mSelectedLayers = new LinkedList();
    protected LinkedList<PadTemplate> mSelectedPadstacks = new LinkedList();
    protected Substrate mSubstrate;
    protected PadTemplateComboBox mComboPadTemplate;
    protected LayerSelectorCombo mComboLayer;
    protected JButton mMakePadstack;
    protected boolean mJustLayers = false;
    protected ActionListener mMakePadStackListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PadStackDlg psd = PadStackDlg.createDialog((Window)((Object)RouteLayerAndViaChooserDialog.this), "RouteVia", RouteLayerAndViaChooserDialog.this.mSubstrate.getADevicePathUsing());
            PadTemplate pt = psd.getActivePadTemplate();
            RouteLayerAndViaChooserDialog.this.mComboPadTemplate.populatePadTemplates();
            RouteLayerAndViaChooserDialog.this.mComboPadTemplate.setSelectedItem(pt);
        }
    };
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RouteLayerAndViaChooserDialog.this.mUserSaidOk = true;
            UIUtil.closeWindow((Window)((Object)RouteLayerAndViaChooserDialog.this));
        }
    };

    public RouteLayerAndViaChooserDialog(Window owner) {
        super(owner);
    }

    public static void editBundleLayers(Bundle bundle) {
        List layers = bundle.getLayers();
        LinkedList<String> padstacks = new LinkedList<String>();
        for (int i = 0; i < layers.size(); ++i) {
            padstacks.add("Default");
        }
        RouteLayerAndViaChooserDialog dlg = RouteLayerAndViaChooserDialog.createDialog(OrbitIO.getMainWindow(), bundle.getTemplate().getSubstrate(), layers, null, true);
        dlg.setVisible(true);
        if (dlg.userSaidOk()) {
            Cp.exec((String)"_bundle = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(bundle)});
            Cp.exec((String)"_bundle.clearLayers();", (Object[])new Object[0]);
            for (APair aPair : dlg.getSelectedLayers()) {
                Cp.exec((String)"_bundle.addLayer(\"%s\");", (Object[])new Object[]{((Layer)aPair.first).getName()});
            }
            Cp.exec((String)"unset(\"_bundle\");", (Object[])new Object[0]);
        }
    }

    public LinkedList<APair<Layer, PadTemplate>> getSelectedLayers() {
        LinkedList<APair<Layer, PadTemplate>> result = new LinkedList<APair<Layer, PadTemplate>>();
        Layer l = (Layer)this.mComboLayer.getSelectedItem();
        if (this.mComboPadTemplate != null) {
            PadTemplate pt = (PadTemplate)this.mComboPadTemplate.getSelectedItem();
            result.add((APair<Layer, PadTemplate>)new APair((Object)l, (Object)pt));
        } else {
            result.add(new APair((Object)l, null));
        }
        return result;
    }

    public static RouteLayerAndViaChooserDialog createDialog(Window owner, Substrate s, List<Layer> selected, List<PadTemplate> padstack, boolean justLayers) {
        RouteLayerAndViaChooserDialog dlg = null;
        dlg = new RouteLayerAndViaChooserDialog(owner);
        dlg.init(s, selected, padstack, justLayers);
        return dlg;
    }

    protected void init(Substrate s, List<Layer> selectedLayers, List<PadTemplate> selectedPadstacks, boolean justLayers) {
        this.mJustLayers = justLayers;
        this.mUserSaidOk = false;
        this.mSelectedLayers.clear();
        this.mSelectedLayers.addAll(selectedLayers);
        this.mSelectedPadstacks.clear();
        DevicePath aPath = s.getADevicePathUsing();
        if (selectedPadstacks != null) {
            this.mSelectedPadstacks.addAll(selectedPadstacks);
        }
        this.mSubstrate = s;
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushFill();
        l.add("RouteLayer");
        this.mComboLayer = (LayerSelectorCombo)l.add((Component)new LayerSelectorCombo(s), (GridBagConstraints)GridBagManager.FILLX);
        this.mComboLayer.addActionListener(new PadStackSelectedListener());
        this.mComboLayer.setSelectedItem(this.mSelectedLayers.getFirst());
        if (!justLayers) {
            l.newline();
            l.add("Via Padstack");
            this.mComboPadTemplate = (PadTemplateComboBox)l.add((Component)new PadTemplateComboBox(aPath), (GridBagConstraints)GridBagManager.FILLX);
            this.mComboPadTemplate.addActionListener(new PadStackSelectedListener());
            this.mComboPadTemplate.setSelectedItem(this.mSelectedPadstacks.getFirst());
            this.mMakePadstack = new JButton("Make Padstack");
            this.mMakePadstack.addActionListener(this.mMakePadStackListener);
            l.add((Component)this.mMakePadstack);
        }
        l.popNl();
        JPanel btnPanel = new JPanel();
        l.push((Container)btnPanel, (GridBagConstraints)GridBagManager.RIGHT);
        JLabel messageLabel = new JLabel("");
        l.add((Component)messageLabel, (GridBagConstraints)GridBagManager.LEFT);
        Font btnFont = messageLabel.getFont();
        messageLabel.setFont(btnFont.deriveFont((float)btnFont.getSize() - 4.0f));
        JButton btnApply = new JButton("Ok");
        l.add((Component)btnApply, (GridBagConstraints)GridBagManager.RIGHT);
        btnApply.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnApply);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        this.setModal(true);
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public boolean userSaidOk() {
        return this.mUserSaidOk;
    }

    class PadStackSelectedListener
    implements ActionListener {
        PadStackSelectedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RouteLayerAndViaChooserDialog.this.repaint();
        }
    }
}

