/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ABoolean;
import com.sigrity.acl.AColor;
import com.sigrity.acl.AHashArray;
import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.Permuter;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.RegexFilterField;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.automation.router.BundleRoutePrep;
import com.sigrity.orbit.automation.router.InteractiveFilteredPortSelectMode;
import com.sigrity.orbit.automation.router.RouterConnectionOptimizer;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.ui.MountingMgmtDlg;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_views.RoutingViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.route_edit.InteractiveRouteEditMode;
import com.sigrity.orbit.ui.wb_route.RDLPersonalizer;
import com.sigrity.orbit.ui.wb_route.RDLRouterInterface;
import com.sigrity.orbit.ui.wb_route.RoutePersonalizer;
import com.sigrity.orbit.ui.wb_route.RouterRuleSetDlg;
import com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI;
import com.sigrity.tools.dbexplorer.DBEResources;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RouteQueue
extends JPanel {
    protected static WeakHashMap<Personality, RoutePersonalizer> mPersonality2Personalizer = new WeakHashMap();
    protected JTable mRouteQueueTable;
    protected JCheckBox mShowMeMode;
    protected JCheckBox mCompact;
    protected JCheckBox mZoomToAllCB;
    protected JButton mSwapTo;
    protected JButton mSwapFrom;
    protected JButton mAddSelectedTo;
    protected JButton mRemoveSelectedTo;
    protected JButton mHighlightSelected;
    protected JButton mOptimize;
    protected JButton mRoute;
    protected JCheckBox mDissallowNetSwapping;
    protected JComboBox<PinTemplate.Type> mSelectPinFilter;
    protected JCheckBox mRemoveViasWhenDeletingWires;
    protected JButton mSeqUpButton;
    protected JButton mSeqDnButton;
    protected JButton mSeqRtButton;
    protected JButton mSeqLtButton;
    protected JButton mFat;
    protected JButton mSkinny;
    protected JButton mWarp;
    protected JLabel mMatchedLabel;
    protected JLabel mStatus;
    protected RouteSides mDirection;
    protected RegexFilterField mFilterField;
    public RouteQueueModel mRouteQueueModel;
    public static RouteQueue theRouteQueue;
    protected CrossProbingMouseAdapter crossProbingMouseAdapter = null;
    protected RouteQueueOverlay rqo;
    protected boolean mInCanvasFindMode = false;
    protected TableCellRenderer tcr;
    protected HistoryListener mHL = null;
    protected int routeStatusColumn = 0;
    protected int ignoreRouteColumn = 1;
    protected int netNameColumn = 2;
    protected int fromPadNameColumn = 3;
    protected int toPadNameColumn = 4;
    protected int lengthNameColumn = 5;
    protected int hintThreatenColumn = 6;
    protected int ruleNameColumn = 7;
    SchedConn changingSchedConn = new SchedConn();
    protected static final String COLROUTESTATUS = "Status";
    protected static final String COLIGNORE = "Fixed";
    protected String COLNET = "Net";
    protected String COLFROMPAD = "From Pad";
    protected String COLTOPAD = "To Pad";
    protected static final String COLRULNAME = "Rule Set";
    protected static final String COLLENGTH = "Length";
    protected static final String COLHINT = "Cross";
    protected static final String SORTA = "Sort Ascending";
    protected static final String SORTD = "Sort Descending";
    protected static final String SHOWNET = "Show Net Name";
    protected static final String SHOWDEVICE = "Show Device Name";
    protected static final String SHOWPATH = "Show Path Name";
    protected static final String SHOWPIN = "Show Pin Name";
    protected static final String SHOWMLENGTH = "Show Manhatten Length";
    protected static final String SHOWRLENGTH = "Show Route Length";
    protected static final String SHOWRES = "Show Route Resistance";
    protected static final String SHOWEFF = "Show Route Efficiency";
    protected static final String FIXALL = "Fix All";
    protected static final String FREEALL = "Free All";
    protected static final String SELECTMODE = "Highlight Mode";
    protected String fromPadShowMode = "Show Device Name";
    protected String toPadShowMode = "Show Net Name";
    protected String lengthMode = "Show Manhatten Length";
    protected int curEditCol;
    protected int curStartPin;
    protected Font stdFont;
    protected DisplayOrder displayOrder = DisplayOrder.NetNameAscending;
    int mCurRow;
    HierPort editingToPin = null;
    public static final String FLDNAME_PRIORITY = "RouteQueue.Priority";
    public static final String FLDNAME_IGNORE = "RouteQueue.Ignore";
    InteractiveFilteredPortSelectMode mPinSelectMode = null;
    protected RouterConnectionOptimizer.LoadListener mOptimizerListener;
    protected SingleLayerRouter.LoadListener mRouteProgressListener;
    protected InteractiveEditModeListener mInteractiveEditModeListener;
    InteractiveRouteEditMode mInteractiveRouteEditMode = null;
    protected static boolean selectionChanging;
    protected static boolean mZoomToAllStatus;
    protected boolean mSimple;
    protected boolean mIsFixed;
    static boolean showSubstrateNetName;
    protected static LinkedList<String> mPerStrList;
    public static final Icon ICON_ARROW_UP;
    public static final Icon ICON_ARROW_DN;
    public static final Icon ICON_ARROW_RT;
    public static final Icon ICON_ARROW_LT;
    private static Map<String, String> mPluginRouter;
    protected LinkedList<String> columnNames = new LinkedList();
    protected ABundleChangedListener mBundleChangeListener = null;
    protected RuleSetListener mRuleSetListener = null;
    protected Action fromZoom = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RouteQueue.this.zoomTo(false);
        }
    };
    protected Action toZoom = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RouteQueue.this.zoomTo(true);
        }
    };
    protected Action allZoom = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RouteQueue.this.zoomTo(null);
        }
    };
    protected Action fatAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RouteQueue.this.fatProcess();
        }
    };
    protected Action skinnyAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RouteQueue.this.skinnyProcess();
        }
    };
    protected Action rvOn = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (String s : mPerStrList) {
                Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
                RouteQueue.routeVisionOn(per);
            }
        }
    };
    protected Action rvOff = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            RouteQueue.routeVisionOff();
        }
    };
    protected ActionListener mReRouteAction = e -> this.reroute();
    protected Action mUnRouteAction = new AbstractAction("Remove Routes"){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean removeVias = RouteQueue.this.mSimple || RouteQueue.this.mRemoveViasWhenDeletingWires.isSelected();
            for (String s : mPerStrList) {
                Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.unRouteRDLPersonality(\"%s\", %b );", (Object[])new Object[]{per.getKeyStr(), removeVias});
                RouteQueue.this.mRouteQueueModel.buildTableFromSchedConn();
            }
            RouteQueue.this.updateUI();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected Action mResortAction = new AbstractAction("Reset Route Order"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DbHistory history = OrbitIO.getCurDb().getHistory();
            try (DbHistory.DbTransaction trans = history.newDbTransaction("Resort Routes");){
                for (String s : mPerStrList) {
                    RouteQueue.resetOrder(s);
                }
            }
            RouteQueue.this.mRouteQueueModel.buildTableFromSchedConn();
            RouteQueue.this.mRouteQueueTable.updateUI();
        }
    };
    protected Action mEditConstraints = new AbstractAction("Edit Rules"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Personality per = null;
            if (mPersonality2Personalizer.size() == 1) {
                per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, mPerStrList.getFirst());
            } else {
                for (int row : RouteQueue.this.mRouteQueueTable.getSelectedRows()) {
                    RouteQueueRow rqr = RouteQueue.this.mRouteQueueModel.getRow(row);
                    if (per != null && per.equals(rqr.per)) {
                        ALog.logInfo((String)"Select one personality only when editing rules");
                        return;
                    }
                    per = rqr.per;
                }
            }
            if (per != null) {
                mPersonality2Personalizer.get(per).editRule(per, null);
            } else {
                ALog.logInfo((String)"Select one personality only when editing rules");
            }
        }
    };
    protected Action mCreateRule = new AbstractAction("Create Rule"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Personality per = null;
            if (mPersonality2Personalizer.size() == 1) {
                per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, mPerStrList.getFirst());
            } else {
                for (int row : RouteQueue.this.mRouteQueueTable.getSelectedRows()) {
                    RouteQueueRow rqr = RouteQueue.this.mRouteQueueModel.getRow(row);
                    if (per != null && per.equals(rqr.per)) {
                        ALog.logInfo((String)"Select one personality only when creating rules");
                        return;
                    }
                    per = rqr.per;
                }
            }
            if (per != null) {
                mPersonality2Personalizer.get(per).createRule(per);
            } else {
                ALog.logInfo((String)"Select one personality only when creating rules");
            }
        }
    };
    protected ActionListener mSwapToPinAction = e -> this.swapToPins();
    protected ActionListener mSwapIOAction = e -> this.swapFromPins();
    protected ActionListener mWarpAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (mPerStrList.size() == 1) {
                for (String s : mPerStrList) {
                    Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
                    Bundle bundle = Bundle.getBundle((Personality)per);
                    if (bundle == null) {
                        return;
                    }
                    Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRoutePrep.prepareForRouting (OrbitIO.getCurDb(),  \"%s\", %b, true);", (Object[])new Object[]{bundle.getKeyStr(), !RouteQueue.this.mIsFixed});
                }
            } else {
                Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRoutePrep.prepareForRouting (OrbitIO.getCurDb(), %b);", (Object[])new Object[]{!RouteQueue.this.mIsFixed});
            }
        }
    };
    protected ActionListener mIncreaseSeqAction = e -> {
        int[] rows = this.mRouteQueueTable.getSelectedRows();
        DbHistory history = OrbitIO.getCurDb().getHistory();
        try (DbHistory.DbTransaction trans = history.newDbTransaction("Move up in sequence");){
            boolean keep;
            int i;
            int size = rows.length;
            boolean nE = this.mDirection == RouteSides.N || this.mDirection == RouteSides.E;
            int n = i = nE ? size - 1 : 0;
            boolean bl = nE ? i >= 0 : (keep = i < size);
            while (keep) {
                int order;
                SchedConn nextBundleSchedConn;
                int row1 = rows[i];
                RouteQueueRow mRouteRow1 = this.mRouteQueueModel.getRow(row1);
                SchedConn routeSchedConn = mRouteRow1.fromto;
                Bundle bundle = Bundle.getBundle((Personality)mRouteRow1.per);
                SchedConn bundleSchedConn = bundle.getSchedConnOfA(routeSchedConn.getDPPA());
                if (bundleSchedConn == null) {
                    bundleSchedConn = bundle.schedConnUsingFreeHierPin(routeSchedConn.getDPPA());
                }
                if ((nextBundleSchedConn = bundle.getNth((order = Bundle.getOrder((SchedConn)bundleSchedConn)) + 1)) != null) {
                    SchedConn nextRouteSchedConn = this.getRouteSchedConnA(nextBundleSchedConn.getDPPA());
                    if (nextRouteSchedConn == null) {
                        nextRouteSchedConn = this.getRouteSchedConnA(nextBundleSchedConn.getDPPB());
                    }
                    if (nextRouteSchedConn != null) {
                        Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.doBundleMoveCommand(OrbitIO.getCurDb(), \"%s\", %d, %d);", (Object[])new Object[]{bundle.getKeyStr(), order, 1});
                        if (theRouteQueue != null) {
                            RouteQueue.theRouteQueue.mRouteQueueModel.buildTableFromSchedConn();
                        }
                    }
                }
                Bundle.bundleChanged((String)mRouteRow1.per.getName());
                int n2 = i = nE ? i - 1 : i + 1;
                keep = nE ? i >= 0 : i < size;
            }
            if (this.mDirection == RouteSides.N || this.mDirection == RouteSides.E) {
                RouteQueue.theRouteQueue.mRouteQueueTable.setRowSelectionInterval(rows[0] + 1, rows[size - 1] + 1);
            } else {
                RouteQueue.theRouteQueue.mRouteQueueTable.setRowSelectionInterval(rows[0] - 1, rows[size - 1] - 1);
            }
            theRouteQueue.updateUI();
        }
        OrbitIO.getApp().refreshCurrentView(false);
    };
    protected ActionListener mDecreaseSeqAction = e -> {
        int[] rows = this.mRouteQueueTable.getSelectedRows();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Move down in sequence");){
            boolean keep;
            int i;
            int size = rows.length;
            boolean nE = this.mDirection == RouteSides.N || this.mDirection == RouteSides.E;
            int n = i = nE ? 0 : size - 1;
            boolean bl = nE ? i < size : (keep = i >= 0);
            while (keep) {
                int order;
                SchedConn nextBundleSchedConn;
                int row1 = rows[i];
                RouteQueueRow mRouteRow1 = this.mRouteQueueModel.getRow(row1);
                SchedConn routeSchedConn = mRouteRow1.fromto;
                Bundle bundle = Bundle.getBundle((Personality)mRouteRow1.per);
                SchedConn bundleSchedConn = bundle.getSchedConnOfA(routeSchedConn.getDPPA());
                if (bundleSchedConn == null) {
                    bundleSchedConn = bundle.schedConnUsingFreeHierPin(routeSchedConn.getDPPA());
                }
                if ((nextBundleSchedConn = bundle.getNth((order = Bundle.getOrder((SchedConn)bundleSchedConn)) - 1)) != null) {
                    SchedConn nextRouteSchedConn = this.getRouteSchedConnA(nextBundleSchedConn.getDPPA());
                    if (nextRouteSchedConn == null) {
                        nextRouteSchedConn = this.getRouteSchedConnA(nextBundleSchedConn.getDPPB());
                    }
                    if (nextRouteSchedConn != null) {
                        Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.doBundleMoveCommand(OrbitIO.getCurDb(), \"%s\", %d, %d);", (Object[])new Object[]{bundle.getKeyStr(), order, -1});
                        if (theRouteQueue != null) {
                            RouteQueue.theRouteQueue.mRouteQueueModel.buildTableFromSchedConn();
                        }
                    }
                }
                Bundle.bundleChanged((String)mRouteRow1.per.getName());
                int n2 = i = nE ? i + 1 : i - 1;
                keep = nE ? i < size : i >= 0;
            }
            if (this.mDirection == RouteSides.N || this.mDirection == RouteSides.E) {
                RouteQueue.theRouteQueue.mRouteQueueTable.setRowSelectionInterval(rows[0] - 1, rows[size - 1] - 1);
            } else {
                RouteQueue.theRouteQueue.mRouteQueueTable.setRowSelectionInterval(rows[0] + 1, rows[size - 1] + 1);
            }
            theRouteQueue.updateUI();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener fatListener = e -> this.fatProcess();
    protected ActionListener skinnyListener = e -> this.skinnyProcess();
    protected ActionListener mAddSelectedPorts = e -> {
        if (this.mPinSelectMode == null) {
            return;
        }
        Db db = OrbitIO.getCurDb();
        Personality p1 = (Personality)db.getByKeyStr(Personality.class, mPerStrList.getFirst());
        DbHistory history = db.getHistory();
        try (DbHistory.DbTransaction trans = history.newDbTransaction("Add Selected " + mPersonality2Personalizer.get(p1).getColumnToName());){
            ArrayList<HierPort> selected = this.mPinSelectMode.getSelectedPorts();
            for (String s : mPerStrList) {
                int i = 0;
                Personality per = (Personality)db.getByKeyStr(Personality.class, s);
                for (HierPort port : selected) {
                    SchedConn aMatchingSchedConn = null;
                    for (SchedConn sc : per.getSchedConns()) {
                        boolean compareB;
                        boolean compareFrom = port.getDPort().getPinTemplate().getType() == mPersonality2Personalizer.get(per).getFromPinType();
                        boolean compareA = sc.getDevicePathA() != null && sc.getHierPortA() != null && port.getPath().containsRelative(sc.getDevicePathA()) && sc.getPortA().equals(port.getDPort());
                        boolean compareTo = port.getDPort().getPinTemplate().getType() == mPersonality2Personalizer.get(per).getToPinType();
                        boolean bl = compareB = sc.getDevicePathB() != null && sc.getHierPortB() != null && port.getPath().containsRelative(sc.getDevicePathB()) && port.getDPort().equals(sc.getPortB());
                        if ((!compareFrom || !compareA) && (!compareTo || !compareB)) continue;
                        aMatchingSchedConn = sc;
                        break;
                    }
                    if (aMatchingSchedConn == null) {
                        Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addOrRemovePort (\"%s\", \"%s\", \"%s\", null)", (Object[])new Object[]{((DevicePath)port.first).toString(), ((PortTemplate)port.second).getKeyStr(), per.getKeyStr()});
                    }
                    if (++i % 100 != 0) continue;
                    this.mAddSelectedTo.setText("adding " + i);
                    Dimension d = this.mAddSelectedTo.getSize();
                    this.mAddSelectedTo.paintImmediately(0, 0, d.width, d.height);
                }
                this.mAddSelectedTo.setText("adding " + i);
                Dimension d = this.mAddSelectedTo.getSize();
                this.mAddSelectedTo.paintImmediately(0, 0, d.width, d.height);
                this.mRouteQueueModel.buildTableFromSchedConn();
                this.mRouteQueueTable.updateUI();
                this.mAddSelectedTo.setText("Add Highlighted");
            }
        }
    };
    protected ActionListener mDeriveDefaultAssignments = e -> {
        for (String s : mPerStrList) {
            Cp.exec((String)("com.sigrity.orbit.ui.wb_route.RouteQueue.deriveDefaultAssignments (\"" + s + "\");"), (Object[])new Object[0]);
        }
    };
    protected ActionListener mHighligthSelectedAction = e -> {
        Design design = OrbitIO.getCurDesign();
        if (design == null) {
            return;
        }
        Personality p1 = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, mPerStrList.getFirst());
        Selection s = design.getCurSelection();
        LinkedList<HierPort> toBeAdded = new LinkedList<HierPort>();
        if (this.mPinSelectMode == null) {
            return;
        }
        ArrayList<HierPort> current = this.mPinSelectMode.getSelectedPorts();
        for (PinInstance pi : s.get(PinInstance.class)) {
            if (!pi.getType().equals((Object)mPersonality2Personalizer.get(p1).getToPinType()) && !pi.getType().equals((Object)mPersonality2Personalizer.get(p1).getFromPinType())) continue;
            for (DevicePath dpath : s.getSelectedPaths((DbObject)pi)) {
                PortTemplate pt;
                HierPort hierPort = new HierPort(dpath, pt = pi.getPinTemplate().getFirstPortTemplate());
                if (current.contains(hierPort)) continue;
                toBeAdded.add(hierPort);
            }
        }
        ALog.logInfo((String)("Adding " + toBeAdded.size() + " ports to the highlight set"));
        for (HierPort hp : toBeAdded) {
            this.mPinSelectMode.addHightlighed(hp);
        }
    };
    protected ActionListener mRemoveSelectedPorts = e -> {
        Personality p1 = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, mPerStrList.getFirst());
        DbHistory history = OrbitIO.getCurDb().getHistory();
        try (DbHistory.DbTransaction trans = history.newDbTransaction("Remove Selected " + mPersonality2Personalizer.get(p1).getColumnToName());){
            ArrayList<HierPort> selected = this.mPinSelectMode.getSelectedPorts();
            for (String s : mPerStrList) {
                Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
                int i = 0;
                for (HierPort port : selected) {
                    SchedConn aMatchingSchedConn = null;
                    for (SchedConn sc : per.getSchedConns()) {
                        boolean compareB;
                        boolean compareA = sc.getDevicePathA() != null && sc.getHierPortA() != null && port.getPath().containsRelative(sc.getDevicePathA()) && port.getDPort().equals(sc.getPortA());
                        boolean bl = compareB = sc.getDevicePathB() != null && sc.getHierPortB() != null && port.getPath().containsRelative(sc.getDevicePathB()) && port.getDPort().equals(sc.getPortB());
                        if (!compareA && !compareB) continue;
                        aMatchingSchedConn = sc;
                        break;
                    }
                    if (aMatchingSchedConn == null) continue;
                    Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addOrRemovePort (\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{((DevicePath)port.first).toString(), ((PortTemplate)port.second).getKeyStr(), per.getKeyStr(), aMatchingSchedConn.getKeyStr()});
                    if (++i % 10 != 0) continue;
                    this.mRemoveSelectedTo.setText("removing " + i);
                    Dimension d = this.mRemoveSelectedTo.getSize();
                    this.mRemoveSelectedTo.paintImmediately(0, 0, d.width, d.height);
                }
                this.mRemoveSelectedTo.setText("removing " + i);
                Dimension d = this.mRemoveSelectedTo.getSize();
                this.mRemoveSelectedTo.paintImmediately(0, 0, d.width, d.height);
                this.mRouteQueueModel.buildTableFromSchedConn();
                this.mRouteQueueTable.updateUI();
                this.mRemoveSelectedTo.setText("Remove Highlighted");
            }
        }
    };
    protected ActionListener mOptimizeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (String s : mPerStrList) {
                if (RouteQueue.this.mDissallowNetSwapping.isSelected()) {
                    Cp.exec((String)("com.sigrity.orbit.ui.wb_route.RouteQueue.optimizeWithoutSwap (\"" + s + "\");"), (Object[])new Object[0]);
                } else {
                    Cp.exec((String)("com.sigrity.orbit.ui.wb_route.RouteQueue.optimizeWithSwap (\"" + s + "\");"), (Object[])new Object[0]);
                }
                Cp.exec((String)("com.sigrity.orbit.ui.wb_route.RouteQueue.resetOrder(\"" + s + "\");"), (Object[])new Object[0]);
            }
            RouteQueue.this.mRouteQueueTable.selectAll();
            RouteQueue.this.mRouteQueueTable.updateUI();
        }
    };
    protected ActionListener mShowMeChanged = e -> this.showMeChanged();
    protected RegexFilterField.FilterListener mFilterListener = new RegexFilterField.FilterListener(){

        public void filter(Pattern pattern) {
            int i = 0;
            RouteQueue.this.mMatchedLabel.setText("");
            RouteQueue.this.mRouteQueueTable.clearSelection();
            if (pattern == null) {
                return;
            }
            int matches = 0;
            for (RouteQueueRow r : RouteQueue.this.mRouteQueueModel.routeQueueRows) {
                if (r.getNet() != null && pattern.matcher(r.getNet().getName()).matches()) {
                    RouteQueue.this.mRouteQueueTable.addRowSelectionInterval(i, i);
                    ++matches;
                }
                ++i;
            }
            RouteQueue.this.mRouteQueueTable.updateUI();
            RouteQueue.this.mMatchedLabel.setText("Matches: " + matches);
        }
    };
    protected ActionListener mShowMeActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int row : RouteQueue.this.mRouteQueueTable.getSelectedRows()) {
                RouteQueueRow rqr = RouteQueue.this.mRouteQueueModel.routeQueueRows.get(row);
                if (rqr.fromto.getHierPortA() != null && rqr.fromto.getHierPortA().second != null) {
                    HierPin dppFrom = new HierPin(rqr.fromto.getHierPortA().getPath(), rqr.fromto.getHierPortA().getPin());
                    ShowMeTheWay.addHierPin(RouteQueue.fullPathHierPin(dppFrom));
                }
                if (rqr.fromto.getHierPortB() == null || rqr.fromto.getHierPortB().second == null) continue;
                HierPin dppTo = new HierPin(rqr.fromto.getHierPortB().getPath(), rqr.fromto.getHierPortB().getPin());
                ShowMeTheWay.addHierPin(RouteQueue.fullPathHierPin(dppTo));
            }
        }
    };
    protected ActionListener mZoomToAction = e -> this.zoomToRouteRegion();
    protected ActionListener applyToInterfaceListener = e -> {
        SchedConn sc = this.mRouteQueueModel.routeQueueRows.get((int)this.mCurRow).fromto;
        Personality per = this.mRouteQueueModel.routeQueueRows.get((int)this.mCurRow).per;
        RuleSet rs = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin());
        if (rs != null && RouteQueue.isRuleSetApplicable(per, rs)) {
            for (SchedConn scto : per.getSchedConns()) {
                if (scto.getHierPortA() == null || !scto.getHierPortA().complete()) continue;
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addToRuleSet (\"%s\", \"%s\");", (Object[])new Object[]{rs.getKeyStr(), scto.getHierPortA().getPin().getKeyStr()});
            }
        }
        this.mRouteQueueTable.updateUI();
    };
    protected Action applyToNetAction = new AbstractAction("Apply This Rule For This Net"){

        @Override
        public void actionPerformed(ActionEvent e) {
            SchedConn sc = RouteQueue.this.mRouteQueueModel.routeQueueRows.get((int)RouteQueue.this.mCurRow).fromto;
            Personality per = RouteQueue.this.mRouteQueueModel.routeQueueRows.get((int)RouteQueue.this.mCurRow).per;
            RuleSet rs = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin());
            if (rs != null && RouteQueue.isRuleSetApplicable(per, rs)) {
                Net n = sc.getHierPortA().getSubstrateNet();
                for (SchedConn scto : per.getSchedConns()) {
                    HierPort fromPin = scto.getHierPortA();
                    HierPort toPin = scto.getHierPortB();
                    Net netTo = null;
                    if (fromPin.complete()) {
                        netTo = fromPin.getSubstrateNet();
                    } else if (toPin.complete()) {
                        netTo = toPin.getSubstrateNet();
                    }
                    if (netTo == null || !netTo.equals(n) || !scto.getHierPortA().complete()) continue;
                    Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addToRuleSet (\"%s\", \"%s\");", (Object[])new Object[]{rs.getKeyStr(), scto.getHierPortA().getPin().getKeyStr()});
                }
            }
            RouteQueue.this.mRouteQueueTable.updateUI();
        }
    };
    protected Action createRuleAction = new AbstractAction("Create New Rule"){

        @Override
        public void actionPerformed(ActionEvent e) {
            SchedConn sc = RouteQueue.this.mRouteQueueModel.routeQueueRows.get((int)RouteQueue.this.mCurRow).fromto;
            Personality per = RouteQueue.this.mRouteQueueModel.routeQueueRows.get((int)RouteQueue.this.mCurRow).per;
            RouterRuleSetDlg rsd = mPersonality2Personalizer.get(per).createRule(per);
            if (rsd.getRuleSet() != null) {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addToRuleSet (\"%s\", \"%s\");", (Object[])new Object[]{rsd.getRuleSet().getKeyStr(), sc.getHierPortA().getPin().getKeyStr()});
            }
            RouteQueue.this.mRouteQueueTable.updateUI();
        }
    };
    protected Action editRuleAction = new AbstractAction("Edit Rule"){

        @Override
        public void actionPerformed(ActionEvent e) {
            SchedConn sc = RouteQueue.this.mRouteQueueModel.routeQueueRows.get((int)RouteQueue.this.mCurRow).fromto;
            Personality per = RouteQueue.this.mRouteQueueModel.routeQueueRows.get((int)RouteQueue.this.mCurRow).per;
            RuleSet rs = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin());
            if (rs != null && RouteQueue.isRuleSetApplicable(per, rs)) {
                mPersonality2Personalizer.get(per).editRule(per, rs);
            }
            RouteQueue.this.mRouteQueueTable.updateUI();
        }
    };
    protected ActionListener mSelectNewToPinSame = e -> {
        SchedConn sc = this.mRouteQueueModel.routeQueueRows.get((int)this.mCurRow).fromto;
        Personality per = this.mRouteQueueModel.routeQueueRows.get((int)this.mCurRow).per;
        RouteQueue.doNewToPinSelection(per, sc, true);
        this.mRouteQueueTable.updateUI();
    };
    protected ActionListener mSelectNewToPinAny = e -> {
        SchedConn sc = this.mRouteQueueModel.routeQueueRows.get((int)this.mCurRow).fromto;
        Personality per = this.mRouteQueueModel.routeQueueRows.get((int)this.mCurRow).per;
        RouteQueue.doNewToPinSelection(per, sc, false);
    };
    protected ActionListener mMoveToTop = e -> {
        for (int row : this.mRouteQueueTable.getSelectedRows()) {
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.userMoveToTop(%d)", (Object[])new Object[]{row});
        }
        this.mRouteQueueTable.updateUI();
    };
    protected ActionListener mMoveToBottom = e -> {
        for (int row : this.mRouteQueueTable.getSelectedRows()) {
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.userMoveToBottom(%d)", (Object[])new Object[]{row});
        }
        this.mRouteQueueTable.updateUI();
    };
    protected ActionListener toggleStatus = e -> {
        for (int row : this.mRouteQueueTable.getSelectedRows()) {
            SchedConn sc;
            RouteQueueRow rqr = this.mRouteQueueModel.getRow(row);
            RouteQueue.setIgnore(sc, !RouteQueue.getIgnore(sc = rqr.fromto));
        }
        this.mRouteQueueTable.updateUI();
    };
    protected ActionListener removeAction = e -> {
        LinkedList<SchedConn> toBeRemoved = new LinkedList<SchedConn>();
        for (int row : this.mRouteQueueTable.getSelectedRows()) {
            RouteQueueRow rqr = this.mRouteQueueModel.getRow(row);
            SchedConn sc = rqr.fromto;
            toBeRemoved.add(sc);
            if (sc.getDPPA() == null) continue;
            PinInstance pi = sc.getDPPA().getPin();
            pi.removeFromRouteDefinition();
        }
        Object object = toBeRemoved.iterator();
        while (object.hasNext()) {
            SchedConn sc = (SchedConn)object.next();
            sc.deleteFromDb();
        }
        this.mRouteQueueModel.buildTableFromSchedConn();
        this.mRouteQueueTable.updateUI();
    };

    public static void addToRoutePersonalizerHash(Personality p, RoutePersonalizer rp) {
        if (p != null && rp != null) {
            mPersonality2Personalizer.put(p, rp);
        }
    }

    public static void clearRoutePersonalizerHash() {
        mPersonality2Personalizer.clear();
    }

    public static void registerRouter(String name, String cmd) {
        mPluginRouter.put(name, cmd);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mHL != null) {
            return;
        }
        DbHistory h = OrbitIO.getCurDb().getHistory();
        this.mHL = new HistoryListener();
        h.addListener((DbHistory.Listener)this.mHL);
        this.mInteractiveEditModeListener = new InteractiveEditModeListener();
        this.mBundleChangeListener = new ABundleChangedListener();
        Bundle.addBundleChangedListener((Bundle.Listener)this.mBundleChangeListener);
        this.mRuleSetListener = new RuleSetListener();
        DbClass clazz = OrbitIO.getCurDb().getDbClass("RuleSet");
        clazz.addObjectListener((DbClass.DbObjectListener)this.mRuleSetListener, new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.REMOVING});
    }

    protected void validateMissingRuleSet(RuleSet rs) {
    }

    @Override
    public void removeNotify() {
        DbHistory h;
        Db db;
        super.removeNotify();
        DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
        if (v2 != null) {
            v2.removeOverlay(this.rqo);
        }
        if (this.mPinSelectMode != null) {
            this.mPinSelectMode.iAmUninstallingMySelf();
        }
        if ((db = OrbitIO.getCurDb()) != null && (h = db.getHistory()) != null) {
            h.removeListener((DbHistory.Listener)this.mHL);
        }
        if (this.mBundleChangeListener != null) {
            Bundle.remBundleChangedListener((Bundle.Listener)this.mBundleChangeListener);
            this.mBundleChangeListener = null;
        }
        if (db != null && this.mRuleSetListener != null) {
            DbClass clazz = db.getDbClass(RuleSet.class);
            clazz.removeObjectListener((DbClass.DbObjectListener)this.mRuleSetListener, new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.REMOVING});
            this.mRuleSetListener = null;
        }
        theRouteQueue = null;
        this.rqo = null;
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public RouteQueue(List<String> pKeyStrList, boolean isFixedSide) {
        GridBagConstraints gbc;
        mPerStrList = new LinkedList<String>(pKeyStrList);
        this.mIsFixed = isFixedSide;
        final Personality p1 = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, mPerStrList.getFirst());
        boolean bl = this.mSimple = !p1.getType().equals((Object)Personality.Type.RDL);
        if (this.mSimple) {
            this.displayOrder = DisplayOrder.SeqOrder;
        }
        if (!showSubstrateNetName) {
            this.COLNET = "Topmost " + this.COLNET;
        }
        for (String s : pKeyStrList) {
            Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
            String fromName = mPersonality2Personalizer.get(per).getColumnFromName();
            String string = mPersonality2Personalizer.get(per).getColumnToName();
            if (!this.COLFROMPAD.contains(fromName)) {
                this.COLFROMPAD = this.COLFROMPAD + "/" + fromName;
            }
            if (this.COLTOPAD.contains(string)) continue;
            this.COLTOPAD = this.COLTOPAD + "/" + string;
        }
        if (this.COLFROMPAD.startsWith("/")) {
            this.COLFROMPAD = this.COLFROMPAD.replaceFirst("/", "");
        }
        if (this.COLTOPAD.startsWith("/")) {
            this.COLTOPAD = this.COLTOPAD.replaceFirst("/", "");
        }
        this.defineColumns();
        this.mRouteQueueModel = new RouteQueueModel(pKeyStrList);
        GridBagManager l = new GridBagManager((Container)this);
        GridBagConstraints gridFillCS = new GridBagConstraints();
        gridFillCS.fill = 2;
        gridFillCS.insets = new Insets(2, 4, 2, 4);
        this.mShowMeMode = new JCheckBox(SELECTMODE);
        this.stdFont = this.mShowMeMode.getFont();
        if (!this.mSimple) {
            String label = mPersonality2Personalizer.get(p1).getFromPinTypeName() + "/" + mPersonality2Personalizer.get(p1).getToPinTypeName() + " Highlight";
            l.pushFillX(label);
            l.add((Component)this.mShowMeMode);
            PinTemplate.Type[] pinTypes = new PinTemplate.Type[]{mPersonality2Personalizer.get(p1).getToPinType(), mPersonality2Personalizer.get(p1).getFromPinType(), null};
            this.mSelectPinFilter = (JComboBox)l.add(new JComboBox<PinTemplate.Type>(pinTypes));
            this.mSelectPinFilter.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int idx, boolean isSelected, boolean hasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, idx, isSelected, hasFocus);
                    if (value == null) {
                        this.setText("Both");
                        this.setIcon(null);
                    } else if (value == mPersonality2Personalizer.get(p1).getToPinType()) {
                        this.setText(mPersonality2Personalizer.get(p1).getToPinTypeName());
                        this.setIcon(mPersonality2Personalizer.get(p1).toPadIcon());
                    } else if (value == mPersonality2Personalizer.get(p1).getFromPinType()) {
                        this.setText(mPersonality2Personalizer.get(p1).getFromPinTypeName());
                        this.setIcon(mPersonality2Personalizer.get(p1).fromPadIcon());
                    }
                    return this;
                }
            });
            this.mSelectPinFilter.addActionListener(this.mShowMeChanged);
            this.mShowMeMode.addActionListener(this.mShowMeChanged);
            l.newline();
            this.mAddSelectedTo = new JButton("Add Highlighted");
            l.add((Component)this.mAddSelectedTo, gridFillCS);
            this.mAddSelectedTo.addActionListener(this.mAddSelectedPorts);
            this.mRemoveSelectedTo = new JButton("Remove Highlighted");
            l.add((Component)this.mRemoveSelectedTo, gridFillCS);
            this.mRemoveSelectedTo.addActionListener(this.mRemoveSelectedPorts);
            l.newline();
            this.mHighlightSelected = new JButton("Highlight Selected " + mPersonality2Personalizer.get(p1).getFromPinTypeName() + " or " + mPersonality2Personalizer.get(p1).getToPinTypeName());
            l.add((Component)this.mHighlightSelected, gridFillCS, 2);
            this.mHighlightSelected.addActionListener(this.mHighligthSelectedAction);
            l.addFillX();
            l.popNl();
            l.pushFillX("Assign " + mPersonality2Personalizer.get(p1).getColumnFromName() + " to " + mPersonality2Personalizer.get(p1).getColumnToName());
            l.newline();
            this.mOptimize = new JButton("Optimize " + mPersonality2Personalizer.get(p1).getColumnToName() + " Assignments");
            l.add((Component)this.mOptimize);
            this.mOptimize.addActionListener(this.mOptimizeAction);
            l.newline();
            this.mDissallowNetSwapping = new JCheckBox("Don't Allow Changing Nets On " + mPersonality2Personalizer.get(p1).getColumnToName());
            this.mDissallowNetSwapping.setToolTipText("Useful in a fixed netlist scenario, for multiple power " + mPersonality2Personalizer.get(p1).getColumnToName().toLowerCase());
            l.add((Component)this.mDissallowNetSwapping);
            l.addFillX();
            l.popNl();
        }
        l.pushFillX("Route");
        this.mRoute = new JButton("Feasibility Route");
        l.add((Component)this.mRoute, (GridBagConstraints)GridBagManager.FILLX);
        this.mRoute.addActionListener(this.mReRouteAction);
        JButton mUnRoute = new JButton(this.mUnRouteAction);
        l.add((Component)mUnRoute, (GridBagConstraints)GridBagManager.FILLX);
        if (!this.mSimple) {
            JButton mResort = new JButton(this.mResortAction);
            l.add((Component)mResort, (GridBagConstraints)GridBagManager.LEFT);
        }
        l.addFillX();
        if (!mPluginRouter.isEmpty()) {
            l.newline();
            for (Map.Entry entry : mPluginRouter.entrySet()) {
                l.add((Component)new JButton(new ActionPluginRouter((String)entry.getKey(), (String)entry.getValue())), (GridBagConstraints)GridBagManager.FILLX);
            }
        }
        l.pop();
        l.newline();
        l.pushFillX("Constraints");
        JButton editConstraints = new JButton(this.mEditConstraints);
        l.add((Component)editConstraints, (GridBagConstraints)GridBagManager.LEFT);
        JButton jButton = new JButton(this.mCreateRule);
        l.add((Component)jButton, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.pop();
        l.newline();
        if (!this.mSimple) {
            l.pushFillX("Options");
            this.mRemoveViasWhenDeletingWires = new JCheckBox("Remove Vias when deleting wires");
            this.mRemoveViasWhenDeletingWires.setToolTipText("If selected, associated vias will be removed when deleting wires");
            gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.weightx = 0.1;
            l.add((Component)this.mRemoveViasWhenDeletingWires, gbc, 3);
            l.pop();
            l.newline();
        }
        if (!this.mSimple) {
            l.pushFillX("Operate - Schedule Connection");
            this.mSwapFrom = new JButton("Swap " + mPersonality2Personalizer.get(p1).getColumnFromName());
            l.add((Component)this.mSwapFrom);
            this.mSwapFrom.addActionListener(this.mSwapIOAction);
            this.mSwapTo = new JButton("Swap " + mPersonality2Personalizer.get(p1).getColumnToName());
            l.add((Component)this.mSwapTo);
            this.mSwapTo.addActionListener(this.mSwapToPinAction);
            l.add("Find Net:");
            this.mFilterField = (RegexFilterField)l.add((Component)new RegexFilterField(this.mFilterListener), (GridBagConstraints)GridBagManager.FILLX.noInsets());
            this.mMatchedLabel = new JLabel("");
            l.add((Component)this.mMatchedLabel);
            l.pop();
            l.newline();
        } else {
            l.pushFillX("Operate - Schedule Connection");
            gbc = (GridBagConstraints)gridFillCS.clone();
            gbc.anchor = 17;
            l.add((Component)new JLabel("Breakout width:"), gbc);
            this.mFat = new JButton("+");
            this.mSkinny = new JButton("-");
            this.mFat.addActionListener(this.fatListener);
            this.mSkinny.addActionListener(this.skinnyListener);
            UIUtil.makeSmallButton((JButton)this.mFat);
            UIUtil.makeSmallButton((JButton)this.mSkinny);
            l.add((Component)this.mFat, gridFillCS);
            l.add((Component)this.mSkinny, gridFillCS);
            l.newline();
            this.mSeqLtButton = new JButton(ICON_ARROW_LT);
            this.mSeqUpButton = new JButton(ICON_ARROW_UP);
            this.mSeqRtButton = new JButton(ICON_ARROW_RT);
            this.mSeqDnButton = new JButton(ICON_ARROW_DN);
            UIUtil.makeSmallButton((JButton)this.mSeqLtButton);
            UIUtil.makeSmallButton((JButton)this.mSeqUpButton);
            UIUtil.makeSmallButton((JButton)this.mSeqRtButton);
            UIUtil.makeSmallButton((JButton)this.mSeqDnButton);
            l.add((Component)new JLabel("Move connections:"), gbc);
            l.add((Component)this.mSeqLtButton, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mSeqUpButton, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mSeqRtButton, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mSeqDnButton, (GridBagConstraints)GridBagManager.LEFT);
            l.addFillX();
            l.newline();
            l.popNl();
            l.pushNoFill();
            String warpString = isFixedSide ? "Jump to Free Side" : "Jump to Fixed Side";
            this.mWarp = new JButton(warpString);
            l.add((Component)this.mWarp);
            this.mWarp.addActionListener(this.mWarpAction);
            this.mZoomToAllCB = new JCheckBox("Zoom To", mZoomToAllStatus);
            this.mZoomToAllCB.addActionListener(e -> {
                if (this.mZoomToAllCB.isSelected()) {
                    this.zoomToRouteRegion();
                }
                mZoomToAllStatus = this.mZoomToAllCB.isSelected();
            });
            l.add((Component)this.mZoomToAllCB);
            l.newline();
            l.popNl();
        }
        this.mRouteQueueTable = new JTable();
        JTableHeader jth = this.mRouteQueueTable.getTableHeader();
        this.tcr = jth.getDefaultRenderer();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int columnWidth = metrics.charWidth('m');
        int desireWidth = 16;
        int desiredHeight = 200;
        this.mRouteQueueTable.setPreferredScrollableViewportSize(new Dimension(desireWidth * columnWidth, desiredHeight));
        this.mRouteQueueTable.setFillsViewportHeight(true);
        this.mRouteQueueTable.setRowSelectionAllowed(false);
        this.mRouteQueueTable.setAutoResizeMode(4);
        this.mRouteQueueTable.setModel(this.mRouteQueueModel);
        this.mRouteQueueTable.addMouseListener(new TableButtonMouseListener(this.mRouteQueueTable));
        HeaderPopupListener headerListener = new HeaderPopupListener();
        this.mRouteQueueTable.getTableHeader().addMouseListener(headerListener);
        this.mRouteQueueTable.setSelectionMode(2);
        this.mRouteQueueTable.getSelectionModel().addListSelectionListener(new RouteQueueSelectionListener());
        ColumnHeaderRender chr = new ColumnHeaderRender();
        TableColumn col = this.mRouteQueueTable.getColumnModel().getColumn(this.routeStatusColumn);
        col.setPreferredWidth(2 * columnWidth);
        col.setMaxWidth(2 * columnWidth);
        col.setIdentifier(this.routeStatusColumn);
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mRouteQueueTable.getColumnModel().getColumn(this.ignoreRouteColumn);
        col.setPreferredWidth(2 * columnWidth);
        col.setMaxWidth(2 * columnWidth);
        col.setIdentifier(this.ignoreRouteColumn);
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mRouteQueueTable.getColumnModel().getColumn(this.netNameColumn);
        col.setPreferredWidth(20 * columnWidth);
        col.setIdentifier(this.netNameColumn);
        col.setHeaderRenderer(chr);
        col = this.mRouteQueueTable.getColumnModel().getColumn(this.fromPadNameColumn);
        col.setPreferredWidth(8 * columnWidth);
        col.setIdentifier(this.fromPadNameColumn);
        col.setHeaderRenderer(chr);
        if (!this.mSimple) {
            col = this.mRouteQueueTable.getColumnModel().getColumn(this.toPadNameColumn);
            col.setPreferredWidth(8 * columnWidth);
            col.setIdentifier(this.toPadNameColumn);
            col.setHeaderRenderer(chr);
            col = this.mRouteQueueTable.getColumnModel().getColumn(this.lengthNameColumn);
            col.setIdentifier(this.lengthNameColumn);
            col.setHeaderRenderer(chr);
        }
        col = this.mRouteQueueTable.getColumnModel().getColumn(this.ruleNameColumn);
        col.setIdentifier(this.ruleNameColumn);
        col.setHeaderRenderer(chr);
        col = this.mRouteQueueTable.getColumnModel().getColumn(this.hintThreatenColumn);
        col.setIdentifier(this.hintThreatenColumn);
        col.setHeaderRenderer(chr);
        this.mRouteQueueTable.setDefaultRenderer(Object.class, new RouteQueueCellRenderer());
        this.mRouteQueueTable.setRowSelectionAllowed(true);
        this.mRouteQueueTable.setColumnSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.mRouteQueueTable);
        l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        this.mStatus = new JLabel(COLROUTESTATUS);
        this.mStatus.setFont(this.stdFont.deriveFont((float)this.stdFont.getSize() - 4.0f));
        l.add((Component)this.mStatus);
        theRouteQueue = this;
        Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.buildTableFromSchedConnForRouteQ();", (Object[])new Object[0]);
        this.updateUI();
        this.setMinimumSize(this.getPreferredSize());
        DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
        this.rqo = new RouteQueueOverlay();
        v2.addOverlay(this.rqo);
        this.updateSelectionChangedStatus();
        this.updateSchedList();
        this.updateStatus();
        this.createKeyBindings();
        this.mOptimizerListener = new RouterConnectionOptimizer.LoadListener(){

            @Override
            public void stats(int percent, boolean done, String data) {
                if (RouteQueue.this.mOptimize == null) {
                    return;
                }
                if (done) {
                    RouteQueue.this.mOptimize.setFont(RouteQueue.this.stdFont.deriveFont((float)RouteQueue.this.stdFont.getSize()));
                    RouteQueue.this.mOptimize.setText("Create Connections");
                } else {
                    RouteQueue.this.mOptimize.setFont(RouteQueue.this.stdFont.deriveFont((float)RouteQueue.this.stdFont.getSize() - 4.0f));
                    RouteQueue.this.mOptimize.setText(data);
                }
                Dimension d = RouteQueue.this.mOptimize.getSize();
                RouteQueue.this.mOptimize.paintImmediately(0, 0, d.width, d.height);
            }
        };
        RouterConnectionOptimizer.addLoadListener(this.mOptimizerListener);
        this.mRouteProgressListener = new SingleLayerRouter.LoadListener(){

            @Override
            public void stats(int percent, boolean done, String data) {
                if (done) {
                    RouteQueue.this.mRoute.setText("Feasibility Re-route");
                } else {
                    RouteQueue.this.mRoute.setText(percent + "% Complete ");
                }
                Dimension d = RouteQueue.this.mRoute.getSize();
                RouteQueue.this.mRoute.paintImmediately(0, 0, d.width, d.height);
            }
        };
        SingleLayerRouter.addLoadListener(this.mRouteProgressListener);
        if (mZoomToAllStatus) {
            this.zoomToRouteRegion();
        }
    }

    protected void defineColumns() {
        int INF = 1000;
        if (this.mSimple) {
            this.columnNames.add(COLROUTESTATUS);
            this.columnNames.add(COLIGNORE);
            this.columnNames.add(this.COLNET);
            this.columnNames.add(this.COLFROMPAD);
            this.toPadNameColumn = 1000;
            this.lengthNameColumn = 1000;
            this.columnNames.add(COLHINT);
            this.hintThreatenColumn = 4;
            this.columnNames.add(COLRULNAME);
            this.ruleNameColumn = 5;
        } else {
            this.columnNames.add(COLROUTESTATUS);
            this.columnNames.add(COLIGNORE);
            this.columnNames.add(this.COLNET);
            this.columnNames.add(this.COLFROMPAD);
            this.columnNames.add(this.COLTOPAD);
            this.columnNames.add(COLLENGTH);
            this.columnNames.add(COLHINT);
            this.columnNames.add(COLRULNAME);
        }
    }

    public static void commandChangeExpansion(double value, String bundleKey, String personalityKey) {
        boolean isFixed;
        Db db = OrbitIO.getCurDb();
        Bundle bundle = (Bundle)db.getByKeyStr(Bundle.class, bundleKey);
        Personality personality = (Personality)db.getByKeyStr(Personality.class, personalityKey);
        WbFcFeasibilityUI.unRouteRDLPersonality(personalityKey, false);
        if (RouteQueue.isFixedSide(bundle, personality)) {
            bundle.setFixedRakePtsList(null);
            bundle.setFixedExpansion(value);
            isFixed = true;
        } else {
            bundle.setFreeRakePtsList(null);
            bundle.setFreeExpansion(value);
            isFixed = false;
        }
        BundleRoutePrep.updateBundleRouteContacts(bundle, isFixed, personality);
    }

    protected static boolean isFixedSide(Bundle b, Personality p) {
        if (b.getRouteGroup() == null) {
            return false;
        }
        return b.getRouteGroup().equals(p);
    }

    protected void createKeyBindings() {
        this.getActionMap().put("rvOn", this.rvOn);
        this.bindKey("W", "rvOn");
        this.getActionMap().put("rvOff", this.rvOff);
        this.bindKey("shift W", "rvOff");
        this.getActionMap().put("fatten", this.fatAction);
        this.bindKey("K", "fatten");
        this.getActionMap().put("skinny", this.skinnyAction);
        this.bindKey("M", "skinny");
        this.globalBind("toZoom", "T", this.toZoom);
        this.globalBind("fromZoom", "F", this.fromZoom);
        this.globalBind("allZoom", "A", this.allZoom);
    }

    protected void globalBind(Object key, String keyStroke, Action action) {
        this.getActionMap().put(key, action);
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(keyStroke), key);
        DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
        v2.getActionMap().put(key, action);
        inputMap = v2.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(keyStroke), key);
    }

    protected APoint2D worldLocOnABundle(Bundle b, APoint2D p) {
        DevicePath dp = b.getTemplate().getAnInstance().getADevicePath();
        dp = dp.getRelativePath(b.getTemplate());
        AffineTransform t = dp.getTransform();
        return p.transform(t);
    }

    public void zoomTo(Boolean type) {
        ARect rc1 = null;
        ARect rc2 = null;
        if (type == null || type.booleanValue()) {
            rc1 = this.getToRect();
        }
        if (type == null || type.booleanValue()) {
            rc2 = this.getFromRect();
        }
        if (rc1 != null) {
            rc1.expand(rc2);
        } else if (rc2 != null) {
            rc2.expand(rc1);
            rc1 = rc2;
        }
        if (rc1 == null) {
            return;
        }
        DesignCanvas2D dv2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
        if (rc1.width() == 0L && rc1.height() == 0L) {
            long min = Design.micronToInternal((Db)OrbitIO.getCurDb(), (double)1.0);
            rc1.grow(min);
        }
        if (type != null) {
            rc1.expand(1.5);
        }
        dv2d.zoomTo(rc1);
    }

    protected ARect getToRect() {
        ARect r = null;
        if (!this.mSimple) {
            return null;
        }
        for (String s : mPerStrList) {
            Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
            Bundle bundle = Bundle.getBundle((Personality)per);
            if (bundle == null) continue;
            for (SchedConn sc : bundle.getSchedConn()) {
                if (sc.getDPPB() == null) continue;
                APoint2D to = this.worldLocOnABundle(bundle, sc.getDPPB().getWorldLoc());
                if (r == null) {
                    r = new ARect(to, to);
                    continue;
                }
                r.expand(to);
            }
        }
        return r;
    }

    protected ARect getFromRect() {
        ARect r = null;
        if (!this.mSimple) {
            return null;
        }
        for (String s : mPerStrList) {
            Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
            Bundle bundle = Bundle.getBundle((Personality)per);
            if (bundle == null) continue;
            for (SchedConn sc : bundle.getSchedConn()) {
                if (sc.getDPPA() == null) continue;
                APoint2D to = this.worldLocOnABundle(bundle, sc.getDPPA().getWorldLoc());
                if (r == null) {
                    r = new ARect(to, to);
                    continue;
                }
                r.expand(to);
            }
        }
        return r;
    }

    public void bindKey(String key, String action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
        if (keyStroke == null) {
            ALog.logWarn((String)"Invalid key stroke '%s' specified while attempting to bind key stroketo action '%s'.", (Object[])new Object[]{key, action});
            return;
        }
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(keyStroke, action);
    }

    protected void updateSelectionChangedStatus() {
        this.updateCanSwapToPins();
        this.updateCanSwapFromPins();
        this.updateSelectedToPins();
    }

    protected int getCol(int x) {
        TableColumnModel columnModel = this.mRouteQueueTable.getColumnModel();
        return columnModel.getColumnIndexAtX(x);
    }

    protected void setFixAll(boolean fix) {
        int rows = RouteQueue.theRouteQueue.mRouteQueueModel.getRowCount();
        DbHistory history = OrbitIO.getCurDb().getHistory();
        try (DbHistory.DbTransaction trans = history.newDbTransaction(FIXALL);){
            for (int row = 0; row < rows; ++row) {
                RouteQueueRow rqr = RouteQueue.theRouteQueue.mRouteQueueModel.getRow(row);
                SchedConn sc = rqr.fromto;
                RouteQueue.setIgnore(sc, fix);
            }
        }
        this.mRouteQueueTable.updateUI();
    }

    protected void rebuildPrimSecondList() {
        HashSet<SchedConn> primList = new HashSet<SchedConn>();
        HashSet<SchedConn> secondList = new HashSet<SchedConn>();
        Db db = OrbitIO.getCurDb();
        for (String s : mPerStrList) {
            Personality per = (Personality)db.getByKeyStr(Personality.class, s);
            Bundle bundle = Bundle.getBundle((Personality)per);
            if (bundle == null) continue;
            Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRoutePrep.updateBundleRouteContacts (\"%s\", %b, \"%s\");", (Object[])new Object[]{bundle.getKeyStr(), RouteQueue.isFixedSide(bundle, per), s});
        }
        for (Object row : (Object)this.mRouteQueueTable.getSelectedRows()) {
            RouteQueueRow rqr = this.mRouteQueueModel.getRow((int)row);
            primList.add(rqr.fromto);
        }
        HashMap<Integer, Net> rowToNet = new HashMap<Integer, Net>();
        for (int row = 0; row < this.mRouteQueueModel.getRowCount(); ++row) {
            RouteQueueRow rqr = this.mRouteQueueModel.getRow(row);
            if (rqr.fromto.getHierPortA() == null || rqr.fromto.getHierPortA().getDPort() == null) continue;
            rowToNet.put(row, rqr.fromto.getHierPortA().getSubstrateNet());
        }
        for (SchedConn sc : primList) {
            if (sc.getHierPortA() == null || sc.getHierPortA().getDbObject() == null) continue;
            Net n = sc.getHierPortA().getSubstrateNet();
            for (int row = 0; row < this.mRouteQueueModel.getRowCount(); ++row) {
                RouteQueueRow rqr = this.mRouteQueueModel.getRow(row);
                if (!n.equals(rowToNet.get(row))) continue;
                secondList.add(rqr.fromto);
            }
        }
        if (this.mSimple) {
            HashSet<Rake> rakes = new HashSet<Rake>();
            for (String s : mPerStrList) {
                Personality per = (Personality)db.getByKeyStr(Personality.class, s);
                Bundle bundle = Bundle.getBundle((Personality)per);
                ArrayList points = bundle.getRakePattern(RouteQueue.isFixedSide(bundle, per));
                for (SchedConn routeSchedConn : primList) {
                    SchedConn bundleSchedConn;
                    HierPort hp = null;
                    if (RouteQueue.isFixedSide(bundle, per)) {
                        bundleSchedConn = bundle.getSchedConnOfA(routeSchedConn.getDPPA());
                        if (bundleSchedConn != null) {
                            hp = bundleSchedConn.getHierPortA();
                        }
                    } else {
                        bundleSchedConn = bundle.schedConnUsingFreeHierPin(routeSchedConn.getDPPA());
                        if (bundleSchedConn != null) {
                            hp = bundleSchedConn.getHierPortB();
                        }
                    }
                    if (bundleSchedConn == null) continue;
                    int order = Bundle.getOrder((SchedConn)bundleSchedConn);
                    rakes.add(new Rake((APoint2D)points.get(order), hp));
                }
            }
            this.rqo.setRakes(rakes);
        }
        this.rqo.setSchedConn(primList, secondList);
    }

    protected static LinkedList<PinInstance> getExternalPins(DevicePath path) {
        LinkedList<PinInstance> returnList = new LinkedList<PinInstance>();
        PinTemplate.Type pinType = null;
        if (path.getDeviceTemplate().getType().equals((Object)DeviceTemplate.Type.DIE)) {
            pinType = PinTemplate.Type.BUMPPAD;
        } else if (path.getDeviceTemplate().getType().equals((Object)DeviceTemplate.Type.PACKAGE)) {
            pinType = PinTemplate.Type.BALLPAD;
        } else {
            return returnList;
        }
        Substrate originalS = path.getSubstrate();
        for (DevicePath desc : path.getDescendants()) {
            if (desc.getSubstrate() != originalS) continue;
            for (PinInstance pi : desc.getLast().getPins()) {
                if (!pi.getType().equals((Object)pinType)) continue;
                returnList.add(pi);
            }
        }
        return returnList;
    }

    public static int countMissingContact(DevicePath fromPath, SchedConn firstSc) {
        Substrate toS;
        int unConnected = 0;
        Substrate fromS = firstSc.getDPPA().getSubstrate();
        if (fromS != (toS = firstSc.getDPPB().getSubstrate())) {
            LinkedList<PinInstance> pins = RouteQueue.getExternalPins(((DevicePath)firstSc.getDPPA().first).pathToSubstrate());
            for (PinInstance pin : pins) {
                if (pin.getFirstExternallyConnected() != null) continue;
                ++unConnected;
            }
        }
        return unConnected;
    }

    public static boolean showContactManagementPopup(DevicePath fromPath, int unConnected) {
        Object[] allOpts = new String[]{"Cancel", "Manage Contacts", "Route"};
        String msg = String.format("<html>There are " + unConnected + " pins that do not have contacts, do you want to continue routing? <br>If not use Manage My Mounting on the Device Hierarchy Pane or Manage Contacts below</html>", new Object[0]);
        JOptionPane op = new JOptionPane(msg, 3);
        op.setOptions(allOpts);
        JDialog dlg = op.createDialog(OrbitIO.getMainWindow(), "Missing Contacts");
        dlg.setVisible(true);
        String selOpt = (String)op.getValue();
        if (selOpt.equals(allOpts[0])) {
            return false;
        }
        if (selOpt.equals(allOpts[1])) {
            if (fromPath != null) {
                MountingMgmtDlg.show(fromPath);
            }
            return false;
        }
        return true;
    }

    protected boolean everythingContacted() {
        Bundle bundle;
        Personality per;
        boolean bypass = true;
        int unConnected = 0;
        DevicePath fromPath = null;
        Db db = OrbitIO.getCurDb();
        for (String s : mPerStrList) {
            per = (Personality)db.getByKeyStr(Personality.class, s);
            if (per == null || (bundle = Bundle.getBundle((Personality)per)) == null || bundle.getContacted()) continue;
            bypass = false;
            break;
        }
        if (bypass) {
            return true;
        }
        if (this.mRouteQueueModel.getRowCount() > 0) {
            RouteQueueRow rqr = this.mRouteQueueModel.getRow(0);
            if (!rqr.fromto.isValidBoth()) {
                return true;
            }
            unConnected += RouteQueue.countMissingContact(fromPath, rqr.fromto);
            fromPath = ((DevicePath)rqr.fromto.getDPPA().first).pathToSubstrate();
        }
        if (unConnected > 0) {
            return RouteQueue.showContactManagementPopup(fromPath, unConnected);
        }
        for (String s : mPerStrList) {
            per = (Personality)db.getByKeyStr(Personality.class, s);
            if (per == null || (bundle = Bundle.getBundle((Personality)per)) == null) continue;
            Cp.exec((String)"unset(\"_bundle\")", (Object[])new Object[0]);
            Cp.exec((String)"_bundle = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(bundle)});
            Cp.exec((String)"_bundle.setContacted();", (Object[])new Object[0]);
        }
        return true;
    }

    protected void reroute() {
        if (!this.everythingContacted()) {
            return;
        }
        int unRuly = 0;
        for (int row = 0; row < this.mRouteQueueModel.getRowCount(); ++row) {
            RuleSet rs;
            RouteQueueRow rqr = this.mRouteQueueModel.getRow(row);
            if (rqr.fromto.getDPPA() == null || (rs = RuleSetMgr.getMyRuleSet((DbObject)rqr.fromto.getHierPortA().getPin())) != null && RouteQueue.isRuleSetApplicable(rqr.per, rs)) continue;
            ++unRuly;
            rs = null;
        }
        if (unRuly > 0) {
            Object[] allOpts = new String[]{"Cancel", "Route"};
            String msg = String.format("There are " + unRuly + " routes that have no rule set defined, these will be ignored", new Object[0]);
            JOptionPane op = new JOptionPane(msg, 3);
            op.setOptions(allOpts);
            JDialog dlg = op.createDialog(OrbitIO.getMainWindow(), "Missing Rules");
            dlg.setVisible(true);
            String selOpt = (String)op.getValue();
            if (selOpt == null || selOpt.equals(allOpts[0])) {
                return;
            }
        }
        DbHistory history = OrbitIO.getCurDb().getHistory();
        try (DbHistory.DbTransaction trans = history.newDbTransaction("Route Bundle");){
            boolean removeVias = this.mSimple || this.mRemoveViasWhenDeletingWires.isSelected();
            int count = 1;
            for (String s : mPerStrList) {
                Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
                if (per == null) continue;
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.unRouteRDLPersonality(\"%s\", %b );", (Object[])new Object[]{per.getKeyStr(), removeVias});
                Bundle bundle = Bundle.getBundle((Personality)per);
                if (bundle != null) {
                    Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRoutePrep.updateBundleRouteContacts (\"%s\", %b, \"%s\");", (Object[])new Object[]{bundle.getKeyStr(), RouteQueue.isFixedSide(bundle, per), s});
                }
                DevicePath pathToRoutingSubstrate = SchedConn.getADevicePath((Personality)per);
                DevicePath relPath = new DevicePath(pathToRoutingSubstrate.getDeviceTemplate());
                String cmd = "";
                if (count++ == 1) {
                    Personality.Type perType = per.getType();
                    cmd = perType == Personality.Type.DIEESCAPE || perType == Personality.Type.PCBFixed || perType == Personality.Type.PCBFree || perType == Personality.Type.PckFree ? "router =  new com.sigrity.orbit.ui.wb_route.BundleEscapeInterface ();" : "router =  new com.sigrity.orbit.ui.wb_route.RDLRouterInterface ();";
                }
                Cp.exec((String)cmd, (Object[])new Object[0]);
                Cp.exec((String)"router.addPersonality (\"%s\");", (Object[])new Object[]{per.getKeyStr()});
                Cp.exec((String)"router.setRoutingPath (\"%s\");", (Object[])new Object[]{relPath.escapedString()});
            }
            Cp.exec((String)"router.route();", (Object[])new Object[0]);
            this.mRouteQueueModel.buildTableFromSchedConn();
        }
        this.updateUI();
    }

    protected static SchedConn getFixedRouteSchedConn(Bundle b, SchedConn sc) {
        Personality p = b.getRouteGroup();
        if (p == null) {
            return null;
        }
        for (SchedConn rsc : p.getSchedConns()) {
            if (!rsc.getDPPA().equals((Object)sc.getDPPA())) continue;
            return rsc;
        }
        return null;
    }

    protected static SchedConn getFreeRouteSchedConn(Bundle b, SchedConn sc) {
        Personality p = b.getRouteGroupFree();
        if (p == null) {
            return null;
        }
        for (SchedConn rsc : p.getSchedConns()) {
            if (!rsc.getDPPA().equals((Object)sc.getDPPB())) continue;
            return rsc;
        }
        return null;
    }

    public static void doBundleMoveCommand(Db db, String bundleKeyStr, int order, int dir) {
        Bundle b = (Bundle)db.getByKeyStr(Bundle.class, bundleKeyStr);
        SchedConn sc = b.getNth(order);
        SchedConn rscFrom = RouteQueue.getFixedRouteSchedConn(b, sc);
        SchedConn rscTo = RouteQueue.getFreeRouteSchedConn(b, sc);
        SchedConn scNext = b.getNth(order + dir);
        SchedConn rscFromNext = RouteQueue.getFixedRouteSchedConn(b, scNext);
        SchedConn rscToNext = RouteQueue.getFreeRouteSchedConn(b, scNext);
        if (Bundle.moveSchedConn((Db)db, (String)bundleKeyStr, (int)order, (int)dir)) {
            Net netOther;
            Net netMe;
            if (rscFrom != null && rscFromNext != null) {
                RouteQueue.removeRoute(OrbitIO.getCurDb(), rscFrom.getKeyStr(), false, b);
                RouteQueue.removeRoute(OrbitIO.getCurDb(), rscFromNext.getKeyStr(), false, b);
                PinTemplate ptFixedMe = rscFrom.getDPPB().getPinTemplate();
                netMe = ptFixedMe.getNet();
                PinTemplate ptFixedOther = rscFromNext.getDPPB().getPinTemplate();
                netOther = ptFixedOther.getNet();
                ptFixedMe.setNet(netOther);
                ptFixedOther.setNet(netMe);
                rscFrom.swapB(rscFromNext);
            }
            if (rscTo != null && rscToNext != null) {
                RouteQueue.removeRoute(OrbitIO.getCurDb(), rscTo.getKeyStr(), false, b);
                RouteQueue.removeRoute(OrbitIO.getCurDb(), rscToNext.getKeyStr(), false, b);
                PinTemplate ptFreeMe = rscTo.getDPPB().getPinTemplate();
                netMe = ptFreeMe.getNet();
                PinTemplate ptFreeOther = rscToNext.getDPPB().getPinTemplate();
                netOther = ptFreeOther.getNet();
                ptFreeMe.setNet(netOther);
                ptFreeOther.setNet(netMe);
                rscTo.swapB(rscToNext);
            }
        }
    }

    protected SchedConn getRouteSchedConnA(HierPin hp) {
        for (RouteQueueRow r : this.mRouteQueueModel.routeQueueRows) {
            if (!r.fromto.getDPPA().equals((Object)hp)) continue;
            return r.fromto;
        }
        return null;
    }

    protected SchedConn getRouteSchedConnB(HierPin hp) {
        for (RouteQueueRow r : this.mRouteQueueModel.routeQueueRows) {
            if (!r.fromto.getDPPB().equals((Object)hp)) continue;
            return r.fromto;
        }
        return null;
    }

    public static void addAPort(HierPort port, Personality p) {
        if (mPersonality2Personalizer.get(p) == null) {
            RouteQueue.addToRoutePersonalizerHash(p, new RDLPersonalizer());
        }
        if (port.getDPort().getPinTemplate().getType().equals((Object)mPersonality2Personalizer.get(p).getToPinType())) {
            SchedConn sc = SchedConn.create((DbObject)p, null, null, (DevicePath)port.getPath(), (PortTemplate)port.getDPort().getPinTemplate().getFirstPortTemplate());
            RouteQueue.setPriority(sc, 0);
        } else if (port.getDPort().getPinTemplate().getType().equals((Object)mPersonality2Personalizer.get(p).getFromPinType())) {
            boolean isRDL = p.getType().equals((Object)Personality.Type.RDL);
            if (isRDL && port.getSubstrateNet() == null || port.getSubstrateNet().isUnused()) {
                return;
            }
            SchedConn sc = SchedConn.create((DbObject)p, (DevicePath)port.getPath(), (PortTemplate)port.getDPort().getPinTemplate().getFirstPortTemplate(), null, null);
            port.getPin().assignToRouteDefinition(p);
            RouteQueue.setPriority(sc, 0);
        }
    }

    public static void addOrRemovePort(String devicePathString, String portTemplateKey, String personalityKey, String schedConnKeyStr) {
        Db db = OrbitIO.getCurDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)personalityKey);
        if (p == null) {
            ALog.logWarn((String)("Personality " + personalityKey + " does not exist"));
            return;
        }
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath.getIsAbsolute()) {
            DeviceTemplate dt = SchedConn.getASubstrateDeviceTemplate((Personality)p);
            devicePath = devicePath.getRelativePathFromAnchor(dt);
        }
        if (devicePath == null) {
            ALog.logWarn((String)("Device Path " + devicePathString + " does not exist"));
            return;
        }
        PortTemplate portTemplate = (PortTemplate)db.getByKeyStr(PortTemplate.class, portTemplateKey);
        if (portTemplate == null) {
            ALog.logWarn((String)("Port " + portTemplateKey + " does not exist"));
            return;
        }
        HierPort port = new HierPort(devicePath, portTemplate);
        if (schedConnKeyStr == null) {
            RouteQueue.addAPort(port, p);
        } else {
            SchedConn aMatchingSchedConn = (SchedConn)db.getByKeyStr(SchedConn.class, schedConnKeyStr);
            if (aMatchingSchedConn == null) {
                ALog.logWarn((String)("SchedConn " + schedConnKeyStr + " does not exist"));
                return;
            }
            if (port.getDPort().getPinTemplate().getType().equals((Object)mPersonality2Personalizer.get(p).getToPinType())) {
                RouteQueue.setPriority(aMatchingSchedConn, 0);
            } else if (port.getDPort().getPinTemplate().getType().equals((Object)mPersonality2Personalizer.get(p).getFromPinType())) {
                port.getPin().removeFromRouteDefinition();
                RouteQueue.setPriority(aMatchingSchedConn, 0);
            }
            aMatchingSchedConn.deleteFromDb();
        }
    }

    protected void fatProcess() {
        for (String s : mPerStrList) {
            Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
            Bundle bundle = Bundle.getBundle((Personality)per);
            double expansion = RouteQueue.isFixedSide(bundle, per) ? bundle.getFixedExpansion() : bundle.getFreeExpansion();
            expansion *= 1.1;
            expansion = Math.min(expansion, 50.0);
            DbHistory history = OrbitIO.getCurDb().getHistory();
            DbHistory.DbTransaction trans = history.newDbTransaction("expand bundle");
            try {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.commandChangeExpansion (%f,\"%s\", \"%s\");", (Object[])new Object[]{expansion, bundle.getKeyStr(), per.getKeyStr()});
            }
            finally {
                if (trans == null) continue;
                trans.close();
            }
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    protected void skinnyProcess() {
        for (String s : mPerStrList) {
            Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
            Bundle bundle = Bundle.getBundle((Personality)per);
            double expansion = RouteQueue.isFixedSide(bundle, per) ? bundle.getFixedExpansion() : bundle.getFreeExpansion();
            expansion /= 1.1;
            expansion = Math.max(expansion, 1.0);
            DbHistory history = OrbitIO.getCurDb().getHistory();
            DbHistory.DbTransaction trans = history.newDbTransaction("shrink bundle");
            try {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.commandChangeExpansion (%f,\"%s\", \"%s\");", (Object[])new Object[]{expansion, bundle.getKeyStr(), per.getKeyStr()});
            }
            finally {
                if (trans == null) continue;
                trans.close();
            }
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    protected void swapToPins() {
        int[] rows = this.mRouteQueueTable.getSelectedRows();
        int row1 = rows[0];
        int row2 = rows[1];
        Db db = OrbitIO.getCurDb();
        Personality p1 = (Personality)db.getByKeyStr(Personality.class, mPerStrList.getFirst());
        DbHistory history = db.getHistory();
        try (DbHistory.DbTransaction trans = history.newDbTransaction("Swap " + mPersonality2Personalizer.get(p1).getColumnToName());){
            RouteQueueRow mRouteRow1 = this.mRouteQueueModel.getRow(row1);
            RouteQueueRow mRouteRow2 = this.mRouteQueueModel.getRow(row2);
            HierPort hp1 = mRouteRow1.fromto.getHierPortB();
            HierPort hp2 = mRouteRow2.fromto.getHierPortB();
            String net1Name = hp1.getSubstrateNet().getName();
            String net2Name = hp2.getSubstrateNet().getName();
            PinInstance pinInst1B = mRouteRow1.fromto.getHierPortB().getPin();
            PinInstance pinInst2B = mRouteRow2.fromto.getHierPortB().getPin();
            if (!pinInst1B.getNet().isUnused()) {
                NetMap.mapThroughPath((DevicePath)hp1.getPath(), (PinInstance)pinInst1B, (String)net2Name);
            }
            if (!pinInst2B.getNet().isUnused()) {
                NetMap.mapThroughPath((DevicePath)hp2.getPath(), (PinInstance)pinInst2B, (String)net1Name);
            }
            int conCount = 0;
            for (RouteQueueRow r : this.mRouteQueueModel.routeQueueRows) {
                if (r.fromto.getHierPortB().equals((Object)hp1)) {
                    ++conCount;
                    r.fromto.setPortB(hp2.getPath(), hp2.getDPort());
                    continue;
                }
                if (!r.fromto.getHierPortB().equals((Object)hp2)) continue;
                ++conCount;
                r.fromto.setPortB(hp1.getPath(), hp1.getDPort());
            }
            ALog.logInfo((String)("Swapped nets " + net1Name + " and " + net2Name));
            ALog.logInfo((String)("There were " + conCount + " connections that changed to different " + mPersonality2Personalizer.get(p1).getColumnToName().toLowerCase()));
        }
        this.mRouteQueueTable.updateUI();
        this.rebuildPrimSecondList();
    }

    protected void swapFromPins() {
        int[] rows = this.mRouteQueueTable.getSelectedRows();
        int row1 = rows[0];
        int row2 = rows[1];
        DbHistory history = OrbitIO.getCurDb().getHistory();
        try (DbHistory.DbTransaction trans = history.newDbTransaction("Swap IO");){
            RouteQueueRow mRouteRow1 = this.mRouteQueueModel.getRow(row1);
            RouteQueueRow mRouteRow2 = this.mRouteQueueModel.getRow(row2);
            HierPort hp1 = mRouteRow1.fromto.getHierPortA();
            HierPort hp2 = mRouteRow2.fromto.getHierPortA();
            APoint2D temp = new APoint2D(hp1.getPath().getLast().getLoc());
            hp1.getPath().getLast().moveTo(hp2.getPath().getLast().getLoc());
            hp2.getPath().getLast().moveTo(temp);
            ALog.logInfo((String)("Swapped " + hp1.getPath().toString() + " and " + hp2.getPath().getLast().toString()));
            this.mRouteQueueTable.updateUI();
            this.rebuildPrimSecondList();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    protected void clearArrowListeners() {
        this.mSeqUpButton.removeActionListener(this.mIncreaseSeqAction);
        this.mSeqUpButton.removeActionListener(this.mDecreaseSeqAction);
        this.mSeqDnButton.removeActionListener(this.mIncreaseSeqAction);
        this.mSeqDnButton.removeActionListener(this.mDecreaseSeqAction);
        this.mSeqRtButton.removeActionListener(this.mIncreaseSeqAction);
        this.mSeqRtButton.removeActionListener(this.mDecreaseSeqAction);
        this.mSeqLtButton.removeActionListener(this.mIncreaseSeqAction);
        this.mSeqLtButton.removeActionListener(this.mDecreaseSeqAction);
    }

    protected void disableArrows() {
        this.mSeqUpButton.setEnabled(false);
        this.mSeqDnButton.setEnabled(false);
        this.mSeqRtButton.setEnabled(false);
        this.mSeqLtButton.setEnabled(false);
    }

    protected void activateProperArrows() {
        RouteSides side = null;
        for (String s : mPerStrList) {
            Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
            Bundle bundle = Bundle.getBundle((Personality)per);
            if (bundle == null) continue;
            ArrayList pts = bundle.getRakePattern(RouteQueue.isFixedSide(bundle, per));
            ALine line = new ALine((APoint2D)pts.get(0), (APoint2D)pts.get(pts.size() - 1));
            double angle = Math.round(line.getAngle());
            if (angle >= 0.0 && angle < 90.0) {
                if (side != null && !side.equals((Object)RouteSides.N)) {
                    this.disableArrows();
                    this.clearArrowListeners();
                    return;
                }
                side = RouteSides.N;
                this.mSeqUpButton.setEnabled(false);
                this.mSeqDnButton.setEnabled(false);
                this.mSeqRtButton.setEnabled(true);
                this.mSeqLtButton.setEnabled(true);
                this.clearArrowListeners();
                this.mDirection = RouteSides.N;
                this.mSeqRtButton.addActionListener(this.mIncreaseSeqAction);
                this.mSeqLtButton.addActionListener(this.mDecreaseSeqAction);
                continue;
            }
            if (angle >= 90.0 && angle < 180.0) {
                if (side != null && !side.equals((Object)RouteSides.W)) {
                    this.disableArrows();
                    this.clearArrowListeners();
                    return;
                }
                side = RouteSides.W;
                this.mSeqUpButton.setEnabled(true);
                this.mSeqDnButton.setEnabled(true);
                this.mSeqRtButton.setEnabled(false);
                this.mSeqLtButton.setEnabled(false);
                this.clearArrowListeners();
                this.mDirection = RouteSides.W;
                this.mSeqUpButton.addActionListener(this.mIncreaseSeqAction);
                this.mSeqDnButton.addActionListener(this.mDecreaseSeqAction);
                continue;
            }
            if (angle >= 180.0 && angle < 270.0) {
                if (side != null && !side.equals((Object)RouteSides.S)) {
                    this.disableArrows();
                    this.clearArrowListeners();
                    return;
                }
                side = RouteSides.S;
                this.mSeqUpButton.setEnabled(false);
                this.mSeqDnButton.setEnabled(false);
                this.mSeqRtButton.setEnabled(true);
                this.mSeqLtButton.setEnabled(true);
                this.clearArrowListeners();
                this.mDirection = RouteSides.S;
                this.mSeqRtButton.addActionListener(this.mDecreaseSeqAction);
                this.mSeqLtButton.addActionListener(this.mIncreaseSeqAction);
                continue;
            }
            if (side != null && !side.equals((Object)RouteSides.E)) {
                this.disableArrows();
                this.clearArrowListeners();
                return;
            }
            side = RouteSides.E;
            this.mSeqUpButton.setEnabled(true);
            this.mSeqDnButton.setEnabled(true);
            this.mSeqRtButton.setEnabled(false);
            this.mSeqLtButton.setEnabled(false);
            this.clearArrowListeners();
            this.mDirection = RouteSides.E;
            this.mSeqUpButton.addActionListener(this.mDecreaseSeqAction);
            this.mSeqDnButton.addActionListener(this.mIncreaseSeqAction);
        }
    }

    protected void updateCanSwapToPins() {
        int numSelected = this.mRouteQueueTable.getSelectedRowCount();
        if (this.mSimple) {
            int[] rows = this.mRouteQueueTable.getSelectedRows();
            if (numSelected > 1) {
                for (int i = 0; i < rows.length - 1; ++i) {
                    if (Math.abs(rows[i] - rows[i + 1]) == 1) continue;
                    this.mSeqUpButton.setEnabled(false);
                    this.mSeqDnButton.setEnabled(false);
                    this.mSeqRtButton.setEnabled(false);
                    this.mSeqLtButton.setEnabled(false);
                    return;
                }
            }
            if (numSelected <= 0 || rows[0] <= 0 || rows[0] - 1 < 0 || this.mRouteQueueModel.getRow((int)rows[0]).per != this.mRouteQueueModel.getRow((int)(rows[0] - 1)).per) {
                if (this.mSeqUpButton.isEnabled()) {
                    this.mSeqUpButton.setEnabled(false);
                }
                if (this.mSeqLtButton.isEnabled()) {
                    this.mSeqLtButton.setEnabled(false);
                }
            }
            if (numSelected <= 0 || rows[numSelected - 1] >= this.mRouteQueueModel.getRowCount() - 1 || rows[numSelected - 1] + 1 > this.mRouteQueueModel.getRowCount() - 1 || this.mRouteQueueModel.getRow((int)rows[numSelected - 1]).per != this.mRouteQueueModel.getRow((int)(rows[0] + 1)).per) {
                if (this.mSeqDnButton.isEnabled()) {
                    this.mSeqDnButton.setEnabled(false);
                }
                if (this.mSeqRtButton.isEnabled()) {
                    this.mSeqRtButton.setEnabled(false);
                }
            }
        } else if (numSelected == 2) {
            this.mSwapTo.setEnabled(true);
        } else {
            this.mSwapTo.setEnabled(false);
        }
    }

    protected void updateCanSwapFromPins() {
        if (this.mSimple) {
            return;
        }
        int numSelected = this.mRouteQueueTable.getSelectedRowCount();
        if (numSelected == 2) {
            Device d2;
            this.mSwapFrom.setEnabled(true);
            int[] selectedrows = this.mRouteQueueTable.getSelectedRows();
            RouteQueueRow r1 = this.mRouteQueueModel.getRow(selectedrows[0]);
            RouteQueueRow r2 = this.mRouteQueueModel.getRow(selectedrows[1]);
            if (r1.fromto.getDevicePathA() == null || r2.fromto.getDevicePathA() == null) {
                this.mSwapFrom.setEnabled(false);
                return;
            }
            Device d1 = r1.fromto.getDevicePathA().getLast();
            if (d1 == (d2 = r2.fromto.getDevicePathA().getLast())) {
                this.mSwapFrom.setEnabled(false);
                return;
            }
            DeviceTemplate t1 = null;
            if (!r1.fromto.getDevicePathA().isEmpty()) {
                t1 = r1.fromto.getDevicePathA().getLast().getTemplate();
            }
            DeviceTemplate t2 = null;
            if (r2.fromto.getDevicePathA().size() > 0) {
                t2 = r2.fromto.getDevicePathA().getLast().getTemplate();
            }
            if (t1 != null && t2 != null) {
                if (t1.equals(t2)) {
                    this.mSwapFrom.setToolTipText(t1.getName() + " is used by both pads");
                    this.mSwapFrom.setForeground(Color.green);
                } else if (AUtil.equals((Object)t1.getBounds(), (Object)t2.getBounds())) {
                    this.mSwapFrom.setToolTipText(t1.getName() + " and " + t2.getName() + " are the same size");
                    this.mSwapFrom.setForeground(Color.orange);
                } else {
                    this.mSwapFrom.setToolTipText(t1.getName() + " and " + t2.getName() + " are different sizes");
                    this.mSwapFrom.setForeground(Color.red);
                }
            }
        } else {
            this.mSwapFrom.setEnabled(false);
        }
    }

    protected void updateSelectedToPins() {
        if (this.mSimple) {
            return;
        }
        if (this.mPinSelectMode != null) {
            int selectedCount = this.mPinSelectMode.getSelectedPorts().size();
            if (selectedCount > 0) {
                this.mAddSelectedTo.setEnabled(true);
                this.mRemoveSelectedTo.setEnabled(true);
                this.mHighlightSelected.setEnabled(true);
                this.mShowMeMode.setText("Highlight Mode(" + selectedCount + ")");
            } else {
                this.mAddSelectedTo.setEnabled(false);
                this.mRemoveSelectedTo.setEnabled(false);
                this.mHighlightSelected.setEnabled(false);
                this.mShowMeMode.setText(SELECTMODE);
            }
        } else {
            this.mAddSelectedTo.setEnabled(false);
            this.mRemoveSelectedTo.setEnabled(false);
            this.mHighlightSelected.setEnabled(false);
            this.mShowMeMode.setText(SELECTMODE);
        }
    }

    protected void updateStatus() {
        int fromCount = 0;
        int toCount = 0;
        int assigned = 0;
        int wires = 0;
        for (int row = 0; row < this.mRouteQueueModel.getRowCount(); ++row) {
            RouteQueueRow rqr = this.mRouteQueueModel.getRow(row);
            SchedConn sc = rqr.fromto;
            boolean hasFrom = false;
            boolean hasTo = false;
            if (sc.getDevicePathA() != null && sc.getPortA() != null) {
                hasFrom = true;
            }
            if (sc.getDevicePathB() != null && sc.getPortB() != null) {
                hasTo = true;
            }
            if (hasFrom) {
                ++fromCount;
            }
            if (hasTo) {
                ++toCount;
            }
            if (!hasFrom || !hasTo) continue;
            ++assigned;
            CompletionStatus cs = RouteQueue.getCompletionStatus(sc);
            if (!cs.equals((Object)CompletionStatus.All)) continue;
            ++wires;
        }
        String status = this.COLFROMPAD + ": " + fromCount + " " + this.COLTOPAD + ": " + toCount + " Assigned: " + assigned + " Wires: " + wires;
        this.mStatus.setForeground(Color.red);
        if (fromCount == assigned) {
            this.mStatus.setForeground(Color.blue);
        }
        if (fromCount == wires) {
            this.mStatus.setForeground(Color.green);
        }
        if (this.mSimple) {
            for (String s : mPerStrList) {
                Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
                Bundle bundle = Bundle.getBundle((Personality)per);
                if (bundle == null) continue;
                Cp.exec((String)"unset(\"_bundle\")", (Object[])new Object[0]);
                Cp.exec((String)"_bundle = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(bundle)});
                Cp.exec((String)"_bundle.setNumRouted(%d);", (Object[])new Object[]{wires});
            }
        }
        this.mStatus.setText(status);
    }

    protected void updateSchedList() {
        ArrayList<SchedConn> current = new ArrayList<SchedConn>();
        for (RouteQueueRow r : this.mRouteQueueModel.routeQueueRows) {
            current.add(r.fromto);
        }
        this.rqo.setInterfaceList(current);
    }

    public static void scChanged() {
        if (theRouteQueue != null) {
            RouteQueue.theRouteQueue.mRouteQueueModel.buildTableFromSchedConn();
            RouteQueue.theRouteQueue.mRouteQueueTable.updateUI();
        }
    }

    public static void optimizeWithoutSwap(String personalityKey) {
        Db db = OrbitIO.getCurDb();
        Personality personality = Personality.getByKeyStr((Db)db, (String)personalityKey);
        RouterConnectionOptimizer optimizer = new RouterConnectionOptimizer();
        optimizer.allowSwapping(false);
        int count = personality.getSchedConnCount();
        if (count == 0) {
            return;
        }
        for (SchedConn sc : personality.getSchedConns()) {
            if (RouteQueue.getIgnore(sc)) continue;
            HierPort from = sc.getHierPortA();
            HierPort to = sc.getHierPortB();
            if (from != null && from.getDPort() != null && from.getPath() != null) {
                optimizer.loadFromPad(from);
            }
            if (to == null || to.getDPort() == null || to.getPath() == null) continue;
            optimizer.loadToPad(to);
        }
        optimizer.setPersonality(personality);
        if (optimizer.go(mPersonality2Personalizer.get(personality))) {
            RouteQueue.removeSchedConnFromPersonality(personality);
            ArrayList<SchedConn> best = optimizer.getBest(personality);
            for (SchedConn sc : best) {
                RouteQueue.addSchedToPersonality(sc, personality);
            }
            RouteQueue.resetOrder(personality);
        }
        RouteQueue.scChanged();
    }

    public static void optimizeWithSwap(String personalityKey) {
        Db db = OrbitIO.getCurDb();
        Personality personality = Personality.getByKeyStr((Db)db, (String)personalityKey);
        RouterConnectionOptimizer optimizer = new RouterConnectionOptimizer();
        optimizer.allowSwapping(true);
        int count = personality.getSchedConnCount();
        if (count == 0) {
            return;
        }
        for (SchedConn sc : personality.getSchedConns()) {
            if (RouteQueue.getIgnore(sc)) continue;
            HierPort from = sc.getHierPortA();
            HierPort to = sc.getHierPortB();
            if (from != null && from.getDPort() != null && from.getPath() != null) {
                optimizer.loadFromPad(from);
            }
            if (to == null || to.getDPort() == null || to.getPath() == null) continue;
            optimizer.loadToPad(to);
        }
        optimizer.setPersonality(personality);
        if (optimizer.go(mPersonality2Personalizer.get(personality))) {
            RouteQueue.removeSchedConnFromPersonality(personality);
            ArrayList<SchedConn> best = optimizer.getBest(personality);
            for (SchedConn sc : best) {
                RouteQueue.addSchedToPersonality(sc, personality);
            }
            RouteQueue.resetOrder(personality);
        }
        RouteQueue.scChanged();
    }

    public void showMeChanged() {
        if (this.mShowMeMode.isSelected()) {
            this.doCanvasFindMode((PinTemplate.Type)this.mSelectPinFilter.getSelectedItem());
            if (this.mSimple) {
                return;
            }
            this.mAddSelectedTo.setEnabled(true);
            this.mRemoveSelectedTo.setEnabled(true);
            this.mHighlightSelected.setEnabled(true);
        } else {
            if (this.mPinSelectMode != null) {
                this.mPinSelectMode.iAmUninstallingMySelf();
            }
            this.mPinSelectMode = null;
            OrbitIO.getApp().refreshCurrentView(true);
            if (this.mSimple) {
                return;
            }
            this.mAddSelectedTo.setEnabled(false);
            this.mRemoveSelectedTo.setEnabled(false);
            this.mHighlightSelected.setEnabled(false);
        }
    }

    protected static SchedConn findSCThatMatches(Personality p, HierPin from, HierPin to) {
        if (from == null) {
            return null;
        }
        if (to == null) {
            return null;
        }
        if (from.getPath() == null) {
            return null;
        }
        if (from.getPin() == null) {
            return null;
        }
        if (to.getPath() == null) {
            return null;
        }
        if (to.getPin() == null) {
            return null;
        }
        if (to.getPinTemplate() == null) {
            return null;
        }
        for (SchedConn sc : p.getSchedConns()) {
            if (sc.getPortB() == null || sc.getPortA() == null || !sc.getDevicePathA().equals((Object)from.getPath()) || !sc.getDevicePathB().equals((Object)to.getPath()) || !sc.getPortA().equals(from.getPinTemplate().getFirstPortTemplate()) || !sc.getPortB().equals(to.getPinTemplate().getFirstPortTemplate())) continue;
            return sc;
        }
        return null;
    }

    protected static SchedConn findSCThatMatches(Personality p, HierPin from) {
        for (SchedConn sc : p.getSchedConns()) {
            if (!sc.isValidBoth() || !sc.getDevicePathA().equals((Object)from.getPath()) || !sc.getPortA().equals(from.getPinTemplate().getFirstPortTemplate())) continue;
            return sc;
        }
        return null;
    }

    public static void deriveDefaultAssignments(String pKeyStr) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)pKeyStr);
        if (p == null) {
            ALog.logWarn((String)"Invalid Personality '%s'.", (Object[])new Object[]{pKeyStr});
            return;
        }
        AHashCollection net2ToPads = new AHashCollection();
        LinkedList<SchedConn> toBeRemoved = new LinkedList<SchedConn>();
        for (SchedConn sc : p.getSchedConns()) {
            toBeRemoved.add(sc);
        }
        for (SchedConn sc : toBeRemoved) {
            sc.deleteFromDb();
        }
        for (PinInstance fromPad : PinInstance.getRoutePins((Personality)p)) {
            DevicePath pathToRoutingSubstrate = fromPad.getDevice().getADevicePath();
            List cList = NetMap.getConnectedDevicePathPorts((Net)fromPad.getNet(), (DevicePath)pathToRoutingSubstrate);
            Substrate theSubstrate = p.getOwner().getSubstrate();
            for (HierPin toPad : cList) {
                PinTemplate dtp = toPad.getPinTemplate();
                if (dtp.getSubstrate() != theSubstrate || toPad.getPin().getType() != mPersonality2Personalizer.get(p).getToPinType()) continue;
                net2ToPads.add((Object)toPad.getSubstrateNet(), (Object)toPad);
            }
        }
        HashMap<HierPin, Integer> wiresOnPin = new HashMap<HierPin, Integer>();
        for (PinInstance fromPad : PinInstance.getRoutePins((Personality)p)) {
            RuleSet rs;
            boolean toPadFound = false;
            HierPin dppFromPad = null;
            DevicePath fromPadPath = fromPad.getDevice().getADevicePath();
            dppFromPad = new HierPin(fromPadPath, fromPad);
            SchedConn sc = new SchedConn();
            sc.setOwner((DbObject)p);
            sc.setPortA(fromPadPath, fromPad.getPinTemplate().getFirstPortTemplate());
            p.getDb().add((DbObject)sc);
            Net net = dppFromPad.getSubstrateNet();
            HierPin bestPin = null;
            Long bestDist = null;
            if (net2ToPads.get((Object)net) == null || (rs = RuleSetMgr.getMyRuleSet((DbObject)fromPad)) == null || !RouteQueue.isRuleSetApplicable(p, rs)) continue;
            int maxRoutesForNet = 1;
            Constraint.MaxRoutesPerBump mrp = (Constraint.MaxRoutesPerBump)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.MAX_WIRE_PER_PIN, null);
            maxRoutesForNet = mrp == Constraint.MaxRoutesPerBump.All ? 1 : (mrp == Constraint.MaxRoutesPerBump.One ? 1 : (mrp == Constraint.MaxRoutesPerBump.Two ? 2 : (mrp == Constraint.MaxRoutesPerBump.Three ? 3 : -1)));
            for (HierPin toPin : (LinkedList)net2ToPads.get((Object)net)) {
                int cur;
                if (wiresOnPin.get(toPin) == null) {
                    wiresOnPin.put(toPin, 0);
                }
                if ((cur = ((Integer)wiresOnPin.get(toPin)).intValue()) != -1 && cur + 1 > maxRoutesForNet) continue;
                long thisDist = dppFromPad.getSubstrateLoc().distance(toPin.getSubstrateLoc());
                if (bestDist != null && thisDist >= bestDist) continue;
                bestDist = thisDist;
                bestPin = toPin;
            }
            if (bestPin != null) {
                sc.setPortB(bestPin.getPath(), bestPin.getPinTemplate().getFirstPortTemplate());
                toPadFound = true;
                wiresOnPin.put(bestPin, (Integer)wiresOnPin.get(bestPin) + 1);
            }
            if (toPadFound) continue;
            ALog.logWarn((String)("No destination pin found for " + dppFromPad.toString()));
        }
        RouteQueue.resetOrder(p);
        RouteQueue.scChanged();
    }

    public static boolean hasARoute(HierPin originalHierPin) {
        if (originalHierPin == null || originalHierPin.getPin() == null) {
            return false;
        }
        AGeom wordlShapeGeom = null;
        HierPin connectingPin = originalHierPin;
        DevicePath path = originalHierPin.getPath();
        PinInstance via = originalHierPin.getPin().getFirstExternallyConnected();
        if (via != null) {
            path = via.getDevice().getADevicePath();
            connectingPin = new HierPin(path, via);
        }
        for (Layer l : connectingPin.getPath().getSubstrate().getLayers()) {
            wordlShapeGeom = connectingPin.getPin().getWorldShapeOnLayer(path, l);
            if (wordlShapeGeom == null) continue;
            ARect r = wordlShapeGeom.getBounds();
            Net top = connectingPin.getSubstrateNet();
            for (Wire w : top.getWires()) {
                if (!r.contains(w.getPath().getFirstPoint()) && !r.contains(w.getPath().getLastPoint()) || RuleSetMgr.getMyRuleSet((DbObject)w) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasARouteFromBundle(Bundle b, HierPin originalHierPin) {
        Wire wire = Bundle.getARouteFromBundle((Bundle)b, (HierPin)originalHierPin);
        return wire != null;
    }

    public static CompletionStatus getCompletionStatus(SchedConn sc) {
        HierPort fromPad = sc.getHierPortA();
        if (fromPad != null) {
            LinkedList<Wire> wires = WbFcFeasibilityUI.getRoutes(sc);
            if (wires == null || wires.isEmpty()) {
                return CompletionStatus.None;
            }
            if (sc.getHierPortA().second != null && sc.getHierPortA().first != null) {
                RuleSet rs = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin());
                if (rs != null) {
                    Layer secondaryLayer = (Layer)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.SEC_ROUTE_LAYER, null);
                    if (secondaryLayer != null) {
                        if (wires.size() == 2) {
                            return CompletionStatus.All;
                        }
                        if (wires.size() == 1) {
                            return CompletionStatus.Partial;
                        }
                    } else if (wires.size() >= 1) {
                        return CompletionStatus.All;
                    }
                } else {
                    return CompletionStatus.All;
                }
            }
        }
        return CompletionStatus.None;
    }

    public static void removeRoute(Db db, String schedConnKeyStr, boolean removeVias, Bundle b) {
        SchedConn sc = (SchedConn)db.getByKeyStr(SchedConn.class, schedConnKeyStr);
        HierPort fromPad = sc.getHierPortA();
        if (fromPad != null) {
            LinkedList<Wire> wires = WbFcFeasibilityUI.getRoutes(sc);
            for (Wire wire : wires) {
                if (b == null || !b.isMyWire(wire) || wire.getDb() == null) continue;
                wire.deleteFromDb();
            }
            if (removeVias) {
                LinkedList<PinTemplate> toBeDeletedVias = new LinkedList<PinTemplate>();
                for (PinInstance pinInstance : ((PinInstance)sc.getDPPA().second).getExternallyConnected()) {
                    toBeDeletedVias.add(pinInstance.getPinTemplate());
                }
                for (PinTemplate pinTemplate : toBeDeletedVias) {
                    if (pinTemplate.getDb() == null) continue;
                    pinTemplate.deleteFromDb();
                }
            }
        }
    }

    public static int computeSchedConnCross(RouteQueueRow rqr, List<RouteQueueRow> arr) {
        if (rqr.fromto.getDPPA() == null || rqr.fromto.getDPPB() == null) {
            return 0;
        }
        int ret = 0;
        ALine l = new ALine(RouteQueue.fullPathHierPin(rqr.fromto.getDPPA()).getWorldLoc(), RouteQueue.fullPathHierPin(rqr.fromto.getDPPB()).getWorldLoc());
        for (RouteQueueRow r : arr) {
            ALine t;
            if (r == rqr || !r.fromto.isValidBoth() || !(t = new ALine(RouteQueue.fullPathHierPin(r.fromto.getDPPA()).getWorldLoc(), RouteQueue.fullPathHierPin(r.fromto.getDPPB()).getWorldLoc())).intersects((AGeom)l)) continue;
            ++ret;
        }
        return ret;
    }

    public void zoomToRouteRegion() {
        ARect b = null;
        if (this.mRouteQueueTable == null) {
            return;
        }
        int[] A = this.mRouteQueueTable.getSelectedRows();
        if (A.length == 0) {
            A = new int[this.mRouteQueueTable.getRowCount()];
            for (int i = 0; i < A.length; ++i) {
                A[i] = i;
            }
        }
        for (int row : A) {
            APoint2D p;
            RouteQueueRow rqr = this.mRouteQueueModel.routeQueueRows.get(row);
            if (rqr.fromto.getHierPortA() != null && rqr.fromto.getHierPortA().second != null) {
                p = RouteQueue.fullPathHierPin(rqr.fromto.getDPPA()).getWorldLoc();
                if (b == null) {
                    b = new ARect(p, p);
                } else {
                    b.expand(p);
                }
            }
            if (rqr.fromto.getHierPortB() == null || rqr.fromto.getHierPortB().second == null) continue;
            p = RouteQueue.fullPathHierPin(rqr.fromto.getDPPB()).getWorldLoc();
            if (b == null) {
                b = new ARect(p, p);
                continue;
            }
            b.expand(p);
        }
        if (b != null) {
            b.expand(1.1);
            DesignView2D v = (DesignView2D)OrbitIO.getCurView();
            v.getCanvas().zoomTo(b);
        }
    }

    public static void addToRuleSet(String ruleSetKeyStr, String pinInstanceString) {
        Db db = OrbitIO.getCurDb();
        RuleSet ruleSet = (RuleSet)db.getByKeyStr(RuleSet.class, ruleSetKeyStr);
        PinInstance pinInstance = (PinInstance)db.getByKeyStr(PinInstance.class, pinInstanceString);
        if (pinInstance == null) {
            ALog.logError((Throwable)new IllegalArgumentException(), (String)"Invalid pinInstance key '%s' specified to addToRuleSet.", (Object[])new Object[]{pinInstanceString});
            return;
        }
        RouteQueue.addToRuleSet(ruleSet, pinInstance);
    }

    public static void addToRuleSet(RuleSet ruleSet, PinInstance pinInstance) {
        if (pinInstance == null) {
            ALog.logError((Throwable)new IllegalArgumentException(), (String)"Invalid null pin instance specified to addToRuleSet.", (Object[])new Object[0]);
            return;
        }
        RuleSetMgr.setMyRuleSet((RuleSet)ruleSet, (DbObject)pinInstance);
    }

    public static void userMoveToTop(int row) {
        RouteQueue.theRouteQueue.mRouteQueueModel.moveToTop(row);
    }

    public static void userMoveToBottom(int row) {
        RouteQueue.theRouteQueue.mRouteQueueModel.moveToBottom(row);
    }

    public static void doNewToPinSelection(Personality per, SchedConn sc, boolean sameNet) {
        ArrayList<HierPort> candidates = new ArrayList<HierPort>();
        DevicePath substratePath = SchedConn.getADevicePath((Personality)per);
        for (DevicePath path : substratePath.getDescendants(true)) {
            for (PinTemplate pin : path.getDeviceTemplate().getPins()) {
                if (pin.getType() != mPersonality2Personalizer.get(per).getToPinType()) continue;
                for (PortTemplate pt : pin.getPortTemplates()) {
                    HierPort hp = new HierPort(path, pt);
                    if (sameNet) {
                        if (!sc.getHierPortA().getSubstrateNet().equals(hp.getSubstrateNet())) continue;
                        candidates.add(hp);
                        continue;
                    }
                    candidates.add(hp);
                }
            }
        }
        RouteQueue.theRouteQueue.changingSchedConn = new SchedConn(sc);
        ChangeToPinAssignment op = new ChangeToPinAssignment();
        RouteQueue.theRouteQueue.mPinSelectMode = InteractiveFilteredPortSelectMode.install((DesignView2D)OrbitIO.getCurView(), candidates);
        InteractiveFilteredPortSelectMode.addLoadListener(op);
    }

    public void doCanvasFindMode(PinTemplate.Type type) {
        ArrayList<HierPort> candidates = new ArrayList<HierPort>();
        for (String s : mPerStrList) {
            Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
            DevicePath substratePath = SchedConn.getADevicePath((Personality)per);
            for (DevicePath path : substratePath.getDescendants(true)) {
                for (PinTemplate pinT : path.getDeviceTemplate().getPins()) {
                    HierPort hp;
                    if (pinT.getType() == mPersonality2Personalizer.get(per).getToPinType()) {
                        if (type != null && type != mPersonality2Personalizer.get(per).getToPinType()) continue;
                        for (PortTemplate pt : pinT.getPortTemplates()) {
                            hp = new HierPort(path, pt);
                            candidates.add(hp);
                        }
                        continue;
                    }
                    if (pinT.getType() != mPersonality2Personalizer.get(per).getFromPinType() || type != null && type != mPersonality2Personalizer.get(per).getFromPinType()) continue;
                    for (PortTemplate pt : pinT.getPortTemplates()) {
                        hp = new HierPort(path, pt);
                        candidates.add(hp);
                    }
                }
            }
        }
        if (RouteQueue.theRouteQueue.mPinSelectMode == null) {
            SelectToPinAction op = new SelectToPinAction();
            RouteQueue.theRouteQueue.mPinSelectMode = InteractiveFilteredPortSelectMode.install((DesignView2D)OrbitIO.getCurView(), candidates);
            InteractiveFilteredPortSelectMode.addLoadListener(op);
        } else {
            RouteQueue.theRouteQueue.mPinSelectMode.setCandidates(candidates);
        }
    }

    public static void resetOrder(String personalityKey) {
        Personality p = Personality.getByKeyStr((Db)OrbitIO.getCurDb(), (String)personalityKey);
        if (p == null) {
            ALog.logWarn((String)"Invalid Personality '%s'.", (Object[])new Object[]{personalityKey});
            return;
        }
        RouteQueue.resetOrder(p);
    }

    public static void resetOrder(Personality p) {
        if (p == null) {
            ALog.logWarn((String)"Invalid Personality in resetOrder()");
            return;
        }
        LinkedList<SchedConn> list = new LinkedList<SchedConn>();
        for (SchedConn sc : p.getSchedConns()) {
            PinInstance ioPad;
            RuleSet rs;
            list.add(sc);
            RouteQueue.setPriority(sc, 0);
            HierPort hierPortA = sc.getHierPortA();
            if (hierPortA == null || (rs = RuleSetMgr.getMyRuleSet((DbObject)(ioPad = hierPortA.getPin()))) == null || !RouteQueue.isRuleSetApplicable(p, rs)) continue;
            Layer routeLayer = (Layer)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.ROUTE_LAYER, null);
            RDLRouterInterface.makeIoPadVia(sc.getDPPA(), routeLayer, null, null);
        }
        Collections.sort(list, new SchedConnRouterSorter(true));
        int priority = 0;
        for (SchedConn sc : list) {
            RouteQueue.setPriority(sc, priority++);
        }
    }

    protected static Integer getPriority(Personality p, HierPin from, HierPin to) {
        SchedConn sc = RouteQueue.findSCThatMatches(p, from, to);
        if (sc != null) {
            return RouteQueue.getPriority(sc);
        }
        return null;
    }

    protected static void removeSchedConnFromPersonality(Personality p) {
        LinkedList<SchedConn> toBeRemoved = new LinkedList<SchedConn>();
        for (SchedConn sc : p.getSchedConns()) {
            if (RouteQueue.getIgnore(sc)) continue;
            toBeRemoved.add(sc);
        }
        for (SchedConn sc : toBeRemoved) {
            sc.deleteFromDb();
        }
    }

    protected static void addSchedToPersonality(SchedConn sc, Personality p) {
        assert (p != null);
        sc.setOwner((DbObject)p);
        p.getDb().add((DbObject)sc);
        if (sc.getPortB() != null && sc.getPortA() != null && !sc.getHierPortA().getSubstrateNet().isUnused()) {
            DevicePath path = sc.getHierPortB().getPath();
            if (!path.getIsAbsolute()) {
                Device d = path.getRoot().getAnInstance();
                DevicePath absPath = new DevicePath(d);
                absPath.addAll(path);
                path = absPath;
            }
            NetMap.mapThroughPath((DevicePath)path, (PinInstance)sc.getHierPortB().getPin(), (String)sc.getHierPortA().getSubstrateNet().getName());
        }
    }

    public void saveSchedPersonality() {
        Personality per;
        LinkedList<SchedConn> toBeRemoved = new LinkedList<SchedConn>();
        AHashArray toBeAdded = new AHashArray();
        HashMap<SchedConn, Integer> savedPriority = new HashMap<SchedConn, Integer>();
        HashMap<SchedConn, Boolean> savedFix = new HashMap<SchedConn, Boolean>();
        for (RouteQueueRow r : this.mRouteQueueModel.routeQueueRows) {
            SchedConn sc = new SchedConn(r.fromto);
            Personality per2 = (Personality)sc.getOwner();
            toBeAdded.add((Object)per2, (Object)sc);
            savedPriority.put(sc, RouteQueue.getPriority(r.fromto));
            savedFix.put(sc, RouteQueue.getIgnore(r.fromto));
        }
        for (String s : mPerStrList) {
            per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
            for (SchedConn sc : per.getSchedConns()) {
                toBeRemoved.add(sc);
            }
        }
        for (SchedConn sc : toBeRemoved) {
            sc.deleteFromDb();
        }
        this.mRouteQueueModel.routeQueueRows.clear();
        for (Map.Entry entry : toBeAdded.entrySet()) {
            per = (Personality)entry.getKey();
            for (SchedConn sc : (ArrayList)entry.getValue()) {
                sc.setOwner((DbObject)per);
                per.getDb().add((DbObject)sc);
                RouteQueueRow rqr = new RouteQueueRow();
                rqr.fromto = sc;
                this.mRouteQueueModel.routeQueueRows.add(rqr);
                RouteQueue.setPriority(sc, (Integer)savedPriority.get(sc));
                RouteQueue.setIgnore(sc, (Boolean)savedFix.get(sc));
            }
        }
        this.mRouteQueueTable.updateUI();
    }

    protected static Integer getPriority(SchedConn sc) {
        Integer priority = (Integer)sc.getValue(FLDNAME_PRIORITY);
        if (priority == null) {
            return 1;
        }
        return priority;
    }

    public static void setPriority(SchedConn schedConn, Integer priority) {
        if (!Objects.equals(RouteQueue.getPriority(schedConn), priority)) {
            Cp.exec((String)"SchedConn _sc = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(schedConn)});
            Cp.exec((String)"_sc.setValue(\"%s\",%d);", (Object[])new Object[]{FLDNAME_PRIORITY, priority});
            Cp.exec((String)"unset(\"_sc\");", (Object[])new Object[0]);
        }
    }

    protected static boolean getIgnore(SchedConn sc) {
        if (sc == null) {
            return false;
        }
        Boolean ignore = (Boolean)sc.getValue(FLDNAME_IGNORE);
        if (ignore == null) {
            return false;
        }
        return ignore;
    }

    protected static void setIgnore(SchedConn schedConn, Boolean ignore) {
        if (!Objects.equals(RouteQueue.getIgnore(schedConn), ignore)) {
            schedConn.setValue(FLDNAME_IGNORE, (Object)ignore);
        }
    }

    public static void ignoreSchedConn(int row) {
        try {
            RouteQueueRow rtr = RouteQueue.theRouteQueue.mRouteQueueModel.routeQueueRows.get(row);
            SchedConn sc = rtr.fromto;
            Boolean ignore = RouteQueue.getIgnore(sc);
            RouteQueue.setIgnore(sc, ignore == false);
        }
        catch (Exception e) {
            ALog.logWarn((String)"Ignore SchedConn failed");
        }
    }

    protected void setDisplayOrder(DisplayOrder order) {
    }

    public static void routeVisionOff() {
        DesignView2D v2d = (DesignView2D)OrbitIO.getCurView();
        DesignCanvas2D c2d = v2d.getCanvas();
        c2d.setDrawer(null);
    }

    public static void routeVisionOn(Personality p) {
        DesignView2D v2d = (DesignView2D)OrbitIO.getCurView();
        DesignCanvas2D c2d = v2d.getCanvas();
        RoutingViewDrawer routingView = new RoutingViewDrawer(c2d);
        LinkedList<Layer> layers = new LinkedList<Layer>();
        DevicePath path = null;
        for (SchedConn sc : p.getSchedConns()) {
            Layer routeLayer;
            RuleSet rs;
            if (!sc.getHierPortA().complete() || !sc.getHierPortB().complete() || (rs = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin())) == null || !RouteQueue.isRuleSetApplicable(p, rs)) continue;
            if (path == null) {
                path = sc.getDevicePathB();
            }
            if (!layers.contains(routeLayer = (Layer)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.ROUTE_LAYER, null))) {
                layers.add(routeLayer);
            }
            if (layers.contains(routeLayer = (Layer)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.SEC_ROUTE_LAYER, null))) continue;
            layers.add(routeLayer);
        }
        if (path != null) {
            path = path.pathToSubstrate();
            for (Layer layer : layers) {
                if (layer == null) continue;
                routingView.addLayer(path.toString(), layer.getName());
            }
            c2d.setDrawer(routingView);
        }
    }

    protected DevicePath bestPath(String badPathString, DeviceTemplate dt) {
        DevicePath bestPath = null;
        LinkedList devices = AUtil.linkedList((Object[])badPathString.split("/"));
        String lastDeviceName = (String)devices.getLast();
        for (DevicePath path : dt.getHierarchicalInstances()) {
            if (!path.getLast().getName().equals(lastDeviceName)) continue;
            if (bestPath == null) {
                bestPath = path;
                continue;
            }
            return null;
        }
        return bestPath;
    }

    protected boolean validateHier(SchedConn sc) {
        return sc.isValidBoth();
    }

    public static void buildTableFromSchedConnForRouteQ() {
        if (theRouteQueue != null) {
            RouteQueue.theRouteQueue.mRouteQueueModel.buildTableFromSchedConn();
        }
    }

    public static int testPermutations(int max) {
        return RouteQueue.testPermutations(max, false);
    }

    public static int testPermutations(int max, boolean stopAtSuccess) {
        OrbitIO.getCurDb().setHistoryEnabled(false);
        if (theRouteQueue != null) {
            int pass = 0;
            block0: for (String s : mPerStrList) {
                Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
                Bundle bundle = Bundle.getBundle((Personality)per);
                LinkedList<SchedConn> originalOrder = new LinkedList<SchedConn>();
                for (SchedConn sc : bundle.getSchedConn()) {
                    originalOrder.add(sc);
                }
                int size = originalOrder.size();
                Integer[] data = new Integer[size];
                for (int i = 0; i < size; ++i) {
                    data[i] = i;
                }
                int num = 0;
                for (Integer[] integerArray : new Permuter<Integer>(data)) {
                    int idx = 0;
                    for (SchedConn sc : originalOrder) {
                        Bundle.setInOrder((SchedConn)sc, (int)integerArray[idx]);
                        ++idx;
                    }
                    RouteQueue.theRouteQueue.mRouteQueueModel.buildTableFromSchedConn();
                    BundleRoutePrep.updateBundleRouteContacts(bundle, true, per);
                    theRouteQueue.reroute();
                    OrbitIO.getApp().refreshCurrentView(false);
                    int failureCount = RouteQueue.failure();
                    if (stopAtSuccess) {
                        if (failureCount == 0) {
                            return 1;
                        }
                    } else if (failureCount == 0) {
                        ++pass;
                    }
                    if (++num <= max) continue;
                    continue block0;
                }
            }
            ALog.logInfo((String)("Pass: " + pass));
            OrbitIO.getCurDb().setHistoryEnabled(true);
            return pass;
        }
        OrbitIO.getCurDb().setHistoryEnabled(true);
        return 0;
    }

    protected static int failure() {
        int failures = 0;
        for (int row = 0; row < RouteQueue.theRouteQueue.mRouteQueueModel.getRowCount(); ++row) {
            RouteQueueRow rqr = RouteQueue.theRouteQueue.mRouteQueueModel.getRow(row);
            SchedConn sc = rqr.fromto;
            boolean hasFrom = false;
            boolean hasTo = false;
            if (sc.getDevicePathA() != null && sc.getPortA() != null) {
                hasFrom = true;
            }
            if (sc.getDevicePathB() != null && sc.getPortB() != null) {
                hasTo = true;
            }
            if (hasFrom && hasTo) {
                CompletionStatus cs = RouteQueue.getCompletionStatus(sc);
                if (cs.equals((Object)CompletionStatus.All)) continue;
                ++failures;
                continue;
            }
            ++failures;
        }
        return failures;
    }

    static HierPin fullPathHierPin(HierPin relPin) {
        if (relPin == null) {
            return relPin;
        }
        DevicePath path = relPin.getPath();
        if (path.getIsAbsolute()) {
            return relPin;
        }
        DeviceTemplate anchor = path.getRoot();
        Device exampleInstance = anchor.getAnInstance();
        DevicePath newPath = exampleInstance.getADevicePath();
        newPath.addAll(path);
        return new HierPin(newPath, (PinInstance)relPin.second);
    }

    static HierPort fullPathHierPort(HierPort relPin) {
        if (relPin == null) {
            return relPin;
        }
        DevicePath path = relPin.getPath();
        if (path.getIsAbsolute()) {
            return relPin;
        }
        DeviceTemplate anchor = path.getRoot();
        Device exampleInstance = anchor.getAnInstance();
        DevicePath newPath = exampleInstance.getADevicePath();
        newPath.addAll(path);
        return new HierPort(newPath, (PortTemplate)relPin.second);
    }

    public static boolean isRuleSetApplicable(Personality personality, RuleSet ruleset) {
        boolean applicable = true;
        if (personality == null || ruleset == null) {
            return false;
        }
        DeviceTemplate devT = personality.getOwner();
        if (devT == null || devT.getSubstrate() != ruleset.getSubstrate()) {
            return false;
        }
        return applicable;
    }

    static {
        selectionChanging = false;
        mZoomToAllStatus = false;
        showSubstrateNetName = true;
        mPerStrList = new LinkedList();
        ICON_ARROW_UP = DBEResources.ICON_ARROW_UP;
        ICON_ARROW_DN = DBEResources.ICON_ARROW_DN;
        ICON_ARROW_RT = DBEResources.ICON_ARROW_RT;
        ICON_ARROW_LT = DBEResources.ICON_ARROW_LT;
        mPluginRouter = new TreeMap<String, String>();
    }

    public static class SchedConnDisplaySorter
    implements Comparator<SchedConn> {
        DisplayOrder order = DisplayOrder.RouteOrder;
        Personality personality = null;

        public SchedConnDisplaySorter(DisplayOrder order, Personality personality) {
            this.order = order;
            this.personality = personality;
        }

        @Override
        public int compare(SchedConn sc0, SchedConn sc1) {
            if (this.order.equals((Object)DisplayOrder.RouteOrder)) {
                Long l0 = sc0.getWorstCaseLength();
                Long l1 = sc1.getWorstCaseLength();
                if (l0 == null && l1 != null) {
                    return 1;
                }
                if (l1 == null && l0 != null) {
                    return -1;
                }
                if (l1 == null && l0 == null) {
                    if (sc0.getPortA() == null) {
                        return 1;
                    }
                    return -1;
                }
                return AUtil.compare((Comparable)l0, (Object)l1);
            }
            if (this.order.equals((Object)DisplayOrder.NetNameAscending) || this.order.equals((Object)DisplayOrder.NetNameDescending)) {
                String s0 = "";
                String s1 = "";
                if (sc0.getHierPortA() != null && sc0.getHierPortA().complete()) {
                    s0 = sc0.getHierPortA().getSubstrateNet().getName();
                }
                if (sc1.getHierPortA() != null && sc1.getHierPortA().complete()) {
                    s1 = sc1.getHierPortA().getSubstrateNet().getName();
                }
                if (s0.equals("") && !s1.equals("")) {
                    return 1;
                }
                if (!s0.equals("") && s1.equals("")) {
                    return -1;
                }
                AAlphaNumComp c = AAlphaNumComp.get();
                if (this.order.equals((Object)DisplayOrder.NetNameAscending)) {
                    return c.compare((Object)s0, (Object)s1);
                }
                return c.compare((Object)s1, (Object)s0);
            }
            if (this.order.equals((Object)DisplayOrder.CompletionStatusAscending)) {
                int i1;
                CompletionStatus c0 = RouteQueue.getCompletionStatus(sc0);
                CompletionStatus c1 = RouteQueue.getCompletionStatus(sc1);
                int i0 = c0.ordinal();
                if (i0 != (i1 = c1.ordinal())) {
                    return i0 - i1;
                }
                return this.compareByName(sc0, sc1, true);
            }
            if (this.order.equals((Object)DisplayOrder.CompletionStatusDescending)) {
                int i1;
                CompletionStatus c0 = RouteQueue.getCompletionStatus(sc0);
                CompletionStatus c1 = RouteQueue.getCompletionStatus(sc1);
                int i0 = c0.ordinal();
                if (i0 != (i1 = c1.ordinal())) {
                    return i1 - i0;
                }
                return this.compareByName(sc0, sc1, false);
            }
            if (this.order.equals((Object)DisplayOrder.RuleNameAscending)) {
                RuleSet rs;
                String r0 = "";
                String r1 = "";
                if (sc0.getHierPortA().second != null && sc0.getHierPortA().first != null && (rs = RuleSetMgr.getMyRuleSet((DbObject)sc0.getHierPortA().getPin())) != null && RouteQueue.isRuleSetApplicable(this.personality, rs)) {
                    r0 = rs.getName();
                }
                if (sc1.getHierPortA().second != null && sc1.getHierPortA().first != null && (rs = RuleSetMgr.getMyRuleSet((DbObject)sc1.getHierPortA().getPin())) != null && RouteQueue.isRuleSetApplicable(this.personality, rs)) {
                    r1 = rs.getName();
                }
                if (r0.equals("") && r1.equals("")) {
                    return this.compareByName(sc0, sc1, true);
                }
                if (r0.equals("") && !r1.equals("")) {
                    return -1;
                }
                if (!r0.equals("") && r1.equals("")) {
                    return 1;
                }
                if (r0.equals(r1)) {
                    return this.compareByName(sc0, sc1, true);
                }
                return r0.compareTo(r1);
            }
            if (this.order.equals((Object)DisplayOrder.RuleNameDescending)) {
                RuleSet rs;
                String r0 = "";
                String r1 = "";
                if (sc0.getHierPortA().second != null && sc0.getHierPortA().first != null && (rs = RuleSetMgr.getMyRuleSet((DbObject)sc0.getHierPortA().getPin())) != null && RouteQueue.isRuleSetApplicable(this.personality, rs)) {
                    r0 = rs.getName();
                }
                if (sc1.getHierPortA().second != null && sc1.getHierPortA().first != null && (rs = RuleSetMgr.getMyRuleSet((DbObject)sc1.getHierPortA().getPin())) != null && RouteQueue.isRuleSetApplicable(this.personality, rs)) {
                    r1 = rs.getName();
                }
                if (r0.equals("") && r1.equals("")) {
                    return this.compareByName(sc0, sc1, false);
                }
                if (r0.equals("") && !r1.equals("")) {
                    return 1;
                }
                if (!r0.equals("") && r1.equals("")) {
                    return -1;
                }
                if (r0.equals(r1)) {
                    return this.compareByName(sc0, sc1, false);
                }
                return r1.compareTo(r0);
            }
            if (this.order.equals((Object)DisplayOrder.SeqOrder) || this.order.equals((Object)DisplayOrder.SeqOrderAscending)) {
                Bundle bundle = Bundle.getBundle((Personality)this.personality);
                if (bundle != null) {
                    SchedConn b0 = bundle.getSchedConnOfA(sc0.getDPPA());
                    if (b0 == null) {
                        b0 = bundle.schedConnUsingFreeHierPin(sc0.getDPPA());
                    }
                    int order0 = Bundle.getOrder((SchedConn)b0);
                    SchedConn b1 = bundle.getSchedConnOfA(sc1.getDPPA());
                    if (b1 == null) {
                        b1 = bundle.schedConnUsingFreeHierPin(sc1.getDPPA());
                    }
                    int order1 = Bundle.getOrder((SchedConn)b1);
                    return this.order.equals((Object)DisplayOrder.SeqOrder) ? order1 - order0 : order0 - order1;
                }
                return 0;
            }
            return 0;
        }

        protected int compareByName(SchedConn sc0, SchedConn sc1, boolean ascending) {
            DisplayOrder save = this.order;
            this.order = ascending ? DisplayOrder.NetNameAscending : DisplayOrder.NetNameDescending;
            int ret = this.compare(sc0, sc1);
            this.order = save;
            return ret;
        }
    }

    public static class SchedConnRouterSorter
    implements Comparator<SchedConn> {
        boolean calculate = false;

        public SchedConnRouterSorter(boolean calc) {
            this.calculate = calc;
        }

        @Override
        public int compare(SchedConn sc0, SchedConn sc1) {
            if (this.calculate) {
                Long l0 = sc0.getWorstCaseLength();
                Long l1 = sc1.getWorstCaseLength();
                if (l0 == null && l1 != null) {
                    return 1;
                }
                if (l1 == null && l0 != null) {
                    return -1;
                }
                if (l1 == null && l0 == null) {
                    if (sc0.getPortA() == null) {
                        return 1;
                    }
                    return -1;
                }
                return AUtil.compare((Comparable)l0, (Object)l1);
            }
            Integer p0 = RouteQueue.getPriority(sc0);
            Integer p1 = RouteQueue.getPriority(sc1);
            return AUtil.compare((Comparable)p0, (Object)p1);
        }
    }

    public class RouteQueueOverlay
    extends JComponent {
        protected DesignCanvas2D.XForm w2s;
        boolean mDrawing = false;
        Layer layer;
        ArrayList<SchedConn> interfaceList = new ArrayList();
        HashSet<SchedConn> primList = new HashSet();
        HashSet<SchedConn> secondList = new HashSet();
        HashSet<Rake> rakes = new HashSet();
        Graphics2D g;

        public RouteQueueOverlay() {
            this.setOpaque(false);
            this.setDoubleBuffered(true);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        public void setInterfaceList(List<SchedConn> interfaceList) {
            for (SchedConn sc : interfaceList) {
                assert (sc.getDb() != null);
                assert (sc.getOwner() != null);
            }
            this.interfaceList.addAll(interfaceList);
            this.repaint();
        }

        public void setRakes(Set<Rake> rakes) {
            this.rakes = new HashSet<Rake>(rakes);
        }

        public void setSchedConn(HashSet<SchedConn> primList, HashSet<SchedConn> secondList) {
            this.primList = primList;
            this.secondList = secondList;
            this.repaint();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (RouteQueue.this.mSimple) {
                DesignView2D view = (DesignView2D)OrbitIO.getCurView();
                RouteQueue.theRouteQueue.crossProbingMouseAdapter = new CrossProbingMouseAdapter();
                view.getCanvas().addMouseListener(RouteQueue.this.crossProbingMouseAdapter);
            }
        }

        @Override
        public void removeNotify() {
            DesignView2D view;
            super.removeNotify();
            if (RouteQueue.this.mSimple && (view = (DesignView2D)OrbitIO.getCurView()) != null && theRouteQueue != null && RouteQueue.theRouteQueue.crossProbingMouseAdapter != null) {
                view.getCanvas().removeMouseListener(RouteQueue.theRouteQueue.crossProbingMouseAdapter);
                RouteQueue.theRouteQueue.crossProbingMouseAdapter = null;
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (this.mDrawing) {
                return;
            }
            DesignView2D view = (DesignView2D)OrbitIO.getCurView();
            if (view == null) {
                return;
            }
            AbstractViewMode avm = (AbstractViewMode)view.getCurMode();
            if (avm == null || avm.isNavigationInProgress()) {
                return;
            }
            this.mDrawing = true;
            this.g = (Graphics2D)graphics;
            Stroke oldStroke = this.g.getStroke();
            Color oldColor = this.g.getColor();
            this.w2s = view.getCanvas().getXForm();
            this.g.setStroke(new BasicStroke(4.0f, 1, 1));
            this.g.setColor(Color.green);
            for (SchedConn sc : this.interfaceList) {
                if (sc.getDb() == null || !WbFcFeasibilityUI.getRoutes(sc).isEmpty() || RouteQueue.this.mSimple || !sc.isValidBoth()) continue;
                this.g.setColor(Color.RED);
                this.drawSchedConn(this.g, sc);
            }
            this.g.setColor(Color.yellow);
            for (SchedConn sc : this.secondList) {
                if (!sc.isValidBoth()) continue;
                this.drawSchedConn(this.g, sc);
            }
            this.g.setColor(Color.white);
            for (SchedConn sc : this.primList) {
                if (!sc.isValidBoth()) continue;
                this.drawSchedConn(this.g, sc);
            }
            this.g.setColor(oldColor);
            this.g.setStroke(oldStroke);
            this.g.setStroke(new BasicStroke(1.0f, 0, 1));
            this.mDrawing = false;
        }

        protected void drawShowMe() {
            Rectangle bounds = RouteQueue.this.mRouteQueueTable.getVisibleRect();
            for (int row = 0; row < RouteQueue.this.mRouteQueueModel.getRowCount(); ++row) {
                Rectangle result = RouteQueue.this.mRouteQueueTable.getCellRect(row, -1, true);
                Insets i = RouteQueue.this.mRouteQueueTable.getInsets();
                result.x = i.left;
                result.width = RouteQueue.this.mRouteQueueTable.getWidth() - i.left - i.right;
                Point from = new Point((int)result.getMaxX() - 2, (int)result.getCenterY());
                if (!bounds.contains(from)) continue;
                from = SwingUtilities.convertPoint(RouteQueue.this.mRouteQueueTable, from, this);
                SchedConn sc = RouteQueue.this.mRouteQueueModel.routeQueueRows.get((int)row).fromto;
                APoint2D to = sc.getDPPB().getWorldLoc();
                Point p1 = this.w2s.getScreenPt(to);
                this.g.drawLine(from.x, from.y, p1.x, p1.y);
            }
        }

        protected void drawScreenSched(int row) {
            Point p = new Point(100, 50);
            p = SwingUtilities.convertPoint(RouteQueue.this.mRouteQueueTable, p, this);
            ALog.logInfo((String)(p.getX() + " " + p.getY()));
        }

        protected void drawFromPin(Graphics2D g, HierPort hp) {
            if (hp == null) {
                return;
            }
            if (hp.getDPort() == null) {
                return;
            }
            PortTemplate pt = hp.getDPort();
            if (pt.getPinTemplate().getIsVirtual()) {
                return;
            }
            DevicePath devPath = hp.getPath();
            if (!devPath.getDeviceTemplate().getType().equals((Object)DeviceTemplate.Type.PAD)) {
                return;
            }
            ARect r = devPath.getBB();
            if (r == null) {
                return;
            }
            Rectangle screenRect = this.w2s.getScreenRect(r);
            g.draw(screenRect);
        }

        protected void drawToPin(Graphics2D g, HierPort hp) {
            if (hp == null) {
                return;
            }
            if (hp.getDPort() == null) {
                return;
            }
            if (hp.getPath() == null) {
                return;
            }
            PortTemplate pt = hp.getDPort();
            if (pt.getPinTemplate().getIsVirtual()) {
                return;
            }
            DevicePath devPath = hp.getPath();
            ARect r = pt.getBounds();
            if (r == null) {
                return;
            }
            ARect transformedR = r.transform(devPath.getTransform()).getBounds();
            Rectangle rs = this.w2s.getScreenRect(transformedR);
            g.draw(rs);
        }

        protected void drawWire(Graphics2D g, Wire w, DevicePath p) {
            APath path = w.getPath();
            int screenWidth = this.w2s.getScreenLength(path.getWidth());
            if (screenWidth == 0) {
                screenWidth = 1;
            }
            Paint oldPaint = g.getPaint();
            ViewColorizer colorizer = OrbitIO.getCurColorizer();
            APatternColor color = colorizer.getColor(p, w);
            if (color == null) {
                return;
            }
            Color baseColor = g.getColor();
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, color.getColor(), 2.0f, 2.0f, baseColor, true);
            g.setPaint(gradient);
            AffineTransform t = p.getTransform();
            GeneralPath screenPath = new GeneralPath();
            for (APoint2D pt : path.getPoints()) {
                APoint2D worldPoint = pt.transform(t);
                Point screenPt = this.w2s.getScreenPt(worldPoint);
                if (screenPath.getCurrentPoint() == null) {
                    screenPath.moveTo(screenPt.x, screenPt.y);
                    continue;
                }
                screenPath.lineTo(screenPt.x, screenPt.y);
            }
            Stroke oldStroke = g.getStroke();
            g.setStroke(DesignCanvas2D.getWireStroke(w, screenWidth));
            g.draw(screenPath);
            g.setStroke(oldStroke);
            g.setPaint(oldPaint);
        }

        protected void drawSchedConn(Graphics2D g, SchedConn sc) {
            if (sc.getHierPortA() != null && sc.getHierPortB() != null && sc.getHierPortA().getDPort() != null && sc.getHierPortB().getDPort() != null && sc.getHierPortB().getPath() != null && sc.getHierPortA().getPath() != null) {
                APoint2D from = sc.getHierPortA().getWorldLoc();
                DevicePath aFromPath = ((DevicePath)sc.getHierPortA().first).getRoot().getAnInstance().getADevicePath();
                from = from.transform(aFromPath.getTransform());
                APoint2D to = sc.getHierPortB().getWorldLoc();
                DevicePath aToPath = null;
                aToPath = ((DevicePath)sc.getHierPortB().first).getRoot() != Design.getDesign((Db)OrbitIO.getCurDb(), (boolean)true) ? ((DevicePath)sc.getHierPortB().first).getRoot().getAnInstance().getADevicePath() : ((DevicePath)sc.getHierPortB().first).getFirst().getTemplate().getAnInstance().getADevicePath();
                to = to.transform(aToPath.getTransform());
                Point p0 = this.w2s.getScreenPt(from);
                Point p1 = this.w2s.getScreenPt(to);
                LinkedList<Wire> wires = WbFcFeasibilityUI.getRoutes(sc);
                if (wires.size() > 0) {
                    DevicePath aPath = sc.getOwningTemplate().getAnInstance().getADevicePath();
                    this.drawWire(g, wires.get(0), aPath);
                } else {
                    g.drawLine(p0.x, p0.y, p1.x, p1.y);
                }
            }
            this.drawFromPin(g, RouteQueue.fullPathHierPort(sc.getHierPortA()));
            this.drawToPin(g, RouteQueue.fullPathHierPort(sc.getHierPortB()));
        }
    }

    public class CrossProbingMouseAdapter
    extends MouseAdapter {
        @Override
        public void mouseDragged(MouseEvent e) {
            ALog.logInfo((String)"drag");
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            DesignView2D view = (DesignView2D)OrbitIO.getCurView();
            APoint2D worldPoint = view.getCanvas().getWorldPt(p);
            Design design = Design.getDesign((Db)OrbitIO.getCurDb());
            for (HierInst hdbo : design.getObjectsAt(worldPoint)) {
                PortTemplate pt;
                HierPort hp;
                DbObject dbo = hdbo.getDbObject();
                Net selectedNet = null;
                if (dbo instanceof Wire) {
                    Wire w = (Wire)dbo;
                    selectedNet = w.getNet();
                    selectedNet = NetMap.getTopmostNet((Net)selectedNet, (DevicePath)hdbo.getPath());
                } else if (dbo instanceof PortTemplate && (selectedNet = (hp = new HierPort((DevicePath)hdbo.first, pt = (PortTemplate)dbo)).getTopMostNet()) == null) continue;
                if (selectedNet == null) continue;
                for (int row = 0; row < RouteQueue.theRouteQueue.mRouteQueueModel.getRowCount(); ++row) {
                    RouteQueueRow rqr = RouteQueue.theRouteQueue.mRouteQueueModel.getRow(row);
                    Net n = rqr.fromto.getHierPortA().getTopMostNet();
                    if (n == null || n != selectedNet) continue;
                    if (!e.isShiftDown()) {
                        RouteQueue.theRouteQueue.mRouteQueueTable.clearSelection();
                    }
                    RouteQueue.theRouteQueue.mRouteQueueTable.addRowSelectionInterval(row, row);
                }
            }
        }
    }

    class RouteQueueModel
    extends AbstractTableModel {
        Personality p;
        ArrayList<RouteQueueRow> routeQueueRows = new ArrayList();

        public RouteQueueRow getRow(int row) {
            return this.routeQueueRows.get(row);
        }

        public RouteQueueModel(List<String> pKeyStrList) {
        }

        public RouteQueueModel(String pKeyStr) {
            Design design = OrbitIO.getCurDesign();
            Db db = design.getDb();
            Personality p = Personality.getByKeyStr((Db)db, (String)pKeyStr);
            if (p == null) {
                ALog.logWarn((String)"Invalid Personality '%s'.", (Object[])new Object[]{pKeyStr});
                return;
            }
            this.p = p;
        }

        public void buildTableFromSchedConn() {
            boolean toggleFlag = true;
            this.routeQueueRows.clear();
            RouteQueue.this.mRouteQueueTable.clearSelection();
            for (String s : mPerStrList) {
                toggleFlag = !toggleFlag;
                Personality per = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, s);
                LinkedList<SchedConn> list = new LinkedList<SchedConn>();
                for (SchedConn sc : per.getSchedConns()) {
                    boolean duplicate = false;
                    for (SchedConn existing : list) {
                        if (existing.getDevicePathA() == null || sc.getDevicePathA() == null || existing.getPortA() == null || sc.getPortA() == null || !existing.getDevicePathA().equals((Object)sc.getDevicePathA()) || !existing.getPortA().equals(sc.getPortA())) continue;
                        duplicate = true;
                    }
                    if (duplicate) continue;
                    list.add(sc);
                }
                DisplayOrder disOrder = RouteQueue.this.displayOrder;
                Bundle bundle = Bundle.getBundle((Personality)per);
                if (bundle != null) {
                    ArrayList pts = RouteQueue.isFixedSide(bundle, per) ? bundle.getRakePattern(true) : bundle.getRakePattern(false);
                    ALine line = new ALine((APoint2D)pts.get(0), (APoint2D)pts.get(pts.size() - 1));
                    double angle = Math.round(line.getAngle());
                    disOrder = angle >= 0.0 && angle < 90.0 ? DisplayOrder.SeqOrderAscending : (angle >= 90.0 && angle < 180.0 ? DisplayOrder.SeqOrder : (angle >= 180.0 && angle < 270.0 ? DisplayOrder.SeqOrder : DisplayOrder.SeqOrderAscending));
                }
                Collections.sort(list, new SchedConnDisplaySorter(disOrder, per));
                for (SchedConn sc : list) {
                    RouteQueueRow rqr = new RouteQueueRow();
                    assert (sc.getOwner() != null);
                    rqr.fromto = sc;
                    rqr.per = per;
                    rqr.toggleFlag = toggleFlag;
                    this.routeQueueRows.add(rqr);
                }
            }
            RouteQueue.this.updateStatus();
        }

        @Override
        public int getColumnCount() {
            return RouteQueue.this.columnNames.size();
        }

        @Override
        public String getColumnName(int col) {
            return RouteQueue.this.columnNames.get(col);
        }

        public Class<?> getRowClass(int r) {
            return this.getValueAt(r, RouteQueue.this.netNameColumn).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.routeQueueRows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }

        public void moveToTop(int r) {
            RouteQueueRow rqr = this.routeQueueRows.get(r);
            this.routeQueueRows.remove(r);
            this.routeQueueRows.add(0, rqr);
            int i = 0;
            for (RouteQueueRow ith : this.routeQueueRows) {
                SchedConn sc = ith.fromto;
                RouteQueue.setPriority(sc, i++);
            }
            RouteQueue.this.saveSchedPersonality();
        }

        public void moveToBottom(int r) {
            RouteQueueRow rqr = this.routeQueueRows.get(r);
            this.routeQueueRows.remove(r);
            this.routeQueueRows.add(rqr);
            int i = 0;
            for (RouteQueueRow ith : this.routeQueueRows) {
                SchedConn sc = ith.fromto;
                RouteQueue.setPriority(sc, i++);
            }
            RouteQueue.this.saveSchedPersonality();
        }
    }

    public static class SelectToPinAction
    implements InteractiveFilteredPortSelectMode.LoadListener {
        protected boolean inSelected(ArrayList<HierPort> selected, HierPort thisOne) {
            if (thisOne == null) {
                return false;
            }
            for (HierPort hp : selected) {
                if (!((DevicePath)hp.first).getLast().equals(((DevicePath)thisOne.first).getLast()) || !((PortTemplate)hp.second).equals(thisOne.second)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void onOverPin(HierPort hp, boolean chosen) {
            if (hp == null) {
                return;
            }
            Rectangle rect = null;
            if (chosen) {
                ArrayList<HierPort> selected = RouteQueue.theRouteQueue.mPinSelectMode.getSelectedPorts();
                int rows = RouteQueue.theRouteQueue.mRouteQueueModel.getRowCount();
                RouteQueue.theRouteQueue.mRouteQueueTable.clearSelection();
                for (int row = 0; row < rows; ++row) {
                    HierPort rowFromPinHP;
                    RouteQueueRow rqr = RouteQueue.theRouteQueue.mRouteQueueModel.getRow(row);
                    HierPort rowToPinHP = rqr.fromto.getHierPortB();
                    if (this.inSelected(selected, rowToPinHP)) {
                        RouteQueue.theRouteQueue.mRouteQueueTable.addRowSelectionInterval(row, row);
                        rect = RouteQueue.theRouteQueue.mRouteQueueTable.getCellRect(row, 0, true);
                    }
                    if (!this.inSelected(selected, rowFromPinHP = rqr.fromto.getHierPortA())) continue;
                    RouteQueue.theRouteQueue.mRouteQueueTable.addRowSelectionInterval(row, row);
                    rect = RouteQueue.theRouteQueue.mRouteQueueTable.getCellRect(row, 0, true);
                }
                theRouteQueue.updateSelectionChangedStatus();
            }
            if (rect != null) {
                RouteQueue.theRouteQueue.mRouteQueueTable.scrollRectToVisible(rect);
                RouteQueue.theRouteQueue.mRouteQueueTable.repaint();
            }
        }

        @Override
        public void leavingMode() {
            if (theRouteQueue == null) {
                return;
            }
            RouteQueue.theRouteQueue.mShowMeMode.setSelected(false);
            RouteQueue.theRouteQueue.mPinSelectMode = null;
            theRouteQueue.showMeChanged();
            theRouteQueue.updateUI();
        }
    }

    public static class ChangeToPinAssignment
    implements InteractiveFilteredPortSelectMode.LoadListener {
        @Override
        public void onOverPin(HierPort hp, boolean chosen) {
            RouteQueueRow rqr = RouteQueue.theRouteQueue.mRouteQueueModel.routeQueueRows.get(RouteQueue.theRouteQueue.mCurRow);
            if (chosen) {
                rqr.fromto.setPortB(hp.getPath(), hp.getDPort());
                Net fromNet = rqr.fromto.getHierPortA().getSubstrateNet();
                Net toNet = rqr.fromto.getHierPortB().getSubstrateNet();
                if (fromNet != toNet) {
                    ALog.logWarn((String)("The " + mPersonality2Personalizer.get(rqr.per).getColumnToName() + " net will change to " + fromNet.getName()));
                    NetMap.mapThroughPath((DevicePath)rqr.fromto.getHierPortB().getPath(), (PinInstance)rqr.fromto.getHierPortB().getPin(), (String)fromNet.getName());
                }
                theRouteQueue.saveSchedPersonality();
                RouteQueue.theRouteQueue.mRouteQueueTable.updateUI();
                theRouteQueue.rebuildPrimSecondList();
                RouteQueue.theRouteQueue.mPinSelectMode.uninstallMode();
                theRouteQueue.updateSelectionChangedStatus();
            } else if (hp != null) {
                RouteQueue.theRouteQueue.editingToPin = hp;
                rqr.editing = true;
            } else {
                rqr.editing = false;
            }
            RouteQueue.theRouteQueue.mRouteQueueTable.repaint();
        }

        @Override
        public void leavingMode() {
            RouteQueue.theRouteQueue.mPinSelectMode = null;
        }
    }

    class InteractiveEditModeListener
    implements AbstractViewMode.ViewModeListener {
        InteractiveEditModeListener() {
        }

        @Override
        public void modeUninstalled() {
            RouteQueue.this.mInteractiveRouteEditMode.removeViewModeListener(this);
            RouteQueue.this.mInteractiveRouteEditMode = null;
            DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
            if (v2 != null) {
                v2.addOverlay(RouteQueue.this.rqo);
            }
        }

        @Override
        public void modeInstalled() {
        }
    }

    static class MyDynamicRoutePainter
    implements InteractiveRouteEditMode.OverlayPainter {
        SchedConn sc;

        MyDynamicRoutePainter() {
        }

        public void setSchedConn(SchedConn sc) {
            this.sc = sc;
        }

        protected void drawIOPad(Graphics2D g, HierPort hp) {
            PortTemplate pt = hp.getDPort();
            DevicePath devPath = hp.getPath();
            ARect r = pt.getBounds();
            if (r == null) {
                return;
            }
            ARect transformedR = new ARect(devPath.transformPt(r.getLL()), devPath.transformPt(r.getUR()));
            DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
            DesignCanvas2D.XForm w2s = v2.getCanvas().getXForm();
            Rectangle screenRect = w2s.getScreenRect(transformedR);
            g.fill(screenRect);
            g.fillRect(100, 100, 100, 100);
        }

        protected void paintMe(Graphics2D g) {
            Color oldColor = g.getColor();
            g.setColor(Color.yellow);
            this.drawIOPad(g, this.sc.getHierPortB());
            g.setColor(oldColor);
        }

        @Override
        public void paintOverlay(Graphics2D g) {
            this.paintMe(g);
        }
    }

    protected class DelWireListener
    implements ActionListener {
        Wire w;

        protected DelWireListener() {
        }

        public void setSchedConn(Wire w) {
            this.w = w;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.w.deleteFromDb();
            OrbitIO.getApp().refreshCurrentView(false);
            RouteQueue.this.updateUI();
        }
    }

    class AddToRuleSet
    extends AbstractAction {
        protected final RuleSet rs;

        public AddToRuleSet(RuleSet rs) {
            super(rs.getName(), (Icon)new AColorIcon(16, 16, rs.getColor()));
            this.rs = rs;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int row : RouteQueue.this.mRouteQueueTable.getSelectedRows()) {
                RouteQueueRow rqr = RouteQueue.this.mRouteQueueModel.getRow(row);
                SchedConn sc = rqr.fromto;
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addToRuleSet (\"%s\", \"%s\");", (Object[])new Object[]{this.rs.getKeyStr(), sc.getHierPortA().getPin().getKeyStr()});
            }
            RouteQueue.this.updateUI();
        }
    }

    class AddToPersonality
    implements ActionListener {
        Personality p;

        public AddToPersonality(Personality p) {
            this.p = p;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int row : RouteQueue.this.mRouteQueueTable.getSelectedRows()) {
                PinInstance pi;
                RouteQueueRow rqr = RouteQueue.this.mRouteQueueModel.getRow(row);
                SchedConn sc = rqr.fromto;
                if (sc.getDPPA() != null) {
                    pi = sc.getDPPA().getPin();
                    Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.addPinToPersonality(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{pi.getKeyStr(), this.p.getKeyStr()});
                }
                if (sc.getDPPB() == null) continue;
                pi = sc.getDPPB().getPin();
                Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.addPinToPersonality(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{pi.getKeyStr(), this.p.getKeyStr()});
            }
            RouteQueue.this.updateUI();
        }
    }

    class TableButtonMouseListener
    extends MouseAdapter {
        protected JTable table;
        JPopupMenu popup;

        public TableButtonMouseListener(JTable table) {
            this.table = table;
        }

        protected void showPopup(MouseEvent e) {
            int row = e.getY() / this.table.getRowHeight();
            if (row >= RouteQueue.this.mRouteQueueTable.getRowCount()) {
                return;
            }
            RouteQueue.this.mCurRow = row;
            RouteQueue.this.curStartPin = RouteQueue.this.getCol(e.getX());
            Personality p = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, mPerStrList.getFirst());
            RouteQueueRow rqr = RouteQueue.this.mRouteQueueModel.routeQueueRows.get(row);
            SchedConn sc = rqr.fromto;
            this.popup = new JPopupMenu();
            Substrate theSubstrate = p.getOwner().getSubstrate();
            int numSelected = RouteQueue.this.mRouteQueueTable.getSelectedRowCount();
            if (numSelected == 1) {
                if (!RouteQueue.this.mSimple) {
                    JMenuItem moveUpMenuItem = new JMenuItem("Move to Top");
                    this.popup.add(moveUpMenuItem);
                    JMenuItem moveDnMenuItem = new JMenuItem("Move to Bottom");
                    this.popup.add(moveDnMenuItem);
                    JMenuItem removeItem = new JMenuItem("Remove From Route Group");
                    this.popup.add(removeItem);
                    removeItem.addActionListener(RouteQueue.this.removeAction);
                    this.popup.addSeparator();
                    JMenuItem selectNewPinSame = new JMenuItem("Select new " + mPersonality2Personalizer.get(rqr.per).getColumnToName() + " of same Net");
                    selectNewPinSame.addActionListener(RouteQueue.this.mSelectNewToPinSame);
                    JMenuItem selectNewPinAny = new JMenuItem("Select new " + mPersonality2Personalizer.get(rqr.per).getColumnToName() + " (any net)");
                    selectNewPinAny.addActionListener(RouteQueue.this.mSelectNewToPinAny);
                    this.popup.add(selectNewPinSame);
                    this.popup.add(selectNewPinAny);
                    this.popup.addSeparator();
                }
                boolean thereIsAValidPin = true;
                RuleSet rs = null;
                if (sc.getHierPortA() != null && sc.getHierPortA().getPin() != null) {
                    rs = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin());
                    if (rs != null && !RouteQueue.isRuleSetApplicable(rqr.per, rs)) {
                        rs = null;
                    }
                } else {
                    thereIsAValidPin = false;
                }
                boolean thereIsACurrentRule = rs != null;
                JMenuItem editRule = new JMenuItem(RouteQueue.this.editRuleAction);
                JMenuItem createRule = new JMenuItem(RouteQueue.this.createRuleAction);
                JMenuItem applyToNet = new JMenuItem(RouteQueue.this.applyToNetAction);
                JMenuItem applyToInterface = new JMenuItem("Apply This Rule For Route Group");
                applyToInterface.addActionListener(RouteQueue.this.applyToInterfaceListener);
                JMenu useExisting = new JMenu("Use Existing Rule...");
                for (RuleSet srs : theSubstrate.getRuleSets()) {
                    if (!srs.isTopLevel()) continue;
                    JMenuItem p1 = new JMenuItem(new AddToRuleSet(srs));
                    ((Container)useExisting).add(p1);
                }
                if (thereIsACurrentRule) {
                    this.popup.add(editRule);
                    this.popup.add(applyToNet);
                    this.popup.add(applyToInterface);
                }
                if (thereIsAValidPin) {
                    this.popup.add(createRule);
                    this.popup.add(useExisting);
                    this.popup.addSeparator();
                }
                JMenu p0 = new JMenu("Add To Personality");
                for (DeviceTemplate devTemp : theSubstrate.getDeviceTemplates()) {
                    Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT).forEach(personality -> {
                        if (personality.getType() == Personality.Type.PORT) {
                            JMenuItem p1 = new JMenuItem(personality.getOwner().getName() + ":" + personality.getName());
                            AColorIcon icon = new AColorIcon(16, 16, personality.getColor());
                            p1.setIcon((Icon)icon);
                            p1.addActionListener(new AddToPersonality((Personality)personality));
                            p0.add(p1);
                        }
                    });
                }
                this.popup.add(p0);
            } else {
                if (!RouteQueue.this.mSimple) {
                    JMenuItem moveUpMenuItem = new JMenuItem("Move to Top (" + numSelected + ")");
                    this.popup.add(moveUpMenuItem);
                    JMenuItem moveDnMenuItem = new JMenuItem("Move to Bottom (" + numSelected + ")");
                    this.popup.add(moveDnMenuItem);
                    this.popup.addSeparator();
                    JMenuItem toggleItem = new JMenuItem("Toggle Fix Status (" + numSelected + ")");
                    this.popup.add(toggleItem);
                    toggleItem.addActionListener(RouteQueue.this.toggleStatus);
                    this.popup.addSeparator();
                    JMenuItem removeItem = new JMenuItem("Remove From Route Group (" + numSelected + ")");
                    this.popup.add(removeItem);
                    removeItem.addActionListener(RouteQueue.this.removeAction);
                    this.popup.addSeparator();
                    moveUpMenuItem.addActionListener(RouteQueue.this.mMoveToTop);
                    moveDnMenuItem.addActionListener(RouteQueue.this.mMoveToBottom);
                }
                JMenu useExisting = new JMenu("Use Existing Rule...");
                for (RuleSet rs : theSubstrate.getRuleSets()) {
                    if (!rs.isTopLevel()) continue;
                    JMenuItem p1 = new JMenuItem(rs.getName());
                    AColorIcon icon = new AColorIcon(16, 16, rs.getColor());
                    p1.setIcon((Icon)icon);
                    p1.addActionListener(new AddToRuleSet(rs));
                    useExisting.add(p1);
                }
                this.popup.add(useExisting);
                this.popup.addSeparator();
                JMenu p0 = new JMenu("Add  To Personality  (" + numSelected + ")");
                for (DeviceTemplate devTemp : theSubstrate.getDeviceTemplates()) {
                    Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT).forEach(personality -> {
                        JMenuItem p1 = new JMenuItem(personality.getOwner().getName() + ":" + personality.getName());
                        AColorIcon icon = new AColorIcon(16, 16, personality.getColor());
                        p1.setIcon((Icon)icon);
                        p1.addActionListener(new AddToPersonality((Personality)personality));
                        p0.add(p1);
                    });
                }
                this.popup.add(p0);
            }
            JMenuItem showMeItem = new JMenuItem("Show Me");
            this.popup.add(showMeItem);
            showMeItem.addActionListener(RouteQueue.this.mShowMeActionListener);
            JMenuItem zoomToItem = new JMenuItem("Zoom to");
            this.popup.add(zoomToItem);
            zoomToItem.addActionListener(RouteQueue.this.mZoomToAction);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            } else {
                int column = RouteQueue.this.getCol(e.getX());
                int row = e.getY() / this.table.getRowHeight();
                if (row >= 0 && row < RouteQueue.this.mRouteQueueModel.getRowCount() && column == RouteQueue.this.ignoreRouteColumn) {
                    Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.ignoreSchedConn(%d)", (Object[])new Object[]{row});
                }
                RouteQueue.this.updateUI();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }
    }

    public class RouteQueueCellRenderer
    extends DefaultTableCellRenderer {
        protected ArrayList<PinTemplate> ioPorts = null;
        protected DeviceTemplate lastDT = null;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            Personality p;
            DevicePath dp;
            String text;
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            RouteQueueRow rqr = RouteQueue.this.mRouteQueueModel.getRow(row);
            Color lightGreen = new Color(0, 255, 0, 100);
            this.setIcon(null);
            this.setText(null);
            this.setForeground(Color.black);
            this.setBackground(rqr.toggleFlag ? lightGreen : Color.white);
            this.setToolTipText("");
            Wire w = null;
            HierPort fromPort = rqr.fromto.getHierPortA();
            boolean noFromPort = true;
            SchedConn sc = rqr.fromto;
            if (sc.getDb() == null) {
                this.setText("[Not in Db]");
                return this;
            }
            if (fromPort != null && fromPort.getDPort() != null) {
                noFromPort = false;
                LinkedList<Wire> wires = WbFcFeasibilityUI.getRoutes(sc);
                if (wires.size() > 0) {
                    w = wires.get(0);
                }
            }
            if (isSelected) {
                this.setBackground(Color.orange);
            }
            if (column == RouteQueue.this.routeStatusColumn) {
                CompletionStatus cs = RouteQueue.getCompletionStatus(sc);
                AColorIcon icon = null;
                if (cs == CompletionStatus.All) {
                    icon = new AColorIcon(16, Color.GREEN);
                } else if (cs == CompletionStatus.None) {
                    icon = new AColorIcon(16, Color.RED);
                } else if (cs == CompletionStatus.Partial) {
                    icon = new AColorIcon(16, Color.ORANGE);
                }
                if (icon != null) {
                    icon.setWhiteBackground(false);
                    this.setIcon((Icon)icon);
                }
            }
            if (column == RouteQueue.this.ignoreRouteColumn && RouteQueue.getIgnore(rqr.fromto)) {
                this.setIcon(OrbitIcons.LOCK);
            }
            if (column == RouteQueue.this.netNameColumn) {
                if (!noFromPort) {
                    Net n = rqr.fromto.getHierPortA().getSubstrateNet();
                    if (showSubstrateNetName) {
                        this.setText(n.getName());
                    } else {
                        this.setText(rqr.fromto.getHierPortA().getTopMostNet().getName());
                    }
                    if (n.isUnused()) {
                        this.setBackground(Color.yellow);
                    }
                    int before = 0;
                    for (int r = 0; r < row; ++r) {
                        if (RouteQueue.getIgnore(RouteQueue.this.mRouteQueueModel.getRow((int)r).fromto)) continue;
                        ++before;
                    }
                    this.setToolTipText("Route Order " + before);
                }
            } else if (column == RouteQueue.this.ruleNameColumn) {
                RuleSet rs;
                if (sc.getHierPortA() != null && sc.getHierPortA().second != null && sc.getHierPortA().first != null && (rs = RuleSetMgr.getMyRuleSet((DbObject)sc.getHierPortA().getPin())) != null && RouteQueue.isRuleSetApplicable(rqr.per, rs)) {
                    this.setForeground(rs.getColor());
                    this.setText(rs.getName());
                }
            } else if (column == RouteQueue.this.lengthNameColumn) {
                ALine l = sc.getLineIncludingViaToIOPad();
                Long length = null;
                if (l != null) {
                    length = Math.abs(l.dX()) + Math.abs(l.dY());
                }
                this.setText("");
                if (l != null) {
                    Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
                    if (RouteQueue.this.lengthMode.equals(RouteQueue.SHOWMLENGTH)) {
                        this.setText(unit.toUserStr(length.longValue()));
                    } else if (RouteQueue.this.lengthMode.equals(RouteQueue.SHOWRLENGTH)) {
                        if (w != null) {
                            this.setText(unit.toUserStr(w.getLength()));
                        }
                    } else if (RouteQueue.this.lengthMode.equals(RouteQueue.SHOWRES)) {
                        if (w != null) {
                            Layer layer = w.getLayer();
                            double r = layer.getResistance();
                            double width = w.getWidth();
                            double tl = w.getLength();
                            double tr = r * tl / width;
                            this.setText(Double.toString(tr));
                        }
                    } else if (w != null) {
                        double tl = w.getLength();
                        double ml = length.longValue();
                        long e = Math.round(ml / tl * 100.0);
                        this.setText(Long.toString(e));
                    }
                }
            } else if (column == RouteQueue.this.fromPadNameColumn) {
                text = "?";
                if (rqr.fromto.getHierPortA() == null || rqr.fromto.getHierPortA().getDPort() == null) {
                    text = "Not Assigned";
                } else {
                    if (RouteQueue.this.fromPadShowMode.equals(RouteQueue.SHOWNET)) {
                        text = rqr.fromto.getHierPortA().getSubstrateNet().getName();
                    } else if (RouteQueue.this.fromPadShowMode.equals(RouteQueue.SHOWDEVICE)) {
                        text = "";
                        dp = rqr.fromto.getDevicePathA();
                        if (dp.isEmpty()) {
                            DeviceTemplate dt = dp.getRoot();
                            if (dt != null) {
                                text = dt.getAnInstance().getName();
                            }
                        } else {
                            text = dp.getLast().getName();
                        }
                    } else if (RouteQueue.this.fromPadShowMode.equals(RouteQueue.SHOWPATH)) {
                        text = rqr.fromto.getHierPortA().getPath().toString();
                    } else if (RouteQueue.this.fromPadShowMode.equals(RouteQueue.SHOWPIN)) {
                        text = rqr.fromto.getHierPortA().getDPort().getPinTemplate().getName();
                    }
                    p = Net.isDiffPair((Net)rqr.fromto.getHierPortA().getNet(), (DevicePath)rqr.fromto.getHierPortA().getPath());
                    if (p != null) {
                        this.setIcon((Icon)new AColorIcon(10, 10, p.getColor()));
                    } else {
                        this.setIcon(null);
                    }
                }
                this.setText(text);
            } else if (column == RouteQueue.this.toPadNameColumn) {
                text = "?";
                if (rqr.editing) {
                    this.setForeground(Color.BLUE);
                    if (RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWNET)) {
                        text = RouteQueue.this.editingToPin.getSubstrateNet().getName();
                    } else if (RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWDEVICE)) {
                        text = "";
                        dp = RouteQueue.this.editingToPin.getPath();
                        if (dp.size() == 0) {
                            DeviceTemplate dt = dp.getRoot();
                            if (dt != null) {
                                text = dt.getAnInstance().getName();
                            }
                        } else {
                            text = dp.getLast().getName();
                        }
                    } else if (RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWPATH)) {
                        text = RouteQueue.this.editingToPin.getPath().toString();
                    } else if (RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWPIN) && (text = RouteQueue.this.editingToPin.getDPort().getPinTemplate().getName()).isEmpty()) {
                        text = RouteQueue.this.editingToPin.getDPort().getKeyStr();
                    }
                    this.setText(text);
                } else {
                    if (rqr.fromto.getPathB() == null || rqr.fromto.getHierPortB().getDPort() == null || rqr.fromto.getHierPortB().getPath() == null) {
                        text = "Not Assigned";
                    } else {
                        if (RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWNET)) {
                            text = rqr.fromto.getHierPortB().getSubstrateNet().getName();
                        } else if (RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWDEVICE)) {
                            text = "";
                            dp = rqr.fromto.getDevicePathA();
                            if (dp.size() == 0) {
                                DeviceTemplate dt = dp.getRoot();
                                if (dt != null) {
                                    text = dt.getAnInstance().getName();
                                }
                            } else {
                                text = dp.getLast().getName();
                            }
                        } else if (RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWPATH)) {
                            text = rqr.fromto.getHierPortB().getPath().toString();
                        } else if (RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWPIN)) {
                            text = rqr.fromto.getHierPortB().getDPort().getPinTemplate().getName();
                        }
                        PinInstance pi = rqr.fromto.getHierPortB().getPin();
                        Personality p2 = pi.getPersonality();
                        if (p2 != null) {
                            this.setIcon((Icon)new AColorIcon(10, 10, p2.getColor()));
                        } else {
                            this.setIcon(null);
                        }
                    }
                    this.setText(text);
                }
            } else if (column == RouteQueue.this.hintThreatenColumn) {
                boolean diffPairAdj = true;
                Personality personality = p = rqr.fromto.isValidBoth() ? Net.isDiffPair((Net)rqr.fromto.getHierPortA().getNet(), (DevicePath)rqr.fromto.getHierPortA().getPath()) : null;
                if (p != null) {
                    diffPairAdj = false;
                    Personality q = null;
                    if (row - 1 >= 0) {
                        RouteQueueRow prev = RouteQueue.this.mRouteQueueModel.getRow(row - 1);
                        q = Net.isDiffPair((Net)prev.fromto.getHierPortA().getNet(), (DevicePath)prev.fromto.getHierPortA().getPath());
                        if (p.equals(q)) {
                            diffPairAdj = true;
                        }
                    }
                    if (!diffPairAdj && row + 1 < RouteQueue.this.mRouteQueueModel.getRowCount()) {
                        RouteQueueRow next = RouteQueue.this.mRouteQueueModel.getRow(row + 1);
                        q = Net.isDiffPair((Net)next.fromto.getHierPortA().getNet(), (DevicePath)next.fromto.getHierPortA().getPath());
                        if (p.equals(q)) {
                            diffPairAdj = true;
                        }
                    }
                }
                if (!diffPairAdj) {
                    this.setIcon((Icon)new AColorIcon(16, AColor.RED));
                    this.setText("Diff Pair");
                } else {
                    int cross = RouteQueue.computeSchedConnCross(rqr, RouteQueue.this.mRouteQueueModel.routeQueueRows);
                    AColorIcon icon = null;
                    icon = cross == 0 ? new AColorIcon(16, AColor.GREEN) : (cross < RouteQueue.this.mRouteQueueModel.routeQueueRows.size() / 2 ? new AColorIcon(16, AColor.ORANGE) : new AColorIcon(16, AColor.RED));
                    if (icon != null) {
                        icon.setWhiteBackground(false);
                    }
                    this.setIcon((Icon)icon);
                    if (cross > 0) {
                        this.setText("" + cross);
                    }
                }
            }
            return this;
        }
    }

    public class ColumnHeaderRender
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (RouteQueue.this.tcr == null) {
                return null;
            }
            Component component = RouteQueue.this.tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = null;
            if (!(component instanceof JLabel)) {
                return null;
            }
            label = (JLabel)component;
            label.setToolTipText("");
            if (column == RouteQueue.this.routeStatusColumn) {
                label.setText("");
                label.setIcon(OrbitIcons.CHECK);
                label.setToolTipText("Shows if a route has fully met the rule set, right click to sort");
            } else if (column == RouteQueue.this.ignoreRouteColumn) {
                label.setText("");
                label.setIcon(OrbitIcons.LOCK);
                label.setToolTipText("Locking the connection will prevent further changes");
            } else if (column == RouteQueue.this.netNameColumn) {
                label.setToolTipText("Right clicking here allows you to sort the nets by net name");
            } else if (column == RouteQueue.this.fromPadNameColumn) {
                label.setToolTipText("Right clicking here allows you to show different features of the " + RouteQueue.this.COLFROMPAD);
            } else if (!RouteQueue.this.mSimple && column == RouteQueue.this.toPadNameColumn) {
                label.setToolTipText("Right clicking here allows you to show different features of the " + RouteQueue.this.COLTOPAD);
            } else if (!RouteQueue.this.mSimple && column == RouteQueue.this.lengthNameColumn) {
                label.setToolTipText("Right clicking here allows you to show different length representations of the connection");
            } else if (column == RouteQueue.this.ruleNameColumn) {
                label.setToolTipText("The rule to be used for the connection, right click for sorting");
            } else if (column == RouteQueue.this.hintThreatenColumn) {
                label.setToolTipText("Reflect the crossing count of schedule connection");
            }
            return component;
        }
    }

    public class RouteQueueSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (selectionChanging) {
                return;
            }
            selectionChanging = true;
            EventQueue.invokeLater(() -> {
                RouteQueue.this.activateProperArrows();
                RouteQueue.this.rebuildPrimSecondList();
                RouteQueue.this.updateSelectionChangedStatus();
                selectionChanging = false;
            });
        }
    }

    class HeaderPopupListener
    extends MouseAdapter {
        HeaderPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        protected void setColMode(String mode) {
            if (RouteQueue.this.curEditCol == RouteQueue.this.fromPadNameColumn) {
                RouteQueue.this.fromPadShowMode = mode;
            } else {
                RouteQueue.this.toPadShowMode = mode;
            }
        }

        protected void setLengthMode(String mode) {
            RouteQueue.this.lengthMode = mode;
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int x = e.getX();
                int col = RouteQueue.this.getCol(x);
                if (col == RouteQueue.this.ignoreRouteColumn) {
                    JPopupMenu pop = new JPopupMenu();
                    ButtonGroup group = new ButtonGroup();
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.FIXALL){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RouteQueue.this.setFixAll(true);
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.FREEALL){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RouteQueue.this.setFixAll(false);
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                        }
                    });
                    for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                        pop.add((JMenuItem)b);
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                if (col == RouteQueue.this.lengthNameColumn) {
                    JPopupMenu pop = new JPopupMenu();
                    ButtonGroup group = new ButtonGroup();
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWMLENGTH){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setLengthMode(RouteQueue.SHOWMLENGTH);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.lengthMode.equals(RouteQueue.SHOWMLENGTH));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWRLENGTH){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setLengthMode(RouteQueue.SHOWRLENGTH);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.lengthMode.equals(RouteQueue.SHOWRLENGTH));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWRES){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setLengthMode(RouteQueue.SHOWRES);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.lengthMode.equals(RouteQueue.SHOWRES));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWEFF){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setLengthMode(RouteQueue.SHOWEFF);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.lengthMode.equals(RouteQueue.SHOWEFF));
                        }
                    });
                    for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                        pop.add((JMenuItem)b);
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                if (col == RouteQueue.this.routeStatusColumn) {
                    if (RouteQueue.this.mSimple) {
                        return;
                    }
                    JPopupMenu pop = new JPopupMenu();
                    ButtonGroup group = new ButtonGroup();
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SORTA){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RouteQueue.this.displayOrder = DisplayOrder.CompletionStatusAscending;
                            RouteQueue.this.mRouteQueueModel.buildTableFromSchedConn();
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.displayOrder.equals((Object)DisplayOrder.CompletionStatusAscending));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SORTD){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RouteQueue.this.displayOrder = DisplayOrder.CompletionStatusDescending;
                            RouteQueue.this.mRouteQueueModel.buildTableFromSchedConn();
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.displayOrder.equals((Object)DisplayOrder.CompletionStatusDescending));
                        }
                    });
                    for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                        pop.add((JMenuItem)b);
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                if (col == RouteQueue.this.netNameColumn) {
                    if (RouteQueue.this.mSimple) {
                        JPopupMenu pop = new JPopupMenu();
                        ButtonGroup group = new ButtonGroup();
                        group.add(new JRadioButtonMenuItem(new AbstractAction("Show Substrate Net"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                showSubstrateNetName = true;
                                RouteQueue.this.columnNames.set(RouteQueue.this.netNameColumn, "Net");
                                RouteQueue.this.mRouteQueueTable.getTableHeader().getColumnModel().getColumn(RouteQueue.this.netNameColumn).setHeaderValue("Net");
                                RouteQueue.this.mRouteQueueModel.fireTableDataChanged();
                                RouteQueue.this.mRouteQueueTable.repaint();
                                RouteQueue.this.updateUI();
                            }
                        }){

                            @Override
                            public void addNotify() {
                                super.addNotify();
                                this.setSelected(showSubstrateNetName);
                            }
                        });
                        group.add(new JRadioButtonMenuItem(new AbstractAction("Show Topmost Net"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                showSubstrateNetName = false;
                                RouteQueue.this.columnNames.set(RouteQueue.this.netNameColumn, "Topmost Net");
                                RouteQueue.this.mRouteQueueTable.getTableHeader().getColumnModel().getColumn(RouteQueue.this.netNameColumn).setHeaderValue("Topmost Net");
                                RouteQueue.this.mRouteQueueModel.fireTableDataChanged();
                                RouteQueue.this.mRouteQueueTable.repaint();
                                RouteQueue.this.updateUI();
                            }
                        }){

                            @Override
                            public void addNotify() {
                                super.addNotify();
                                this.setSelected(!showSubstrateNetName);
                            }
                        });
                        for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                            pop.add((JMenuItem)b);
                        }
                        pop.show(e.getComponent(), e.getX(), e.getY());
                        return;
                    }
                    JPopupMenu pop = new JPopupMenu();
                    ButtonGroup group = new ButtonGroup();
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SORTA){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RouteQueue.this.displayOrder = DisplayOrder.NetNameAscending;
                            RouteQueue.this.mRouteQueueModel.buildTableFromSchedConn();
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.displayOrder.equals((Object)DisplayOrder.NetNameAscending));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SORTD){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RouteQueue.this.displayOrder = DisplayOrder.NetNameDescending;
                            RouteQueue.this.mRouteQueueModel.buildTableFromSchedConn();
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.displayOrder.equals((Object)DisplayOrder.NetNameDescending));
                        }
                    });
                    for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                        pop.add((JMenuItem)b);
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                if (col == RouteQueue.this.ruleNameColumn) {
                    JPopupMenu pop = new JPopupMenu();
                    ButtonGroup group = new ButtonGroup();
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SORTA){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RouteQueue.this.displayOrder = DisplayOrder.RuleNameAscending;
                            RouteQueue.this.mRouteQueueModel.buildTableFromSchedConn();
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.displayOrder.equals((Object)DisplayOrder.RuleNameAscending));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SORTD){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RouteQueue.this.displayOrder = DisplayOrder.RuleNameDescending;
                            RouteQueue.this.mRouteQueueModel.buildTableFromSchedConn();
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.displayOrder.equals((Object)DisplayOrder.RuleNameDescending));
                        }
                    });
                    for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                        pop.add((JMenuItem)b);
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                RouteQueue.this.curEditCol = col;
                JPopupMenu pop = new JPopupMenu();
                ButtonGroup group = new ButtonGroup();
                if (col == RouteQueue.this.toPadNameColumn) {
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWPIN){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setColMode(RouteQueue.SHOWPIN);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWPIN));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWDEVICE){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setColMode(RouteQueue.SHOWDEVICE);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWDEVICE));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWPATH){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setColMode(RouteQueue.SHOWPATH);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWPATH));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWNET){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setColMode(RouteQueue.SHOWNET);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.toPadShowMode.equals(RouteQueue.SHOWNET));
                        }
                    });
                    for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                        pop.add((JMenuItem)b);
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                }
                if (col == RouteQueue.this.fromPadNameColumn) {
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWPIN){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setColMode(RouteQueue.SHOWPIN);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.fromPadShowMode.equals(RouteQueue.SHOWPIN));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWDEVICE){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setColMode(RouteQueue.SHOWDEVICE);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.fromPadShowMode.equals(RouteQueue.SHOWDEVICE));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWPATH){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setColMode(RouteQueue.SHOWPATH);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.fromPadShowMode.equals(RouteQueue.SHOWPATH));
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction(RouteQueue.SHOWNET){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HeaderPopupListener.this.setColMode(RouteQueue.SHOWNET);
                            RouteQueue.this.updateUI();
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                            this.setSelected(RouteQueue.this.fromPadShowMode.equals(RouteQueue.SHOWNET));
                        }
                    });
                    for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                        pop.add((JMenuItem)b);
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    private class ActionPluginRouter
    extends AbstractAction {
        protected String cmd;

        public ActionPluginRouter(String name, String cmd) {
            super(name);
            this.cmd = cmd;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            Cp.exec((String)"OrbitIO.getCurDesign().getCurSelection().clear();", (Object[])new Object[0]);
            for (String pKeyStr : mPerStrList) {
                Personality p = (Personality)db.getByKeyStr(Personality.class, pKeyStr);
                for (SchedConn sc : p.getSchedConns()) {
                    Cp.exec((String)"OrbitIO.getCurDesign().getCurSelection().setSelected(\"%s\", \"%s\", %s);", (Object[])new Object[]{sc.getDbClass().getName(), sc.getKeyStr(), ABoolean.toString((boolean)true)});
                }
            }
            Cp.exec((String)this.cmd, (Object[])new Object[0]);
        }
    }

    protected class RouteQueueRow {
        Personality per;
        SchedConn fromto;
        boolean toggleFlag;
        DeviceTemplate routingTemplate;
        boolean editing = false;

        protected RouteQueueRow() {
        }

        public Net getNet() {
            if (this.fromto.getHierPortA() == null || this.fromto.getHierPortA().getDPort() == null) {
                return null;
            }
            return this.fromto.getHierPortA().getSubstrateNet();
        }
    }

    protected class Rake {
        protected APoint2D p;
        protected HierPort hp;

        public Rake(APoint2D p, HierPort hp) {
            this.p = p;
            this.hp = hp;
        }
    }

    protected class RouteQueueCol {
        int order;
        String name;
        int maxWidth;
        int foundWidth;
        int startWidth;

        public RouteQueueCol(int order, String name, int maxWidth) {
            this.order = order;
            this.name = name;
            this.maxWidth = maxWidth;
        }
    }

    protected class RuleSetListener
    extends DbClass.DbObjectAdapter {
        protected RuleSetListener() {
        }

        public boolean removingObject(DbClass.ObjectRemove remove) {
            if (!remove.getDbObject().getDb().getHistory().isInUndoRedo()) {
                RuleSet rs = (RuleSet)remove.getDbObject();
                RouteQueue.this.validateMissingRuleSet(rs);
            }
            return true;
        }
    }

    class ABundleChangedListener
    implements Bundle.Listener {
        ABundleChangedListener() {
        }

        public void react(String started) {
        }
    }

    protected class HistoryListener
    extends DbHistory.ListenerAdapter {
        protected HistoryListener() {
        }

        public void endUndoRedo(boolean isRedo) {
            RouteQueue.this.mRouteQueueModel.buildTableFromSchedConn();
            RouteQueue.this.updateUI();
        }
    }

    public static enum CompletionStatus {
        All,
        Partial,
        None;

    }

    public static enum DisplayOrder {
        RouteOrder,
        NetNameAscending,
        NetNameDescending,
        CompletionStatusAscending,
        CompletionStatusDescending,
        RuleNameAscending,
        RuleNameDescending,
        SeqOrder,
        SeqOrderAscending;

    }

    public static enum RouteSides {
        N,
        S,
        E,
        W;

    }
}

