/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.wb_route.RouteQueue;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.HashSet;
import java.util.LinkedList;

public class RouteQueueDlg
extends DbDialog {
    protected DbClass.DbObjectListener mDL = null;
    protected Personality mPersonality = null;
    private static RouteQueueDlg mLastDialog = null;
    protected static HashSet<Personality> mActiveRouteQs = new HashSet();

    public static RouteQueueDlg getLastDialog() {
        return mLastDialog;
    }

    public static RouteQueueDlg createDialog(Window owner, Db db, LinkedList<String> pKeyStrList, String title, boolean isFixed) {
        if (mLastDialog != null) {
            UIUtil.closeWindow((Window)((Object)mLastDialog));
        }
        RouteQueueDlg dlg = null;
        dlg = new RouteQueueDlg(db, owner);
        dlg.init(pKeyStrList, title, isFixed);
        mLastDialog = dlg;
        return dlg;
    }

    public static void addActive(Personality p) {
        mActiveRouteQs.add(p);
    }

    public static void remActive(Personality p) {
        mActiveRouteQs.remove(p);
    }

    public static boolean isActive(Personality p) {
        return mActiveRouteQs.contains(p);
    }

    public RouteQueueDlg(Db db, Window owner) {
        super(db, (Component)owner);
    }

    public void addNotify() {
        super.addNotify();
        this.mDL = new InstanceListener();
        DbClass clazz1 = this.mDb.getDbClass(Personality.class);
        clazz1.addObjectListener(this.mDL, DbClass.DbObjectEventType.getUpdated());
        RouteQueueDlg.addActive(this.mPersonality);
    }

    public void removeNotify() {
        super.removeNotify();
        RouteQueueDlg.remActive(this.mPersonality);
        mLastDialog = null;
    }

    protected void init(LinkedList<String> pKeyStrList, String title, boolean isFixed) {
        GridBagManager l = new GridBagManager(this.getContentPane());
        Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.clearRoutePersonalizerHash ();", (Object[])new Object[0]);
        for (String pKeyStr : pKeyStrList) {
            Personality p = (Personality)OrbitIO.getCurDb().getByKeyStr(Personality.class, pKeyStr);
            if (title == null) {
                this.setTitle("Route Group assignments for " + p.getName());
            } else {
                this.setTitle(title);
            }
            if (p.getType().equals((Object)Personality.Type.DIEESCAPE)) {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addToRoutePersonalizerHash (OrbitIO.getCurDb().getByKeyStr(Personality.class, \"%s\"), new com.sigrity.orbit.ui.wb_route.DieEscapePersonalizer());", (Object[])new Object[]{pKeyStr});
                continue;
            }
            if (p.getType().equals((Object)Personality.Type.PckFree)) {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addToRoutePersonalizerHash (OrbitIO.getCurDb().getByKeyStr(Personality.class, \"%s\"), new com.sigrity.orbit.ui.wb_route.PCBFreePersonalizer());", (Object[])new Object[]{pKeyStr});
                continue;
            }
            if (p.getType().equals((Object)Personality.Type.RDL)) {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addToRoutePersonalizerHash (OrbitIO.getCurDb().getByKeyStr(Personality.class, \"%s\"), new com.sigrity.orbit.ui.wb_route.RDLPersonalizer());", (Object[])new Object[]{pKeyStr});
                continue;
            }
            if (p.getType().equals((Object)Personality.Type.PCBFree)) {
                Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addToRoutePersonalizerHash (OrbitIO.getCurDb().getByKeyStr(Personality.class, \"%s\"), new com.sigrity.orbit.ui.wb_route.PCBFreePersonalizer());", (Object[])new Object[]{pKeyStr});
                continue;
            }
            if (!p.getType().equals((Object)Personality.Type.PCBFixed)) continue;
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouteQueue.addToRoutePersonalizerHash (OrbitIO.getCurDb().getByKeyStr(Personality.class, \"%s\"), new com.sigrity.orbit.ui.wb_route.PCBFixedPersonalizer());", (Object[])new Object[]{pKeyStr});
        }
        RouteQueue routeQ = new RouteQueue(pKeyStrList, isFixed);
        l.add((Component)routeQ, (GridBagConstraints)GridBagManager.FILLALL);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    protected class InstanceListener
    implements DbClass.DbObjectListener {
        protected InstanceListener() {
        }

        public boolean addingObject(DbClass.ObjectAdd add) {
            return false;
        }

        public boolean changingObject(DbClass.ObjectChange change) {
            return false;
        }

        public boolean removingObject(DbClass.ObjectRemove remove) {
            return false;
        }

        public void addedObject(DbClass.ObjectAdd add) {
        }

        public void changedObject(DbClass.ObjectChange change) {
        }

        public void removedObject(DbClass.ObjectRemove remove) {
            if (RouteQueueDlg.this.mPersonality == null) {
                return;
            }
            if (remove.getObject() == RouteQueueDlg.this.mPersonality) {
                if (mLastDialog != null) {
                    UIUtil.closeWindow((Window)((Object)mLastDialog));
                }
                mLastDialog = null;
            }
        }
    }
}

