/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.BondFingerUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DevicePathPortPair;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.router.PrettyRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.automation.router.Topstacle;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.wb_route.RouteQueue;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class RouterInterface {
    private RouterInterface() {
    }

    public static void routeVision(String personalityKey, boolean on) {
        Substrate s;
        Db db = OrbitIO.getCurDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)personalityKey);
        if (p == null) {
            ALog.logWarn((String)"Can not find route group definition");
        }
        Substrate substrate = s = p == null ? null : p.getOwner().getSubstrate();
        if (s == null) {
            return;
        }
        String routeLayerString = null;
        Constraint l = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTE_LAYER);
        if (l == null) {
            return;
        }
        routeLayerString = ((Layer)l.getValue()).getName();
        Layer routeLayer = s.getLayer(routeLayerString);
        DesignCanvas2D dv2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
        ViewColorizer colorizer = dv2d.getColorizer();
        for (Layer thisLayer : s.getLayers(null)) {
            ViewColorizer.LayerKey lk = colorizer.getLayerKey(thisLayer, true);
            if (on) {
                colorizer.setDisplay(null, (ViewColorizer.Key)lk, true);
                continue;
            }
            if (thisLayer == routeLayer) continue;
            colorizer.setDisplay(null, (ViewColorizer.Key)lk, false);
        }
        OrbitIO.getApp().refreshCurrentView(true);
    }

    public static void extractObstacles(List<Topstacle> results, DevicePath parentPath, Layer routeLayer) {
        RouterInterface.extractObstacles(results, parentPath, routeLayer, null);
    }

    public static void extractObstacles(List<Topstacle> results, DevicePath parentPath, Layer routeLayer, ARect restrictedBounds) {
        ARect bounds = parentPath.getDeviceTemplate().getBB();
        if (restrictedBounds != null) {
            bounds = restrictedBounds;
        }
        Substrate s = parentPath.getSubstrate();
        for (DevicePath cdp : parentPath.getDescendants()) {
            if (cdp.getSubstrate() != s) continue;
            cdp = cdp.getRelativePathFromAnchor(parentPath.getDeviceTemplate());
            DeviceTemplate child = cdp.getDeviceTemplate();
            for (PinTemplate dPort : child.getPins()) {
                AGeom g = dPort.getSubstrateShapeOnLayer(cdp, routeLayer);
                if (g == null) continue;
                PinInstance pi = cdp.getDevice() != null ? cdp.getDevice().getPin(dPort) : child.getAnInstance().getPin(dPort);
                Topstacle topstacle = Topstacle.fromDevicePathPort(new HierPin(cdp, pi), routeLayer);
                topstacle.setShape(g);
                if (!bounds.contains(topstacle.getShape().getBounds().center())) continue;
                results.add(topstacle);
            }
        }
    }

    public static PrettyRouter routeConnections(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted, DevicePath parentPath, Layer routeLayer, long width, long clear, Constraint.RouteAngle angle, Constraint.RouteStrategy strategy, NamedGrid grid, boolean animate, boolean justShowConnections, SortType st, boolean useThinWire, ARect dieRect, PrettyRouter.RouteType rt) {
        return RouterInterface.routeConnections(toBeRouted, parentPath, routeLayer, angle, strategy, grid, animate, justShowConnections, st, useThinWire, dieRect, true, rt);
    }

    public static PrettyRouter routeConnections(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted, DevicePath parentPath, Layer routeLayer, Constraint.RouteAngle angle, Constraint.RouteStrategy strategy, NamedGrid grid, boolean animate, boolean justShowConnections, SortType st, boolean useThinWire, ARect dieRect, boolean makePretty, PrettyRouter.RouteType rt) {
        Db db = OrbitIO.getCurDb();
        ArrayList<Topstacle> obstacles = new ArrayList<Topstacle>();
        RouterInterface.extractObstacles(obstacles, parentPath, routeLayer, null);
        PrettyRouter pr = PrettyRouter.getPrettyRouter(parentPath.getLast().getTemplate(), routeLayer, true);
        pr.setDB(db);
        pr.setParent(parentPath);
        pr.setLayer(routeLayer);
        pr.setObstacles(obstacles);
        pr.debugView();
        Personality p = ((HierPin)toBeRouted.get(0).getFrom().getOwner()).getPin().getRouteGroup();
        if (st != SortType.AsIs) {
            Collections.sort(toBeRouted, new RouteSorter(p, st, dieRect));
        }
        pr.setToBeRouted(toBeRouted);
        pr.setAngle(angle);
        pr.setRouteType(rt);
        if (!justShowConnections) {
            pr.globalRoute(true);
            if (makePretty) {
                pr.detailRoute();
            }
        } else {
            return pr;
        }
        Selection selection = Design.getSelection((Db)db);
        Selection.clearSelection();
        UserCommands.removeConnections();
        for (SingleLayerRouter.RouteInformation ri : toBeRouted) {
            if (ri.getSucess()) continue;
            Connection c = Connection.create((Db)db, (HierPin)((HierPin)ri.getFrom().getOwner()), (HierPin)((HierPin)ri.getTo().getOwner()));
            selection.add((DbObject)c);
        }
        OrbitIO.getApp().refreshCurrentView(true);
        return pr;
    }

    public static void routeUnGroupOfBondPadsToBalls(String personalityKey) {
        Db db = OrbitIO.getCurDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)personalityKey);
        ArrayList<Wire> toBeRemovedWires = new ArrayList<Wire>();
        if (p == null) {
            ALog.logWarn((String)"Can not find route group definition");
        }
        PinInstance port = null;
        if (p != null) {
            port = PinInstance.getBondRingPins((Personality)p).stream().findFirst().orElse(null);
        }
        if (port == null) {
            return;
        }
        PinTemplate dtp = port.getPinTemplate();
        PadTemplate pt = dtp.getPadTemplate();
        Layer routeLayer = null;
        if (pt == null) {
            return;
        }
        routeLayer = pt.getLayers().stream().findFirst().orElse(null);
        for (Wire w : db.getObjects(Wire.class)) {
            if (w.getLayer() != routeLayer) continue;
            toBeRemovedWires.add(w);
        }
        for (Wire w : toBeRemovedWires) {
            w.deleteFromDb();
        }
        OrbitIO.getApp().refreshCurrentView(true);
    }

    public static void determineConnectionCrossings(ArrayList<SingleLayerRouter.RouteInformation> list) {
        int size = list.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i; j < size; ++j) {
                ALine lJ;
                ALine lI = list.get(i).line();
                if (!lI.intersects((AGeom)(lJ = list.get(j).line()))) continue;
                list.get(i).setNumConnectionsICross(list.get(i).getNumConnectionsICross() + 1L);
                list.get(j).setNumConnectionsICross(list.get(j).getNumConnectionsICross() + 1L);
            }
        }
    }

    public static void determineDiffPairs(ArrayList<SingleLayerRouter.RouteInformation> list) {
        int size = list.size();
        Db db = OrbitIO.getCurDb();
        for (int i = 0; i < size; ++i) {
            boolean mlv;
            Constraint ml;
            list.get(i).setDiffPair(null);
            Net n = list.get(i).getFrom().getNet();
            Personality p = n.getPersonality();
            if (p == null || (ml = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH)) == null || !(mlv = ((Boolean)ml.getValue()).booleanValue())) continue;
            list.get(i).setDiffPair(p);
        }
    }

    public static void moveDiffPairsClose(ArrayList<SingleLayerRouter.RouteInformation> list) {
        int size = list.size();
        block0: for (int i = 0; i < size; ++i) {
            if (list.get(i).getDiffPair() == null) continue;
            for (int j = i + 1; j < size; ++j) {
                if (list.get(j).getDiffPair() != list.get(i).getDiffPair()) continue;
                SingleLayerRouter.RouteInformation rj = list.get(j);
                list.remove(j);
                list.add(i + 1, rj);
                ++i;
                continue block0;
            }
        }
    }

    public static void routeGroupOfBondPadsToBalls(String personalityKey, boolean justShowConnections) {
        Db db = OrbitIO.getCurDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)personalityKey);
        if (p == null) {
            ALog.logError((String)"Can not find route group definition");
            return;
        }
        Long width = Constraint.getRouteWidth(null, null, (Personality)p);
        long clr = (Long)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.WIRE_CLEAR);
        long pinExitLength = 0L;
        Constraint.RouteAngle angle = Constraint.RouteAngle.Any;
        Constraint.RouteStrategy strategy = Constraint.RouteStrategy.GlobalRoute;
        Constraint.ConnectToStrategy connectStrategy = Constraint.ConnectToStrategy.FREE;
        NamedGrid grid = null;
        boolean animate = false;
        DeviceTemplate devTemp = p.getOwner();
        DevicePath parentPath = RouterInterface.determinePathOfSubstrate(devTemp);
        if (devTemp != null) {
            Constraint cs;
            Constraint ra;
            Constraint constraint;
            Constraint rs;
            Constraint a;
            Constraint c;
            Long w = Constraint.getRouteWidth(null, null, (Personality)p);
            if (w != null) {
                width = w;
            }
            if ((c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.WIRE_CLEAR)) != null) {
                clr = (Long)c.getValue();
            }
            if ((a = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTE_ANGLE)) != null) {
                angle = (Constraint.RouteAngle)a.getValue();
            }
            if ((c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.PIN_EXIT_LENGTH)) != null) {
                pinExitLength = (Long)c.getValue();
            }
            if ((rs = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTE_STRATEGY)) != null) {
                strategy = (Constraint.RouteStrategy)rs.getValue();
            }
            if ((constraint = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTING_GRID)) != null) {
                grid = (NamedGrid)constraint.getValue();
            }
            if ((ra = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ANIMATION)) != null) {
                animate = (Boolean)ra.getValue();
            }
            if ((cs = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.CONNECT_STRATEGY)) != null) {
                connectStrategy = (Constraint.ConnectToStrategy)cs.getValue();
            }
        }
        List<Object> created = null;
        ArrayList<SingleLayerRouter.RouteInformation> toBeRouted = new ArrayList<SingleLayerRouter.RouteInformation>();
        Layer routeLayer = null;
        if (connectStrategy == Constraint.ConnectToStrategy.FREE) {
            PortPairOpt ppo = new PortPairOpt();
            ArrayList<HierPin> arrayList = new ArrayList<HierPin>();
            ArrayList<HierPin> bPorts = new ArrayList<HierPin>();
            ArrayList<Personality> pinPersonalityOfBFs = new ArrayList<Personality>();
            for (PinInstance port : PinInstance.getBondRingPins((Personality)p)) {
                Objects.requireNonNull(parentPath);
                PinTemplate bf = BondFingerUtil.getConnectedBF((DeviceTemplate)parentPath.getDeviceTemplate(), (PinInstance)port);
                if (BondFingerUtil.getGravity((PinTemplate)bf) != null && BondFingerUtil.getGravity((PinTemplate)bf) != bf) continue;
                PinInstance bfp = bf.getPinInstance(bf.getDeviceTemplate().getPathToPresentUser());
                Personality personality = bfp.getPersonality();
                if (!pinPersonalityOfBFs.contains(personality)) {
                    pinPersonalityOfBFs.add(personality);
                }
                arrayList.add(new HierPin(null, bfp));
            }
            ALog.logInfo((String)(arrayList.size() + " Bond fingers being requested to connect"));
            if (arrayList.isEmpty()) {
                return;
            }
            routeLayer = RouterInterface.determineLayerOfBondFinger(((HierPin)arrayList.get(0)).getPin());
            if (routeLayer == null) {
                return;
            }
            ppo.setAPorts(arrayList);
            Objects.requireNonNull(parentPath);
            for (PinInstance dp : parentPath.getLast().getPins()) {
                if (dp.getType() == PinTemplate.Type.BONDFINGERPAD || dp.getPinTemplate().getBounds(routeLayer) == null) continue;
                bPorts.add(new HierPin(null, dp));
            }
            ALog.logInfo((String)(bPorts.size() + " Candidate Ball Pads Found"));
            ppo.setBPorts(bPorts);
            ppo.setFilter(false);
            ppo.assign();
            created = ppo.getCreated();
            ALog.logInfo((String)(created.size() + " Routes being requested"));
        } else {
            created = new ArrayList();
            for (PinInstance pinInstance : PinInstance.getBondRingPins((Personality)p)) {
                Objects.requireNonNull(parentPath);
                PinTemplate bf = BondFingerUtil.getConnectedBF((DeviceTemplate)parentPath.getLast().getTemplate(), (PinInstance)pinInstance);
                if (bf == null || BondFingerUtil.getGravity((PinTemplate)bf) != null && BondFingerUtil.getGravity((PinTemplate)bf) != bf) continue;
                PinInstance bfp = bf.getPinInstance(bf.getDeviceTemplate().getPathToPresentUser());
                if (routeLayer == null) {
                    routeLayer = RouterInterface.determineLayerOfBondFinger(bfp);
                }
                if (bfp == null) continue;
                Net topNet = NetMap.getTopmostNet((Net)bfp.getNet(), (DevicePath)bf.getDeviceTemplate().getPathToPresentUser());
                PinInstance candidate = null;
                for (PinInstance dp : parentPath.getLast().getPins()) {
                    if (dp.getType() == PinTemplate.Type.BONDFINGERPAD || dp.getPinTemplate().getBounds(routeLayer) == null || NetMap.getTopmostNet((Net)dp.getNet(), (DevicePath)dp.getDevice().getADevicePath()) != topNet) continue;
                    if (candidate != null) {
                        candidate = null;
                        break;
                    }
                    candidate = dp;
                }
                if (candidate == null) continue;
                DevicePath bfPath = new DevicePath(parentPath);
                DevicePathPortPair dpp = new DevicePathPortPair(new HierPin(bfPath, bfp), new HierPin(parentPath, candidate));
                created.add(dpp);
            }
        }
        if (!created.isEmpty()) {
            for (DevicePathPortPair devicePathPortPair : created) {
                SingleLayerRouter.RouteInformation ri = new SingleLayerRouter.RouteInformation();
                ri.setFrom(Topstacle.fromDevicePathPort(devicePathPortPair.getDPPA().getPath(), devicePathPortPair.getDPPA().getPin()));
                ri.setTo(Topstacle.fromDevicePathPort(devicePathPortPair.getDPPB().getPath(), devicePathPortPair.getDPPB().getPin()));
                ri.setWidth(width);
                ri.setClear(clr);
                ri.setPinExitLength(pinExitLength);
                toBeRouted.add(ri);
            }
            RouterInterface.routeConnections(toBeRouted, parentPath, routeLayer, width, clr, angle, strategy, grid, animate, justShowConnections, SortType.ShortToLong, false, null, PrettyRouter.RouteType.PACKAGEWB);
        }
    }

    public static PrettyRouter routeFCGroup(String personalityKey, boolean justShowConnections) {
        Constraint ra;
        Constraint rg;
        Constraint rs;
        DeviceTemplate t;
        Db db = OrbitIO.getCurDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)personalityKey);
        if (p == null) {
            ALog.logWarn((String)"Can not find route group definition");
        }
        Constraint.RouteAngle angle = Constraint.RouteAngle.Any;
        Constraint.RouteStrategy strategy = Constraint.RouteStrategy.GlobalRoute;
        NamedGrid grid = null;
        boolean animate = false;
        DeviceTemplate deviceTemplate = t = p == null ? null : p.getOwner();
        if (t == null) {
            return null;
        }
        DevicePath parentPath = RouterInterface.determinePathOfSubstrate(t);
        String routeLayerString = null;
        Constraint l = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTE_LAYER);
        if (l == null) {
            return null;
        }
        routeLayerString = ((Layer)l.getValue()).getName();
        Layer routeLayer = t.getSubstrate().getLayer(routeLayerString);
        Long w = Constraint.getRouteWidth(null, null, (Personality)p);
        if (w == null) {
            return null;
        }
        long width = w;
        Constraint c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.WIRE_CLEAR);
        if (c == null) {
            return null;
        }
        long clr = (Long)c.getValue();
        Constraint a = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTE_ANGLE);
        if (a != null) {
            angle = (Constraint.RouteAngle)a.getValue();
        }
        if ((rs = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTE_STRATEGY)) != null) {
            strategy = (Constraint.RouteStrategy)rs.getValue();
        }
        if ((rg = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTING_GRID)) != null) {
            grid = (NamedGrid)rg.getValue();
        }
        if ((ra = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ANIMATION)) != null) {
            animate = (Boolean)ra.getValue();
        }
        ArrayList<DevicePathPortPair> created = new ArrayList<DevicePathPortPair>();
        ArrayList<SingleLayerRouter.RouteInformation> toBeRouted = new ArrayList<SingleLayerRouter.RouteInformation>();
        AHashCollection routeList = new AHashCollection();
        DevicePath diePath = null;
        for (PinInstance bump : PinInstance.getRoutePins((Personality)p)) {
            DevicePath bumpPath = bump.getDevice().getADevicePath();
            diePath = bumpPath.pathToLowestDie();
            for (PinInstance candidate : NetMap.getConnectedPorts((Net)bump.getNet(), (DevicePath)bumpPath)) {
                PinTemplate dtp = candidate.getPinTemplate();
                Objects.requireNonNull(parentPath);
                if (dtp.getDeviceTemplate() != parentPath.getDeviceTemplate() || candidate.getPinTemplate().getBounds(routeLayer) == null) continue;
                routeList.add((Object)bump, (Object)candidate);
            }
        }
        for (PinInstance bump : routeList.keySet()) {
            LinkedList ports = (LinkedList)routeList.get((Object)bump);
            if (ports.size() != 2) {
                ALog.logInfo((String)("There are " + ports.size() + " connected to " + bump.getName() + " and will be ignored"));
                continue;
            }
            if (((PinInstance)ports.get(0)).getName().contains("Bump")) {
                created.add(new DevicePathPortPair(new HierPin(parentPath, (PinInstance)ports.get(0)), new HierPin(parentPath, (PinInstance)ports.get(1))));
                continue;
            }
            if (((PinInstance)ports.get(1)).getName().contains("Bump")) {
                created.add(new DevicePathPortPair(new HierPin(parentPath, (PinInstance)ports.get(1)), new HierPin(parentPath, (PinInstance)ports.get(0))));
                continue;
            }
            ALog.logInfo((String)"no bump via found");
        }
        if (created.size() > 0) {
            for (DevicePathPortPair dppp : created) {
                DevicePath devicePathA = dppp.getDPPA().getPath();
                DevicePath devicePathB = dppp.getDPPB().getPath();
                SingleLayerRouter.RouteInformation ri = new SingleLayerRouter.RouteInformation();
                ri.setFrom(Topstacle.fromDevicePathPort(devicePathA, dppp.getDPPA().getPin()));
                ri.getFrom().setShape(dppp.getDPPA().getPin().getSubstrateShapeOnLayer(devicePathA, routeLayer));
                ri.setTo(Topstacle.fromDevicePathPort(devicePathB, dppp.getDPPB().getPin()));
                ri.getTo().setShape(dppp.getDPPB().getPin().getSubstrateShapeOnLayer(devicePathB, routeLayer));
                ri.setWidth(width);
                ri.setClear(clr);
                ri.setPinExitLength(0L);
                toBeRouted.add(ri);
            }
            ARect dieRect = diePath.getBB();
            RouterInterface.routeConnections(toBeRouted, parentPath, routeLayer, width, clr, angle, strategy, grid, animate, justShowConnections, SortType.DistanceFromDieEdge, true, dieRect, PrettyRouter.RouteType.PACKAGEFC);
        }
        return null;
    }

    static int comparePriority(Personality p, SingleLayerRouter.RouteInformation r0, SingleLayerRouter.RouteInformation r1) {
        Integer p0 = RouteQueue.getPriority(p, r0.getFrom().toDevicePathPort(), r0.getTo().toDevicePathPort());
        Integer p1 = RouteQueue.getPriority(p, r1.getFrom().toDevicePathPort(), r1.getTo().toDevicePathPort());
        if (p0 != null && p1 != null) {
            if (p0 > p1) {
                return 1;
            }
            if (p1 > p0) {
                return -1;
            }
            return 0;
        }
        if (p0 != null && p1 == null) {
            return -1;
        }
        if (p1 != null && p0 == null) {
            return 1;
        }
        return 0;
    }

    private static PinInstance findMatchPortInPath(APath path, DevicePath dp, Net n, PinInstance assigned) {
        int count = path.getPointCount();
        if (count <= 2) {
            return null;
        }
        for (PinInstance p : NetMap.getConnectedPorts((Net)n, (DevicePath)dp)) {
            if (p == assigned) continue;
            DevicePath pdp = p.getDevice().getADevicePath();
            APoint2D loc = p.getWorldLoc(pdp);
            for (int i = 1; i < count - 1; ++i) {
                if (!loc.equals((Object)path.getPoint(i))) continue;
                return p;
            }
        }
        return null;
    }

    protected static DevicePath determinePathOfSubstrate(DeviceTemplate devTemp) {
        Device parentDevice = null;
        DevicePath parentPath = null;
        for (Device d : devTemp.getDeviceInstances()) {
            if (!d.getIsSubstrate()) continue;
            parentDevice = d;
            break;
        }
        for (DevicePath path : OrbitIO.getCurDesign().getDescendantDevices()) {
            if (path.getLast() != parentDevice) continue;
            parentPath = path;
            break;
        }
        return parentPath;
    }

    protected static Layer determineLayerOfBondFinger(PinInstance aPort) {
        Layer layer = null;
        PinTemplate dtp = aPort.getPinTemplate();
        PadTemplate pt = dtp.getPadTemplate();
        if (pt != null) {
            for (LayerShape ls : pt.getLayerShapes()) {
                layer = ls.getLayer();
            }
        }
        return layer;
    }

    protected static void writeOrder(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted) {
        try (PrintStream p = new PrintStream(new FileOutputStream("orderOut.txt"));){
            for (SingleLayerRouter.RouteInformation ri : toBeRouted) {
                p.println(ri.getFrom().getNet().getName());
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected static ArrayList<SingleLayerRouter.RouteInformation> readOrder(ArrayList<SingleLayerRouter.RouteInformation> toBeRouted) {
        try (BufferedReader myInput = new BufferedReader(new InputStreamReader(new FileInputStream("orderIn.txt")));){
            String netName;
            int readPos = 0;
            while ((netName = myInput.readLine()) != null) {
                if (readPos >= toBeRouted.size()) {
                    break;
                }
                for (int i = 0; i < toBeRouted.size(); ++i) {
                    if (!toBeRouted.get(i).getFrom().getNet().getName().equals(netName)) continue;
                    SingleLayerRouter.RouteInformation riTemp = toBeRouted.get(i);
                    toBeRouted.remove(i);
                    toBeRouted.add(readPos, riTemp);
                    break;
                }
                ++readPos;
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
        return toBeRouted;
    }

    public static class RouteSorter
    implements Comparator<SingleLayerRouter.RouteInformation> {
        SortType mT;
        ARect mDieRect = null;
        Personality mPersonality;

        public RouteSorter(Personality p, SortType t, ARect dieRect) {
            this.mPersonality = p;
            this.mT = t;
            this.mDieRect = dieRect;
        }

        @Override
        public int compare(SingleLayerRouter.RouteInformation rI0, SingleLayerRouter.RouteInformation rI1) {
            ALine l1;
            ALine l0;
            if (this.mT == SortType.Experimental) {
                boolean l1Straight;
                l0 = rI0.line();
                l1 = rI1.line();
                long dx0 = Math.abs(l0.dX());
                long dx1 = Math.abs(l1.dX());
                boolean l0Straight = Math.abs(l0.getAngle() - 90.0) < 15.0;
                boolean bl = l1Straight = Math.abs(l1.getAngle() - 90.0) < 15.0;
                if (l0Straight && !l1Straight) {
                    return -1;
                }
                if (l1Straight && !l0Straight) {
                    return 1;
                }
                if (dx0 < dx1) {
                    return -1;
                }
                if (dx1 < dx0) {
                    return 1;
                }
                if (rI0.length() < rI1.length()) {
                    return -1;
                }
                if (rI1.length() < rI0.length()) {
                    return 1;
                }
                if (rI0.getFrom().getPoint().getX() < rI1.getFrom().getPoint().getX()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getX() > rI1.getFrom().getPoint().getX()) {
                    return 1;
                }
                if (rI0.getFrom().getPoint().getY() < rI1.getFrom().getPoint().getY()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getY() > rI1.getFrom().getPoint().getY()) {
                    return 1;
                }
            }
            if (this.mT == SortType.DistanceFromDieEdge) {
                long d1;
                boolean l1Straight;
                l0 = rI0.line();
                l1 = rI1.line();
                boolean l0Straight = Math.abs(l0.getAngle() - 90.0) < 15.0;
                boolean bl = l1Straight = Math.abs(l1.getAngle() - 90.0) < 15.0;
                if (rI0.getDiffPair() != null && rI1.getDiffPair() == null) {
                    return -1;
                }
                if (rI0.getDiffPair() == null && rI1.getDiffPair() != null) {
                    return 1;
                }
                if (l0Straight && !l1Straight) {
                    return -1;
                }
                if (l1Straight && !l0Straight) {
                    return 1;
                }
                HierPin from0 = (HierPin)rI0.getFrom().getOwner();
                HierPin from1 = (HierPin)rI1.getFrom().getOwner();
                long d0 = from0.getMinDistToSubstrateEdge(this.mDieRect);
                if (d0 < (d1 = from1.getMinDistToSubstrateEdge(this.mDieRect))) {
                    return -1;
                }
                if (d1 < d0) {
                    return 1;
                }
                if (rI0.length() < rI1.length()) {
                    return -1;
                }
                if (rI1.length() < rI0.length()) {
                    return 1;
                }
                if (rI0.getFrom().getPoint().getX() < rI1.getFrom().getPoint().getX()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getX() > rI1.getFrom().getPoint().getX()) {
                    return 1;
                }
                if (rI0.getFrom().getPoint().getY() < rI1.getFrom().getPoint().getY()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getY() > rI1.getFrom().getPoint().getY()) {
                    return 1;
                }
            }
            if (this.mT == SortType.DistanceFromParentEdge) {
                long d1;
                HierPin from0 = (HierPin)rI0.getFrom().getOwner();
                HierPin from1 = (HierPin)rI1.getFrom().getOwner();
                long d0 = from0.getMinDistToSubstrateEdge();
                if (d0 < (d1 = from1.getMinDistToSubstrateEdge())) {
                    return -1;
                }
                if (d1 < d0) {
                    return 1;
                }
                if (rI0.length() < rI1.length()) {
                    return -1;
                }
                if (rI1.length() < rI0.length()) {
                    return 1;
                }
                if (rI0.getFrom().getPoint().getX() < rI1.getFrom().getPoint().getX()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getX() > rI1.getFrom().getPoint().getX()) {
                    return 1;
                }
                if (rI0.getFrom().getPoint().getY() < rI1.getFrom().getPoint().getY()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getY() > rI1.getFrom().getPoint().getY()) {
                    return 1;
                }
            }
            if (this.mT == SortType.ShortToLong) {
                int p0 = RouterInterface.comparePriority(this.mPersonality, rI0, rI1);
                if (p0 == -1) {
                    return -1;
                }
                if (p0 == 1) {
                    return 1;
                }
                if (rI0.length() < rI1.length()) {
                    return -1;
                }
                if (rI1.length() < rI0.length()) {
                    return 1;
                }
                if (rI0.getFrom().getPoint().getX() < rI1.getFrom().getPoint().getX()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getX() > rI1.getFrom().getPoint().getX()) {
                    return 1;
                }
                if (rI0.getFrom().getPoint().getY() < rI1.getFrom().getPoint().getY()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getY() > rI1.getFrom().getPoint().getY()) {
                    return 1;
                }
                return 0;
            }
            if (this.mT == SortType.LongToShort) {
                if (rI0.length() < rI1.length()) {
                    return 1;
                }
                if (rI1.length() < rI0.length()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getX() < rI1.getFrom().getPoint().getX()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getX() > rI1.getFrom().getPoint().getX()) {
                    return 1;
                }
                if (rI0.getFrom().getPoint().getY() < rI1.getFrom().getPoint().getY()) {
                    return -1;
                }
                if (rI0.getFrom().getPoint().getY() > rI1.getFrom().getPoint().getY()) {
                    return 1;
                }
                return 0;
            }
            if (this.mT == SortType.Conflict) {
                if (!rI0.getSucess() && rI1.getSucess()) {
                    return -1;
                }
                if (rI0.getSucess() && !rI1.getSucess()) {
                    return 1;
                }
                return 0;
            }
            if (this.mT == SortType.Efficiency) {
                if (!rI0.getSucess() && rI1.getSucess()) {
                    return -1;
                }
                if (rI0.getSucess() && !rI1.getSucess()) {
                    return 1;
                }
                double ddiff = rI0.getEfficiency() - rI1.getEfficiency();
                if (ddiff > 0.0) {
                    return 1;
                }
                if (ddiff < 0.0) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
    }

    public static class ConnectionSorter
    implements Comparator<Connection> {
        @Override
        public int compare(Connection c0, Connection c1) {
            if (c0.getRect().left() < c1.getRect().left()) {
                return -1;
            }
            if (c0.getRect().left() > c1.getRect().left()) {
                return 1;
            }
            if (c0.getRect().bottom() < c1.getRect().bottom()) {
                return -1;
            }
            if (c0.getRect().bottom() > c1.getRect().bottom()) {
                return 1;
            }
            return 0;
        }
    }

    public static enum SortType {
        AsIs,
        ShortToLong,
        LongToShort,
        Conflict,
        Efficiency,
        ConnectionCrossing,
        DistanceFromParentEdge,
        DistanceFromDieEdge,
        Experimental;

    }
}

