/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.OrbitIO;
import java.awt.Window;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;

public class WbExportDefFileChooser
extends AFileChooser {
    static final AFileFilter CVS_FILE_FILTER = AFileFilter.CSV;
    static final String NO_LAYER = "<No Layer>";
    protected Substrate mSubstrate;
    protected String mFingerFileName;
    protected String mMetalFileName;
    protected Window mOwner;
    protected FileWriter mFingerWriter;
    protected FileWriter mMetalWriter;
    protected CSVDocument mCSVDocument;
    static final Constraint.DescriptorList mFingerHeader = Constraint.DescriptorList.of((Constraint.Descriptor[])new Constraint.Descriptor[]{Constraint.RING_GEOM, Constraint.BOND_SIDE, Constraint.BONDFINGER_WIDTH, Constraint.BONDFINGER_LENGTH, Constraint.BONDFINGER_TIER_DIST, Constraint.BONDFINGER_ANGLE, Constraint.BONDMAX_LENGTH, Constraint.BONDMIN_LENGTH, Constraint.BONDFINGER_SEPARATION, Constraint.BONDWIRE_TO_BONDWIRE_CLR, Constraint.BONDMIN_ANGLE, Constraint.BONDWIRE_WIDTH, Constraint.WIREBOND_LAYER, Constraint.BONDFINGER_LAYER});
    static final Constraint.DescriptorList mMetalHeader = Constraint.DescriptorList.of((Constraint.Descriptor[])new Constraint.Descriptor[]{Constraint.METALRING_WIDTH, Constraint.METALRING_DIST, Constraint.BONDFINGER_SEPARATION, Constraint.BONDWIRE_TO_BONDWIRE_CLR, Constraint.BONDMIN_ANGLE, Constraint.BONDWIRE_WIDTH, Constraint.WIREBOND_LAYER, Constraint.BONDFINGER_LAYER});

    public static void createFileChooser(Window owner, String title, Substrate substrate) {
        WbExportDefFileChooser fc = new WbExportDefFileChooser();
        fc.setFileFilter((FileFilter)CVS_FILE_FILTER);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle(title);
        fc.initi(owner, substrate);
    }

    private void initi(Window owner, Substrate substrate) {
        this.mOwner = owner;
        this.mSubstrate = substrate;
        if (this.showSaveDialog(owner) != 0) {
            return;
        }
        File f = this.getSelectedFile();
        if (f == null) {
            return;
        }
        String fileName = f.getPath();
        fileName = fileName.replace(".csv", "");
        this.mFingerFileName = fileName + "_Finger.csv";
        this.mMetalFileName = fileName + "_Metal.csv";
        this.exportFile();
    }

    private void exportFile() {
        Db db = OrbitIO.getCurDb();
        try {
            this.mFingerWriter = new FileWriter(new File(this.mFingerFileName));
            this.mMetalWriter = new FileWriter(new File(this.mMetalFileName));
        }
        catch (IOException e) {
            ALog.logWarn((String)"problem opening");
            return;
        }
        this.writeHeader();
        for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
            Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING).forEach(personality -> {
                Constraint.RingType ringType = (Constraint.RingType)Constraint.getValue((Db)db, (DbObject)personality, (Constraint.Descriptor)Constraint.BONDRING_TYPE);
                FileWriter writer = ringType != Constraint.RingType.FINGER ? this.mMetalWriter : this.mFingerWriter;
                Constraint.DescriptorList header = ringType != Constraint.RingType.FINGER ? mMetalHeader : mFingerHeader;
                String name = personality.getName();
                this.print(writer, name);
                for (Constraint.Descriptor desc : header) {
                    String sVal;
                    Class classType = desc.getType();
                    if (classType == Long.class) {
                        long val = (Long)Constraint.getValue((Db)db, (DbObject)personality, (Constraint.Descriptor)desc);
                        sVal = OrbitIO.getCurView().getUnit().toUserStr(val);
                        sVal = sVal.replaceAll(",", "");
                        this.print(writer, "," + sVal);
                        continue;
                    }
                    if (classType == Double.class) {
                        double Val = (Double)Constraint.getValue((Db)db, (DbObject)personality, (Constraint.Descriptor)desc);
                        sVal = Double.toString(Val);
                        sVal = sVal.replaceAll(",", "");
                        this.print(writer, "," + sVal);
                        continue;
                    }
                    if (classType == Layer.class) {
                        Layer layer = (Layer)Constraint.getValue((Db)db, (DbObject)personality, (Constraint.Descriptor)desc);
                        String sVal2 = layer != null ? layer.getName() : NO_LAYER;
                        this.print(writer, "," + sVal2);
                        continue;
                    }
                    this.print(writer, "," + Constraint.getValue((Db)db, (DbObject)personality, (Constraint.Descriptor)desc));
                }
                this.print(writer, "\n");
            });
        }
        try {
            this.mFingerWriter.close();
            this.mMetalWriter.close();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems closing", (Object[])new Object[0]);
        }
    }

    protected void writeHeader() {
        this.print(this.mFingerWriter, "Name,");
        for (Constraint.Descriptor desc : mFingerHeader) {
            this.print(this.mFingerWriter, desc.getDesc());
            this.print(this.mFingerWriter, ",");
        }
        this.print(this.mFingerWriter, "\n");
        this.print(this.mMetalWriter, "Name,");
        for (Constraint.Descriptor desc : mMetalHeader) {
            this.print(this.mMetalWriter, desc.getDesc());
            this.print(this.mMetalWriter, ",");
        }
        this.print(this.mMetalWriter, "\n");
    }

    protected boolean print(FileWriter writer, String s) {
        try {
            writer.write(s);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Problems writing", (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

