/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AMutableReference;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.automation.RouterMgmt;
import com.sigrity.orbit.automation.router.InteractiveRouter;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import com.sigrity.orbit.cmd.BundleCommands;
import com.sigrity.orbit.export.DEFOut;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.wb_route.BondRingDefinitionEditDlg;
import com.sigrity.orbit.ui.wb_route.EvolveConnSolutionDlg;
import com.sigrity.orbit.ui.wb_route.EvolveWBSolutionDlg;
import com.sigrity.orbit.ui.wb_route.InteractiveGuidedRouter;
import com.sigrity.orbit.ui.wb_route.RDLRuleSetDlg;
import com.sigrity.orbit.ui.wb_route.RouteGroupNameEditor;
import com.sigrity.orbit.ui.wb_route.RouteQueue;
import com.sigrity.orbit.ui.wb_route.RouteQueueDlg;
import com.sigrity.orbit.ui.wb_route.RouterRuleSetDlg;
import com.sigrity.orbit.ui.wb_route.WbExportDefFileChooser;
import com.sigrity.orbit.ui.wb_route.WbImportDefFileChooser;
import com.sigrity.orbit.ui.wb_route.WireBondExportDlg;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WbFcFeasibilityUI
extends DbDialog {
    protected static boolean sShowWireBonding = true;
    protected static int COLS_NAME = 20;
    protected static int COLS_NUM = 10;
    protected static final String[] PERSONALITY_RELATIONS = new String[]{"PinInstance-bondRingPersonality"};
    protected static final String WIRE_BOND_GROUP_NAME = "Wire Bond Group";
    protected static final String RDL_GROUP_NAME = "RDL Route Groups";
    protected static final String DIE_ESCAPE_GROUP_NAME = "Die Escape Route Groups";
    public static final Icon ICON_ROUTE_ADD = UIUtil.getIcon(OrbitIcons.class, (String)"res/iconRouteAdd.png");
    public static final Icon ICON_TABLE = UIUtil.getIcon(OrbitIcons.class, (String)"res/iconTable.png");
    public static final AFileFilter mCVSFileFilter = AFileFilter.CSV;
    protected SingleLayerRouter.LoadListener mListener;
    protected InteractiveRouter mIR;
    JProgressBar mProgressMeter;
    static boolean refreshPending = false;
    static ArrayList<String> lastExpandedSet = new ArrayList();
    protected static Personality mSelectedPersonality = null;
    protected AAppView mView;
    protected Design mDesign;
    protected WbAndFCStrategyTree mWireBondAndRouteStrategyTree;
    protected JButton mBtnAdd;
    protected JButton mBtnEdit;
    protected JButton mBtnDelete;
    protected DbRelationDef.DbRelationListener mRelationListener = new DbRelationDef.DbRelationAdapter(){

        public void related(DbRelationDef.RelationChange change) {
            Personality personality = (Personality)change.getRight();
            DbObject dbo = change.getLeft();
            AStrategyNode pn = WbFcFeasibilityUI.this.getRootNode().findNode(personality);
            if (pn == null) {
                return;
            }
            pn.add((PinInstance)dbo);
        }

        public void unrelated(DbRelationDef.RelationChange change) {
            Personality personality = (Personality)change.getRight();
            DbObject dbo = change.getLeft();
            AStrategyNode pn = WbFcFeasibilityUI.this.getRootNode().findNode(personality);
            if (pn == null) {
                return;
            }
            int idx = pn.getIndex((PinInstance)dbo);
            if (idx == -1) {
                return;
            }
            pn.remove(idx);
        }
    };
    protected DbClass.DbObjectListener mPersonalityListener = new DbClass.DbObjectAdapter(){

        public void addedObject(DbClass.ObjectAdd add) {
            WbFcFeasibilityUI.this.getRootNode().notifyChange((DbClass.DbObjectEvent)add);
        }

        public void changedObject(DbClass.ObjectChange change) {
            WbFcFeasibilityUI.this.getRootNode().notifyChange((DbClass.DbObjectEvent)change);
        }

        public void removedObject(DbClass.ObjectRemove remove) {
            WbFcFeasibilityUI.this.getRootNode().notifyChange((DbClass.DbObjectEvent)remove);
        }
    };
    protected ActionListener mSelectPortsOfStrategy = e -> {
        ArrayList<AStrategyNode> selected = this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
        if (selected.size() != 1) {
            return;
        }
        Personality personality = selected.get((int)0).mPersonality;
        Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.selectPortsOfStrategy(\"%s\")", (Object[])new Object[]{personality.getKeyStr()});
    };
    protected ActionListener mDeleteStrategy = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<AStrategyNode> selected = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
            if (selected.size() != 1) {
                return;
            }
            AStrategyNode strategy = selected.get(0);
            Personality personality = strategy.mPersonality;
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.deleteStrategy (\"%s\")", (Object[])new Object[]{personality.getKeyStr()});
            WbFcFeasibilityUI.this.refreshTree();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mRemoveSelectedPorts = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<AStrategyNode> selected = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
            if (selected.size() != 1) {
                return;
            }
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.removeSelectedPortsToStrategy(\"%s\")", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
            WbFcFeasibilityUI.this.refreshTree();
        }
    };
    protected ActionListener mAddSelectedSinglePorts = e -> {
        ArrayList<AStrategyNode> selected = this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
        if (selected.size() != 1) {
            return;
        }
        Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.addSelectedSinglePortsToStrategy(\"%s\")", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
        this.refreshTree();
    };
    protected ActionListener mAddSelectedPorts = e -> {
        ArrayList<AStrategyNode> selected = this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
        if (selected.size() != 1) {
            return;
        }
        Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.addSelectedPortsToStrategy(\"%s\")", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
        this.refreshTree();
    };
    protected ActionListener mReBondMe = e -> {
        this.mUnBondMeCommand();
        this.mBondMeCommand();
    };
    protected ActionListener mUnBondMe = e -> this.mUnBondMeCommand();
    protected ActionListener mBondMe = e -> this.mBondMeCommand();
    protected ActionListener mReWireMe = e -> {
        Cp.exec((String)"com.sigrity.orbit.automation.wirebonder.WireBonder.bondRing(\"%s\", true)", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
        Cp.exec((String)"UserCommands.removeConnections();", (Object[])new Object[0]);
    };
    protected ActionListener mUnRouteMe = e -> Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouterInterface.routeUnGroupOfBondPadsToBalls(\"%s\")", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
    protected ActionListener mFanoutFC = e -> {
        String devTempKeyStr = mSelectedPersonality.getOwner().getKeyStr();
        String personality = mSelectedPersonality.getName();
        Cp.exec((String)"com.sigrity.orbit.automation.FanOutFactory.doDevTemplatesBumpPadsForFC(\"%s\", \"%s\");", (Object[])new Object[]{devTempKeyStr, personality});
        Cp.exec((String)"com.sigrity.orbit.automation.FanOutFactory.doDevTemplatesBallPadsForFC(\"%s\", \"%s\");", (Object[])new Object[]{devTempKeyStr, personality});
        OrbitIO.getApp().refreshCurrentView(false);
    };
    protected ActionListener mFanoutWB = e -> {
        String devTempKeyStr = mSelectedPersonality.getOwner().getKeyStr();
        String personality = mSelectedPersonality.getName();
        Cp.exec((String)"com.sigrity.orbit.automation.FanOutFactory.doDevTemplatesBallPadsForWB(\"%s\", \"%s\");", (Object[])new Object[]{devTempKeyStr, personality});
        OrbitIO.getApp().refreshCurrentView(false);
    };
    protected ActionListener mCCBB = e -> {
        Substrate substrate = this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
        EvolveConnSolutionDlg.showMe(OrbitIO.getMainWindow(), substrate.getKeyStr(), false);
    };
    protected ActionListener mRouteMeWB = e -> Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouterInterface.routeGroupOfBondPadsToBalls(\"%s\", false)", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
    protected ActionListener mRouteMeFC = e -> Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouterInterface.routeFCGroup(\"%s\")", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
    protected ActionListener mRouteMeRDL = e -> Cp.exec((String)"com.sigrity.orbit.ui.wb_route.RouterInterface.routeRDLFromIOPadGroup(\"%s\", false)", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
    protected ActionListener mRouteQueue = e -> {
        if (mSelectedPersonality != null) {
            LinkedList<String> pKeyStrList = new LinkedList<String>();
            pKeyStrList.add(mSelectedPersonality.getKeyStr());
            RouteQueueDlg dlg = RouteQueueDlg.createDialog((Window)((Object)this), this.mDb, pKeyStrList, null, true);
            dlg.setVisible(true);
        }
    };
    protected ActionListener mRouteVision = e -> RouteQueue.routeVisionOn(mSelectedPersonality);
    protected ActionListener mUnRouteVision = e -> RouteQueue.routeVisionOff();
    protected ActionListener mShowMe = e -> {};
    protected ActionListener mPartialDef = e -> {
        ExportPartialDefDlg dlg = new ExportPartialDefDlg();
        if (dlg.showMe(false)) {
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.writePartialDef(\"%s\", %s, false)", (Object[])new Object[]{mSelectedPersonality.getKeyStr(), Cp.getFileAsArgument((String)dlg.getPath())});
        }
    };
    protected ActionListener mPartialCustom = e -> {
        ExportPartialDefDlg dlg = new ExportPartialDefDlg();
        if (dlg.showMe(true)) {
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.writePartialDef(\"%s\", %s, true)", (Object[])new Object[]{mSelectedPersonality.getKeyStr(), Cp.getFileAsArgument((String)dlg.getPath())});
        }
    };
    protected ActionListener mAddNewRouteGroup = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Substrate substrate = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
            AStrategyGroupNode group = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedStrategyGroups().get(0);
            RouteGroupNameEditor dlg = group.getType() == StrategyGroupType.RDL ? RouteGroupNameEditor.createDialog((Window)((Object)WbFcFeasibilityUI.this), "RDL Route Group", null, substrate, false) : RouteGroupNameEditor.createDialog((Window)((Object)WbFcFeasibilityUI.this), "Package Route Groups", null, substrate, false);
            dlg.setVisible(true);
            if (dlg.getAccepted()) {
                if (group.getType() == StrategyGroupType.RDL) {
                    Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.addRouteGroupDefinition(\"%s\",\"%s\", Personality.Type.RDL)", (Object[])new Object[]{substrate.getName(), dlg.getPersonalityName()});
                } else {
                    Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.addRouteGroupDefinition(\"%s\",\"%s\", Personality.Type.DIEESCAPE)", (Object[])new Object[]{substrate.getName(), dlg.getPersonalityName()});
                }
            }
            UIUtil.closeWindow((Window)((Object)dlg));
            WbFcFeasibilityUI.this.refreshTree();
        }
    };
    protected ActionListener mInteractiveEditor = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
            WbFcFeasibilityUI.this.mIR = new InteractiveRouter();
            WbFcFeasibilityUI.this.mIR.start();
        }
    };
    protected ActionListener mViaAllRouteGroups = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Substrate s = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
            for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
                Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.DIEESCAPE).filter(p -> !p.doesPinPersonalityHavePowerNets()).forEach(p -> {
                    String devTempKeyStr = p.getOwner().getKeyStr();
                    String personality = p.getName();
                    Cp.exec((String)"com.sigrity.orbit.automation.FanOutFactory.doDevTemplatesBumpPadsForFC(\"%s\", \"%s\");", (Object[])new Object[]{devTempKeyStr, personality});
                    Cp.exec((String)"com.sigrity.orbit.automation.FanOutFactory.doDevTemplatesBallPadsForFC(\"%s\", \"%s\");", (Object[])new Object[]{devTempKeyStr, personality});
                });
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener mUnRouteAllRouteGroups = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Substrate s = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
            AStrategyGroupNode node = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedStrategyGroups().get(0);
            if (node.getType() == StrategyGroupType.RDL) {
                for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
                    Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.RDL).forEach(p -> {
                        Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.unRouteRDLPersonality(\"%s\" );", (Object[])new Object[]{p.getKeyStr()});
                        OrbitIO.getApp().refreshCurrentView(false);
                    });
                }
            }
        }
    };
    protected ActionListener mImporDef = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Substrate substrate = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
            WbImportDefFileChooser.createFileChooser((Window)((Object)WbFcFeasibilityUI.this), "Import Ring Definition", substrate);
            WbFcFeasibilityUI.this.refreshTree();
        }
    };
    protected ActionListener mExportDef = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Substrate substrate = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
            WbExportDefFileChooser.createFileChooser((Window)((Object)WbFcFeasibilityUI.this), "Export Ring Definition", substrate);
        }
    };
    protected ActionListener mAddNewBondRingDefinitionF = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Substrate substrate = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
            BondRingDefinitionEditDlg dlg = BondRingDefinitionEditDlg.createDialog((Window)((Object)WbFcFeasibilityUI.this), "Create Wire Bond Ring Definition", null, substrate, true, false, BondRingDefinitionEditDlg.BondRingDialogType.NewFinger);
            dlg.setVisible(true);
        }
    };
    protected ActionListener mAddNewBondRingDefinitionM = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Substrate substrate = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
            BondRingDefinitionEditDlg dlg = BondRingDefinitionEditDlg.createDialog((Window)((Object)WbFcFeasibilityUI.this), "Create Wire Bond Ring Definition", null, substrate, false, false, BondRingDefinitionEditDlg.BondRingDialogType.NewMetal);
            dlg.setVisible(true);
        }
    };
    protected ActionListener mWBExport = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Substrate substrate = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
            WireBondExportDlg wbExportDlg = new WireBondExportDlg((Window)((Object)WbFcFeasibilityUI.this), substrate);
            wbExportDlg.setVisible(true);
        }
    };
    protected ActionListener mDoConnOptEvolve = e -> this.mConnOptEvolveWBConnnectionCommand();
    protected ActionListener mEvolveSolution = e -> this.mEvolveSolution();
    protected ActionListener mReBondAll = e -> {
        this.mUnBondAllCommand();
        this.mBondAllCommand();
    };
    protected ActionListener mBondAll = e -> this.mBondAllCommand();
    protected ActionListener mUnBondAll = e -> this.mUnBondAllCommand();
    protected ActionListener mEditRDLRuleSet = e -> {
        Substrate substrate = this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
        RDLRuleSetDlg rsd = new RDLRuleSetDlg((Window)((Object)this));
        rsd.showMe(substrate.getKeyStr(), RouterRuleSetDlg.DialogMode.EditAnyRule, null);
    };
    protected ActionListener mEditStrategyDefinition = e -> {
        ArrayList<AStrategyNode> selected = this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
        if (selected.size() != 1) {
            return;
        }
        AStrategyNode strategy = selected.get(0);
        Personality personality = strategy.mPersonality;
        Substrate substrate = this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
        if (strategy.mType == StrategyGroupType.DIEESCAPE) {
            RouteGroupNameEditor dlg = RouteGroupNameEditor.createDialog((Window)((Object)this), "Create Personality", personality, substrate, false);
            dlg.setVisible(true);
            if (!dlg.getAccepted()) {
                return;
            }
            dlg.simpleConstraintFrame.doSave((DbObject)personality, substrate, false);
        } else {
            Constraint.RingType rt = (Constraint.RingType)Constraint.getValue((Db)personality.getDb(), (DbObject)personality, (Constraint.Descriptor)Constraint.BONDRING_TYPE);
            BondRingDefinitionEditDlg dlg = BondRingDefinitionEditDlg.createDialog((Window)((Object)this), "Create Personality", personality, substrate, rt == Constraint.RingType.FINGER, false, BondRingDefinitionEditDlg.BondRingDialogType.Edit);
            dlg.setVisible(true);
        }
        this.mWireBondAndRouteStrategyTree.repaint(personality);
    };
    protected ActionListener mCreateRDLRuleSet = e -> {
        Substrate substrate = this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
        RDLRuleSetDlg rsd = new RDLRuleSetDlg((Window)((Object)this));
        rsd.showMe(substrate.getKeyStr(), RouterRuleSetDlg.DialogMode.CreateARule, null);
    };
    JPopupMenu mBondRingStrategyPopupMenu = new JPopupMenu(){
        protected Action mItemImportDef;
        protected Action mItemExportDef;
        protected Action mItemAddFinger;
        protected Action mItemAddMetal;
        protected Action mItemWBExport;
        protected Action mItemBondAll;
        protected Action mItemReBondAll;
        protected Action mItemUnBondAll;
        protected Action mItemEdit;
        protected Action mItemDelete;
        protected Action mItemAddSelectedPorts;
        protected Action mItemSelectPorts;
        protected Action mItemBondRing;
        protected Action mItemReBondRing;
        protected Action mItemUnBondRing;
        {
            this.mItemImportDef = this.add("Import Ring Definitions", WbFcFeasibilityUI.this.mImporDef);
            this.mItemExportDef = this.add("Export Ring Definitions", WbFcFeasibilityUI.this.mExportDef);
            this.mItemAddFinger = this.add("Add Ring (Finger) Definition...", WbFcFeasibilityUI.this.mAddNewBondRingDefinitionF);
            this.mItemAddMetal = this.add("Add Ring (Metal) Definition...", WbFcFeasibilityUI.this.mAddNewBondRingDefinitionM);
            this.mItemWBExport = this.add("Wire Bond Export", WbFcFeasibilityUI.this.mWBExport);
            this.mItemBondAll = this.add("Bond All Rings", WbFcFeasibilityUI.this.mBondAll);
            this.mItemUnBondAll = this.add("UnBond All Rings", WbFcFeasibilityUI.this.mUnBondAll);
            this.mItemReBondAll = this.add("ReBond All Rings", WbFcFeasibilityUI.this.mReBondAll);
            this.addSeparator();
            this.mItemEdit = this.add("Edit Constraints...", WbFcFeasibilityUI.this.mEditStrategyDefinition);
            this.mItemDelete = this.add("Delete", WbFcFeasibilityUI.this.mDeleteStrategy);
            this.mItemAddSelectedPorts = this.add("Add Selected Pins", WbFcFeasibilityUI.this.mAddSelectedPorts);
            this.mItemAddSelectedPorts = this.add("Add Selected Signal Pins", WbFcFeasibilityUI.this.mAddSelectedSinglePorts);
            this.mItemAddSelectedPorts = this.add("Remove Selected Pins", WbFcFeasibilityUI.this.mRemoveSelectedPorts);
            this.mItemSelectPorts = this.add("Select Pins", WbFcFeasibilityUI.this.mSelectPortsOfStrategy);
            this.addSeparator();
            this.mItemBondRing = this.add("Bond Ring", WbFcFeasibilityUI.this.mBondMe);
            this.mItemUnBondRing = this.add("UnBond Ring", WbFcFeasibilityUI.this.mUnBondMe);
            this.mItemReBondRing = this.add("ReBond Ring", WbFcFeasibilityUI.this.mReBondMe);
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            super.show(invoker, x, y);
        }

        protected void prepare(int x, int y) {
            ArrayList<AStrategyNode> selBondRingDefinitions = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
            ArrayList<AStrategyGroupNode> selBondStrategies = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedStrategyGroups();
            if (selBondRingDefinitions.size() == 1) {
                mSelectedPersonality = selBondRingDefinitions.get((int)0).mPersonality;
            }
            boolean license = true;
            this.mItemImportDef.setEnabled(selBondStrategies.size() == 1 && license);
            this.mItemExportDef.setEnabled(selBondStrategies.size() == 1 && license);
            this.mItemAddFinger.setEnabled(selBondStrategies.size() == 1 && license);
            this.mItemAddMetal.setEnabled(selBondStrategies.size() == 1 && license);
            this.mItemWBExport.setEnabled(selBondStrategies.size() == 1 && license);
            this.mItemBondAll.setEnabled(selBondStrategies.size() == 1 && license);
            this.mItemUnBondAll.setEnabled(selBondStrategies.size() == 1 && license);
            this.mItemReBondAll.setEnabled(selBondStrategies.size() == 1 && license);
            this.mItemEdit.setEnabled(selBondRingDefinitions.size() == 1 && license);
            this.mItemDelete.setEnabled(selBondRingDefinitions.size() == 1 && license);
            this.mItemAddSelectedPorts.setEnabled(selBondRingDefinitions.size() == 1 && license);
            this.mItemSelectPorts.setEnabled(selBondRingDefinitions.size() == 1 && license);
            this.mItemBondRing.setEnabled(selBondRingDefinitions.size() == 1 && license);
            this.mItemUnBondRing.setEnabled(selBondRingDefinitions.size() == 1 && license);
            this.mItemReBondRing.setEnabled(selBondRingDefinitions.size() == 1 && license);
        }
    };
    JPopupMenu mSubstrateGroupEditor = new JPopupMenu(){
        protected Action mAddNewRouteGroupAction;
        {
            this.mAddNewRouteGroupAction = this.add("Add Route Group...", WbFcFeasibilityUI.this.mAddNewRouteGroup);
            this.addSeparator();
            this.add("Edit Rule Sets...", WbFcFeasibilityUI.this.mEditRDLRuleSet);
            this.add("Create a Rule Set...", WbFcFeasibilityUI.this.mCreateRDLRuleSet);
            this.addSeparator();
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            super.show(invoker, x, y);
        }

        protected void prepare(int x, int y) {
            boolean license = true;
            this.mAddNewRouteGroupAction.setEnabled(license);
        }
    };
    JPopupMenu mRDLStrategyPopup = new RouteGroupPopup(Personality.Type.RDL);
    JPopupMenu mFCStrategyPopup = new RouteGroupPopup(Personality.Type.DIEESCAPE);
    protected WbAndFCStrategyTree.PopupMenuHandler mTreePopupMenuHandler = new WbAndFCStrategyTree.PopupMenuHandler(){

        @Override
        public void handlePopup(int x, int y) {
            ALazyTreeNode node;
            ArrayList<AStrategyNode> selStrategy = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
            ArrayList<AStrategyGroupNode> selStrategyGroups = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedStrategyGroups();
            if (selStrategy.size() == 1) {
                node = selStrategy.get(0);
                if (node.mType == StrategyGroupType.Wirebond) {
                    WbFcFeasibilityUI.this.mBondRingStrategyPopupMenu.show(WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree, x, y);
                } else if (node.mType == StrategyGroupType.DIEESCAPE) {
                    WbFcFeasibilityUI.this.mFCStrategyPopup.show(WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree, x, y);
                } else if (node.mType == StrategyGroupType.RDL) {
                    WbFcFeasibilityUI.this.mRDLStrategyPopup.show(WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree, x, y);
                }
            } else if (selStrategyGroups.size() == 1) {
                node = selStrategyGroups.get(0);
                if (node.mType == StrategyGroupType.Wirebond) {
                    WbFcFeasibilityUI.this.mBondRingStrategyPopupMenu.show(WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree, x, y);
                } else if (node.mType == StrategyGroupType.DIEESCAPE) {
                    WbFcFeasibilityUI.this.mSubstrateGroupEditor.show(WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree, x, y);
                } else if (node.mType == StrategyGroupType.RDL) {
                    WbFcFeasibilityUI.this.mSubstrateGroupEditor.show(WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree, x, y);
                }
            }
            LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
            TreePath tp = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectionPath();
            if (tp == null) {
                return;
            }
            Object selObj = tp.getLastPathComponent();
            if (selObj instanceof ContextMenuSupport) {
                ContextMenuSupport cms = (ContextMenuSupport)selObj;
                cms.populateMenuItems(menuItems);
            }
            if (menuItems.size() < 1) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            for (JMenuItem mi : menuItems) {
                if (mi == null) {
                    popup.addSeparator();
                    continue;
                }
                popup.add(mi);
            }
            popup.show(WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree, x, y);
        }
    };

    public static void create(Window owner, AAppView view) {
        WbFcFeasibilityUI wbui = new WbFcFeasibilityUI(view, owner);
        wbui.setVisible(true);
    }

    public static void setShowWirebonding(boolean b) {
        sShowWireBonding = b;
    }

    public WbFcFeasibilityUI(AAppView view, Component owner) throws HeadlessException {
        super(view.getDb(), owner);
        this.setView(view);
        this.init();
    }

    protected void init() {
        this.setTitle("Route Feasibility");
        this.mDb = OrbitIO.getCurDb();
        GridBagManager l = new GridBagManager(this.getContentPane());
        JPanel pnlPersonalities = new JPanel();
        pnlPersonalities.setBorder(BorderFactory.createTitledBorder("Substrates"));
        l.push((Container)pnlPersonalities, (GridBagConstraints)GridBagManager.FILLALL);
        ATreeModel tm = new ATreeModel();
        this.mWireBondAndRouteStrategyTree = new WbAndFCStrategyTree(tm);
        tm.setRoot((TreeNode)((Object)new RootNode(tm, this.mDb)));
        this.mWireBondAndRouteStrategyTree.setCellRenderer((TreeCellRenderer)((Object)new BRCellRenderer()));
        this.mWireBondAndRouteStrategyTree.setRootVisible(false);
        this.mWireBondAndRouteStrategyTree.setShowsRootHandles(true);
        this.mWireBondAndRouteStrategyTree.setPopupMenuHandler(this.mTreePopupMenuHandler);
        JScrollPane spPers = new JScrollPane(this.mWireBondAndRouteStrategyTree);
        l.add((Component)spPers, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX.noInsets());
        l.pop();
        l.pop();
        l.newline();
        if (pnlPersonalities.getPreferredSize().width < 200) {
            pnlPersonalities.setPreferredSize(new Dimension(200, 200));
        }
        this.mProgressMeter = new JProgressBar(0, 100);
        this.mProgressMeter.setStringPainted(true);
        l.add((Component)this.mProgressMeter, (GridBagConstraints)GridBagManager.FILLX);
        this.mListener = new SingleLayerRouter.LoadListener(){

            @Override
            public void stats(int percent, boolean done, String data) {
                if (done) {
                    percent = 100;
                }
                WbFcFeasibilityUI.this.mProgressMeter.setValue(percent);
                Object s = done ? data : percent + "% " + data;
                WbFcFeasibilityUI.this.mProgressMeter.setString((String)s);
                Dimension d = WbFcFeasibilityUI.this.mProgressMeter.getSize();
                WbFcFeasibilityUI.this.mProgressMeter.paintImmediately(0, 0, d.width, d.height);
                if (done) {
                    // empty if block
                }
            }
        };
        SingleLayerRouter.addLoadListener(this.mListener);
        l.newline();
        JButton btnClose = new JButton("Close");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        this.expandAll(this.mWireBondAndRouteStrategyTree, true, 3);
        DbClass dbcPersonality = this.mDb.getDbClass(Personality.class);
        assert (dbcPersonality != null);
        dbcPersonality.addObjectListener(this.mPersonalityListener, DbClass.DbObjectEventType.getUpdated());
        for (String relName : PERSONALITY_RELATIONS) {
            DbRelationDef rd = this.mDb.getRelation(relName);
            assert (rd != null);
            rd.addRelationListener(this.mRelationListener, DbRelationDef.RELATION_UPDATED);
        }
    }

    public void restoreExpansion(JTree tree) {
        TreeModel tm = this.mWireBondAndRouteStrategyTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
        this.restoreExpansion(tree, new TreePath((Object)rn));
        this.mWireBondAndRouteStrategyTree.scrollPathToVisible(this.mWireBondAndRouteStrategyTree.getSelectionPath());
        refreshPending = false;
    }

    protected void restoreExpansion(JTree tree, TreePath tp) {
        TreeNode node = (TreeNode)tp.getLastPathComponent();
        if (node.getChildCount() > 0) {
            ALazyTreeNode sn;
            if (node instanceof AStrategyGroupNode && !lastExpandedSet.contains((sn = (AStrategyGroupNode)((Object)node)).getName())) {
                return;
            }
            if (node instanceof AStrategyNode && !lastExpandedSet.contains((sn = (AStrategyNode)((Object)node)).getName())) {
                return;
            }
            Enumeration<? extends TreeNode> e = node.children();
            while (e != null && e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = tp.pathByAddingChild(n);
                this.restoreExpansion(tree, path);
            }
            tree.expandPath(tp);
        } else {
            tree.collapsePath(tp);
        }
    }

    public void refreshTree() {
        if (refreshPending) {
            return;
        }
        refreshPending = true;
        this.saveCurrentExpansion();
        TreeModel tm = this.mWireBondAndRouteStrategyTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
        EventQueue.invokeLater(() -> this.restoreExpansion(this.mWireBondAndRouteStrategyTree));
    }

    protected void saveCurrentExpansion(JTree tree, TreePath tp) {
        Enumeration<TreePath> expanded = tree.getExpandedDescendants(tp);
        if (expanded != null) {
            ALazyTreeNode sn;
            if (tp.getLastPathComponent() instanceof AStrategyGroupNode) {
                sn = (AStrategyGroupNode)((Object)tp.getLastPathComponent());
                lastExpandedSet.add(sn.getName());
            }
            if (tp.getLastPathComponent() instanceof AStrategyNode) {
                sn = (AStrategyNode)((Object)tp.getLastPathComponent());
                lastExpandedSet.add(sn.getName());
            }
            for (TreePath p : AUtil.getIterable(expanded)) {
                this.saveCurrentExpansion(tree, p);
            }
        }
    }

    protected void saveCurrentExpansion() {
        lastExpandedSet = new ArrayList();
        TreePath rootPath = new TreePath(this.mWireBondAndRouteStrategyTree.getModel().getRoot());
        this.saveCurrentExpansion(this.mWireBondAndRouteStrategyTree, rootPath);
    }

    protected void clearTree() {
        ATreeModel tm = (ATreeModel)this.mWireBondAndRouteStrategyTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
    }

    protected void expandHierLevels() {
        ATreeModel tm = (ATreeModel)this.mWireBondAndRouteStrategyTree.getModel();
        RootNode rn = (RootNode)((Object)tm.getRoot());
        rn.invalidateChildren();
        this.expandAll(this.mWireBondAndRouteStrategyTree, true, 5);
        this.mWireBondAndRouteStrategyTree.scrollPathToVisible(this.mWireBondAndRouteStrategyTree.getSelectionPath());
    }

    public void removeNotify() {
        DbClass dbcPersonality = this.mDb.getDbClass(Personality.class);
        if (dbcPersonality == null) {
            return;
        }
        dbcPersonality.removeObjectListener(this.mPersonalityListener, DbClass.DbObjectEventType.getUpdated());
        for (String relName : PERSONALITY_RELATIONS) {
            DbRelationDef rd = this.mDb.getRelation(relName);
            assert (rd != null);
            rd.removeRelationListener(this.mRelationListener, DbRelationDef.RELATION_UPDATED);
        }
        super.removeNotify();
    }

    protected RootNode getRootNode() {
        return (RootNode)((Object)this.mWireBondAndRouteStrategyTree.getModel().getRoot());
    }

    protected Personality getSelectedPersonality() {
        ArrayList<AStrategyNode> selected = this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
        if (selected.size() != 1) {
            return null;
        }
        return selected.get((int)0).mPersonality;
    }

    protected void mBondMeCommand() {
        Cp.exec((String)"com.sigrity.orbit.automation.wirebonder.WireBonder.bondRing(\"%s\")", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
        Cp.exec((String)"UserCommands.removeConnections();", (Object[])new Object[0]);
    }

    protected void mUnBondMeCommand() {
        Cp.exec((String)"com.sigrity.orbit.automation.wirebonder.WireBonder.unBondRing(\"%s\")", (Object[])new Object[]{mSelectedPersonality.getKeyStr()});
        Cp.exec((String)"UserCommands.removeConnections();", (Object[])new Object[0]);
    }

    public static void writePartialDef(String personalityKey, String fileName, boolean custom) {
        Personality p = Personality.getByKeyStr((Db)OrbitIO.getCurDb(), (String)personalityKey);
        LinkedList<Wire> wires = new LinkedList<Wire>();
        ArrayList<DevicePath> devices = new ArrayList<DevicePath>();
        ArrayList<HierPin> vias = new ArrayList<HierPin>();
        if (p.getType() == Personality.Type.RDL) {
            DevicePath diePath = null;
            for (PinInstance ioPad : PinInstance.getRoutePins((Personality)p)) {
                DevicePath ioPadPath = ioPad.getDevice().getADevicePath();
                diePath = ioPadPath.pathToLowestDie();
                HierPin dppIOPad = new HierPin(ioPadPath, ioPad);
                if (ioPad.getFirstExternallyConnected() != null) {
                    vias.add(new HierPin(diePath, ioPad.getFirstExternallyConnected()));
                }
                if ((wires = BundleCommands.getRoutes(dppIOPad, diePath.getDeviceTemplate(), null)).isEmpty()) continue;
                wires.add(wires.get(0));
            }
            for (SchedConn sc : p.getSchedConns()) {
                devices.add(sc.getDevicePathA());
                devices.add(sc.getDevicePathB());
            }
            if (custom) {
                DEFOut.writeCustom(wires, vias, fileName);
            } else {
                if (diePath == null) {
                    ALog.logWarn((String)"There is nothing to write");
                }
                DEFOut defout = new DEFOut();
                WireFilter jtwf = new WireFilter();
                jtwf.setWires(wires);
                defout.setJustTheseWiresFilter(jtwf);
                DeviceFilter jtdf = new DeviceFilter();
                jtdf.setDevices(devices);
                defout.setJustTheseDevicesFilter(jtdf);
                defout.write(diePath, false, true, fileName, false);
            }
        }
    }

    protected static boolean isRouted(HierPin hp, DeviceTemplate dt, Bundle b) {
        LinkedList<Wire> wires = BundleCommands.getRoutes(hp, dt, b);
        return !wires.isEmpty();
    }

    protected boolean hasRoutes(Personality p) {
        if (p.getType() == Personality.Type.RDL) {
            for (PinInstance ioPad : PinInstance.getRoutePins((Personality)p)) {
                DevicePath ioPadPath = ioPad.getDevice().getADevicePath();
                HierPin dppIOPad = new HierPin(ioPadPath, ioPad);
                if (!WbFcFeasibilityUI.isRouted(dppIOPad, ioPadPath.pathToLowestDie().getDeviceTemplate(), null)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean anyHasRoutes() {
        Substrate s = this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
        for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
            if (!Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.RDL).anyMatch(p -> this.hasRoutes((Personality)p))) continue;
            return true;
        }
        return false;
    }

    static HashSet<Layer> getPotentialRouteLayers(Personality p) {
        HashSet<Layer> layers = new HashSet<Layer>();
        for (SchedConn sc : p.getSchedConns()) {
            Layer secondary;
            RuleSet rs = RuleSetMgr.getMyRuleSet((DbObject)sc);
            if (rs == null) continue;
            Layer primary = (Layer)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.ROUTE_LAYER, null);
            if (primary != null) {
                layers.add(primary);
            }
            if ((secondary = (Layer)RuleSetMgr.getConstraintValue((RuleSet)rs, (Constraint.Descriptor)Constraint.SEC_ROUTE_LAYER, null)) == null) continue;
            layers.add(secondary);
        }
        return layers;
    }

    static SchedConn getSchedConnOfIOPad(Personality personality, PinInstance p) {
        for (SchedConn sc : personality.getSchedConns()) {
            if (sc.getDevicePathA() == null || !sc.getHierPortA().complete() || !sc.getHierPortA().getPin().equals(p)) continue;
            return sc;
        }
        return null;
    }

    public static void unRouteRDLPersonality(String pKeyStr) {
        WbFcFeasibilityUI.unRouteRDLPersonality(pKeyStr, true);
    }

    public static void unRouteRDLPersonality(String pKeyStr, boolean removeVias) {
        Db db = OrbitIO.getCurDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)pKeyStr);
        RouterMgmt.unRouteRDLPersonality((Personality)p, (boolean)removeVias);
    }

    protected void mEvolveSolution() {
        Substrate substrate = this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
        EvolveWBSolutionDlg.showMe(OrbitIO.getMainWindow(), substrate.getKeyStr());
    }

    protected void mConnOptEvolveWBConnnectionCommand() {
        Substrate substrate = this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
        EvolveConnSolutionDlg.showMe(OrbitIO.getMainWindow(), substrate.getKeyStr(), true);
    }

    protected void mBondAllCommand() {
        Substrate substrate = this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
        Cp.exec((String)"com.sigrity.orbit.automation.wirebonder.WireBonder.bondSubstrate(\"%s\");", (Object[])new Object[]{substrate.getKeyStr()});
        Cp.exec((String)"UserCommands.removeConnections();", (Object[])new Object[0]);
    }

    protected void mUnBondAllCommand() {
        Substrate substrate = this.mWireBondAndRouteStrategyTree.getSelectedSubstrates().get(0);
        Cp.exec((String)"com.sigrity.orbit.automation.wirebonder.WireBonder.unBondSubstrate(\"%s\");", (Object[])new Object[]{substrate.getKeyStr()});
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static Action getGuidedRouteAction(DesignView2D view, DevicePath path, PinTemplate dtp) {
        if (path == null || dtp == null) {
            return null;
        }
        PinInstance port = PinInstance.getPinInstance((Device)path.getLast(), (PinTemplate)dtp);
        if (port == null) {
            return null;
        }
        Personality routeGroup = port.getRouteGroup();
        if (routeGroup == null) {
            return null;
        }
        return new InteractiveGuidedRouteAction(view, path, port);
    }

    boolean isConnected(PinInstance dp) {
        Device d = dp.getDevice();
        DevicePath dpath = d.getADevicePath();
        Device die = dpath.pathToLowestDie().getLast();
        Net top = NetMap.getNetAt((Net)dp.getNet(), (DevicePath)dpath, (DeviceTemplate)die.getTemplate());
        return top.getDeviceTemplate() == die.getTemplate();
    }

    public static LinkedList<Wire> getRoutes(SchedConn sc) {
        Bundle bundle = null;
        DbObject owner = sc.getOwner();
        if (owner instanceof Personality) {
            bundle = Bundle.getBundle((Personality)((Personality)owner));
        }
        assert (sc.getDb() != null);
        return BundleCommands.getRoutes(sc.getDPPA(), sc.getOwningTemplate(), bundle);
    }

    protected void setView(AAppView view) {
        this.mView = view;
        this.mDb = view.getDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
    }

    public static void deleteStrategy(String pKeyStr) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        Personality p = Personality.getByKeyStr((Db)db, (String)pKeyStr);
        if (p == null) {
            ALog.logWarn((String)"Can not wire bond ring definition");
            return;
        }
        RouterMgmt.deleteStrategy((Personality)p);
    }

    public static void addSelectedPortsToStrategy(String pKeyStr) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        Selection s = design.getCurSelection();
        Personality p = Personality.getByKeyStr((Db)db, (String)pKeyStr);
        if (p == null) {
            ALog.logWarn((String)"Invalid Personality '%s'.", (Object[])new Object[]{pKeyStr});
            return;
        }
        for (PinInstance dp : s.get(PinInstance.class)) {
            Personality.Type ptype = p.getType();
            if (ptype == Personality.Type.BONDRING) {
                Personality currentPersonalityOnSameSubstrate = dp.belongsToAnotherPersonalityOnSameDeviceTemplateAs(p);
                if (currentPersonalityOnSameSubstrate != null) {
                    dp.unAssignToBondRingDefinition(currentPersonalityOnSameSubstrate);
                }
                if (dp.belongsToRing(p)) continue;
                dp.assignToBondRingDefinition(p);
                continue;
            }
            if (p == dp.getRouteGroup()) continue;
            if (ptype == Personality.Type.DIEESCAPE) {
                if (dp.getType() != PinTemplate.Type.BUMPPAD) continue;
                dp.assignToRouteDefinition(p);
                continue;
            }
            if (dp.getType() == PinTemplate.Type.BUMPPAD) continue;
            dp.assignToRouteDefinition(p);
        }
    }

    public static void addSelectedSinglePortsToStrategy(String pKeyStr) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        Selection s = design.getCurSelection();
        Personality p = Personality.getByKeyStr((Db)db, (String)pKeyStr);
        if (p == null) {
            ALog.logWarn((String)"Invalid Personality '%s'.", (Object[])new Object[]{pKeyStr});
            return;
        }
        HashSet pins = new HashSet();
        s.getSelectedHierInsts(PinInstance.class).forEach(pinH -> {
            Boolean power;
            PinInstance dp = (PinInstance)pinH.getDbObject();
            DevicePath path = pinH.getPath();
            HierPin hp = new HierPin(path, dp);
            Net n = hp.getSubstrateNet();
            Personality personality = n.getPersonality();
            boolean addPin = true;
            if (personality != null && (power = (Boolean)Constraint.getValue((Db)db, (DbObject)personality, (Constraint.Descriptor)Constraint.IS_POWER)) != null && power.booleanValue()) {
                addPin = false;
            }
            if (addPin) {
                pins.add(dp);
            }
        });
        for (PinInstance dp : pins) {
            Personality.Type ptype = p.getType();
            if (ptype == Personality.Type.BONDRING) {
                Personality currentPersonalityOnSameSubstrate = dp.belongsToAnotherPersonalityOnSameDeviceTemplateAs(p);
                if (currentPersonalityOnSameSubstrate != null) {
                    dp.unAssignToBondRingDefinition(currentPersonalityOnSameSubstrate);
                }
                if (dp.belongsToRing(p)) continue;
                dp.assignToBondRingDefinition(p);
                continue;
            }
            if (p == dp.getRouteGroup()) continue;
            if (ptype == Personality.Type.DIEESCAPE) {
                if (dp.getType() != PinTemplate.Type.BUMPPAD) continue;
                dp.assignToRouteDefinition(p);
                continue;
            }
            if (dp.getType() == PinTemplate.Type.BUMPPAD) continue;
            dp.assignToRouteDefinition(p);
        }
    }

    public static void removeSelectedPortsToStrategy(String pKeyStr) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        Selection s = design.getCurSelection();
        Personality p = Personality.getByKeyStr((Db)db, (String)pKeyStr);
        if (p == null) {
            ALog.logWarn((String)"Invalid Personality '%s'.", (Object[])new Object[]{pKeyStr});
            return;
        }
        for (PinInstance dp : s.get(PinInstance.class)) {
            Personality.Type ptype = p.getType();
            if (ptype != Personality.Type.BONDRING || !dp.belongsToRing(p)) continue;
            dp.unAssignToBondRingDefinition(p);
        }
    }

    public static void selectPortsOfStrategy(String pKeyStr) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        Selection s = design.getCurSelection();
        Personality p = Personality.getByKeyStr((Db)db, (String)pKeyStr);
        if (p == null) {
            ALog.logWarn((String)"Can not wire bond ring definition");
            return;
        }
        DeviceTemplate devTemp = p.getOwner();
        DevicePath devicePath = null;
        for (DevicePath path2 : design.getDescendantDevices()) {
            if (!path2.getLast().getIsSubstrate() || path2.getLast().getTemplate() != devTemp) continue;
            devicePath = path2;
        }
        if (p.getType() == Personality.Type.BONDRING) {
            for (PinInstance port : PinInstance.getBondRingPins((Personality)p)) {
                s.add(devicePath, (DbObject)port);
            }
        } else {
            for (PinInstance port : PinInstance.getRoutePins((Personality)p)) {
                Device subDevice = devicePath == null ? null : devicePath.getLast();
                DevicePath portPath = port.getDevice().getAllPaths().filter(path -> path.contains(subDevice)).findFirst().orElse(null);
                s.add(portPath, (DbObject)port);
            }
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static boolean addWireBondRingDefinition(String name, String devTempKeyStr) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot add personality, no current database.");
            return false;
        }
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        Optional personality = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING, (String)name);
        if (personality.isPresent()) {
            ALog.logWarn((String)"Overwrite '%s', a personality by that name already exists.", (Object[])new Object[]{name});
            return false;
        }
        Personality p = new Personality(devTemp, Personality.Type.BONDRING, name);
        db.add((DbObject)p);
        return true;
    }

    @Deprecated
    public static boolean addWireBondRingDefintion(String name, String substrateName) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot add personality, no current database.");
            return false;
        }
        Substrate substrate = Substrate.getSubstrate((Db)db, (String)substrateName);
        Personality personality = Personality.getPersonality((Substrate)substrate, (Personality.Type)Personality.Type.BONDRING, (String)name);
        if (personality != null) {
            ALog.logError((String)"Cannot add '%s', a personality by that name already exists.", (Object[])new Object[]{name});
            return false;
        }
        personality = new Personality(name, Personality.Type.BONDRING, substrate);
        db.add((DbObject)personality);
        return true;
    }

    public static boolean addRDLRouteGroupDefintionForDevTemp(String devTempKeyStr, String name) {
        return WbFcFeasibilityUI.addRouteGroupDefinitionForDevTemp(devTempKeyStr, name, Personality.Type.RDL);
    }

    public static boolean addRouteGroupDefinitionForDevTemp(String devTempKeyStr, String name, Personality.Type type) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot add personality, no current database.");
            return false;
        }
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        if (devTemp == null) {
            ALog.logError((String)"Cannot add personality, no DeviceTemplate found.");
            return false;
        }
        Optional personality = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)type, (String)name);
        if (!personality.isPresent()) {
            personality = Personality.create((DeviceTemplate)devTemp, (Personality.Type)type, (String)name);
            if (type != Personality.Type.NET && personality.isPresent()) {
                Optional netP = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.NET, (String)name);
                if (netP.isPresent()) {
                    ((Personality)personality.get()).setColor(((Personality)netP.get()).getColor());
                } else {
                    ((Personality)personality.get()).setColor(AUtil.colorFromString((String)Personality.nextColor()));
                }
            }
        } else {
            ALog.logError((String)"Cannot add '%s', a personality by that name already exists.", (Object[])new Object[]{name});
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean addRDLRouteGroupDefintion(String substrateName, String name) {
        return WbFcFeasibilityUI.addRouteGroupDefinition(substrateName, name, Personality.Type.RDL);
    }

    @Deprecated
    public static boolean addRouteGroupDefinition(String substrateName, String name, Personality.Type type) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot add personality, no current database.");
            return false;
        }
        Substrate substrate = Substrate.getSubstrate((Db)db, (String)substrateName);
        substrate.getSubstrateTemplates().forEach(devTemp -> Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)type, (String)name, createdPers -> {
            Optional netP = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)type, (String)name);
            if (netP.isPresent()) {
                createdPers.setColor(((Personality)netP.get()).getColor());
            } else {
                createdPers.setColor(AUtil.colorFromString((String)Personality.nextColor()));
            }
        }, existingPers -> ALog.logError((String)"Cannot add '%s', a personality by that name already exists.", (Object[])new Object[]{name})));
        return true;
    }

    public void expandAll(JTree tree, boolean expand, int stopDepth) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand, 0, stopDepth);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand, int depth, int stopDepth) {
        if (depth >= stopDepth) {
            return;
        }
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e != null && e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand, depth + 1, stopDepth);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void diffPairReport(String devicePathString, String fileName, String layerName) {
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)"'%s' is not a device path", (Object[])new Object[]{devicePathString});
            return;
        }
        Device device = devicePath.getLast();
        Substrate s = device.getSubstrate();
        AMutableReference layer = new AMutableReference(null);
        if (!layerName.isEmpty()) {
            layer.set((Object)s.getLayer(layerName));
            if (layer.get() == null) {
                ALog.logError((String)"'%s' is not a layer on '%s'", (Object[])new Object[]{layerName, s});
                return;
            }
        }
        try (PrintStream ps = new PrintStream(new FileOutputStream(fileName));){
            ps.println("Diff Pair Name,Skew,Routed");
            ArrayList<Personality> diffPairs = new ArrayList<Personality>();
            for (Net net : device.getNets()) {
                Boolean matchLength;
                Personality p = net.getPersonality();
                if (p == null || (matchLength = (Boolean)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH)) == null || !matchLength.booleanValue() || diffPairs.contains(p)) continue;
                diffPairs.add(p);
            }
            long skewSum = 0L;
            int skews = 0;
            Collections.sort(diffPairs);
            for (Personality personality : diffPairs) {
                ArrayList netsInPersonality = new ArrayList();
                ArrayList lengthsOfNetsInPersonality = new ArrayList();
                MutableBoolean hasWires = MutableBoolean.create((boolean)false);
                personality.getPersonalityMaps().forEach(pm -> {
                    Net n = (Net)pm.getObject();
                    netsInPersonality.add(n);
                    long l = 0L;
                    HierPin dpLast = null;
                    for (HierPin hdp : NetMap.getConnectedDevicePathPorts((Net)n, (DevicePath)devicePath)) {
                        PinInstance dp = (PinInstance)hdp.second;
                        if (!dp.hasShapeOnLayer((Layer)layer.get())) continue;
                        if (dpLast == null) {
                            dpLast = hdp;
                            continue;
                        }
                        Wire w = Wire.connects((PinInstance)dp, (PinInstance)((PinInstance)dpLast.second));
                        if (w != null) {
                            hasWires.set(true);
                            l += w.getLength();
                            continue;
                        }
                        l += hdp.dist(dpLast);
                    }
                    lengthsOfNetsInPersonality.add(l);
                });
                long skew = Math.abs((Long)lengthsOfNetsInPersonality.get(0) - (Long)lengthsOfNetsInPersonality.get(1));
                double skewUser = unit.toUser(skew);
                skewSum += skew;
                ++skews;
                ps.println(personality.getName() + "," + skewUser + "," + hasWires);
            }
            if (skews > 0) {
                ps.println("Average Skew," + unit.toUser(skewSum / (long)skews));
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    protected class BRCellRenderer
    extends ATreeCellRenderer {
        protected BRCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            if (value instanceof AStrategyNode) {
                long ports;
                Color color;
                Personality p = ((AStrategyNode)((Object)value)).mPersonality;
                if (p.getDb() == null) {
                    this.setText("?");
                    return c;
                }
                if (p.getType() == Personality.Type.BONDRING) {
                    Constraint.RingType rt = (Constraint.RingType)Constraint.getValue((Db)p.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.BONDRING_TYPE);
                    color = rt == Constraint.RingType.METAL ? Color.YELLOW : Color.ORANGE;
                    ports = PinInstance.getBondRingPinCount((Personality)p);
                } else {
                    color = p.getColor();
                    ports = PinInstance.getRoutePinCount((Personality)p);
                }
                this.setIcon((Icon)new AColorIcon(12, 12, color));
                this.setText(p.getName() + "(" + ports + ")");
            }
            if (value instanceof AStrategyGroupNode) {
                this.setIcon(DbExplorerPanel.getFolderIcon());
            }
            if (value instanceof SubstrateNode) {
                DeviceTemplate dt = ((SubstrateNode)((Object)value)).deviceTemplate;
                this.setIcon(DbExplorerPanel.getIconForTemplate(dt));
            }
            if (value instanceof PortNode) {
                PinInstance dp = ((PortNode)value).port;
                DevicePath dPath = ((PortNode)value).devPath;
                HierPin dpp = new HierPin(dPath, dp);
                Object text = dpp.toString();
                text = WbFcFeasibilityUI.isRouted(dpp, dPath.pathToSubstrate().getDeviceTemplate(), null) ? (String)text + " ROUTED" : (String)text + " NOT ROUTED";
                this.setText((String)text);
                PinTemplate mPort = dp.getPinTemplate();
                if (mPort.getType() == PinTemplate.Type.BUMPPAD) {
                    this.setIcon(DBEResources.ICON_BUMP);
                }
                if (mPort.getType() == PinTemplate.Type.IOPAD) {
                    this.setIcon(DBEResources.ICON_PAD);
                }
            }
            return c;
        }
    }

    public static class InteractiveGuidedRouteAction
    extends AbstractAction {
        protected DesignView2D mView;
        protected DevicePath mPath;
        protected PinInstance mPort;

        protected InteractiveGuidedRouteAction(DesignView2D view, DevicePath path, PinInstance port) {
            super("Interactively Route (Guided)", ICON_ROUTE_ADD);
            this.mView = view;
            this.mPath = path;
            this.mPort = port;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Personality personality = this.mPort.getRouteGroup();
            if (personality == null) {
                ALog.logWarn((String)"Unable to determine route group.");
                return;
            }
            Layer layer = null;
            Constraint c = Constraint.getConstraint((Db)personality.getDb(), (DbObject)personality, (Constraint.Descriptor)Constraint.ROUTE_LAYER);
            if (c != null) {
                layer = (Layer)c.getValue();
            }
            if (layer == null) {
                ALog.logWarn((String)"Unable to determine routing layer.");
                return;
            }
            List candidates = NetMap.getConnectedDevicePathPorts((Net)this.mPort.getNet(), (DevicePath)this.mPath);
            HierPin to = null;
            for (HierPin candidate : candidates) {
                if (candidate.getPin().getType() != PinTemplate.Type.BUMPPAD) continue;
                to = candidate;
                break;
            }
            if (to == null) {
                ALog.logWarn((String)"Unable to determine other end of connection.");
                return;
            }
            DevicePath routeOnDevice = this.mPath.commonParent(to.getPath());
            InteractiveGuidedRouter router = InteractiveGuidedRouter.getRouter(this.mView, routeOnDevice, layer, true);
            HierPin from = new HierPin(this.mPath, this.mPort);
            router.startRoute(from, to);
        }
    }

    public static class ShowMeAction
    extends AbstractAction {
        protected PinInstance port;
        protected DevicePath path;

        protected ShowMeAction(PinInstance port, DevicePath path) {
            super("Show Me");
            this.port = port;
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowMeTheWay.addHierPin(new HierPin(this.path, this.port));
        }
    }

    public static class RemoveWireAction
    extends AbstractAction {
        protected PinInstance port;
        protected DevicePath path;

        protected RemoveWireAction(DevicePath path, PinInstance port) {
            super("Remove Wire");
            this.port = port;
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class PortNode
    extends ATreeNode
    implements ContextMenuSupport {
        protected PinInstance port;
        protected DevicePath devPath;

        public PortNode(ATreeNode parent, PinInstance port, DevicePath devPath) {
            super(parent);
            this.port = port;
            this.devPath = devPath;
        }

        public String getText() {
            return this.port.getName();
        }

        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        public int getChildCount() {
            return 0;
        }

        public int getIndex(TreeNode node) {
            return -1;
        }

        public Enumeration<TreeNode> children() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        public void render(ATreeCellRenderer r) {
            super.render(r);
            Icon icon = this.getIcon();
            if (icon != null) {
                r.setIcon(icon);
            }
        }

        public Icon getIcon() {
            return null;
        }

        public PinInstance getPort() {
            return this.port;
        }

        public DevicePath getDevicePath() {
            return this.devPath;
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            if (WbFcFeasibilityUI.this.mView instanceof DesignView2D) {
                DesignView2D view2D = (DesignView2D)WbFcFeasibilityUI.this.mView;
                items.add(new JMenuItem(new InteractiveGuidedRouteAction(view2D, this.devPath, this.port)));
                items.add(new JMenuItem(new RemoveWireAction(this.devPath, this.port)));
                items.add(null);
            }
            items.add(new JMenuItem(new ShowMeAction(this.port, this.devPath)));
            OrbitGuiWS gws = OrbitIO.getApp().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            for (JMenuItem mi : oar.getJMenuItems(this.port)) {
                if (mi.getAction() instanceof InteractiveGuidedRouteAction) continue;
                items.add(mi);
            }
        }
    }

    protected static class WbAndFCStrategyTree
    extends JTree
    implements Autoscroll {
        boolean refreshPending = false;
        protected ATreeModel mDbTreeModel;
        protected PopupMenuHandler mPopupMenuHandler = null;
        protected MouseListener mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }
        };
        protected Insets m_autoscrollInsets = new Insets(20, 20, 20, 20);

        public WbAndFCStrategyTree(ATreeModel tm) {
            super((TreeModel)tm);
            this.mDbTreeModel = tm;
            this.addMouseListener(this.mMouseListener);
        }

        public void setPopupMenuHandler(PopupMenuHandler h) {
            this.mPopupMenuHandler = h;
        }

        public ArrayList<AStrategyNode> getSelectedStrategy() {
            ArrayList<AStrategyNode> res = new ArrayList<AStrategyNode>();
            TreePath[] selPaths = this.getSelectionPaths();
            if (selPaths == null) {
                return res;
            }
            for (TreePath path : selPaths) {
                Object o = path.getLastPathComponent();
                if (!(o instanceof AStrategyNode)) continue;
                res.add((AStrategyNode)((Object)o));
            }
            return res;
        }

        public ArrayList<AStrategyGroupNode> getSelectedStrategyGroups() {
            ArrayList<AStrategyGroupNode> res = new ArrayList<AStrategyGroupNode>();
            TreePath[] selPaths = this.getSelectionPaths();
            if (selPaths == null) {
                return res;
            }
            for (TreePath path : selPaths) {
                Object o = path.getLastPathComponent();
                if (!(o instanceof AStrategyGroupNode)) continue;
                res.add((AStrategyGroupNode)((Object)o));
            }
            return res;
        }

        public ArrayList<Substrate> getSelectedSubstrates() {
            ArrayList<Substrate> res = new ArrayList<Substrate>();
            TreePath[] selPaths = this.getSelectionPaths();
            if (selPaths == null) {
                return res;
            }
            for (TreePath path : selPaths) {
                Object o = path.getLastPathComponent();
                if (o instanceof SubstrateNode) {
                    res.add(((SubstrateNode)((Object)o)).getSubstrate());
                }
                if (o instanceof AStrategyGroupNode) {
                    res.add(((SubstrateNode)((Object)path.getParentPath().getLastPathComponent())).getSubstrate());
                }
                if (!(o instanceof AStrategyNode)) continue;
                res.add(((SubstrateNode)((Object)path.getParentPath().getParentPath().getLastPathComponent())).getSubstrate());
            }
            return res;
        }

        public ATreeNode getNodeAtPoint(Point pt) {
            TreePath path = this.getPathForLocation(pt.x, pt.y);
            if (path == null) {
                return null;
            }
            Object obj = path.getLastPathComponent();
            if (obj instanceof ATreeNode) {
                return (ATreeNode)obj;
            }
            return null;
        }

        public void repaint(Personality personality) {
            int rowCount = this.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                PersonalityUI.PersonalityNode pn;
                TreePath path = this.getPathForRow(i);
                Object o = path.getLastPathComponent();
                if (!(o instanceof PersonalityUI.PersonalityNode) || (pn = (PersonalityUI.PersonalityNode)((Object)o)).getPersonality() != personality) continue;
                Rectangle r = this.getPathBounds(path);
                this.repaint(r);
                return;
            }
        }

        protected void popupMenu(MouseEvent e) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            this.setSelectionRow(row);
            if (this.mPopupMenuHandler != null) {
                this.mPopupMenuHandler.handlePopup(e.getX(), e.getY());
            }
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.m_autoscrollInsets;
        }

        @Override
        public void autoscroll(Point cursorLocation) {
            Insets insets = this.getAutoscrollInsets();
            Rectangle outer = this.getVisibleRect();
            Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
            if (!inner.contains(cursorLocation)) {
                Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
                this.scrollRectToVisible(scrollRect);
            }
        }

        static interface PopupMenuHandler {
            public void handlePopup(int var1, int var2);
        }
    }

    protected class AStrategyNode
    extends ALazyTreeNode {
        protected Personality mPersonality;
        protected ArrayList<PortNode> mChildNodes;
        protected StrategyGroupType mType;
        protected String mName;

        public AStrategyNode(ATreeNode parent, Personality p, StrategyGroupType gt) {
            super(parent);
            this.mPersonality = p;
            this.mName = p.getName();
            this.mType = gt;
        }

        public String getName() {
            return this.mName;
        }

        public Personality getPersonality() {
            return this.mPersonality;
        }

        public int getIndex(PinInstance p) {
            if (this.mChildNodes == null) {
                return -1;
            }
            for (int i = 0; i < this.mChildNodes.size(); ++i) {
                if (!this.mChildNodes.get(i).getPort().equals(p)) continue;
                return i;
            }
            return -1;
        }

        public IterableIterator<PortNode> getChildNodes() {
            if (this.mChildNodes == null) {
                return AEmptyItr.create();
            }
            return new AIterableItr(this.mChildNodes.iterator());
        }

        public PortNode getNode(int idx) {
            if (this.mChildNodes == null) {
                return null;
            }
            return this.mChildNodes.get(idx);
        }

        public void add(PinInstance p) {
            if (this.mChildNodes == null) {
                return;
            }
            Device subDev = ((SubstrateNode)this.getParent().getParent()).getSubstrateDevice();
            DevicePath portPath = p.getDevice().getAllPaths().filter(path -> path.contains(subDev)).findFirst().orElse(null);
            Object[] children = new PortNode[]{new PortNode((ATreeNode)this, p, portPath)};
            int[] indices = new int[]{this.getChildCount()};
            this.mChildNodes.add(children[0]);
            this.mTreeModel.treeNodesInserted((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public void remove(int idx) {
            if (this.mChildNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mChildNodes.get(idx)};
            this.mChildNodes.remove(idx);
            this.mTreeModel.treeNodesRemoved((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public void update(int idx) {
            if (this.mChildNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mChildNodes.get(idx)};
            this.mTreeModel.treeNodesChanged((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public SubstrateNode getSubstrateNode() {
            ATreeNode node;
            for (node = this.getParent(); node != null && !(node instanceof SubstrateNode); node = node.getParent()) {
            }
            return (SubstrateNode)node;
        }

        public ArrayList<PortNode> populateChildren() {
            Boolean routePins = true;
            if (this.mType == StrategyGroupType.DIEESCAPE) {
                routePins = true;
            } else if (this.mType == StrategyGroupType.RDL) {
                routePins = true;
            } else if (this.mType == StrategyGroupType.Wirebond) {
                routePins = false;
            }
            this.mChildNodes = new ArrayList();
            if (routePins != null) {
                Device substrateDevice = this.getSubstrateNode().getSubstrateDevice();
                for (PinInstance dbo : routePins != false ? PinInstance.getRoutePins((Personality)this.mPersonality) : PinInstance.getBondRingPins((Personality)this.mPersonality)) {
                    Device d = dbo.getDevice();
                    DevicePath portPath = d.getAllPaths().filter(path -> path.contains(substrateDevice)).findFirst().orElse(null);
                    this.mChildNodes.add(new PortNode((ATreeNode)this, dbo, portPath));
                }
                Collections.sort(this.mChildNodes, new PortSorter());
            }
            return this.mChildNodes;
        }

        public String getText() {
            return this.mPersonality.getName();
        }

        protected class PortSorter
        implements Comparator<PortNode> {
            @Override
            public int compare(PortNode o1, PortNode o2) {
                HierPin dpp1 = new HierPin(o1.devPath, o1.port);
                HierPin dpp2 = new HierPin(o2.devPath, o2.port);
                AAlphaNumComp c = AAlphaNumComp.get();
                boolean dpp1Routed = WbFcFeasibilityUI.isRouted(dpp1, o1.devPath.pathToSubstrate().getDeviceTemplate(), null);
                boolean dpp2Routed = WbFcFeasibilityUI.isRouted(dpp2, o2.devPath.pathToSubstrate().getDeviceTemplate(), null);
                if (!dpp1Routed && dpp2Routed) {
                    return -1;
                }
                if (!dpp2Routed && dpp1Routed) {
                    return 1;
                }
                return c.compare((Object)dpp1.getTopMostNet().getName(), (Object)dpp2.getTopMostNet().getName());
            }
        }
    }

    protected class AStrategyGroupNode
    extends ALazyTreeNode {
        protected String mName;
        protected ArrayList<AStrategyNode> mStrategyNodes;
        protected DeviceTemplate deviceTemplate;
        protected StrategyGroupType mType;

        public AStrategyGroupNode(ATreeNode parent, DeviceTemplate dt, String name, StrategyGroupType t) {
            super(parent);
            this.mName = name;
            this.deviceTemplate = dt;
            this.mType = t;
        }

        public StrategyGroupType getType() {
            return this.mType;
        }

        public String getName() {
            return this.mName;
        }

        public int getIndex(Personality p) {
            if (this.mStrategyNodes == null) {
                return -1;
            }
            for (int i = 0; i < this.mStrategyNodes.size(); ++i) {
                if (this.mStrategyNodes.get(i).getPersonality() != p) continue;
                return i;
            }
            return -1;
        }

        public AStrategyNode getNode(int idx) {
            if (this.mStrategyNodes == null) {
                return null;
            }
            return this.mStrategyNodes.get(idx);
        }

        public void add(Personality p) {
            if (this.mStrategyNodes == null) {
                return;
            }
            if (p.getType() == Personality.Type.BONDRING) {
                AStrategyNode[] children = new AStrategyNode[]{new AStrategyNode((ATreeNode)this, p, StrategyGroupType.Wirebond)};
                int[] indices = new int[]{this.getChildCount()};
                this.mStrategyNodes.add(children[0]);
                this.mTreeModel.treeNodesInserted((Object)this, this.getTreePath().getPath(), indices, (Object[])children);
            } else if (p.getType() == Personality.Type.DIEESCAPE) {
                AStrategyNode[] children = new AStrategyNode[]{new AStrategyNode((ATreeNode)this, p, StrategyGroupType.DIEESCAPE)};
                int[] indices = new int[]{this.getChildCount()};
                this.mStrategyNodes.add(children[0]);
                this.mTreeModel.treeNodesInserted((Object)this, this.getTreePath().getPath(), indices, (Object[])children);
            } else if (p.getType() == Personality.Type.RDL) {
                AStrategyNode[] children = new AStrategyNode[]{new AStrategyNode((ATreeNode)this, p, StrategyGroupType.RDL)};
                int[] indices = new int[]{this.getChildCount()};
                this.mStrategyNodes.add(children[0]);
                this.mTreeModel.treeNodesInserted((Object)this, this.getTreePath().getPath(), indices, (Object[])children);
            }
        }

        public void remove(int idx) {
            if (this.mStrategyNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mStrategyNodes.get(idx)};
            this.mStrategyNodes.remove(idx);
            this.mTreeModel.treeNodesRemoved((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public void update(int idx) {
            if (this.mStrategyNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mStrategyNodes.get(idx)};
            this.mTreeModel.treeNodesChanged((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public ArrayList<AStrategyNode> populateChildren() {
            block4: {
                Substrate s;
                block5: {
                    block3: {
                        this.mStrategyNodes = new ArrayList();
                        s = this.deviceTemplate.getSubstrate();
                        if (this.mType != StrategyGroupType.Wirebond) break block3;
                        for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
                            Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING).forEach(p -> this.mStrategyNodes.add(new AStrategyNode((ATreeNode)this, (Personality)p, StrategyGroupType.Wirebond)));
                        }
                        break block4;
                    }
                    if (this.mType != StrategyGroupType.DIEESCAPE) break block5;
                    for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
                        Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.DIEESCAPE).forEach(p -> this.mStrategyNodes.add(new AStrategyNode((ATreeNode)this, (Personality)p, StrategyGroupType.DIEESCAPE)));
                    }
                    break block4;
                }
                if (this.mType != StrategyGroupType.RDL) break block4;
                for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
                    Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.RDL).forEach(p -> this.mStrategyNodes.add(new AStrategyNode((ATreeNode)this, (Personality)p, StrategyGroupType.RDL)));
                }
            }
            return this.mStrategyNodes;
        }

        public String getText() {
            return this.mName;
        }
    }

    protected class SubstrateNode
    extends ALazyTreeNode {
        protected AStrategyGroupNode mBondStrategyGroup;
        protected AStrategyGroupNode mDieEscapeGroup;
        protected AStrategyGroupNode mRDLStrategyGroup;
        protected ArrayList<ATreeNode> nodes;
        protected DeviceTemplate deviceTemplate;
        protected Device substrateDevice;

        public SubstrateNode(ATreeNode m, DeviceTemplate dt) {
            super(m);
            this.deviceTemplate = dt;
            this.mSortChildren = false;
            DevicePath dp = OrbitIO.getCurDesign().getDescendantDevices().stream().filter(path -> path.getLast().getIsSubstrate() && path.getSubstrate() == this.deviceTemplate.getSubstrate()).findFirst().orElse(null);
            if (dp != null) {
                this.substrateDevice = dp.getLast();
            }
        }

        public Substrate getSubstrate() {
            return this.deviceTemplate.getSubstrate();
        }

        public DeviceTemplate getDeviceTemplate() {
            return this.deviceTemplate;
        }

        public Device getSubstrateDevice() {
            return this.substrateDevice;
        }

        public ArrayList<ATreeNode> populateChildren() {
            this.nodes = new ArrayList();
            if (this.deviceTemplate.getType() != DeviceTemplate.Type.DIE) {
                if (sShowWireBonding) {
                    this.mBondStrategyGroup = new AStrategyGroupNode((ATreeNode)this, this.deviceTemplate, WbFcFeasibilityUI.WIRE_BOND_GROUP_NAME, StrategyGroupType.Wirebond);
                    this.nodes.add((ATreeNode)this.mBondStrategyGroup);
                }
                this.mDieEscapeGroup = new AStrategyGroupNode((ATreeNode)this, this.deviceTemplate, WbFcFeasibilityUI.DIE_ESCAPE_GROUP_NAME, StrategyGroupType.DIEESCAPE);
                this.nodes.add((ATreeNode)this.mDieEscapeGroup);
            } else {
                this.mRDLStrategyGroup = new AStrategyGroupNode((ATreeNode)this, this.deviceTemplate, WbFcFeasibilityUI.RDL_GROUP_NAME, StrategyGroupType.RDL);
                this.nodes.add((ATreeNode)this.mRDLStrategyGroup);
            }
            return this.nodes;
        }

        public String getText() {
            if (this.deviceTemplate == null) {
                return "?";
            }
            Object name = "";
            for (Device d : WbFcFeasibilityUI.this.mDb.getObjects(Device.class)) {
                if (!d.getIsSubstrate() || d.getTemplate() != this.deviceTemplate) continue;
                name = (String)name + d.getName() + " ";
            }
            return name;
        }

        public AStrategyGroupNode getChildOfType(Personality.Type t) {
            for (ATreeNode c : this.nodes) {
                AStrategyGroupNode n = (AStrategyGroupNode)c;
                if (!n.mType.equals((Object)StrategyGroupType.Wirebond)) continue;
                return n;
            }
            return null;
        }

        public AStrategyNode findNodeFor(Personality p) {
            AStrategyGroupNode ptn = this.mBondStrategyGroup;
            if (ptn == null) {
                return null;
            }
            int idxPersonality = ptn.getIndex(p);
            if (idxPersonality == -1) {
                return null;
            }
            return ptn.getNode(idxPersonality);
        }
    }

    protected class RootNode
    extends ALazyTreeNode {
        protected ArrayList<SubstrateNode> mSubstrateNodes;

        public RootNode(ATreeModel m, Db db) {
            super(m);
        }

        public ArrayList<SubstrateNode> populateChildren() {
            this.mSubstrateNodes = new ArrayList();
            for (DeviceTemplate dt : WbFcFeasibilityUI.this.mDb.getObjects(DeviceTemplate.class)) {
                DeviceTemplate.Type type;
                if (!dt.amIASubstrate() || (type = dt.getType()) != DeviceTemplate.Type.BOARD && type != DeviceTemplate.Type.DIE && type != DeviceTemplate.Type.PACKAGE) continue;
                this.mSubstrateNodes.add(new SubstrateNode((ATreeNode)this, dt));
            }
            Collections.sort(this.mSubstrateNodes, new SubstrateSorter());
            return this.mSubstrateNodes;
        }

        public String getText() {
            return "Substrates";
        }

        public int getIndex(Substrate s) {
            if (this.mSubstrateNodes == null) {
                return -1;
            }
            for (int i = 0; i < this.mSubstrateNodes.size(); ++i) {
                if (this.mSubstrateNodes.get(i).getSubstrate() != s) continue;
                return i;
            }
            return -1;
        }

        public int getIndex(DeviceTemplate t) {
            if (this.mSubstrateNodes == null) {
                return -1;
            }
            for (int i = 0; i < this.mSubstrateNodes.size(); ++i) {
                if (this.mSubstrateNodes.get(i).getDeviceTemplate() != t) continue;
                return i;
            }
            return -1;
        }

        public void add(DeviceTemplate dt) {
            if (this.mSubstrateNodes == null) {
                return;
            }
            SubstrateNode[] children = new SubstrateNode[]{new SubstrateNode((ATreeNode)this, dt)};
            int[] indices = new int[]{this.getChildCount()};
            this.mSubstrateNodes.add(children[0]);
            this.mTreeModel.treeNodesInserted((Object)this, this.getTreePath().getPath(), indices, (Object[])children);
        }

        public void remove(int idx) {
            if (this.mSubstrateNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mSubstrateNodes.get(idx)};
            this.mSubstrateNodes.remove(idx);
            this.mTreeModel.treeNodesRemoved((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public void update(int idx) {
            if (this.mSubstrateNodes == null) {
                return;
            }
            int[] indices = new int[]{idx};
            Object[] children = new Object[]{this.mSubstrateNodes.get(idx)};
            this.mTreeModel.treeNodesChanged((Object)this, this.getTreePath().getPath(), indices, children);
        }

        public AStrategyNode findNode(Personality p) {
            if (p.getOwner() == null) {
                return null;
            }
            if (p.getOwner().getSubstrate() != null) {
                int idxSubstrate = this.getIndex(p.getOwner().getSubstrate());
                if (idxSubstrate == -1) {
                    return null;
                }
                SubstrateNode sn = this.mSubstrateNodes.get(idxSubstrate);
                return sn.findNodeFor(p);
            }
            for (SubstrateNode sn : this.mSubstrateNodes) {
                AStrategyNode pn = sn.findNodeFor(p);
                if (pn == null) continue;
                return pn;
            }
            return null;
        }

        public void notifyChange(DbClass.DbObjectEvent event) {
            Substrate substrate;
            DbObject dbo = event.getDbObject();
            assert (dbo instanceof Personality);
            Personality personality = (Personality)dbo;
            Personality.Type pt = personality.getType();
            DeviceTemplate owner = personality.getOwner();
            Substrate substrate2 = substrate = owner == null ? null : owner.getSubstrate();
            if (substrate == null) {
                if (WbFcFeasibilityUI.this.mDb.getHistory().isInUndoRedo()) {
                    WbFcFeasibilityUI.this.refreshTree();
                }
                return;
            }
            if (event instanceof DbClass.ObjectAdd) {
                int idxSubstrate = this.getIndex(owner);
                if (idxSubstrate == -1) {
                    return;
                }
                SubstrateNode sn = this.mSubstrateNodes.get(idxSubstrate);
                AStrategyGroupNode ptn = null;
                if (pt == Personality.Type.BONDRING) {
                    ptn = sn.getChildOfType(Personality.Type.BONDRING);
                }
                if (ptn == null) {
                    return;
                }
                ptn.add(personality);
                return;
            }
            AStrategyNode pn = this.findNode(personality);
            if (pn == null) {
                return;
            }
            AStrategyGroupNode ptn = (AStrategyGroupNode)pn.getParent();
            int idxPersonalityNode = ptn.getIndex(personality);
            if (idxPersonalityNode == -1) {
                return;
            }
            if (event instanceof DbClass.ObjectRemove) {
                ptn.remove(idxPersonalityNode);
            } else if (event instanceof DbClass.ObjectChange) {
                ptn.update(idxPersonalityNode);
            }
        }

        protected class SubstrateSorter
        implements Comparator<SubstrateNode> {
            protected SubstrateSorter() {
            }

            @Override
            public int compare(SubstrateNode c0, SubstrateNode c1) {
                return c0.getSubstrate().getName().compareTo(c1.getSubstrate().getName());
            }
        }
    }

    static interface ContextMenuSupport {
        public void populateMenuItems(List<JMenuItem> var1);
    }

    protected class RouteGroupPopup
    extends JPopupMenu {
        protected Action mItemEdit;
        protected Action mItemDelete;
        protected Action mItemRouteVision;
        protected Action mItemUnRouteVision;
        protected Action mItemAddSelectedPorts;
        protected Action mItemSelectPorts;
        protected Action mItemPartialDef;
        protected Action mItemPartialCustom;
        protected Personality.Type mType;

        public RouteGroupPopup(Personality.Type type) {
            this.mType = type;
            this.add("Edit Route Group Assignments", WbFcFeasibilityUI.this.mRouteQueue, null, ICON_TABLE);
            this.addSeparator();
            this.mItemDelete = this.add("Delete Route Group", WbFcFeasibilityUI.this.mDeleteStrategy);
            this.addSeparator();
            this.mItemEdit = this.add("Edit Rule Sets...", WbFcFeasibilityUI.this.mEditRDLRuleSet);
            this.add("Create a Rule Set...", WbFcFeasibilityUI.this.mCreateRDLRuleSet);
            this.addSeparator();
            this.mItemRouteVision = this.add("Route Vision", WbFcFeasibilityUI.this.mRouteVision);
            this.mItemUnRouteVision = this.add("Restore Default Display", WbFcFeasibilityUI.this.mUnRouteVision);
            this.addSeparator();
            if (type.equals((Object)Personality.Type.RDL)) {
                this.mItemPartialDef = this.add("Write Partial .def of Wires", WbFcFeasibilityUI.this.mPartialDef);
                this.mItemPartialCustom = this.add("Write Partial Custom Wires", WbFcFeasibilityUI.this.mPartialCustom);
            }
        }

        protected void add(String text, ActionListener listener, String toolTip, Icon icon) {
            JMenuItem jmi = this.add(new JMenuItem(text));
            jmi.addActionListener(listener);
            if (toolTip != null) {
                jmi.setToolTipText(toolTip);
            }
            if (icon != null) {
                jmi.setIcon(icon);
            }
        }

        protected Action add(String text, final ActionListener listener) {
            AbstractAction a = new AbstractAction(text){
                protected ActionListener mListener;
                {
                    super(arg0);
                    this.mListener = listener;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.mListener.actionPerformed(e);
                }
            };
            this.add(a);
            return a;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepare(x, y);
            super.show(invoker, x, y);
        }

        protected void prepare(int x, int y) {
            ArrayList<AStrategyNode> selRouteGroups = WbFcFeasibilityUI.this.mWireBondAndRouteStrategyTree.getSelectedStrategy();
            boolean license = true;
            this.mItemEdit.setEnabled(selRouteGroups.size() == 1 && license);
            this.mItemDelete.setEnabled(selRouteGroups.size() == 1 && license);
            if (this.mType == Personality.Type.RDL) {
                this.mItemPartialDef.setEnabled(selRouteGroups.size() == 1 && license);
                this.mItemPartialCustom.setEnabled(selRouteGroups.size() == 1 && license);
            }
            this.mItemRouteVision.setEnabled(selRouteGroups.size() == 1 && license);
            this.mItemUnRouteVision.setEnabled(selRouteGroups.size() == 1 && license);
            if (selRouteGroups.size() == 1) {
                mSelectedPersonality = selRouteGroups.get((int)0).mPersonality;
            }
        }
    }

    public static class DeviceFilter
    implements DEFOut.JustTheseDevicesFilter {
        protected Set<DevicePath> devSet = Collections.emptySet();

        public void setDevices(List<DevicePath> deviceList) {
            this.devSet = new HashSet<DevicePath>(deviceList);
        }

        @Override
        public boolean include(DevicePath dp) {
            return this.devSet.contains(dp);
        }

        @Override
        public boolean intersects(ARect r) {
            for (DevicePath dp : this.devSet) {
                ARect dRect;
                if (dp.isEmpty() || !(dRect = dp.getBB()).intersects(r)) continue;
                return true;
            }
            return false;
        }
    }

    public static class WireFilter
    implements DEFOut.JustTheseWiresFilter {
        protected Set<Wire> wireSet = Collections.emptySet();

        public void setWires(List<Wire> wireList) {
            this.wireSet = new HashSet<Wire>(wireList);
        }

        @Override
        public boolean include(Wire w) {
            return this.wireSet.contains(w);
        }
    }

    public class ExportPartialDefDlg {
        String path;

        public boolean showMe(boolean custom) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = AFileFilter.DEF;
            if (custom) {
                filter = AFileFilter.CSV;
            }
            fc.setFileFilter((FileFilter)filter);
            ExportPartialDefOptions options = new ExportPartialDefOptions();
            fc.setAccessory((JComponent)options);
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return false;
            }
            File f = fc.getSelectedFile();
            this.path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                this.path = custom ? this.path + ".csv" : this.path + ".def";
            }
            return true;
        }

        public String getPath() {
            return this.path;
        }

        private class ExportPartialDefOptions
        extends JPanel {
            @Override
            public void addNotify() {
                super.addNotify();
            }
        }
    }

    protected static enum StrategyGroupType {
        Wirebond,
        RDL,
        DIEESCAPE;

    }
}

