/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.OrbitIO;
import java.awt.Window;
import java.io.File;
import java.io.FileWriter;
import java.util.Optional;
import javax.swing.filechooser.FileFilter;

public class WbImportDefFileChooser
extends AFileChooser {
    static final AFileFilter CVS_FILE_FILTER = AFileFilter.CSV;
    static final String NO_LAYER = "<No Layer>";
    static final int FINGER_HEADER_SIZE = 15;
    static final int METAL_HEADER_SIZE = 9;
    protected BondRingType mBondRingType;
    protected Substrate mSubstrate;
    protected String mFileName;
    protected File mFile;
    protected FileWriter mFileWriter;
    protected CSVDocument mCSVDocument;
    static final Constraint.DescriptorList mFingerHeader = Constraint.DescriptorList.of((Constraint.Descriptor[])new Constraint.Descriptor[]{Constraint.RING_GEOM, Constraint.BOND_SIDE, Constraint.BONDFINGER_WIDTH, Constraint.BONDFINGER_LENGTH, Constraint.BONDFINGER_TIER_DIST, Constraint.BONDFINGER_ANGLE, Constraint.BONDMAX_LENGTH, Constraint.BONDMIN_LENGTH, Constraint.BONDFINGER_SEPARATION, Constraint.BONDWIRE_TO_BONDWIRE_CLR, Constraint.BONDMIN_ANGLE, Constraint.BONDWIRE_WIDTH, Constraint.WIREBOND_LAYER, Constraint.BONDFINGER_LAYER});
    static final Constraint.DescriptorList mMetalHeader = Constraint.DescriptorList.of((Constraint.Descriptor[])new Constraint.Descriptor[]{Constraint.METALRING_WIDTH, Constraint.METALRING_DIST, Constraint.BONDFINGER_SEPARATION, Constraint.BONDWIRE_TO_BONDWIRE_CLR, Constraint.BONDMIN_ANGLE, Constraint.BONDWIRE_WIDTH, Constraint.WIREBOND_LAYER, Constraint.BONDFINGER_LAYER});

    public static void createFileChooser(Window owner, String title, Substrate substrate) {
        WbImportDefFileChooser fc = new WbImportDefFileChooser();
        fc.setFileFilter((FileFilter)CVS_FILE_FILTER);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(true);
        fc.setDialogTitle(title);
        fc.initi(owner, substrate);
    }

    private void initi(Window owner, Substrate substrate) {
        this.mSubstrate = substrate;
        if (this.showOpenDialog(owner) != 0) {
            return;
        }
        for (File f : this.getSelectedFiles()) {
            if (f == null) {
                return;
            }
            this.mFileName = f.getPath();
            this.importFile();
        }
    }

    protected void importFile() {
        this.mCSVDocument = this.readCSVFile();
        if (this.mCSVDocument.getAttributeNames().length == 15) {
            ALog.logInfo((String)"Import Ring (Finger) Definition");
            this.mBondRingType = BondRingType.FINGER;
        } else if (this.mCSVDocument.getAttributeNames().length == 9) {
            ALog.logInfo((String)"Import Ring (Metal) Definition");
            this.mBondRingType = BondRingType.METAL;
        } else {
            ALog.logError((String)"Wrong input csv format");
            return;
        }
        for (int i = 0; i != this.mCSVDocument.getItemCount(); ++i) {
            this.loadCSVFile(i);
        }
    }

    private void loadCSVFile(int itemIndex) {
        Db db = OrbitIO.getCurDb();
        for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
            if (devTemp.getType() != DeviceTemplate.Type.PACKAGE) continue;
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.WbFcFeasibilityUI.addWireBondRingDefinition(\"%s\",\"%s\")", (Object[])new Object[]{this.mCSVDocument.getItemValue(itemIndex, "name"), devTemp.getKeyStr()});
        }
        for (DeviceTemplate devTemp : this.mSubstrate.getDeviceTemplates()) {
            Optional pOpt;
            if (devTemp.getType() != DeviceTemplate.Type.PACKAGE || !(pOpt = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.BONDRING, (String)this.mCSVDocument.getItemValue(itemIndex, "name"))).isPresent()) continue;
            Personality personality = (Personality)pOpt.get();
            this.setConstraintValue(itemIndex, db, personality);
        }
    }

    protected void setConstraintValue(int itemIndex, Db db, Personality personality) {
        String strRingType = this.mBondRingType != BondRingType.FINGER ? "METAL" : "FINGER";
        Constraint.DescriptorList mHeader = this.mBondRingType != BondRingType.FINGER ? mMetalHeader : mFingerHeader;
        Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\",\"%s\",\"BondRingType\",\"%s\")", (Object[])new Object[]{personality.getDbClass().getName(), personality.getKeyStr(), strRingType});
        for (Constraint.Descriptor desc : mHeader) {
            Double dVal;
            Class classType = desc.getType();
            String attriName = desc.getDesc().toLowerCase().replace(" ", "");
            String sVal = this.mCSVDocument.getItemValue(itemIndex, attriName);
            if (sVal == null) {
                ALog.logError((String)"Wrong csv input format.");
                return;
            }
            if (classType == Double.class) {
                dVal = Double.valueOf(sVal);
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", (Double) %f)", (Object[])new Object[]{personality.getDbClass().getName(), personality.getKeyStr(), desc.getName(), dVal});
                continue;
            }
            if (classType == Long.class) {
                dVal = Double.valueOf(sVal);
                Long lVal = OrbitIO.getCurView().getUnit().fromUser(dVal.doubleValue());
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", (Long) %dL)", (Object[])new Object[]{personality.getDbClass().getName(), personality.getKeyStr(), desc.getName(), lVal});
                continue;
            }
            if (classType.isEnum()) {
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{personality.getDbClass().getName(), personality.getKeyStr(), desc.getName(), sVal.toUpperCase()});
                continue;
            }
            if (classType == Layer.class) {
                String layerVal = sVal.equals(NO_LAYER) ? "null" : String.format("\"%s\"", Layer.get((Db)db, (Substrate)this.mSubstrate, (String)sVal).getKeyStr());
                Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(\"%s\", \"%s\", \"%s\", %s)", (Object[])new Object[]{personality.getDbClass().getName(), personality.getKeyStr(), desc.getName(), layerVal});
                continue;
            }
            assert (false);
        }
    }

    private CSVDocument readCSVFile() {
        CSVDocument ruleDoc;
        String[] h = null;
        try {
            ruleDoc = CSVDocument.newInstance(h);
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            parser2.setDataSepExpression(",");
            ruleDoc.setPath(this.mFileName);
            ruleDoc = parser2.parse(this.mFileName);
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logError((String)("Problems reading " + this.mFileName));
            return null;
        }
        ALog.logInfo((String)"Read Wire bond constraint definition from: %s", (Object[])new Object[]{this.mFileName});
        return ruleDoc;
    }

    public static enum BondRingType {
        FINGER,
        METAL;

    }
}

