/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.BondFingerUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.xml.AXmlUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class WireBondExport {
    protected static final String DOCTYPE = "<!DOCTYPE die SYSTEM \"cdnwb.dtd\">\n";
    protected static final String EXPORT_UNIT = "UM";
    protected static final String FINGER_SHAPE = "OBLONG_X";
    protected static final String FINGER_PATTERN = "Free Placement";
    protected static final String FINGER_SNAP = "Finger Origin";
    protected static final long FINGER_EQUAL_WIRE_LENGTH = 2750000L;
    protected static final String WIRE_STACK_LEVEL = "1";
    protected XMLStreamWriter mXmlWriter;
    protected Device mDieDev;
    protected DeviceTemplate mPackageDevT;
    protected LinkedList<PinTemplate> mDieBondFinger = new LinkedList();
    protected HashMap<String, SipFingerAlignment> mDiePad2SipFingerAlignment = new HashMap();

    public WireBondExport(DeviceTemplate packageDevT, Device dieDev) {
        this.mDieDev = dieDev;
        this.mPackageDevT = packageDevT;
    }

    public void exportWireBond(String fileName) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(fileName);){
            this.mXmlWriter = AXmlUtil.createXmlStreamWriter((OutputStream)fileOutputStream);
            ALog.logInfo((String)"Wirte wire bond configuration file to %s", (Object[])new Object[]{fileName});
            this.loadDieBondFinger();
            this.loadFingerAlignment();
            this.writeWireBondXml();
            ALog.logInfo((String)"Export wire bond configuration file complete.");
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"There was an unexpected exception while writing %s.", (Object[])new Object[]{fileName});
        }
    }

    protected void loadDieBondFinger() {
        this.mPackageDevT.getPins().stream().filter(pin -> pin.getType() == PinTemplate.Type.BONDFINGERPAD && NetMap.isMapped((Net)pin.getNet(), (Device)this.mDieDev)).forEach(pin -> this.mDieBondFinger.add((PinTemplate)pin));
    }

    protected void loadFingerAlignment() {
        Personality.getPersonalities((DeviceTemplate)this.mPackageDevT, (Personality.Type)Personality.Type.BONDRING).forEach(bondRingPersonality -> {
            Constraint.BondFingerAngle orbitFingerAngle = (Constraint.BondFingerAngle)Constraint.getValue((Db)OrbitIO.getCurDb(), (DbObject)bondRingPersonality, (Constraint.Descriptor)Constraint.BONDFINGER_ANGLE);
            SipFingerAlignment sipFingerAlignment = SipFingerAlignment.tranlateFromOrbit(orbitFingerAngle);
            PinInstance.getBondRingPins((Personality)bondRingPersonality).forEach(pin -> this.mDiePad2SipFingerAlignment.put(pin.getKeyStr(), sipFingerAlignment));
        });
    }

    protected void writeWireBondXml() throws XMLStreamException {
        this.mXmlWriter.writeStartDocument();
        this.mXmlWriter.writeDTD(DOCTYPE);
        this.writeDie();
        this.mXmlWriter.writeEndDocument();
        this.mXmlWriter.flush();
        this.mXmlWriter.close();
    }

    protected void writeDie() throws XMLStreamException {
        this.mXmlWriter.writeStartElement("die");
        this.writeXmlElement("die_name", this.mDieDev.getName());
        this.writeXmlElement("die_height", this.getUserUnitStr(this.mDieDev.getBB().height()));
        this.writeXmlElement("die_width", this.getUserUnitStr(this.mDieDev.getBB().width()));
        this.writeFingerDefs();
        this.writeFingers();
        this.writeWires();
        this.mXmlWriter.writeEndElement();
    }

    protected void writeWires() throws XMLStreamException {
        for (PinTemplate pin : this.mDieBondFinger) {
            this.writeWire(BondFingerUtil.getWireBond((PinTemplate)pin));
        }
    }

    protected void writeWire(Wire bondWire) throws XMLStreamException {
        this.mXmlWriter.writeStartElement("wire");
        this.writeXmlElement("profile", bondWire.getLayer().getName());
        this.writeXmlElement("diameter", this.getUserUnitStr(bondWire.getWidth()));
        this.writeWireStart(bondWire.getPath().getPoint(0));
        this.writeWireEnd(bondWire.getPath().getPoint(1));
        this.mXmlWriter.writeEndElement();
    }

    protected void writeWireEnd(APoint2D endPoint) throws XMLStreamException {
        this.mXmlWriter.writeStartElement("wire_end");
        this.writeXmlElement("loc_x", this.getUserUnitStr(endPoint.getX()));
        this.writeXmlElement("loc_y", this.getUserUnitStr(endPoint.getY()));
        this.mXmlWriter.writeEndElement();
    }

    protected void writeWireStart(APoint2D startPoint) throws XMLStreamException {
        this.mXmlWriter.writeStartElement("wire_start");
        this.writeXmlElement("loc_x", this.getUserUnitStr(startPoint.getX()));
        this.writeXmlElement("loc_y", this.getUserUnitStr(startPoint.getY()));
        this.mXmlWriter.writeEndElement();
    }

    protected void writeFingers() throws XMLStreamException {
        for (PinTemplate pin : this.mDieBondFinger) {
            this.writeFinger(pin);
        }
    }

    protected void writeFinger(PinTemplate finger) throws XMLStreamException {
        this.mXmlWriter.writeStartElement("finger");
        this.writeXmlElement("label", finger.getName());
        this.writeXmlElement("loc_x", this.getUserUnitStr(finger.getLoc().getX()));
        this.writeXmlElement("loc_y", this.getUserUnitStr(finger.getLoc().getY()));
        this.writeXmlElement("angle", this.getSipAngle(finger.getRotate()));
        this.writeXmlElement("pattern", FINGER_PATTERN);
        this.writeXmlElement("alignment", this.getFingerAlignment(finger));
        this.writeXmlElement("snap", FINGER_SNAP);
        this.writeXmlElement("equal_wire_length", this.getUserUnitStr(2750000L));
        this.writeXmlElement("pad_name", finger.getPadTemplate().getName());
        this.mXmlWriter.writeEndElement();
    }

    protected String getFingerAlignment(PinTemplate finger) {
        PinInstance diePad = BondFingerUtil.getConnectedDiePad((DevicePath)this.mPackageDevT.getPathToPresentUser(), (PinTemplate)finger);
        return this.mDiePad2SipFingerAlignment.get(diePad.getKeyStr()).getName();
    }

    protected void writeFingerDefs() throws XMLStreamException {
        HashSet<String> padTemplate = new HashSet<String>();
        for (PinTemplate pin : this.mDieBondFinger) {
            PadTemplate bondFingerPad = pin.getPadTemplate();
            if (padTemplate.contains(bondFingerPad.getName())) continue;
            padTemplate.add(bondFingerPad.getName());
            this.writeFingerDef(bondFingerPad);
        }
    }

    protected void writeFingerDef(PadTemplate bondFingerPad) throws XMLStreamException {
        this.mXmlWriter.writeStartElement("finger_def");
        this.writeXmlElement("pad_name", bondFingerPad.getName());
        this.writeXmlElement("shape", FINGER_SHAPE);
        this.writeXmlElement("height", this.getUserUnitStr(bondFingerPad.getBB(null).width()));
        this.writeXmlElement("width", this.getUserUnitStr(bondFingerPad.getBB(null).height()));
        this.mXmlWriter.writeEndElement();
    }

    protected void writeXmlElement(String element, String data) throws XMLStreamException {
        this.mXmlWriter.writeStartElement(element);
        this.mXmlWriter.writeCharacters(data);
        this.mXmlWriter.writeEndElement();
    }

    protected String getUserUnitStr(long orbitValue) {
        return String.format("%s %s", OrbitIO.getCurView().getUnit().toUserStr(orbitValue).replace(",", ""), EXPORT_UNIT);
    }

    protected String getSipAngle(float angle) {
        return String.valueOf(angle * -1.0f + 90.0f);
    }

    public static enum SipFingerAlignment {
        FOLLOWWIRE("Aligned with Wire"),
        ORTHOGONAL("Orthogonal to Die Side");

        private String alignment;

        private SipFingerAlignment(String alignment) {
            this.alignment = alignment;
        }

        public String getName() {
            return this.alignment;
        }

        public static SipFingerAlignment tranlateFromOrbit(Constraint.BondFingerAngle orbitBondFingerAngle) {
            if (orbitBondFingerAngle == Constraint.BondFingerAngle.FOLLOWWIRE) {
                return FOLLOWWIRE;
            }
            return ORTHOGONAL;
        }
    }
}

