/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.wb_route;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class WireBondExportDlg
extends DbDialog {
    public static final AFileFilter WBT = new AFileFilter("wbt", "Wire Bond configuration files");
    protected AFileChooserControl mFileChooser;
    protected JComboBox<Device> mDieComboBox = new JComboBox();
    protected Substrate mSubstrate;
    protected DeviceTemplate mPackage;
    protected ActionListener mOkHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object exportFile = WireBondExportDlg.this.mFileChooser.getPath();
            if (!((String)exportFile).contains(".wbt")) {
                exportFile = (String)exportFile + ".wbt";
            }
            String packageGetByKeyStr = "curDb().getByKeyStr(DeviceTemplate.class, \"" + WireBondExportDlg.this.mPackage.getKeyStr() + "\")";
            String dieGetByKeyStr = "curDb().getByKeyStr(Device.class, \"" + ((Device)WireBondExportDlg.this.mDieComboBox.getSelectedItem()).getKeyStr() + "\")";
            Cp.exec((String)"unset(\"_wirebondexport\");", (Object[])new Object[0]);
            Cp.exec((String)"_wirebondexport = new com.sigrity.orbit.ui.wb_route.WireBondExport(%s,%s);", (Object[])new Object[]{packageGetByKeyStr, dieGetByKeyStr});
            Cp.exec((String)"_wirebondexport.exportWireBond(%s)", (Object[])new Object[]{Cp.getFileAsArgument((String)exportFile)});
            Cp.exec((String)"unset(\"_wirebondexport\");", (Object[])new Object[0]);
            UIUtil.closeWindow((Window)((Object)WireBondExportDlg.this));
        }
    };
    protected ListCellRenderer<Object> mDieComboBoxRender = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(((Device)value).getName());
            return this;
        }
    };

    WireBondExportDlg(Window owner, Substrate substrate) {
        super(OrbitIO.getApp().getCurrentDb(), (Component)owner, "Wire Bond Export", Dialog.ModalityType.DOCUMENT_MODAL);
        this.mSubstrate = substrate;
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        l.add("File name:");
        this.mFileChooser = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mFileChooser.addChoosableFileFilter(WBT);
        this.mFileChooser.setUseSaveChooser(true);
        l.newline();
        l.add("Parent die:");
        this.initDieComboBox(substrate);
        l.add(this.mDieComboBox, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        btnOk.addActionListener(this.mOkHandler);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    protected void initDieComboBox(Substrate substrate) {
        this.mPackage = (DeviceTemplate)substrate.getDeviceTemplates().next();
        this.mPackage.getChildren().stream().filter(dev -> dev.getDeviceType() == DeviceTemplate.Type.DIE && !dev.getFlipped()).forEach(dev -> this.mDieComboBox.addItem((Device)dev));
        this.mDieComboBox.setRenderer(this.mDieComboBoxRender);
    }
}

