/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.updio;

import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AComboBox;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.tools.dbexplorer.DBEResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UPDImportOptionsPanel
extends JPanel {
    JCheckBox mCbRootDevName;
    JTextField mTxtRootDevName;
    JCheckBox mCbDevTmpltPrefix;
    JTextField mTxtDevTmpltPrefix;
    JCheckBox mCbSubstrate;
    AComboBox<AComboBox.AComboBoxItem> mCoSubstrate;
    boolean mIsUpd = false;
    protected ActionListener mEnableControls = e -> {
        if (this.mTxtRootDevName.isEnabled() && !this.mCbRootDevName.isSelected()) {
            this.mTxtRootDevName.setText(this.getDefaultRootDevname());
        }
        if (this.mCoSubstrate.isEnabled() && !this.mCbSubstrate.isSelected()) {
            this.mCoSubstrate.setSelectedIndex(0);
        }
        this.mTxtRootDevName.setEnabled(this.mCbRootDevName.isSelected());
        this.mTxtDevTmpltPrefix.setEnabled(this.mCbDevTmpltPrefix.isSelected());
        this.mCoSubstrate.setEnabled(this.mCbSubstrate.isSelected());
    };

    public UPDImportOptionsPanel(boolean isUpd, DeviceTemplate.Type t) {
        this.mIsUpd = isUpd;
        this.setBorder(BorderFactory.createTitledBorder((isUpd ? "UPD" : "Speed") + " Import options"));
        GridBagManager l = new GridBagManager((Container)this);
        this.mCbRootDevName = new JCheckBox("Root device name");
        l.add((Component)this.mCbRootDevName, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        l.newline();
        l.indent();
        this.mTxtRootDevName = new JTextField(this.getDefaultRootDevname(), 8);
        l.add((Component)this.mTxtRootDevName, (GridBagConstraints)GridBagManager.FILLX.insets(0, 0, 0, 4));
        this.mCbRootDevName.addActionListener(this.mEnableControls);
        this.mCbRootDevName.setSelected(true);
        l.newline();
        this.mCbDevTmpltPrefix = new JCheckBox("Device template prefix");
        l.add((Component)this.mCbDevTmpltPrefix, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        l.newline();
        l.indent();
        this.mTxtDevTmpltPrefix = new JTextField(8);
        l.add((Component)this.mTxtDevTmpltPrefix, (GridBagConstraints)GridBagManager.FILLX.insets(0, 0, 0, 4));
        this.mCbDevTmpltPrefix.addActionListener(this.mEnableControls);
        l.newline();
        AComboBox.AComboBoxItem p = new AComboBox.AComboBoxItem((Object)"Package", DBEResources.ICON_PACKAGE, (Object)DeviceTemplate.Type.PACKAGE);
        AComboBox.AComboBoxItem b = new AComboBox.AComboBoxItem((Object)"Board", DBEResources.ICON_BOARD, (Object)DeviceTemplate.Type.BOARD);
        AComboBox.AComboBoxItem d = new AComboBox.AComboBoxItem((Object)"Die", DBEResources.ICON_DIE, (Object)DeviceTemplate.Type.DIE);
        this.mCbSubstrate = new JCheckBox("Substrate type");
        l.add((Component)this.mCbSubstrate, (GridBagConstraints)GridBagManager.FILLX.insets(0, 0, 0, 4));
        l.newline();
        l.indent();
        this.mCoSubstrate = isUpd ? new AComboBox((Object[])new AComboBox.AComboBoxItem[]{p, b, d}) : new AComboBox((Object[])new AComboBox.AComboBoxItem[]{p, b});
        l.add(this.mCoSubstrate, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        this.mCbSubstrate.addActionListener(this.mEnableControls);
        int substrateIndex = -1;
        for (int i = 0; i < this.mCoSubstrate.getItemCount(); ++i) {
            DeviceTemplate.Type st = (DeviceTemplate.Type)((AComboBox.AComboBoxItem)this.mCoSubstrate.getItemAt(i)).getKey();
            if (st != t) continue;
            substrateIndex = i;
            break;
        }
        this.mCoSubstrate.setSelectedIndex(substrateIndex);
        l.addFillY();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mEnableControls.actionPerformed(null);
    }

    public String getRootDeviceName() {
        if (!this.mTxtRootDevName.isEnabled()) {
            return "";
        }
        return this.mTxtRootDevName.getText();
    }

    public String getDeviceTemplatePrefix() {
        if (!this.mTxtDevTmpltPrefix.isEnabled()) {
            return "";
        }
        return this.mTxtDevTmpltPrefix.getText();
    }

    public DeviceTemplate.Type getTemplateType() {
        return (DeviceTemplate.Type)((AComboBox.AComboBoxItem)this.mCoSubstrate.getSelectedItem()).getKey();
    }

    protected String getDefaultRootDevname() {
        return this.mIsUpd ? "UPDDesign" : "SPDDesign";
    }
}

