/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.updio;

import com.sigrity.acl.ALog;
import com.sigrity.orbit.updio.UpdReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UpdPropertyParser {
    protected ObjectFieldParsers mParsers = new ObjectFieldParsers();

    public void addParser(String objType, String fieldName, Parser parser2) {
        this.mParsers.addParser(objType, fieldName, parser2);
    }

    public Parser getParser(String objType, String fieldName) {
        return this.mParsers.getParser(objType, fieldName);
    }

    public HashMap<String, Object> parseFieldProps(UpdReader.ObjectInfo oi) throws UpdReader.InvalidDataException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator<UpdReader.Field> fieldDefs = oi.mFields == null ? null : oi.mFields.iterator();
        UpdReader.Property priorProp = null;
        for (int i = 0; i < oi.mProperties.size(); ++i) {
            UpdReader.Property p = oi.mProperties.get(i);
            if (p.mName != null) {
                fieldDefs = null;
            }
            if (fieldDefs != null && fieldDefs.hasNext()) {
                UpdReader.Field fd = fieldDefs.next();
                p.mName = fd.mName;
                assert (p.mType == null) : "How did this happen?";
                p.mType = fd.mType;
            }
            if (!(oi.mObjectType.equals("change") || p.mName != null && p.mName.length() != 0)) {
                assert (false) : "More properties than fields, prior property was: " + priorProp;
                break;
            }
            Parser parser2 = this.getParser(oi.mObjectType, p.mName);
            if (parser2 == null) {
                parser2 = this.getParser(null, p.mName);
            }
            Object parsedObject = null;
            if (parser2 == null) {
                parsedObject = p.mVal;
            } else {
                ObjectValueIterator ovi = new ObjectValueIterator(oi.mProperties, i);
                try {
                    parsedObject = parser2.parse(ovi);
                }
                catch (UpdReader.InvalidDataException ide) {
                    ALog.logError((Throwable)ide, (String)"Invalid data while reading object of type '%s', last property succesfully read was '%s'", (Object[])new Object[]{oi.mObjectType, priorProp.mName});
                    throw ide;
                }
                i = ovi.getNextPropIndex() - 1;
            }
            result.put(p.mName, parsedObject);
            priorProp = p;
        }
        return result;
    }

    public static class ObjectValueIterator
    implements Iterator<String> {
        ArrayList<UpdReader.Property> mProperties = null;
        int mPropIdx = -1;
        boolean mUsedVal = false;
        int mAdditionalIdx = -1;

        public ObjectValueIterator(ArrayList<UpdReader.Property> props, int startIndex) {
            this.mProperties = props;
            this.mPropIdx = startIndex;
            this.mUsedVal = false;
            if (this.curProp().mAdditional != null) {
                this.mAdditionalIdx = 0;
            }
        }

        public UpdReader.Property curProp() {
            return this.mProperties.get(this.mPropIdx);
        }

        public int getNextPropIndex() {
            return this.mPropIdx + (this.mUsedVal ? 1 : 0);
        }

        public String peek() {
            return this.getValue(false);
        }

        protected String getValue(boolean advance) {
            if (!this.mUsedVal) {
                if (advance) {
                    this.mUsedVal = true;
                }
                return this.curProp().mVal;
            }
            if (this.mAdditionalIdx >= 0 && this.mAdditionalIdx < this.curProp().mAdditional.size()) {
                int n;
                ArrayList<String> arrayList = this.curProp().mAdditional;
                if (advance) {
                    int n2 = this.mAdditionalIdx;
                    n = n2;
                    this.mAdditionalIdx = n2 + 1;
                } else {
                    n = this.mAdditionalIdx;
                }
                return arrayList.get(n);
            }
            if (this.mAdditionalIdx < 0 && this.getNextPropIndex() < this.mProperties.size()) {
                String val = this.mProperties.get((int)this.getNextPropIndex()).mVal;
                if (advance) {
                    ++this.mPropIdx;
                    this.mUsedVal = true;
                    this.mAdditionalIdx = this.curProp().mAdditional == null ? -1 : 0;
                }
                return val;
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            if (!this.mUsedVal) {
                return true;
            }
            if (this.mAdditionalIdx >= 0 && this.mAdditionalIdx < this.curProp().mAdditional.size()) {
                return true;
            }
            return this.mAdditionalIdx < 0 && this.getNextPropIndex() < this.mProperties.size();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.getValue(true);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ObjectFieldParsers
    extends HashMap<String, FieldParsers> {
        public void addParser(String objType, String fieldName, Parser parser2) {
            FieldParsers fps = (FieldParsers)this.get(objType);
            if (fps == null) {
                fps = new FieldParsers();
                this.put(objType, fps);
            }
            fps.put(fieldName, parser2);
        }

        public Parser getParser(String objType, String fieldName) {
            FieldParsers fps = (FieldParsers)this.get(objType);
            if (fps == null) {
                return null;
            }
            return (Parser)fps.get(fieldName);
        }
    }

    public static class FieldParsers
    extends HashMap<String, Parser> {
    }

    public static interface Parser {
        public Object parse(ObjectValueIterator var1) throws UpdReader.InvalidDataException;
    }
}

