/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.updio;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.orbit.updio.UpdIO;
import com.sigrity.orbit.updio.UpdToDbProcessor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Pattern;

public class UpdReader {
    protected File mFile = null;
    protected Processor mProcessor = null;
    protected int mSize = -1;
    protected InputStream mInStream = null;
    protected boolean mEncoreFormat = false;
    protected boolean mFragmentFile = false;
    protected Stack<Token> mPendingToken = new Stack();
    protected ArrayList<Token> mStringTable = new ArrayList();
    protected HashMap<String, ArrayList<Field>> mObjectDefs = new HashMap();
    protected static final Token INVALID_STRTBL_ITEM = new Token("[INVALID CODE]", UpdIO.OutputToken.ot_identifier);
    protected static final HashMap<String, KeyWord> KeyWords = new HashMap();

    public UpdReader(File f, Processor proc) {
        this.mFile = f;
        this.mProcessor = proc;
    }

    public boolean read() {
        this.mProcessor.initialize();
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(this.mFile));){
            this.mInStream = inStream;
            this.mSize = this.mInStream.available();
            this.validateFileHeader();
            if (!this.mFragmentFile) {
                this.readLeftParen();
            }
            this.readObject(null, null, null);
            if (!this.mFragmentFile) {
                this.readRightParen();
            }
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"File '%s' not found.", (Object[])new Object[]{this.mFile.getPath()});
            return false;
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error reading file '%s' (%s).", (Object[])new Object[]{this.mFile.getPath(), e.getLocalizedMessage()});
            return false;
        }
        catch (InvalidDataException e) {
            String msg = String.format("Error reading file '%s'.", this.mFile.getPath());
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                msg = String.format("%s %s.", msg, e.getMessage());
            }
            ALog.logError((Throwable)e, (String)msg, (Object[])new Object[0]);
            return false;
        }
        this.mProcessor.complete();
        return true;
    }

    protected void readObject(Object parent, String objectTypeName, ArrayList<Field> fieldDefs) throws InvalidDataException {
        String name = objectTypeName;
        if (name == null) {
            Token token = this.readToken();
            if (token.getType() == UpdIO.OutputToken.ot_identifier) {
                name = token.getStr();
            } else {
                this.unreadToken(token);
            }
        }
        ObjectInfo objInfo = new ObjectInfo(parent, name, fieldDefs);
        this.readProperties(objInfo);
        Object clientObject = this.processObject(objInfo);
        Token token = this.readToken();
        while (token.getType() == UpdIO.OutputToken.ot_left_par) {
            Token t2 = this.readToken();
            if (t2.getType() != UpdIO.OutputToken.ot_identifier) {
                throw new InvalidDataException("Error reading input object, expected identifier after opening parenthesis");
            }
            switch (t2.getIdentifierType()) {
                case kw_def: {
                    this.readObjectDef(clientObject);
                    break;
                }
                case kw_ref: {
                    this.readObjectRelation(clientObject);
                    break;
                }
                default: {
                    throw new InvalidDataException("Error reading input object, expected Ref or Def");
                }
            }
            token = this.readToken();
        }
    }

    protected Object processObject(ObjectInfo objectInfo) throws InvalidDataException {
        return this.mProcessor.processObject(objectInfo);
    }

    protected void processRelation(RelationInfo relInfo, Object parent) throws InvalidDataException {
        this.mProcessor.processRelation(relInfo);
    }

    protected void readObjectRelation(Object parent) throws InvalidDataException {
        RelationInfo relInfo = this.readRelationSpec(parent);
        Token token = this.readToken();
        relInfo.mRelObjType = token.getStr();
        Token t = this.readToken();
        while (t.getType() == UpdIO.OutputToken.ot_identifier || t.getType() == UpdIO.OutputToken.ot_real) {
            relInfo.mRelObjName = t.getStr();
            this.processRelation(relInfo, parent);
            t = this.readToken();
        }
        if (t.getType() != UpdIO.OutputToken.ot_right_par) {
            throw new InvalidDataException("Expected right parenthesis while reading relation");
        }
    }

    protected RelationInfo readRelationSpec(Object parent) throws InvalidDataException {
        RelationInfo r = new RelationInfo();
        r.mParent = parent;
        Token t = this.readToken();
        if (t.getType() != UpdIO.OutputToken.ot_left_par) {
            this.unreadToken(t);
            return r;
        }
        t = this.readToken();
        if (t.getIdentifierType() != KeyWord.kw_rel) {
            throw new InvalidDataException("Expected 'Rel' keyword");
        }
        t = this.readToken();
        if (t.getType() != UpdIO.OutputToken.ot_identifier) {
            throw new InvalidDataException("Expected identifier");
        }
        r.mRelName = t.getStr();
        t = this.readToken();
        if (t.getType() != UpdIO.OutputToken.ot_right_par) {
            throw new InvalidDataException("Expected right parenthesis");
        }
        return r;
    }

    protected ArrayList<Field> readObjectDef(Object parent) throws InvalidDataException {
        UpdIO.OutputToken type;
        ArrayList<Field> res;
        block7: {
            res = null;
            Token token = this.readToken();
            if (token.getType() == UpdIO.OutputToken.ot_left_par) {
                Token t2 = this.readToken();
                while (t2.getType() != UpdIO.OutputToken.ot_right_par) {
                    t2 = this.readToken();
                }
                token = this.readToken();
            }
            String objectTypeName = token.getStr();
            while (true) {
                Token t = this.readToken();
                type = t.getType();
                KeyWord kw = t.getIdentifierType();
                if (type != UpdIO.OutputToken.ot_left_par) break block7;
                Token typeToken = this.readToken();
                kw = typeToken.getIdentifierType();
                if (kw == KeyWord.kw_gfmt || kw == KeyWord.kw_lfmt) {
                    this.unreadToken(typeToken);
                    res = this.readObjectFormat(objectTypeName);
                    continue;
                }
                if (t.getType() == UpdIO.OutputToken.ot_right_par) {
                    ObjectInfo objInfo = new ObjectInfo(parent, objectTypeName);
                    this.processObject(objInfo);
                    continue;
                }
                if (res == null) {
                    this.unreadToken(typeToken);
                    this.readObject(parent, objectTypeName, null);
                    continue;
                }
                if (t.getType() == UpdIO.OutputToken.ot_left_par) break;
                this.unreadToken(t);
                this.readObject(parent, null, res);
            }
            throw new InvalidDataException("Expected identifier");
        }
        if (type != UpdIO.OutputToken.ot_right_par) {
            throw new InvalidDataException("Expected right parenthesis");
        }
        return res;
    }

    protected ArrayList<Field> readObjectFormat(String objTypeName) throws InvalidDataException {
        Token t;
        KeyWord type;
        boolean global = false;
        ArrayList<Field> res = null;
        KeyWord fmt = this.readToken().getIdentifierType();
        if (fmt != KeyWord.kw_lfmt) {
            if (fmt == KeyWord.kw_gfmt) {
                global = true;
            } else {
                throw new InvalidDataException("Expected format");
            }
        }
        ArrayList<Field> fields = null;
        if (global) {
            fields = this.mObjectDefs.get(objTypeName);
            if (fields == null) {
                fields = new ArrayList();
                this.mObjectDefs.put(objTypeName, fields);
            } else {
                fields.clear();
            }
        } else {
            fields = new ArrayList<Field>();
            res = fields;
        }
        while ((type = (t = this.readToken()).getIdentifierType()) == KeyWord.kw_name || type == KeyWord.tt_identifier || type == KeyWord.kw_int || type == KeyWord.kw_real || type == KeyWord.kw_str) {
            Field p = new Field();
            p.mType = type;
            if (type == KeyWord.kw_int || type == KeyWord.kw_real || type == KeyWord.kw_str) {
                t = this.readToken();
            }
            p.mName = t.getStr();
            fields.add(p);
        }
        if (t.getType() != UpdIO.OutputToken.ot_right_par) {
            throw new InvalidDataException("Expected right parenthesis.");
        }
        return res;
    }

    protected void readVals(Property property, int count) throws InvalidDataException {
        for (int cur = 0; count < 0 || cur < count; ++cur) {
            Token token = this.readToken();
            if (count < 0 && !token.mType.isInt() && !token.mType.isReal()) {
                this.unreadToken(token);
                break;
            }
            if (token.mType == UpdIO.OutputToken.ot_left_par || token.mType == UpdIO.OutputToken.ot_right_par) {
                throw new InvalidDataException("Found parenthesis while expecting values.");
            }
            property.addVal(token.getStr());
        }
    }

    protected void readProperties(ObjectInfo objInfo) throws InvalidDataException {
        Token token = this.readToken();
        UpdIO.OutputToken type = token.getType();
        KeyWord kw = token.getIdentifierType();
        if (kw == KeyWord.kw_def || kw == KeyWord.kw_ref) {
            this.unreadToken(token);
            return;
        }
        if (objInfo.mFields == null) {
            objInfo.mFields = this.mObjectDefs.get(objInfo.mObjectType);
        }
        while (type != UpdIO.OutputToken.ot_left_par && type != UpdIO.OutputToken.ot_right_par) {
            Property p = new Property();
            p.addVal(token.getStr());
            objInfo.mProperties.add(p);
            token = this.readToken();
            if (token == null) {
                throw new InvalidDataException("Unexpected end of tokens");
            }
            type = token.getType();
            kw = token.getIdentifierType();
        }
        while (token.getType() == UpdIO.OutputToken.ot_left_par) {
            Token tempToken = this.readToken();
            this.unreadToken(tempToken);
            KeyWord tkw = tempToken.getIdentifierType();
            if (tkw != KeyWord.tt_identifier && tkw != KeyWord.kw_int && tkw != KeyWord.kw_real && tkw != KeyWord.kw_str) break;
            Property p = this.readLongProperty();
            objInfo.mProperties.add(p);
            token = this.readToken();
            if (token.getType() != UpdIO.OutputToken.ot_right_par) {
                throw new InvalidDataException("Expected right parenthesis to close property, found '" + token.getStr() + "'");
            }
            token = this.readToken();
        }
        this.unreadToken(token);
    }

    protected Property readLongProperty() throws InvalidDataException {
        Token token;
        Property result = new Property();
        Token typeToken = this.readToken();
        result.mType = typeToken.getIdentifierType();
        switch (result.mType) {
            case kw_int: 
            case kw_real: 
            case kw_str: {
                break;
            }
            default: {
                this.unreadToken(typeToken);
                result.mType = KeyWord.tt_unknown;
            }
        }
        Token name = this.readToken();
        if (name.getType() != UpdIO.OutputToken.ot_identifier) {
            throw new InvalidDataException("Invalid data for property name");
        }
        result.mName = name.getStr();
        while (true) {
            if ((token = this.readToken()).getType() == UpdIO.OutputToken.ot_right_par) break;
            if (token.getType() == UpdIO.OutputToken.ot_left_par) {
                throw new InvalidDataException("Unexpected left parenthesis while reading property value.");
            }
            result.addVal(token.getStr());
        }
        this.unreadToken(token);
        return result;
    }

    protected void validateFileHeader() throws InvalidDataException {
        float progVersion;
        float fileVersion;
        long magic = this.readInt();
        if (magic == 0x55555555L) {
            this.mEncoreFormat = true;
        } else if (magic == 0x77777777L) {
            this.mEncoreFormat = false;
        } else {
            throw new InvalidDataException();
        }
        this.readLeftParen();
        String fileType = this.readIdentifier();
        String version = this.readIdentifier();
        if (!(fileType.equals("navigator_data") || fileType.equals("Navigator_Data") || fileType.equals("SIGRITY_UPD_Data") || fileType.equals("SIGRITY_UPD_data"))) {
            if (fileType.equals("navigator_fragment") || fileType.equals("SIGRITY_UPD_fragment")) {
                this.mFragmentFile = true;
            } else {
                throw new InvalidDataException("Invalid file type");
            }
        }
        if (version.charAt(0) == '/' || version.charAt(0) == '\\') {
            version = "2.0";
        }
        if ((fileVersion = Float.parseFloat(version)) > (progVersion = Float.parseFloat("7.2"))) {
            throw new InvalidDataException("Invalid file version, newer than program version");
        }
    }

    public long readInt() throws InvalidDataException {
        Token tok = this.readToken();
        UpdIO.OutputToken type = tok.getType();
        if (type.isInt()) {
            return Integer.parseInt(tok.getStr());
        }
        if (type.isReal() || type == UpdIO.OutputToken.ot_identifier) {
            return Math.round(Double.parseDouble(tok.getStr()));
        }
        throw new InvalidDataException();
    }

    public String readIdentifier() throws InvalidDataException {
        Token tok = this.readToken();
        if (tok.getType() == UpdIO.OutputToken.ot_identifier) {
            return tok.getStr();
        }
        String msg = String.format("Expected identifier, found '%s'", tok.getStr());
        throw new InvalidDataException(msg);
    }

    public void readLeftParen() throws InvalidDataException {
        Token tok = this.readToken();
        if (tok.getType() == UpdIO.OutputToken.ot_left_par) {
            return;
        }
        throw new InvalidDataException();
    }

    public void readRightParen() throws InvalidDataException {
        Token tok = this.readToken();
        if (tok.getType() == UpdIO.OutputToken.ot_right_par) {
            return;
        }
        throw new InvalidDataException();
    }

    protected void unreadToken(Token t) {
        this.mPendingToken.push(t);
    }

    protected Token readToken() {
        Token token = null;
        if (!this.mPendingToken.empty()) {
            return this.mPendingToken.pop();
        }
        try {
            int b = this.mInStream.read();
            if (b == -1) {
                ALog.logError((String)"Error reading from file '%s', unexpected end of file.", (Object[])new Object[]{this.mFile.getPath()});
                return null;
            }
            if (b >= UpdIO.OutputToken.ot_id_real_0.ordinal()) {
                int code = b - UpdIO.OutputToken.ot_id_real_0.ordinal();
                token = this.getString(code);
            } else {
                UpdIO.OutputToken type = UpdIO.OutputToken.values()[b];
                if (this.mEncoreFormat) {
                    type = UpdReader.ConvertOutputToken(UpdIO.OutputTokenEncore.values()[type.ordinal()]);
                }
                StringBuffer str = new StringBuffer();
                long intVal = 0L;
                switch (type) {
                    case ot_eof: {
                        break;
                    }
                    case ot_identifier: 
                    case ot_real: {
                        do {
                            b = this.mInStream.read();
                            str.append((char)(b & 0x7F));
                        } while ((b & 0x80) == 0);
                        token = new Token(str.toString(), type);
                        this.saveString(token);
                        break;
                    }
                    case ot_left_par: {
                        token = new Token("(", type);
                        break;
                    }
                    case ot_right_par: {
                        token = new Token(")", type);
                        break;
                    }
                    case ot_pos_int_1: 
                    case ot_pos_int_2: 
                    case ot_pos_int_3: 
                    case ot_pos_int_4: {
                        intVal = this.readBinaryInteger(type, UpdIO.OutputToken.ot_pos_int_1);
                        type = UpdIO.OutputToken.ot_pos_int_4;
                        token = new Token("" + intVal, type);
                        break;
                    }
                    case ot_neg_int_1: 
                    case ot_neg_int_2: 
                    case ot_neg_int_3: 
                    case ot_neg_int_4: {
                        intVal = -this.readBinaryInteger(type, UpdIO.OutputToken.ot_neg_int_1);
                        type = UpdIO.OutputToken.ot_pos_int_4;
                        token = new Token("" + intVal, type);
                        break;
                    }
                    case ot_id_real_1: 
                    case ot_id_real_2: 
                    case ot_id_real_3: 
                    case ot_id_real_4: {
                        int code = (int)this.readBinaryInteger(type, UpdIO.OutputToken.ot_id_real_1);
                        token = this.getString(code -= UpdIO.OutputToken.ot_id_real_0.ordinal() - 256);
                        break;
                    }
                    default: {
                        ALog.logError((Throwable)new IOException("Invalid file"), (String)"Invalid byte in input (%d) from file '%s'.\n", (Object[])new Object[]{b, this.mFile.getPath()});
                    }
                }
            }
        }
        catch (IOException ioe) {
            ALog.logError((Throwable)ioe, (String)"Error reading from file '%s'.", (Object[])new Object[]{this.mFile.getPath()});
        }
        if (token == null || token.getStr().contains("package") || token.getStr().contains("partition")) {
            // empty if block
        }
        return token;
    }

    protected Token getString(int code) {
        if (0 <= code && code < this.mStringTable.size()) {
            return this.mStringTable.get(code);
        }
        return INVALID_STRTBL_ITEM;
    }

    protected int saveString(Token entry) {
        this.mStringTable.add(entry);
        return this.mStringTable.size() - 1;
    }

    public static UpdIO.OutputTokenEncore OutputTokenEncore(UpdIO.OutputToken tok) {
        UpdIO.OutputTokenEncore ans = UpdIO.OutputTokenEncore.ote_eof;
        switch (tok) {
            case ot_right_par: {
                ans = UpdIO.OutputTokenEncore.ote_right_par;
                break;
            }
            case ot_left_par: {
                ans = UpdIO.OutputTokenEncore.ote_left_par;
                break;
            }
            case ot_real: {
                ans = UpdIO.OutputTokenEncore.ote_real;
                break;
            }
            case ot_identifier: {
                ans = UpdIO.OutputTokenEncore.ote_identifier;
                break;
            }
            default: {
                ans = UpdIO.OutputTokenEncore.values()[tok.ordinal()];
            }
        }
        return ans;
    }

    public static UpdIO.OutputToken ConvertOutputToken(UpdIO.OutputTokenEncore encTok) {
        UpdIO.OutputToken ans = UpdIO.OutputToken.ot_eof;
        switch (encTok) {
            case ote_left_par: {
                ans = UpdIO.OutputToken.ot_left_par;
                break;
            }
            case ote_right_par: {
                ans = UpdIO.OutputToken.ot_right_par;
                break;
            }
            case ote_identifier: {
                ans = UpdIO.OutputToken.ot_identifier;
                break;
            }
            case ote_real: {
                ans = UpdIO.OutputToken.ot_real;
                break;
            }
            default: {
                ans = UpdIO.OutputToken.values()[encTok.ordinal()];
            }
        }
        return ans;
    }

    public long readBinaryInteger(UpdIO.OutputToken type, UpdIO.OutputToken baseToken) throws IOException {
        int len = type.ordinal() - baseToken.ordinal() + 1;
        long value = 0L;
        int shift = 0;
        while (len > 0) {
            value += (long)this.mInStream.read() << shift;
            --len;
            shift += 8;
        }
        return value;
    }

    protected void newline(FileWriter writer, int indent) throws IOException {
        writer.write(10);
        for (int i = 0; i < indent; ++i) {
            writer.write(9);
        }
    }

    protected void c2a(String path) {
        File outFile = new File(path);
        int indent = 0;
        Pattern idNoQuote = Pattern.compile("[\\p{Alnum}_]*");
        try (FileInputStream fis = new FileInputStream(this.mFile);
             FileWriter writer = new FileWriter(outFile);){
            this.mInStream = new BufferedInputStream(fis);
            this.mSize = this.mInStream.available();
            Token magicToken = this.readToken();
            if (magicToken.mType.isInt()) {
                ALog.logInfo((String)"Header token: %X", (Object[])new Object[]{Integer.parseInt(magicToken.mStr)});
            } else {
                ALog.logInfo((String)"Header token: %s", (Object[])new Object[]{magicToken.mStr});
            }
            while (this.mInStream.available() > 0) {
                Token t = this.readToken();
                if (t == null) continue;
                if (t.getType() == UpdIO.OutputToken.ot_left_par) {
                    this.newline(writer, indent);
                } else if (t.getType() == UpdIO.OutputToken.ot_right_par) {
                    this.newline(writer, --indent);
                }
                String s = t.getStr();
                if (t.getType() == UpdIO.OutputToken.ot_identifier) {
                    if (s.length() == 0 || s.charAt(0) == '\u0000') {
                        writer.write("''");
                    } else if (idNoQuote.matcher(s).matches()) {
                        writer.write(s);
                    } else if (s.equals("'")) {
                        writer.write("\"'\"");
                    } else {
                        writer.write("'" + s + "'");
                    }
                } else {
                    writer.write(s);
                }
                if (t.getType() == UpdIO.OutputToken.ot_left_par) {
                    this.newline(writer, ++indent);
                    continue;
                }
                if (t.getType() == UpdIO.OutputToken.ot_right_par) {
                    this.newline(writer, indent);
                    continue;
                }
                writer.write(32);
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"File '%s' not found.", (Object[])new Object[]{this.mFile.getPath()});
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error reading file '%s' (%s).", (Object[])new Object[]{this.mFile.getPath(), e.getLocalizedMessage()});
        }
    }

    public static int test(String ... args) {
        if (args.length < 2) {
            ALog.logError((String)"Invalid options.");
            return 1;
        }
        File f = new File(args[0]);
        String opt = args[1];
        if (opt.equals("-c2a")) {
            if (!f.canRead()) {
                ALog.logError((String)"Cannot read from '%s'.", (Object[])new Object[]{args[0]});
                return 2;
            }
            if (args.length < 3) {
                ALog.logError((String)"No output file specified.");
                return 1;
            }
            UpdReader reader = new UpdReader(f, null);
            reader.c2a(args[2]);
            return 0;
        }
        try {
            Processor proc = null;
            File[] files = new File[]{f};
            if (f.isDirectory()) {
                File dir = f;
                files = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("upd") || name.endsWith("UPD");
                    }
                });
            }
            for (File file : files) {
                if (opt.equals("-p2a")) {
                    if (!f.canRead()) {
                        ALog.logError((String)"Cannot read from '%s'.", (Object[])new Object[]{args[0]});
                        return 2;
                    }
                    proc = args.length > 2 ? new FileOutProcessor(args[2]) : new StdOutProcessor();
                } else if (opt.equals("-p2d")) {
                    Db db = new Db(new Db.Version(0, 0));
                    Design.create((Db)db);
                    proc = new UpdToDbProcessor(db);
                } else {
                    ALog.logError((String)"Invalid options.");
                    return 1;
                }
                ALog.logInfo((String)"Reading '%s'.", (Object[])new Object[]{file.getPath()});
                UpdReader reader = new UpdReader(file, proc);
                boolean result = reader.read();
                ALog.logInfo((String)("UpdReader.read() returned " + result));
            }
        }
        catch (IOException ioe) {
            ALog.logError((Throwable)ioe, (String)"An error occurred during processing", (Object[])new Object[0]);
            return 127;
        }
        return 0;
    }

    public static void main(String[] args) {
        System.exit(UpdReader.test(args));
    }

    static {
        for (KeyWord kw : KeyWord.values()) {
            KeyWords.put(kw.mKey, kw);
        }
    }

    protected static class StdOutProcessor
    extends FileOutProcessor {
        public StdOutProcessor() throws FileNotFoundException {
            super(null);
        }
    }

    protected static class FileOutProcessor
    extends Processor {
        protected PrintStream mOut = System.out;

        public FileOutProcessor(String outfile) throws FileNotFoundException {
            if (outfile != null) {
                File f = new File(outfile);
                this.mOut = new PrintStream(f);
            }
        }

        @Override
        public void initialize() {
        }

        @Override
        public Object processObject(ObjectInfo objectInfo) {
            this.mOut.println(objectInfo.getDescription());
            final ObjectInfo temp = objectInfo;
            return new Object(){

                public String toString() {
                    String desc = temp.mProperties.size() > 0 ? temp.mProperties.get((int)0).mVal : "";
                    return String.format("%s '%s'", temp.mObjectType, desc);
                }
            };
        }

        @Override
        public void processRelation(RelationInfo relInfo) {
            this.mOut.println(String.format("%s is related to: %s\n", relInfo.mParent, relInfo.getDescription()));
        }

        @Override
        public void complete() {
        }
    }

    protected static class InvalidDataException
    extends Exception {
        public InvalidDataException() {
        }

        public InvalidDataException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidDataException(String message) {
            super(message);
        }

        public InvalidDataException(Throwable cause) {
            super(cause);
        }
    }

    protected static class Token {
        String mStr;
        UpdIO.OutputToken mType;

        public Token(String str, UpdIO.OutputToken type) {
            this.mStr = str;
            this.mType = type;
        }

        public void setStr(String str) {
            this.mStr = str;
        }

        public String getStr() {
            return this.mStr;
        }

        public void setType(UpdIO.OutputToken type) {
            this.mType = type;
        }

        public UpdIO.OutputToken getType() {
            return this.mType;
        }

        public KeyWord getIdentifierType() {
            if (this.mType != UpdIO.OutputToken.ot_identifier) {
                return null;
            }
            KeyWord kw = KeyWords.get(this.getStr());
            return kw != null ? kw : KeyWord.tt_identifier;
        }
    }

    public static enum KeyWord {
        kw_def("Def"),
        kw_gfmt("Gfmt"),
        kw_int("Int"),
        kw_lfmt("Lfmt"),
        kw_name("Name"),
        kw_real("Real"),
        kw_ref("Ref"),
        kw_rel("Rel"),
        kw_str("Str"),
        tt_eof("endoffile"),
        tt_space("space"),
        tt_identifier("identifier"),
        tt_integer("integer"),
        tt_real("real"),
        tt_left_par("("),
        tt_right_par(")"),
        tt_unknown("unknowntoken");

        private final String mKey;

        private KeyWord(String key) {
            this.mKey = key;
        }
    }

    public static class ObjectInfo {
        String mObjectType;
        ArrayList<Field> mFields = null;
        ArrayList<Property> mProperties = new ArrayList();
        Object mParent;

        public ObjectInfo(Object parent, String objectType) {
            this(parent, objectType, null);
        }

        public ObjectInfo(Object parent, String objectType, ArrayList<Field> fields) {
            this.mParent = parent;
            this.mObjectType = objectType;
            this.mFields = fields;
        }

        public String getDescription() {
            StringBuffer desc = new StringBuffer("Object of type '" + this.mObjectType + "'\n");
            if (this.mFields != null && this.mFields.size() > 0) {
                desc.append("--- Fields ---\n");
                for (Field f : this.mFields) {
                    desc.append(String.format("%s: %s\n", new Object[]{f.mName, f.mType}));
                }
            }
            if (this.mProperties.size() > 0) {
                desc.append("--- Properties ---\n");
                for (Property p : this.mProperties) {
                    desc.append(String.format("%s (%s): '%s'", new Object[]{p.mName, p.mType, p.mVal}));
                    if (p.mAdditional != null) {
                        for (String s : p.mAdditional) {
                            desc.append(", '" + s + "'");
                        }
                    }
                    desc.append("\n");
                }
            }
            return desc.toString();
        }
    }

    public static class Property {
        KeyWord mType;
        String mName;
        String mVal;
        ArrayList<String> mAdditional;

        public void addVal(String val) {
            if (this.mVal == null) {
                this.mVal = val;
            } else {
                if (this.mAdditional == null) {
                    this.mAdditional = new ArrayList();
                }
                this.mAdditional.add(val);
            }
        }

        public String toString() {
            String addDesc = this.mAdditional == null ? "null" : String.format("%d (%s)", this.mAdditional.size(), this.mAdditional.toString());
            return super.toString() + String.format(" [%s, %s, %s, %s]", new Object[]{this.mType, this.mName, this.mVal, addDesc});
        }
    }

    public static class Field {
        KeyWord mType;
        String mName;
    }

    protected static class RelationInfo {
        String mRelName;
        String mRelObjType;
        String mRelObjName;
        Object mParent;

        public RelationInfo() {
        }

        public RelationInfo(RelationInfo ri) {
            this.mRelName = ri.mRelName;
            this.mRelObjType = ri.mRelObjType;
            this.mRelObjName = ri.mRelObjName;
            this.mParent = ri.mParent;
        }

        public String getDescription() {
            return String.format("Relation (%s); Parent %s; Related object: %s '%s'", this.mRelName, this.mParent, this.mRelObjType, this.mRelObjName);
        }
    }

    public static abstract class Processor {
        protected UpdReader mReader = null;

        public abstract void initialize();

        public abstract Object processObject(ObjectInfo var1) throws InvalidDataException;

        public abstract void processRelation(RelationInfo var1) throws InvalidDataException;

        public abstract void complete();

        public void registerReader(UpdReader reader) {
            this.mReader = reader;
        }

        public UpdReader getRegisteredReader() {
            return this.mReader;
        }
    }
}

