/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.updio;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbLoader;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOutlineGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.updio.UpdPropertyParser;
import com.sigrity.orbit.updio.UpdReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;

public class UpdToDbProcessor
extends UpdReader.Processor
implements DbLoader {
    public static final String DEFAULT_ROOTDEVNAME = "UPDDesign";
    protected Db mDb;
    protected String mRootDeviceName = null;
    protected boolean mDevicenameChanged = false;
    protected String mDeviceTemplatePrefix = null;
    protected DeviceTemplate.Type mTemplateType = DeviceTemplate.Type.PACKAGE;
    protected boolean mReadWires = true;
    protected UpdPropertyParser mPropParser = new UpdPropertyParser();
    protected static double mUPDPerMicron = 100.0;
    protected static double mUpdMicronPerUser = 1.0;
    protected static long mInternalPerMicron = 1000L;
    protected LinkedHashSet<UpdReader.RelationInfo> mDeferredRelations = new LinkedHashSet();
    protected HashMap<Net, Integer> mCurPinTemplateCount = new HashMap();
    protected HashMap<Layer, PadTemplate> mWireEndPadTemplates = new HashMap();
    protected Device mRootDevice = null;
    protected Device mCurDevice;
    protected int mCurDevicePinCount = 0;
    protected Substrate mSubstrate = null;
    protected ArrayList<DeviceTemplate> mPartitions = new ArrayList();
    protected LinkedHashSet<String> mLayerReadOrder = new LinkedHashSet();
    protected LinkedList<Substrate> mCreatedSubstrates = new LinkedList();
    protected LinkedList<Net> mCreatedDesignNets = new LinkedList();
    protected LinkedList<Device> mCreatedDevices = new LinkedList();
    protected HashMap<PadTemplate, ArrayList<Substrate>> mCreatedPadTemplates = new HashMap();
    protected HashMap<String, String> templateToSubstrate = new HashMap();
    protected HashMap<String, PinInstance> mCreatedPinInstances = new HashMap();
    protected HashMap<String, PinTemplate> mCreatedDevTemplatePorts = new HashMap();
    protected LinkedList<HashMap<String, Object>> mDeferredVias = new LinkedList();
    protected HashMap<String, String> mOrigPadstackName2PadTemplateName = new HashMap();
    protected HashMap<String, String> mRenamedDeviceTemplates = new HashMap();
    protected ArrayList<Device> mFixUpDevicesOrigins = new ArrayList();
    protected HashMap<DeviceTemplate, Integer> mDeviceTemplate2PinCount = new HashMap();
    protected LinkedList<Wire> mCreatedWires = new LinkedList();
    protected LinkedList<Metal> mCreatedMetals = new LinkedList();
    protected boolean mArcPathWarningIssued = false;
    protected boolean mArcWarningIssued = false;
    protected DeviceTemplate mDeviceTemplate = null;
    protected UpdPropertyParser.Parser parseCoordinate = new CoordinateParser();
    protected UpdPropertyParser.Parser parseRect = new RectagleParser();
    protected UpdPropertyParser.Parser parseGeometry = new GeometryParser();
    protected UpdPropertyParser.Parser parseArrayInt = new ArrayIntegerParser();
    protected UpdPropertyParser.Parser parseDesignResolution = new DesignResolutionParser();
    static int _LV_EXTRADATAFLAG = Integer.MIN_VALUE;
    protected UpdPropertyParser.Parser parseLinkedVertexList = new LinkedVertexListParser();

    public static boolean importUpd(String filePath, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type templateType, boolean readWires) {
        File file = new File(filePath);
        if (!file.canRead()) {
            ALog.logError((String)"Cannot read '%s'.", (Object[])new Object[]{filePath});
            return false;
        }
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot import '%s', there is no current database.", (Object[])new Object[]{filePath});
            return false;
        }
        UpdToDbProcessor dbProcessor = new UpdToDbProcessor(db);
        dbProcessor.setRootDeviceName(rootDeviceName);
        dbProcessor.setDeviceTemplatePrefix(deviceTemplatePrefix);
        if (templateType != null) {
            dbProcessor.setSubstrateType(templateType);
        }
        dbProcessor.setReadWires(readWires);
        UpdReader reader = new UpdReader(file, dbProcessor);
        dbProcessor.registerReader(reader);
        ALog.logInfo((String)"Reading '%s'.", (Object[])new Object[]{file.getPath()});
        if (!reader.read()) {
            return false;
        }
        Design d = Design.getDesign((Db)db);
        d.binAllDevices();
        return true;
    }

    public UpdToDbProcessor(Db db) {
        this.mDb = db;
        this.addParser(null, "Center", this.parseCoordinate);
        this.addParser(null, "CenterOrgAdj", this.parseCoordinate);
        this.addParser(null, "Dorigin", this.parseCoordinate);
        this.addParser(null, "DOrigin", this.parseCoordinate);
        this.addParser(null, "GluePt", this.parseCoordinate);
        this.addParser(null, "NudgeOrigin", this.parseCoordinate);
        this.addParser(null, "Pin1OrgAdj", this.parseCoordinate);
        this.addParser(null, "Pt", this.parseCoordinate);
        this.addParser(null, "AlternateBody", this.parseGeometry);
        this.addParser(null, "Geom", this.parseGeometry);
        this.addParser(null, "Geometry", this.parseGeometry);
        this.addParser(null, "BodyOutlinePolygon", this.parseGeometry);
        this.addParser(null, "BoundRect", this.parseRect);
        this.addParser("component", "GroupDs", this.parseCoordinate);
        this.addParser("component", "PinBoundRect", this.parseGeometry);
        this.addParser("esegment", "X1Y1", this.parseCoordinate);
        this.addParser("esegment", "X2Y2", this.parseCoordinate);
        this.addParser("model", "Interconnects", this.parseLinkedVertexList);
        this.addParser("modelelem", "RelLoc", this.parseCoordinate);
        this.addParser("modelelem", "NetNums", this.parseArrayInt);
        this.addParser("smartmetal", "HatchGeom", this.parseGeometry);
        this.addParser("design", "resolution", this.parseDesignResolution);
    }

    public void setRootDeviceName(String name) {
        if ((name = name.trim()).length() == 0) {
            name = null;
        }
        this.mRootDeviceName = name;
        this.mDevicenameChanged = true;
    }

    public void setDeviceTemplatePrefix(String prefix) {
        if ((prefix = prefix.trim()).length() == 0) {
            prefix = null;
        }
        this.mDeviceTemplatePrefix = prefix;
    }

    public void setSubstrateType(DeviceTemplate.Type t) {
        this.mTemplateType = t;
    }

    public void setReadWires(boolean readWires) {
        this.mReadWires = readWires;
    }

    @Override
    public void initialize() {
        Object substrateName;
        this.mDb.setActiveLoader((DbLoader)this);
        this.mDb.setHistoryEnabled(false);
        this.mDb.setListenersEnabled(false);
        if (this.mRootDeviceName == null) {
            this.mRootDeviceName = DEFAULT_ROOTDEVNAME;
        }
        Design design = Design.getDesign((Db)this.mDb);
        String origName = this.mRootDeviceName;
        this.mRootDeviceName = Device.getUniqueName((DeviceTemplate)design, (String)this.mRootDeviceName);
        if (origName != null && !origName.equals(this.mRootDeviceName)) {
            ALog.logInfo((String)"A root device named '%s' already exists, the new root device name was changed to '%s'.", (Object[])new Object[]{origName, this.mRootDeviceName});
        }
        if (!((String)(substrateName = this.mRootDeviceName)).startsWith("UPD_")) {
            substrateName = "UPD_" + (String)substrateName;
        }
        substrateName = (String)substrateName + "_Substrate";
        substrateName = Substrate.getUniqueName((Db)this.mDb, (String)substrateName);
        this.mSubstrate = this.createSubstrate((String)substrateName);
        this.mDeviceTemplate = DeviceTemplate.create((Substrate)this.mSubstrate, (String)this.mRootDeviceName, (boolean)false);
        this.mDeviceTemplate.setType(this.mTemplateType);
        this.mRootDevice = Device.create((Db)this.mDb, (String)this.mRootDeviceName, (DeviceTemplate)this.mDeviceTemplate, (DeviceTemplate)design);
    }

    @Override
    public Object processObject(UpdReader.ObjectInfo oi) throws UpdReader.InvalidDataException {
        HashMap<String, Object> values = this.mPropParser.parseFieldProps(oi);
        DbObject dbo = this.processEvent((ObjectTracker)oi.mParent, oi.mObjectType, values);
        return new ObjectTracker(oi.mObjectType, dbo, (ObjectTracker)oi.mParent);
    }

    @Override
    public void processRelation(UpdReader.RelationInfo relInfo) {
        ObjectTracker parent = (ObjectTracker)relInfo.mParent;
        if (parent.mDbo instanceof Device) {
            if (relInfo.mRelObjType.equals("package")) {
                DeviceTemplate dt = this.getDeviceTemplate(relInfo.mRelObjName);
                if (dt != null) {
                    ((Device)parent.mDbo).setTemplate(dt);
                }
                return;
            }
        } else if (parent.mDbo instanceof DeviceTemplate) {
            DeviceTemplate dt = (DeviceTemplate)parent.mDbo;
            Substrate s = dt.getSubstrate();
            if (s != null && relInfo.mRelObjType.equals("layer")) {
                String layerName = relInfo.mRelObjName;
                if (s.getLayer(layerName) == null) {
                    this.createLayer(s, layerName);
                }
                return;
            }
        } else if (parent.mObjType.equalsIgnoreCase("diffpair")) {
            if (relInfo.mRelObjType.equalsIgnoreCase("net")) {
                String netName = relInfo.mRelObjName;
                for (Net net : this.mCreatedDesignNets) {
                    if (!net.getName().equals(netName) || !(parent.mDbo instanceof Personality)) continue;
                    net.assignToPersonality((Personality)parent.mDbo, null);
                    break;
                }
            }
        } else if (parent.mObjType.equalsIgnoreCase("footprintdefpin") && relInfo.mRelObjType.equalsIgnoreCase("padstack")) {
            String padstackName = relInfo.mRelObjName;
            String newPadstackName = this.mOrigPadstackName2PadTemplateName.get(padstackName);
            if (newPadstackName != null) {
                padstackName = newPadstackName;
            }
            for (PadTemplate pt : this.mCreatedPadTemplates.keySet()) {
                ArrayList<Substrate> subs;
                if (!pt.getName().equals(padstackName)) continue;
                DeviceTemplate dt = null;
                ObjectTracker ancester = parent;
                while (dt == null || ancester.mParent == null) {
                    if (ancester.mDbo instanceof DeviceTemplate) {
                        dt = (DeviceTemplate)ancester.mDbo;
                    }
                    ancester = ancester.mParent;
                }
                Substrate s = dt.getSubstrate();
                if (s == null || (subs = this.mCreatedPadTemplates.get(pt)).contains(s)) break;
                subs.add(s);
                break;
            }
        }
        UpdReader.RelationInfo deferRelInfo = new UpdReader.RelationInfo(relInfo);
        this.mDeferredRelations.add(deferRelInfo);
    }

    @Override
    public void complete() {
        this.finishDeviceCreation();
        this.finishPinCreation();
        this.finishViaCreation();
        this.processDeferredRelations();
        this.fixLayerOrder();
        this.fixUpUPDOriginMess();
        this.finishWireCreation();
        this.finishMetalCreation();
        this.mDb.setActiveLoader(null);
        this.mDb.setListenersEnabled(true);
        this.mDb.setHistoryEnabled(true);
    }

    public DbObject processEvent(ObjectTracker parent, String objType, HashMap<String, Object> values) {
        if (objType.equals("design")) {
            double dbuPerInch = 2540000.0;
            if (values.get("InternalPerInch") != null) {
                String s = (String)values.get("InternalPerInch");
                dbuPerInch = Double.parseDouble(s);
            } else if (values.get("resolution") != null) {
                int idxLength;
                LinkedList vals = (LinkedList)values.get("resolution");
                int idxDbu = vals.indexOf("dbu");
                if (idxDbu >= 0 && vals.size() > idxDbu + 1) {
                    dbuPerInch = Double.parseDouble((String)vals.get(idxDbu + 1));
                }
                if ((idxLength = vals.indexOf("length")) >= 0 && vals.size() > idxLength + 1) {
                    String updLength = (String)vals.get(idxLength + 1);
                    if (updLength.equals("1/10-mil")) {
                        mUpdMicronPerUser = 2.54;
                    } else if (updLength.equals("micro-inch")) {
                        mUpdMicronPerUser = 0.0254;
                    } else if (updLength.equals("mil")) {
                        mUpdMicronPerUser = 25.4;
                    } else if (updLength.equals("inch")) {
                        mUpdMicronPerUser = 25400.0;
                    } else if (updLength.equals("micron")) {
                        mUpdMicronPerUser = 1.0;
                    } else if (updLength.equals("mm")) {
                        mUpdMicronPerUser = 1000.0;
                    } else if (updLength.equals("cm")) {
                        mUpdMicronPerUser = 10000.0;
                    }
                }
            }
            mUPDPerMicron = dbuPerInch / 25400.0;
            Design design = Design.getDesign((Db)this.mDb);
            if (design == null) {
                design = Design.create((Db)this.mDb);
            }
            mInternalPerMicron = design.getInternalPerMicron();
            return design;
        }
        if (objType.equals("component")) {
            String isFixed;
            String mm;
            String rot;
            Device d = new Device((String)values.get("Name"), this.mRootDevice, null);
            d.setLoc((APoint2D)values.get("DOrigin"));
            String placed = (String)values.get("IsPlaced");
            if (placed != null && placed.equals("1")) {
                d.setIsPlaced(true);
            }
            if ((rot = (String)values.get("Rot")) != null) {
                float r = Float.parseFloat(rot);
                r = (360.0f - r) % 360.0f;
                d.setRotate(r);
            }
            if ((mm = (String)values.get("MountingMethodName")) != null && (mm.equals("Default_MIRROR") || mm.equals("Default_BOTTOM"))) {
                d.setMirror(true);
            }
            if ((isFixed = (String)values.get("IsFixed")) != null && isFixed.equals("1")) {
                d.setIsFixed(true);
            }
            this.mDb.add((DbObject)d);
            String relToOrigin = (String)values.get("DOriginRelTo");
            if (relToOrigin.equals("reference_pin")) {
                this.mFixUpDevicesOrigins.add(d);
            }
            this.mCreatedDevices.add(d);
            return d;
        }
        if (objType.equals("pin")) {
            String pinType = (String)values.get("p_type");
            if (pinType != null && pinType.equals("via")) {
                this.mDeferredVias.add(values);
            } else {
                String pinName = (String)values.get("Name");
                if (pinName != null) {
                    PinInstance dp = new PinInstance(pinName, null, null);
                    this.mCreatedPinInstances.put(pinName, dp);
                    return dp;
                }
            }
        } else {
            if (objType.equals("footprintdef")) {
                assert (parent.mObjType.equals("package"));
                String thisMMName = (String)values.get("MountingMethodName");
                if (thisMMName != null && thisMMName.compareTo("Default_TOP") == 0) {
                    AGeom g = (AGeom)values.get("BodyOutlinePolygon");
                    if (g == null) {
                        g = (AGeom)values.get("AlternateBody");
                    }
                    assert (g != null);
                    if (g != null) {
                        ((DeviceTemplate)parent.mDbo).setBounds(g);
                    }
                    return parent.mDbo;
                }
                return null;
            }
            if (objType.equals("footprintdefpin")) {
                String isPin1;
                DeviceTemplate dt = (DeviceTemplate)parent.getDbo();
                if (dt == null) {
                    return null;
                }
                int pinNum = this.getNextPinNum(dt);
                Object name = "" + values.get("UserName");
                if (((String)(name = ((String)name).trim())).length() == 0) {
                    name = "Pin" + pinNum;
                }
                Net net = dt.getNetUnused();
                Object netName = "" + values.get("DefaultNetName");
                if (((String)(netName = ((String)netName).trim())).length() != 0 && (net = dt.getNet((String)netName)) == null) {
                    net = new Net(dt, (String)netName);
                    this.mDb.add((DbObject)net);
                }
                assert (net != null);
                PinTemplate dtp = this.createPinTemplate((String)name, net);
                APoint2D loc = (APoint2D)values.get("Pt");
                dtp.setLoc(loc);
                String strRot = (String)values.get("PadstackRot");
                if (strRot != null) {
                    float r = Float.parseFloat(strRot);
                    r = (360.0f - r) % 360.0f;
                    dtp.setRotate(r);
                }
                if ((isPin1 = (String)values.get("IsPin1")) != null && isPin1.equals("1")) {
                    dtp.setIsPin1(true);
                }
                return dtp;
            }
            if (objType.equals("layer")) {
                String name = (String)values.get("Name");
                Layer l = this.mSubstrate.getLayer(name);
                if (l == null) {
                    l = this.createLayer(this.mSubstrate, name);
                }
                this.setNotNull((DbObject)l, "thickness", values.get("Thickness"), true);
                String layerType = (String)values.get("Type");
                if (layerType != null) {
                    l.setType(layerType);
                }
                return l;
            }
            if (objType.equals("partition_layer")) {
                for (DeviceTemplate dt : this.mPartitions) {
                    Substrate s = dt.getSubstrate();
                    this.createLayer(s, (String)values.get("layer"));
                }
                return null;
            }
            if (objType.equals("net")) {
                Net net = new Net(null, (String)values.get("Name"));
                this.mDb.add((DbObject)net);
                this.mCreatedDesignNets.add(net);
                return net;
            }
            if (objType.equals("diffpair")) {
                if (parent.mObjType.equals("diffpair")) {
                    Personality netPersonality = Personality.createDiffPair((String)((String)values.get("Name")), (DeviceTemplate)this.mDeviceTemplate);
                    return netPersonality;
                }
            } else {
                if (objType.equals("package")) {
                    DeviceTemplate dt = this.createDeviceTemplate("" + values.get("Name"));
                    dt.setType(DeviceTemplate.Type.PACKAGEDDIE);
                    this.mDb.add((DbObject)dt);
                    Object type = values.get("type");
                    if (type != null) {
                        dt.setValue("UPDPackageType", (Object)("" + type));
                        if (type.equals("die")) {
                            dt.setType(DeviceTemplate.Type.DIE);
                        } else if (type.equals("package")) {
                            dt.setType(DeviceTemplate.Type.PACKAGE);
                        }
                    }
                    return dt;
                }
                if (objType.equals("padstack")) {
                    String name = (String)values.get("Name");
                    PadTemplate pt = PadTemplate.create((Db)this.mDb, (Substrate)this.mSubstrate, (String)name);
                    if (!pt.getName().equals(name)) {
                        this.mOrigPadstackName2PadTemplateName.put(name, pt.getName());
                    }
                    this.mCreatedPadTemplates.put(pt, new ArrayList());
                    return pt;
                }
                if (objType.equals("partition")) {
                    String name = "" + values.get("Name");
                    if (name.equals("Design")) {
                        return this.mRootDevice.getTemplate();
                    }
                    String dtName = this.formatUpdPartitionName("" + values.get("Name"));
                    DeviceTemplate dt = this.createDeviceTemplate(dtName);
                    this.mPartitions.add(dt);
                    this.mDb.add((DbObject)dt);
                    return dt;
                }
                if (objType.equals("shape")) {
                    Metal metal;
                    if (parent.mObjType.equals("pattern")) {
                        if (parent.mParent.mObjType.equals("padstack")) {
                            AGeom geom = (AGeom)values.get("Geom");
                            LayerShape ls = LayerShape.create((Db)this.mDb, null, (DbObject)parent.mParent.getDbo(), (AGeom)geom);
                            return ls;
                        }
                    } else if (parent.mObjType.equals("partition")) {
                        AGeom g = (AGeom)values.get("Geom");
                        if (g != null) {
                            ((DeviceTemplate)parent.getDbo()).setBounds(g);
                        }
                    } else if (parent.mObjType.equals("wire")) {
                        Wire wire;
                        if (parent.mParent.mObjType.equals("wiring") && parent.mParent.mParent.mObjType.equals("design") && (wire = (Wire)parent.mDbo) != null) {
                            AGeom geom = (AGeom)values.get("Geom");
                            assert (geom instanceof APath);
                            if (geom instanceof APath) {
                                APath path = (APath)geom;
                                wire.setPath(path);
                            }
                            return wire;
                        }
                    } else if (parent.mObjType.equals("smartmetal") && (metal = (Metal)parent.mDbo) != null) {
                        AGeom geom = (AGeom)values.get("Geom");
                        metal.setGeom(geom);
                        return metal;
                    }
                } else if (objType.equals("wire") && this.mReadWires) {
                    if (parent.mObjType.equals("wiring") && parent.mParent.mObjType.equals("design")) {
                        String netName;
                        Wire wire = new Wire(null, null, null);
                        Object net_num = values.get("net_num");
                        String string = netName = net_num == null ? null : net_num.toString();
                        if (netName != null && netName.length() > 0) {
                            UpdReader.RelationInfo ri = new UpdReader.RelationInfo();
                            ri.mParent = new ObjectTracker("wire", (DbObject)wire, parent);
                            ri.mRelObjType = "net_num";
                            ri.mRelObjName = netName;
                            this.mDeferredRelations.add(ri);
                        }
                        this.mDb.add((DbObject)wire);
                        this.mCreatedWires.add(wire);
                        return wire;
                    }
                } else if (objType.equals("smartmetal") && parent != null && parent.mObjType.equals("smartmetal") && parent.mParent != null && parent.mParent.mObjType.equals("design")) {
                    Metal metal = new Metal(null, null);
                    this.mDb.add((DbObject)metal);
                    this.mCreatedMetals.add(metal);
                    return metal;
                }
            }
        }
        return null;
    }

    protected void setNotNull(DbObject dbo, String field, Object val, boolean toDbu) {
        if (val == null) {
            return;
        }
        DbClass dbc = this.mDb.getDbClass(dbo.getClass());
        DbFieldDef fd = dbc.getField(field);
        if (fd == null) {
            assert (false) : "Invalid field specified";
            return;
        }
        if (!fd.getClass().equals(String.class) && val.getClass().equals(String.class)) {
            if (toDbu) {
                long l = this.updUser2Db((String)val);
                dbo.setValue(field, (Object)l);
            } else {
                fd.setValueFromString(dbo, (String)val);
            }
        } else {
            dbo.setValue(field, val);
        }
    }

    protected void addParser(String objType, String field, UpdPropertyParser.Parser parser2) {
        this.mPropParser.addParser(objType, field, parser2);
    }

    public long updDb2Db(String val) {
        Double v = Double.parseDouble(val);
        return (long)(v / mUPDPerMicron * (double)mInternalPerMicron);
    }

    public long updUser2Db(String val) {
        Double v = Double.parseDouble(val);
        return (long)(v * mUpdMicronPerUser * (double)mInternalPerMicron);
    }

    protected boolean hasNextNumber(UpdPropertyParser.ObjectValueIterator ovi) {
        if (!ovi.hasNext()) {
            return false;
        }
        String s = ovi.peek();
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    protected boolean hasNextLong(UpdPropertyParser.ObjectValueIterator ovi) {
        if (!ovi.hasNext()) {
            return false;
        }
        String s = ovi.peek();
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    protected int getNextPinNum(DeviceTemplate dt) {
        Integer i = this.mDeviceTemplate2PinCount.get(dt);
        if (i == null) {
            i = 0;
        }
        Integer n = i;
        Integer n2 = i = Integer.valueOf(i + 1);
        this.mDeviceTemplate2PinCount.put(dt, i);
        return i;
    }

    protected void finishDeviceCreation() {
        DeviceTemplate rootDeviceTemplate;
        if (this.mCreatedDevices.size() == 1) {
            this.mRootDevice.deleteFromDb();
            this.mRootDevice = this.mCreatedDevices.get(0);
            rootDeviceTemplate = this.mRootDevice.getTemplate();
            this.mCreatedDevices.remove(0);
            if (this.mDevicenameChanged) {
                this.mRootDevice.setName(this.mRootDeviceName);
            }
            rootDeviceTemplate.setType(this.mTemplateType);
        } else {
            rootDeviceTemplate = this.mRootDevice.getTemplate();
        }
        if (rootDeviceTemplate == null) {
            assert (false);
            return;
        }
        for (Net n : this.mCreatedDesignNets) {
            Net aNet = Net.get((DeviceTemplate)rootDeviceTemplate, (String)n.getName());
            if (aNet == null) {
                n.setDeviceTemplate(rootDeviceTemplate);
                continue;
            }
            n.deleteFromDb();
        }
        if (!this.mCreatedDevices.isEmpty()) {
            this.mRootDevice.setTemplate(rootDeviceTemplate);
        }
        this.mSubstrate = this.mRootDevice.getSubstrate();
        this.mRootDevice.setParent((DeviceTemplate)Design.getDesign((Db)this.mDb));
        this.mRootDevice.setLoc(new APoint2D(0L, 0L));
        for (Device d : this.mCreatedDevices) {
            d.setParent(this.mRootDevice, true);
        }
        ArrayList<UpdReader.RelationInfo> processed = new ArrayList<UpdReader.RelationInfo>();
        for (UpdReader.RelationInfo relInfo : this.mDeferredRelations) {
            ObjectTracker parent = (ObjectTracker)relInfo.mParent;
            if (!(parent.mDbo instanceof Device) || !relInfo.mRelObjType.equals("package")) continue;
            DeviceTemplate dt = this.getDeviceTemplate(relInfo.mRelObjName);
            if (dt != null) {
                ((Device)parent.mDbo).setTemplate(dt);
            }
            processed.add(relInfo);
        }
        for (UpdReader.RelationInfo relInfo : processed) {
            this.mDeferredRelations.remove(relInfo);
        }
    }

    protected void processDeferredRelations() {
        for (UpdReader.RelationInfo relInfo : this.mDeferredRelations) {
            Layer l;
            Net net;
            ObjectTracker parent = (ObjectTracker)relInfo.mParent;
            if (parent.mDbo instanceof LayerShape) {
                Layer l2;
                if (!relInfo.mRelObjType.equals("layer")) continue;
                PadTemplate dt = null;
                ObjectTracker ot = parent;
                while (dt == null && ot != null) {
                    if (ot.mDbo != null && ot.mDbo instanceof PadTemplate) {
                        dt = (PadTemplate)ot.mDbo;
                    }
                    ot = ot.mParent;
                }
                Substrate s = this.mSubstrate;
                if (dt != null) {
                    ArrayList<Substrate> subs = this.mCreatedPadTemplates.get(dt);
                    if (subs != null && subs.size() == 1) {
                        s = subs.get(0);
                    }
                    dt.setSubstrate(s);
                }
                if ((l2 = s.getLayer(relInfo.mRelObjName)) == null) {
                    l2 = this.createLayer(s, relInfo.mRelObjName);
                }
                ((LayerShape)parent.mDbo).setLayer(l2);
                continue;
            }
            if (parent.mDbo instanceof PinTemplate) {
                PinTemplate pinT;
                PadTemplate pt;
                if (!relInfo.mRelObjType.equals("padstack") || (pt = PadTemplate.get((Db)this.mDb, (Substrate)(pinT = (PinTemplate)parent.mDbo).getSubstrate(), (String)relInfo.mRelObjName)) == null) continue;
                pinT.setPadTemplate(pt);
                continue;
            }
            if (parent.mDbo instanceof Net) {
                if (!relInfo.mRelObjType.equals("pin")) continue;
                Net netParent = (Net)parent.mDbo;
                String pinName = relInfo.mRelObjName;
                PinInstance dp = this.mCreatedPinInstances.get(pinName);
                if (dp == null) {
                    dp = new PinInstance(pinName, null, null);
                    boolean added = this.addPinInstanceToDb(dp);
                    if (!added) {
                        ALog.logWarn((String)"Ignoring relation for net '%s' to pin '%s', the pin specified is invalid.", (Object[])new Object[]{netParent.getName(), pinName});
                        continue;
                    }
                    this.mCreatedPinInstances.put(pinName, dp);
                }
                if (netParent == null || netParent.getDb() == null) continue;
                assert (netParent.getDeviceTemplate() == this.mRootDevice.getTemplate());
                DeviceTemplate dtPort = dp.getDeviceTemplate();
                PinTemplate dtpPort = dp.getPinTemplate();
                Net netPort = dp.getNet();
                if (netParent.isUnused()) {
                    Net curParentNet;
                    if (netPort == null) {
                        dtpPort.setNet(dtPort.getNetUnused());
                        continue;
                    }
                    if (netPort.isUnused() || (curParentNet = NetMap.getParentNet((Device)dp.getDevice(), (Net)netPort)) == null) continue;
                    NetMap.unmap((Device)dp.getDevice(), (Net)netPort, (Net)curParentNet);
                    continue;
                }
                String parentNetName = netParent.getName();
                if (netPort == null || netPort.isUnused()) {
                    netPort = dtPort.createNet(parentNetName, true);
                    dtpPort.setNet(netPort);
                }
                NetMap.mapChildNet((Device)dp.getDevice(), (Net)netPort, (Net)netParent);
                continue;
            }
            if (parent.mDbo instanceof Wire) {
                Wire wire = (Wire)parent.mDbo;
                if (relInfo.mRelObjType.equals("net_num")) {
                    net = this.mRootDevice.getTemplate().getNet(relInfo.mRelObjName);
                    assert (net != null);
                    if (net == null) continue;
                    wire.setNet(net);
                    continue;
                }
                if (!relInfo.mRelObjType.equals("layer") || (l = this.mSubstrate.getLayer(relInfo.mRelObjName)) == null) continue;
                wire.setLayer(l);
                continue;
            }
            if (!(parent.mDbo instanceof Metal)) continue;
            Metal metal = (Metal)parent.mDbo;
            if (relInfo.mRelObjType.equals("layer")) {
                l = this.mSubstrate.getLayer(relInfo.mRelObjName);
                if (l == null) continue;
                metal.setLayer(l);
                continue;
            }
            if (!relInfo.mRelObjType.equals("net") || (net = this.mRootDevice.getTemplate().getNet(relInfo.mRelObjName)) == null) continue;
            metal.setNet(net);
        }
    }

    protected void finishPinCreation() {
        for (PinInstance dp : this.mCreatedPinInstances.values()) {
            boolean added = this.addPinInstanceToDb(dp);
            assert (added);
        }
    }

    protected void finishViaCreation() {
        DeviceTemplate dt = this.mRootDevice.getTemplate();
        for (HashMap hashMap : this.mDeferredVias) {
            String bfName;
            PadTemplate pt;
            String strPinType = (String)hashMap.get("p_type");
            Net net = null;
            String netName = (String)hashMap.get("net_num");
            if (netName == null || netName.isEmpty()) {
                net = dt.getNetUnused();
            } else {
                net = dt.getNet(netName);
                if (net == null) {
                    ALog.logWarn((String)"Net '%s' does not exist, a %s using it cannot be created.", (Object[])new Object[]{netName, strPinType});
                    continue;
                }
            }
            String strIsBF = (String)hashMap.get("IsBondFinger");
            boolean isBF = strIsBF == null ? false : strIsBF.equals("1");
            String strX = (String)hashMap.get("x");
            String strY = (String)hashMap.get("y");
            String strViaRot = (String)hashMap.get("ViaRot");
            String padstack = (String)hashMap.get("padstack");
            String newName = this.mOrigPadstackName2PadTemplateName.get(padstack);
            if (newName != null) {
                padstack = newName;
            }
            if ((pt = PadTemplate.get((Db)this.mDb, (Substrate)net.getSubstrate(), (String)padstack)) == null) {
                ALog.logWarn((String)"Padstack '%s' does not exist, a %s using it cannot be created.", (Object[])new Object[]{padstack, strPinType});
                continue;
            }
            String name = strPinType;
            if (isBF && (bfName = (String)hashMap.get("BondFingerName")) != null) {
                name = bfName;
            }
            String base = name;
            int i = 1;
            while (net.getPinTemplate(name) != null) {
                name = String.format("%s%d", base, ++i);
            }
            PinTemplate dtp = PinTemplate.create((Net)net, (String)name);
            dtp.setPadTemplate(pt);
            APoint2D loc = new APoint2D(this.updUser2Db(strX), this.updUser2Db(strY));
            dtp.setLoc(loc);
            if (strViaRot != null) {
                dtp.setRotate(360.0f - Float.parseFloat(strViaRot));
            }
            if (isBF) {
                dtp.setType(PinTemplate.Type.BONDFINGERPAD);
            }
            PinInstance.create((Db)this.mDb, (String)name, (Device)this.mRootDevice, (PinTemplate)dtp);
        }
    }

    protected void finishWireCreation() {
        for (Wire wire : this.mCreatedWires) {
            APoint2D p;
            APath path = wire.getPath();
            if (path == null) {
                assert (false);
                continue;
            }
            Net net = wire.getNet();
            if (net == null) {
                net = this.mRootDevice.getTemplate().getNetUnused();
                wire.setNet(net);
            }
            if (path.getPointCount() > 0) {
                p = path.getFirstPoint();
                this.addPort(net, p, wire.getLayer());
            }
            if (path.getPointCount() <= 1) continue;
            p = path.getLastPoint();
            this.addPort(net, p, wire.getLayer());
        }
    }

    protected void finishMetalCreation() {
        for (Metal metal : this.mCreatedMetals) {
            Net net = metal.getNet();
            if (net != null) continue;
            net = this.mRootDevice.getTemplate().getNetUnused();
            metal.setNet(net);
        }
    }

    private void addPort(Net net, APoint2D point, Layer layer) {
        PinTemplate dtp = this.createUniquePinTemplate(net);
        this.mDb.add((DbObject)dtp);
        dtp.setLoc(point);
        if (layer != null) {
            PadTemplate pt = this.mWireEndPadTemplates.get(layer);
            if (pt == null) {
                pt = PadTemplate.create((Db)this.mDb, (Substrate)dtp.getSubstrate(), (String)String.format("WireEnd-%s", layer.getName()));
                dtp.setPadTemplate(pt);
                LayerShape.create((Db)this.mDb, (Layer)layer, (DbObject)pt, (AGeom)new ARect(0L, 0L, 0L, 0L));
                this.mWireEndPadTemplates.put(layer, pt);
            }
            dtp.setPadTemplate(pt);
        }
        PinInstance dp = new PinInstance(dtp.getName(), this.mRootDevice, dtp);
        this.mDb.add((DbObject)dp);
    }

    protected PinTemplate createUniquePinTemplate(Net net) {
        String name;
        int i;
        assert (net != null);
        Integer curCount = this.mCurPinTemplateCount.get(net);
        int n = i = curCount == null ? 0 : curCount;
        while (net.getPinTemplate(name = String.format("Port%d", ++i)) != null) {
        }
        this.mCurPinTemplateCount.put(net, i);
        return new PinTemplate(name, net);
    }

    protected boolean addPinInstanceToDb(PinInstance dp) {
        Device d;
        String pinName = dp.getName();
        if (pinName == null) {
            return false;
        }
        int index = pinName.indexOf("-");
        if (index <= 0) {
            return false;
        }
        String devName = pinName.substring(0, index);
        if (this.mCreatedDevices.size() == 0) {
            d = this.mRootDevice;
        } else {
            DeviceTemplate rootDt = this.mRootDevice.getTemplate();
            d = rootDt.getChild(devName);
        }
        if (d == null) {
            assert (false);
            return false;
        }
        dp.setValue("device", (Object)d);
        DeviceTemplate dt = d.getTemplate();
        String portName = pinName.substring(index + 1);
        PinTemplate dtp = this.getPinTemplate(dt, portName);
        if (dtp == null) {
            assert (false);
            return false;
        }
        dp.setValue("pinTemplate", (Object)dtp);
        return this.mDb.add((DbObject)dp);
    }

    protected void fixLayerOrder() {
        for (Substrate s : this.mCreatedSubstrates) {
            int lCount = AUtil.linkedList((Iterator)s.getLayers()).size();
            int nextLayerOrder = 0;
            for (String layerName : this.mLayerReadOrder) {
                Layer l = s.getLayer(layerName);
                if (l == null) continue;
                l.setOrder(lCount - nextLayerOrder++);
            }
        }
    }

    protected void fixUpUPDOriginMess() {
        ArrayList<DeviceTemplate> mProcessed = new ArrayList<DeviceTemplate>();
        for (Device d : this.mFixUpDevicesOrigins) {
            DeviceTemplate t = d.getTemplate();
            if (mProcessed.contains(t)) continue;
            mProcessed.add(t);
            PinTemplate p = t.getPin1();
            if (p == null) continue;
            APoint2D ds = p.getLoc();
            t.shiftMyBounds(-ds.getX(), -ds.getY());
        }
    }

    protected void fixUpOffsets() {
        if (this.mRootDevice == null) {
            return;
        }
        APoint2D ll = this.mRootDevice.getTemplate().getBB().getLL();
        DevicePath rootPath = new DevicePath(this.mRootDevice);
        for (Device d : this.mCreatedDevices) {
            if (d == this.mRootDevice) continue;
            DevicePath path = new DevicePath(rootPath, d);
            APoint2D myll = path.getBB().getLL();
            d.moveTo(myll.getX() - ll.getX(), myll.getY() - ll.getY());
        }
    }

    protected Layer createLayer(Substrate s, String name) {
        if (!this.mLayerReadOrder.contains(name)) {
            this.mLayerReadOrder.add(name);
        }
        return Layer.create((Substrate)s, (String)name);
    }

    protected PinTemplate createPinTemplate(String name, Net net) {
        assert (net != null);
        PinTemplate dtp = PinTemplate.create((Net)net, (String)name);
        String key = String.format("%s:%s", net.getDeviceTemplate().getName(), name);
        PinTemplate prev = this.mCreatedDevTemplatePorts.put(key, dtp);
        assert (prev == null);
        return dtp;
    }

    protected PinTemplate getPinTemplate(DeviceTemplate dt, String name) {
        String key = String.format("%s:%s", dt.getName(), name);
        return this.mCreatedDevTemplatePorts.get(key);
    }

    public DbLoader.DbLoadingForeignKey getLoadingKeyVal(DbObject dbo, DbFieldDef keyField) {
        if (dbo == this.mRootDevice || dbo instanceof Design && keyField.getField().getType() == Substrate.class) {
            return new DbLoader.StringForeignKey("[null]");
        }
        return new DbLoader.StringForeignKey(String.format("[null:%d]", dbo.getDbObjId()));
    }

    protected String getDeviceTemplateName(String baseName) {
        return this.mDeviceTemplatePrefix == null ? baseName : String.format("%s%s", this.mDeviceTemplatePrefix, baseName);
    }

    protected DeviceTemplate getDeviceTemplate(String baseName) {
        String name = this.getDeviceTemplateName(baseName);
        String rename = this.mRenamedDeviceTemplates.get(name);
        if (rename != null) {
            name = rename;
        }
        Substrate s = Substrate.getSubstrate((Db)this.mDb, (String)this.templateToSubstrate.get(name));
        return DeviceTemplate.getDeviceTemplate((Substrate)s, (String)name);
    }

    protected DeviceTemplate createDeviceTemplate(String baseName) {
        String name = baseName = this.getDeviceTemplateName(baseName);
        Substrate s = this.createSubstrate(name + "_Substrate");
        int i = 1;
        while (DeviceTemplate.getDeviceTemplate((Substrate)s, (String)name) != null) {
            name = String.format("%s%d", baseName, i);
            ++i;
        }
        if (!name.equals(baseName)) {
            this.mRenamedDeviceTemplates.put(baseName, name);
            ALog.logInfo((String)"DeviceTemplate '%s' already exists, renamed to '%s'.", (Object[])new Object[]{baseName, name});
        }
        DeviceTemplate dt = new DeviceTemplate(name, s);
        this.templateToSubstrate.put(name, s.getName());
        dt.setSourceType(DeviceTemplate.SourceType.UPD);
        UpdReader reader = this.getRegisteredReader();
        if (reader != null && reader.mFile != null) {
            dt.setSourceFile(reader.mFile.getAbsolutePath());
        }
        return dt;
    }

    protected String formatUpdPartitionName(String updPartitionName) {
        return String.format("UPDPartition-%s", updPartitionName);
    }

    protected Substrate createSubstrate(String name) {
        Substrate s = Substrate.create((Db)this.mDb, (String)name, (Substrate.getSubstrate((Db)this.mDb, (String)name) != null ? 1 : 0) != 0);
        this.mCreatedSubstrates.add(s);
        return s;
    }

    public class LinkedVertexListParser
    implements UpdPropertyParser.Parser {
        @Override
        public Object parse(UpdPropertyParser.ObjectValueIterator vals) throws UpdReader.InvalidDataException {
            int count = Integer.parseInt(vals.next());
            ArrayList<HashMap<String, Object>> a = new ArrayList<HashMap<String, Object>>(count);
            for (int i = 0; i < count; ++i) {
                a.add(this.parseVertex(vals));
            }
            return a;
        }

        protected HashMap<String, Object> parseVertex(UpdPropertyParser.ObjectValueIterator ovi) throws UpdReader.InvalidDataException {
            HashMap<String, Object> v = new HashMap<String, Object>();
            String netSpec = ovi.next();
            v.put(netSpec, ovi.next());
            v.put("padStackOrLayer", ovi.next());
            v.put("loc", UpdToDbProcessor.this.parseCoordinate.parse(ovi));
            v.put("layer1Name", ovi.next());
            v.put("layer2Name", ovi.next());
            int type = Integer.parseInt(ovi.next());
            v.put("start", 0 != Integer.parseInt(ovi.next()));
            v.put("end", 0 != Integer.parseInt(ovi.next()));
            v.put("endGeom", 0 != Integer.parseInt(ovi.next()));
            v.put("round", 0 != Integer.parseInt(ovi.next()));
            v.put("hasRot", 0 != Integer.parseInt(ovi.next()));
            v.put("isBF", 0 != Integer.parseInt(ovi.next()));
            v.put("wireUse", Integer.parseInt(ovi.next()));
            v.put("isTaper", 0 != Integer.parseInt(ovi.next()));
            v.put("isArc", 0 != Integer.parseInt(ovi.next()));
            v.put("isDisk", 0 != Integer.parseInt(ovi.next()));
            v.put("startsSnowman", 0 != Integer.parseInt(ovi.next()));
            v.put("isHD", 0 != Integer.parseInt(ovi.next()));
            v.put("isTransPt", 0 != Integer.parseInt(ovi.next()));
            v.put("radius", UpdToDbProcessor.this.updUser2Db(ovi.next()));
            v.put("width", UpdToDbProcessor.this.updUser2Db(ovi.next()));
            v.put("angle", Double.parseDouble(ovi.next()));
            v.put("subnet", Integer.parseInt(ovi.next()));
            boolean extraData = false;
            if (0 != (type & _LV_EXTRADATAFLAG)) {
                type ^= _LV_EXTRADATAFLAG;
                extraData = true;
            }
            v.put("type", type);
            if (extraData) {
                int extraDataCount = Integer.parseInt(ovi.next());
                HashMap<String, Object> extraDataSet = new HashMap<String, Object>(extraDataCount);
                block5: for (int i = 0; i < extraDataCount; ++i) {
                    String edKey = ovi.next();
                    int edType = Integer.parseInt(ovi.next());
                    String edVal = ovi.next();
                    switch (LV_EXTRADATA_TYPE.getByFileVal(edType)) {
                        case EDT_INT: {
                            long val = Long.parseLong(edVal);
                            extraDataSet.put(edKey, val);
                            continue block5;
                        }
                        case EDT_DBL: {
                            double val = Double.parseDouble(edVal);
                            extraDataSet.put(edKey, val);
                            continue block5;
                        }
                        case EDT_STR: {
                            String val = edVal;
                            extraDataSet.put(edKey, val);
                            continue block5;
                        }
                        default: {
                            assert (false);
                            continue block5;
                        }
                    }
                }
                v.put("extra", extraDataSet);
            }
            return v;
        }
    }

    public static enum LV_EXTRADATA_TYPE {
        EDT_UNDEF(-1),
        EDT_INT(0),
        EDT_DBL(1),
        EDT_STR(2);

        protected int mFileVal;

        private LV_EXTRADATA_TYPE(int fileVal) {
            this.mFileVal = fileVal;
        }

        public int getFileVal() {
            return this.mFileVal;
        }

        public static LV_EXTRADATA_TYPE getByFileVal(int fileVal) {
            return LV_EXTRADATA_TYPE.values()[fileVal + 1];
        }
    }

    public class DesignResolutionParser
    implements UpdPropertyParser.Parser {
        @Override
        public Object parse(UpdPropertyParser.ObjectValueIterator vals) {
            LinkedList<String> res = new LinkedList<String>();
            while (vals.hasNext()) {
                String s = vals.next();
                res.add(s);
            }
            return res;
        }
    }

    public class ArrayIntegerParser
    implements UpdPropertyParser.Parser {
        @Override
        public Object parse(UpdPropertyParser.ObjectValueIterator vals) {
            int count = Integer.parseInt(vals.next());
            int[] a = new int[count];
            for (int i = 0; i < count; ++i) {
                a[i] = Integer.parseInt(vals.next());
            }
            return a;
        }
    }

    public class GeometryParser
    implements UpdPropertyParser.Parser {
        @Override
        public Object parse(UpdPropertyParser.ObjectValueIterator vals) throws UpdReader.InvalidDataException {
            if (!vals.hasNext()) {
                assert (false) : "No type specified during geometry read.";
                ALog.logError((String)"No type specified during geometry read.");
                throw new UpdReader.InvalidDataException();
            }
            String gType = vals.next();
            if (gType.equals("rect")) {
                return new ARect(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
            }
            if (gType.equals("circle")) {
                return new ACircle(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
            }
            if (gType.equals("line")) {
                return new ALine(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
            }
            if (gType.equals("arc")) {
                if (!UpdToDbProcessor.this.mArcWarningIssued) {
                    ALog.logWarn((String)"The UPD design contains arc shapes that are not currently supported, they are being converted to standard paths.");
                    UpdToDbProcessor.this.mArcWarningIssued = true;
                }
                APath p = new APath();
                for (int i = 0; i < 3; ++i) {
                    p.addPoint(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
                }
                long w1 = UpdToDbProcessor.this.updUser2Db(vals.next());
                long w2 = UpdToDbProcessor.this.updUser2Db(vals.next());
                long w = Math.round((Math.abs((double)w1) + Math.abs((double)w2)) / 2.0);
                p.setWidth(w);
                return p;
            }
            if (gType.equals("arcpath")) {
                if (!UpdToDbProcessor.this.mArcPathWarningIssued) {
                    ALog.logWarn((String)"The UPD design contains arcpath shapes that are not currently supported, they are being converted to standard paths.");
                    UpdToDbProcessor.this.mArcPathWarningIssued = true;
                }
                APath p = new APath();
                while (UpdToDbProcessor.this.hasNextNumber(vals)) {
                    int f;
                    p.addPoint(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
                    long w = UpdToDbProcessor.this.updUser2Db(vals.next());
                    if (p.getPointCount() == 1) {
                        p.setWidth(w);
                    }
                    if (((f = Integer.parseInt(vals.next())) & 2) == 0) continue;
                    vals.next();
                }
                return p;
            }
            if (gType.equals("path")) {
                APath p = new APath();
                p.setWidth(UpdToDbProcessor.this.updUser2Db(vals.next()));
                while (UpdToDbProcessor.this.hasNextNumber(vals)) {
                    p.addPoint(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
                }
                return p;
            }
            if (gType.equals("path2")) {
                APath p = new APath();
                vals.next();
                vals.next();
                vals.next();
                p.setWidth(UpdToDbProcessor.this.updUser2Db(vals.next()));
                while (UpdToDbProcessor.this.hasNextNumber(vals)) {
                    p.addPoint(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
                }
                return p;
            }
            if (gType.equals("strokedtext")) {
                for (int i = 0; i < 10; ++i) {
                    vals.next();
                }
                return null;
            }
            if (gType.equals("polygon")) {
                APolygon p = new APolygon();
                while (UpdToDbProcessor.this.hasNextNumber(vals)) {
                    p.addPoint(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
                }
                return p;
            }
            if (gType.equals("polygon_nbr")) {
                APolygon p = new APolygon();
                long v = Long.parseLong(vals.next());
                int i = 0;
                while ((long)i < v) {
                    p.addPoint(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
                    ++i;
                }
                return p;
            }
            if (gType.equals("polyline")) {
                APath p = new APath();
                while (UpdToDbProcessor.this.hasNextNumber(vals)) {
                    p.addPoint(UpdToDbProcessor.this.updUser2Db(vals.next()), UpdToDbProcessor.this.updUser2Db(vals.next()));
                }
                return p;
            }
            if (gType.equals("complex")) {
                long children = Long.parseLong(vals.next());
                boolean closed = Boolean.parseBoolean(vals.next());
                if (closed) {
                    AOutlineGeom outline = new AOutlineGeom();
                    int i = 0;
                    while ((long)i < children) {
                        AGeom child = (AGeom)this.parse(vals);
                        outline.addSegment(child);
                        ++i;
                    }
                    return outline;
                }
                ACompositeGeom c = new ACompositeGeom();
                int i = 0;
                while ((long)i < children) {
                    AGeom child = (AGeom)this.parse(vals);
                    c.addChild(child);
                    ++i;
                }
                return c;
            }
            String msg = String.format("Invalid geometry type '%s' during geometry read.", gType);
            ALog.logError((String)msg);
            assert (false) : msg;
            throw new UpdReader.InvalidDataException();
        }
    }

    public class RectagleParser
    implements UpdPropertyParser.Parser {
        @Override
        public Object parse(UpdPropertyParser.ObjectValueIterator vals) {
            long x1 = UpdToDbProcessor.this.updUser2Db(vals.next());
            long y1 = UpdToDbProcessor.this.updUser2Db(vals.next());
            long x2 = UpdToDbProcessor.this.updUser2Db(vals.next());
            long y2 = UpdToDbProcessor.this.updUser2Db(vals.next());
            return new ARect(x1, y1, x2, y2);
        }
    }

    public class CoordinateParser
    implements UpdPropertyParser.Parser {
        @Override
        public Object parse(UpdPropertyParser.ObjectValueIterator vals) {
            long x = UpdToDbProcessor.this.updUser2Db(vals.next());
            long y = UpdToDbProcessor.this.updUser2Db(vals.next());
            return new APoint2D(x, y);
        }
    }

    protected static class ObjectTracker {
        protected String mObjType;
        protected DbObject mDbo;
        protected ObjectTracker mParent;
        protected static ObjectTracker NoParent = new ObjectTracker(null, null, null){

            @Override
            public Object getParent() {
                return this;
            }

            @Override
            public String toString() {
                return "None";
            }
        };

        public ObjectTracker(String objType, DbObject dbo, ObjectTracker parent) {
            this.mObjType = objType != null ? objType : "";
            this.mDbo = dbo;
            this.mParent = parent != null ? parent : NoParent;
        }

        public String getObjType() {
            return this.mObjType;
        }

        public DbObject getDbo() {
            return this.mDbo;
        }

        public Object getParent() {
            return this.mParent;
        }

        public DbObject getParentDbo() {
            return this.mParent == NoParent ? null : this.mParent.getParentDbo();
        }

        public String toString() {
            String parentDesc = this.mParent == NoParent ? "" : ", " + this.mParent.toString();
            return String.format("'%s'%s", this.mObjType, parentDesc);
        }
    }
}

