/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.updio;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AggregateIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.NestedIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AArc;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.ContactPadFactory;
import com.sigrity.orbit.updio.UpdEnums;
import com.sigrity.orbit.updio.UpdIO;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.filechooser.FileFilter;

public class UpdWriter {
    protected File mFile;
    protected Db mDb;
    protected HashSet<DevicePath> mFilterPaths = null;
    protected boolean mFlatDie = false;
    protected boolean mFlatBondFingers = false;
    protected boolean mFlatNets = false;
    protected boolean mIgnoreUnusedDieLayers = false;
    protected LinkedList<Layer> mLayers = null;
    protected boolean mFragmentFile = false;
    protected Design mDesign;
    protected Unit mUnit;
    protected BufferedOutputStream mOutStream;
    protected HashMap<PadTemplate, HashSet<Layer>> mPadTemplateAddWireBondLayer = new HashMap();
    protected HashMultimap<Personality, String> mNetPersonalities2Nets = HashMultimap.create();
    protected HashMultimap<Personality, String> mPinPersonalities2Pins = HashMultimap.create();
    protected BiMap<Net, String> mNetNames = null;
    protected static final Set<DeviceTemplate.Type> SubstrateTypes = AUtil.hashSet((Object[])new DeviceTemplate.Type[]{DeviceTemplate.Type.BOARD, DeviceTemplate.Type.INTERPOSER, DeviceTemplate.Type.PACKAGE, DeviceTemplate.Type.PACKAGEDDIE, DeviceTemplate.Type.DIE});
    protected BiMap<Integer, String> mStringTable = HashBiMap.create();

    public static boolean save(Db db, String filePath) {
        File f = new File(filePath);
        UpdWriter uw = new UpdWriter(db, f);
        return uw.write();
    }

    public static boolean exportCurDbToUpd() {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = new AFileFilter("upd", "UPD Files");
        fc.setFileFilter((FileFilter)filter);
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
            path = (String)path + ".upd";
        }
        return (Boolean)Cp.exec((String)"com.sigrity.orbit.updio.UpdWriter.save(curDb(), %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
    }

    public UpdWriter(Db db, File f) {
        this.mFile = f;
        this.mDb = db;
    }

    public UpdWriter(String path) {
        this(OrbitIO.getCurDb(), new File(path));
    }

    public void setFlattenDie(boolean b) {
        this.mFlatDie = b;
    }

    public void setFlattenBondFingers(boolean b) {
        this.mFlatBondFingers = b;
    }

    public void setFlattenNets(boolean b) {
        this.mFlatNets = b;
    }

    public void setIgnoreUnusedDieLayers(boolean b) {
        this.mIgnoreUnusedDieLayers = b;
    }

    public void setFilterPaths(Iterator<DevicePath> pathsToWrite) {
        if (pathsToWrite == null) {
            this.mFilterPaths = null;
            return;
        }
        this.mFilterPaths = new HashSet();
        AUtil.addAll(this.mFilterPaths, pathsToWrite);
    }

    public void setFilterPaths(String[] pathsToWrite) {
        if (pathsToWrite == null) {
            this.mFilterPaths = null;
            return;
        }
        this.mFilterPaths = new HashSet();
        for (String p : pathsToWrite) {
            DevicePath dp = DevicePath.fromString((Db)this.mDb, (String)p);
            if (dp == null) {
                ALog.logError((String)"'%s' is not a valid DevicePath, it is being ignored.", (Object[])new Object[]{p});
                continue;
            }
            this.mFilterPaths.add(dp);
        }
    }

    public boolean include(DevicePath p) {
        if (p.isEmpty()) {
            return true;
        }
        if (this.mFlatDie && this.isOnFlatDie(p)) {
            return false;
        }
        if (this.mFlatBondFingers && p.getLast().getTemplate().getType() == DeviceTemplate.Type.BONDFINGER) {
            return false;
        }
        if (this.mFilterPaths == null) {
            return true;
        }
        return this.mFilterPaths.contains(p);
    }

    protected boolean isOnDie(DevicePath p, DeviceTemplate dieTemplate) {
        for (int i = p.size() - 1; i >= 0; --i) {
            Device d = p.get(i);
            if (d.getTemplate() == dieTemplate) {
                return true;
            }
            if (d.getTemplate().getType() != DeviceTemplate.Type.DIE) continue;
            return false;
        }
        return false;
    }

    protected int findDie(DevicePath p) {
        for (int i = p.size() - 1; i >= 0; --i) {
            Device d = p.get(i);
            if (d.getTemplate().getType() != DeviceTemplate.Type.DIE) continue;
            return i;
        }
        return -1;
    }

    protected boolean isOnFlatDie(DevicePath p) {
        if (p == null || p.isEmpty()) {
            return false;
        }
        if (p.getLast().getTemplate().getType() == DeviceTemplate.Type.DIE) {
            return false;
        }
        for (int i = p.size() - 1; i >= 0; --i) {
            Device d = p.get(i);
            if (d.getTemplate().getType() != DeviceTemplate.Type.DIE) continue;
            return this.include(d.getTemplate());
        }
        return false;
    }

    public boolean include(DeviceTemplate t) {
        for (DevicePath p : t.getHierarchicalInstances()) {
            if (!this.include(p)) continue;
            return true;
        }
        return false;
    }

    public boolean include(Substrate s) {
        if (s == null) {
            return false;
        }
        for (DevicePath p : s.getInstancePaths()) {
            if (!this.include(p)) continue;
            return true;
        }
        return false;
    }

    public boolean include(Layer l) {
        Substrate s = l.getSubstrate();
        if (!this.include(s)) {
            return false;
        }
        boolean isDie = false;
        for (DeviceTemplate dt : s.getDeviceTemplates()) {
            if (dt.getType() != DeviceTemplate.Type.DIE) continue;
            isDie = true;
            break;
        }
        if (!this.mIgnoreUnusedDieLayers || !isDie) {
            return true;
        }
        if (l.getRelatedCount("Metal-layer", false) > 0) {
            return true;
        }
        for (LayerShape ls : l.getLayerShapes()) {
            DbObject owner = ls.getOwner();
            if (!(owner instanceof PadTemplate)) continue;
            PadTemplate pt = (PadTemplate)owner;
            for (PortTemplate port : pt.getPortTemplates()) {
                PinTemplate pinTemplate = port.getPinTemplate();
                if (pinTemplate == null) continue;
                switch (pinTemplate.getType()) {
                    case BALLPAD: 
                    case BONDFINGERPAD: 
                    case BUMPPAD: 
                    case CONTACT: 
                    case WIREBONDPAD: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean write() {
        this.mDesign = Design.getDesign((Db)this.mDb);
        if (this.mDesign == null) {
            ALog.logError((String)"There is no Design in the database.");
            return false;
        }
        this.mUnit = this.mDesign.getUnit();
        if (this.mUnit == null) {
            ALog.logError((String)"Unable to determine Design units.");
            return false;
        }
        try (FileOutputStream fos = this.mFragmentFile ? null : new FileOutputStream(this.mFile);){
            if (!this.mFragmentFile) {
                this.mOutStream = new BufferedOutputStream(fos);
                this.writeInteger(0x77777777L);
            }
            this.openParen();
            this.writeFileHeader(this.mFragmentFile);
            if (!this.mFragmentFile) {
                this.writeDb();
            } else {
                ALog.logError((String)"Writing fragment files is not currently supported.");
            }
            this.closeParen();
            if (!this.mFragmentFile) {
                this.writeEOF();
                this.mOutStream.close();
            }
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Error opening output file '%s'.", (Object[])new Object[]{this.mFile.getPath()});
            return false;
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error writing to output file '%s'.", (Object[])new Object[]{this.mFile.getPath()});
            return false;
        }
        return true;
    }

    protected void writeDb() throws IOException {
        this.openParen();
        this.writeIdentifier("design");
        this.openParen();
        this.writeIdentifier("resolution");
        this.writeIdentifier("dbu");
        this.writeInteger(2540000L);
        this.writeIdentifier("quote");
        this.writeIdentifier("'");
        this.writeIdentifier("length");
        this.writeIdentifier("micron");
        this.writeInteger(2L);
        this.closeParen();
        this.openParen();
        this.writeIdentifier("settings");
        this.writeIdentifier("update_substrate_from_package");
        this.writeInteger(0L);
        this.writeIdentifier("check_comp_clearance");
        this.writeInteger(0L);
        this.writeIdentifier("check_cc_rules");
        this.writeInteger(0L);
        this.closeParen();
        Date now = new Date();
        String fpath = this.mDb.getFile() == null ? "[Unsaved Design]" : this.mDb.getFile().getPath();
        String noteName = new SimpleDateFormat("yyyyMMdd HHmmss-0").format(now);
        String noteText = String.format("OrbitIO design (%s) exported at %s from %s version %s (%s) by %s", fpath, new SimpleDateFormat("yyyyMMdd-HHmmssz").format(now), OrbitIO.getApp().getName(), ABuildInfo.getVersion(), ABuildInfo.getTimestamp(), System.getProperty("user.name"));
        String noteTitle = "OrbitIO Export Information";
        noteText = noteText.replace("\\", "\\092");
        noteText = noteText.replace("\n", "\\010");
        this.openParen();
        this.writeIdentifiers("Def", "note");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "Text", "Title");
        this.closeParen();
        this.openParen();
        this.writeIdentifiers(noteName, noteText, noteTitle);
        this.openParen();
        this.writeIdentifiers("Ref", "partition", "Design");
        this.closeParen();
        this.closeParen();
        this.closeParen();
        this.writeWires();
        this.writeMetals();
        this.writePartitions();
        this.writePins();
        this.writePinClasses();
        this.writePadstacks();
        this.writePackages();
        this.writeNets();
        this.writeNetClasses();
        this.writeLayers();
        this.writeComponents();
        this.closeParen();
    }

    protected String getNetName(DevicePath path, Net net) {
        if (!this.mFlatNets) {
            return path.toString() + "/" + net.getName();
        }
        if (this.mNetNames == null) {
            this.mNetNames = HashBiMap.create();
            AggregateIterator paths = new AggregateIterator((Iterator)ASingletonItr.create((Object)new DevicePath((DeviceTemplate)this.mDesign)), (Iterator)this.mDesign.getDescendantDevices());
            for (DevicePath curPath : paths) {
                if (!this.include(curPath)) continue;
                for (Net curNet : curPath.getDeviceTemplate().getNets()) {
                    Net topMost = NetMap.getTopmostNet((Net)curNet, (DevicePath)curPath);
                    if (this.mNetNames.containsKey((Object)topMost)) continue;
                    String name = topMost.getName();
                    if (this.mNetNames.containsValue((Object)name)) {
                        DevicePath topNetPath = curPath.pathTo(topMost.getDeviceTemplate());
                        name = String.format("%s@%s", name, topNetPath.toString());
                        int i = 0;
                        while (this.mNetNames.containsValue((Object)name)) {
                            name = String.format("%s_%d", topMost.getName(), i);
                            ++i;
                        }
                    }
                    this.mNetNames.put((Object)topMost, (Object)name);
                }
            }
        }
        return (String)this.mNetNames.get((Object)NetMap.getTopmostNet((Net)net, (DevicePath)path));
    }

    protected String getNetClassName(Personality netPers) {
        Substrate substrate = netPers.getOwner().getSubstrate();
        String substrateName = substrate == null ? "" : substrate.getName() + ":";
        return substrateName + netPers.getName();
    }

    protected String getPinName(DevicePath path, PinTemplate port) {
        if (this.mFlatDie && this.isOnFlatDie(path)) {
            int idxDie = this.findDie(path);
            assert (idxDie >= 0);
            DevicePath diePath = path.getSubPath(0, idxDie + 1);
            DevicePath flattened = path.getSubPath(idxDie + 1, path.size());
            return String.format("%s-%s/%s", diePath.toString(), flattened.toString().substring(2), port.getKeyStr());
        }
        return String.format("%s-%s", path.toString(), port.getKeyStr());
    }

    protected String getPinClassName(Personality pinPers) {
        Substrate substrate = pinPers.getOwner().getSubstrate();
        String substrateName = substrate == null ? "" : substrate.getName() + ":";
        return substrateName + pinPers.getName();
    }

    protected void writeWires() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "wiring");
        this.openParen();
        this.openParen();
        this.writeIdentifiers("Def", "wire");
        this.openParen();
        this.writeIdentifiers("Gfmt", "net_num", "use");
        this.closeParen();
        for (DevicePath path : this.mDesign.getDescendantDevices()) {
            if (!this.include(path)) continue;
            for (Wire wire : path.getLast().getTemplate().getWires()) {
                PadTemplate bpt;
                PinInstance bondPad;
                PinInstance bondFinger;
                Net net = wire.getNet();
                Layer layer = wire.getLayer();
                APath wirePath = wire.getPath();
                APath worldPath = wirePath.transform(path.getTransform());
                this.openParen();
                this.writeIdentifier(net.isUnused() ? "" : this.getNetName(path, net));
                if (wire.getType() == Wire.Type.BOND) {
                    this.writeIdentifier(UpdEnums.WIRE_USE.wu_wirebond.name);
                } else {
                    this.writeIdentifier(UpdEnums.WIRE_USE.wu_normal.name);
                }
                this.openParen();
                this.writeIdentifiers("Def", "shape");
                this.openParen();
                this.writeGeom((AGeom)worldPath);
                this.openParen();
                this.writeIdentifiers("Ref", "layer");
                this.writeIdentifier(UpdWriter.getLayerName(layer));
                this.closeParen();
                this.closeParen();
                this.closeParen();
                this.closeParen();
                if (!this.mFlatBondFingers || (bondFinger = wire.getConnectedPortOfType(path.getLast(), PinTemplate.Type.BONDFINGERPAD)) == null) continue;
                PadTemplate fpt = bondFinger.getPadTemplate();
                if (fpt != null) {
                    HashSet<Object> layers = this.mPadTemplateAddWireBondLayer.get(fpt);
                    if (layers == null) {
                        layers = new HashSet();
                        this.mPadTemplateAddWireBondLayer.put(fpt, layers);
                    }
                    layers.add(layer);
                }
                if ((bondPad = wire.getOtherConnectedPort(path.getLast(), bondFinger)) == null || (bpt = bondPad.getPadTemplate()) == null) continue;
                HashSet<Object> layers = this.mPadTemplateAddWireBondLayer.get(bpt);
                if (layers == null) {
                    layers = new HashSet();
                    this.mPadTemplateAddWireBondLayer.put(bpt, layers);
                }
                layers.add(layer);
            }
        }
        this.closeParen();
        if (this.mFlatBondFingers) {
            this.writeFlatBondFingers();
        }
        this.closeParen();
        this.closeParen();
    }

    protected void writeMetals() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "smartmetal");
        this.openParen();
        this.writeIdentifiers("Gfmt", "metalType", "type", "pourStyle");
        this.closeParen();
        for (DevicePath path : this.mDesign.getDescendantDevices()) {
            DeviceTemplate dt = path.getDeviceTemplate();
            if (dt == null) continue;
            for (Metal m : dt.getMetals()) {
                this.openParen();
                this.writeIdentifier("instance");
                this.writeIdentifier("solid");
                this.writeIdentifier("simple");
                this.openParen();
                this.writeIdentifiers("Def", "shape");
                this.openParen();
                this.writeGeom(m.getGeom());
                this.openParen();
                this.writeIdentifiers("Ref", "layer");
                this.writeIdentifier(UpdWriter.getLayerName(m.getLayer()));
                this.closeParen();
                this.closeParen();
                this.closeParen();
                this.openParen();
                this.writeIdentifiers("Ref", "net");
                this.writeIdentifier(this.getNetName(path, m.getNet()));
                this.closeParen();
                this.closeParen();
            }
        }
        this.closeParen();
    }

    protected void writePadstacks() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "padstack");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "Absolute");
        this.closeParen();
        for (PadTemplate pt : this.mDb.getObjects(PadTemplate.class)) {
            this.openParen();
            this.writeIdentifier(pt.getKeyStr());
            this.writeInteger(0L);
            this.openParen();
            this.writeIdentifiers("Def", "pattern");
            this.openParen();
            this.writeIdentifiers("Gfmt", "Dorigin");
            this.closeParen();
            for (LayerShape ls : pt.getLayerShapes()) {
                this.writePadLayerShape(ls.getGeom(), ls.getLayer());
            }
            if (this.mPadTemplateAddWireBondLayer.containsKey(pt)) {
                for (Layer l : this.mPadTemplateAddWireBondLayer.get(pt)) {
                    this.writePadLayerShape((AGeom)new ACircle(0L, 0L, 1L), l);
                }
                this.mPadTemplateAddWireBondLayer.remove(pt);
            }
            this.closeParen();
            this.closeParen();
        }
        this.closeParen();
    }

    protected void writePadLayerShape(AGeom geom, Layer layer) throws IOException {
        this.openParen();
        this.writeIntegers(0L, 0L);
        this.openParen();
        this.writeIdentifiers("Def", "shape");
        this.openParen();
        this.writeIdentifiers("Gfmt", "IsPad");
        this.closeParen();
        this.openParen();
        this.writeInteger(1L);
        this.writeGeom(geom);
        this.openParen();
        this.writeIdentifiers("Ref", "layer", UpdWriter.getLayerName(layer));
        this.closeParen();
        this.closeParen();
        this.closeParen();
        this.openParen();
        this.writeIdentifiers("Ref", "layer", UpdWriter.getLayerName(layer));
        this.closeParen();
        this.closeParen();
    }

    protected void writePins() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "pin");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "IsDiePad", "IsBumpPad", "IsBallPad", "IsBondFinger");
        this.closeParen();
        for (DevicePath path : this.mDesign.getDescendantDevices()) {
            if (!this.mFlatDie ? !this.include(path) : !this.include(path) && !this.isOnFlatDie(path)) continue;
            block8: for (PinInstance port : path.getLast().getPins()) {
                PinTemplate.Type ptype = port.getPinTemplate().getType();
                int isDiePad = 0;
                int isBumpPad = 0;
                int isBallPad = 0;
                int isBondFinger = 0;
                switch (ptype) {
                    case WIREBONDPAD: {
                        isDiePad = 1;
                        break;
                    }
                    case BUMPPAD: 
                    case CONTACT: {
                        isBumpPad = 1;
                        break;
                    }
                    case BALLPAD: {
                        isBallPad = 1;
                        break;
                    }
                    case BONDFINGERPAD: {
                        if (this.mFlatBondFingers) continue block8;
                        isBondFinger = 1;
                        break;
                    }
                    case WIREEND: {
                        continue block8;
                    }
                }
                this.openParen();
                String pinName = this.getPinName(path, port.getPinTemplate());
                this.writeIdentifier(pinName);
                this.writeInteger(isDiePad);
                this.writeInteger(isBumpPad);
                this.writeInteger(isBallPad);
                this.writeInteger(isBondFinger);
                this.closeParen();
                Personality pinPersonality = port.getPersonality();
                if (pinPersonality == null) continue;
                this.mPinPersonalities2Pins.put((Object)pinPersonality, (Object)pinName);
            }
        }
        this.closeParen();
    }

    protected void writePinClasses() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "pinclass");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "Color");
        this.closeParen();
        for (Personality pp : this.mPinPersonalities2Pins.keySet()) {
            this.openParen();
            String pinClassName = this.getPinClassName(pp);
            String pinClassColor = UpdWriter.formatColor(pp.getColor());
            this.writeIdentifiers(pinClassName, pinClassColor);
            this.openParen();
            this.writeIdentifiers("Ref", "pin");
            for (String pinName : this.mPinPersonalities2Pins.get((Object)pp)) {
                this.writeIdentifier(pinName);
            }
            this.closeParen();
            this.closeParen();
        }
        this.closeParen();
    }

    protected void writeFlatBondFingers() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "pin");
        this.openParen();
        this.writeIdentifiers("Gfmt", "IsBondFinger", "p_type", "x", "y", "ViaRot", "net_num", "padstack");
        this.closeParen();
        for (DevicePath path : this.mDesign.getDescendantDevices()) {
            DevicePath testPath = new DevicePath(path);
            if (path.getLast().getDeviceType() == DeviceTemplate.Type.BONDFINGER) {
                testPath = path.getParent();
            }
            if (!this.mFlatDie ? !this.include(testPath) : !this.include(testPath) && !this.isOnFlatDie(testPath)) continue;
            Device device = path.getLast();
            for (PinInstance port : device.getPins()) {
                if (port.getPinTemplate().getType() != PinTemplate.Type.BONDFINGERPAD) continue;
                APoint2D loc = port.getLoc();
                loc = loc.transform(path.getTransform());
                float rot = 360.0f - AGeomUtil.normDeg((float)(path.getRot() + port.getRotate()));
                PadTemplate pt = port.getPinTemplate().getPadTemplate();
                this.openParen();
                this.writeInteger(1L);
                this.writeIdentifier("via");
                this.writeDbu(loc.getX());
                this.writeDbu(loc.getY());
                this.writeReal(rot);
                this.writeIdentifier(this.getNetName(path, port.getNet()));
                this.writeIdentifier(pt.getKeyStr());
                this.closeParen();
            }
        }
        this.closeParen();
    }

    protected boolean writeNetPinRef(PinTemplate dtp) {
        switch (dtp.getType()) {
            case WIREEND: 
            case TOPOLOGYPOINT: {
                return false;
            }
            case BONDFINGERPAD: {
                if (!this.mFlatBondFingers) break;
                return false;
            }
        }
        return true;
    }

    protected void writeNets() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "net");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "defined", "net_num", "IsOrigNet", "IsSuperNet");
        this.closeParen();
        HashBiMap superNets = HashBiMap.create();
        int netNum = 2;
        for (Net net : this.mDb.getObjects(Net.class)) {
            if (net.isUnused()) continue;
            DeviceTemplate dt = net.getDeviceTemplate();
            if (dt == null) {
                dt = this.mDesign;
            }
            ASingletonItr instanceItr = dt == this.mDesign ? new ASingletonItr((Object)Design.getDesignPath((Db)this.mDb)) : dt.getHierarchicalInstances();
            for (DevicePath path : instanceItr) {
                if (!this.include(path)) continue;
                String netName = this.getNetName(path, net);
                String superNetName = null;
                Net topMost = NetMap.getTopmostNet((Net)net, (DevicePath)path);
                if (this.mFlatNets && topMost != net) continue;
                if (!this.mFlatNets && (topMost != net || NetMap.getChildNets((Net)net).hasNext())) {
                    superNetName = (String)superNets.get((Object)topMost);
                    if (superNetName == null) {
                        superNetName = String.format("[S]%s", topMost.getName());
                        int i = 1;
                        while (superNets.containsValue((Object)superNetName)) {
                            superNetName = String.format("Super%s[%d]", topMost.getName(), i);
                            ++i;
                        }
                        superNets.put((Object)topMost, (Object)superNetName);
                    }
                } else {
                    topMost = null;
                }
                this.openParen();
                this.writeIdentifier(netName);
                this.writeInteger(1L);
                this.writeInteger(netNum++);
                this.writeInteger(topMost == null ? 0L : 1L);
                this.writeInteger(0L);
                Personality netPersonality = net.getPersonality();
                if (netPersonality != null) {
                    this.mNetPersonalities2Nets.put((Object)netPersonality, (Object)netName);
                }
                Object descendantPorts = !this.mFlatNets ? AEmptyItr.create() : new NestedIterator<HierInst<Net>, HierInst<PinTemplate>>((Iterator)NetMap.getDescendantNetsWithPaths((DevicePath)path, (Net)net)){

                    public Iterator<HierInst<PinTemplate>> getLowerIterator(final HierInst<Net> upper) {
                        return new ProcessingIterator<PinTemplate, HierInst<PinTemplate>>((Iterator)((Net)upper.second).getPins()){

                            protected HierInst<PinTemplate> process(PinTemplate port) {
                                return new HierInst((DevicePath)upper.first, (DbObject)port);
                            }
                        };
                    }
                };
                IterableIterator pins = net.getPins();
                if (pins.iterator().hasNext() || descendantPorts.hasNext()) {
                    this.openParen();
                    if (topMost == null) {
                        this.writeIdentifiers("Ref", "pin");
                        for (PinTemplate port : pins) {
                            if (!this.writeNetPinRef(port)) continue;
                            this.writeIdentifier(this.getPinName(path, port));
                        }
                        for (HierInst hport : descendantPorts) {
                            DevicePath p = hport.getPath();
                            PinTemplate port = (PinTemplate)hport.getDbObject();
                            if (!this.writeNetPinRef(port)) continue;
                            this.writeIdentifier(this.getPinName(p, port));
                        }
                    } else {
                        this.writeIdentifier("Ref");
                        this.openParen();
                        this.writeIdentifiers("Rel", "orignet_pin");
                        this.closeParen();
                        this.writeIdentifier("pin");
                        for (PinTemplate port : pins) {
                            if (!this.writeNetPinRef(port)) continue;
                            this.writeIdentifier(this.getPinName(path, port));
                        }
                        this.closeParen();
                        this.openParen();
                        this.writeIdentifier("Ref");
                        this.openParen();
                        this.writeIdentifiers("Rel", "net_snet");
                        this.closeParen();
                        this.writeIdentifiers("net", superNetName);
                    }
                    this.closeParen();
                }
                this.closeParen();
            }
        }
        for (Net net : superNets.keySet()) {
            String netName = (String)superNets.get((Object)net);
            this.openParen();
            this.writeIdentifier(netName);
            this.writeInteger(1L);
            this.writeInteger(netNum++);
            this.writeInteger(0L);
            this.writeInteger(1L);
            IterableIterator ports = NetMap.getConnectedPorts((Net)net, (DevicePath)null);
            if (ports.iterator().hasNext()) {
                this.openParen();
                this.writeIdentifiers("Ref", "pin");
                for (PinInstance port : ports) {
                    PinTemplate.Type type = port.getPinTemplate().getType();
                    if (type == PinTemplate.Type.TOPOLOGYPOINT || type == PinTemplate.Type.WIREEND) continue;
                    for (DevicePath path : port.getDevice().getHierarchicalInstances()) {
                        if (!this.include(path)) continue;
                        this.writeIdentifier(this.getPinName(path, port.getPinTemplate()));
                    }
                }
                this.closeParen();
            }
            this.openParen();
            this.writeIdentifier("Ref");
            this.openParen();
            this.writeIdentifiers("Rel", "net_snet");
            this.closeParen();
            this.writeIdentifiers("net", netName);
            this.closeParen();
            this.closeParen();
        }
        this.closeParen();
    }

    protected void writeNetClasses() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "nclass");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "Color");
        this.closeParen();
        for (Personality np : this.mNetPersonalities2Nets.keySet()) {
            this.openParen();
            String nclassName = this.getNetClassName(np);
            String nclassColor = UpdWriter.formatColor(np.getColor());
            this.writeIdentifiers(nclassName, nclassColor);
            this.openParen();
            this.writeIdentifiers("Ref", "net");
            for (String netName : this.mNetPersonalities2Nets.get((Object)np)) {
                this.writeIdentifier(netName);
            }
            this.closeParen();
            this.closeParen();
        }
        this.closeParen();
    }

    protected void writeComponents() throws IOException {
        this.openParen();
        this.writeIdentifier("Def");
        this.writeIdentifier("component");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "DOrigin", "DOriginRelTo", "Rot", "IsPlaced", "Height");
        this.closeParen();
        for (DevicePath path : this.mDesign.getDescendantDevices()) {
            if (!this.include(path)) continue;
            this.writeComponent(path);
        }
        this.closeParen();
    }

    protected void writeComponent(DevicePath path) throws IOException {
        long height;
        this.openParen();
        Device device = path.getLast();
        Substrate substrate = device.getSubstrate();
        DeviceTemplate template = device.getTemplate();
        DeviceTemplate.Type type = template.getType();
        this.writeIdentifier(path.toString());
        APoint2D loc = path.getOrigin();
        this.writeDbus(loc.getX(), loc.getY());
        this.writeIdentifier("origin");
        this.writeRotation(path.getRot());
        this.writeInteger(device.getIsPlaced() ? 1L : 0L);
        boolean hasHeight = SubstrateTypes.contains(type);
        long l = height = hasHeight ? substrate.getHeight() : 0L;
        if (type == DeviceTemplate.Type.CONTACT_DEVICE) {
            boolean exportChildren = false;
            long maxMountedHeight = Long.MIN_VALUE;
            for (Device child : template.getChildren()) {
                if (child.getSubstrate() == substrate) continue;
                if (this.mFilterPaths == null || this.mFilterPaths.contains(path.withChild(child))) {
                    exportChildren = true;
                    break;
                }
                maxMountedHeight = Math.max(maxMountedHeight, child.getSubstrate() == null ? 0L : child.getSubstrate().getHeight());
            }
            if (!exportChildren) {
                Object o = template.getValue(ContactPadFactory.FldName_FromDevice);
                if (o instanceof Device && ((Device)o).getDb() != null) {
                    Device fromDevice = (Device)o;
                    height = fromDevice.getSubstrate().getHeight();
                } else if (maxMountedHeight != Long.MIN_VALUE) {
                    height = maxMountedHeight;
                }
            }
        }
        this.writeDbu(height);
        if (path.getMirror()) {
            this.openParen();
            this.writeIdentifiers("MountingMethodName", "Default_MIRROR");
            this.closeParen();
        }
        this.openParen();
        this.writeIdentifiers("Ref", "package");
        this.writeIdentifier(template.getName());
        this.closeParen();
        this.closeParen();
    }

    protected void writePackages() throws IOException {
        this.openParen();
        this.writeIdentifier("Def");
        this.writeIdentifier("package");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "DefaultMMName", "type");
        this.closeParen();
        for (DeviceTemplate t : this.mDb.getObjects(DeviceTemplate.class)) {
            if (t instanceof Design || !this.include(t)) continue;
            this.writePackage(t);
        }
        this.closeParen();
    }

    protected void writePackage(DeviceTemplate t) throws IOException {
        boolean isDie = false;
        this.openParen();
        this.writeIdentifier(t.getName());
        this.writeIdentifier("Default_TOP");
        switch (t.getType()) {
            case PACKAGE: 
            case PACKAGEDDIE: {
                this.writeIdentifier("other");
                break;
            }
            case DIE: {
                isDie = true;
                this.writeIdentifier("die");
                break;
            }
            case MACRO: 
            case HARDMACRO: 
            case SOFTMACRO: 
            case CORE: {
                this.writeIdentifier("embedded");
                break;
            }
            case CONTACT_DEVICE: {
                DeviceTemplate.Type fromDeviceType = (DeviceTemplate.Type)t.getValue(ContactPadFactory.FldName_FromDeviceType, DeviceTemplate.Type.class);
                if (fromDeviceType == null) break;
                switch (fromDeviceType) {
                    case DIE: 
                    case COVER: 
                    case MACRO: {
                        this.writeIdentifier("die");
                        break;
                    }
                    case PACKAGE: {
                        this.writeIdentifier("other");
                    }
                }
                break;
            }
        }
        this.openParen();
        this.writeIdentifiers("Def", "footprintdef");
        this.openParen();
        this.writeIdentifiers("Gfmt", "MountingMethodName", "Surface", "AlternateBody");
        this.closeParen();
        this.openParen();
        this.writeIdentifiers("Default_TOP", "TOP");
        this.writeShapeData(t.getBounds(true));
        this.openParen();
        this.writeIdentifier("BodyOutlinePolygon");
        this.writeShapeData((AGeom)t.getBounds().toPoly());
        this.closeParen();
        if (t.getPins().hasNext() || this.mFlatDie && isDie) {
            this.openParen();
            this.writeIdentifiers("Def", "footprintdefpin");
            this.openParen();
            this.writeIdentifiers("Gfmt", "DefaultNetName", "IsPin1", "PadstackRot", "Pt", "Type", "UserName", "fcPinType");
            this.closeParen();
            this.writePackagePorts((Iterable<PinTemplate>)t.getPins(), isDie, 0.0f, null, null);
            if (this.mFlatDie && isDie) {
                for (DevicePath p : t.getDescendantDevices()) {
                    if (this.findDie(p) != -1) continue;
                    this.writePackagePorts((Iterable<PinTemplate>)p.getLast().getTemplate().getPins(), true, p.getRot(), p.getTransform(), p);
                }
            }
            this.closeParen();
        }
        this.closeParen();
        this.closeParen();
        this.closeParen();
    }

    protected void writePackagePorts(Iterable<PinTemplate> ports, boolean forDie, float rotation, AffineTransform xform, DevicePath flattenPath) throws IOException {
        block3: for (PinTemplate dtp : ports) {
            if (dtp.getType() == PinTemplate.Type.TOPOLOGYPOINT || dtp.getType() == PinTemplate.Type.WIREEND) continue;
            if (forDie && this.mFlatDie) {
                PinTemplate.Type portType = dtp.getType();
                switch (portType) {
                    case BUMPPAD: 
                    case WIREBONDPAD: {
                        break;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
            Object name = dtp.getKeyStr();
            if (flattenPath != null) {
                name = flattenPath.toString().substring(1) + "/" + (String)name;
            }
            this.openParen();
            this.writeIdentifier("");
            this.writeInteger(dtp.isPin1() ? 1L : 0L);
            float r = dtp.getRotate();
            if (rotation != 0.0f) {
                r = AGeomUtil.normDeg((float)(r + rotation));
            }
            this.writeRotation(r);
            APoint2D pt = dtp.getLoc();
            if (pt == null) {
                pt = new APoint2D();
            }
            if (xform != null) {
                pt = pt.transform(xform);
            }
            this.writeDbu(pt.getX());
            this.writeDbu(pt.getY());
            this.writeInteger(0L);
            this.writeIdentifier((String)name);
            this.writeIdentifier("undefined");
            if (dtp.getPadTemplate() != null) {
                this.openParen();
                this.writeIdentifiers("Ref", "padstack", dtp.getPadTemplate().getKeyStr());
                this.closeParen();
            }
            this.closeParen();
        }
    }

    protected void writeLayers() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "layer");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "IsTop", "IsBottom", "type", "Thickness");
        this.closeParen();
        List<Layer> layers = this.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            Layer l = layers.get(i);
            this.openParen();
            String lName = UpdWriter.getLayerName(l);
            this.writeIdentifier(lName);
            this.writeInteger(0L);
            this.writeInteger(0L);
            String updLayerType = "signal";
            switch (l.getType()) {
                case Jumper: {
                    updLayerType = "jumper";
                    break;
                }
                case Dielectric: {
                    updLayerType = "dielectric";
                    break;
                }
                case Artwork: {
                    updLayerType = "artwork";
                }
            }
            this.writeIdentifier(updLayerType);
            this.writeDbu(l.getHeight());
            this.closeParen();
        }
        this.closeParen();
    }

    public Layer[] getDefaultTopLayers() {
        return new Layer[]{UpdWriter.createDefaultLayer("TopAir", Layer.LayerType.Dielectric, 1371600L), UpdWriter.createDefaultLayer("TopSolderPaste", Layer.LayerType.Artwork, this.mUnit.fromUser(-1.0)), UpdWriter.createDefaultLayer("TopSolderMask", Layer.LayerType.Artwork, this.mUnit.fromUser(-1.0))};
    }

    public Layer[] getDefaultBottomLayers() {
        return new Layer[]{UpdWriter.createDefaultLayer("BottomSolderMask", Layer.LayerType.Artwork, this.mUnit.fromUser(-1.0)), UpdWriter.createDefaultLayer("BottomSolderPaste", Layer.LayerType.Artwork, this.mUnit.fromUser(-1.0)), UpdWriter.createDefaultLayer("BottomAir", Layer.LayerType.Dielectric, 1371600L)};
    }

    public static Layer createDefaultLayer(String name, Layer.LayerType type, long thickness) {
        Layer l = new Layer(null, name);
        l.setType(type);
        l.setHeight(thickness);
        return l;
    }

    public List<Layer> getLayers() {
        if (this.mLayers == null) {
            this.mLayers = new LinkedList();
            for (Layer l : this.mDb.getObjects(Layer.class)) {
                if (!this.include(l)) continue;
                this.mLayers.add(l);
            }
            Collections.sort(this.mLayers);
            Collections.reverse(this.mLayers);
            int i = 0;
            for (Layer l : this.getDefaultTopLayers()) {
                this.mLayers.add(i++, l);
            }
            for (Layer l : this.getDefaultBottomLayers()) {
                this.mLayers.add(l);
            }
        }
        return this.mLayers;
    }

    public static String getLayerName(Layer l) {
        Substrate substrate = l.getSubstrate();
        String substrateName = substrate == null ? "" : substrate.getName() + ":";
        Object name = substrateName + l.getName();
        name = ((String)name).replace(' ', '_');
        return name;
    }

    protected void writePartitions() throws IOException {
        this.openParen();
        this.writeIdentifiers("Def", "partition");
        this.openParen();
        this.writeIdentifiers("Gfmt", "Name", "TopLayerName", "TopSignalLayerName", "BotLayerName", "BotSignalLayerName");
        this.closeParen();
        this.writePartitionDesign();
        this.closeParen();
    }

    protected void writePartitionDesign() throws IOException {
        List<Layer> layers = this.getLayers();
        String topLayerName = UpdWriter.getLayerName(layers.get(0));
        String botLayerName = UpdWriter.getLayerName(layers.get(layers.size() - 1));
        this.openParen();
        this.writeIdentifiers("Design", topLayerName, topLayerName, botLayerName, botLayerName);
        AGeom shape = this.mDesign.getBounds(true);
        if (shape != null) {
            this.openParen();
            this.writeIdentifiers("Def", "shape");
            this.openParen();
            this.writeGeom(shape);
            this.closeParen();
            this.closeParen();
            this.openParen();
            this.writeIdentifier("Def");
            this.openParen();
            this.writeIdentifiers("Rel", "partition_polygon");
            this.closeParen();
            this.writeIdentifier("shape");
            this.openParen();
            this.writeGeom((AGeom)shape.toPoly());
            this.closeParen();
            this.closeParen();
            this.openParen();
            this.writeIdentifiers("Def", "boundary");
            this.openParen();
            this.openParen();
            this.writeIdentifiers("Def", "shape");
            this.openParen();
            this.writeGeom(shape);
            this.closeParen();
            this.closeParen();
            this.closeParen();
            this.closeParen();
        }
        this.openParen();
        this.writeIdentifiers("Ref", "layer");
        for (Layer l : layers) {
            this.writeIdentifier(UpdWriter.getLayerName(l));
        }
        this.closeParen();
        this.closeParen();
    }

    protected void writeGeom(AGeom geom) throws IOException {
        this.openParen();
        this.writeIdentifier("Geom");
        this.writeShapeData(geom);
        this.closeParen();
    }

    protected void writePolyLine(APolygon poly) throws IOException {
        this.openParen();
        this.writeIdentifier("Geom");
        this.writeIdentifier("polyline");
        List pts = poly.getPointList();
        for (int i = 0; i < pts.size() - 1; ++i) {
            APoint2D pt = (APoint2D)pts.get(i);
            this.writeDbu(pt.getX());
            this.writeDbu(pt.getY());
        }
        this.closeParen();
    }

    protected void writeShapeData(AGeom geom) throws IOException {
        Class<?> gc = geom.getClass();
        if (gc.equals(AArc.class)) {
            ALog.logWarn((String)"Unsupported geometry '%s', it is not being saved to the UPD file.", (Object[])new Object[]{gc.getName()});
            assert (false);
        } else if (gc.equals(ACircle.class)) {
            ACircle circle = (ACircle)geom;
            this.writeIdentifier("circle");
            this.writeDbus(circle.getC().getX(), circle.getC().getY(), circle.getR());
        } else if (gc.equals(ACompositeGeom.class)) {
            ALog.logWarn((String)"Unsupported geometry '%s', it is not being saved to the UPD file.", (Object[])new Object[]{gc.getName()});
            assert (false);
        } else if (gc.equals(ALine.class)) {
            ALog.logWarn((String)"Unsupported geometry '%s', it is not being saved to the UPD file.", (Object[])new Object[]{gc.getName()});
            assert (false);
        } else if (gc.equals(AOctagon.class) || gc.equals(APolygon.class)) {
            APolygon poly = (APolygon)geom;
            this.writeIdentifier("polygon_nbr");
            this.writeInteger(poly.getPointCount());
            for (APoint2D pt : poly.getPoints()) {
                this.writeDbu(pt.getX());
                this.writeDbu(pt.getY());
            }
        } else if (gc.equals(APath.class)) {
            APath p = (APath)geom;
            this.writeIdentifier("path");
            this.writeDbu(p.getWidth());
            for (APoint2D pt : p.getPoints()) {
                this.writeDbu(pt.getX());
                this.writeDbu(pt.getY());
            }
        } else if (gc.equals(APoint2D.class)) {
            ALog.logWarn((String)"Unsupported geometry '%s', it is not being saved to the UPD file.", (Object[])new Object[]{gc.getName()});
            assert (false);
        } else if (gc.equals(ARect.class)) {
            ARect r = (ARect)geom;
            this.writeIdentifier("rect");
            this.writeDbu(r.left());
            this.writeDbu(r.bottom());
            this.writeDbu(r.right());
            this.writeDbu(r.top());
        } else {
            ALog.logWarn((String)"Unsupported geometry '%s', it is not being saved to the UPD file.", (Object[])new Object[]{gc.getName()});
            assert (false);
        }
    }

    protected void writeFileHeader(boolean fragment) throws IOException {
        if (fragment) {
            this.writeIdentifier("SIGRITY_UPD_fragment");
        } else {
            this.writeIdentifier("SIGRITY_UPD_Data");
        }
        this.writeIdentifier("7.2");
    }

    protected void writeIdentifiers(String ... list) throws IOException {
        for (String s : list) {
            this.writeIdentifier(s);
        }
    }

    protected void writeIdentifier(String s) throws IOException {
        this.writeBinaryText(s, UpdIO.OutputToken.ot_identifier);
    }

    protected void writeBinaryText(String text, UpdIO.OutputToken defType) throws IOException {
        Integer key = (Integer)this.mStringTable.inverse().get((Object)text);
        if (key == null) {
            key = this.mStringTable.size();
            this.mStringTable.put((Object)key, (Object)text);
            this.writeBinaryToken(defType.ordinal());
            byte[] str = text.getBytes("US-ASCII");
            if (str.length > 0) {
                int n = str.length - 1;
                str[n] = (byte)(str[n] | 0x80);
                for (byte c : str) {
                    this.mOutStream.write(c);
                }
            } else {
                this.mOutStream.write(128);
            }
        } else {
            int code = key + UpdIO.OutputToken.ot_id_real_0.ordinal();
            if (code < 256) {
                this.writeBinaryToken(code);
            } else {
                this.writeBinaryInteger(code -= 256, UpdIO.OutputToken.ot_id_real_1, UpdIO.OutputToken.ot_id_real_1);
            }
        }
    }

    protected void writeIntegers(long ... values) throws IOException {
        for (long value : values) {
            this.writeInteger(value);
        }
    }

    protected void writeInteger(long value) throws IOException {
        this.writeBinaryInteger(value, UpdIO.OutputToken.ot_pos_int_1, UpdIO.OutputToken.ot_neg_int_1);
    }

    protected void writeDbus(long ... values) throws IOException {
        for (long value : values) {
            this.writeDbu(value);
        }
    }

    protected void writeRotation(float r) throws IOException {
        this.writeReal(ATransformUtil.normRot((float)(360.0f - r)));
    }

    protected void writeDbu(long value) throws IOException {
        double d = this.mUnit.toUser(value);
        this.writeReal(d);
    }

    protected void writeReal(double value) throws IOException {
        if (value <= 9.223372036854776E18 && value >= -9.223372036854776E18 && value % 1.0 == 0.0) {
            this.writeInteger((long)value);
        } else {
            this.writeBinaryText(Double.toString(value), UpdIO.OutputToken.ot_real);
        }
    }

    void writeBinaryInteger(long value, UpdIO.OutputToken posType, UpdIO.OutputToken negType) throws IOException {
        int type;
        int len;
        if (value >= 0L) {
            len = UpdWriter.integerLength(value);
            type = posType.ordinal() + len - 1;
        } else {
            value = -value;
            len = UpdWriter.integerLength(value);
            type = negType.ordinal() + len - 1;
        }
        this.writeBinaryToken(type);
        while (--len >= 0) {
            byte b = (byte)(value & 0xFFL);
            value >>= 8;
            this.mOutStream.write(b);
        }
    }

    protected void writeBinaryToken(UpdIO.OutputToken token) throws IOException {
        this.writeBinaryToken(token.ordinal());
    }

    protected void writeBinaryToken(int value) throws IOException {
        assert (value <= 255 && value >= 0);
        this.writeBinaryToken((byte)value);
    }

    protected void writeBinaryToken(byte value) throws IOException {
        this.mOutStream.write(value);
    }

    protected void openParen() throws IOException {
        this.writeBinaryToken(UpdIO.OutputToken.ot_left_par);
    }

    protected void closeParen() throws IOException {
        this.writeBinaryToken(UpdIO.OutputToken.ot_right_par);
    }

    protected void writeEOF() throws IOException {
        this.writeBinaryToken(UpdIO.OutputToken.ot_eof);
    }

    protected static int integerLength(long value) {
        if ((value & 0xFF000000L) != 0L) {
            return 4;
        }
        if ((value & 0xFF0000L) != 0L) {
            return 3;
        }
        if ((value & 0xFF00L) != 0L) {
            return 2;
        }
        return 1;
    }

    public static String formatColor(Color c) {
        return String.format("RGB(%02x%02x%02x)", c.getRed(), c.getGreen(), c.getBlue());
    }
}

