/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.updio;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.DesignDialog;
import com.sigrity.orbit.ui.common.HierarchyChooser;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class UpdWriterUI
extends DesignDialog {
    protected AFileChooserControl mFc;
    protected JCheckBox mCbFlatDie;
    protected JCheckBox mCbFlatBondFingers;
    protected JCheckBox mCbFlatNets;
    protected JCheckBox mCbNoUnusedDieLayers;
    protected HierarchyChooser mHc;
    protected JTextField mTxtStatus = new JTextField();
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            IterableIterator<DevicePath> selPaths;
            Object path = UpdWriterUI.this.mFc.getPath();
            if (((String)path).length() == 0) {
                UpdWriterUI.this.mFc.getTextField().requestFocus();
                String msg = String.format("A target file must be specified.", new Object[0]);
                JOptionPane.showMessageDialog((Component)((Object)UpdWriterUI.this), msg, "File Error", 0);
                return;
            }
            File f = new File((String)path);
            if (!f.getName().contains(".")) {
                path = (String)path + ".upd";
                UpdWriterUI.this.mFc.getTextField().setText((String)path);
                f = new File((String)path);
            }
            if (f.exists() && !f.canWrite()) {
                UpdWriterUI.this.mFc.getTextField().requestFocus();
                String msg = String.format("Unable to write to '%s'.", path);
                JOptionPane.showMessageDialog((Component)((Object)UpdWriterUI.this), msg, "File Error", 0);
                return;
            }
            Cp.exec((String)"uw = new com.sigrity.orbit.updio.UpdWriter(%s)", (Object[])new Object[]{Cp.getFileAsArgument((File)f)});
            if (UpdWriterUI.this.mCbFlatNets.isSelected()) {
                Cp.exec((String)"uw.setFlattenNets(true)", (Object[])new Object[0]);
            }
            if (UpdWriterUI.this.mCbFlatDie.isSelected()) {
                Cp.exec((String)"uw.setFlattenDie(true)", (Object[])new Object[0]);
            }
            if (UpdWriterUI.this.mCbFlatBondFingers.isSelected()) {
                Cp.exec((String)"uw.setFlattenBondFingers(true)", (Object[])new Object[0]);
            }
            if (UpdWriterUI.this.mCbNoUnusedDieLayers.isSelected()) {
                Cp.exec((String)"uw.setIgnoreUnusedDieLayers(true)", (Object[])new Object[0]);
            }
            if ((selPaths = UpdWriterUI.this.mHc.getSelectedPaths()) != null) {
                UpdWriterUI.this.setStatus("Processing filter...", new Object[0]);
                int selCount = 0;
                Object paths = "";
                for (DevicePath p : selPaths) {
                    ++selCount;
                    if (((String)paths).length() > 0) {
                        paths = (String)paths + ",";
                    }
                    paths = (String)paths + String.format("\"%s\"", p.toString());
                }
                UpdWriterUI.this.setStatus("Writing %d devices...", selCount);
                Cp.exec((String)"uw.setFilterPaths(new String[]{%s})", (Object[])new Object[]{paths});
            } else {
                UpdWriterUI.this.setStatus("Writing design.", new Object[0]);
            }
            boolean ok = (Boolean)Cp.exec((String)"uw.write();", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"uw\")", (Object[])new Object[0]);
            if (!ok) {
                UpdWriterUI.this.setStatus("Write failed.", new Object[0]);
                String msg = String.format("An error occurred writing '%s'.", path);
                JOptionPane.showMessageDialog((Component)((Object)UpdWriterUI.this), msg, "File Error", 0);
                return;
            }
            UpdWriterUI.this.setStatus(null, new Object[0]);
            UIUtil.closeWindow((Window)((Object)UpdWriterUI.this));
        }
    };

    public static void display() {
        UpdWriterUI dlg = new UpdWriterUI(AApp.getApp().getMainWin());
        dlg.setVisible(true);
    }

    public UpdWriterUI(Component owner) {
        super(OrbitIO.getCurDb(), owner);
        this.setTitle("Export to UPD");
        this.setModal(true);
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        l.add("To UPD file:");
        this.mFc = new AFileChooserControl(new AFileChooserControl.ChooserInitializer(){

            public void initChooser(JFileChooser fc) {
                AFileFilter filter = new AFileFilter("upd", "UPD Files");
                fc.setFileFilter((FileFilter)filter);
            }
        });
        this.mFc.setUseSaveChooser(true);
        l.add((Component)this.mFc, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.push("Options", (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        GridBagManager.GridBagConstraintsEx c = GridBagManager.LEFT.insets(4, 0);
        l.add("Flatten:", (GridBagConstraints)c);
        l.pushNoFill();
        this.mCbFlatNets = (JCheckBox)l.add((Component)new JCheckBox("Nets", true), (GridBagConstraints)c);
        this.mCbFlatDie = (JCheckBox)l.add((Component)new JCheckBox("Die devices", true), (GridBagConstraints)c);
        this.mCbFlatBondFingers = (JCheckBox)l.add((Component)new JCheckBox("Bond Fingers", true), (GridBagConstraints)c);
        l.popNl();
        l.add("Ignore:", (GridBagConstraints)c);
        l.pushNoFill();
        this.mCbNoUnusedDieLayers = (JCheckBox)l.add((Component)new JCheckBox("Unused die layers", true), (GridBagConstraints)c);
        l.pop();
        l.popNl();
        this.mHc = (HierarchyChooser)l.add((Component)new HierarchyChooser(this.getDesign()), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.pushFillXRemainX();
        l.add((Component)this.mTxtStatus, (GridBagConstraints)GridBagManager.FILLX);
        this.mTxtStatus.setEditable(false);
        this.mTxtStatus.setBorder(null);
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        JButton btnClose = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        btnOk.addActionListener(this.mOk);
        this.pack();
        UIUtil.center((Component)((Object)this));
    }

    protected void setStatus(String fmt, Object ... args) {
        if (fmt == null) {
            this.mTxtStatus.setText("");
            return;
        }
        String text = String.format(fmt, args);
        this.mTxtStatus.setText(text);
        Container c = this.getContentPane();
        if (c instanceof JComponent) {
            ((JComponent)c).paintImmediately(((JComponent)c).getBounds());
        }
    }
}

