/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.util;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.JedecAlphabet;
import com.sigrity.orbit.OrbitIO;
import java.awt.event.ActionEvent;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class MatrixRenamePins {
    protected DeviceTemplate mDevT;

    public static MatrixRenamePins create(Db db, String deviceTemplateKey) {
        return new MatrixRenamePins((DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, deviceTemplateKey));
    }

    public static ActionRenameTemplatePins createAction(DeviceTemplate devT) {
        return new ActionRenameTemplatePins(devT);
    }

    protected MatrixRenamePins(DeviceTemplate devT) {
        this.mDevT = devT;
    }

    public long rename(boolean verify, String startAtStr) {
        AGeomUtil.CompassCorners startAt = AGeomUtil.CompassCorners.valueOf((String)startAtStr);
        return this.rename(verify, startAt);
    }

    public long rename(boolean verify, AGeomUtil.CompassCorners startAt) {
        long count;
        if (verify && (count = this.getPins().count()) > 0L) {
            String msg = String.format("%d pins will be considered for renaming. Continue?", count);
            String title = "Confirm Rename Pins";
            if (0 != JOptionPane.showConfirmDialog(OrbitIO.getMainWindow(), msg, title, 0)) {
                return 0L;
            }
        }
        AIterableItr pins = AIterableItr.itr(this.getPins());
        HierInst[][] portMatrix = this.mDevT.getHierPortMatrix((Iterable)pins, startAt);
        int length = portMatrix.length;
        int renamed = 0;
        for (int row = 0; row < length; ++row) {
            String rowName = JedecAlphabet.getNth((int)row);
            for (int col = 0; col < portMatrix[row].length; ++col) {
                String newName;
                HierInst hPinT = portMatrix[row][col];
                if (hPinT == null) continue;
                PinTemplate pinT = (PinTemplate)hPinT.getDbObject();
                Net net = pinT.getNet();
                PinTemplate existPin = net.getPinTemplate(newName = String.format("%s%d", rowName, col + 1));
                if (existPin != null && existPin != pinT) {
                    String existPinNewName = newName;
                    long suf = 1L;
                    while (net.getPinTemplate(existPinNewName) != null) {
                        existPinNewName = String.format("%s_%d", newName, suf);
                        ++suf;
                    }
                    existPin.setName(existPinNewName);
                }
                if (pinT.getName() != null && !pinT.getName().equals(newName)) {
                    pinT.setName(newName);
                    ++renamed;
                }
                for (PinInstance pi : pinT.getPinInstances()) {
                    pi.clrName();
                }
            }
        }
        OrbitIO.refreshViewsOf((DbObject)this.mDevT);
        return renamed;
    }

    public long rename(boolean verify) {
        return this.rename(verify, AGeomUtil.CompassCorners.NW);
    }

    protected Stream<DeviceTemplate.DescendantPin> getPins() {
        return this.mDevT.getDescendantPins().stream().filter(hPin -> hPin.getPinTemplate().getSubstrate() == this.mDevT.getSubstrate());
    }

    protected static class ActionRenameTemplatePins
    extends AbstractAction {
        protected DeviceTemplate mDevT;

        public ActionRenameTemplatePins(DeviceTemplate dt) {
            super("Matrix Rename Descendant Pins");
            this.mDevT = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = Cp.exec((String)"%s.create(curDb(), \"%s\").rename(true)", (Object[])new Object[]{AReflection.getJavaClassName(MatrixRenamePins.class), this.mDevT.getKeyStr()});
            if (o instanceof Long) {
                ALog.logInfo((String)"Renamed %d pins.", (Object[])new Object[]{(Long)o});
            } else {
                ALog.logWarn((String)"Unexpected return type %s from %s.", (Object[])new Object[]{AReflection.getJavaClassName(o == null ? null : o.getClass()), AReflection.getJavaClassName(MatrixRenamePins.class)});
            }
        }
    }
}

