/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.util;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Term;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.cmd.BundleCommands;
import com.sigrity.orbit.util.OrbitValidator;
import com.sigrity.orbit.util.PinUtil;
import java.util.List;
import java.util.stream.Collectors;

public class SwapPins {
    private final DevicePath mDevPathA;
    private final PinInstance mPinInstA;
    private final DevicePath mDevPathB;
    private final PinInstance mPinInstB;

    public static void swapPins(Db db, String devPathAStr, String pinAName, String devPathBStr, String pinBName) {
        DevicePath devPathA = DevicePath.fromString((Db)db, (String)devPathAStr);
        DevicePath devPathB = DevicePath.fromString((Db)db, (String)devPathBStr);
        assert (devPathA != null && devPathB != null);
        PinInstance pinInstA = devPathA.getDevice().getPinByName(pinAName);
        PinInstance pinInstB = devPathB.getDevice().getPinByName(pinBName);
        assert (pinInstA != null && pinInstB != null);
        SwapPins.swapPins(devPathA, pinInstA, devPathB, pinInstB);
    }

    public static void swapPins(DevicePath devPathA, PinInstance pinInstA, DevicePath devPathB, PinInstance pinInstB) {
        OrbitValidator.validateHierInst((DevicePath)devPathA, (DbObject)pinInstA);
        OrbitValidator.validateHierInst((DevicePath)devPathB, (DbObject)pinInstB);
        SwapPins swapPins = new SwapPins(devPathA, pinInstA, devPathB, pinInstB);
        swapPins.swapPin();
    }

    private SwapPins(DevicePath devPathA, PinInstance pinInstA, DevicePath devPathB, PinInstance pinInstB) {
        this.mDevPathA = devPathA;
        this.mPinInstA = pinInstA;
        this.mDevPathB = devPathB;
        this.mPinInstB = pinInstB;
    }

    private void swapPin() {
        if (!Bundle.canSwapInBundle((DevicePath)this.mDevPathA, (PinInstance)this.mPinInstA, (DevicePath)this.mDevPathB, (PinInstance)this.mPinInstB)) {
            ALog.logWarn((String)"Can not swap a pin involved in the fixed side of a bundle");
            return;
        }
        if (this.mDevPathA.equals((Object)this.mDevPathB)) {
            this.swapPinNets();
        } else {
            this.swapNetAtCommonAnscestor();
        }
        this.floodNets();
        this.swapPersonalities();
        this.swapFloorplans();
        this.swapPinLabels();
        this.swapRuleSets();
        this.updateBundle();
        ALog.logInfo((String)"%s pin %s swapped with %s pin %s", (Object[])new Object[]{this.mDevPathA, this.mPinInstA.getName(), this.mDevPathB, this.mPinInstB.getName()});
    }

    private void swapPinNets() {
        PinTemplate pt1 = this.mPinInstA.getPinTemplate();
        PinTemplate pt2 = this.mPinInstB.getPinTemplate();
        Net n1 = pt1.getNet();
        Net n2 = pt2.getNet();
        pt1.setNet(n2);
        pt2.setNet(n1);
    }

    private void swapNetAtCommonAnscestor() {
        DeviceTemplate commonAnscestor = this.mDevPathA.commonAnscestor(this.mDevPathB).getDeviceTemplate();
        DevicePath relPathA = this.mDevPathA.getRelativePathFromAnchor(commonAnscestor);
        DevicePath relPathB = this.mDevPathB.getRelativePathFromAnchor(commonAnscestor);
        Net topNetA = NetMap.getTopmostNet((Net)this.mPinInstA.getNet(), (DevicePath)relPathA);
        Net topNetB = NetMap.getTopmostNet((Net)this.mPinInstB.getNet(), (DevicePath)relPathB);
        this.connectNet(topNetB, relPathA, this.mPinInstA.getPinTemplate(), topNetA);
        this.connectNet(topNetA, relPathB, this.mPinInstB.getPinTemplate(), topNetB);
    }

    private void connectNet(Net toNet, DevicePath fromPath, PinTemplate fromPin, Net fromTopNet) {
        DeviceTemplate commonAnscestor = fromPath.getRoot();
        if (toNet.getDeviceTemplate() == commonAnscestor && !toNet.isUnused()) {
            if (fromPath.isEmpty()) {
                fromPin.setNet(toNet);
            } else {
                Net topChildNet = fromTopNet;
                if (fromTopNet.getDeviceTemplate() == commonAnscestor) {
                    DevicePath childPath = new DevicePath(fromPath);
                    childPath.removeFirst();
                    topChildNet = NetMap.getTopmostNet((Net)fromPin.getNet(), (DevicePath)childPath);
                }
                DevicePath netPath = fromPath.pathTo(topChildNet.getDeviceTemplate());
                NetMap.mapToRoot((DevicePath)netPath, (Net)topChildNet, (String)toNet.getName());
            }
        } else if (fromPath.isEmpty()) {
            fromPin.removeNet();
        } else if (fromTopNet.getDeviceTemplate() == commonAnscestor) {
            DevicePath childPath = new DevicePath(fromPath);
            childPath.removeFirst();
            Net topChildNet = NetMap.getTopmostNet((Net)fromPin.getNet(), (DevicePath)childPath);
            assert (topChildNet.getDeviceTemplate() == fromPath.getFirst().getTemplate());
            NetMap.unmap((Device)fromPath.getFirst(), (Net)topChildNet);
        }
    }

    private void floodNets() {
        PinUtil.floodNet((DevicePath)this.mDevPathA, (PinTemplate)this.mPinInstA.getPinTemplate(), (DevicePath)this.mDevPathA, (Net)this.mPinInstA.getNet());
        PinUtil.floodNet((DevicePath)this.mDevPathB, (PinTemplate)this.mPinInstB.getPinTemplate(), (DevicePath)this.mDevPathB, (Net)this.mPinInstB.getNet());
    }

    private void swapPersonalities() {
        List<PersonalityMap> personalityMapsA = PersonalityMap.getPersonalities((Personality.Type)Personality.Type.PORT, (DbObject)this.mPinInstA, (DevicePath)this.mDevPathA).collect(Collectors.toList());
        List<PersonalityMap> personalityMapsB = PersonalityMap.getPersonalities((Personality.Type)Personality.Type.PORT, (DbObject)this.mPinInstB, (DevicePath)this.mDevPathB).collect(Collectors.toList());
        DeviceTemplate commonAnscestor = this.mDevPathA.commonAnscestor(this.mDevPathB).getDeviceTemplate();
        assert (commonAnscestor != null);
        if (!personalityMapsA.isEmpty()) {
            StoredPath storedPathB = StoredPath.getRelativeFromAnchor((DevicePath)this.mDevPathB, (DeviceTemplate)commonAnscestor);
            personalityMapsA.forEach(pMap -> {
                if (PersonalityMap.get((Personality)pMap.getPersonality(), (StoredPath)storedPathB, (DbObject)this.mPinInstB).isEmpty()) {
                    pMap.setObject((DbObject)this.mPinInstB);
                    pMap.setPath(storedPathB);
                }
            });
        }
        if (!personalityMapsB.isEmpty()) {
            StoredPath storedPathA = StoredPath.getRelativeFromAnchor((DevicePath)this.mDevPathA, (DeviceTemplate)commonAnscestor);
            personalityMapsB.forEach(pMap -> {
                if (PersonalityMap.get((Personality)pMap.getPersonality(), (StoredPath)storedPathA, (DbObject)this.mPinInstA).isEmpty()) {
                    pMap.setObject((DbObject)this.mPinInstA);
                    pMap.setPath(storedPathA);
                }
            });
        }
    }

    private void swapFloorplans() {
        Floorplan fp2;
        FloorplanPin fpPin1 = FloorplanPin.find((PinTemplate)this.mPinInstA.getPinTemplate(), (DevicePath)this.mDevPathA);
        FloorplanPin fpPin2 = FloorplanPin.find((PinTemplate)this.mPinInstB.getPinTemplate(), (DevicePath)this.mDevPathB);
        Floorplan fp1 = fpPin1 == null ? null : fpPin1.getOwner();
        Floorplan floorplan = fp2 = fpPin2 == null ? null : fpPin2.getOwner();
        if (fpPin1 != null && fpPin2 != null) {
            if (fp1 != fp2) {
                fpPin1.setOwner(fp2);
                fpPin2.setOwner(fp1);
            }
        } else if (fpPin1 != null) {
            fpPin1.reassignTo(this.mPinInstB, this.mDevPathB);
        } else if (fpPin2 != null) {
            fpPin2.reassignTo(this.mPinInstA, this.mDevPathA);
        }
    }

    private void swapPinLabels() {
        DeviceTemplate substrateDevTB;
        DeviceTemplate substrateDevTA = this.mDevPathA.getSubstrateDeviceTemplate();
        if (substrateDevTA != (substrateDevTB = this.mDevPathB.getSubstrateDeviceTemplate())) {
            return;
        }
        DevicePath commonAnscestorPath = this.mDevPathA.commonAnscestor(this.mDevPathB);
        for (Device dev : commonAnscestorPath.getRelativePath(substrateDevTA)) {
            this.swapPinLabels(dev.getTemplate());
        }
    }

    private void swapPinLabels(DeviceTemplate owner) {
        PinTemplate pinA = this.mPinInstA.getPinTemplate();
        PinTemplate pinB = this.mPinInstB.getPinTemplate();
        PinLabel pinLabelA = PinLabel.get((DeviceTemplate)owner, (DevicePath)this.mDevPathA, (PinTemplate)pinA, (boolean)false);
        PinLabel pinLabelB = PinLabel.get((DeviceTemplate)owner, (DevicePath)this.mDevPathB, (PinTemplate)pinB, (boolean)false);
        Term termA = pinLabelA == null ? null : pinLabelA.getTerm(false);
        Term termB = pinLabelB == null ? null : pinLabelB.getTerm(false);
        DevicePath relPathA = this.mDevPathA.getRelativePathFromAnchor(owner);
        if (termB != null && termB.isConnect(relPathA, pinA)) {
            if (pinLabelA == null) {
                pinLabelA = PinLabel.get((DevicePath)relPathA, (PinTemplate)pinA);
            }
            pinLabelA.setTerm(termB);
        }
        DevicePath relPathB = this.mDevPathB.getRelativePathFromAnchor(owner);
        if (termA != null && termA.isConnect(relPathB, pinB)) {
            if (pinLabelB == null) {
                pinLabelB = PinLabel.get((DevicePath)relPathB, (PinTemplate)pinB);
            }
            pinLabelB.setTerm(termA);
        }
    }

    private void swapRuleSets() {
        RuleSet rs1 = RuleSetMgr.getMyRuleSet((DbObject)this.mPinInstA);
        RuleSet rs2 = RuleSetMgr.getMyRuleSet((DbObject)this.mPinInstB);
        RuleSetMgr.setMyRuleSet((RuleSet)rs1, (DbObject)this.mPinInstB);
        RuleSetMgr.setMyRuleSet((RuleSet)rs2, (DbObject)this.mPinInstA);
    }

    private void updateBundle() {
        BundleCommands.updatePotentialBundleOnSwap(HierPin.forPin((DevicePath)this.mDevPathA, (PinInstance)this.mPinInstA), HierPin.forPin((DevicePath)this.mDevPathB, (PinInstance)this.mPinInstB));
        Bundle.bundleChanged((String)"swap");
    }
}

