/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.verilog;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.CallGraph;
import com.sigrity.orbit.CallGraphPanel;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.verilog.CallTreeProbe;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class CallTree {
    ArrayList<TemplateNode> nodes = new ArrayList();
    TemplateNode designNode = null;

    public ArrayList<TemplateNode> getNodes() {
        return this.nodes;
    }

    protected String bussName(String netName) {
        String ret = netName;
        int loc = ret.indexOf(91);
        if (loc > 0) {
            return ret.substring(0, loc);
        }
        return ret;
    }

    public void print() {
        for (TemplateNode node : this.nodes) {
            if (node.isAChild()) continue;
            node.print("Root", 0);
        }
    }

    public TemplateNode find(String name) {
        for (TemplateNode node : this.nodes) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public TemplateNode insert(String name) {
        TemplateNode node = this.find(name);
        if (node != null) {
            return node;
        }
        node = new TemplateNode();
        this.nodes.add(node);
        node.setName(name);
        return node;
    }

    public DeviceTemplate synDB(Substrate s, String filePath) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            return null;
        }
        if (s == null) {
            s = Substrate.create((Db)db, (String)"syn", (boolean)true);
        }
        long pinSize = Design.micronToInternal((Db)db, (double)10.0);
        for (TemplateNode node : this.nodes) {
            boolean created = false;
            DeviceTemplate dt = DeviceTemplate.get((Db)db, (String)s.getName(), (String)node.name);
            if (dt == null) {
                dt = DeviceTemplate.create((Substrate)s, (String)node.name, (boolean)false);
                created = true;
            }
            double d = (double)pinSize * (double)(node.templateNetName.size() + 1);
            long dim = (long)Math.sqrt(d);
            if (created) {
                dt.setBounds((AGeom)new ARect(0L, 0L, dim, dim));
                ALog.logInfo((String)("Created Template " + node.name));
                dt.setSourceFile(filePath);
                dt.setSourceType(DeviceTemplate.SourceType.VERILOG);
                dt.setIsSynthesized(true);
            } else {
                ALog.logInfo((String)("Redefining Template " + node.name));
            }
            long x = pinSize / 2L;
            long y = pinSize / 2L;
            for (String netName : node.templateNetName) {
                String direction;
                PinTemplate pt;
                Net n = dt.getNet(netName);
                if (n == null) {
                    n = dt.createNet(netName);
                }
                if ((pt = dt.getPinByName(netName)) == null) {
                    pt = PinTemplate.create((Net)n, (String)n.getName());
                    pt.setLoc(new APoint2D(x, y));
                    if ((x += pinSize) > dim) {
                        y += pinSize;
                        x = 0L;
                    }
                }
                if ((direction = node.pinDirections.get(netName)) == null) continue;
                if (direction.equals("output")) {
                    pt.setDirection(PinTemplate.Direction.OUT);
                }
                if (!direction.equals("input")) continue;
                pt.setDirection(PinTemplate.Direction.IN);
            }
        }
        for (TemplateNode node : this.nodes) {
            this.synInstances(db, s, node, filePath);
        }
        DeviceTemplate topTemplate = null;
        for (TemplateNode node : this.nodes) {
            DevicePath aDiePath;
            if (!node.firstModule || (aDiePath = s.getADevicePathUsing()) == null) continue;
            topTemplate = DeviceTemplate.get((Db)db, (String)s.getName(), (String)node.name);
        }
        DbExplorerPanel.refreshAll();
        OrbitIO.getApp().zoomFitCurrentView();
        return topTemplate;
    }

    protected void synInstances(Db db, Substrate s, TemplateNode node, String filePath) {
        long x = 0L;
        long y = 0L;
        for (InstanceNode instance : node.references) {
            DeviceTemplate myTemplate = DeviceTemplate.get((Db)db, (String)s.getName(), (String)instance.templateName);
            if (myTemplate == null) {
                myTemplate = DeviceTemplate.create((Substrate)s, (String)instance.templateName, (boolean)false);
                myTemplate.setSourceFile(filePath);
                myTemplate.setSourceType(DeviceTemplate.SourceType.VERILOG);
                myTemplate.setIsSynthesized(true);
            }
            DeviceTemplate parentTemplate = DeviceTemplate.get((Db)db, (String)s.getName(), (String)node.getName());
            Device device = Device.create((Db)db, (String)instance.getName(), (DeviceTemplate)myTemplate, (DeviceTemplate)parentTemplate);
            for (String pinName : instance.refPinName) {
                Net childNet;
                PinTemplate pt = myTemplate.getPinByName(pinName);
                if (pt == null) {
                    Net myNet = myTemplate.getNetUnused();
                    pt = PinTemplate.create((Net)myNet, (String)pinName);
                    pt.setLoc(new APoint2D(x, y));
                }
                if ((childNet = pt.getNet()).isUnused()) {
                    childNet = myTemplate.createNet(pinName);
                    pt.setNet(childNet);
                }
                if (childNet == null) continue;
            }
            device.moveTo(x, y);
        }
    }

    public void trace(String netName, CallTreeProbe probe) {
        for (TemplateNode node : this.nodes) {
            if (node.isAChild()) continue;
            node.trace(netName, probe, "");
        }
    }

    public void traceAllTopLevelNets(CallTreeProbe probe) {
        for (TemplateNode node : this.nodes) {
            if (node.isAChild()) continue;
            for (String p : node.templateNetName) {
                node.trace(p, probe, "");
            }
        }
    }

    private void insertNodeAndChildrenAt(TemplateNode n, String instanceName, CallTreeDisplayableNode parent) {
        CallTreeDisplayableNode node = new CallTreeDisplayableNode(instanceName + "(" + n.name + ")");
        parent.add(node);
        for (InstanceNode ref : n.references) {
            this.insertNodeAndChildrenAt(ref.getTemplate(), ref.getName(), node);
        }
    }

    private void insertNodes(CallTreeDisplayableNode top) {
        for (TemplateNode node : this.nodes) {
            if (node.isAChild()) continue;
            this.insertNodeAndChildrenAt(node, "", top);
        }
    }

    public void show() {
        CallTreeDisplayableNode top = new CallTreeDisplayableNode("Design");
        this.insertNodes(top);
        JTree tree = new JTree(top);
        JScrollPane treeView = new JScrollPane(tree);
        JFrame frame = new JFrame("Verilog Hierarchy");
        frame.add(treeView);
        treeView.setOpaque(true);
        frame.setContentPane(treeView);
        frame.pack();
        frame.setVisible(true);
    }

    public void graph() {
        OrbitIO app = OrbitIO.getApp();
        Window winMain = app.getMainWin();
        ADialog dlg = new ADialog(winMain, "CallGraphPanel Test");
        CallGraph cg = new CallGraph(this);
        CallGraphPanel cgp = new CallGraphPanel(cg);
        GridBagManager l = new GridBagManager(dlg.getContentPane());
        l.add((Component)cgp, (GridBagConstraints)GridBagManager.FILLALL);
        dlg.pack();
        UIUtil.center((Component)dlg);
        dlg.setVisible(true);
    }

    static class CallTreeDisplayableNode
    extends DefaultMutableTreeNode {
        CallTreeDisplayableNode(String s) {
            super(s);
        }
    }

    public class TemplateNode {
        boolean firstModule = false;
        protected boolean isAChild = false;
        protected String name;
        protected ArrayList<String> templateNetName = new ArrayList();
        protected ArrayList<InstanceNode> references = new ArrayList();
        protected LinkedList<Property> properties = new LinkedList();
        protected HashMap<String, String> pinDirections = new HashMap();

        public void addProperty(String name, String val) {
            Property p = new Property(name, val);
            this.properties.add(p);
        }

        public void addPinDirection(String pinName, String direction) {
            this.pinDirections.put(pinName, direction);
        }

        public void print(String instanceName, int indent) {
            Object buffer = "";
            for (int i = 0; i < indent; ++i) {
                buffer = (String)buffer + "\t";
            }
            buffer = (String)buffer + instanceName + " " + this.name + "(";
            for (String p : this.templateNetName) {
                buffer = (String)buffer + p + ", ";
            }
            buffer = (String)buffer + ")";
            System.out.println((String)buffer);
            for (InstanceNode ref : this.references) {
                ref.getTemplate().print(ref.getName(), indent + 1);
            }
        }

        public InstanceNode addChild(String childInstanceName, String childTemplateName) {
            InstanceNode instance = new InstanceNode();
            instance.setName(childInstanceName);
            instance.template = null;
            instance.templateName = childTemplateName;
            this.references.add(instance);
            return instance;
        }

        public void addTemplateNetName(String param) {
            this.templateNetName.add(param);
        }

        public boolean isAChild() {
            return this.isAChild;
        }

        public void setAChild(boolean isAChild) {
            this.isAChild = isAChild;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<InstanceNode> getReferences() {
            return this.references;
        }

        public void trace(String paramName, CallTreeProbe probe, String path) {
            if (this.templateNetName.contains(paramName)) {
                for (InstanceNode call : this.references) {
                    if (call.template == null) continue;
                    ArrayList<Integer> refList = call.findRefNetNameOfName(paramName);
                    for (Integer pinIndex : refList) {
                        String pinName = call.findRefPinNameOfIndex(pinIndex);
                        Object newPath = path.isEmpty() ? call.getName() : path + "/" + call.getName();
                        probe.visit(call.refObject, call.getName(), pinName, call.findRefNetNameOfIndex(pinIndex), (String)newPath, call.template.references == null);
                        call.template.trace(pinName, probe, (String)newPath);
                    }
                }
            }
        }
    }

    public static class Property {
        String name;
        String val;

        public Property(String name, String val) {
            this.name = name;
            this.val = val;
        }
    }

    public class InstanceNode {
        TemplateNode parent;
        protected TemplateNode template = null;
        protected String templateName = null;
        protected Object refObject = null;
        private String name;
        protected ArrayList<String> refPinName = new ArrayList();
        protected ArrayList<String> refNetName = new ArrayList();

        public TemplateNode getTemplate() {
            return this.template;
        }

        public int findRefPinNameOfName(String name) {
            return this.refPinName.indexOf(name);
        }

        public String findRefPinNameOfIndex(int index) {
            return this.refPinName.get(index);
        }

        public ArrayList<Integer> findRefNetNameOfName(String name) {
            int size = this.refNetName.size();
            ArrayList<Integer> refList = new ArrayList<Integer>();
            for (int i = 0; i < size; ++i) {
                String netName = this.refNetName.get(i);
                if (!CallTree.this.bussName(netName).equals(name)) continue;
                refList.add(i);
            }
            return refList;
        }

        public String findRefNetNameOfIndex(int index) {
            return this.refNetName.get(index);
        }

        public void addPinNet(String pin, String net) {
            this.refPinName.add(pin);
            this.refNetName.add(net);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

