/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.verilog;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.verilog.CallTreeProbe;
import com.sigrity.orbit.verilog.LogicalCorrelationDescription;
import java.util.ArrayList;
import java.util.HashMap;

public class CallTreeProbeNetSetter
implements CallTreeProbe {
    HashMap<Device, String> mDevice2LogicalPath = new HashMap();
    protected DevicePath mParentPath;
    static CallTreeProbeNetSetter ASingleton;
    ArrayList<LogicalCorrelationDescription> ivnd = new ArrayList();
    ArrayList<LogicalCorrelationDescription> ivhnd = new ArrayList();
    ArrayList<LogicalCorrelationDescription> nvid = new ArrayList();
    ArrayList<LogicalCorrelationDescription> ivid = new ArrayList();
    ArrayList<LogicalCorrelationDescription> ividp = new ArrayList();
    protected boolean mSynMissing = false;

    public CallTreeProbeNetSetter(DevicePath parentPath) {
        this.mParentPath = parentPath;
    }

    public static CallTreeProbeNetSetter getSingleton() {
        return ASingleton;
    }

    public void begin(boolean synMissing) {
        this.mSynMissing = synMissing;
        ASingleton = this;
    }

    public void finish() {
        for (DevicePath dp : OrbitIO.getCurDesign().getDescendantDevices()) {
            Device device = dp.getLast();
            if (this.mDevice2LogicalPath.containsKey(device)) continue;
            LogicalCorrelationDescription cd = new LogicalCorrelationDescription();
            cd.name = device.getName();
            cd.setDescription(dp.toString());
            cd.setType(LogicalCorrelationDescription.Type.NVID);
            this.nvid.add(cd);
        }
    }

    @Override
    public void visit(Object o, String nodeName, String portName, String netName, String path, boolean leaf) {
        Device device = (Device)o;
        if (o == null) {
            LogicalCorrelationDescription cd = new LogicalCorrelationDescription();
            cd.name = nodeName;
            cd.description = nodeName + " " + portName + " " + path + " " + netName;
            if (leaf) {
                if (this.contains(this.ivnd, nodeName)) {
                    return;
                }
                cd.setType(LogicalCorrelationDescription.Type.IVND);
                this.ivnd.add(cd);
            } else {
                if (this.ivhnd.size() > 1000) {
                    return;
                }
                if (this.contains(this.ivhnd, nodeName)) {
                    return;
                }
                cd.setType(LogicalCorrelationDescription.Type.IVHND);
                this.ivhnd.add(cd);
            }
            return;
        }
        if (this.mDevice2LogicalPath.containsKey(device) && this.mDevice2LogicalPath.get(device).equals(path)) {
            LogicalCorrelationDescription cd = this.find(this.ividp, device.getName());
            if (cd != null) {
                cd.setDescription(cd.getDescription() + "<br>" + path + " " + netName);
            } else {
                cd = new LogicalCorrelationDescription();
                cd.name = device.getName();
                cd.description = "found multiple instances <br>" + path + " " + netName;
                cd.setType(LogicalCorrelationDescription.Type.IVIDP);
                this.ividp.add(cd);
            }
            return;
        }
        this.mDevice2LogicalPath.put(device, path);
        DeviceTemplate dt = device.getTemplate();
        PinTemplate dtp = dt.getPinByName(portName);
        if (dtp == null) {
            if (device.getTemplate().getType() == DeviceTemplate.Type.PERSONALITY) {
                return;
            }
            LogicalCorrelationDescription cd = new LogicalCorrelationDescription();
            cd.name = device.getName();
            cd.description = "Can't find pin " + portName + " on device " + device.getADevicePath();
            cd.setType(LogicalCorrelationDescription.Type.IVIDP);
            this.ividp.add(cd);
            return;
        }
        PinInstance port = device.getAssociatedPinInstance(dtp);
        if (port == null) {
            if (device.getTemplate().getType() == DeviceTemplate.Type.PERSONALITY) {
                return;
            }
            LogicalCorrelationDescription cd = new LogicalCorrelationDescription();
            cd.name = device.getName();
            cd.description = "Cant find pin " + portName + " on device " + device.getADevicePath();
            cd.setType(LogicalCorrelationDescription.Type.IVIDP);
            this.ividp.add(cd);
            return;
        }
        DevicePath apath = device.getADevicePath();
        NetMap.mapThroughPath((DevicePath)apath, (Net)port.getNet(), (String)netName);
        port.setNetSetterType(PinInstance.NetSetterType.VERILOG);
        LogicalCorrelationDescription cd = new LogicalCorrelationDescription();
        cd.name = netName;
        cd.description = "<br>" + path + " " + portName;
        this.ivid.add(cd);
        cd.setType(LogicalCorrelationDescription.Type.IVID);
    }

    public ArrayList<LogicalCorrelationDescription> getIvid() {
        return this.ivid;
    }

    public ArrayList<LogicalCorrelationDescription> getIvidp() {
        return this.ividp;
    }

    public ArrayList<LogicalCorrelationDescription> getIvnd() {
        return this.ivnd;
    }

    public ArrayList<LogicalCorrelationDescription> getIvhnd() {
        return this.ivhnd;
    }

    public ArrayList<LogicalCorrelationDescription> getNvid() {
        return this.nvid;
    }

    protected LogicalCorrelationDescription find(ArrayList<LogicalCorrelationDescription> list, String name) {
        for (LogicalCorrelationDescription vcd : list) {
            if (!vcd.getName().equals(name)) continue;
            return vcd;
        }
        return null;
    }

    protected boolean contains(ArrayList<LogicalCorrelationDescription> list, String name) {
        return this.find(list, name) != null;
    }
}

