/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.verilog;

import antlr.RecognitionException;
import antlr.collections.AST;
import com.sigrity.acl.ABoolean;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AString;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.verilog.VerilogSyntax;
import com.sigrity.orbit.ComponentLibrary;
import com.sigrity.orbit.verilog.Antlr2Util;
import com.sigrity.orbit.verilog.VerilogLexer;
import com.sigrity.orbit.verilog.VerilogParser;
import com.sigrity.orbit.verilog.VerilogToDbCorrelation;
import com.sigrity.orbit.verilog.VerilogToDbProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;

public class Verilog {
    public static final String FILE_EXT_V = "v";
    public static final String FILE_DESC_V = "Verilog File";

    public static String getDefaultImportSubstrateName(Db db) {
        return Substrate.getUniqueName((Db)db, (String)"VerilogImport", (String)"", (boolean)true);
    }

    public static AST parse(String filePath) {
        return Verilog.parse(new File(filePath));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static AST parse(File f) {
        try (FileInputStream fileInStream = new FileInputStream(f);){
            AST aST;
            block16: {
                InputStream inStream = AFileFilter.VERILOGGZ.isExtFile(f) ? new GZIPInputStream(fileInStream) : fileInStream;
                try {
                    VerilogLexer lexer = new VerilogLexer(inStream);
                    VerilogParser parser2 = new VerilogParser(lexer);
                    parser2.parse();
                    aST = parser2.getAST();
                    if (inStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inStream.close();
            }
            return aST;
        }
        catch (FileNotFoundException e) {
            ALog.logError((String)"File '%s' not found.", (Object[])new Object[]{f});
        }
        catch (ZipException e) {
            ALog.logError((String)"Error reading compressed data in the GZIP file format '%s'.", (Object[])new Object[]{f});
        }
        catch (RecognitionException e) {
            ALog.logError((String)"Error parsing %s %s", (Object[])new Object[]{f, e});
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Error parsing Verilog file '%s'.", (Object[])new Object[]{f});
        }
        return null;
    }

    public static void walk(AST node, Visitor visitor) {
        visitor.enter(node).ifPresent(childVisitor -> Antlr2Util.children(node).forEach(child -> Verilog.walk(child, childVisitor)));
        visitor.exit(node);
    }

    public static boolean importFile(String file, Db db, String substrateName) {
        return Verilog.importFiles(new String[]{file}, db, substrateName);
    }

    public static boolean importFiles(String[] files, Db db, String substrateName) {
        Importer importer = new Importer(db);
        importer.setTargetSubstrateName(Optional.ofNullable(substrateName));
        return importer.importFiles(Arrays.asList(files));
    }

    public static boolean parseFile(String pathName, Consumer<AST> moduleHandler) {
        File file = new File(pathName);
        ALog.logInfo((String)"Parsing '%s'", (Object[])new Object[]{file});
        AST astRoot = Verilog.parse(file);
        if (astRoot == null) {
            return false;
        }
        Antlr2Util.nodeAndFollowingSiblings(astRoot).filter(ast -> ast.getType() == 4).forEach(moduleHandler::accept);
        return true;
    }

    public static String getVerilogFieldName(String fieldName) {
        return String.format("%s.%s", Verilog.class.getName(), fieldName);
    }

    public static String getVerilogNetMsbMaxFldName(String netName) {
        return Verilog.getVerilogFieldName(String.format("NetMsbMax.%s", netName));
    }

    public static boolean getVerilogNetMsbMax(DeviceTemplate devT, String netName) {
        return ABoolean.fromString((String)devT.getStringValue(Verilog.getVerilogNetMsbMaxFldName(netName)));
    }

    public static void setVerilogNetMsbMax(DeviceTemplate devT, String netName, boolean msbMax) {
        devT.setValue(Verilog.getVerilogNetMsbMaxFldName(netName), (Object)msbMax);
    }

    public static IterableIterator<Net> getBitIndexedNets(DeviceTemplate devT, String netName) {
        Pattern pattern = VerilogSyntax.getBitIndexedNamePattern((String)netName);
        return devT.getNets().filter(net -> pattern.matcher(net.getName()).matches()).sorted(Net.NameComparator.reversed());
    }

    public static Optional<Long> getVerilogNetMaxBit(DeviceTemplate devT, String netName) {
        Pattern pattern = VerilogSyntax.getBitIndexedNamePattern((String)netName);
        return devT.getNets().stream().map(net -> pattern.matcher(net.getName())).filter(Matcher::matches).map(matcher -> Long.parseLong(matcher.group(1))).reduce(Math::max);
    }

    public static void dump(String filePath) {
        AST astRoot = Verilog.parse(filePath);
        Antlr2Util.nodeAndFollowingSiblings(astRoot).forEach(ast -> Verilog.walk(ast, new Visitor(){
            int indent = 0;

            @Override
            public Optional<Visitor> enter(AST node) {
                AUtil.print((String)"[%03d]%s%s", (Object[])new Object[]{node.getType(), AString.repeat((String)"  ", (int)this.indent), node.toString()});
                ++this.indent;
                return Optional.of(this);
            }

            @Override
            public void exit(AST node) {
                --this.indent;
            }
        }));
    }

    protected static IterableIterator<DeviceTemplate> getDevTsWithName(Db db, final String devTName) {
        return new FilteringIterator<DeviceTemplate>((Iterator)db.getObjects(DeviceTemplate.class)){

            protected boolean include(DeviceTemplate devT) {
                return Verilog.getModuleName(devT).equals(devTName);
            }
        };
    }

    public static String getModuleName(DeviceTemplate devT) {
        return devT.isDesign() ? ((Design)devT).getUserName("Design") : devT.getName();
    }

    private Verilog() {
    }

    public static class Importer {
        protected Db mDb;
        protected String mTgtSubstName = null;
        protected ComponentLibrary mCompLib = null;
        private boolean mIsOverwriteExisting = false;
        private boolean mIsOverwritePG = false;
        private boolean mIsOverwriteBump = false;

        public Importer(Db targetDb) {
            this.mDb = targetDb;
        }

        public Optional<String> getTargetSubstrateName() {
            return Optional.ofNullable(this.mTgtSubstName);
        }

        public void setTargetSubstrateName(Optional<String> targetSubst) {
            this.mTgtSubstName = targetSubst.orElse(null);
        }

        public Optional<ComponentLibrary> getCompLib() {
            return Optional.ofNullable(this.mCompLib);
        }

        public void setCompLib(Optional<ComponentLibrary> compLib) {
            this.mCompLib = compLib.orElse(null);
        }

        public void setIsOverwriteExisting(boolean b) {
            this.mIsOverwriteExisting = b;
        }

        public void setIsOverwritePG(boolean b) {
            this.mIsOverwritePG = b;
        }

        public void setIsOverwriteBump(boolean b) {
            this.mIsOverwriteBump = b;
        }

        public boolean importFiles(String ... files) {
            return this.importFiles(Arrays.asList(files));
        }

        public boolean importFiles(List<String> files) {
            VerilogToDbCorrelation correlator = new VerilogToDbCorrelation(this.mDb);
            correlator.setDefaultSubstrate(this.mTgtSubstName);
            for (String file : files) {
                if (Verilog.parseFile(file, correlator)) continue;
                return false;
            }
            VerilogToDbProcessor processor = new VerilogToDbProcessor(this.mDb);
            processor.setComponentLibrary(this.mCompLib);
            processor.setIsOverwriteExisting(this.mIsOverwriteExisting);
            processor.setIsOverwriteBump(this.mIsOverwriteBump);
            processor.setIsOverwritePG(this.mIsOverwritePG);
            if (this.mTgtSubstName != null) {
                processor.setDefaultSubstrate(this.mTgtSubstName);
            }
            ALog.logInfo((String)"Processing Verilog...");
            boolean result = processor.process(correlator.getCorrelation());
            ALog.logInfo((String)"Verilog import complete.");
            return result;
        }
    }

    public static interface Visitor {
        public Optional<Visitor> enter(AST var1);

        public void exit(AST var1);
    }
}

