/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.verilog;

import antlr.collections.AST;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.verilog.VerilogIdentifier;
import com.sigrity.orbit.verilog.CallTree;
import java.util.ArrayList;
import java.util.function.Consumer;

public class VerilogToCallTree
implements Consumer<AST> {
    protected Db mDb;
    protected CallTree mCallTree;
    boolean firstModule = true;
    protected VerilogIdentifier mVerilogIdentifiers = new VerilogIdentifier();

    public VerilogToCallTree(Db db, CallTree callTree) {
        this.mDb = db;
        this.mCallTree = callTree;
    }

    public void print() {
        this.mCallTree.print();
    }

    public void show() {
        this.mCallTree.show();
    }

    @Override
    public void accept(AST tModule) {
        AST c;
        String deviceTemplateName = this.mVerilogIdentifiers.unescape(tModule.getFirstChild().toString());
        CallTree.TemplateNode template = this.mCallTree.insert(deviceTemplateName);
        template.firstModule = this.firstModule;
        this.firstModule = false;
        for (c = tModule.getFirstChild(); c != null; c = c.getNextSibling()) {
            AST c1;
            if (c.getType() == 169) {
                for (c1 = c.getFirstChild(); c1 != null; c1 = c1.getNextSibling()) {
                    String portName = this.mVerilogIdentifiers.unescape(c1.getText());
                    if (portName.equals(",")) continue;
                    template.addTemplateNetName(portName);
                }
                continue;
            }
            if (c.getType() != 33) continue;
            c1 = c.getNextSibling();
            String pname = c1.getText();
            c1 = c1.getNextSibling();
            c1 = c1.getNextSibling();
            String pVal = c1.getText();
            template.addProperty(pname, pVal);
        }
        for (c = tModule.getFirstChild(); c != null; c = c.getNextSibling()) {
            AST pinName;
            if (c.getType() == 170) {
                this.moduleInst(template, deviceTemplateName, c);
                continue;
            }
            if (c.getType() == 35) {
                pinName = c.getFirstChild();
                if (pinName == null) continue;
                template.addPinDirection(pinName.getText(), "output");
                continue;
            }
            if (c.getType() != 34 || (pinName = c.getFirstChild()) == null) continue;
            template.addPinDirection(pinName.getText(), "input");
        }
    }

    protected void moduleInst(CallTree.TemplateNode parent, String deviceTemplateName, AST tModuleInst) {
        AST tChildDeviceTemplate = tModuleInst.getFirstChild();
        AST tChildDevice = tChildDeviceTemplate.getNextSibling();
        String instanceName = this.mVerilogIdentifiers.unescape(tChildDevice.toString());
        String intanceTemplateName = tChildDeviceTemplate.toString();
        CallTree.InstanceNode instanceNode = parent.addChild(instanceName, intanceTemplateName);
        AST tPortConnections = tChildDevice.getNextSibling();
        if (tPortConnections.getType() != 171) {
            return;
        }
        for (AST tPortConnection = tPortConnections.getFirstChild(); tPortConnection != null; tPortConnection = tPortConnection.getNextSibling()) {
            int type = tPortConnection.getType();
            if (type != 173) continue;
            AST tPin = tPortConnection.getFirstChild();
            AST tNet = tPin.getFirstChild();
            if (tPin == null || tNet == null) continue;
            instanceNode.addPinNet(this.mVerilogIdentifiers.unescape(tPin.toString()), this.toFullString(tNet));
        }
    }

    protected ArrayList<Device> findDevice(String name, DeviceTemplate dt) {
        name = name.replaceAll(" ", "");
        ArrayList<Device> returnList = new ArrayList<Device>();
        for (Device candidate : dt.getDeviceInstances()) {
            String cName = candidate.getName();
            if (cName.startsWith("\\") || cName.startsWith("/")) {
                cName = cName.substring(1);
            }
            if (!name.equals(cName)) continue;
            returnList.add(candidate);
        }
        return returnList;
    }

    protected String toFullString(AST node) {
        Object ret = node.toString();
        for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
            ret = (String)ret + node.toString();
        }
        return ret;
    }
}

