/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.verilog;

import antlr.collections.AST;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.verilog.VerilogIdentifier;
import com.sigrity.orbit.verilog.Verilog;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class VerilogToDbCorrelation
implements Consumer<AST> {
    protected Db mDb;
    protected List<AST> mModuleASTs = new LinkedList<AST>();
    protected String mDefaultSubstrateName = null;
    protected Substrate mDefaultSubstrate = null;
    protected VerilogIdentifier mVerilogIdentifier = new VerilogIdentifier();

    public VerilogToDbCorrelation(Db db) {
        this.mDb = db;
    }

    public void setDefaultSubstrate(String substrateName) {
        this.mDefaultSubstrateName = substrateName;
    }

    public Correlation getCorrelation() {
        ArrayList<Correlated> correlateds = new ArrayList<Correlated>();
        for (AST ast : this.mModuleASTs) {
            correlateds.add(new Correlated(ast));
        }
        return new Correlation(correlateds);
    }

    @Override
    public void accept(AST astModule) {
        this.mModuleASTs.add(astModule);
    }

    public class Correlated {
        protected AST mModuleAst;
        protected DeviceTemplate mModuleDevT;

        public Correlated(AST module) {
            this.mModuleAst = module;
            this.mModuleDevT = this.getMappedDevT(this.mModuleAst);
        }

        public String getModuleName() {
            return VerilogToDbCorrelation.this.mVerilogIdentifier.unescape(this.mModuleAst.getFirstChild().getText());
        }

        public AST getModuleAst() {
            return this.mModuleAst;
        }

        public DeviceTemplate getModuleDevT() {
            return this.mModuleDevT;
        }

        public Optional<DeviceTemplate> getDeviceTemplate() {
            return Optional.ofNullable(this.getModuleDevT());
        }

        private DeviceTemplate getMappedDevT(AST astModule) {
            String devTemplName = VerilogToDbCorrelation.this.mVerilogIdentifier.unescape(astModule.getFirstChild().getText());
            DeviceTemplate dt = DeviceTemplate.get((Db)VerilogToDbCorrelation.this.mDb, (String)VerilogToDbCorrelation.this.mDefaultSubstrateName, (String)devTemplName);
            if (dt != null) {
                return dt;
            }
            Optional optDevT = this.getMatchedDevTs(devTemplName).ifExactlyOne();
            if (optDevT.isPresent()) {
                return (DeviceTemplate)optDevT.get();
            }
            return null;
        }

        private IterableIterator<DeviceTemplate> getMatchedDevTs(String devTemplName) {
            return Verilog.getDevTsWithName(VerilogToDbCorrelation.this.mDb, devTemplName);
        }
    }

    public class Correlation {
        protected List<Correlated> mCorrelated;

        public Correlation(List<Correlated> correlated) {
            this.mCorrelated = correlated;
        }

        public List<Correlated> getCorrelated() {
            return this.mCorrelated;
        }
    }
}

