/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.verilog;

import antlr.collections.AST;
import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.acl.verilog.VerilogSyntax;
import com.sigrity.orbit.ComponentLibrary;
import com.sigrity.orbit.cmd.NetCommands;
import com.sigrity.orbit.verilog.Antlr2Util;
import com.sigrity.orbit.verilog.Verilog;
import com.sigrity.orbit.verilog.VerilogToDbCorrelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class VerilogToDbProcessor {
    private static final String SUPPLY0_STRING = "supply0";
    private static final String SUPPLY1_STRING = "supply1";
    private final Db mDb;
    private final VerilogTermTable mTermTable;
    private String mDefaultSubstrateName = null;
    private ComponentLibrary mCompLib = null;
    private boolean mIsOverwrite = false;
    private boolean mIsOverwritePG = false;
    private boolean mIsOverwriteBump = false;
    private boolean mSynthesizeChildTemplates = true;
    private final Map<DeviceTemplate, V2DevTProcessor> mDevT2Processor = new HashMap<DeviceTemplate, V2DevTProcessor>();
    private final Map<String, Set<String>> mDTRelation = new HashMap<String, Set<String>>();
    private static final int[] VERILOG_IDENTIFIER_TYPES = new int[]{93, 94};
    private static final Set<Integer> VERILOG_IDENTIFIER_TYPES_SET = IntStream.of(VERILOG_IDENTIFIER_TYPES).boxed().collect(Collectors.toSet());
    private static final Comparator<Net> WireFirstThenNameComparator = (a, b) -> {
        boolean hasTermA = a.getTerms().hasNext();
        boolean hasTermB = b.getTerms().hasNext();
        if (hasTermA && !hasTermB) {
            return 1;
        }
        if (!hasTermA && hasTermB) {
            return -1;
        }
        return AAlphaNumComp.comp((Object)a.getName(), (Object)b.getName());
    };

    public VerilogToDbProcessor(Db db) {
        this.mDb = db;
        this.mTermTable = new VerilogTermTable();
    }

    public void setDefaultSubstrate(String subsrtateName) {
        this.mDefaultSubstrateName = subsrtateName;
    }

    public void setComponentLibrary(ComponentLibrary lib) {
        this.mCompLib = lib;
    }

    public void setIsOverwriteExisting(boolean b) {
        this.mIsOverwrite = b;
    }

    public void setIsOverwritePG(boolean b) {
        this.mIsOverwritePG = b;
    }

    public void setIsOverwriteBump(boolean b) {
        this.mIsOverwriteBump = b;
    }

    public boolean process(VerilogToDbCorrelation.Correlation correlation) {
        for (VerilogToDbCorrelation.Correlated correlated : correlation.getCorrelated()) {
            DeviceTemplate devT = correlated.getDeviceTemplate().orElseGet(() -> this.createDeviceTemplate(correlated));
            assert (devT != null);
            V2DevTProcessor devTProcessor = this.newV2DevTProcessor(correlated, devT);
            this.mDevT2Processor.put(devT, devTProcessor);
        }
        this.mDevT2Processor.forEach((k, v) -> v.processTemplate());
        this.mDevT2Processor.forEach((k, v) -> v.processChildInst());
        this.mDevT2Processor.forEach((k, v) -> v.processAssignment());
        this.overwriteExisting();
        this.mTermTable.close();
        return true;
    }

    private DeviceTemplate createDeviceTemplate(VerilogToDbCorrelation.Correlated correlated) {
        String substrateName = this.getDefaultSubstrateName();
        Substrate substrate = Substrate.getSubstrate((Db)this.mDb, (String)substrateName);
        if (substrate == null) {
            substrate = Substrate.create((Db)this.mDb, (String)substrateName);
        }
        return this.createDeviceTemplate(substrate, correlated);
    }

    private V2DevTProcessor newV2DevTProcessor(VerilogToDbCorrelation.Correlated correlated, DeviceTemplate devT) {
        return new V2DevTProcessor(correlated.getModuleAst(), devT);
    }

    private DeviceTemplate createDeviceTemplate(Substrate substrate, VerilogToDbCorrelation.Correlated correlated) {
        String dtName = correlated.getModuleName();
        assert (DeviceTemplate.getDeviceTemplate((Substrate)substrate, (String)dtName) == null);
        DeviceTemplate compLibDevT = this.getCompLibDevT(substrate, correlated);
        if (compLibDevT != null) {
            return compLibDevT;
        }
        DeviceTemplate devT = DeviceTemplate.create((Substrate)substrate, (String)dtName, (boolean)false);
        devT.setIsSynthesized(true);
        ALog.flogInfo((String)"Synthesized DeviceTemplate '%s' for Substrate '%s'.", (Object[])new Object[]{dtName, substrate.getName()});
        return devT;
    }

    private DeviceTemplate getCompLibDevT(Substrate substrate, VerilogToDbCorrelation.Correlated correlated) {
        if (this.mCompLib == null) {
            return null;
        }
        String dtName = correlated.getModuleName();
        if (dtName.equals(this.getDefaultSubstrateName())) {
            this.getDTRelation(correlated);
        }
        String dvName = null;
        if (this.mDTRelation.containsKey(dtName)) {
            dvName = this.mDTRelation.get(dtName).iterator().next();
        }
        long numPorts = VerilogToDbProcessor.getNumPorts(correlated);
        return this.mCompLib.getComponent(new ComponentLibrary.Spec[]{ComponentLibrary.Spec.verilogName((String)dtName), ComponentLibrary.Spec.targetSubstrateName((String)substrate.getName()), ComponentLibrary.Spec.deviceName((String)dvName), ComponentLibrary.Spec.numberOfPorts((Long)numPorts)}).map(ComponentLibrary.CompDesc::getDeviceTemplate).orElse(null);
    }

    private void getDTRelation(VerilogToDbCorrelation.Correlated correlated) {
        Antlr2Util.children(correlated.getModuleAst()).filter(ast -> ast.getType() == 170).forEach(ast -> {
            String dtName = ast.getFirstChild().getText();
            String dvName = ast.getFirstChild().getNextSibling().getText();
            if (this.mDTRelation.containsKey(dtName)) {
                this.mDTRelation.get(dtName).add(dvName);
            } else {
                HashSet<String> dvSet = new HashSet<String>();
                dvSet.add(dvName);
                this.mDTRelation.put(dtName, dvSet);
            }
        });
    }

    private void overwriteExisting() {
        if (this.mIsOverwrite) {
            this.mDevT2Processor.forEach((k, v) -> v.processOverwrite());
        }
    }

    private String getDefaultSubstrateName() {
        if (this.mDefaultSubstrateName == null) {
            this.mDefaultSubstrateName = Verilog.getDefaultImportSubstrateName(this.mDb);
        }
        return this.mDefaultSubstrateName;
    }

    private static IterableIterator<Net> getOrCreateNets(DeviceTemplate devT, String verilogName) {
        Optional<SliceInfo> sliceInfoOpt = VerilogToDbProcessor.getInfoFromBusSlice(verilogName);
        IterableIterator<Net> netItr = null;
        if (sliceInfoOpt.isPresent()) {
            SliceInfo sliceInfo = sliceInfoOpt.get();
            netItr = VerilogToDbProcessor.getOrCreateNets(devT, sliceInfo.getName(), sliceInfo.getMsb(), sliceInfo.getLsb());
        } else {
            netItr = Verilog.getBitIndexedNets(devT, verilogName);
        }
        return netItr.hasNext() ? netItr : ASingletonItr.create((Object)VerilogToDbProcessor.getOrCreateNet(devT, verilogName));
    }

    private static IterableIterator<Net> getOrCreateNets(DeviceTemplate devT, SliceOrNet sliceOrNet) {
        if (sliceOrNet.isSlice()) {
            SliceInfo slice = sliceOrNet.getSliceInfo();
            return VerilogToDbProcessor.getOrCreateNets(devT, slice.getName(), slice.getMsb(), slice.getLsb());
        }
        return VerilogToDbProcessor.getOrCreateNets(devT, sliceOrNet.getText());
    }

    private static IterableIterator<Net> getOrCreateNets(DeviceTemplate devT, String name, int from, int to) {
        return VerilogSyntax.getBitIndexedNames((String)name, (int)from, (int)to).mapAndNonNull(indexedName -> VerilogToDbProcessor.getOrCreateNet(devT, indexedName));
    }

    private static Net getOrCreateNet(DeviceTemplate devT, String netName) {
        return Optional.ofNullable(devT.getNet(netName)).orElseGet(() -> {
            Term term = devT.getTerm(netName);
            if (term != null) {
                return term.uniquifyNet();
            }
            return devT.createNet(netName);
        });
    }

    private static Optional<SliceInfo> getInfoFromBusSlice(String sliceName) {
        Matcher matcher = VerilogSyntax.getNameSliceMatcher((String)sliceName);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String name = matcher.group(1);
        int msb = Integer.parseInt(matcher.group(2));
        int lsb = matcher.group(4) == null ? msb : Integer.parseInt(matcher.group(4));
        return Optional.of(new SliceInfo(name, msb, lsb));
    }

    private static boolean isVerilogIdentifier(int tknType) {
        return VERILOG_IDENTIFIER_TYPES_SET.contains(tknType);
    }

    private static boolean isVerilogIdentifier(AST node) {
        return VerilogToDbProcessor.isVerilogIdentifier(node.getType());
    }

    private static SliceOrNet getSliceOrNet(AST ast) {
        if (VerilogToDbProcessor.isSliceInfo(ast)) {
            return new SliceOrNet(VerilogToDbProcessor.getSliceInfo(ast));
        }
        return new SliceOrNet(ast.getText());
    }

    private static SliceInfo getSliceInfo(AST ast) {
        assert (VerilogToDbProcessor.isSliceInfo(ast));
        AST astLhsMsb = ast.getNextSibling().getNextSibling();
        AST astLhsLsb = null;
        if (astLhsMsb.getNextSibling().getType() == 15) {
            astLhsLsb = astLhsMsb.getNextSibling().getNextSibling();
        }
        int msb = Integer.parseInt(astLhsMsb.getText());
        int lsb = astLhsLsb == null ? msb : Integer.parseInt(astLhsLsb.getText());
        return new SliceInfo(ast.getText(), msb, lsb);
    }

    private static boolean isSliceInfo(AST ast) {
        return VerilogToDbProcessor.isVerilogIdentifier(ast) && ast.getNextSibling() != null && ast.getNextSibling().getType() == 14 && Antlr2Util.nodeOrFollowingSiblingOfType(ast, 16).isPresent();
    }

    private static long getNumPorts(VerilogToDbCorrelation.Correlated correlated) {
        return Antlr2Util.children(correlated.getModuleAst()).filter(ast -> ast.getType() == 169).map(ast -> Antlr2Util.children(ast).filter(VerilogToDbProcessor::isVerilogIdentifier).count()).reduce(0L, (a, b) -> a + b);
    }

    private class VerilogTermTable {
        private final Map<DeviceTemplate, Map<String, List<Term>>> mBusMap = new HashMap<DeviceTemplate, Map<String, List<Term>>>();
        private final DbClass.DbObjectAdapter mTermListener;
        private final DbClass.DbObjectAdapter mNetListener;
        private boolean cache;

        private VerilogTermTable() {
            this.cache = VerilogToDbProcessor.this.mDb.getListenersEnabled();
            DbClass clsTerm = VerilogToDbProcessor.this.mDb.getDbClass(Term.class);
            final DbFieldDef termNetField = clsTerm.getField("net");
            DbClass clsNet = VerilogToDbProcessor.this.mDb.getDbClass(Net.class);
            final DbFieldDef netNameField = clsNet.getField("name");
            assert (VerilogToDbProcessor.this.mDb.getListenersEnabled());
            this.mTermListener = new DbClass.DbObjectAdapter(){

                public void addedObject(DbClass.ObjectAdd add) {
                    if (!VerilogTermTable.this.cache) {
                        return;
                    }
                    Term term = (Term)add.getDbObject();
                    APair t = VerilogSyntax.parseBusName((String)term.getNet().getName());
                    if (t == null) {
                        return;
                    }
                    Map busMap = VerilogTermTable.this.mBusMap.computeIfAbsent(term.getDeviceTemplate(), x$0 -> VerilogTermTable.this.buildTerms((DeviceTemplate)x$0));
                    busMap.computeIfAbsent((String)t.getFirst(), busName -> new LinkedList()).add(term);
                }

                public boolean removingObject(DbClass.ObjectRemove remove) {
                    Term term = (Term)remove.getDbObject();
                    APair t = VerilogSyntax.parseBusName((String)term.getNet().getName());
                    if (t == null) {
                        return true;
                    }
                    Map busMap = VerilogTermTable.this.mBusMap.computeIfAbsent(term.getDeviceTemplate(), x$0 -> VerilogTermTable.this.buildTerms((DeviceTemplate)x$0));
                    busMap.computeIfAbsent((String)t.getFirst(), busName -> new LinkedList()).remove(term);
                    return true;
                }

                public void changedObject(DbClass.ObjectChange change) {
                    if (change.getField() == termNetField) {
                        APair t;
                        Net oldNet = (Net)change.getOldValue();
                        Net newNet = (Net)change.getNewValue();
                        Term term = (Term)change.getObject();
                        Map busMap = VerilogTermTable.this.mBusMap.computeIfAbsent(term.getDeviceTemplate(), x$0 -> VerilogTermTable.this.buildTerms((DeviceTemplate)x$0));
                        if (oldNet != null && (t = VerilogSyntax.parseBusName((String)oldNet.getName())) != null) {
                            busMap.computeIfAbsent((String)t.getFirst(), busName -> new LinkedList()).remove(term);
                        }
                        if (newNet != null && (t = VerilogSyntax.parseBusName((String)newNet.getName())) != null) {
                            busMap.computeIfAbsent((String)t.getFirst(), busName -> new LinkedList()).add(term);
                        }
                    }
                }
            };
            this.mNetListener = new DbClass.DbObjectAdapter(){

                public void changedObject(DbClass.ObjectChange change) {
                    if (change.getField() == netNameField) {
                        assert (false);
                        VerilogTermTable.this.cache = false;
                    }
                }
            };
            VerilogToDbProcessor.this.mDb.getDbClass(Term.class).addObjectListener((DbClass.DbObjectListener)this.mTermListener, new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.ADDED, DbClass.DbObjectEventType.REMOVING, DbClass.DbObjectEventType.CHANGED});
            VerilogToDbProcessor.this.mDb.getDbClass(Net.class).addObjectListener((DbClass.DbObjectListener)this.mNetListener, new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.CHANGED});
        }

        private Map<String, List<Term>> buildTerms(DeviceTemplate devT) {
            HashMap<String, List<Term>> ret = new HashMap<String, List<Term>>();
            for (Term term : devT.getTerms()) {
                APair t = VerilogSyntax.parseBusName((String)term.getNet().getName());
                if (t == null) continue;
                ret.computeIfAbsent((String)t.getFirst(), busName -> new LinkedList()).add(term);
            }
            return ret;
        }

        private List<Term> getDbTerms(DeviceTemplate childDevT, String childPortName) {
            LinkedList<Term> dbTerms;
            if (this.cache) {
                dbTerms = new LinkedList();
                Map busMap = this.mBusMap.computeIfAbsent(childDevT, this::buildTerms);
                if (busMap != null && busMap.containsKey(childPortName)) {
                    dbTerms.addAll((Collection)busMap.get(childPortName));
                }
            } else {
                dbTerms = AUtil.arrayList((Stream)Term.getBitIndexedTerms((DeviceTemplate)childDevT, (String)childPortName));
            }
            Term term = Term.get((DeviceTemplate)childDevT, (String)childPortName);
            if (term != null) {
                dbTerms.add(term);
            }
            return dbTerms;
        }

        public void close() {
            VerilogToDbProcessor.this.mDb.getDbClass(Term.class).removeObjectListener((DbClass.DbObjectListener)this.mTermListener, new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.ADDED, DbClass.DbObjectEventType.REMOVING, DbClass.DbObjectEventType.CHANGED});
            VerilogToDbProcessor.this.mDb.getDbClass(Net.class).removeObjectListener((DbClass.DbObjectListener)this.mNetListener, new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.CHANGED});
        }
    }

    private static interface TermVNodeDef {
        public List<Term> getTerms();
    }

    private static class TermBitVNodeDef
    implements TermVNodeDef {
        Term mTerm;

        protected TermBitVNodeDef(Term term) {
            this.mTerm = term;
        }

        @Override
        public List<Term> getTerms() {
            return AUtil.arrayList((Object[])new Term[]{this.mTerm});
        }
    }

    private static class TermBusVNodeDef
    implements TermVNodeDef {
        private final List<Term> mTerms;

        protected TermBusVNodeDef(List<Term> terms) {
            this.mTerms = terms;
        }

        @Override
        public List<Term> getTerms() {
            return this.mTerms;
        }
    }

    private static abstract class VNodeDef {
        String mPortName;

        protected VNodeDef(String portName) {
            this.mPortName = portName;
        }

        protected String getName() {
            return this.mPortName;
        }

        protected abstract List<Net> getNets();
    }

    private static class BitVNodeDef
    extends VNodeDef {
        Net mNet;

        protected BitVNodeDef(String portName, Net net) {
            super(portName);
            this.mNet = net;
        }

        @Override
        protected List<Net> getNets() {
            return AUtil.arrayList((Object[])new Net[]{this.mNet});
        }
    }

    private static class BusVNodeDef
    extends VNodeDef {
        private final int mMsb;
        private final int mLsb;
        private final List<Net> mNets;

        protected BusVNodeDef(String portName, int msb, int lsb, List<Net> nets) {
            super(portName);
            this.mMsb = msb;
            this.mLsb = lsb;
            this.mNets = nets;
        }

        @Override
        protected List<Net> getNets() {
            return this.mNets;
        }

        protected List<Net> getNets(int msb, int lsb) {
            if (!this.isSameOrderIndex(msb, lsb)) {
                ALog.flogError((String)"%s[%d:%d] is out of order.", (Object[])new Object[]{this.getName(), msb, lsb});
                return Collections.emptyList();
            }
            if (!this.isInRange(msb, lsb)) {
                ALog.flogError((String)"%s[%d:%d] is out of range.", (Object[])new Object[]{this.getName(), msb, lsb});
                return Collections.emptyList();
            }
            return this.mNets.subList(Math.abs(msb - this.mMsb), Math.abs(lsb - this.mMsb) + 1);
        }

        private boolean isSameOrderIndex(long msb, long lsb) {
            return this.mMsb >= this.mLsb && msb >= lsb || this.mMsb <= this.mLsb && msb <= lsb;
        }

        private boolean isInRange(long msb, long lsb) {
            long maxBit = Math.max(msb, lsb);
            long minBit = Math.min(msb, lsb);
            return this.getMinBit() <= minBit && maxBit <= this.getMaxBit();
        }

        private long getMaxBit() {
            return Math.max(this.mMsb, this.mLsb);
        }

        private long getMinBit() {
            return Math.min(this.mMsb, this.mLsb);
        }
    }

    private static class SliceOrNet {
        protected SliceInfo mSlice = null;
        protected String mNetName = null;

        public SliceOrNet(SliceInfo slice) {
            this.mSlice = slice;
        }

        public SliceOrNet(String netName) {
            this.mNetName = netName;
        }

        public boolean isSlice() {
            return this.mSlice != null;
        }

        public SliceInfo getSliceInfo() {
            return this.mSlice;
        }

        public String toString() {
            return String.format("%s(%s)", this.mSlice != null ? "Slice" : "Net", this.mSlice != null ? this.mSlice.toString() : this.mNetName);
        }

        public String getText() {
            return this.mSlice != null ? this.mSlice.getText() : this.mNetName;
        }
    }

    private static class SliceInfo {
        String mName;
        int mMsb;
        int mLsb;

        public SliceInfo(String name, int msb, int lsb) {
            this.mName = name;
            this.mMsb = msb;
            this.mLsb = lsb;
        }

        public String getName() {
            return this.mName;
        }

        public int getMsb() {
            return this.mMsb;
        }

        public int getLsb() {
            return this.mLsb;
        }

        public String getText() {
            return VerilogSyntax.formatNameSlice((String)this.mName, (int)this.mMsb, (int)this.mLsb);
        }

        public String toString() {
            return this.getText();
        }
    }

    private class V2DevTProcessor {
        private final AST mAstModule;
        private final DeviceTemplate mDevT;
        private List<String> mPortList;
        private Map<String, VNodeDef> mName2VNodeDef = new HashMap<String, VNodeDef>();
        private Map<String, TermVNodeDef> mName2TermVNodeDef = new HashMap<String, TermVNodeDef>();
        protected List<V2ChildDevProcessor> mV2ChildDevProcessors = new LinkedList<V2ChildDevProcessor>();
        protected List<Device> mSynthesizedDevices = new LinkedList<Device>();
        private AssignmentInfo mAssignmentInfos = new AssignmentInfo();

        public V2DevTProcessor(AST astModule, DeviceTemplate devT) {
            this.mAstModule = astModule;
            this.mDevT = devT;
        }

        public DeviceTemplate getDeviceTemplate() {
            return this.mDevT;
        }

        public String getModuleName() {
            return Verilog.getModuleName(this.mDevT);
        }

        public boolean isPort(String name) {
            return this.mPortList.contains(name);
        }

        public String getPortName(int index) {
            if (this.getPortSize() > index) {
                return this.mPortList.get(index);
            }
            return null;
        }

        public TermVNodeDef getTermPort(String name) {
            if (!this.isPort(name)) {
                ALog.flogError((String)"Port '%s' is not defined in the port list of module '%s'.", (Object[])new Object[]{name, this.getModuleName()});
            }
            return this.mName2TermVNodeDef.get(name);
        }

        private int getPortSize() {
            return this.mPortList.size();
        }

        public void processTemplate() {
            Antlr2Util.children(this.mAstModule).forEach(ast -> {
                switch (ast.getType()) {
                    case 169: {
                        this.updatePortList((AST)ast);
                        break;
                    }
                    case 168: {
                        this.updateNet((AST)ast);
                        break;
                    }
                    case 34: {
                        this.updatePortDirectionAndRange((AST)ast, Net.Direction.IN);
                        break;
                    }
                    case 35: {
                        this.updatePortDirectionAndRange((AST)ast, Net.Direction.OUT);
                        break;
                    }
                    case 36: {
                        this.updatePortDirectionAndRange((AST)ast, Net.Direction.INOUT);
                        break;
                    }
                    case 53: {
                        this.loadAssign((AST)ast);
                        break;
                    }
                    case 170: {
                        this.loadModuleInst((AST)ast);
                        break;
                    }
                }
            });
        }

        public void processChildInst() {
            this.updateChildern();
            if (!this.mSynthesizedDevices.isEmpty()) {
                ALog.flogInfo((String)"Synthesized %s child devices in '%s'.", (Object[])new Object[]{this.mSynthesizedDevices.size(), this.mDevT.getKeyStr()});
            }
        }

        public void processAssignment() {
            this.mAssignmentInfos.process();
        }

        public void processOverwrite() {
            this.removeNonDefinedChild();
            this.removeNonDefinedPortWire();
            this.processOverWriteChildDev();
        }

        private void updatePortList(AST ast) {
            this.mPortList = Antlr2Util.children(ast).filter(x$0 -> VerilogToDbProcessor.isVerilogIdentifier(x$0)).map(AST::getText).collect(Collectors.toList());
            this.mPortList.forEach(port -> this.mName2VNodeDef.put((String)port, (VNodeDef)null));
        }

        private void updatePortDirectionAndRange(AST literal, Net.Direction dir) {
            AST astNetType = literal.getFirstChild();
            List<String> portNames = Antlr2Util.nodeAndFollowingSiblings(astNetType).filter(x$0 -> VerilogToDbProcessor.isVerilogIdentifier(x$0)).map(AST::getText).collect(Collectors.toList());
            this.checkPortDefinition(portNames);
            if (astNetType != null && astNetType.getType() == 14) {
                AST astMsb = astNetType.getNextSibling();
                AST astLsb = astMsb.getNextSibling().getType() == 15 ? astMsb.getNextSibling().getNextSibling() : null;
                int msb = Integer.parseInt(astMsb.toString());
                int lsb = astLsb == null ? msb : Integer.parseInt(astLsb.toString());
                this.updateBusPort(dir, portNames, msb, lsb);
            } else {
                this.updatePort(portNames, dir);
            }
        }

        private void checkPortDefinition(List<String> portNames) {
            portNames.forEach(this::checkPortDefinition);
        }

        private void checkPortDefinition(String portName) {
            if (!this.isPort(portName)) {
                ALog.flogWarn((String)"Port '%s' declares in module '%s' does not define in the port list.", (Object[])new Object[]{portName, this.mDevT.getName()});
            }
        }

        private void updateBusPort(Net.Direction dir, String portName, int msb, int lsb) {
            Term.Type termType = Term.Type.get((Net.Direction)dir);
            List terms = (List)Term.getOrCreateTerms((DeviceTemplate)this.getDeviceTemplate(), (String)portName, (int)msb, (int)lsb).collect(Collectors.toList());
            terms.forEach(term -> term.setType(termType));
            this.mName2TermVNodeDef.put(portName, new TermBusVNodeDef(terms));
            ArrayList<Net> nets = new ArrayList<Net>(terms.size());
            for (Term term2 : terms) {
                Net net = term2.getNet();
                if (VerilogToDbProcessor.this.mIsOverwrite) {
                    net = term2.uniquifyNet();
                }
                net.setDirection(dir);
                nets.add(net);
            }
            this.mName2VNodeDef.put(portName, new BusVNodeDef(portName, msb, lsb, nets));
        }

        private void updatePort(String portName, Net.Direction dir) {
            Term.Type termType = Term.Type.get((Net.Direction)dir);
            Term term = Term.getOrCreateTerm((DeviceTemplate)this.getDeviceTemplate(), (String)portName);
            term.setType(termType);
            this.mName2TermVNodeDef.put(portName, new TermBitVNodeDef(term));
            Net net = term.getNet();
            if (VerilogToDbProcessor.this.mIsOverwrite) {
                net = term.uniquifyNet();
            }
            net.setDirection(dir);
            this.mName2VNodeDef.put(portName, new BitVNodeDef(portName, net));
        }

        private void updateBusPort(Net.Direction dir, List<String> portNames, int msb, int lsb) {
            portNames.forEach(portName -> this.updateBusPort(dir, (String)portName, msb, lsb));
        }

        private void updatePort(List<String> portNames, Net.Direction dir) {
            portNames.forEach(portName -> this.updatePort((String)portName, dir));
        }

        private void updateNet(AST astNet) {
            AST astNetType = astNet.getFirstChild();
            Antlr2Util.nodeAndFollowingSiblings(astNetType).filter(x$0 -> VerilogToDbProcessor.isVerilogIdentifier(x$0)).map(AST::getText).forEach(name -> this.updateNet((String)name, astNetType));
        }

        private void updateNet(String name, AST astNetType) {
            if (astNetType.getNextSibling().getType() == 14) {
                AST astMsb = astNetType.getNextSibling().getNextSibling();
                AST astLsb = astMsb.getNextSibling().getType() == 15 ? astMsb.getNextSibling().getNextSibling() : null;
                int msb = Integer.parseInt(astMsb.toString());
                int lsb = astLsb == null ? msb : Integer.parseInt(astLsb.toString());
                List nets = (List)VerilogToDbProcessor.getOrCreateNets(this.mDevT, name, msb, lsb).collect(Collectors.toList());
                this.classifyNetType(astNetType, nets);
                this.mName2VNodeDef.put(name, new BusVNodeDef(name, msb, lsb, nets));
                if (this.isPort(name)) {
                    this.classifyAsTerm(name, nets);
                }
            } else {
                Net net = VerilogToDbProcessor.getOrCreateNet(this.mDevT, name);
                ArrayList nets = AUtil.arrayList((Object[])new Net[]{net});
                this.classifyNetType(astNetType, nets);
                this.mName2VNodeDef.put(name, new BitVNodeDef(name, net));
                if (this.isPort(name)) {
                    this.classifyAsTerm(name, net);
                }
            }
        }

        private void classifyNetType(AST astNetType, List<Net> nets) {
            String netTypeStr = astNetType.getText();
            if (netTypeStr.equals(VerilogToDbProcessor.SUPPLY1_STRING)) {
                this.classifyAsPower(nets);
            } else if (netTypeStr.equals(VerilogToDbProcessor.SUPPLY0_STRING)) {
                this.classifyAsGround(nets);
            }
        }

        private void classifyAsGround(List<Net> nets) {
            String name = nets.get(0).getName();
            Personality personality = NetCommands.getPowerNetPersonality(this.mDevT, name);
            for (Net net : nets) {
                NetCommands.classifyAsGround(net, personality);
            }
        }

        private void classifyAsPower(List<Net> nets) {
            String name = nets.get(0).getName();
            Personality personality = NetCommands.getPowerNetPersonality(this.mDevT, name);
            for (Net net : nets) {
                NetCommands.classifyAsPower(net, personality);
            }
        }

        private void classifyAsTerm(String portName, List<Net> nets) {
            ArrayList<Term> terms = new ArrayList<Term>(nets.size());
            nets.forEach(net -> {
                Term term = this.getNetTerm((Net)net);
                terms.add(term);
            });
            this.mName2TermVNodeDef.put(portName, new TermBusVNodeDef(terms));
        }

        private void classifyAsTerm(String portName, Net net) {
            Term term = this.getNetTerm(net);
            this.mName2TermVNodeDef.put(portName, new TermBitVNodeDef(term));
        }

        private Term getNetTerm(Net net) {
            Term term = this.getDeviceTemplate().getTerm(net.getName());
            if (term == null) {
                term = Term.create((Net)net);
            } else if (term.getNet() != net) {
                term.setNet(net);
            }
            return term;
        }

        private void loadModuleInst(AST astModuleInst) {
            this.loadV2ChildDevProcessor(astModuleInst.getFirstChild());
        }

        private void loadV2ChildDevProcessor(AST astChildModule) {
            this.mV2ChildDevProcessors.add(new V2ChildDevProcessor(astChildModule));
        }

        private void loadAssign(AST ast) {
            AST astLhs = ast.getNextSibling();
            List<Net> lhs = this.getParentNets(astLhs);
            Optional<AST> optAstAssign = Antlr2Util.nodeOrFollowingSiblingOfType(astLhs, 20);
            if (optAstAssign.isPresent()) {
                AST astRhs = optAstAssign.get().getNextSibling();
                List<Net> rhs = this.getParentNets(astRhs);
                this.updateAssign(lhs, rhs);
            } else {
                ALog.logWarn((Throwable)new Exception(), (String)"Error processing assignment, it is being ignored: assign %s", (Object[])new Object[]{ast.getText()});
                assert (false);
            }
        }

        private void updateAssign(List<Net> lhs, List<Net> rhs) {
            assert (!lhs.isEmpty() && !rhs.isEmpty());
            Iterator<Net> lhsItr = lhs.iterator();
            Iterator<Net> rhsItr = rhs.iterator();
            while (lhsItr.hasNext() && rhsItr.hasNext()) {
                Net lhsNet = lhsItr.next();
                Net rhsNet = rhsItr.next();
                this.mAssignmentInfos.addNetGroup(lhsNet, rhsNet);
            }
        }

        private void updateChildern() {
            this.mV2ChildDevProcessors.forEach(V2ChildDevProcessor::process);
        }

        private void removeNonDefinedChild() {
            HashSet<Device> verilogChildern = new HashSet<Device>();
            for (V2ChildDevProcessor childProcessor : this.mV2ChildDevProcessors) {
                Device dev = childProcessor.getDevice();
                if (dev == null) continue;
                verilogChildern.add(dev);
            }
            DeviceTemplate devT = this.getDeviceTemplate();
            if (devT == null) {
                return;
            }
            for (Device dbChild : AUtil.arrayList((Iterator)devT.getChildren())) {
                if (verilogChildern.contains(dbChild) || !VerilogToDbProcessor.this.mIsOverwriteBump && dbChild.isBump()) continue;
                dbChild.deleteFromDb();
            }
        }

        private void removeNonDefinedPortWire() {
            this.removeNonDefinedPort();
            this.removeNonDefinedWire();
        }

        private void removeNonDefinedPort() {
            HashSet<Term> verilogPors = new HashSet<Term>();
            for (TermVNodeDef nodeDef : this.mName2TermVNodeDef.values()) {
                verilogPors.addAll(nodeDef.getTerms());
            }
            for (Term dbTerm : AUtil.arrayList((Iterator)this.getDeviceTemplate().getTerms())) {
                if (verilogPors.contains(dbTerm) || !VerilogToDbProcessor.this.mIsOverwritePG && dbTerm.isPowerGound()) continue;
                dbTerm.deleteFromDb();
            }
        }

        private void removeNonDefinedWire() {
            HashSet<Net> verilogPortWires = new HashSet<Net>();
            for (VNodeDef nodeDef : this.mName2VNodeDef.values()) {
                verilogPortWires.addAll(nodeDef.getNets());
            }
            ArrayList dbNets = AUtil.arrayList((Iterator)this.getDeviceTemplate().getNets());
            for (Net dbNet : dbNets) {
                if (verilogPortWires.contains(dbNet) || dbNet.isUnused() || !VerilogToDbProcessor.this.mIsOverwritePG && Net.isPowerNet((Net)dbNet)) continue;
                dbNet.deleteFromDb();
            }
        }

        private void processOverWriteChildDev() {
            this.mV2ChildDevProcessors.forEach(V2ChildDevProcessor::processOverwrite);
        }

        private List<Net> getParentNets(AST astParent) {
            if (astParent.getType() == 12) {
                return this.getConcatenationParentNets(astParent);
            }
            return this.getNonConcatenationParentNets(astParent);
        }

        private List<Net> getNonConcatenationParentNets(AST astParent) {
            SliceOrNet parentNode = VerilogToDbProcessor.getSliceOrNet(astParent);
            List parentNets = this.getNets(parentNode);
            if (parentNets.isEmpty()) {
                parentNets = (List)VerilogToDbProcessor.getOrCreateNets(this.mDevT, parentNode).collect(Collectors.toList());
            }
            return parentNets;
        }

        private List<Net> getConcatenationParentNets(AST astParent) {
            LinkedList<Net> parentNets = new LinkedList<Net>();
            AST curAst = astParent;
            while (curAst.getType() != 13) {
                List<Net> curParentNets = this.getNonConcatenationParentNets(curAst.getNextSibling());
                parentNets.addAll(curParentNets);
                Optional<AST> optAstNext = Antlr2Util.nodeOrFollowingSiblingOfType(curAst.getNextSibling(), 9, 13);
                if (optAstNext.isPresent()) {
                    curAst = optAstNext.get();
                    continue;
                }
                assert (false);
            }
            return parentNets;
        }

        private List<Net> getNets(SliceOrNet sliceOrNet) {
            if (sliceOrNet.isSlice()) {
                return this.getNets(sliceOrNet.getSliceInfo());
            }
            return this.getNetsOfNode(sliceOrNet.getText());
        }

        private List<Net> getNets(SliceInfo sliceInfo) {
            String nodeName = sliceInfo.getName();
            VNodeDef vNodeDef = this.mName2VNodeDef.get(nodeName);
            if (vNodeDef instanceof BusVNodeDef) {
                BusVNodeDef busVNodeDef = (BusVNodeDef)vNodeDef;
                return busVNodeDef.getNets(sliceInfo.getMsb(), sliceInfo.getLsb());
            }
            ALog.flogError((String)"Cannot select part of scalar '%s' in '%s'", (Object[])new Object[]{sliceInfo.getText(), this.mDevT.getName()});
            return Collections.emptyList();
        }

        private List<Net> getNetsOfNode(String nodeName) {
            VNodeDef vNodeDef = this.mName2VNodeDef.get(nodeName);
            if (vNodeDef == null) {
                return Collections.emptyList();
            }
            return vNodeDef.getNets();
        }

        private class AssignmentInfo {
            private List<List<Net>> netGroups = new LinkedList<List<Net>>();
            private Map<Net, List<Net>> net2Group = new HashMap<Net, List<Net>>();

            private AssignmentInfo() {
            }

            public void process() {
                this.netGroups.forEach(this::updatePortAssign);
            }

            private void updatePortAssign(List<Net> group) {
                Collections.sort(group, WireFirstThenNameComparator);
                Net newNet = group.get(0);
                group.forEach(oldNet -> {
                    if (oldNet != newNet) {
                        newNet.mergeAndDelete(oldNet);
                    }
                });
                Term namedTerm = V2DevTProcessor.this.getDeviceTemplate().getTerm(newNet.getName());
                if (namedTerm != null) {
                    assert (namedTerm.getNet() == newNet);
                    newNet.syncAttribute(namedTerm);
                }
            }

            public void addNetGroup(Net net1, Net net2) {
                List<Net> group1 = this.net2Group.get(net1);
                List<Net> group2 = this.net2Group.get(net2);
                if (group1 != null && group2 != null) {
                    group1.addAll(group2);
                    group1.add(net2);
                    this.net2Group.put(net2, group1);
                    this.netGroups.remove(group2);
                } else if (group1 == null && group2 != null) {
                    group2.add(net1);
                    this.net2Group.put(net1, group2);
                } else if (group1 != null) {
                    group1.add(net2);
                    this.net2Group.put(net2, group1);
                } else {
                    LinkedList group = AUtil.linkedList((Object[])new Net[]{net1, net2});
                    this.netGroups.add(group);
                    this.net2Group.put(net1, group);
                    this.net2Group.put(net2, group);
                }
            }
        }

        private class V2ChildDevProcessor {
            protected AST mAstChildModule;
            protected V2DevTProcessor mV2ChildDevTProcessor;
            protected Device mChild;
            private Set<Term> mProcessedPorts = new HashSet<Term>();

            public V2ChildDevProcessor(AST astChildModule) {
                this.mAstChildModule = astChildModule;
            }

            public void process() {
                this.updateChildDev();
                this.updatePortConnections();
            }

            public Device getDevice() {
                return this.mChild;
            }

            public void processOverwrite() {
                this.upmapNonProcessedPort();
            }

            private void updateChildDev() {
                String childModuleName = this.mAstChildModule.getText();
                AST astChildDevice = this.mAstChildModule.getNextSibling();
                String childName = astChildDevice.getText();
                this.mChild = V2DevTProcessor.this.mDevT.getChild(childName);
                if (this.mChild == null) {
                    this.mChild = this.createChildDev(childName);
                } else if (!this.mChild.getTemplate().getName().equals(childModuleName)) {
                    ALog.flogError((String)"Child '%s' of '%s' is defined as module '%s' in the verilog, but have different device template '%s' in the current design.", (Object[])new Object[]{childName, V2DevTProcessor.this.mDevT.getName(), childModuleName, this.mChild.getTemplate().getName()});
                    this.mChild = null;
                }
                if (this.mChild != null) {
                    this.mV2ChildDevTProcessor = VerilogToDbProcessor.this.mDevT2Processor.get(this.mChild.getTemplate());
                }
            }

            private Device createChildDev(String childName) {
                String childTemplateName;
                Substrate parentSubstrate = V2DevTProcessor.this.mDevT.getSubstrate();
                DeviceTemplate childDevT = parentSubstrate.getDeviceTemplate(childTemplateName = this.mAstChildModule.getText());
                if (childDevT == null) {
                    childDevT = DeviceTemplate.get((Db)VerilogToDbProcessor.this.mDb, (String)VerilogToDbProcessor.this.getDefaultSubstrateName(), (String)childTemplateName);
                }
                if (childDevT == null) {
                    childDevT = Verilog.getDevTsWithName(VerilogToDbProcessor.this.mDb, childTemplateName).ifExactlyOne().orElse(null);
                }
                if (childDevT == null) {
                    if (VerilogToDbProcessor.this.mSynthesizeChildTemplates) {
                        childDevT = this.createDeviceTemplate(childTemplateName, childName);
                    } else {
                        ALog.logWarn((String)"DeviceTemplate '%s' does not have a child '%s' and unable to find DeviceTemplate '%s' to create the child. The MODULE instance is being ignored.", (Object[])new Object[]{V2DevTProcessor.this.mDevT.getKeyStr(), childName, childTemplateName});
                        return null;
                    }
                }
                Device newDevice = Device.create((String)childName, (DeviceTemplate)childDevT, (DeviceTemplate)V2DevTProcessor.this.mDevT);
                newDevice.setIsPlaced(false);
                newDevice.moveToClearArea();
                V2DevTProcessor.this.mSynthesizedDevices.add(newDevice);
                return newDevice;
            }

            private DeviceTemplate createDeviceTemplate(String devTName, String deviceName) {
                Substrate substrate = V2DevTProcessor.this.mDevT.getSubstrate();
                assert (DeviceTemplate.getDeviceTemplate((Substrate)substrate, (String)devTName) == null);
                DeviceTemplate compLibDevT = this.getCompLibDevT(substrate, devTName, deviceName);
                if (compLibDevT != null) {
                    return compLibDevT;
                }
                DeviceTemplate devT = DeviceTemplate.create((Substrate)substrate, (String)devTName, (boolean)false);
                devT.setIsSynthesized(true);
                ALog.flogInfo((String)"Synthesized DeviceTemplate '%s' for Substrate '%s'.", (Object[])new Object[]{devTName, substrate.getName()});
                return devT;
            }

            private DeviceTemplate getCompLibDevT(Substrate substrate, String devTName, String deviceName) {
                if (VerilogToDbProcessor.this.mCompLib == null) {
                    return null;
                }
                List portNames = this.getAstPortConnection().filter(ast -> ast.getFirstChild() != null).map(ast -> ast.getFirstChild().getText()).collect(Collectors.toList());
                long numPorts = this.getAstPortConnection().count();
                return VerilogToDbProcessor.this.mCompLib.getComponent(new ComponentLibrary.Spec[]{ComponentLibrary.Spec.verilogName((String)devTName), ComponentLibrary.Spec.targetSubstrateName((String)substrate.getName()), ComponentLibrary.Spec.deviceName((String)deviceName), ComponentLibrary.Spec.numberOfPorts((Long)numPorts), ComponentLibrary.Spec.portNames(portNames)}).map(ComponentLibrary.CompDesc::getDeviceTemplate).orElse(null);
            }

            private void updatePortConnections() {
                if (this.mChild == null) {
                    return;
                }
                AST astPortConnections = this.mAstChildModule.getNextSibling().getNextSibling();
                assert (astPortConnections.getType() == 171);
                int portConnectionType = astPortConnections.getFirstChild().getType();
                if (portConnectionType == 173) {
                    this.updateNamedPortConnections();
                } else if (portConnectionType == 172) {
                    this.updatePortConnectionList();
                } else assert (false);
            }

            private void updatePortConnectionList() {
                List astParents = this.getAstPortConnection().collect(Collectors.toList());
                int parentPortSize = astParents.size();
                int childPortSize = this.getChildPortSize();
                if ((astParents.size() != 1 || ((AST)astParents.get(0)).getFirstChild() != null) && childPortSize != parentPortSize) {
                    ALog.flogError((String)"Wrong number of ports for child '%s' in module '%s'. Expecting %d, got %d.", (Object[])new Object[]{this.mChild.getName(), V2DevTProcessor.this.getModuleName(), childPortSize, parentPortSize});
                    return;
                }
                for (int index = 0; index != parentPortSize; ++index) {
                    assert (astParents.get(index) != null && ((AST)astParents.get(index)).getType() == 172);
                    AST astParent = ((AST)astParents.get(index)).getFirstChild();
                    String childName = this.getChildPortName(index);
                    if (astParent == null && childName != null) {
                        this.unmapChildPort(childName);
                        continue;
                    }
                    if (childName == null) continue;
                    this.updatePortConnections(astParent, childName);
                }
            }

            private Stream<AST> getAstPortConnection() {
                AST astPortConnections = this.mAstChildModule.getNextSibling().getNextSibling();
                assert (astPortConnections.getType() == 171);
                return Antlr2Util.children(astPortConnections);
            }

            private String getChildPortName(int index) {
                if (this.mV2ChildDevTProcessor == null) {
                    return null;
                }
                return this.mV2ChildDevTProcessor.getPortName(index);
            }

            private int getChildPortSize() {
                if (this.mV2ChildDevTProcessor == null) {
                    return 0;
                }
                return this.mV2ChildDevTProcessor.getPortSize();
            }

            private void updateNamedPortConnections() {
                this.getAstPortConnection().forEach(ast -> {
                    assert (ast.getType() == 173);
                    AST astChildPort = ast.getFirstChild();
                    if (astChildPort == null) {
                        assert (false);
                        ALog.flogError((String)"Invalid named port connection (no port name specified)%s", (Object[])new Object[]{ast.getLine() == 0 ? "." : String.format(" near line %d.", ast.getLine())});
                        return;
                    }
                    String childName = astChildPort.getText();
                    AST astParent = astChildPort.getFirstChild();
                    if (astParent == null) {
                        this.checkChildPort(childName);
                        this.unmapChildPort(childName);
                        return;
                    }
                    this.updatePortConnections(astParent, childName);
                });
            }

            private void checkChildPort(String astChildPort) {
                if (this.mV2ChildDevTProcessor == null) {
                    this.makeChildPortExist(astChildPort);
                } else {
                    this.checkChildPortExit(astChildPort);
                }
            }

            protected void makeChildPortExist(String portName) {
                if (this.getChildTerms(portName).isEmpty()) {
                    Term.create((String)portName, (DeviceTemplate)this.mChild.getTemplate());
                }
            }

            private void checkChildPortExit(String portName) {
                if (!this.mV2ChildDevTProcessor.isPort(portName)) {
                    ALog.flogError((String)"Port '%s' of child '%s' in '%s' is not defined in port list of module '%s'", (Object[])new Object[]{portName, this.mChild.getName(), V2DevTProcessor.this.getModuleName(), this.mV2ChildDevTProcessor.getModuleName()});
                }
            }

            protected void unmapChildPort(String portName) {
                for (Term term : this.getChildTerms(portName)) {
                    TermMap.unmap((Device)this.mChild, (Term)term);
                }
            }

            private List<Term> getChildTerms(String childPortName) {
                return this.getChildTerms(childPortName, 0, false);
            }

            private List<Term> getChildTerms(String childPortName, int numBitParent, boolean isCreate) {
                if (this.mV2ChildDevTProcessor == null) {
                    List<Term> dbTerms = this.getDbTerms(childPortName);
                    if (!dbTerms.isEmpty() || !isCreate) {
                        return dbTerms;
                    }
                    if (numBitParent > 1) {
                        return (List)Term.getOrCreateTerms((DeviceTemplate)this.mChild.getTemplate(), (String)childPortName, (int)(numBitParent - 1), (int)0).collect(Collectors.toList());
                    }
                    return AUtil.arrayList((Object[])new Term[]{Term.getOrCreateTerm((DeviceTemplate)this.mChild.getTemplate(), (String)childPortName)});
                }
                TermVNodeDef childVNodeDef = this.mV2ChildDevTProcessor.getTermPort(childPortName);
                return childVNodeDef == null ? Collections.emptyList() : childVNodeDef.getTerms();
            }

            private List<Term> getDbTerms(String childPortName) {
                return VerilogToDbProcessor.this.mTermTable.getDbTerms(this.mChild.getTemplate(), childPortName);
            }

            private void updatePortConnections(AST astParent, String childName) {
                List<Net> parentNets = V2DevTProcessor.this.getParentNets(astParent);
                this.updatePortConnection(parentNets, childName);
            }

            private void updatePortConnection(List<Net> parentNets, String childName) {
                List<Term> childTerms;
                int numBitChild;
                int numBitParent = parentNets.size();
                if (numBitParent != (numBitChild = (childTerms = this.getOrCreateChildTerms(childName, numBitParent)).size())) {
                    ALog.logWarn((String)"Port '%s' of %s has %d bit, connect to %d bit in %s", (Object[])new Object[]{childName, this.mChild.getName(), numBitChild, numBitParent, V2DevTProcessor.this.getModuleName()});
                }
                this.mapTerms(parentNets, childTerms);
                this.addProcessedPorts(childTerms);
            }

            private List<Term> getOrCreateChildTerms(String childPortName, int numBitParent) {
                return this.getChildTerms(childPortName, numBitParent, true);
            }

            private void mapTerms(List<Net> parentNets, List<Term> childTerms) {
                Iterator<Net> parentNetItr = parentNets.iterator();
                Iterator<Term> childTermItr = childTerms.iterator();
                while (parentNetItr.hasNext() && childTermItr.hasNext()) {
                    Net parentNet = parentNetItr.next();
                    Term childTerm = childTermItr.next();
                    TermMap.mapChildTerm((Device)this.mChild, (Term)childTerm, (Net)parentNet);
                }
                while (childTermItr.hasNext()) {
                    Term childNet = childTermItr.next();
                    TermMap.unmap((Device)this.mChild, (Term)childNet);
                }
            }

            private void upmapNonProcessedPort() {
                for (Term childTerm : this.getDevice().getTerms()) {
                    Net parentNet;
                    if (this.isProcessed(childTerm) || !VerilogToDbProcessor.this.mIsOverwritePG && childTerm.isPowerGound() || (parentNet = TermMap.getParentNet((Device)this.getDevice(), (Term)childTerm)) == null || !VerilogToDbProcessor.this.mIsOverwritePG && Net.isPowerNet((Net)parentNet)) continue;
                    TermMap.unmap((Device)this.getDevice(), (Term)childTerm);
                }
            }

            private boolean isProcessed(Term childPort) {
                return this.mProcessedPorts.contains(childPort);
            }

            private void addProcessedPorts(List<Term> terms) {
                this.mProcessedPorts.addAll(terms);
            }
        }
    }
}

