/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.verilog;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.verilog.CallTree;
import com.sigrity.orbit.verilog.Verilog;
import com.sigrity.orbit.verilog.VerilogToCallTree;

public class VerilogToTemplates {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synDesign(String filePath, String substrateName) {
        Db db = OrbitIO.getCurDb();
        db.setHistoryEnabled(false);
        try {
            CallTree ct = new CallTree();
            Verilog.parseFile(filePath, new VerilogToCallTree(db, ct));
            ct.synDB(Substrate.getSubstrate((Db)OrbitIO.getCurDb(), (String)substrateName), filePath);
        }
        finally {
            db.setHistoryEnabled(true);
        }
    }

    public static void makeASuperPad(String substrateName, String templateName) {
        DeviceTemplate dt = DeviceTemplate.get((Db)OrbitIO.getCurDb(), (String)substrateName, (String)templateName);
        if (dt == null) {
            ALog.logWarn((String)(templateName + " is not a template on " + substrateName));
            return;
        }
        dt.setType(DeviceTemplate.Type.PAD);
        dt.setValue("LEFDEF.ignoreOnWrite", (Object)true);
        for (Device child : dt.getChildren()) {
            if (!child.getTemplate().getSourceType().equals((Object)DeviceTemplate.SourceType.VERILOG)) continue;
            child.getTemplate().setValue("LEFDEF.ignoreOnWrite", (Object)true);
        }
        for (Device child : dt.getChildren()) {
            if (!child.getTemplate().getType().equals((Object)DeviceTemplate.Type.PAD)) continue;
            dt.setBounds((AGeom)new ARect(child.getTemplate().getBB()));
            break;
        }
        for (Device child : dt.getChildren()) {
            for (PinTemplate pt : child.getTemplate().getPins()) {
                Net childNet;
                Net parentNet;
                String userFunction = pt.getUserFunction();
                if (userFunction == null || userFunction.isEmpty() || (parentNet = NetMap.getParentNet((Device)child, (Net)(childNet = pt.getNet()))) == null) continue;
                for (PinTemplate parentPin : dt.getPins()) {
                    if (!parentPin.getNet().equals(parentNet)) continue;
                    parentPin.setUserFunction(userFunction);
                }
            }
        }
    }
}

