/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.vhdl;

import antlr.TokenStreamException;
import antlr.collections.AST;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.orbit.verilog.CallTree;
import com.sigrity.orbit.vhdl.Vhdl;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DefaultVhdlTreeHandler
implements Vhdl.VhdlTreeHandler {
    protected Db mDb;
    protected CallTree mCallTree;
    protected HashMap<String, Entity> mEntities = new HashMap();
    protected HashMap<String, VhdlPackage> mPackages = new HashMap();
    protected ArrayList<ArrayList<String>> mLibraryes = new ArrayList();

    public DefaultVhdlTreeHandler(Db db, CallTree callTree) {
        this.mDb = db;
        this.mCallTree = callTree;
    }

    @Override
    public void print() {
        this.mCallTree.print();
    }

    @Override
    public void show() {
        this.mCallTree.show();
    }

    @Override
    public void mkDesign(AST tDesign) {
        this.mLibraryes.clear();
        for (AST c = tDesign.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (c.getType() == 154) {
                this.mkLibrary(c);
                continue;
            }
            if (c.getType() == 68) {
                this.mkPackage(c);
                continue;
            }
            if (c.getType() != 65) continue;
            this.mkEntity(c);
        }
    }

    protected void mkLibrary(AST tLibrary) {
        ArrayList<String> path = new ArrayList<String>();
        this.mLibraryes.add(path);
        for (AST l = tLibrary.getFirstChild(); l != null; l = l.getNextSibling()) {
            if (l.toString().equals(".")) continue;
            path.add(l.toString().toUpperCase());
        }
    }

    protected void mkPackage(AST tPackage) {
        VhdlPackage pkg = this.createNode(VhdlPackage.class, tPackage, null);
        if (pkg == null) {
            return;
        }
        this.mPackages.put(pkg.getName(), pkg);
        for (AST c = tPackage.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (c.getType() != 50) continue;
            this.componentInst(c, pkg);
        }
    }

    protected void mkEntity(AST tEntity) {
        Entity entity = this.createNode(Entity.class, tEntity, null);
        if (entity == null) {
            return;
        }
        this.mEntities.put(entity.getName(), entity);
        for (AST c = tEntity.getNextSibling(); c != null; c = c.getNextSibling()) {
            if (c.getType() != 24) continue;
            this.architectureInst(c, entity);
        }
    }

    protected void architectureInst(AST tArch, Entity entity) {
    }

    protected void componentInst(AST tComponent, VhdlNetNodeDeclare arch) {
        Component c = this.createNode(Component.class, tComponent, arch);
        if (c == null) {
            return;
        }
        CallTree.TemplateNode node = this.mCallTree.insert(c.getName());
        node.setAChild(true);
    }

    protected void moduleInst(Architecture arch, DeviceTemplate dt, AST tModuleInst) {
    }

    protected Component findComponent(Architecture arch, String n) {
        Component c;
        HashMap<String, Component> l = arch.mComponents;
        if (l != null && (c = l.get(n)) != null) {
            return c;
        }
        for (ArrayList<String> p : this.mLibraryes) {
            Component c2;
            if (p.size() < 2) continue;
            String k1 = p.get(p.size() - 2);
            String k2 = p.get(p.size() - 1);
            VhdlPackage pkg = this.mPackages.get(k1);
            if (pkg == null || !k2.equals("ALL") && !k2.equals(n) || (c2 = pkg.mComponents.get(n)) == null) continue;
            return c2;
        }
        return null;
    }

    protected <T extends VhdlNetNodeDeclare> T createNode(Class<T> cls, AST tNode, VhdlNetNodeDeclare parent) {
        VhdlNetNodeDeclare obj = null;
        try {
            Constructor<T> ct = cls.getDeclaredConstructor(DefaultVhdlTreeHandler.class, AST.class, VhdlNetNodeDeclare.class);
            assert (ct != null);
            obj = (VhdlNetNodeDeclare)ct.newInstance(this, tNode, parent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)obj;
    }

    protected class Component
    extends VhdlNetNodeDeclare {
        protected Component(AST tComponent, VhdlNetNodeDeclare parent) throws TokenStreamException {
            super(tComponent, parent);
            if (parent != null) {
                if (parent instanceof VhdlPackage) {
                    ((VhdlPackage)parent).mComponents.put(this.getName(), this);
                } else if (parent instanceof Architecture) {
                    ((Architecture)parent).mComponents.put(this.getName(), this);
                }
            }
        }
    }

    protected class VhdlPackage
    extends VhdlNetNodeDeclare {
        protected HashMap<String, Component> mComponents;

        protected VhdlPackage(AST tPackage, VhdlNetNodeDeclare parent) throws TokenStreamException {
            super(parent);
            this.mComponents = new HashMap();
            AST c = tPackage.getFirstChild();
            if (c == null) {
                throw new TokenStreamException();
            }
            this.mName = c.toString().toUpperCase();
        }
    }

    protected class Architecture
    extends VhdlNetNodeDeclare {
        protected HashMap<String, Component> mComponents;

        protected Architecture(AST tArch, VhdlNetNodeDeclare parent) throws TokenStreamException {
            super(parent);
            this.mComponents = new HashMap();
            AST c = tArch.getFirstChild();
            this.mName = c.toString().toUpperCase();
            String en = c.getNextSibling().toString().toUpperCase();
            Entity entity = DefaultVhdlTreeHandler.this.mEntities.get(en);
            if (entity == null || !en.equals(parent.getName())) {
                throw new TokenStreamException();
            }
            Iterator<String> itr = entity.getPorts();
            while (itr.hasNext()) {
                this.mPorts.add(itr.next());
            }
            if (parent instanceof Entity) {
                Entity e = (Entity)parent;
                e.mArchs.put(this.mName, this);
            }
        }
    }

    protected class Entity
    extends VhdlNetNodeDeclare {
        protected HashMap<String, Architecture> mArchs;

        protected Entity(AST tEntity, VhdlNetNodeDeclare parent) throws TokenStreamException {
            super(tEntity, parent);
            this.mArchs = new HashMap();
        }
    }

    protected class VhdlNetNodeDeclare {
        protected ArrayList<String> mPorts = new ArrayList();
        protected VhdlNetNodeDeclare mParent = null;
        protected String mName;

        protected VhdlNetNodeDeclare(AST tNode, VhdlNetNodeDeclare parent) throws TokenStreamException {
            this(parent);
            AST c = tNode.getFirstChild();
            if (c == null) {
                throw new TokenStreamException();
            }
            this.mName = c.toString().toUpperCase();
            for (c = c.getNextSibling(); c != null; c = c.getNextSibling()) {
                if (c.getType() != 118) continue;
                for (AST cl = c.getFirstChild(); cl != null; cl = cl.getNextSibling()) {
                    String portName = cl.toString();
                    if (portName.equals(",")) continue;
                    this.mPorts.add(cl.toString().toUpperCase());
                }
            }
        }

        protected VhdlNetNodeDeclare(VhdlNetNodeDeclare parent) {
            this.mParent = parent;
        }

        public Iterator<String> getPorts() {
            return this.mPorts.iterator();
        }

        public String getName() {
            return this.mName;
        }

        public VhdlNetNodeDeclare getParent() {
            return this.mParent;
        }

        public void dump() {
            System.out.println("\n\tClass : " + this.getClass());
            System.out.println("\tName : " + this.mName);
            System.out.println("\tPorts :");
            for (String s : this.mPorts) {
                System.out.println("\t\t" + s);
            }
        }
    }
}

