/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.vhdl;

import antlr.RecognitionException;
import antlr.collections.AST;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.verilog.CallTree;
import com.sigrity.orbit.vhdl.DefaultVhdlTreeHandler;
import com.sigrity.orbit.vhdl.VhdlLexer;
import com.sigrity.orbit.vhdl.VhdlParser;
import com.sigrity.orbit.vhdl.VhdlTreeParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class Vhdl {
    protected static VhdlTreeHandler mTh = null;
    static BiMap<VhdlTreeParser, VhdlTreeHandler> sTreeHandler2TreeParser = HashBiMap.create();

    public static void importFile(String fileName, CallTree ct) {
        Db db = OrbitIO.getCurDb();
        File f = new File(fileName);
        DefaultVhdlTreeHandler th = new DefaultVhdlTreeHandler(db, ct);
        Vhdl v = new Vhdl(th);
        v.importFile(f);
    }

    public static void design(VhdlTreeParser vtp, AST tDesign) {
        ((VhdlTreeHandler)sTreeHandler2TreeParser.get((Object)vtp)).mkDesign(tDesign);
    }

    public Vhdl(VhdlTreeHandler th) {
        mTh = th;
    }

    public void importFile(File f) {
        FileInputStream is;
        try {
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            ALog.logError((String)"File '%s' not found.", (Object[])new Object[]{f.getPath()});
            return;
        }
        VhdlLexer lexer = new VhdlLexer(is);
        VhdlParser parser2 = new VhdlParser(lexer);
        ALog.logInfo((String)"Parsing Vhdl file '%s'.", (Object[])new Object[]{f.getPath()});
        try {
            parser2.design();
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Error parsing Vhdl file '%s'.", (Object[])new Object[]{f.getPath()});
            return;
        }
        AST treeRoot = parser2.getAST();
        VhdlTreeParser treeParser = new VhdlTreeParser();
        sTreeHandler2TreeParser.put((Object)treeParser, (Object)mTh);
        try {
            treeParser.parse(treeRoot);
        }
        catch (RecognitionException e) {
            ALog.logError((Throwable)e, (String)"Error parsing hierarchy for Vhdl file '%s'.", (Object[])new Object[]{f.getPath()});
        }
        sTreeHandler2TreeParser.remove((Object)treeParser);
    }

    private static void dump(AST ast) {
        System.out.println(ast.getText());
        System.out.println(ast.getType());
        if (ast.getFirstChild() != null) {
            Vhdl.dump(ast.getFirstChild());
        }
        if (ast.getNextSibling() != null) {
            Vhdl.dump(ast.getNextSibling());
        }
    }

    protected static interface VhdlTreeHandler {
        public void mkDesign(AST var1);

        public void print();

        public void show();
    }
}

