/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.priv;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewDlg;
import com.sigrity.orbit.ui.PersonalityUI;
import java.util.ArrayList;

public class ScanStitching {
    public static void doItNow(String diePathString) {
        ScanStitching ss = new ScanStitching();
        IOViewDlg.create(OrbitIO.getMainWindow(), OrbitIO.getCurView(), diePathString);
        ss.go(diePathString);
        Db db = OrbitIO.getCurDb();
        Net.deleteImmaterialNets((Db)db, (boolean)true);
    }

    public void go(String diePathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath diePath = DevicePath.fromString((Db)db, (String)diePathString);
        if (diePath == null) {
            ALog.logWarn((String)(diePath + " does not exist"));
        }
        ALog.logInfo((String)"Executing ScanStitching: stitches the TDO-TDI of BSCAN chain, TDO-TDI of IO UDR chain, renames to SCAN muxing netnames");
        DeviceTemplate devTemp = diePath.getLast().getTemplate();
        String bs_name = "bscan";
        String us_name = "ioudr";
        Personality p_bs = Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.NET, (String)bs_name);
        Personality p_us = Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.NET, (String)us_name);
        PersonalityUI.removeNetsFromPersonality(p_bs.getKeyStr());
        PersonalityUI.removeNetsFromPersonality(p_us.getKeyStr());
        ArrayList<DevicePath> orderedDevices_bscan = this.deriveOrderedDevices(diePath, "bscan");
        ALog.logInfo((String)"");
        ALog.logInfo((String)"BSCAN IO Cell Sequence");
        ALog.logInfo((String)"======================");
        this.printDevices(orderedDevices_bscan);
        this.stitchDevices(orderedDevices_bscan, p_bs, "bscan");
        ArrayList<DevicePath> orderedDevices_ioudr = this.deriveOrderedDevices(diePath, "ioudr");
        ALog.logInfo((String)"IO_UDR IO Cell Sequence");
        ALog.logInfo((String)"=======================");
        this.printDevices(orderedDevices_ioudr);
        this.stitchDevices(orderedDevices_ioudr, p_us, "ioudr");
        ArrayList<DevicePath> orderedDevices_scan = this.deriveOrderedDevices(diePath, "scan");
        ALog.logInfo((String)"SCAN Muxing IO Cell Sequence");
        ALog.logInfo((String)"============================");
        this.renameScanNetsToBussed(orderedDevices_scan);
        ALog.logInfo((String)"DONE Executing ScanStiching");
    }

    protected void stitchDevices(ArrayList<DevicePath> list, Personality personality, String mode) {
        String InterfaceName;
        DevicePath tdiPath = list.get(0);
        Device tdi = tdiPath.getLast();
        DeviceTemplate tdiTemplate = tdi.getTemplate();
        PinTemplate p = tdiTemplate.getPinByName("CIN");
        String lastInterfaceName = InterfaceName = tdiPath.getParent().getLast().getName();
        Object lastNetName = "ci_TDI_CIN";
        DevicePath lastPath = tdiPath;
        if (tdiPath.getString().contains("LCore")) {
            lastNetName = "ciw_TDI_CIN";
        }
        NetMap.mapThroughPath((DevicePath)tdiPath, (Net)p.getNet(), (String)lastNetName);
        p.getNet().assignToPersonality(personality, tdiPath);
        int length = list.size();
        int i = 0;
        Net lastNet = null;
        int j = 1;
        String chainName = "null";
        String TDI_PinName = "null";
        String TDO_PinName = "null";
        String finalTDONetnameToCore = "null";
        String finalTDONetnameToCoreEmbedded = "null";
        if ("bscan".equals(mode)) {
            chainName = "bs_chain_";
            TDI_PinName = "BSCAN_TDI";
            TDO_PinName = "BSCAN_TDO";
            finalTDONetnameToCore = "ji_tdo_bscan_last";
            finalTDONetnameToCoreEmbedded = "jiw_tdo_bscan_last";
        } else if ("ioudr".equals(mode)) {
            chainName = "us_chain_";
            TDI_PinName = "IO_UDR_TDI";
            TDO_PinName = "IO_UDR_TDO";
            finalTDONetnameToCore = "ji_tdo_ioudr_last";
            finalTDONetnameToCoreEmbedded = "jiw_tdo_ioudr_last";
        }
        for (i = 1; i < length - 1; ++i) {
            tdiPath = list.get(i);
            InterfaceName = tdiPath.getParent().getLast().getName();
            Net inputNet = tdiPath.getLast().getTemplate().getPinByName(TDI_PinName).getNet();
            DevicePath interfacePath = new DevicePath(tdiPath);
            interfacePath.removeFirst();
            if (interfacePath.getString().contains("LCore")) {
                interfacePath.removeFirst();
            }
            if (lastPath.getParent().equals((Object)tdiPath.getParent())) {
                NetMap.mapThroughPath((DevicePath)interfacePath, (Net)inputNet, (String)lastNetName);
                inputNet.assignToPersonality(personality, interfacePath);
                ++j;
            } else {
                j = 1;
                if (!(((String)lastNetName).endsWith("_TDI_CIN") || ((String)lastNetName).contains("_tdo_bscan_last") || ((String)lastNetName).contains("_tdo_ioudr_last"))) {
                    lastNetName = chainName + lastInterfaceName + "_to_" + InterfaceName;
                }
                String interfaceChainInName = "bscan".equals(mode) ? "bs_chain_TDI" : "us_chain_TDI";
                String interfaceChainOutName = "bscan".equals(mode) ? "bs_chain_TDO" : "us_chain_TDO";
                this.mapThroughPathSplitNameAtTemplate(tdiPath, inputNet, tdiPath.getParent().getDeviceTemplate(), interfaceChainInName, (String)lastNetName);
                if (lastNet != null) {
                    this.mapThroughPathSplitNameAtTemplate(lastPath, lastNet, lastPath.getParent().getDeviceTemplate(), interfaceChainOutName, (String)lastNetName);
                }
                inputNet.assignToPersonality(personality, tdiPath);
            }
            lastNetName = chainName + j + "_" + InterfaceName;
            Net outputNet = tdiPath.getLast().getTemplate().getPinByName(TDO_PinName).getNet();
            NetMap.mapThroughPath((DevicePath)interfacePath, (Net)outputNet, (String)lastNetName);
            outputNet.assignToPersonality(personality, interfacePath);
            lastPath = tdiPath;
            lastNet = outputNet;
            lastInterfaceName = InterfaceName;
        }
        tdiPath = list.get(length - 2);
        Device tdo = tdiPath.getLast();
        DeviceTemplate tdoTemplate = tdo.getTemplate();
        p = tdoTemplate.getPinByName(TDO_PinName);
        if (tdiPath.getString().contains("LCore")) {
            finalTDONetnameToCore = finalTDONetnameToCoreEmbedded;
        }
        NetMap.mapThroughPath((DevicePath)tdiPath, (Net)p.getNet(), (String)finalTDONetnameToCore);
        NetMap.mapThroughPath((DevicePath)lastPath, lastNet, (String)finalTDONetnameToCore);
        p.getNet().assignToPersonality(personality, tdiPath);
    }

    protected void printDevices(ArrayList<DevicePath> list) {
        for (int i = 0; i < list.size(); ++i) {
            DevicePath dp = list.get(i);
            Device device = dp.getLast();
            DeviceTemplate dt = device.getTemplate();
            ALog.logInfo((String)(" " + i + "," + list.get(i).toString() + "," + dt.getName()));
        }
        ALog.logInfo((String)"");
    }

    protected boolean mapThroughPathSplitNameAtTemplate(DevicePath fullPath, Net bottomNet, DeviceTemplate dt, String lowerName, String upperName) {
        DevicePath belowPath = fullPath.copy();
        while (belowPath != null && !belowPath.isEmpty() && belowPath.getFirst().getTemplate() != dt) {
            belowPath.removeFirst();
        }
        if (belowPath == null || belowPath.isEmpty()) {
            return false;
        }
        DevicePath abovePath = fullPath.copy();
        while (abovePath != null && !abovePath.isEmpty() && abovePath.getLast().getTemplate() != dt) {
            abovePath.removeLast();
        }
        if (abovePath == null || abovePath.isEmpty()) {
            return false;
        }
        Device belowDevice = belowPath.getFirst();
        DeviceTemplate belowDeviceTemplate = belowDevice.getTemplate();
        NetMap.mapThroughPath((DevicePath)belowPath, (Net)bottomNet, (String)lowerName);
        Net topNet = fullPath.getFirst().getTemplate().getNet(upperName);
        if (topNet == null) {
            topNet = Net.create((DeviceTemplate)fullPath.getFirst().getTemplate(), (String)upperName);
        }
        Net belowNet = belowDeviceTemplate.getNet(lowerName);
        NetMap.mapThroughPath((DevicePath)abovePath, (Net)belowNet, (String)upperName);
        return true;
    }

    protected boolean importantDevice(DevicePath candidate, String mode) {
        Device d = candidate.getLast();
        DeviceTemplate dt = d.getTemplate();
        if ("bscan".equals(mode)) {
            boolean hasBSCAN_TDO;
            boolean hasBSCAN_TDI = dt.getPinByName("BSCAN_TDI") != null;
            boolean bl = hasBSCAN_TDO = dt.getPinByName("BSCAN_TDO") != null;
            if (!hasBSCAN_TDI || !hasBSCAN_TDO) {
                return false;
            }
            if (d.getName().equals("TMS")) {
                return false;
            }
            if (d.getName().equals("TCK")) {
                return false;
            }
            if (d.getName().equals("TRSTB")) {
                return false;
            }
            return !d.getName().contains("TAP_SEL");
        }
        if ("ioudr".equals(mode)) {
            boolean hasIOUDR_TDO;
            boolean hasIOUDR_TDI = dt.getPinByName("IO_UDR_TDI") != null;
            boolean bl = hasIOUDR_TDO = dt.getPinByName("IO_UDR_TDO") != null;
            if (!hasIOUDR_TDI || !hasIOUDR_TDO) {
                return false;
            }
            if (d.getName().equals("TMS") || d.getName().equals("TCK") || d.getName().equals("TRSTB")) {
                return false;
            }
            return !d.getName().contains("TAP_SEL");
        }
        if ("scan".equals(mode)) {
            boolean hasSCAN_IN = dt.getPinByName("SCAN_IN") != null;
            boolean hasSCAN_OUT = dt.getPinByName("SCAN_OUT") != null;
            String PinName = "";
            for (PinTemplate pinTemplate : dt.getPins()) {
                PinName = pinTemplate.getName();
                if (!PinName.contains("top_SCAN_IN")) continue;
                return true;
            }
            if (!hasSCAN_IN || !hasSCAN_OUT) {
                return false;
            }
            if (d.getName().equals("TMS") || d.getName().equals("TCK") || d.getName().equals("TRSTB") || d.getName().equals("TDI") || d.getName().equals("TDO")) {
                return false;
            }
            return !d.getName().contains("TAP_SEL");
        }
        return true;
    }

    protected ArrayList<DevicePath> deriveOrderedDevices(DevicePath diePath, String mode) {
        int i;
        ArrayList<DevicePath> temp = new ArrayList<DevicePath>();
        ArrayList<DevicePath> orderedDevices = new ArrayList<DevicePath>();
        for (DevicePath candidate : IOView.getDevicesInSequence()) {
            if (!this.importantDevice(candidate, mode)) continue;
            temp.add(candidate);
        }
        int tdiLoc = -1;
        int tdoLoc = -1;
        int length = temp.size();
        for (i = 0; i < length; ++i) {
            DevicePath candidate = (DevicePath)temp.get(i);
            if (candidate.getLast().getName().equals("TDI")) {
                tdiLoc = i;
            }
            if (!candidate.getLast().getName().equals("TDO")) continue;
            tdoLoc = i;
        }
        ALog.logWarn((String)"");
        ALog.logWarn((String)("ScanStitching: Mode= " + mode + " : Total Device Length = " + length + " : TDI_location=" + tdiLoc + " :TDO_location=" + tdoLoc));
        if ("bscan".equals(mode)) {
            if (tdiLoc < 0) {
                ALog.logWarn((String)"Could not find TDI");
                return orderedDevices;
            }
            if (tdoLoc < 0) {
                ALog.logWarn((String)"Could not find TDO");
                return orderedDevices;
            }
            if (tdoLoc > tdiLoc) {
                ALog.logError((String)"TDO is placed after TDI in the sequence; TDI should be placed immediately after TDO");
                return orderedDevices;
            }
            if (tdiLoc > tdoLoc + 1) {
                ALog.logError((String)"Aside from spacers, there should not be devices between TDI & TDO and TDI should be placed immediately after TDO");
                return orderedDevices;
            }
        }
        if ("bscan".equals(mode) || "ioudr".equals(mode)) {
            for (i = tdiLoc; i < length; ++i) {
                orderedDevices.add((DevicePath)temp.get(i));
            }
            for (i = 0; i < tdiLoc; ++i) {
                orderedDevices.add((DevicePath)temp.get(i));
            }
        }
        if ("scan".equals(mode)) {
            for (i = 0; i < length; ++i) {
                orderedDevices.add((DevicePath)temp.get(i));
            }
        }
        return orderedDevices;
    }

    protected void renameScanNetsToBussed(ArrayList<DevicePath> scanlist) {
        int length = scanlist.size();
        int i = 0;
        int count_user_defined_scan_in = 0;
        int count_user_defined_scan_out = 0;
        int count_SCAN_EN_MUXED = 0;
        int noMabcScanPins = 0;
        DevicePath scanPath_SCAN_EN_MUXED = scanlist.get(i);
        for (i = 0; i < length; ++i) {
            boolean scan_error2;
            DevicePath scanPath = scanlist.get(i);
            Device scan_device = scanPath.getLast();
            DeviceTemplate scanTemplate = scan_device.getTemplate();
            boolean isMabc = false;
            String PinName = "";
            for (PinTemplate pinTemplate : scanTemplate.getPins()) {
                PinName = pinTemplate.getName();
                if (!PinName.contains("top_SCAN_DIR")) continue;
                isMabc = true;
                ++noMabcScanPins;
            }
            if (isMabc) continue;
            PinTemplate pt_SCAN_IN = scanTemplate.getPinByName("SCAN_IN");
            PinTemplate pt_SCAN_OUT = scanTemplate.getPinByName("SCAN_OUT");
            String PinName_SCAN_IN = pt_SCAN_IN.getName();
            String PinName_SCAN_OUT = pt_SCAN_OUT.getName();
            Net currentTopNet = NetMap.getTopmostNet((Net)pt_SCAN_IN.getNet(), (DevicePath)scanPath);
            String SCAN_IN_netname = currentTopNet.getName();
            PinTemplate pt_SCAN_DIR = scanTemplate.getPinByName("SCAN_DIR");
            Net currentTopNet_SCAN_DIR = NetMap.getTopmostNet((Net)pt_SCAN_DIR.getNet(), (DevicePath)scanPath);
            String SCAN_DIR_netname = currentTopNet_SCAN_DIR.getName();
            PinTemplate pt_SO_SEL = scanTemplate.getPinByName("SO_SEL");
            Net currentTopNet_SO_SEL = NetMap.getTopmostNet((Net)pt_SO_SEL.getNet(), (DevicePath)scanPath);
            String SO_SEL_netname = currentTopNet_SO_SEL.getName();
            boolean scan_input_mode = SCAN_DIR_netname.contains("tie1") && SO_SEL_netname.contains("tie0");
            boolean scan_output_mode = SCAN_DIR_netname.contains("tie0") && SO_SEL_netname.contains("tie1");
            boolean scan_error1 = SCAN_DIR_netname.contains("tie0") && !SO_SEL_netname.contains("tie1");
            boolean bl = scan_error2 = !SCAN_DIR_netname.contains("tie0") && SO_SEL_netname.contains("tie1");
            if (SCAN_IN_netname.contains("SCAN_EN_MUXED")) {
                ++count_SCAN_EN_MUXED;
                scanPath_SCAN_EN_MUXED = scanlist.get(i);
                scanlist.remove(i);
                length = scanlist.size();
                ALog.logInfo((String)("ScanStitching: SCAN_EN_MUXED found at =" + scanPath_SCAN_EN_MUXED + " : length = " + length + " : i = " + --i));
                continue;
            }
            if (scan_input_mode || scan_output_mode) {
                if (scan_input_mode) {
                    ALog.logInfo((String)("ScanStitching: User-Defined SCAN IN  found at =" + scanlist.get(i) + " and connecting " + PinName_SCAN_OUT + "to tie0"));
                    ++count_user_defined_scan_in;
                    NetMap.mapThroughPath((DevicePath)scanPath, (Net)pt_SCAN_OUT.getNet(), (String)"tie0");
                }
                if (scan_output_mode) {
                    ++count_user_defined_scan_out;
                    Net parentNet = NetMap.getParentNet((Device)scan_device, (Net)pt_SCAN_IN.getNet());
                    if (parentNet != null && NetMap.unmap((Device)scan_device, (Net)pt_SCAN_IN.getNet(), (Net)parentNet)) {
                        ALog.logInfo((String)("ScanStitching: User-Defined SCAN OUT found at = " + scanlist.get(i) + " and  disconnecting " + PinName_SCAN_IN + " ==> OPEN"));
                    }
                }
                scanlist.remove(i);
                length = scanlist.size();
                --i;
                continue;
            }
            if (!scan_error1 && !scan_error2) continue;
            ALog.logWarn((String)("ScanStitching: User Error in defining SCAN_DIR/SO_SEL at =" + scanlist.get(i)));
        }
        if (count_SCAN_EN_MUXED == 0) {
            ALog.logError((String)("ScanStitching: There is no 'SCAN_EN_MUXED' in any of the 'SCAN_IN' pins <-- You need to add it : ScanList Length =" + length));
            return;
        }
        if (count_SCAN_EN_MUXED > 1) {
            ALog.logError((String)("ScanStitching: There is more than 1 'SCAN_EN_MUXED' on the 'SCAN_IN' pins <-- You need to just have one : ScanList Length =" + length));
            return;
        }
        if (count_SCAN_EN_MUXED == 1) {
            ALog.logInfo((String)("ScanStitching: Found 'SCAN_EN_MUXED' at Device = " + scanPath_SCAN_EN_MUXED + " : ScanList Length =" + length));
            ALog.logInfo((String)"");
            Device SEM_device = scanPath_SCAN_EN_MUXED.getLast();
            DeviceTemplate SEMTemplate = SEM_device.getTemplate();
            String SEM_SCAN_DIR_netname = "tie1";
            String SEM_SO_SEL_netname = "tie0";
            String SEM_SCAN_OUT_netname = "tie0";
            PinTemplate pt_SEM_SCAN_DIR = SEMTemplate.getPinByName("SCAN_DIR");
            PinTemplate pt_SEM_SCAN_SO_SEL = SEMTemplate.getPinByName("SO_SEL");
            PinTemplate pt_SEM_SCAN_OUT = SEMTemplate.getPinByName("SCAN_OUT");
            NetMap.mapThroughPath((DevicePath)scanPath_SCAN_EN_MUXED, (Net)pt_SEM_SCAN_DIR.getNet(), (String)SEM_SCAN_DIR_netname);
            NetMap.mapThroughPath((DevicePath)scanPath_SCAN_EN_MUXED, (Net)pt_SEM_SCAN_SO_SEL.getNet(), (String)SEM_SO_SEL_netname);
            NetMap.mapThroughPath((DevicePath)scanPath_SCAN_EN_MUXED, (Net)pt_SEM_SCAN_OUT.getNet(), (String)SEM_SCAN_OUT_netname);
        }
        length = scanlist.size();
        ALog.logInfo((String)("ScanStitching: New Bussed Scan List length after removing devices = " + length));
        ALog.logInfo((String)"");
        int count_embed = 0;
        int count_top = 0;
        int count_mabc = 0;
        int count_mabc_user_defined_scan_in = 0;
        int count_mabc_user_defined_scan_out = 0;
        int count_mabc_user_defined = 0;
        for (i = 0; i < length; ++i) {
            DevicePath scanPath = scanlist.get(i);
            DevicePath new_scanPath = new DevicePath(scanPath);
            Device scan_device = scanPath.getLast();
            DeviceTemplate scanTemplate = scan_device.getTemplate();
            int noMabcScanPinsOnCurrentDevice = 0;
            boolean isMabc = false;
            String PinName = "";
            for (PinTemplate pinTemplate : scanTemplate.getPins()) {
                PinName = pinTemplate.getName();
                if (!PinName.contains("top_SCAN_IN")) continue;
                isMabc = true;
                ++noMabcScanPinsOnCurrentDevice;
            }
            Object newNetName_SCAN_IN = "null";
            Object newNetName_SCAN_OUT = "null";
            Object newNetName_SCAN_DIR = "null";
            Object newNetName_SCAN_SO_SEL = "null";
            if (new_scanPath.getString().contains("LCore") && !isMabc) {
                new_scanPath.removeFirst();
                newNetName_SCAN_IN = "siw_SCAN_IN[" + count_embed + "]";
                newNetName_SCAN_OUT = "sow_SCAN_OUT[" + count_embed + "]";
                newNetName_SCAN_DIR = "sow_SCAN_DIR[" + count_embed + "]";
                newNetName_SCAN_SO_SEL = "sow_SCAN_SO_SEL[" + count_embed + "]";
                ALog.logInfo((String)("ScanStitching: Embedded SCAN Chain " + count_embed + " " + scanlist.get(i).toString()));
                ++count_embed;
            } else if (!isMabc) {
                newNetName_SCAN_IN = "si_SCAN_IN[" + count_top + "]";
                newNetName_SCAN_OUT = "so_SCAN_OUT[" + count_top + "]";
                newNetName_SCAN_DIR = "so_SCAN_DIR[" + count_top + "]";
                newNetName_SCAN_SO_SEL = "so_SCAN_SO_SEL[" + count_top + "]";
                ALog.logInfo((String)("ScanStitching: TOP SCAN Chain " + count_top + " " + scanlist.get(i).toString()));
                ++count_top;
            } else if (isMabc) {
                ALog.logInfo((String)("ScanStitching: Mabc Device in Chain " + count_mabc + " " + scanlist.get(i).toString()));
                for (int m = 0; m < noMabcScanPinsOnCurrentDevice; ++m) {
                    PinTemplate p_PM_SCAN_DIR = scanTemplate.getPinByName("top_SCAN_DIR[" + m + "]");
                    Net currentTopNet_PM_SCAN_DIR = NetMap.getTopmostNet((Net)p_PM_SCAN_DIR.getNet(), (DevicePath)scanPath);
                    String PM_SCAN_DIR_netname = currentTopNet_PM_SCAN_DIR.getName();
                    PinTemplate p_PM_SCAN_OUT = scanTemplate.getPinByName("top_SCAN_OUT[" + m + "]");
                    PinTemplate p_PM_SCAN_IN = scanTemplate.getPinByName("top_SCAN_IN[" + m + "]");
                    if (new_scanPath.getString().contains("LCore")) {
                        new_scanPath.removeFirst();
                    }
                    if (PM_SCAN_DIR_netname.startsWith("tie1_")) {
                        ALog.logInfo((String)("ScanStitching: User-Defined MABC SCAN IN  found at =" + scanlist.get(i) + "[" + m + "] and connecting top_SCAN_OUT[" + m + "] to tie0"));
                        ++count_mabc_user_defined_scan_in;
                        NetMap.mapThroughPath((DevicePath)new_scanPath, (Net)p_PM_SCAN_OUT.getNet(), (String)"tie0");
                        continue;
                    }
                    if (PM_SCAN_DIR_netname.startsWith("tie0_")) {
                        ++count_mabc_user_defined_scan_out;
                        Net parentNet = NetMap.getParentNet((Device)scan_device, (Net)p_PM_SCAN_IN.getNet());
                        if (!NetMap.unmap((Device)scan_device, (Net)p_PM_SCAN_IN.getNet(), (Net)parentNet)) continue;
                        ALog.logInfo((String)("ScanStitching: User-Defined MABC SCAN OUT found at = " + scanlist.get(i) + "[" + m + "] and  disconnecting top_SCAN_IN[" + m + "] ==> OPEN"));
                        continue;
                    }
                    ++count_mabc_user_defined;
                }
                ++count_mabc;
            }
            if (isMabc) continue;
            PinTemplate p_SCAN_IN = scanTemplate.getPinByName("SCAN_IN");
            PinTemplate p_SCAN_OUT = scanTemplate.getPinByName("SCAN_OUT");
            PinTemplate p_SCAN_DIR = scanTemplate.getPinByName("SCAN_DIR");
            PinTemplate p_SCAN_SO_SEL = scanTemplate.getPinByName("SO_SEL");
            NetMap.mapThroughPath((DevicePath)new_scanPath, (Net)p_SCAN_IN.getNet(), (String)newNetName_SCAN_IN);
            NetMap.mapThroughPath((DevicePath)new_scanPath, (Net)p_SCAN_OUT.getNet(), (String)newNetName_SCAN_OUT);
            NetMap.mapThroughPath((DevicePath)new_scanPath, (Net)p_SCAN_DIR.getNet(), (String)newNetName_SCAN_DIR);
            NetMap.mapThroughPath((DevicePath)new_scanPath, (Net)p_SCAN_SO_SEL.getNet(), (String)newNetName_SCAN_SO_SEL);
        }
        int count_possible_scan_devices = 0;
        int count_TAP_Signals = 0;
        for (DevicePath devicepath : IOView.getDevicesInSequence()) {
            boolean hasSCAN_OUT;
            Device d = devicepath.getLast();
            DeviceTemplate dt = d.getTemplate();
            boolean hasSCAN_IN = dt.getPinByName("SCAN_IN") != null;
            boolean bl = hasSCAN_OUT = dt.getPinByName("SCAN_OUT") != null;
            if (hasSCAN_IN && hasSCAN_OUT) {
                ++count_possible_scan_devices;
            }
            if (!d.getName().equals("TMS") && !d.getName().equals("TCK") && !d.getName().equals("TRSTB") && !d.getName().equals("TDI") && !d.getName().equals("TDO") && !d.getName().contains("TAP_SEL")) continue;
            ++count_TAP_Signals;
        }
        ALog.logInfo((String)"");
        ALog.logInfo((String)"ScanStitching: SCAN Sharing Summary:");
        ALog.logInfo((String)"====================================");
        ALog.logInfo((String)("Possible total Scan Devices without PMxx like block ----------------------->> " + count_possible_scan_devices));
        ALog.logInfo((String)("   Embedded Scan Devices (SCAN_DIR/SO_SEL not hard tied)                    = " + count_embed));
        ALog.logInfo((String)("   Top Scan Devices      (SCAN_DIR/SO_SEL not hard tied)                    = " + count_top));
        ALog.logInfo((String)("   User Defined Scan Sharing Input only Devices (SCAN_DIR=tie1;SO_SEL=tie0) = " + count_user_defined_scan_in));
        ALog.logInfo((String)("   User Defined Scan Sharing Output only Devices(SCAN_DIR=tie0;SO_SEL=tie1) = " + count_user_defined_scan_out));
        ALog.logInfo((String)("   Excluded from Scan chains: SCAN_EN_MUXED (must be excatly 1)             = " + count_SCAN_EN_MUXED));
        ALog.logInfo((String)("   Excluded from Scan chains: TCK,TMS,TRSTB,TDI,TDO and possibly TAP_SEL    = " + count_TAP_Signals));
        ALog.logInfo((String)"");
        ALog.logInfo((String)("Possible total Scan Devices within PMxx like blocks (MABC/DDR/etc) -------->> " + noMabcScanPins));
        ALog.logInfo((String)("   User Defined PMxx Scan Input Devices  (top_SCAN_DIR=tie1)                = " + count_mabc_user_defined_scan_in));
        ALog.logInfo((String)("   User Defined PMxx Scan Output Devices (top_SCAN_DIR=tie0)                = " + count_mabc_user_defined_scan_out));
        ALog.logInfo((String)("   User Defined PMxx Scan Devices (top_SCAN_DIR not hard tied)              = " + count_mabc_user_defined));
        ALog.logInfo((String)"");
        ALog.logInfo((String)"======================================================================================");
    }
}

