/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.cadence.plaf.InnovusLookAndFeel;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbReader;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AImageIcon;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.serial.UpdXmlReader;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;

public class DbExplorer
extends JFrame {
    protected DbExplorerPanel mExplorerPanel = null;
    protected ActionListener mFileOpener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.addChoosableFileFilter((FileFilter)OrbitIO.OIO_FILE_FILTER);
            AFileFilter updXmlFilter = new AFileFilter("updxml", "UPD XML Files");
            fc.addChoosableFileFilter((FileFilter)updXmlFilter);
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter((FileFilter)OrbitIO.OIO_FILE_FILTER);
            if (fc.showOpenDialog((Component)DbExplorer.this) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            FileFilter ff = fc.getFileFilter();
            Db db = OrbitIO.createDb();
            if (ff == OrbitIO.OIO_FILE_FILTER) {
                DbReader dbr = new DbReader(db);
                if (dbr.read(f.getPath())) {
                    db.setFile(f);
                    DbExplorer.this.mExplorerPanel.setDb(db);
                }
            } else if (ff == updXmlFilter && new UpdXmlReader().loadUpdXml(db, f)) {
                DbExplorer.this.mExplorerPanel.setDb(db);
            }
        }
    };

    public DbExplorer(Db db) {
        super("DbExplorer");
        File iconPath = new File(AApp.getInstallDir(), "res/img/icon32.png");
        AImageIcon icon = new AImageIcon(iconPath.getPath());
        this.setIconImage(icon.getImage());
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.createMenuBar());
        GridBagManager gb = new GridBagManager(this.getContentPane());
        this.mExplorerPanel = new DbExplorerPanel("Design Explorer");
        gb.add((Component)this.mExplorerPanel, (GridBagConstraints)GridBagManager.FILLALL);
        this.pack();
        if (db != null) {
            this.mExplorerPanel.setDb(db);
        }
    }

    public DbExplorer() {
        this((Db)null);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu("File");
        m.setMnemonic(70);
        mb.add(m);
        JMenuItem mi = new JMenuItem("Open...", 79);
        mi.addActionListener(this.mFileOpener);
        m.add(mi);
        mi = new JMenuItem("Exit", 88);
        mi.addActionListener(UIUtil.getCloser((Window)this));
        m.add(mi);
        return mb;
    }

    public static DbExplorer showWindow() {
        DbExplorer explorer = new DbExplorer();
        explorer.setVisible(true);
        return explorer;
    }

    public static DbExplorerPanel createExplorerPanel() {
        return new DbExplorerPanel("Design Explorer");
    }

    public static void main(String[] args) {
        DbExplorer.showWindow();
    }

    static {
        System.setProperty("swing.boldMetal", "false");
        try {
            UIManager.setLookAndFeel((LookAndFeel)new InnovusLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            ALog.logError((Throwable)e);
        }
    }
}

