/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.google.common.collect.Lists;
import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.APlatformUtil;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.AStringEscape;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AclInfo;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbItr;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbPrimaryKey;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.PrimaryKey;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ACheckBoxIcon;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.DesignSettings;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.cmd.DeviceCommands;
import com.sigrity.orbit.ui.DbObjectUI;
import com.sigrity.orbit.ui.LayerUI;
import com.sigrity.orbit.ui.NetUI;
import com.sigrity.orbit.ui.OrbitGuiObjectActionRegistry;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.OrbitHyperlinkHandler;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.VisibilityControlUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.table_editor.EditDeviceUI;
import com.sigrity.orbit.ui.table_editor.EditLayerUI;
import com.sigrity.orbit.ui.table_editor.EditNetUI;
import com.sigrity.orbit.ui.table_editor.EditPinLabelUI;
import com.sigrity.orbit.ui.table_editor.EditPinUI;
import com.sigrity.orbit.ui.table_editor.EditTermUI;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbObjectTransferable;
import com.sigrity.tools.dbexplorer.DbTraceExplorerPanel;
import com.sigrity.tools.dbexplorer.NodeIcons;
import com.sigrity.tools.dbexplorer.NodeOptions;
import com.sigrity.tools.dbexplorer.SearchPanel;
import com.sigrity.tools.dbexplorer.SearchSelectedPanel;
import com.sigrity.tools.dbexplorer.tree.ContextMenuSupport;
import com.sigrity.tools.dbexplorer.tree.DbTreeModel;
import com.sigrity.tools.dbexplorer.tree.DbTreeNode;
import com.sigrity.tools.dbexplorer.tree.JitDbTreeNode;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DbExplorerPanel
extends JPanel {
    public static final boolean TreeAllowsMultipleSelectionDefault = true;
    public static final int MAX_ELEMS = Integer.MAX_VALUE;
    public static final String ENABLE_EXTENDED_UI = "com.sigrity.tools.dbexplorer.extraui";
    public static final String TEXT_INVALID = "<invalid>";
    protected static final ArrayList<DbExplorerPanel> sExplorerPanels = new ArrayList();
    protected static final Map<Class<?>, Integer> mNodeClassOrder = AUtil.indexMap((Object[])new Class[]{DatabaseNode.class, DisplayNode.class, TermsNode.class, NetsNode.class, PinLabelsNode.class, PinsNode.class, ViasNode.class, FingersNode.class, BundlesNode.class, DeviceHierarchyRootNode.class, DeviceHierarchyNode.class, DeviceTypeGroupNode.class, DbRelationsGroupNode.class, AllClassesNode.class, AllRelationsNode.class, DbClassNode.class, DbObjNode.class, DeviceUnplacedGroupNode.class, DbRelationNode.class, DbRelatedObjectsNode.class});
    private static HTMLViewer sViewer;
    protected SearchPanel mPnlSearch;
    protected SearchSelectedPanel mPnlSelJump;
    protected ASplitPane mTraceSplitPane;
    protected DbTraceExplorerPanel mPnlTrace;
    protected JTree mTree = null;
    protected JScrollPane mScrollTree;
    protected DetailsPanel mDetailsPanel = null;
    protected Db mDb = null;
    protected Selection mDbSelection = null;
    protected ViewColorizer mViewColorizer = null;
    protected boolean mCreateEnabled = false;
    protected boolean mShowDetailsPane = true;
    protected boolean mNetDrag = false;
    protected ExploreNetListener mExploreNetListener = null;
    protected TreeSelectionListener mTreeHighlightSelectionListener = null;
    protected RELATION_DISPLAY mRelationDisplay = RELATION_DISPLAY.GROUP;
    protected boolean mCountCommentDisplay = true;
    protected boolean mTreeAllowsMutlipleSelection = true;
    protected HashSet<DevicePath> mInvalidateDevices = null;
    protected Selection.SelectionListener mSelectionListener = set -> this.repaint();
    protected Action mActionShowSearchPanel = new AbstractAction("Find", OrbitIcons.SRCH){

        @Override
        public void actionPerformed(ActionEvent e) {
            DbExplorerPanel.this.mPnlSearch.setVisible(true);
            DbExplorerPanel.this.mPnlSearch.requestFocus();
        }
    };
    protected Action mActionShowSearchSelPanel = new AbstractAction("FindSelected", OrbitIcons.SELECT){

        @Override
        public void actionPerformed(ActionEvent e) {
            DbExplorerPanel.this.mPnlSelJump.setVisible(true);
            DbExplorerPanel.this.mPnlSelJump.requestFocus();
        }
    };
    protected boolean mRefreshPending = false;
    protected Db.DbListener mDbListener = new Db.DbListenerAdapter(){

        public void dbObjectListenerStateChange(Db db, boolean listenersEnabled) {
            if (listenersEnabled) {
                DbExplorerPanel.this.refresh();
            }
        }
    };
    protected Action mRefresh = new ActionRefreshNodes();
    protected TransferHandler mTransferHandler = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c) {
            TreePath[] selPaths = DbExplorerPanel.this.mTree.getSelectionPaths();
            if (selPaths.length != 1) {
                return null;
            }
            TreePath selPath = DbExplorerPanel.this.mTree.getSelectionPath();
            if (selPath == null) {
                return null;
            }
            Object selObj = selPath.getLastPathComponent();
            if (selObj instanceof DeviceHierarchyNode) {
                DeviceHierarchyNode dhn = (DeviceHierarchyNode)selObj;
                DevicePath dpath = DevicePath.fromString((Db)DbExplorerPanel.this.mDb, (String)dhn.getDevicePathString());
                DbExplorerPanel.this.mNetDrag = false;
                return new DbObjectTransferable.DeviceTransferable(dpath, selPath);
            }
            if (selObj instanceof NetNode) {
                DbExplorerPanel.this.mNetDrag = true;
                DevicePath dpath = ((NetNode)selObj).getDevicePath();
                Net dbNetObj = ((NetNode)selObj).getNet();
                return new DbObjectTransferable.NetTransferable(dpath, dbNetObj);
            }
            if (selObj instanceof DbObjNode) {
                DbObjNode node = (DbObjNode)selObj;
                return new DbObjectTransferable.HierDboTransferable(node.getDevicePath(), (DbObject)node.getDbObj());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return DbExplorerPanel.this.mNetDrag ? 0x40000001 : 2;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (DbExplorerPanel.this.mNetDrag) {
                return false;
            }
            APair<DevicePath, DevicePath> srcAndTgt = this.getSourceAndTarget(support);
            if (srcAndTgt == null) {
                return false;
            }
            if (support.getDropAction() != 2) {
                support.setDropAction(2);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            APair<DevicePath, DevicePath> srcAndTgt = this.getSourceAndTarget(support);
            if (srcAndTgt == null || srcAndTgt.first == null) {
                return false;
            }
            DevicePath srcPath = (DevicePath)srcAndTgt.first;
            DevicePath tgtPath = srcAndTgt.second == null ? Design.getDesignPath((Db)DbExplorerPanel.this.mDb) : (DevicePath)srcAndTgt.second;
            Runnable runnable = () -> {
                DeviceCommands.setDeviceToNewParent(DbExplorerPanel.this.mDb, srcPath, tgtPath);
                DbExplorerPanel.refreshAll();
                SwingUtilities.invokeLater(() -> {
                    OrbitIO.getOrbitIO().refreshCurrentView(false);
                    DevicePath selPath = tgtPath == null ? new DevicePath(srcPath.getLast()) : new DevicePath(tgtPath, srcPath.getLast());
                    DbExplorerPanel.this.selectDevicePath(selPath);
                });
            };
            if (APlatformUtil.isMacPlatform()) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
            return true;
        }

        APair<DevicePath, DevicePath> getSourceAndTarget(TransferHandler.TransferSupport support) {
            DevicePath srcPath;
            Transferable transferable = support.getTransferable();
            if (!transferable.isDataFlavorSupported(DbObjectTransferable.DeviceTransferable.FLAVOR)) {
                return null;
            }
            try {
                DbObjectTransferable.DeviceTransferable dt = (DbObjectTransferable.DeviceTransferable)transferable.getTransferData(DbObjectTransferable.DeviceTransferable.FLAVOR);
                srcPath = dt.mDevicePath;
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error getting transfer data.", (Object[])new Object[0]);
                return null;
            }
            JTree.DropLocation dropLoc = (JTree.DropLocation)support.getDropLocation();
            TreePath dropTargetPath = dropLoc.getPath();
            if (dropTargetPath == null) {
                return null;
            }
            if (srcPath == null) {
                return null;
            }
            Object tgtObj = dropTargetPath.getLastPathComponent();
            if (tgtObj instanceof DeviceHierarchyNode) {
                DeviceHierarchyNode dhn = (DeviceHierarchyNode)tgtObj;
                if (!dhn.getDevice().getTemplate().isValidParentFor(srcPath.getLast().getTemplate())) {
                    return null;
                }
                String tgtPathStr = dhn.getDevicePathString();
                DevicePath tgtPath = DevicePath.fromString((Db)DbExplorerPanel.this.mDb, (String)tgtPathStr);
                return new APair((Object)srcPath, (Object)tgtPath);
            }
            if (tgtObj instanceof DeviceHierarchyRootNode) {
                return new APair((Object)srcPath, null);
            }
            return null;
        }
    };

    protected static HTMLViewer getHTMLViewer(String html) {
        if (sViewer == null) {
            sViewer = new HTMLViewer();
        }
        sViewer.setText(html);
        return sViewer;
    }

    public DbExplorerPanel(String name) {
        this(name, true);
    }

    public DbExplorerPanel(String name, boolean showDetailsPane) {
        this.setName(name);
        this.mShowDetailsPane = showDetailsPane;
        GridBagManager gbmMain = new GridBagManager((Container)this);
        JPanel pnlExplorer = new JPanel();
        GridBagManager gbmExplorer = GridBagManager.layout((Container)pnlExplorer);
        this.mTree = this.createTree();
        this.createSearchPanel(gbmExplorer);
        this.createSelectJumpPanel(gbmExplorer);
        this.createTracePanel();
        this.mScrollTree = new JScrollPane(this.mTree);
        this.mScrollTree.setPreferredSize(new Dimension(200, 500));
        if (this.mPnlTrace != null) {
            this.mTraceSplitPane = new ASplitPane(0, this.mPnlTrace, this.mScrollTree);
            gbmExplorer.add((Component)this.mTraceSplitPane, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        } else {
            gbmExplorer.add((Component)this.mScrollTree, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        }
        if (this.mShowDetailsPane) {
            this.mDetailsPanel = new DetailsPanel();
            this.mDetailsPanel.setPreferredSize(new Dimension(400, 500));
            this.mTree.addTreeSelectionListener(new DbTreeSelListener(this.mDetailsPanel));
            ASplitPane splitPane = new ASplitPane();
            splitPane.setLeftComponent(pnlExplorer);
            splitPane.setRightComponent(this.mDetailsPanel);
            splitPane.setBorder(null);
            gbmMain.add((Component)splitPane, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        } else {
            gbmMain.add((Component)pnlExplorer, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        }
        this.installPopupMenu();
        this.initializeDragAndDrop();
        sExplorerPanels.add(this);
    }

    private JTree createTree() {
        ATree tree = new ATree(){

            public String getToolTipText(MouseEvent event) {
                TreePath path = this.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return null;
                }
                Object node = path.getLastPathComponent();
                if (node instanceof DbTreeNode) {
                    return ((DbTreeNode)node).getTooltipText();
                }
                return path.getLastPathComponent().toString();
            }
        };
        ToolTipManager.sharedInstance().registerComponent((JComponent)tree);
        tree.setScrollsOnExpand(false);
        tree.setModel(null);
        tree.setEditable(false);
        tree.setCellRenderer(new DbTreeCellRenderer());
        tree.setShowsRootHandles(true);
        tree.getSelectionModel().setSelectionMode(this.mTreeAllowsMutlipleSelection ? 4 : 1);
        this.mTreeHighlightSelectionListener = e -> {
            DesignView2D v2d;
            AAppView view = DbExplorerPanel.getCurOrbitView();
            DesignView2D designView2D = v2d = view instanceof DesignView2D ? (DesignView2D)view : null;
            if (v2d == null) {
                return;
            }
            boolean render = false;
            DbObjectHighlighter.clear(v2d);
            render |= Floorplan.setHighlightedObject(null);
            TreePath[] paths = this.mTree.getSelectionPaths();
            if (paths != null) {
                Selection sel = new Selection(this.mDb);
                for (TreePath path : paths) {
                    Object item = path.getLastPathComponent();
                    if (!(item instanceof DbObjNode)) continue;
                    DbObjNode node = (DbObjNode)item;
                    Object dbo = node.getDbObj();
                    sel.add(node.getDevicePath(), dbo);
                }
                DbObjectHighlighter.highlight(v2d, sel);
            }
            if (render) {
                OrbitApp.getApp().refreshCurrentView(false);
            }
        };
        tree.addTreeSelectionListener(this.mTreeHighlightSelectionListener);
        tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Point pt = DbExplorerPanel.this.mTree.getMousePosition();
                if (pt == null) {
                    return;
                }
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                JMenuItem mi = DbExplorerPanel.this.getTreeContextMenuActionByKeyStroke(ks);
                if (mi != null) {
                    mi.doClick();
                }
            }
        });
        return tree;
    }

    protected void createSearchPanel(GridBagManager l) {
        this.mPnlSearch = (SearchPanel)l.addNl((Component)new SearchPanel(this.mTree, new JPopupMenu()), (GridBagConstraints)GridBagManager.FILLX.insets(0, 0, 1, 0));
        this.mPnlSearch.setVisible(false);
        String ACTION_FIND = "Find";
        this.mTree.getActionMap().put("Find", this.mActionShowSearchPanel);
        this.mTree.getInputMap().put(OrbitHotkey.getKeyStroke("UI Search"), "Find");
    }

    protected void createSelectJumpPanel(GridBagManager l) {
        this.mPnlSelJump = (SearchSelectedPanel)l.addNl((Component)new SearchSelectedPanel(this.mTree), (GridBagConstraints)GridBagManager.FILLX.insets(0, 0, 1, 0));
        this.mPnlSelJump.setVisible(false);
    }

    protected DbTraceExplorerPanel createTracePanel() {
        this.mPnlTrace = new DbTraceExplorerPanel("Trace");
        this.mPnlTrace.setVisible(false);
        return this.mPnlTrace;
    }

    protected Action getTraceAction(final HierInst<? extends DbObject> hierInst) {
        if (this.mPnlTrace == null) {
            return null;
        }
        if (hierInst.getDbObject() instanceof Net) {
            return new AbstractAction("Trace"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DbExplorerPanel.this.mPnlTrace.startNetTracing((HierInst<Net>)new HierInst(hierInst.getPath(), (DbObject)((Net)hierInst.getDbObject())));
                    DbExplorerPanel.this.mPnlTrace.setDb(DbExplorerPanel.this.getDb());
                    DbExplorerPanel.this.mTraceSplitPane.setDividerLocation(100);
                    DbExplorerPanel.this.mPnlTrace.setVisible(true);
                }
            };
        }
        return null;
    }

    public static void refreshAll() {
        for (DbExplorerPanel ep : sExplorerPanels) {
            ep.refresh();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Db.addDbListener((Db.DbListener)this.mDbListener);
    }

    @Override
    public void removeNotify() {
        Db.removeDbListener((Db.DbListener)this.mDbListener);
        sExplorerPanels.remove(this);
        super.removeNotify();
        this.setDb(null);
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (RuntimeException e) {
            ALog.logError((Throwable)e, (String)"Error repainting %s.", (Object[])new Object[]{this.getClass().getSimpleName()});
        }
    }

    public void refresh() {
        if (this.mRefreshPending) {
            return;
        }
        this.mRefreshPending = true;
        EventQueue.invokeLater(() -> {
            try {
                if (this.getDb() != null) {
                    this.setDb(this.getDb());
                }
            }
            finally {
                this.mRefreshPending = false;
            }
        });
    }

    public void setDb(Db db) {
        State savedState = null;
        if (db == null && this.mDb != null) {
            if (this.mDbSelection != null) {
                this.mDbSelection.removeSelectionListener(this.mSelectionListener);
            }
        } else if (db == this.mDb && db != null) {
            savedState = this.getState();
        }
        this.mDbSelection = Selection.getCurrentSelectionForDb((Db)db);
        this.mViewColorizer = DesignSettings.getViewColorizer((Db)db);
        this.updateCurDbTo(db);
        if (db != null) {
            if (savedState != null) {
                this.putState(savedState);
            }
            if (this.mDbSelection != null) {
                this.mDbSelection.addSelectionListener(this.mSelectionListener);
            }
        }
    }

    protected void updateCurDbTo(Db db) {
        DbTreeModel dbtm;
        this.mDb = db;
        NodeIcons.resetCache();
        TreeModel tm = this.mTree.getModel();
        if (tm instanceof DbTreeModel) {
            dbtm = (DbTreeModel)((Object)tm);
            dbtm.dispose();
        }
        if (db != null) {
            assert (this.mViewColorizer != null);
            dbtm = new DbTreeModel();
            dbtm.setRoot(new DatabaseNode(dbtm));
            this.mTree.setModel((TreeModel)((Object)dbtm));
            if (this.mPnlSearch != null) {
                this.mPnlSearch.getTreeSearchUI().setModel(this.mTree.getModel());
            }
            if (this.mPnlSelJump != null) {
                this.mPnlSelJump.getTreeSearchUI().setModel(this.mTree.getModel());
            }
            this.mTree.setRootVisible(false);
        } else {
            if (this.mPnlSearch != null) {
                this.mPnlSearch.getTreeSearchUI().setModel(null);
            }
            if (this.mPnlSelJump != null) {
                this.mPnlSelJump.getTreeSearchUI().setModel(null);
            }
            this.mTree.setModel(null);
        }
    }

    public Db getDb() {
        return this.mDb;
    }

    public void setCreateEnabled(boolean b) {
        this.mCreateEnabled = b;
    }

    public void showTreeContextMenu(int x, int y) {
        JPopupMenu m = new JPopupMenu();
        LinkedList<JMenuItem> menuItems = this.createContextMenu();
        for (JMenuItem mi : menuItems) {
            if (mi == null) {
                m.addSeparator();
                continue;
            }
            m.add(mi);
            UIUtil.setUniqueMnemonic((JPopupMenu)m, (AbstractButton)mi);
        }
        AMenuUtil.setMnemonics((JPopupMenu)m, (boolean)true, (boolean)true);
        if (OrbitIO.getGuiWorkspace() != null) {
            OrbitIO.getGuiWorkspace().beautify(m);
        }
        m.show(this.mTree, x, y);
    }

    public JMenuItem getTreeContextMenuActionByKeyStroke(KeyStroke ks) {
        LinkedList<JMenuItem> menuItems = this.createContextMenu();
        for (JMenuItem mi : menuItems) {
            KeyStroke mks;
            if (mi == null || (mks = mi.getAccelerator()) == null || !mks.equals(ks)) continue;
            return mi;
        }
        return null;
    }

    protected LinkedList<JMenuItem> createContextMenu() {
        LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
        TreePath[] selPaths = this.mTree.getSelectionPaths();
        if (selPaths != null) {
            if (selPaths.length == 1) {
                Object activeObject = selPaths[0].getLastPathComponent();
                if (activeObject instanceof ContextMenuSupport) {
                    ContextMenuSupport cms = (ContextMenuSupport)activeObject;
                    cms.populateMenuItems(menuItems);
                }
            } else {
                menuItems.addAll(this.getMenuItems(selPaths));
            }
        }
        menuItems.add(0, new JMenuItem(this.mRefresh));
        if (menuItems.size() > 1) {
            menuItems.add(1, null);
        }
        return menuItems;
    }

    protected List<JMenuItem> getMenuItems(TreePath[] paths) {
        Selection sel = new Selection(this.mDb);
        for (TreePath path : paths) {
            Object lpc = path.getLastPathComponent();
            if (lpc instanceof DbObjNode) {
                DbObjNode dbon = (DbObjNode)lpc;
                if (lpc instanceof PinTemplateNode) {
                    PinTemplateNode ptNode = (PinTemplateNode)lpc;
                    HierInst<PinInstance> pinInst = ptNode.getHierPinInst();
                    if (pinInst != null) {
                        sel.add(pinInst);
                        continue;
                    }
                    sel.add(dbon.getHierInst());
                    continue;
                }
                sel.add(dbon.getHierInst());
                continue;
            }
            sel.clear();
            return Collections.emptyList();
        }
        Db db = this.getDb();
        OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
        ObjectActionRegistry oar = gws.getObjectActionRegistry();
        OrbitGuiShortcutActionRegistry sar = OrbitGuiShortcutActionRegistry.get();
        List<JMenuItem> mi = oar.getJMenuItems(sel).stream().collect(Collectors.toList());
        OrbitGuiShortcutActionRegistry.ViewConstraint vc = OrbitGuiShortcutActionRegistry.ViewConstraint.createAll();
        vc.remove(Selection.class);
        for (Object obj : sar.getActions(db, sel, null, vc)) {
            if (obj instanceof Action) {
                mi.add(ObjectActionRegistry.getJMenuItem((Action)obj));
                continue;
            }
            if (!(obj instanceof JMenuItem)) continue;
            mi.add((JMenuItem)obj);
        }
        Collections.sort(mi, (a, b) -> a.getText().compareTo(b.getText()));
        if (mi.isEmpty()) {
            for (Action a2 : AUtil.arrayList(DbObjectUI.ActionFactorySelection.getActions(sel, null))) {
                mi.add(ObjectActionRegistry.getJMenuItem(a2));
            }
        }
        return mi;
    }

    public void setExploreNetListener(ExploreNetListener enl) {
        this.mExploreNetListener = enl;
    }

    public ExploreNetListener getExploreNetListener() {
        return this.mExploreNetListener;
    }

    protected void installPopupMenu() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle r;
                Point p = new Point();
                TreePath sel = DbExplorerPanel.this.mTree.getSelectionPath();
                if (sel != null && (r = DbExplorerPanel.this.mTree.getPathBounds(sel)) != null) {
                    p.x = r.x;
                    p.y = r.y + r.height;
                }
                DbExplorerPanel.this.showTreeContextMenu(p.x, p.y);
            }
        };
        ActionMap am = this.mTree.getActionMap();
        am.put(action, action);
        this.mTree.getInputMap().put(KeyStroke.getKeyStroke(121, 64), action);
        this.mTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            protected boolean maybeShowPopup(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    return false;
                }
                TreePath p = DbExplorerPanel.this.mTree.getPathForLocation(e.getX(), e.getY());
                if (!(p == null || DbExplorerPanel.this.mTreeAllowsMutlipleSelection && DbExplorerPanel.this.mTree.isPathSelected(p))) {
                    DbExplorerPanel.this.mTree.setSelectionPath(p);
                }
                DbExplorerPanel.this.showTreeContextMenu(e.getX(), e.getY());
                return true;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath p = DbExplorerPanel.this.mTree.getPathForLocation(e.getX(), e.getY());
                if (e.isPopupTrigger()) {
                    return;
                }
                Object node = p == null ? null : p.getLastPathComponent();
                Rectangle pathBounds = DbExplorerPanel.this.mTree.getPathBounds(p);
                if (node instanceof NetNode) {
                    boolean changed;
                    NetNode netNode = (NetNode)node;
                    int width = netNode.getColorIconForNet().getIconWidth();
                    if (e.getX() >= pathBounds.x + width && e.getX() < pathBounds.x + 2 * width && e.getButton() == 1 && (changed = netNode.changeColorDialog())) {
                        DbExplorerPanel.this.mTree.repaint(pathBounds);
                        OrbitIO.getApp().refreshCurrentView();
                    }
                } else if (node instanceof LayersNode) {
                    LayersNode layersNode = (LayersNode)node;
                    int width = 16;
                    if (e.getX() >= pathBounds.x + width && e.getX() < pathBounds.x + 2 * width && e.getButton() == 1) {
                        layersNode.toggleCheckBox();
                    }
                } else if (node instanceof LayerNode) {
                    LayerNode layerNode = (LayerNode)node;
                    int width = 16;
                    if (e.getX() >= pathBounds.x && e.getX() < pathBounds.x + width && e.getButton() == 1) {
                        layerNode.toggleCheckBox();
                    } else if (e.getX() >= pathBounds.x + width && e.getX() < pathBounds.x + 2 * width && e.getButton() == 1) {
                        layerNode.chooseColor();
                    }
                } else if (node instanceof DisplayObjectNode) {
                    DisplayObjectNode objNode = (DisplayObjectNode)node;
                    int width = 16;
                    if (e.getX() >= pathBounds.x && e.getX() < pathBounds.x + width && e.getButton() == 1) {
                        objNode.toggleCheckBox();
                    } else if (e.getX() >= pathBounds.x + width && e.getX() < pathBounds.x + 2 * width && e.getButton() == 1) {
                        objNode.chooseColor();
                    }
                }
            }
        });
    }

    public void showSearchPanel() {
        this.mActionShowSearchPanel.actionPerformed(null);
    }

    public void showSearchSelectedPanel() {
        this.mActionShowSearchSelPanel.actionPerformed(null);
    }

    public static Map<Class<?>, Integer> getNodeClassOrderTable() {
        return mNodeClassOrder;
    }

    protected boolean filterTreeNode(JitDbTreeNode node) {
        return node != null;
    }

    public static void expandHierLevels(JTree tree, TreePath startPath, int levels) {
        if (levels != -1 && levels <= 0) {
            return;
        }
        boolean expandedStart = false;
        TreeModel tm = tree.getModel();
        if (tm == null) {
            return;
        }
        Object startNode = startPath.getLastPathComponent();
        for (int i = 0; i < tm.getChildCount(startNode); ++i) {
            Object child = tm.getChild(startNode, i);
            if (!(child instanceof HasDevice)) continue;
            if (!expandedStart) {
                HasDevice dhn = (HasDevice)child;
                Device device = dhn.getDevice();
                if ((levels > 0 || device.getIsSubstrate()) && !tree.isExpanded(startPath)) {
                    tree.expandPath(startPath);
                }
                expandedStart = true;
            }
            TreePath childPath = startPath.pathByAddingChild(child);
            if (levels < 0) {
                DbExplorerPanel.expandHierLevels(tree, childPath, levels);
                continue;
            }
            if (levels <= 1) continue;
            DbExplorerPanel.expandHierLevels(tree, childPath, levels - 1);
        }
    }

    public static int getDeviceTypeSortPriority(DeviceTemplate.Type t) {
        if (t == DeviceTemplate.Type.PACKAGE) {
            return -100;
        }
        return 0;
    }

    protected List<DbTreeNode> createPowerSignalGroups(DbTreeNode parent, DevicePath dp, List<? extends DbObjNode<?>> netChildren, Function<DbObject, Net> netMapper) {
        if (netChildren == null) {
            return new ArrayList<DbTreeNode>();
        }
        ArrayList signalList = new ArrayList();
        ArrayList powerList = new ArrayList();
        ArrayList ncList = new ArrayList();
        for (int i = 0; i < netChildren.size(); ++i) {
            DbObjNode<?> node = netChildren.get(i);
            Object dbo = node.getDbObj();
            Net net = netMapper.apply((DbObject)dbo);
            if (net.isNC()) {
                ncList.add(node);
                continue;
            }
            if (Net.isPowerNet((Net)net, (DevicePath)dp)) {
                powerList.add(node);
                continue;
            }
            signalList.add(node);
        }
        ArrayList<DbTreeNode> ret = new ArrayList<DbTreeNode>();
        if (!signalList.isEmpty()) {
            ret.add(new NetGroupNode(parent, NetGroupType.SIGNAL, signalList));
        }
        if (!powerList.isEmpty()) {
            ret.add(new NetGroupNode(parent, NetGroupType.PG, powerList));
        }
        if (!ncList.isEmpty()) {
            ret.add(new NetGroupNode(parent, NetGroupType.NC, ncList));
        }
        return ret;
    }

    <T extends DbObject> DbObjNode<T> createDbObjNode(DbTreeNode parent, T dbo) {
        return new DbObjNode(this, parent, dbo);
    }

    private static DevicePath getDevicePath(TreePath tp) {
        Object[] path = tp.getPath();
        DevicePath devicePath = null;
        for (int i = 0; i < path.length; ++i) {
            Object node = path[i];
            if (devicePath == null && node instanceof DeviceHierarchyRootNode) {
                DeviceHierarchyRootNode dhrn = (DeviceHierarchyRootNode)node;
                devicePath = new DevicePath((DeviceTemplate)dhrn.getDbObj());
                continue;
            }
            if (!(node instanceof DeviceHierarchyNode) || node instanceof DeviceTypeGroupNode) continue;
            DeviceHierarchyNode dhn = (DeviceHierarchyNode)node;
            Device d = dhn.getDevice();
            if (devicePath == null) {
                devicePath = new DevicePath(d);
                continue;
            }
            devicePath.add(d);
        }
        return devicePath;
    }

    protected boolean selectDevicePath(DevicePath dp) {
        DeviceHierarchyRootNode dhrn = this.getDeviceHieararchyRootNode();
        if (dhrn == null) {
            return false;
        }
        TreePath tp = dhrn.getTreePath(dp);
        if (tp == null) {
            return false;
        }
        this.mTree.setSelectionPath(tp);
        return true;
    }

    protected DeviceHierarchyRootNode getDeviceHieararchyRootNode() {
        return this.getDeviceHieararchyRootNode(null);
    }

    protected DeviceHierarchyRootNode getDeviceHieararchyRootNode(TreeNode start) {
        TreeNode child;
        int i;
        if (start == null) {
            DbTreeModel tm = (DbTreeModel)((Object)this.mTree.getModel());
            Object o = tm.getRoot();
            if (!(o instanceof DbTreeNode)) {
                return null;
            }
            start = (DbTreeNode)o;
        }
        if (start instanceof DeviceHierarchyRootNode) {
            return (DeviceHierarchyRootNode)start;
        }
        for (i = 0; i < start.getChildCount(); ++i) {
            child = start.getChildAt(i);
            if (!(child instanceof DeviceHierarchyRootNode)) continue;
            return (DeviceHierarchyRootNode)child;
        }
        for (i = 0; i < start.getChildCount(); ++i) {
            child = start.getChildAt(i);
            DeviceHierarchyRootNode found = this.getDeviceHieararchyRootNode(child);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected void initializeDragAndDrop() {
        this.mTree.setTransferHandler(this.mTransferHandler);
        this.mTree.setDragEnabled(true);
        this.mTree.setDropMode(DropMode.ON);
    }

    public static int getDbObjDisplayCount(DbClass dbClass, MutableInteger actual) {
        int count;
        int n = count = dbClass == null ? 0 : dbClass.getInstanceCount(false);
        if (actual != null) {
            actual.setValue(count);
        }
        return Math.min(count, Integer.MAX_VALUE);
    }

    public static int getDbObjDisplayCount(DbClass dbClass) {
        return DbExplorerPanel.getDbObjDisplayCount(dbClass, null);
    }

    static String getSupportedCtorTypeName(Class<?> type) {
        if (String.class.isAssignableFrom(type)) {
            return "String";
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return "Integer";
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return "Float";
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return "Double";
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return "Boolean";
        }
        if (DbObject.class.isAssignableFrom(type)) {
            return type.getSimpleName();
        }
        return null;
    }

    static String getConstructorDescription(Constructor<?> ctor) {
        StringBuilder desc = new StringBuilder();
        for (Class<?> type : ctor.getParameterTypes()) {
            String curParm = DbExplorerPanel.getSupportedCtorTypeName(type);
            if (curParm == null) {
                return null;
            }
            if (desc.length() > 0) {
                desc.append(", ");
            }
            desc.append(curParm);
        }
        if (desc.length() == 0) {
            desc.append("<Default Constructor>");
        }
        return desc.toString();
    }

    public static Icon getIconForSubstrate(Substrate s) {
        return NodeIcons.getIconForSubstrate(s);
    }

    public static Icon getIconForTemplate(DeviceTemplate template) {
        return NodeIcons.getIconForTemplate(template);
    }

    public static Icon getIconForTemplateType(DeviceTemplate.Type type) {
        return NodeIcons.getIconForTemplateType(type);
    }

    public void setRelationDisplay(RELATION_DISPLAY type) {
        this.mRelationDisplay = type;
    }

    public void setCountCommentDisplay(boolean enable) {
        this.mCountCommentDisplay = enable;
    }

    public boolean isShowRelations() {
        return this.mRelationDisplay != RELATION_DISPLAY.HIDE;
    }

    public static Icon getIconForDevice(Device device) {
        return NodeIcons.getIconForDevice(device);
    }

    public static Icon getIconForPinTemplate(PinTemplate pt) {
        return NodeIcons.getIconForPinTemplate(pt);
    }

    public static Icon getIconForNet(Net net) {
        return NodeIcons.getIconForNet(net);
    }

    public static Icon getFolderIcon() {
        return NodeIcons.getFolderIcon();
    }

    public static Icon getIconForDbObject(DbObject dbo) {
        return NodeIcons.getIconForDbObject(dbo);
    }

    public static boolean enableExtendedUI() {
        return System.getProperty(ENABLE_EXTENDED_UI) != null;
    }

    public static AAppView getCurOrbitView() {
        OrbitIO app = OrbitIO.getOrbitIO();
        if (app == null) {
            return null;
        }
        return app.getCurrentView();
    }

    public State getState() {
        return new State();
    }

    public void putState(State state) {
        TreePath p;
        for (DbTreePath dbtp : state.getExpanded()) {
            p = dbtp.findPath(this.mTree.getModel());
            if (p == null) continue;
            this.mTree.expandPath(p);
        }
        for (DbTreePath dbtp : state.getSelected()) {
            p = dbtp.findPath(this.mTree.getModel());
            if (p == null) continue;
            this.mTree.addSelectionPath(p);
        }
    }

    public IterableIterator<TreePath> getPathItrExcludingUnloadedJitNodes(final TreeModel m) {
        Object rootNode = m.getRoot();
        if (rootNode == null) {
            return AEmptyItr.create();
        }
        final LinkedList<ASingletonItr> queue = new LinkedList<ASingletonItr>();
        TreePath rootPath = new TreePath(rootNode);
        queue.add(new ASingletonItr((Object)rootPath));
        return AIterableItr.itr((Iterator)new Iterator<TreePath>(){
            TreePath prev = null;
            {
                this.advance();
            }

            void advance() {
                while (queue != null && !queue.isEmpty() && !((Iterator)queue.getFirst()).hasNext()) {
                    queue.remove();
                }
            }

            @Override
            public boolean hasNext() {
                if (this.prev != null) {
                    JitDbTreeNode jitNode;
                    final Object parentNode = this.prev.getLastPathComponent();
                    Iterator<DbTreeNode> childItr = parentNode instanceof JitDbTreeNode ? ((jitNode = (JitDbTreeNode)parentNode).isChildrenValid() ? AUtil.getIterator(jitNode.children()) : AEmptyItr.create()) : new Iterator<DbTreeNode>(){
                        Object mParentNode;
                        int count;
                        int nextIdx;
                        {
                            this.mParentNode = parentNode;
                            this.count = m.getChildCount(parentNode);
                            this.nextIdx = 0;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.nextIdx < this.count;
                        }

                        @Override
                        public DbTreeNode next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            return (DbTreeNode)m.getChild(this.mParentNode, this.nextIdx++);
                        }
                    };
                    ProcessingIterator<DbTreeNode, TreePath> childPathItr = new ProcessingIterator<DbTreeNode, TreePath>((Iterator)childItr){
                        TreePath mParentNode;

                        protected void init() {
                            this.mParentNode = prev;
                            super.init();
                        }

                        protected TreePath process(DbTreeNode o) {
                            return this.mParentNode.pathByAddingChild(o);
                        }
                    };
                    if (childPathItr.hasNext()) {
                        queue.add(childPathItr);
                    }
                    this.prev = null;
                }
                return queue != null && !queue.isEmpty();
            }

            @Override
            public TreePath next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.prev = (TreePath)((Iterator)queue.getFirst()).next();
                this.advance();
                return this.prev;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("ATreeUtil.getDescendantBreadthFirstItr() iterator does not support remove().");
            }
        });
    }

    private static void collapseTreeAll(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        DbExplorerPanel.collapseTreeAll(tree, new TreePath(root));
    }

    private static void collapseTreeAll(JTree tree, TreePath path) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node instanceof JitDbTreeNode && !((JitDbTreeNode)node).isChildrenValid()) {
            tree.collapsePath(path);
            return;
        }
        if (!tree.isExpanded(path)) {
            return;
        }
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                TreeNode n = enumeration.nextElement();
                TreePath p = path.pathByAddingChild(n);
                DbExplorerPanel.collapseTreeAll(tree, p);
            }
        }
        tree.collapsePath(path);
    }

    public void collapseNodes() {
        DbExplorerPanel.collapseTreeAll(this.mTree);
        TreeNode root = (TreeNode)this.mTree.getModel().getRoot();
        DbExplorerPanel.expandHierLevels(this.mTree, new TreePath(root), 2);
    }

    public class State {
        protected LinkedList<DbTreePath> mExpanded = Lists.newLinkedList();
        protected LinkedList<DbTreePath> mSelected = Lists.newLinkedList();

        public State() {
            TreePath[] selected;
            TreePath rootPath = new TreePath(DbExplorerPanel.this.mTree.getModel().getRoot());
            Enumeration<TreePath> expanded = DbExplorerPanel.this.mTree.getExpandedDescendants(rootPath);
            if (expanded != null) {
                for (TreePath p : AUtil.getIterable(expanded)) {
                    DbTreePath tp = DbTreePath.fromTreePath(p);
                    if (tp == null) continue;
                    this.mExpanded.add(tp);
                }
            }
            if ((selected = DbExplorerPanel.this.mTree.getSelectionPaths()) != null) {
                for (TreePath p : selected) {
                    DbTreePath tp = DbTreePath.fromTreePath(p);
                    if (tp == null) continue;
                    this.mSelected.add(tp);
                }
            }
        }

        public Iterable<DbTreePath> getExpanded() {
            return this.mExpanded;
        }

        public Iterable<DbTreePath> getSelected() {
            return this.mSelected;
        }
    }

    public static class DbTreePath
    extends LinkedList<DbTreeNode> {
        public static DbTreePath fromTreePath(TreePath p) {
            DbTreePath res = new DbTreePath();
            for (Object o : p.getPath()) {
                if (!(o instanceof DbTreeNode)) {
                    return null;
                }
                DbTreeNode dbtn = (DbTreeNode)o;
                res.add(dbtn);
            }
            return res;
        }

        public TreePath findPath(TreeModel m) {
            TreePath res = null;
            DbTreeNode curActualNode = (DbTreeNode)m.getRoot();
            for (DbTreeNode curRefNode : this) {
                if (res == null) {
                    if (curRefNode.equiv(curActualNode)) {
                        res = new TreePath(curActualNode);
                        continue;
                    }
                    return null;
                }
                boolean found = false;
                for (int i = 0; i < m.getChildCount(curActualNode); ++i) {
                    DbTreeNode dbtn;
                    Object o = m.getChild(curActualNode, i);
                    if (!(o instanceof DbTreeNode) || !curRefNode.equiv(dbtn = (DbTreeNode)o)) continue;
                    found = true;
                    res = res.pathByAddingChild(dbtn);
                    curActualNode = dbtn;
                    break;
                }
                if (found) continue;
                return null;
            }
            return res;
        }
    }

    public static class DALinkHandler
    extends OrbitHyperlinkHandler {
        protected AFloatWindow mFloatWindow;
        protected DbTreeNode mDbTreeNode;

        public DALinkHandler(AFloatWindow fw, DbTreeNode dbtn) {
            super(fw);
            this.mDbTreeNode = dbtn;
        }

        @Override
        protected void ownerDataChanged() {
            JComponent c = this.mDbTreeNode.getDetailsView();
            if (!(c instanceof HTMLViewer)) {
                return;
            }
            HTMLViewer hv = (HTMLViewer)c;
            this.mFloatWindow.setHtmlContents(hv.getText());
        }
    }

    public static class HTMLViewer
    extends JTextPane {
        public HTMLViewer() {
            HTMLEditorKit hek = new HTMLEditorKit();
            this.setBorder(null);
            this.setEditorKit(hek);
            this.setEditable(false);
            HTMLDocument doc = (HTMLDocument)hek.createDefaultDocument();
            StyleSheet styleSheet = doc.getStyleSheet();
            styleSheet.addRule("body {font-family: sans-serif}");
            styleSheet.addRule("td {padding: 1px; border-width: 1px}");
            styleSheet.addRule("th {text-align: left}");
            styleSheet.addRule("h3 {text-decoration:underline; margin-bottom:2px}");
            styleSheet.addRule("pre {font-size: x-small; font-family: sans-serif}");
            this.setDocument(doc);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            this.setCaretPosition(0);
        }
    }

    static class NewInstFromCtorsDlg
    extends ADialog {
        protected Db mDb = null;
        protected List<Constructor<?>> mCtors = null;
        protected JComboBox<APair<Constructor<?>, String>> mCboCtors = null;
        protected JPanel mCtorArgsPanel = null;
        protected Object mNewObj = null;

        public static NewInstFromCtorsDlg create(Window owner, Db db, List<Constructor<?>> ctors) {
            if (owner instanceof Frame) {
                return new NewInstFromCtorsDlg((Frame)owner, db, ctors);
            }
            if (owner instanceof Dialog) {
                return new NewInstFromCtorsDlg((Dialog)owner, db, ctors);
            }
            return new NewInstFromCtorsDlg(db, ctors);
        }

        public NewInstFromCtorsDlg(Frame owner, Db db, List<Constructor<?>> ctors) {
            super(owner, true);
            this.init(db, ctors);
        }

        public NewInstFromCtorsDlg(Dialog owner, Db db, List<Constructor<?>> ctors) {
            super(owner, true);
            this.init(db, ctors);
        }

        public NewInstFromCtorsDlg(Db db, List<Constructor<?>> ctors) {
            this.init(db, ctors);
        }

        protected void init(Db db, List<Constructor<?>> ctors) {
            this.mDb = db;
            this.mCtors = ctors;
            GridBagManager gbm = new GridBagManager((Container)((Object)this));
            gbm.add("Available constructors:");
            this.mCboCtors = new JComboBox();
            gbm.add(this.mCboCtors, (GridBagConstraints)GridBagManager.FILLX);
            gbm.newline();
            this.mCtorArgsPanel = new JPanel();
            this.mCtorArgsPanel.setBorder(null);
            new GridBagManager((Container)this.mCtorArgsPanel);
            gbm.add((Component)this.mCtorArgsPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            gbm.newline();
            gbm.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            gbm.addFillX();
            JButton btnOk = new JButton("OK");
            btnOk.addActionListener(e -> this.doApply());
            gbm.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            JButton btnCancel = new JButton("Cancel");
            gbm.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            gbm.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            for (Constructor<?> ctor : ctors) {
                String desc = DbExplorerPanel.getConstructorDescription(ctor);
                if (desc == null) continue;
                this.mCboCtors.addItem(new APair<Constructor<?>, String>(ctor, desc){

                    public String toString() {
                        return (String)this.second;
                    }
                });
            }
            this.mCboCtors.addActionListener(e -> this.ctorChanged());
            this.ctorChanged();
        }

        protected void ctorChanged() {
            GridBagManager gbm = new GridBagManager((Container)this.mCtorArgsPanel);
            this.mCtorArgsPanel.removeAll();
            Constructor ctor = (Constructor)((APair)this.mCboCtors.getSelectedItem()).first;
            for (Class<?> type : ctor.getParameterTypes()) {
                String curParm = DbExplorerPanel.getSupportedCtorTypeName(type);
                assert (curParm != null);
                gbm.add(curParm);
                gbm.add((Component)new JTextField(25), (GridBagConstraints)GridBagManager.FILLX);
                gbm.newline();
            }
            gbm.addFillY();
            this.pack();
        }

        protected void doApply() {
            Constructor ctor = (Constructor)((APair)this.mCboCtors.getSelectedItem()).first;
            Component[] comps = this.mCtorArgsPanel.getComponents();
            Class<?>[] types = ctor.getParameterTypes();
            int argCount = types.length;
            Object[] args = new Object[argCount];
            for (int i = 0; i < argCount; ++i) {
                Component c = comps[i * 2 + 1];
                if (!(c instanceof JTextField)) continue;
                JTextField f = (JTextField)c;
                String a = f.getText();
                Class<?> type = types[i];
                try {
                    if (String.class.isAssignableFrom(type)) {
                        args[i] = a;
                        continue;
                    }
                    if (Integer.TYPE.isAssignableFrom(type)) {
                        AFieldValidator.validateInt((JTextField)f);
                        args[i] = Integer.parseInt(a);
                        continue;
                    }
                    if (Float.TYPE.isAssignableFrom(type)) {
                        AFieldValidator.validateInt((JTextField)f);
                        args[i] = Float.valueOf(Float.parseFloat(a));
                        continue;
                    }
                    if (Double.TYPE.isAssignableFrom(type)) {
                        AFieldValidator.validateInt((JTextField)f);
                        args[i] = Double.parseDouble(a);
                        continue;
                    }
                    if (Boolean.TYPE.isAssignableFrom(type)) {
                        AFieldValidator.validateInt((JTextField)f);
                        args[i] = Boolean.parseBoolean(a);
                        continue;
                    }
                    if (!DbObject.class.isAssignableFrom(type)) continue;
                    DbClass dbClass = this.mDb.getDbClass(type);
                    DbObject arg = dbClass.getInstanceByKeyStr(a);
                    if (arg == null) {
                        throw AFieldValidator.createException((String)a, (String)type.getSimpleName(), null, (Component)f);
                    }
                    args[i] = arg;
                    continue;
                }
                catch (AFieldValidator.AFieldValidationException e) {
                    return;
                }
            }
            try {
                this.mNewObj = ctor.newInstance(args);
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Unable to instantiate object.", (Object[])new Object[0]);
            }
            UIUtil.closeWindow((Window)((Object)this));
        }

        Object getNewObject() {
            return this.mNewObj;
        }
    }

    protected class ActionZoomToDevice
    extends AbstractAction {
        DesignView2D mView;
        Device mDevice;

        public ActionZoomToDevice(AAppView view, Device device) {
            super("Zoom to Device");
            if (!(view instanceof DesignView2D)) {
                this.setEnabled(false);
                return;
            }
            this.mView = (DesignView2D)view;
            this.mDevice = device;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mDevice == null) {
                assert (false);
                return;
            }
            DevicePath dpath = this.mDevice.getADevicePath();
            ARect bounds = dpath.getBB();
            if (bounds == null) {
                assert (false);
                return;
            }
            ARect r = new ARect(bounds);
            r.changeSizeBy(0.1);
            this.mView.getCanvas().getXForm().setWorld(r);
            this.mView.getCanvas().refresh();
        }
    }

    protected class ActionShowInDesignNets
    extends AbstractAction {
        protected Net mNet;
        protected DevicePath mDevice;

        public ActionShowInDesignNets(Net net, DevicePath device) {
            super("Show in 'Design Nets'");
            this.mNet = net;
            this.mDevice = device;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DbExplorerPanel.this.mExploreNetListener != null) {
                DbExplorerPanel.this.mExploreNetListener.exploreNet(this.mDevice, this.mNet);
            }
        }
    }

    public class ActionRefreshNodes
    extends AbstractAction {
        public ActionRefreshNodes() {
            super("Refresh All Nodes", UIUtil.getScaledIcon((Icon)OrbitIcons.REFRESH, (int)16, (int)16));
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Refresh"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbExplorerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DbExplorerPanel.this.setDb(DbExplorerPanel.this.mDb);
            DbExplorerPanel.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public class DbRelationNode
    extends JitDbTreeNode {
        protected DbRelationDef mDbRel;

        public DbRelationNode(DbTreeNode parent, DbRelationDef dbRel) {
            super(parent);
            this.mDbRel = null;
            this.mDbRel = dbRel;
            assert (this.mDbRel != null);
        }

        public DbRelationDef getDbRel() {
            return this.mDbRel;
        }

        @Override
        public void populateChildren() {
            ArrayList<DbClassNode> children;
            this.mChildren = children = new ArrayList<DbClassNode>();
            children.add(new DbClassNode(this, this.mDbRel.getDbClassL()));
            children.add(new DbClassNode(this, this.mDbRel.getDbClassR()));
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(DBEResources.ICON_DBRELATION);
        }

        @Override
        public String getText() {
            return this.mDbRel.getName();
        }

        @Override
        public JComponent getDetailsView() {
            String html = "<h2>" + this.getText() + "</h2>";
            return DbExplorerPanel.getHTMLViewer(html);
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            return other instanceof DbRelationNode && ((DbRelationNode)other).mDbRel.equals(this.mDbRel);
        }
    }

    public class DbRelatedObjectsNode
    extends JitDbTreeNode {
        protected DbRelationDef mDbRel;
        protected boolean mParentIsLeft;

        public DbRelatedObjectsNode(DbObjNode<?> parent, DbRelationDef dbRel, boolean parentIsLeft) {
            super(parent);
            this.mDbRel = null;
            this.mDbRel = dbRel;
            assert (this.mDbRel != null);
            this.mParentIsLeft = parentIsLeft;
        }

        public DbRelationDef getDbRel() {
            return this.mDbRel;
        }

        @Override
        public void populateChildren() {
            ArrayList<DbObjNode> children = new ArrayList<DbObjNode>();
            DbObjNode parent = (DbObjNode)this.getParent();
            Object dbobj = parent.getDbObj();
            for (DbObject related : this.mDbRel.getRelated(dbobj, this.mParentIsLeft)) {
                children.add(new DbObjNode(DbExplorerPanel.this, (DbTreeNode)this, related));
            }
            this.setChildren(children);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            if (this.mParentIsLeft) {
                r.setIcon(DBEResources.ICON_DBRELATION_LTOR);
            } else {
                r.setIcon(DBEResources.ICON_DBRELATION_RTOL);
            }
        }

        @Override
        public String getText() {
            return this.mDbRel.getName();
        }

        @Override
        public JComponent getDetailsView() {
            Object html = "";
            html = (String)html + "<h2>" + this.mDbRel.getName() + "</h2>";
            return DbExplorerPanel.getHTMLViewer((String)html);
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DbRelatedObjectsNode)) {
                return false;
            }
            DbRelatedObjectsNode o = (DbRelatedObjectsNode)other;
            return o.mDbRel.equals(this.mDbRel) && o.mParentIsLeft == this.mParentIsLeft && o.mParent.equals(this.mParent);
        }
    }

    public static class DbObjNode<T extends DbObject>
    extends JitDbTreeNode {
        protected T mDbObj;
        final /* synthetic */ DbExplorerPanel this$0;

        public DbObjNode(DbTreeNode parent, T dbObj) {
            this.this$0 = this$0;
            super(parent);
            this.mDbObj = null;
            this.mDbObj = dbObj;
            assert (this.mDbObj != null);
        }

        public T getDbObj() {
            return this.mDbObj;
        }

        @Override
        public void populateChildren() {
            ArrayList<JitDbTreeNode> children;
            this.mChildren = children = new ArrayList<JitDbTreeNode>();
            DbClass dbClass = this.mDbObj.getDbClass();
            if (dbClass == null) {
                return;
            }
            switch (this.this$0.mRelationDisplay) {
                case GROUP: {
                    children.add(this.this$0.new DbRelationsGroupNode(this));
                    break;
                }
                case DISPLAY: {
                    for (DbRelationDef rel : this.this$0.mDb.getRelations()) {
                        if (rel.getDbClassL() == dbClass) {
                            children.add(this.this$0.new DbRelatedObjectsNode(this, rel, true));
                            continue;
                        }
                        if (rel.getDbClassR() != dbClass) continue;
                        children.add(this.this$0.new DbRelatedObjectsNode(this, rel, false));
                    }
                    for (DbRelationDef rel : dbClass.getRuntimeRefRelations()) {
                        if (!rel.getRelated(this.mDbObj, false).hasNext()) continue;
                        children.add(this.this$0.new DbRelatedObjectsNode(this, rel, false));
                    }
                    break;
                }
            }
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            if (this.this$0.mDbSelection != null && this.this$0.mDbSelection.contains(this.mDbObj)) {
                r.setFont(r.getFont().deriveFont(1));
            }
            r.setText(this.getText());
            r.setIcon(this.getIcon());
        }

        @Override
        public String getText() {
            if (this.mDbObj.getDb() == null) {
                return DbExplorerPanel.TEXT_INVALID;
            }
            return this.mDbObj.getDbClass().getName() + ": " + this.mDbObj.getKeyStr();
        }

        public Icon getIcon() {
            return NodeIcons.getIconForDbObject(this.mDbObj);
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            OrbitIO orbitIO = OrbitIO.getOrbitIO();
            if (orbitIO == null) {
                super.populateMenuItems(items);
            } else {
                OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
                ObjectActionRegistry oar = gws.getObjectActionRegistry();
                HierInst<T> hdbo = this.getHierInst();
                LinkedList objItems = AMenuUtil.groupByFirstWord(oar.getJMenuItems(hdbo));
                AMenuUtil.sort((List)objItems, (boolean)true);
                for (JMenuItem item : objItems) {
                    items.add(item);
                }
            }
            if (this.getClass() == DbObjNode.class) {
                Selection sel = new Selection(this.this$0.mDb);
                sel.add(this.getHierInst());
                for (Action a : AUtil.arrayList(DbObjectUI.ActionFactorySelection.getActions(sel, null))) {
                    items.add(ObjectActionRegistry.getJMenuItem(a));
                }
            }
        }

        public HierInst<T> getHierInst() {
            return new HierInst(this.getDevicePath(), this.mDbObj);
        }

        @Override
        public JComponent getDetailsView() {
            return null;
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DbObjNode)) {
                return false;
            }
            DbObjNode o = (DbObjNode)other;
            return o.mDbObj.equals(this.mDbObj);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!other.getClass().equals(this.getClass())) {
                return false;
            }
            T dboOther = ((DbObjNode)other).mDbObj;
            if (this.mDbObj == null) {
                return dboOther == null;
            }
            return this.mDbObj.equals(dboOther);
        }

        public int hashCode() {
            return this.mDbObj.hashCode();
        }

        public DbTreeNode findChild(Enumeration<? extends DbTreeNode> children, DbObject dbo) {
            for (DbTreeNode n : AUtil.getIterable(children)) {
                if (!(n instanceof DbObjNode) || ((DbObjNode)n).mDbObj != dbo) continue;
                return n;
            }
            return null;
        }

        public Device getDevice() {
            for (DbTreeNode node = this; node != null; node = node.getParent()) {
                if (!(node instanceof DeviceHierarchyNode)) continue;
                return (Device)((DeviceHierarchyNode)node).getDbObj();
            }
            return null;
        }

        public DevicePath getDevicePath() {
            return DbExplorerPanel.getDevicePath(this.getTreePath());
        }

        protected String getDevicePathString() {
            DevicePath dp = this.getDevicePath();
            if (dp == null) {
                return null;
            }
            return dp.toString();
        }
    }

    public class DbClassNode
    extends JitDbTreeNode {
        protected static final String DBCLASS_RUNTIME = "<Runtime>";
        protected DbClass mDbClass;
        protected int mDbObjTotalCount;
        protected int mDbObjShowCount;

        public DbClassNode(DbTreeNode parent, DbClass dbClass) {
            super(parent);
            this.mDbClass = null;
            this.mDbObjTotalCount = -1;
            this.mDbObjShowCount = -1;
            this.mDbClass = dbClass;
        }

        public DbClass getDbClass() {
            return this.mDbClass;
        }

        @Override
        public void populateChildren() {
            this.getCountsAsNeeded();
            ArrayList<DbObjNode> children = new ArrayList<DbObjNode>();
            if (this.mDbClass != null) {
                IterableIterator itr = this.mDbClass.getInstances(false);
                for (int i = 0; i < this.mDbObjShowCount; ++i) {
                    DbObject e = (DbObject)itr.next();
                    children.add(new DbObjNode(DbExplorerPanel.this, (DbTreeNode)this, e));
                }
                children.sort((x, y) -> PrimaryKey.compare((DbPrimaryKey)x.getDbObj().getPrimaryKey(), (DbPrimaryKey)y.getDbObj().getPrimaryKey()));
                this.mSortChildren = true;
            }
            this.setChildren(children);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            this.getCountsAsNeeded();
            r.setText(this.getText());
            r.setIcon(this.getIcon());
        }

        public Icon getIcon() {
            return DBEResources.ICON_DBCLASS;
        }

        @Override
        public String getText() {
            Object strCount = this.mDbObjTotalCount == this.mDbObjShowCount ? "" + this.mDbObjTotalCount : String.format("%d of %d", this.mDbObjShowCount, this.mDbObjTotalCount);
            return this.mDbClass == null ? DBCLASS_RUNTIME : this.mDbClass.getName() + " (" + (String)strCount + ")";
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DbClassNode)) {
                return false;
            }
            DbClassNode o = (DbClassNode)other;
            if (this.mDbClass == null) {
                return o.mDbClass == null;
            }
            return o.mDbClass.equals((Object)this.mDbClass);
        }

        @Override
        public void invalidateChildren() {
            super.invalidateChildren();
            this.mDbObjShowCount = -1;
            this.mDbObjTotalCount = -1;
        }

        protected void getCountsAsNeeded() {
            if (this.mDbObjTotalCount < 0 || !this.mChildrenValid) {
                MutableInteger actual = new MutableInteger();
                int oldShowCount = this.mDbObjShowCount;
                this.mDbObjShowCount = DbExplorerPanel.getDbObjDisplayCount(this.mDbClass, actual);
                this.mDbObjTotalCount = actual.getValue();
                if (oldShowCount > this.mDbObjShowCount) {
                    this.mDbObjShowCount = Math.min(oldShowCount, this.mDbObjTotalCount);
                }
            }
        }

        @Override
        public JComponent getDetailsView() {
            assert (DbExplorerPanel.this.mDb != null);
            if (DbExplorerPanel.this.mDb == null) {
                return null;
            }
            if (this.mDbClass == null) {
                Object html = String.format("<h2>DbClass: Unknown (<i>%s</i>)</h2>", AUtil.escapeHtml((String)DBCLASS_RUNTIME));
                html = (String)html + "<div><i>No further information is available.</i></div>";
                return DbExplorerPanel.getHTMLViewer((String)html);
            }
            StringBuilder html = new StringBuilder("<h2>DbClass: " + this.mDbClass.getName() + "</h2>");
            if (this.mDbClass.getDb() == null) {
                html.append("<div><i>This class is not in a database.</i></div>");
                return DbExplorerPanel.getHTMLViewer(html.toString());
            }
            this.getCountsAsNeeded();
            html.append("There are " + this.mDbObjTotalCount + " database objects of this database class.");
            html.append("<br><h2>Fields</h2>");
            html.append("<table><tr><th>Name</th><th>Type</th><th>Key</th><th>Persists</th><th>Relation</th><th>Soft</th></tr>\n");
            for (DbFieldDef fd : this.mDbClass.getFields()) {
                String tableDataStrFormat = "<td>%s</td>";
                html.append("<tr>");
                html.append(String.format("<td>%s</td>", fd.getName()));
                html.append(String.format("<td>%s</td>", fd.getFieldClass().getSimpleName()));
                html.append(String.format("<td>%s</td>", fd.getIsKey()));
                html.append(String.format("<td>%s</td>", fd.getPersist()));
                html.append(String.format("<td>%s</td>", fd.getRelation() != null));
                html.append(String.format("<td>%s</td>", !fd.getIsHard()));
                html.append("</tr>\n");
            }
            html.append("</table>");
            if (DbExplorerPanel.this.mDb != null) {
                html.append("<br><h2>Relations</h2>");
                html.append("<table><tr><th>Name</th><th>Side</th><th>Related</th></tr>\n");
                String side = null;
                DbClass other = null;
                for (DbRelationDef rel : DbExplorerPanel.this.mDb.getRelations()) {
                    if (rel.getDbClassL().isAssignableFrom(this.mDbClass)) {
                        side = "left";
                        other = rel.getDbClassR();
                    } else {
                        if (rel.getDbClassR() == null || !rel.getDbClassR().isAssignableFrom(this.mDbClass)) continue;
                        side = "right";
                        other = rel.getDbClassL();
                    }
                    html.append("<tr>");
                    html.append(String.format("<td>%s</td>", rel.getName()));
                    html.append(String.format("<td>%s</td>", side));
                    html.append(String.format("<td>%s</td>", other == null ? "{unknown}" : other.getName()));
                    html.append("</tr>\n");
                }
                html.append("</table>");
            }
            return DbExplorerPanel.getHTMLViewer(html.toString());
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            this.getCountsAsNeeded();
            if (this.mDbObjShowCount < this.mDbObjTotalCount) {
                items.add(new MenuItemShowMore());
            }
            super.populateMenuItems(items);
            if (DbExplorerPanel.this.mCreateEnabled) {
                items.add(new JMenuItem(new MenuItemCreateInst()));
            }
        }

        protected class MenuItemShowMore
        extends JMenuItem {
            protected boolean mShiftDown = false;
            protected final String TXT_SHOW_MORE = "Show more";
            protected final String TXT_SHOW_ALL = "Show all";
            protected ActionListener mHandler = e -> {
                this.updateShift(e);
                DbClassNode.this.mDbObjShowCount = this.mShiftDown ? DbClassNode.this.mDbObjTotalCount : Math.min(DbClassNode.this.mDbObjShowCount += Integer.MAX_VALUE, DbClassNode.this.mDbObjTotalCount);
                DbClassNode.this.populateChildren();
                if (DbClassNode.this.mChildren != null && DbClassNode.this.mSortChildren) {
                    Collections.sort(DbClassNode.this.mChildren);
                }
                DbTreeModel tm = (DbTreeModel)((Object)((Object)DbExplorerPanel.this.mTree.getModel()));
                tm.fireTreeStructureChanged(this, DbClassNode.this.getTreePath().getPath(), new int[0], new Object[0]);
            };
            protected KeyEventDispatcher mKeyEventHandler = e -> {
                this.updateShift(e);
                return false;
            };

            public MenuItemShowMore() {
                this.setText("Show more");
                this.setToolTipText("Shift-click this menu item to show all");
                this.updateShift(EventQueue.getCurrentEvent());
                this.addActionListener(this.mHandler);
            }

            @Override
            public void addNotify() {
                super.addNotify();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.mKeyEventHandler);
            }

            @Override
            public void removeNotify() {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.mKeyEventHandler);
                super.removeNotify();
            }

            protected void updateShift(AWTEvent e) {
                boolean b;
                if (!(e instanceof InputEvent)) {
                    return;
                }
                InputEvent ie = (InputEvent)e;
                boolean bl = b = 0 != (ie.getModifiersEx() & 0x40);
                if (b == this.mShiftDown) {
                    return;
                }
                this.mShiftDown = b;
                this.setText(b ? "Show all" : "Show more");
            }
        }

        protected class MenuItemCreateInst
        extends AbstractAction {
            public MenuItemCreateInst() {
                super("Create " + DbClassNode.this.mDbClass.getName() + "...");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Class cls = DbClassNode.this.mDbClass.getJavaClass();
                LinkedList ctors = new LinkedList();
                for (Constructor<?> ctor : cls.getConstructors()) {
                    String desc = DbExplorerPanel.getConstructorDescription(ctor);
                    if (desc == null) continue;
                    ctors.add(ctor);
                }
                if (ctors.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Unable to create object, no parsable constructors.");
                    return;
                }
                NewInstFromCtorsDlg createDlg = NewInstFromCtorsDlg.create(AApp.getApp().getMainWin(), DbExplorerPanel.this.mDb, ctors);
                createDlg.setTitle("Create new " + DbClassNode.this.mDbClass.getName());
                createDlg.setVisible(true);
                Object newObj = createDlg.getNewObject();
                if (newObj != null) {
                    DbObject dbobj = (DbObject)newObj;
                    DbExplorerPanel.this.mDb.add(dbobj);
                    DbClassNode.this.invalidateChildren();
                    DbExplorerPanel.this.mTree.expandPath(DbClassNode.this.getTreePath());
                }
            }
        }
    }

    public class AllRelationsNode
    extends JitDbTreeNode {
        public AllRelationsNode(DatabaseNode parent) {
            super(parent);
            assert (DbExplorerPanel.this.mDb != null);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(this.getIcon());
        }

        public Icon getIcon() {
            return UIManager.getIcon("Tree.openIcon");
        }

        @Override
        public String getText() {
            return String.format("Relations (%s)", DbExplorerPanel.this.mDb == null ? "<Db Closed>" : DbExplorerPanel.this.mDb.getDescription(false));
        }

        @Override
        public void populateChildren() {
            ArrayList<DbRelationNode> children = new ArrayList<DbRelationNode>();
            for (DbRelationDef relation : DbExplorerPanel.this.mDb.getRelations()) {
                children.add(new DbRelationNode(this, relation));
            }
            this.setChildren(children);
        }

        @Override
        public JComponent getDetailsView() {
            String html = "<h2>Database " + DbExplorerPanel.this.mDb.getDescription(false) + "</h2>";
            html = html + String.format("%s<br><br>", DbExplorerPanel.this.mDb.getDescription(true));
            html = html + String.format("There are %d database relationships defined.", this.getChildCount());
            return DbExplorerPanel.getHTMLViewer(html);
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            return other instanceof AllRelationsNode;
        }
    }

    public class NetHierarchyNode
    extends DbObjNode<Net> {
        protected NetMap mNetMap;
        protected int mChildDeviceCount;

        public NetHierarchyNode(DbTreeNode parent, Net net) {
            super(DbExplorerPanel.this, parent, (DbObject)net);
            this.mChildDeviceCount = -1;
        }

        public NetHierarchyNode(NetHierarchyNode parent, NetMap netMap) {
            super(DbExplorerPanel.this, (DbTreeNode)parent, (DbObject)netMap.getChildNet());
            this.mChildDeviceCount = -1;
            if (netMap.getDevice() == null) {
                ALog.logDebug((String)("Creating node for invalid NetMap:  " + netMap.toString()));
            }
            this.mNetMap = netMap;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(this.getIcon());
        }

        @Override
        public Icon getIcon() {
            return DbExplorerPanel.getIconForNet(this.getDbObj() != null ? (Net)this.getDbObj() : null);
        }

        @Override
        public String getText() {
            String name;
            if (this.mNetMap != null) {
                name = this.mNetMap.getDevice() == null ? DbExplorerPanel.TEXT_INVALID : String.format("%s: %s", this.mNetMap.getDevice().getName(), this.mNetMap.getChildNet().getName());
            } else if (this.getDbObj() != null) {
                name = ((Net)this.getDbObj()).getName();
                if (name == null) {
                    name = "";
                }
            } else {
                name = "<unknown>";
            }
            int childDeviceCount = this.getDbObj() != null && this.mNetMap != null ? this.getChildCount() : 0;
            return childDeviceCount > 0 ? String.format("%s (%d)", name, childDeviceCount) : name;
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof NetHierarchyNode)) {
                return false;
            }
            NetHierarchyNode o = (NetHierarchyNode)other;
            return (this.mNetMap == o.mNetMap || o.mNetMap != null && o.mNetMap.equals(this.mNetMap)) && ((Net)o.getDbObj()).equals(this.getDbObj());
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            AAppView view;
            super.populateMenuItems(items);
            if (this.mNetMap != null && this.mNetMap.getDevice() != null && (view = DbExplorerPanel.getCurOrbitView()) != null && view.getDb() == ((Net)this.mDbObj).getDb()) {
                JMenuItem mi = new JMenuItem(new ActionZoomToDevice(view, this.mNetMap.getDevice()));
                items.add(mi);
            }
        }

        public NetHierarchyNode getTopNetNode() {
            DbTreeNode tn = this.getParent();
            if (tn instanceof NetHierarchyNode) {
                return ((NetHierarchyNode)tn).getTopNetNode();
            }
            return this;
        }

        @Override
        public void populateChildren() {
            ArrayList<DbObjNode> children = new ArrayList<DbObjNode>();
            if (this.getDbObj() != null && ((Net)this.getDbObj()).getDb() != null) {
                for (NetMap nm : NetMap.getChildNets((Net)((Net)this.getDbObj()))) {
                    children.add(new NetHierarchyNode(this, nm));
                }
                if (DbExplorerPanel.this.getClientProperty("ShowNetPorts") != null) {
                    for (PinTemplate dtp : ((Net)this.getDbObj()).getPins()) {
                        children.add(new DbObjNode(DbExplorerPanel.this, (DbTreeNode)this, (DbObject)dtp));
                    }
                }
            }
            this.setChildren(children);
        }

        public NetHierarchyNode getChildFor(Net net, Device device) {
            this.populateChildrenAsNeeded();
            List children = this.mChildren;
            for (DbTreeNode c : children) {
                if (!(c instanceof NetHierarchyNode)) continue;
                NetHierarchyNode nhn = (NetHierarchyNode)c;
                if (nhn.mNetMap.getChildNet() != net || nhn.mNetMap.getDevice() != device) continue;
                return nhn;
            }
            return null;
        }
    }

    public class NetHierarchyDesignNetsNode
    extends JitDbTreeNode {
        public NetHierarchyDesignNetsNode(DbTreeNode parent) {
            super(parent);
            assert (DbExplorerPanel.this.mDb != null);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(this.getIcon());
        }

        public Icon getIcon() {
            return DBEResources.ICON_DESIGNNETS;
        }

        @Override
        public String getText() {
            return "Design Nets (" + DbExplorerPanel.this.mDb.getDescription(false) + ")";
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            return other instanceof NetHierarchyDesignNetsNode;
        }

        @Override
        public void populateChildren() {
            ArrayList<NetHierarchyNode> children = new ArrayList<NetHierarchyNode>();
            for (Net n : DbExplorerPanel.this.mDb.getObjects(Net.class)) {
                if (n.getDeviceTemplate() != null && !(n.getDeviceTemplate() instanceof Design)) continue;
                children.add(new NetHierarchyNode(this, n));
            }
            this.setChildren(children);
        }

        @Override
        public JComponent getDetailsView() {
            String html = "<h2>Database " + DbExplorerPanel.this.mDb.getDescription(false) + "</h2>";
            html = html + String.format("%s<br><br>", DbExplorerPanel.this.mDb.getDescription(true));
            html = html + String.format("There are %d nets at the design level.", this.getChildCount());
            return DbExplorerPanel.getHTMLViewer(html);
        }

        public NetHierarchyNode getChildFor(Net net) {
            this.populateChildrenAsNeeded();
            List children = this.mChildren;
            for (DbTreeNode c : children) {
                NetHierarchyNode nhn;
                if (!(c instanceof NetHierarchyNode) || (nhn = (NetHierarchyNode)c).getDbObj() != net) continue;
                return nhn;
            }
            return null;
        }
    }

    public class DeviceTemplateNetsNode
    extends JitDbTreeNode {
        protected DeviceTemplate mDeviceTemplate;

        public DeviceTemplateNetsNode(DbTreeNode parent, DeviceTemplate dt) {
            super(parent);
            this.mDeviceTemplate = dt;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(this.getIcon());
        }

        public Icon getIcon() {
            return DBEResources.ICON_TEMPLATE;
        }

        @Override
        public String getText() {
            return String.format("Device Template '%s' (%d nets)", this.mDeviceTemplate.getName(), this.getChildCount());
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DeviceTemplateNetsNode)) {
                return false;
            }
            DeviceTemplateNetsNode o = (DeviceTemplateNetsNode)other;
            return o.mDeviceTemplate.equals(this.mDeviceTemplate);
        }

        @Override
        public void populateChildren() {
            ArrayList<NetHierarchyNode> children = new ArrayList<NetHierarchyNode>();
            for (Net n : this.mDeviceTemplate.getNets()) {
                children.add(new NetHierarchyNode(this, n));
            }
            this.setChildren(children);
        }

        public NetHierarchyNode getChildFor(Net net, Device device) {
            List children = this.mChildren;
            for (DbTreeNode c : children) {
                NetHierarchyNode nhn;
                if (!(c instanceof NetHierarchyNode) || (nhn = (NetHierarchyNode)c).getDbObj() != net) continue;
                return nhn;
            }
            return null;
        }
    }

    public class DeviceTemplatesNetsNode
    extends JitDbTreeNode {
        public DeviceTemplatesNetsNode(DbTreeNode parent) {
            super(parent);
            assert (DbExplorerPanel.this.mDb != null);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(this.getIcon());
        }

        public Icon getIcon() {
            return DBEResources.ICON_TEMPLATES;
        }

        @Override
        public String getText() {
            return String.format("Device Templates (%d)", this.getChildCount());
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            return other instanceof DeviceTemplatesNetsNode;
        }

        @Override
        public void populateChildren() {
            ArrayList<DeviceTemplateNetsNode> children = new ArrayList<DeviceTemplateNetsNode>();
            for (DeviceTemplate dt : DbExplorerPanel.this.mDb.getObjects(DeviceTemplate.class)) {
                children.add(new DeviceTemplateNetsNode(this, dt));
            }
            this.setChildren(children);
        }

        public DeviceTemplateNetsNode getChildFor(DeviceTemplate dt) {
            this.populateChildrenAsNeeded();
            List children = this.mChildren;
            for (DbTreeNode c : children) {
                if (!(c instanceof DeviceTemplateNetsNode)) continue;
                DeviceTemplateNetsNode dtnn = (DeviceTemplateNetsNode)c;
                if (dtnn.mDeviceTemplate != dt) continue;
                return dtnn;
            }
            return null;
        }
    }

    public class BundleNode
    extends DbObjNode<Bundle> {
        public BundleNode(DbTreeNode parent, Bundle bundle) {
            super(DbExplorerPanel.this, parent, (DbObject)bundle);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            APatternColor pc;
            r.setText(this.getText());
            r.setCountCommentText("" + this.getChildCount());
            r.setIcon(UIUtil.getScaledIcon((Icon)DBEResources.ICON_BUNDLE, (int)16, (int)16));
            ViewColorizer colorizer = DbExplorerPanel.this.mViewColorizer;
            if (!colorizer.isVisible(super.getDevicePath(), this.getDbObj())) {
                r.setTextDecoration(TextDecoration.DELETE);
            }
            r.setColorIcon(ViewColorizer.getColorIcon((Color)((pc = colorizer.getColor(super.getDevicePath(), (Bundle)this.getDbObj())) == null ? null : pc.getColor()), (boolean)false, (int)16));
        }

        @Override
        public String getText() {
            return ((Bundle)this.getDbObj()).getName();
        }

        @Override
        public void populateChildren() {
            ArrayList<PinTemplateNode> children = new ArrayList<PinTemplateNode>();
            Bundle bundle = (Bundle)this.getDbObj();
            HashSet<PinTemplate> ptSet = new HashSet<PinTemplate>();
            for (PinTemplate pt : bundle.getFixedContacts()) {
                if (pt.getDeviceTemplate() != bundle.getTemplate()) continue;
                ptSet.add(pt);
            }
            for (PinTemplate pt : bundle.getFreeContacts()) {
                if (pt.getDeviceTemplate() != bundle.getTemplate()) continue;
                ptSet.add(pt);
            }
            for (PinTemplate pt : ptSet) {
                PinTemplateNode node = new PinTemplateNode(this, pt);
                if (!DbExplorerPanel.this.filterTreeNode(node)) continue;
                children.add(node);
            }
            this.setChildren(children);
        }
    }

    public class BundlesNode
    extends JitDbTreeNode {
        private DeviceTemplate mTemplate;

        public BundlesNode(DbTreeNode parent, DeviceTemplate devT) {
            super(parent);
            this.mTemplate = devT;
        }

        @Override
        public void populateChildren() {
            ArrayList<BundleNode> children = new ArrayList<BundleNode>();
            for (Bundle b : this.mTemplate.getBundles()) {
                children.add(new BundleNode(this, b));
            }
            this.setChildren(children);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setCountCommentText("" + this.mTemplate.getBundleCount());
            r.setIcon(UIUtil.getScaledIcon((Icon)DBEResources.ICON_BUNDLES, (int)16, (int)16));
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            return other instanceof BundlesNode;
        }

        @Override
        public String getText() {
            return "Bundles";
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            this.populateChildrenAsNeeded();
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            for (DbTreeNode dbo : this.mChildren) {
                paths.add(dbo.getTreePath());
            }
            items.addAll(DbExplorerPanel.this.getMenuItems(paths.toArray(new TreePath[paths.size()])));
        }
    }

    public class PortTemplateNode
    extends DbObjNode<PortTemplate> {
        public PortTemplateNode(DbTreeNode parent, PortTemplate portT) {
            super(DbExplorerPanel.this, parent, (DbObject)portT);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            super.render(r);
            int fstyle = 0;
            if (DbExplorerPanel.this.mDbSelection != null && DbExplorerPanel.this.mDbSelection.contains(this.getDevicePath(), this.getDbObj())) {
                fstyle |= 1;
            }
            r.setFont(r.getFont().deriveFont(fstyle));
            ViewColorizer colorizer = DbExplorerPanel.this.mViewColorizer;
            r.setColorIcon(colorizer.getColorIcon(this.getDevicePath(), this.getDbObj(), 16));
            boolean visible = colorizer.isVisible(this.getDevicePath(), this.getDbObj());
            if (!visible) {
                r.setTextDecoration(TextDecoration.DELETE);
            }
        }

        @Override
        public String getText() {
            return "" + ((PortTemplate)this.getDbObj()).getPortNum();
        }

        @Override
        public String getTooltipText() {
            return String.format("%s on '%s'.", this.getDbObj(), this.getDevicePath());
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof PortTemplateNode)) {
                return false;
            }
            PortTemplateNode o = (PortTemplateNode)other;
            return AUtil.equals(o.getDbObj(), this.getDbObj());
        }
    }

    public class PinTemplateNode
    extends DbObjNode<PinTemplate> {
        protected PinInstance mPinInst;

        public PinTemplateNode(DbTreeNode parent, PinTemplate pinT) {
            super(DbExplorerPanel.this, parent, (DbObject)pinT);
            this.mPinInst = this.getPinInst();
        }

        public HierInst<PinInstance> getHierPinInst() {
            if (this.mPinInst == null) {
                return null;
            }
            return HierInst.create((DevicePath)this.getDevicePath(), (DbObject)this.mPinInst);
        }

        public PinTemplate getPinT() {
            return (PinTemplate)this.getDbObj();
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            super.render(r);
            int fstyle = 0;
            if (this.mPinInst != null) {
                fstyle |= 2;
            }
            if (DbExplorerPanel.this.mDbSelection != null && DbExplorerPanel.this.mDbSelection.contains(this.getDevicePath(), this.getDbObj())) {
                fstyle |= 1;
            }
            r.setFont(r.getFont().deriveFont(fstyle));
            ViewColorizer colorizer = DbExplorerPanel.this.mViewColorizer;
            r.setColorIcon(colorizer.getColorIcon(this.getDevicePath(), this.getDbObj(), 16));
            boolean visible = colorizer.isVisible(this.getDevicePath(), this.getDbObj());
            if (!visible) {
                r.setTextDecoration(TextDecoration.DELETE);
            }
        }

        @Override
        public Icon getIcon() {
            return DbExplorerPanel.getIconForPinTemplate(this.getPinT());
        }

        public PinInstance getPinInst() {
            Device d = this.getDevice();
            return d != null && d.getTemplate() == this.getPinT().getDeviceTemplate() ? PinInstance.getPinInstance((Device)d, (PinTemplate)this.getPinT()) : null;
        }

        @Override
        public String getText() {
            if (this.getPinT().getDb() == null) {
                return DbExplorerPanel.TEXT_INVALID;
            }
            if (this.mPinInst != null) {
                return this.mPinInst.getName();
            }
            return this.getPinT().getName();
        }

        @Override
        public String getTooltipText() {
            if (this.mPinInst == null) {
                return ((PinTemplate)this.getDbObj()).toString();
            }
            return this.mPinInst.toString();
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof PinTemplateNode)) {
                return false;
            }
            PinTemplateNode o = (PinTemplateNode)other;
            return AUtil.equals((Object)o.getPinT(), (Object)this.getPinT());
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        @Override
        public void populateChildren() {
            ArrayList<PortTemplateNode> children = new ArrayList<PortTemplateNode>();
            for (PortTemplate portTmplt : this.getPinT().getPortTemplates()) {
                children.add(new PortTemplateNode(this, portTmplt));
            }
            this.setChildren(children);
        }
    }

    public class FingersNode
    extends PinsNode {
        public FingersNode(DbTreeNode parent, Device d, List<PinTemplate> pins) {
            super(parent, d, pins);
            this.mPinGroupType = Selectors.FINGER_PIN_TYPE;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            super.render(r);
            r.setIcon(DBEResources.ICON_BONDFINGERS4);
        }

        @Override
        public String getText() {
            return "Fingers";
        }
    }

    public class ViasNode
    extends PinsNode {
        public ViasNode(DbTreeNode parent, Device d, List<PinTemplate> pins) {
            super(parent, d, pins);
            this.mPinGroupType = Selectors.VIA_PIN_TYPE;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            super.render(r);
            r.setIcon(DBEResources.ICON_VIAS);
        }

        @Override
        public String getText() {
            return "Vias";
        }
    }

    public class PinTypeGroupNode
    extends PinsNode {
        public PinTypeGroupNode(DbTreeNode parent, Device d, List<PinTemplate> pins, PinTemplate.Type type) {
            super(parent, d, pins);
            this.mPinGroupType = Set.of(type);
        }

        @Override
        protected void placeChildren(List<PinTemplate> pins) {
            ArrayList<PinTemplateNode> children = new ArrayList<PinTemplateNode>();
            for (PinTemplate pinT : pins) {
                PinTemplateNode node = new PinTemplateNode(this, pinT);
                if (!DbExplorerPanel.this.filterTreeNode(node)) continue;
                children.add(node);
            }
            this.setChildren(children);
        }

        @Override
        public String getText() {
            return ((PinTemplate.Type)this.mPinGroupType.iterator().next()).toString() + "s";
        }
    }

    public class PinsNode
    extends JitDbTreeNode {
        protected Device mDevice;
        protected DeviceTemplate mDeviceTemplate;
        protected Set<PinTemplate.Type> mPinGroupType;

        public PinsNode(DbTreeNode parent, Device d, List<PinTemplate> pins) {
            super(parent);
            assert (DbExplorerPanel.this.mDb != null);
            this.mPinGroupType = AUtil.hashSet((Object[])PinTemplate.Type.values());
            this.mPinGroupType.removeAll(Selectors.VIA_PIN_TYPE);
            this.mPinGroupType.removeAll(Selectors.FINGER_PIN_TYPE);
            this.mPinGroupType.remove(PinTemplate.Type.TOPOLOGYPOINT);
            this.mDevice = d;
            this.mDeviceTemplate = this.mDevice == null ? Design.getDesign((Db)DbExplorerPanel.this.mDb) : this.mDevice.getTemplate();
            this.placeChildren(pins);
        }

        protected void placeChildren(List<PinTemplate> pins) {
            if (NodeOptions.getGroupPinByType()) {
                Map<PinTemplate.Type, List<PinTemplate>> pinGroup = pins.stream().collect(Collectors.groupingBy(PinTemplate::getType));
                ArrayList<PinTypeGroupNode> children = new ArrayList<PinTypeGroupNode>();
                for (Map.Entry<PinTemplate.Type, List<PinTemplate>> e : pinGroup.entrySet()) {
                    children.add(new PinTypeGroupNode(this, this.mDevice, e.getValue(), e.getKey()));
                }
                this.setChildren(children);
            } else {
                ArrayList<PinTemplateNode> children = new ArrayList<PinTemplateNode>();
                for (PinTemplate pinT : pins) {
                    PinTemplateNode node = new PinTemplateNode(this, pinT);
                    if (!DbExplorerPanel.this.filterTreeNode(node)) continue;
                    children.add(node);
                }
                this.setChildren(children);
            }
        }

        public Device getDevice() {
            return this.mDevice;
        }

        public DeviceTemplate getDeviceTemplate() {
            return this.mDeviceTemplate;
        }

        @Override
        public String getTooltipText() {
            StringBuilder sb = new StringBuilder("Contains Pin Types: ");
            boolean first = true;
            for (PinTemplate.Type type : this.mPinGroupType) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(String.format("%s (%s)", type.getUserName(), type.toString()));
                first = false;
            }
            return sb.toString();
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setCountCommentText("" + this.getChildCount());
            r.setIcon(DBEResources.ICON_PINS);
        }

        @Override
        public String getText() {
            return "Pins";
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof PinsNode)) {
                return false;
            }
            PinsNode o = (PinsNode)other;
            return AUtil.equals((Object)o.mDevice, (Object)this.mDevice) && AUtil.equals((Object)o.mDeviceTemplate, (Object)this.mDeviceTemplate) && this.getText().equals(other.getText());
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            this.populateChildrenAsNeeded();
            Action action = EditPinUI.getAction(this.getDevicePath(), this.mPinGroupType);
            JMenuItem tableEditorMenuItem = new JMenuItem(action);
            items.add(tableEditorMenuItem);
            List<JMenuItem> childrenMenuItems = this.getChildrenMenuItems();
            items.addAll(childrenMenuItems);
        }

        protected DevicePath getDevicePath() {
            return DbExplorerPanel.getDevicePath(this.getTreePath());
        }

        protected List<JMenuItem> getChildrenMenuItems() {
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            for (DbTreeNode dbo : this.mChildren) {
                paths.add(dbo.getTreePath());
            }
            return DbExplorerPanel.this.getMenuItems(paths.toArray(new TreePath[paths.size()]));
        }
    }

    public class DeviceUnplacedGroupNode
    extends JitDbTreeNode {
        public DeviceUnplacedGroupNode(DbTreeNode parent, List<Device> devices) {
            super(parent);
            ArrayList<DeviceHierarchyNode> children = new ArrayList<DeviceHierarchyNode>();
            for (Device d : devices) {
                DeviceHierarchyNode node = new DeviceHierarchyNode(this, d);
                if (!DbExplorerPanel.this.filterTreeNode(node)) continue;
                children.add(node);
            }
            this.setChildren(children);
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setCountCommentText("" + this.getChildCount());
            r.setIcon(DBEResources.ICON_FOLDER);
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DeviceUnplacedGroupNode)) {
                return false;
            }
            return AUtil.equals((Object)this.getText(), (Object)other.getText());
        }

        @Override
        public String getText() {
            return "Unplaced";
        }
    }

    public class NetNode
    extends DbObjNode<Net> {
        protected Device mDevice;
        protected Personality mDiffPair;
        protected Personality mOtherPersonality;

        public NetNode(DbTreeNode parent, Net n, Device d) {
            super(DbExplorerPanel.this, parent, (DbObject)n);
            assert (DbExplorerPanel.this.mDb != null);
            this.mDevice = d;
            this.mDiffPair = null;
            for (PersonalityMap pm : PersonalityMap.getPersonalities((Personality.Type)Personality.Type.NET, (DbObject)n).collect(Collectors.toList())) {
                if (pm.getPersonality().hasNetMatchlengthValue()) {
                    this.mDiffPair = pm.getPersonality();
                    continue;
                }
                this.mOtherPersonality = pm.getPersonality();
            }
        }

        public boolean changeColorDialog() {
            Color c;
            Personality changePersonality = null;
            if (this.mDiffPair != null) {
                changePersonality = this.mDiffPair;
                c = changePersonality.getColor();
            } else if (this.mOtherPersonality != null) {
                changePersonality = this.mOtherPersonality;
                c = changePersonality.getColor();
            } else {
                c = this.getNet().getColor();
            }
            if (c == null) {
                c = Color.WHITE;
            }
            String title = "Select Color for Net " + this.getNet().getName();
            AColorChooserDlg dlg = AColorChooserDlg.createDialog((Component)DbExplorerPanel.this.mTree, title, c);
            Color newColor = dlg.doModal();
            if (changePersonality != null) {
                Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.updatePersonalityColor(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{changePersonality.getKeyStr(), AUtil.colorToString((Color)newColor)});
            } else {
                Cp.exec((String)"com.sigrity.orbit.ui.NetUI.updateNetColor(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{this.getNet().getKeyStr(), AUtil.colorToString((Color)newColor), this.getDevicePath().toString()});
            }
            return true;
        }

        public Icon getColorIconForNet() {
            Color color = this.mDiffPair != null ? this.mDiffPair.getColor() : (this.mOtherPersonality != null ? this.mOtherPersonality.getColor() : this.getNet().getColor());
            int rowHeight = DbExplorerPanel.this.mTree.getRowHeight();
            if (rowHeight <= 0) {
                rowHeight = 16;
            }
            int iconSize = rowHeight - 2;
            return ViewColorizer.getColorIcon((Color)color, (boolean)false, (int)iconSize);
        }

        public Iterator<Interface> getInterfaces() {
            HashSet<Interface> intf = new HashSet<Interface>();
            Enumeration<DbTreeNode> e = this.children();
            while (e.hasMoreElements()) {
                DbTreeNode n = e.nextElement();
                if (!(n instanceof PinTemplateNode)) continue;
                PinTemplate pt = (PinTemplate)((PinTemplateNode)n).getDbObj();
                for (FloorplanPin fpp : pt.getFloorplanPins()) {
                    try {
                        Interface t = fpp.getOwner().getMyInterface();
                        if (t == null) continue;
                        intf.add(t);
                    }
                    catch (Exception exception) {}
                }
            }
            for (NetMap np : NetMap.getConnectedNets((Net)this.getNet(), (DevicePath)this.getDevicePath())) {
                for (Interface itf : np.getChildNet().getRelated("Interface-nets", false, Interface.class)) {
                    intf.add(itf);
                }
            }
            return intf.iterator();
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            super.render(r);
            r.setColorIcon(this.getColorIconForNet());
            r.setCountCommentText("" + this.getChildCount());
        }

        @Override
        public Icon getIcon() {
            return DbExplorerPanel.getIconForNet(this.getNet());
        }

        @Override
        public String getTooltipText() {
            if (this.mDevice == null) {
                return null;
            }
            Object toolTipString = "<html>";
            if (this.getNet() == null || this.getNet().getDb() == null) {
                toolTipString = (String)toolTipString + "[Invalid NetNode]";
            } else {
                String devicePathStr = this.getDevicePathString();
                DevicePath path = DevicePath.fromString((Db)this.getNet().getDb(), (String)devicePathStr);
                HierInst topNet = NetMap.getTop((DevicePath)path, (Net)this.getNet());
                if (topNet != null) {
                    Object p;
                    Object object = p = topNet.getPath() == null ? "" : topNet.getPath().toString();
                    if (!((String)p).endsWith("/")) {
                        p = (String)p + "/";
                    }
                    String s = String.format("%s%s", p, AStringEscape.escapeHtml4((String)((Net)topNet.getDbObject()).getName()));
                    toolTipString = (String)toolTipString + "The highest level net is " + s + ". ";
                }
                if (this.getNet().getPinCount() > 0) {
                    toolTipString = (String)toolTipString + "<br>";
                    Object children = this.getNet().getPins().stream().limit(16L).map(PinTemplate::getName).collect(Collectors.joining(","));
                    if (this.getNet().getPinCount() > 16) {
                        children = (String)children + ", ...";
                    }
                    String ports = "Pins: " + (String)children;
                    toolTipString = (String)toolTipString + ports;
                }
            }
            toolTipString = (String)toolTipString + "</html>";
            return toolTipString;
        }

        @Override
        public String getText() {
            if (this.getNet().getDb() == null) {
                return DbExplorerPanel.TEXT_INVALID;
            }
            return this.getNet().getName();
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof NetNode)) {
                return false;
            }
            NetNode o = (NetNode)other;
            return ((Net)o.mDbObj).equals(this.mDbObj) && AUtil.equals((Object)o.mDevice, (Object)this.mDevice);
        }

        @Override
        public boolean isLeaf() {
            return this.mDevice == null || this.getChildCount() == 0;
        }

        @Override
        public void populateChildren() {
            ArrayList<DbObjNode> children = new ArrayList<DbObjNode>();
            for (DbObject dbo : ((Net)this.mDbObj).getContents()) {
                if (dbo instanceof PinTemplate) {
                    children.add(new PinTemplateNode(this, (PinTemplate)dbo));
                    continue;
                }
                children.add(new DbObjNode(DbExplorerPanel.this, (DbTreeNode)this, dbo));
            }
            this.setChildren(children);
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof NetNode) {
                if (this.getNet().isUnused()) {
                    return -1;
                }
                if (((NetNode)o).getNet().isUnused()) {
                    return 1;
                }
            }
            return super.compareTo(o);
        }

        public Net getNet() {
            return (Net)this.getDbObj();
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            Action a = DbExplorerPanel.this.getTraceAction(this.getHierInst());
            if (a != null) {
                items.add(new JMenuItem(a));
                items.add(null);
            }
            super.populateMenuItems(items);
            if (this.getNet() == null || this.getNet().getDb() == null) {
                return;
            }
            if (DbExplorerPanel.this.getExploreNetListener() != null) {
                DevicePath dp = this.getDevicePath();
                if (dp == null && this.mDevice == null) {
                    dp = Design.getDesignPath((Db)DbExplorerPanel.this.mDb);
                }
                items.add(new JMenuItem(new ActionExploreNet(this.getNet(), dp)));
            }
            items.add(new JMenuItem(new AbstractAction("Show Me"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DevicePath path = NetNode.this.getDevicePath();
                    if (path == null && NetNode.this.mDevice == null) {
                        path = Design.getDesignPath((Db)DbExplorerPanel.this.mDb);
                    }
                    ShowMeTheWay.addNet(NetNode.this.getNet(), path);
                }
            }));
        }

        protected class ActionExploreNet
        extends AbstractAction {
            protected Net mNet;
            protected DevicePath mDevice;

            public ActionExploreNet(Net net, DevicePath device) {
                super("Explore Net...");
                this.mNet = net;
                this.mDevice = device;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DbExplorerPanel.this.mExploreNetListener == null) {
                    assert (false);
                    return;
                }
                DbExplorerPanel.this.mExploreNetListener.exploreNet(this.mDevice, this.mNet);
            }
        }
    }

    public class TermNode
    extends DbObjNode<Term> {
        protected Device mDevice;

        public TermNode(DbTreeNode parent, Term dbObj, Device d) {
            super(DbExplorerPanel.this, parent, (DbObject)dbObj);
            this.mDevice = d;
        }

        public Term getTerm() {
            return (Term)this.getDbObj();
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            super.render(r);
            r.setCountCommentText(Integer.toString(this.getChildCount()));
        }

        @Override
        public Icon getIcon() {
            return DBEResources.ICON_NET;
        }

        @Override
        public String getText() {
            if (this.getTerm().getDb() == null) {
                return DbExplorerPanel.TEXT_INVALID;
            }
            return this.getTerm().getName();
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof TermNode)) {
                return false;
            }
            TermNode o = (TermNode)other;
            return ((Term)o.mDbObj).equals(this.mDbObj) && AUtil.equals((Object)o.mDevice, (Object)this.mDevice);
        }

        @Override
        public boolean isLeaf() {
            return this.mDevice == null || this.getChildCount() == 0;
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            super.populateMenuItems(items);
            AMenuUtil.sort(items, (boolean)false);
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public String getTooltipText() {
            return this.getTerm().toString();
        }
    }

    public class FloorplanNode
    extends DbObjNode<Floorplan> {
        Device mDevice;
        Interface mInterface;
        Floorplan mFloorplan;
        int mChildCount;

        public FloorplanNode(DbTreeNode parent, Device dev, Floorplan floorplan, List<? extends NetNode> children) {
            super(DbExplorerPanel.this, parent, (DbObject)floorplan);
            this.mDevice = dev;
            this.mFloorplan = floorplan;
            this.mInterface = floorplan.getMyInterface();
            this.mChildCount = children == null ? 0 : children.size();
            this.mSortChildren = false;
            if (NodeOptions.getGroupNetByPowerSignal()) {
                this.setChildren(DbExplorerPanel.this.createPowerSignalGroups(this, DbExplorerPanel.getDevicePath(parent.getTreePath()), children, net -> (Net)net));
            } else {
                this.setChildren(children);
            }
        }

        public Floorplan getFloorplan() {
            return this.mFloorplan;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setCountCommentText("" + this.mChildCount);
            ViewColorizer colorizer = DbExplorerPanel.this.mViewColorizer;
            if (!this.mInterface.getVisible() || !colorizer.getShowInterfaces()) {
                r.setTextDecoration(TextDecoration.DELETE);
            }
            Icon icon = ViewColorizer.getColorIcon((Color)this.mInterface.getColor(), (boolean)colorizer.isDrawHollow((DbObject)this.mInterface), (int)16);
            r.setIcon(icon);
        }

        @Override
        public String getText() {
            if (this.getInterface().getDb() == null) {
                return DbExplorerPanel.TEXT_INVALID;
            }
            return this.mInterface.getName();
        }

        public Interface getInterface() {
            return this.mInterface;
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof FloorplanNode)) {
                return false;
            }
            FloorplanNode o = (FloorplanNode)other;
            return o.getInterface().equals(this.getInterface());
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            Selection sel = new Selection(DbExplorerPanel.this.mDb);
            OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            JMenu intfMenu = new JMenu("Interface");
            sel.add((DbObject)this.mInterface);
            for (JMenuItem item : oar.getJMenuItems(sel)) {
                intfMenu.add(item);
            }
            intfMenu.add(new JMenuItem(new OrbitGuiObjectActionRegistry.ActionShowDetails(null, (DbObject)this.mInterface, null, null)));
            items.add(intfMenu);
            sel.clear();
            sel.add(super.getDevicePath(), (DbObject)this.mFloorplan);
            for (JMenuItem item : oar.getJMenuItems(sel)) {
                items.add(item);
            }
            items.add(new JMenuItem(new OrbitGuiObjectActionRegistry.ActionShowDetails(null, (DbObject)this.mFloorplan, null, null)));
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public DevicePath getDevicePath() {
            return super.getDevicePath().pathToSubstrate();
        }
    }

    public class NetGroupNode
    extends JitDbTreeNode {
        final NetGroupType mGroupType;

        public NetGroupNode(DbTreeNode parent, NetGroupType type, List<? extends DbTreeNode> children) {
            super(parent);
            this.mSortChildren = false;
            this.mGroupType = type;
            this.setChildren(children);
            for (DbTreeNode dbTreeNode : children) {
                dbTreeNode.setParent(this);
            }
        }

        @Override
        public boolean isLeaf() {
            return this.mChildren == null || this.mChildren.isEmpty();
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setCountCommentText("" + this.getChildCount());
            ADecoratedIcon icon = null;
            if (this.mGroupType == NetGroupType.SIGNAL) {
                icon = new ADecoratedIcon(DBEResources.ICON_FOLDER, UIUtil.getScaledIcon((Icon)OrbitIcons.SIGNAL, (int)10, (int)10));
            } else if (this.mGroupType == NetGroupType.PG) {
                icon = new ADecoratedIcon(DBEResources.ICON_FOLDER, UIUtil.getScaledIcon((Icon)OrbitIcons.POWER, (int)10, (int)10));
            } else if (this.mGroupType == NetGroupType.NC) {
                icon = new ADecoratedIcon(DBEResources.ICON_FOLDER, UIUtil.getScaledIcon((Icon)OrbitIcons.CROSS, (int)10, (int)10));
            }
            if (icon != null) {
                r.setIcon((Icon)icon);
            }
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof NetGroupNode)) {
                return false;
            }
            NetGroupNode o = (NetGroupNode)other;
            return o.mGroupType == this.mGroupType;
        }

        @Override
        public String getText() {
            if (this.mGroupType == NetGroupType.SIGNAL) {
                return "Signal";
            }
            if (this.mGroupType == NetGroupType.PG) {
                return "Power/Ground";
            }
            if (this.mGroupType == NetGroupType.NC) {
                return "NC";
            }
            return "Undefined";
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
        }

        @Override
        public void populateChildren() {
        }
    }

    static enum NetGroupType {
        SIGNAL,
        PG,
        NC;

    }

    public class NetsNode
    extends JitDbTreeNode {
        protected Device mDevice;
        protected DeviceTemplate mDeviceTemplate;

        public NetsNode(DbTreeNode parent, Device d) {
            super(parent);
            assert (DbExplorerPanel.this.mDb != null);
            this.mDevice = d;
            this.mDeviceTemplate = this.mDevice == null ? Design.getDesign((Db)DbExplorerPanel.this.mDb) : this.mDevice.getTemplate();
            this.mSortChildren = false;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setCountCommentText("" + this.mDeviceTemplate.getNetCount());
            r.setIcon(DBEResources.ICON_NETS);
        }

        @Override
        public String getText() {
            return "Nets";
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof NetsNode)) {
                return false;
            }
            NetsNode o = (NetsNode)other;
            return AUtil.equals((Object)o.mDevice, (Object)this.mDevice) && AUtil.equals((Object)o.mDeviceTemplate, (Object)this.mDeviceTemplate);
        }

        @Override
        public void populateChildren() {
            ArrayList<NetNode> children = new ArrayList<NetNode>();
            if (this.mDeviceTemplate != null) {
                for (Net net : this.mDeviceTemplate.getNets()) {
                    NetNode node;
                    if (!NodeOptions.getNetFilter().include(net) || !DbExplorerPanel.this.filterTreeNode(node = new NetNode(this, net, this.mDevice))) continue;
                    children.add(node);
                }
            }
            this.setChildren(this.arrange(children));
            assert (this.mChildren != null);
        }

        protected List<DbTreeNode> arrange(List<NetNode> children) {
            Collections.sort(children);
            if (NodeOptions.mSortNet == NodeOptions.SortType.NUM_DEC) {
                Collections.sort(children, Comparator.comparingInt(JitDbTreeNode::getChildCount).reversed());
            } else if (NodeOptions.mSortNet == NodeOptions.SortType.NUM_INC) {
                Collections.sort(children, Comparator.comparingInt(JitDbTreeNode::getChildCount));
            }
            HashMap<Personality, NetNode> hash = new HashMap<Personality, NetNode>();
            for (int i = children.size() - 1; i >= 0; --i) {
                NetNode node = children.get(i);
                Personality p = node.mDiffPair;
                if (p == null || hash.containsKey(p)) continue;
                hash.put(p, node);
            }
            ArrayList<NetNode> filter = new ArrayList<NetNode>();
            for (int i = 0; i < children.size(); ++i) {
                Personality p;
                NetNode b;
                NetNode a = children.get(i);
                if (a == (b = (NetNode)hash.get(p = a.mDiffPair))) continue;
                filter.add(a);
                if (b == null) continue;
                filter.add(b);
            }
            if (!NodeOptions.mGroupByInterface && !NodeOptions.mGroupByPowerSignal) {
                return new ArrayList<DbTreeNode>(filter);
            }
            if (NodeOptions.mGroupByInterface) {
                return this.createInterfaceGroups(filter);
            }
            DevicePath dp = this.mParent instanceof DeviceHierarchyNode ? ((DeviceHierarchyNode)this.mParent).getDevicePath() : null;
            return DbExplorerPanel.this.createPowerSignalGroups(this, dp, filter, net -> (Net)net);
        }

        /*
         * WARNING - void declaration
         */
        protected List<DbTreeNode> createInterfaceGroups(ArrayList<NetNode> netChildren) {
            HashMap intfGroup = new HashMap();
            ArrayList<NetNode> unused = new ArrayList<NetNode>();
            ArrayList<DbTreeNode> mixed = new ArrayList<DbTreeNode>();
            DbObjNode parentNode = (DbObjNode)this.getParent();
            DevicePath path = parentNode.getDevicePath();
            for (int i = 0; i < netChildren.size(); ++i) {
                NetNode a = netChildren.get(i);
                Interface intf = a.getNet().getInterface(path);
                if (intf != null) {
                    void var10_11;
                    ArrayList arrayList = (ArrayList)intfGroup.get(intf);
                    if (arrayList == null) {
                        ArrayList arrayList2 = new ArrayList();
                        intfGroup.put(intf, arrayList2);
                    }
                    var10_11.add(a);
                    continue;
                }
                unused.add(a);
            }
            DeviceTemplate subTemplate = this.getDevicePath().getSubstrateDeviceTemplate();
            ArrayList<FloorplanNode> ret = new ArrayList<FloorplanNode>();
            for (Map.Entry entry : intfGroup.entrySet()) {
                Interface intf = (Interface)entry.getKey();
                Floorplan substrateFp = intf.getFloorplan(subTemplate, false);
                if (substrateFp == null) continue;
                ret.add(new FloorplanNode(this, this.mDevice, substrateFp, (List)entry.getValue()));
            }
            HashMap<Interface, FloorplanNode> hierIntfs = new HashMap<Interface, FloorplanNode>();
            for (FloorplanNode i : ret) {
                Interface intf = i.getInterface();
                hierIntfs.put(intf, i);
                for (intf = intf.getParent(); intf != null; intf = intf.getParent()) {
                    if (hierIntfs.containsKey(intf)) continue;
                    hierIntfs.put(intf, null);
                }
            }
            ret.clear();
            for (Interface intf : hierIntfs.keySet()) {
                FloorplanNode node = (FloorplanNode)hierIntfs.get(intf);
                if (node == null) {
                    node = new FloorplanNode(this, this.mDevice, intf.getFloorplan(subTemplate, true), new ArrayList());
                }
                ArrayList<FloorplanNode> children = new ArrayList<FloorplanNode>();
                children.addAll(AUtil.arrayList(node.children()));
                for (Interface i : intf.getChildren()) {
                    if (!hierIntfs.containsKey(i)) continue;
                    FloorplanNode inode = (FloorplanNode)hierIntfs.get(i);
                    if (inode == null) {
                        inode = new FloorplanNode(node, this.mDevice, i.getFloorplan(subTemplate, true), new ArrayList());
                    }
                    hierIntfs.put(i, inode);
                    children.add(inode);
                }
                Collections.sort(children, (x, y) -> {
                    AAlphaNumComp c = AAlphaNumComp.get();
                    if (x instanceof FloorplanNode && y instanceof FloorplanNode) {
                        return c.compare((Object)((FloorplanNode)x).getInterface().getName(), (Object)((FloorplanNode)y).getInterface().getName());
                    }
                    if (x instanceof NetNode && y instanceof NetNode) {
                        return c.compare((Object)((NetNode)x).getText(), (Object)((NetNode)y).getText());
                    }
                    return x instanceof FloorplanNode ? -1 : 1;
                });
                node.setChildren(children);
                if (intf.getParent() != null) continue;
                ret.add(node);
            }
            Collections.sort(ret, (x, y) -> {
                AAlphaNumComp c = AAlphaNumComp.get();
                return c.compare((Object)x.getInterface().getName(), (Object)y.getInterface().getName());
            });
            mixed.addAll(ret);
            if (NodeOptions.mGroupByPowerSignal) {
                mixed.addAll(DbExplorerPanel.this.createPowerSignalGroups(this, this.getDevicePath(), unused, net -> (Net)net));
            } else {
                mixed.addAll(unused);
            }
            return mixed;
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            if (OrbitIO.getOrbitIO() == null) {
                return;
            }
            items.add(new NodeOptions.ActionFilterNetMenu(DbExplorerPanel::refreshAll).getJMenu());
            items.add(new NodeOptions.ActionGroupNetMenu(DbExplorerPanel::refreshAll).getJMenu());
            items.add(new NodeOptions.ActionSortNetMenu(DbExplorerPanel::refreshAll).getJMenu());
            items.add(null);
            DevicePath devicePath = this.getDevicePath();
            items.add(new JMenuItem(EditNetUI.getAction(devicePath)));
            ArrayList<JMenuItem> netItems = new ArrayList<JMenuItem>();
            for (Action a : NetUI.getActions(devicePath)) {
                netItems.add(new JMenuItem(a));
            }
            AMenuUtil.sort(netItems, (boolean)true);
            items.addAll(netItems);
        }

        protected DevicePath getDevicePath() {
            return DbExplorerPanel.getDevicePath(this.getTreePath());
        }
    }

    public class LayerNode
    extends DbObjNode<Layer> {
        public LayerNode(DbTreeNode parent, Layer layer) {
            super(DbExplorerPanel.this, parent, (DbObject)layer);
        }

        @Override
        public String getText() {
            return ((Layer)this.getDbObj()).getName();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof LayerNode)) {
                return false;
            }
            LayerNode o = (LayerNode)other;
            return AUtil.equals(o.getDbObj(), this.getDbObj()) && AUtil.equals((Object)o.getDevicePath(), (Object)this.getDevicePath());
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            ViewColorizer vc = DbExplorerPanel.this.mViewColorizer;
            DevicePath dp = super.getDevicePath();
            APatternColor color = vc.getColor(dp, (Layer)this.getDbObj(), false);
            int rowHeight = DbExplorerPanel.this.mTree.getRowHeight();
            if (rowHeight <= 0) {
                rowHeight = 16;
            }
            r.setColorIcon(ViewColorizer.getColorIcon((Color)(color == null ? null : color.getColor()), (boolean)false, (int)(rowHeight - 2)));
            ViewColorizer tc = vc.getColorizerFor(dp, (ViewColorizer.Key)vc.getLayerKey((Layer)this.getDbObj(), true));
            r.setObjectVisible(color != null ? 1 : 2, tc != null && dp.equals((Object)tc.getPath()));
        }

        public void toggleCheckBox() {
            ViewColorizer vc = DbExplorerPanel.this.mViewColorizer;
            DevicePath dp = super.getDevicePath();
            APatternColor color = vc.getColor(dp, (Layer)this.getDbObj(), false);
            Cp.exec((String)"com.sigrity.orbit.ui.LayerUI.setLayerVisible(curDb(), \"%s\", \"%s\", %b)", (Object[])new Object[]{((Layer)this.getDbObj()).getKeyStr(), dp.getString(), color == null});
            DbExplorerPanel.this.repaint();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }

        public void chooseColor() {
            VisibilityControlUI.ActionChangeColor a = new VisibilityControlUI.ActionChangeColor(OrbitIO.getMainWindow(), DbExplorerPanel.this.mViewColorizer, (ViewColorizer.Key)DbExplorerPanel.this.mViewColorizer.getLayerKey((Layer)this.getDbObj(), true), super.getDevicePath());
            a.actionPerformed(null);
            DbExplorerPanel.this.repaint();
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            items.add(new JMenuItem(new LayerUI.ActionInheritParentView((Layer)this.getDbObj(), this.getDevicePath())));
            super.populateMenuItems(items);
        }
    }

    public class LayersNode
    extends JitDbTreeNode {
        public LayersNode(DisplayNode parent) {
            super(parent);
            assert (DbExplorerPanel.this.mDb != null);
            this.mSortChildren = false;
        }

        DevicePath getDevicePath() {
            DbTreeNode node = this.getParent();
            return ((DisplayNode)node).getDevicePath();
        }

        @Override
        public void populateChildren() {
            ArrayList<LayerNode> children = new ArrayList<LayerNode>();
            DevicePath path = this.getDevicePath();
            Substrate sub = path.getSubstrate();
            List layers = sub.getLayers().stream().sorted(Layer.OrderComparator.reversed()).collect(Collectors.toList());
            Set<Layer.LayerType> displayTypes = NodeOptions.getDisplayLayerTypes();
            for (Layer l : layers) {
                if (!displayTypes.contains(l.getType())) continue;
                children.add(new LayerNode(this, l));
            }
            Device device = this.getDevicePath().getLast();
            if (device.getFlipped()) {
                Collections.reverse(children);
            }
            this.setChildren(children);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            ViewColorizer tc;
            r.setText(this.getText());
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.LAYERS, (int)16, (int)16));
            ViewColorizer vc = DbExplorerPanel.this.mViewColorizer;
            DevicePath path = this.getDevicePath();
            Substrate sub = path.getSubstrate();
            int mask = 0;
            DevicePath dp = this.getDevicePath();
            if (sub.getLayerCount() > 0) {
                for (Layer l : sub.getLayers()) {
                    boolean visible = vc.getDisplay(dp, (ViewColorizer.Key)vc.getLayerKey(l, true));
                    if (visible) {
                        mask |= 1;
                        continue;
                    }
                    mask |= 2;
                }
            }
            r.setObjectVisible(mask, (tc = vc.getOverride(path, false)) != null && path.equals((Object)tc.getPath()));
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof LayersNode)) {
                return false;
            }
            LayersNode o = (LayersNode)other;
            return AUtil.equals((Object)o.getDevicePath(), (Object)this.getDevicePath());
        }

        @Override
        public String getText() {
            return "Layers";
        }

        public void toggleCheckBox() {
            ViewColorizer vc = DbExplorerPanel.this.mViewColorizer;
            DevicePath path = this.getDevicePath();
            Substrate sub = path.getSubstrate();
            boolean visible = false;
            for (Layer l : sub.getLayers()) {
                if (vc.getColor(this.getDevicePath(), l, false) == null) continue;
                visible = true;
                break;
            }
            for (Layer l : sub.getLayers()) {
                Cp.exec((String)"com.sigrity.orbit.ui.LayerUI.setLayerVisible(curDb(), \"%s\", \"%s\", %b)", (Object[])new Object[]{l.getKeyStr(), path.getString(), !visible});
            }
            DbExplorerPanel.this.repaint();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            Substrate curSubstrate = this.getDevicePath().getSubstrate();
            Action action = EditLayerUI.getAction(curSubstrate);
            JMenuItem layerTableMenuItem = new JMenuItem(action);
            items.add(layerTableMenuItem);
            items.add(new JMenuItem(new LayerUI.ActionInheritParentView(this.getDevicePath())));
        }
    }

    public class DisplayObjectNode
    extends JitDbTreeNode {
        ViewColorizer.Key mKey;

        public DisplayObjectNode(DisplayObjectsNode parent, ViewColorizer.Key key) {
            super(parent);
            this.mKey = key;
        }

        DevicePath getDevicePath() {
            DbTreeNode node = this.getParent();
            return ((DisplayObjectsNode)node).getDevicePath();
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public void populateChildren() {
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            ViewColorizer vc = DbExplorerPanel.this.mViewColorizer;
            DevicePath dp = this.getDevicePath();
            APatternColor color = vc.getColor(dp, this.mKey);
            boolean isDisplay = vc.getDisplay(dp, this.mKey);
            int rowHeight = DbExplorerPanel.this.mTree.getRowHeight();
            if (rowHeight <= 0) {
                rowHeight = 16;
            }
            r.setColorIcon(ViewColorizer.getColorIcon((APatternColor)color, (boolean)false, (int)(rowHeight - 2)));
            ViewColorizer tc = vc.getColorizerFor(dp, this.mKey);
            r.setObjectVisible(isDisplay ? 1 : 2, tc != null && dp.equals((Object)tc.getPath()));
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DisplayObjectNode)) {
                return false;
            }
            DisplayObjectNode o = (DisplayObjectNode)other;
            return AUtil.equals((Object)o.getDevicePath(), (Object)this.getDevicePath()) && AUtil.equals((Object)this.mKey, (Object)o.mKey);
        }

        @Override
        public String getText() {
            ViewColorizer vc = DbExplorerPanel.this.mViewColorizer;
            return vc.getDescription((Object)this.mKey);
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
        }

        public void toggleCheckBox() {
            ViewColorizer vc = DbExplorerPanel.this.mViewColorizer;
            DevicePath path = this.getDevicePath();
            boolean isDisplay = vc.getDisplay(path, this.mKey);
            Cp.exec((String)"com.sigrity.orbit.ui.core.ViewColorizer.setDisplay(\"%s\", \"%s\", %b)", (Object[])new Object[]{path.getString(), this.mKey.asString(), !isDisplay});
            DbExplorerPanel.this.repaint();
            OrbitIO.getOrbitIO().refreshCurrentView(false);
        }

        public void chooseColor() {
            VisibilityControlUI.ActionChangeColor a = new VisibilityControlUI.ActionChangeColor(OrbitIO.getMainWindow(), DbExplorerPanel.this.mViewColorizer, this.mKey, this.getDevicePath());
            a.actionPerformed(null);
            DbExplorerPanel.this.repaint();
        }
    }

    public class DisplayObjectsNode
    extends JitDbTreeNode {
        public DisplayObjectsNode(DisplayNode parent) {
            super(parent);
        }

        DevicePath getDevicePath() {
            DbTreeNode node = this.getParent();
            return ((DisplayNode)node).getDevicePath();
        }

        @Override
        public void populateChildren() {
            ArrayList<DisplayObjectNode> children = new ArrayList<DisplayObjectNode>();
            ViewColorizer vc = DbExplorerPanel.this.mViewColorizer;
            for (ViewColorizer.Key key : vc.getColorKeys(this.getDevicePath().getDeviceTemplate().getType())) {
                children.add(new DisplayObjectNode(this, key));
            }
            this.mSortChildren = false;
            this.setChildren(children);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(DBEResources.ICON_DBOBJ);
            ViewColorizer vc = DbExplorerPanel.this.mViewColorizer;
            DevicePath path = this.getDevicePath();
            int mask = 0;
            for (ViewColorizer.Key key : vc.getColorKeys(this.getDevicePath().getDeviceTemplate().getType())) {
                if (vc.getDisplay(path, key)) {
                    mask |= 1;
                    continue;
                }
                mask |= 2;
            }
            ViewColorizer tc = vc.getOverride(path, false);
            r.setObjectVisible(mask, tc != null && path.equals((Object)tc.getPath()));
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DisplayObjectsNode)) {
                return false;
            }
            DisplayObjectsNode o = (DisplayObjectsNode)other;
            return AUtil.equals((Object)o.getDevicePath(), (Object)this.getDevicePath());
        }

        @Override
        public String getText() {
            return "Objects";
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            items.add(new JMenuItem((Action)new ViewColorizer.ActionInheritParentObjectView(this.getDevicePath())));
        }
    }

    public class DisplayNode
    extends JitDbTreeNode {
        public DisplayNode(DbObjNode<?> parent) {
            super(parent);
        }

        DevicePath getDevicePath() {
            DbTreeNode node = this.getParent();
            return ((DbObjNode)node).getDevicePath();
        }

        @Override
        public void populateChildren() {
            ArrayList<JitDbTreeNode> children = new ArrayList<JitDbTreeNode>();
            children.add(new LayersNode(this));
            children.add(new DisplayObjectsNode(this));
            this.mSortChildren = false;
            this.setChildren(children);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.VIEW_SETTING, (int)16, (int)16));
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DisplayNode)) {
                return false;
            }
            DisplayNode o = (DisplayNode)other;
            return AUtil.equals((Object)o.getDevicePath(), (Object)this.getDevicePath());
        }

        @Override
        public String getText() {
            return "Layers & Objects";
        }
    }

    public class PinLabelsNode
    extends JitDbTreeNode {
        protected DeviceTemplate mDeviceTemplate;

        public PinLabelsNode(DbTreeNode parent, DeviceTemplate devT) {
            super(parent);
            this.mDeviceTemplate = devT;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setCountCommentText(Long.toString(AUtil.count((Iterator)PinLabel.get((DeviceTemplate)this.mDeviceTemplate))));
            r.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.CONS_PROPERTY, (int)16, (int)16));
        }

        @Override
        public String getText() {
            return "PinLabels";
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof PinLabelsNode)) {
                return false;
            }
            PinLabelsNode o = (PinLabelsNode)other;
            return AUtil.equals((Object)o.mDeviceTemplate, (Object)this.mDeviceTemplate);
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            Action action = EditPinLabelUI.getAction(this.getDevicePath());
            JMenuItem tableEditorMenuItem = new JMenuItem(action);
            items.add(tableEditorMenuItem);
        }

        protected DevicePath getDevicePath() {
            return DbExplorerPanel.getDevicePath(this.getTreePath());
        }

        @Override
        public void populateChildren() {
        }
    }

    public class TermsNode
    extends JitDbTreeNode {
        protected Device mDevice;
        protected DeviceTemplate mDeviceTemplate;

        public TermsNode(DbTreeNode parent, Device dev) {
            super(parent);
            this.mDevice = dev;
            this.mDeviceTemplate = this.mDevice == null ? Design.getDesign((Db)DbExplorerPanel.this.mDb) : this.mDevice.getTemplate();
            this.mSortChildren = false;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            if (this.mDeviceTemplate != null) {
                r.setCountCommentText("" + this.mDeviceTemplate.getTermCount());
            }
            r.setIcon(DBEResources.ICON_TERMS);
        }

        @Override
        public String getText() {
            return "Terms";
        }

        @Override
        public void populateChildren() {
            ArrayList<TermNode> children = new ArrayList<TermNode>();
            if (this.mDeviceTemplate != null) {
                for (Term t : this.mDeviceTemplate.getTerms()) {
                    TermNode node = new TermNode(this, t, this.mDevice);
                    if (!DbExplorerPanel.this.filterTreeNode(node)) continue;
                    children.add(node);
                }
            }
            this.setChildren(this.arrange(children));
        }

        private List<DbTreeNode> arrange(List<TermNode> children) {
            Collections.sort(children);
            if (NodeOptions.mSortNet == NodeOptions.SortType.NUM_DEC) {
                Collections.sort(children, Comparator.comparingInt(JitDbTreeNode::getChildCount).reversed());
            } else if (NodeOptions.mSortNet == NodeOptions.SortType.NUM_INC) {
                Collections.sort(children, Comparator.comparingInt(JitDbTreeNode::getChildCount));
            }
            if (!NodeOptions.mGroupByPowerSignal) {
                return new ArrayList<DbTreeNode>(children);
            }
            DevicePath dp = this.mParent instanceof DeviceHierarchyNode ? ((DeviceHierarchyNode)this.mParent).getDevicePath() : null;
            return DbExplorerPanel.this.createPowerSignalGroups(this, dp, children, net -> ((Term)net).getNet());
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof TermsNode)) {
                return false;
            }
            TermsNode o = (TermsNode)other;
            return AUtil.equals((Object)o.mDevice, (Object)this.mDevice) && AUtil.equals((Object)o.mDeviceTemplate, (Object)this.mDeviceTemplate);
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            items.add(new NodeOptions.ActionGroupNetMenu(DbExplorerPanel::refreshAll).getJMenu());
            items.add(null);
            Action action = EditTermUI.getAction(this.getDevicePath());
            JMenuItem tableEditorMenuItem = new JMenuItem(action);
            items.add(tableEditorMenuItem);
        }

        protected DevicePath getDevicePath() {
            return DbExplorerPanel.getDevicePath(this.getTreePath());
        }
    }

    public class DeviceTypeGroupNode
    extends JitDbTreeNode {
        protected DeviceTemplate.Type mType;
        protected DeviceTemplate mDevT;
        protected long mChildCount;

        public DeviceTypeGroupNode(DeviceHierarchyNode parent, DeviceTemplate.Type type) {
            super(parent);
            this.mType = type;
            this.mDevT = ((Device)parent.getDbObj()).getTemplate();
            this.mChildCount = this.mDevT.getChildren().stream().filter(device -> device.getType() == type).count();
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            Icon icon = null;
            if (this.mType == DeviceTemplate.Type.HARDMACRO) {
                icon = UIManager.getIcon("CDNS.hardBlockCollectionIcon");
            } else if (this.mType == DeviceTemplate.Type.SOFTMACRO) {
                icon = UIManager.getIcon("CDNS.softBlockCollectionIcon");
            }
            if (icon == null) {
                icon = new ADecoratedIcon(DBEResources.ICON_FOLDER, UIUtil.getScaledIcon((Icon)DbExplorerPanel.getIconForTemplateType(this.mType), (int)10, (int)10));
            }
            r.setIcon(icon);
            r.setCountCommentText("" + this.mChildCount);
        }

        @Override
        public String getText() {
            return this.mType.toString() + "s";
        }

        @Override
        public void populateChildren() {
            ArrayList<DeviceHierarchyNode> children;
            this.mChildren = children = new ArrayList<DeviceHierarchyNode>();
            for (Device child : this.mDevT.getChildren()) {
                DeviceHierarchyNode node;
                if (child.getDeviceType() != this.mType || !DbExplorerPanel.this.filterTreeNode(node = new DeviceHierarchyNode(this, child))) continue;
                children.add(node);
            }
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof DeviceTypeGroupNode) {
                return this.getText().compareTo(((DeviceTypeGroupNode)o).getText());
            }
            if (DeviceHierarchyNode.class.isAssignableFrom(o.getClass())) {
                return 1;
            }
            return super.compareTo(o);
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            JMenuItem tableMenuItem = new JMenuItem(EditDeviceUI.getAction(this.getDevicePath(), this.mType));
            tableMenuItem.setText(String.format("%s Table", this.getText()));
            items.add(tableMenuItem);
            JMenuItem deleteItem = new JMenuItem(this.getDeletionAction());
            items.add(deleteItem);
            JMenuItem selectItem = new JMenuItem(this.getSelectAction());
            items.add(selectItem);
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DeviceTypeGroupNode)) {
                return false;
            }
            DeviceTypeGroupNode o = (DeviceTypeGroupNode)other;
            return this.mDevT == o.mDevT && this.mType == o.mType;
        }

        public DevicePath getDevicePath() {
            return DbExplorerPanel.getDevicePath(this.getTreePath());
        }

        private Action getDeletionAction() {
            return new AbstractAction(String.format("Delete %s Devices", this.mType), OrbitIcons.CROSS){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Cp.exec((String)"com.sigrity.orbit.cmd.DeviceCommands.deleteChildDevices(curDb(), \"%s\", DeviceTemplate.Type.%s)", (Object[])new Object[]{DeviceTypeGroupNode.this.getDevicePath(), DeviceTypeGroupNode.this.mType.name()});
                }

                @Override
                public boolean isEnabled() {
                    return super.isEnabled() && OrbitIO.getCurDb() != null;
                }
            };
        }

        private Action getSelectAction() {
            return new AbstractAction(String.format("Select %s Devices", this.mType), UIUtil.getScaledIcon((Icon)OrbitIcons.SELECT, (int)16, (int)16)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Cp.exec((String)"com.sigrity.orbit.cmd.DeviceCommands.selectChildDevices(curDb(), \"%s\", DeviceTemplate.Type.%s)", (Object[])new Object[]{DeviceTypeGroupNode.this.getDevicePath(), DeviceTypeGroupNode.this.mType.name()});
                }

                @Override
                public boolean isEnabled() {
                    return super.isEnabled() && OrbitIO.getCurDb() != null;
                }
            };
        }
    }

    public class DbRelationsGroupNode<T extends DbObject>
    extends DbObjNode<T> {
        protected boolean mIncludeParentRel;

        public DbRelationsGroupNode(DbObjNode<T> parent) {
            super(DbExplorerPanel.this, parent, parent.getDbObj());
            this.mIncludeParentRel = false;
        }

        @Override
        public void populateChildren() {
            ArrayList<DbRelatedObjectsNode> children;
            this.mChildren = children = new ArrayList<DbRelatedObjectsNode>();
            DbRelationDef rdDeviceParent = DbExplorerPanel.this.mDb.getRelation("Device-parent");
            for (DbRelationDef rel : DbExplorerPanel.this.mDb.getRelations()) {
                if (rel == rdDeviceParent && !this.mIncludeParentRel) continue;
                if (rel.getDbClassL() == this.mDbObj.getDbClass()) {
                    children.add(new DbRelatedObjectsNode(this, rel, true));
                    continue;
                }
                if (rel.getDbClassR() != this.mDbObj.getDbClass()) continue;
                children.add(new DbRelatedObjectsNode(this, rel, false));
            }
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(DBEResources.ICON_DBRELATION);
        }

        @Override
        public String getText() {
            return "Relations";
        }
    }

    public class DeviceHierarchyNode
    extends DbObjNode<Device>
    implements HasDevice {
        protected int mChildDeviceCount;

        public DeviceHierarchyNode(DeviceHierarchyRootNode parent, Device d) {
            super(DbExplorerPanel.this, (DbTreeNode)parent, (DbObject)d);
            this.mChildDeviceCount = -1;
        }

        public DeviceHierarchyNode(DeviceHierarchyNode parent, Device d) {
            super(DbExplorerPanel.this, (DbTreeNode)parent, (DbObject)d);
            this.mChildDeviceCount = -1;
        }

        public DeviceHierarchyNode(JitDbTreeNode parent, Device d) {
            super(DbExplorerPanel.this, (DbTreeNode)parent, (DbObject)d);
            this.mChildDeviceCount = -1;
        }

        @Override
        public Device getDevice() {
            return (Device)this.mDbObj;
        }

        public int getChildDeviceCount() {
            if (this.mChildDeviceCount < 0 && this.getDevice().getTemplate() != null) {
                this.mChildDeviceCount = this.getDevice().getTemplate().childCount();
            }
            return this.mChildDeviceCount;
        }

        @Override
        public void populateChildren() {
            DisplayNode node;
            List<Device> unplaced;
            ArrayList<JitDbTreeNode> children;
            this.mChildren = children = new ArrayList<JitDbTreeNode>();
            children.add(new NetsNode(this, this.getDevice()));
            children.add(new TermsNode(this, this.getDevice()));
            Device device = this.getDevice();
            DeviceTemplate devT = device.getTemplate();
            String VIAS = "Vias";
            String FINGERS = "Fingers";
            String PINS = "Pins";
            String BUNDLE_PINS = "BundlePins";
            if (devT != null) {
                JitDbTreeNode node2;
                Map<String, List<PinTemplate>> pinGroup = this.getDevice().getTemplate().getPins().stream().collect(Collectors.groupingBy(e -> {
                    if (Selectors.VIA_PIN_TYPE.contains(e.getType())) {
                        return "Vias";
                    }
                    if (Selectors.FINGER_PIN_TYPE.contains(e.getType())) {
                        return "Fingers";
                    }
                    if (e.getType() == PinTemplate.Type.TOPOLOGYPOINT) {
                        return "BundlePins";
                    }
                    return "Pins";
                }));
                if (pinGroup.containsKey("Pins") && DbExplorerPanel.this.filterTreeNode(node2 = new PinsNode(this, this.getDevice(), pinGroup.get("Pins")))) {
                    children.add(node2);
                }
                if (AclInfo.getDebugMode() && pinGroup.containsKey("Vias")) {
                    children.add(new ViasNode(this, this.getDevice(), pinGroup.get("Vias")));
                }
                if (pinGroup.containsKey("Fingers") && DbExplorerPanel.this.filterTreeNode(node2 = new FingersNode(this, this.getDevice(), pinGroup.get("Fingers")))) {
                    children.add(node2);
                }
                if (devT.getBundleCount() > 0) {
                    children.add(new BundlesNode(this, devT));
                }
                if (PinLabel.get((DeviceTemplate)devT).hasNext() && DbExplorerPanel.this.filterTreeNode(node2 = new PinLabelsNode(this, devT))) {
                    children.add(node2);
                }
            }
            ConcurrentHashMap.KeySetView groupNodesAdded = ConcurrentHashMap.newKeySet();
            List nodes = this.getDevice().getChildren().parallelStream().filter(d -> !NodeOptions.getGroupUnplacedDevice() || d.getIsPlaced()).map(child -> {
                DeviceTemplate.Type type = child.getDeviceType();
                JitDbTreeNode node = null;
                if (NodeOptions.getDeviceGroupTypes().contains(type)) {
                    if (groupNodesAdded.add(type)) {
                        node = new DeviceTypeGroupNode(this, type);
                    }
                } else {
                    node = new DeviceHierarchyNode(this, (Device)child);
                    if (!DbExplorerPanel.this.filterTreeNode(node)) {
                        node = null;
                    }
                }
                return node;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            children.addAll(nodes);
            if (NodeOptions.getGroupUnplacedDevice() && !(unplaced = this.getDevice().getChildren().stream().filter(d -> !d.getIsPlaced()).collect(Collectors.toList())).isEmpty()) {
                children.add(new DeviceUnplacedGroupNode(this, unplaced));
            }
            if (device.getIsSubstrate() && DbExplorerPanel.this.filterTreeNode(node = new DisplayNode(this))) {
                children.add(node);
            }
            switch (DbExplorerPanel.this.mRelationDisplay) {
                case GROUP: {
                    children.add(new DbRelationsGroupNode<Device>(this));
                    break;
                }
                case DISPLAY: {
                    DbRelationDef rdDeviceParent = DbExplorerPanel.this.mDb.getRelation("Device-parent");
                    for (DbRelationDef rel : DbExplorerPanel.this.mDb.getRelations()) {
                        if (rel == rdDeviceParent) continue;
                        if (rel.getDbClassL() == ((Device)this.mDbObj).getDbClass()) {
                            children.add(new DbRelatedObjectsNode(this, rel, true));
                            continue;
                        }
                        if (rel.getDbClassR() != ((Device)this.mDbObj).getDbClass()) continue;
                        children.add(new DbRelatedObjectsNode(this, rel, false));
                    }
                    break;
                }
            }
        }

        public DeviceHierarchyRootNode getHRoot() {
            DbTreeNode parent = this.getParent();
            if (parent instanceof DeviceHierarchyRootNode) {
                return (DeviceHierarchyRootNode)parent;
            }
            if (parent instanceof DeviceHierarchyNode) {
                return ((DeviceHierarchyNode)parent).getHRoot();
            }
            return null;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            boolean visible;
            int childDeviceCount;
            super.render(r);
            DeviceTemplate.Type type = this.getDevice().getType();
            if (type != DeviceTemplate.Type.GROUP && this.getDevice().getTemplate() != null) {
                r.setNodeCommentText(this.getDevice().getTemplate().getName());
            }
            if ((childDeviceCount = this.getChildDeviceCount()) > 0) {
                r.setCountCommentText("" + childDeviceCount);
            }
            if (DbExplorerPanel.this.mViewColorizer == null) {
                ALog.logError((String)"?? %s", (Object[])new Object[]{this.getDbObj()});
            }
            if (!(visible = DbExplorerPanel.this.mViewColorizer.isVisible(this.getDevicePath(), this.getDbObj()))) {
                r.setTextDecoration(TextDecoration.DELETE);
            }
        }

        @Override
        public String getTooltipText() {
            return this.getDevicePathString();
        }

        @Override
        public String getText() {
            if (this.getDevice().getDb() == null) {
                return DbExplorerPanel.TEXT_INVALID;
            }
            String name = this.getDevice().getShortName();
            if (name == null) {
                name = "";
            }
            return name;
        }

        @Override
        public Icon getIcon() {
            double scale;
            Icon icon = DbExplorerPanel.getIconForDevice(this.getDevice());
            if (icon != null && this.getDevice() != null && this.getDevice().getTemplate() != null && this.getDevice().getTemplate().getSubstrate() != null && this.isTopNodeOnSubstrate() && !Double.isNaN(scale = this.getDevice().getTemplate().getSubstrate().getScale()) && scale != 1.0) {
                Icon iconDecor = scale < 1.0 ? DBEResources.ICON_SCALE_DOWN : DBEResources.ICON_SCALE_UP;
                icon = new ADecoratedIcon(icon, iconDecor, ADecoratedIcon.POSX.CENTER, ADecoratedIcon.POSY.CENTER);
            }
            return icon;
        }

        public boolean isTopNodeOnSubstrate() {
            DbTreeNode parent = this.getParent();
            if (parent instanceof DeviceHierarchyRootNode) {
                return true;
            }
            if (parent instanceof DeviceHierarchyNode) {
                return this.getSubstrate() != ((DeviceHierarchyNode)parent).getSubstrate();
            }
            return true;
        }

        public Substrate getSubstrate() {
            Device device = this.getDevice();
            if (device == null) {
                return null;
            }
            return device.getSubstrate();
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DeviceHierarchyNode)) {
                return false;
            }
            DeviceHierarchyNode o = (DeviceHierarchyNode)other;
            return ((Device)o.mDbObj).equals(this.mDbObj);
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof DeviceTypeGroupNode) {
                return -1;
            }
            if (DeviceHierarchyNode.class.isAssignableFrom(o.getClass())) {
                DeviceHierarchyNode other = (DeviceHierarchyNode)o;
                Device devA = this.getDevice();
                Device devB = other.getDevice();
                if (devA != null && devB != null) {
                    DeviceTemplate devTA = devA.getTemplate();
                    DeviceTemplate devTB = devB.getTemplate();
                    if (devTA != null && devTB != null) {
                        int typeBPriority;
                        DeviceTemplate.Type typeA = devTA.getType();
                        DeviceTemplate.Type typeB = devTB.getType();
                        int typeAPriority = DbExplorerPanel.getDeviceTypeSortPriority(typeA);
                        if (typeAPriority != (typeBPriority = DbExplorerPanel.getDeviceTypeSortPriority(typeB))) {
                            return typeAPriority < typeBPriority ? -1 : 1;
                        }
                    }
                }
            }
            return super.compareTo(o);
        }
    }

    public static interface HasDevice {
        public Device getDevice();
    }

    public class DeviceHierarchyRootNode
    extends DbObjNode<Design> {
        protected int mDfltOpenLevels;
        protected DbRelationDef.DbRelationAdapter mDevice2ParentListener;
        protected DbClass.DbObjectListener mDeviceListener;
        protected DbClass.DbObjectListener mContentListener;

        public DeviceHierarchyRootNode(DatabaseNode parent) {
            super(DbExplorerPanel.this, (DbTreeNode)parent, (DbObject)Design.getDesign((Db)DbExplorerPanel.this.mDb));
            this.mDfltOpenLevels = -1;
            this.mDevice2ParentListener = new DbRelationDef.DbRelationAdapter(){

                public void related(DbRelationDef.RelationChange change) {
                    this.processChange(change);
                }

                public void unrelated(DbRelationDef.RelationChange change) {
                    this.processChange(change);
                }

                protected void processChange(DbRelationDef.RelationChange change) {
                    if (DeviceHierarchyRootNode.this.invalidatedAll()) {
                        return;
                    }
                    DeviceTemplate newParent = (DeviceTemplate)change.getRight();
                    DeviceTemplate oldParent = (DeviceTemplate)change.getOldRight();
                    if (newParent != null) {
                        if (newParent instanceof Design) {
                            DeviceHierarchyRootNode.this.invalidate(new DevicePath(newParent));
                        }
                        for (DevicePath pathDevice : newParent.getHierarchicalInstances()) {
                            DeviceHierarchyRootNode.this.invalidate(pathDevice);
                        }
                    }
                    if (oldParent != null) {
                        if (oldParent instanceof Design) {
                            DeviceHierarchyRootNode.this.invalidate(new DevicePath(newParent));
                        }
                        for (DevicePath pathDevice : oldParent.getHierarchicalInstances()) {
                            DeviceHierarchyRootNode.this.invalidate(pathDevice);
                        }
                    }
                }
            };
            this.mDeviceListener = new DbClass.DbObjectAdapter(){

                public void addedObject(DbClass.ObjectAdd add) {
                    this.changed(add.getObject());
                }

                public boolean removingObject(DbClass.ObjectRemove remove) {
                    this.changed(remove.getObject());
                    return true;
                }

                protected void changed(DbObject dbo) {
                    if (DeviceHierarchyRootNode.this.invalidatedAll()) {
                        return;
                    }
                    if (DeviceHierarchyRootNode.this.isRoot(dbo)) {
                        DeviceHierarchyRootNode.this.invalidateAll();
                    } else {
                        Device d = (Device)dbo;
                        for (DevicePath pathDevice : d.getHierarchicalInstances()) {
                            DeviceHierarchyRootNode.this.invalidate(pathDevice.getParent());
                        }
                    }
                }
            };
            this.mContentListener = new DbClass.DbObjectAdapter(){

                public void addedObject(DbClass.ObjectAdd add) {
                    DbExplorerPanel.this.refresh();
                }

                public void removedObject(DbClass.ObjectRemove remove) {
                    DbExplorerPanel.this.refresh();
                }

                public void changedObject(DbClass.ObjectChange change) {
                    DbExplorerPanel.this.refresh();
                }
            };
            assert (DbExplorerPanel.this.mDb != null);
            this.registerListeners();
            if (this.mDfltOpenLevels != 0) {
                EventQueue.invokeLater(() -> DbExplorerPanel.expandHierLevels(DbExplorerPanel.this.mTree, this.getTreePath(), this.mDfltOpenLevels));
            }
        }

        private void registerListeners() {
            Class[] contentClass;
            DbRelationDef dbr;
            DbClass dbcDevice = DbExplorerPanel.this.mDb.getDbClass(Device.class);
            if (dbcDevice != null) {
                dbcDevice.addObjectListener(this.mDeviceListener, DbClass.DbObjectEventType.getUpdated());
            }
            if ((dbr = DbExplorerPanel.this.mDb.getRelation("Device-parent")) != null) {
                dbr.addRelationListener((DbRelationDef.DbRelationListener)this.mDevice2ParentListener, DbRelationDef.RELATION_UPDATED);
            }
            for (Class clz : contentClass = new Class[]{Net.class, PinTemplate.class, Bundle.class, Wire.class}) {
                DbClass contentDbc = DbExplorerPanel.this.mDb.getDbClass(clz);
                if (contentDbc == null) continue;
                contentDbc.addObjectListener(this.mContentListener, DbClass.DbObjectEventType.getUpdated());
            }
        }

        private void deregisterListeners() {
            Class[] contentClass;
            DbRelationDef dbr;
            DbClass dbcDevice = DbExplorerPanel.this.mDb.getDbClass(Device.class);
            if (dbcDevice != null) {
                dbcDevice.removeObjectListener(this.mDeviceListener, DbClass.DbObjectEventType.getUpdated());
            }
            if ((dbr = DbExplorerPanel.this.mDb.getRelation("Device-parent")) != null) {
                dbr.removeRelationListener((DbRelationDef.DbRelationListener)this.mDevice2ParentListener, DbRelationDef.RELATION_UPDATED);
            }
            for (Class clz : contentClass = new Class[]{Net.class, PinTemplate.class, Bundle.class, Wire.class}) {
                DbClass contentDbc = DbExplorerPanel.this.mDb.getDbClass(clz);
                if (contentDbc == null) continue;
                contentDbc.removeObjectListener(this.mContentListener, DbClass.DbObjectEventType.getUpdated());
            }
        }

        @Override
        public void dispose() {
            if (DbExplorerPanel.this.mDb != null) {
                this.deregisterListeners();
            }
            super.dispose();
        }

        @Override
        public String getText() {
            if (DbExplorerPanel.this.mDb == null) {
                return "Invalid design (not in a database)";
            }
            Design design = Design.getDesign((Db)DbExplorerPanel.this.mDb, (boolean)false);
            return String.format("%s (%s)", design.getUserName("Design"), DbExplorerPanel.this.mDb.getDescription(false));
        }

        @Override
        public Icon getIcon() {
            return DBEResources.ICON_DESIGNDEVICES;
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            if (!(other instanceof DeviceHierarchyRootNode)) {
                return false;
            }
            DeviceHierarchyRootNode o = (DeviceHierarchyRootNode)other;
            return ((Design)o.mDbObj).equals(this.mDbObj);
        }

        @Override
        public void populateChildren() {
            TermsNode terms;
            ArrayList<JitDbTreeNode> children;
            this.mChildren = children = new ArrayList<JitDbTreeNode>();
            Design design = Design.getDesign((Db)DbExplorerPanel.this.mDb, (boolean)false);
            if (design == null) {
                return;
            }
            NetsNode nets = new NetsNode(this, null);
            if (nets.getChildCount() > 0) {
                children.add(nets);
            }
            if ((terms = new TermsNode(this, null)).getChildCount() > 0) {
                children.add(terms);
            }
            ArrayList<Device> unplaced = new ArrayList<Device>();
            for (Device o : design.getRootDevices()) {
                if (NodeOptions.getGroupUnplacedDevice() && !o.getIsPlaced()) {
                    unplaced.add(o);
                    continue;
                }
                DeviceHierarchyNode node = new DeviceHierarchyNode(this, o);
                if (!DbExplorerPanel.this.filterTreeNode(node)) continue;
                children.add(node);
            }
            if (!unplaced.isEmpty()) {
                children.add(new DeviceUnplacedGroupNode(this, unplaced));
            }
        }

        @Override
        public JComponent getDetailsView() {
            if (DbExplorerPanel.this.mDb == null) {
                return DbExplorerPanel.getHTMLViewer("");
            }
            String html = "<h2>Database " + DbExplorerPanel.this.mDb.getDescription(false) + "</h2>";
            html = html + String.format("%s<br><br>", DbExplorerPanel.this.mDb.getDescription(true));
            html = html + String.format("There are %d root devices.", this.getChildCount());
            return DbExplorerPanel.getHTMLViewer(html);
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem("Show Relations");
            mi.setAction(new AbstractAction("Show Relations"){
                {
                    this.putValue("SwingSelectedKey", true);
                    this.putValue("InitUnChecked", DbExplorerPanel.this.isShowRelations());
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    DbExplorerPanel.this.setRelationDisplay(DbExplorerPanel.this.mRelationDisplay == RELATION_DISPLAY.HIDE ? RELATION_DISPLAY.GROUP : RELATION_DISPLAY.HIDE);
                    DbExplorerPanel.refreshAll();
                }
            });
            mi.setSelected(DbExplorerPanel.this.isShowRelations());
            items.add(mi);
            items.add(null);
            super.populateMenuItems(items);
        }

        public void setDefaultOpenLevels(int i) {
            this.mDfltOpenLevels = i;
        }

        public void invalidate(DevicePath p) {
            if (p == null) {
                return;
            }
            if (p.isDesign()) {
                this.invalidateAll();
                return;
            }
            if (this.invalidatedAll()) {
                return;
            }
            if (DbExplorerPanel.this.mInvalidateDevices != null && DbExplorerPanel.this.mInvalidateDevices.contains(p)) {
                return;
            }
            if (DbExplorerPanel.this.mInvalidateDevices == null) {
                DbExplorerPanel.this.mInvalidateDevices = new HashSet();
                EventQueue.invokeLater(new InvalidateObjects());
            }
            DbExplorerPanel.this.mInvalidateDevices.add(p);
        }

        protected boolean invalidatedAll() {
            return DbExplorerPanel.this.mInvalidateDevices != null && DbExplorerPanel.this.mInvalidateDevices.isEmpty();
        }

        public void invalidateAll() {
            if (this.invalidatedAll()) {
                return;
            }
            if (DbExplorerPanel.this.mInvalidateDevices == null) {
                EventQueue.invokeLater(new InvalidateObjects());
            }
            DbExplorerPanel.this.mInvalidateDevices = new HashSet();
        }

        public boolean isRoot(DbObject dbo) {
            return dbo instanceof Design && Design.getDesign((Db)dbo.getDb()) == dbo || dbo instanceof Device && ((Device)dbo).isRoot();
        }

        public DbTreeNode walkTree(List<Device> path) {
            DbTreeNode n = null;
            Enumeration<DbTreeNode> children = this.children();
            if (children == null) {
                return null;
            }
            for (Device d : path) {
                n = this.findChild(children, (DbObject)d);
                if (!(n instanceof JitDbTreeNode)) {
                    return null;
                }
                children = ((JitDbTreeNode)n).children();
            }
            return n;
        }

        public TreePath getTreePath(DevicePath devicePath) {
            if (devicePath.isDesign()) {
                return this.getTreePath();
            }
            TreePath result = null;
            Enumeration<DbTreeNode> children = this.children();
            for (Device d : devicePath) {
                if (children == null) {
                    return null;
                }
                DbTreeNode n = this.findChild(children, (DbObject)d);
                if (!(n instanceof DeviceHierarchyNode)) {
                    return null;
                }
                result = result == null ? this.getTreePath().pathByAddingChild(n) : result.pathByAddingChild(n);
                children = ((DeviceHierarchyNode)n).children();
            }
            return result;
        }

        public TreePath getTreePathWithNoNeed(DevicePath devicePath) {
            if (devicePath.isDesign()) {
                return this.getTreePath();
            }
            if (this.mChildren == null || !this.mChildrenValid) {
                return null;
            }
            TreePath result = null;
            Enumeration<DbTreeNode> children = this.children();
            for (Device d : devicePath) {
                if (children == null) {
                    return null;
                }
                DbTreeNode n = this.findChild(children, (DbObject)d);
                if (n == null) {
                    return null;
                }
                if (!(n instanceof DeviceHierarchyNode)) {
                    return null;
                }
                result = result == null ? this.getTreePath().pathByAddingChild(n) : result.pathByAddingChild(n);
                if (!((DeviceHierarchyNode)n).isChildrenValid()) {
                    children = null;
                    continue;
                }
                children = ((DeviceHierarchyNode)n).children();
            }
            return result;
        }

        public class InvalidateObjects
        implements Runnable {
            @Override
            public void run() {
                if (DbExplorerPanel.this.mDb == null || DbExplorerPanel.this.mInvalidateDevices == null || DbExplorerPanel.this.mTree == null || DbExplorerPanel.this.mTree.getModel() == null) {
                    return;
                }
                State savedState = DbExplorerPanel.this.getState();
                if (DbExplorerPanel.this.mInvalidateDevices.isEmpty()) {
                    DeviceHierarchyRootNode.this.invalidateChildren();
                } else {
                    for (DevicePath path : DbExplorerPanel.this.mInvalidateDevices) {
                        Object o;
                        TreePath tpParent;
                        TreePath tp = DeviceHierarchyRootNode.this.getTreePathWithNoNeed(path);
                        if (tp == null || (tpParent = tp.getParentPath()) == null || tpParent.getPathCount() == 0 || !((o = tpParent.getLastPathComponent()) instanceof JitDbTreeNode)) continue;
                        ((JitDbTreeNode)o).invalidateChildren();
                    }
                }
                DbExplorerPanel.this.mInvalidateDevices = null;
                DbExplorerPanel.this.putState(savedState);
            }
        }
    }

    public class AllClassesNode
    extends JitDbTreeNode {
        public AllClassesNode(DatabaseNode parent) {
            super(parent);
            assert (DbExplorerPanel.this.mDb != null);
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
            r.setIcon(UIManager.getIcon("Tree.openIcon"));
        }

        @Override
        public String getText() {
            return String.format("Classes (%s)", DbExplorerPanel.this.mDb == null ? "<Db Closed>" : DbExplorerPanel.this.mDb.getDescription(false));
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            return other instanceof AllClassesNode;
        }

        @Override
        public void populateChildren() {
            ArrayList<DbClassNode> children;
            this.mChildren = children = new ArrayList<DbClassNode>();
            DbItr itr = DbExplorerPanel.this.mDb.getDbClasses();
            while (itr.hasNext()) {
                DbClass e = (DbClass)itr.next();
                children.add(0, new DbClassNode(this, e));
            }
        }

        @Override
        public JComponent getDetailsView() {
            String html = "<h2>Database " + DbExplorerPanel.this.mDb.getDescription(false) + "</h2>";
            html = html + String.format("%s<br><br>", DbExplorerPanel.this.mDb.getDescription(true));
            html = html + String.format("There are %d database classes defined.", this.getChildCount());
            return DbExplorerPanel.getHTMLViewer(html);
        }
    }

    public class DatabaseNode
    extends JitDbTreeNode {
        public DatabaseNode(DbTreeModel dbtm) {
            super(dbtm);
            assert (DbExplorerPanel.this.mDb != null);
            this.mSortChildren = false;
        }

        @Override
        public void populateChildren() {
            ArrayList<JitDbTreeNode> children = new ArrayList<JitDbTreeNode>();
            children.add(new AllClassesNode(this));
            children.add(new AllRelationsNode(this));
            if (Design.getDesign((Db)DbExplorerPanel.this.mDb) != null) {
                children.add(new DeviceHierarchyRootNode(this));
            }
            this.mChildren = children;
        }

        @Override
        public void render(DbTreeCellRenderer r) {
            r.setText(this.getText());
        }

        @Override
        public String getText() {
            return "The Database";
        }

        @Override
        public boolean equiv(DbTreeNode other) {
            return other instanceof DatabaseNode;
        }
    }

    public static class DbTreeSelListener
    implements TreeSelectionListener {
        final DetailsPanel mDetails;

        public DbTreeSelListener(DetailsPanel detailsPanel) {
            this.mDetails = detailsPanel;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object selected = e.getPath().getLastPathComponent();
            this.mDetails.setCurrentItem(selected);
        }
    }

    public class DbTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected DefaultTreeCellRenderer mDfltRenderer = new DefaultTreeCellRenderer();
        protected JCheckBox mCbVisible = new JCheckBox();
        protected JLabel mIconLabel = new JLabel();
        protected JLabel mColorLabel = new JLabel();
        protected JLabel mNodeCommentLabel = new JLabel();
        protected JLabel mCountCommentLabel = new JLabel();
        protected Object value;
        protected JTree tree;
        protected boolean selected;
        protected boolean expanded;
        protected boolean leaf;
        protected int row;
        protected boolean hasFocus;
        protected TextDecoration mTextDecoration = TextDecoration.NONE;
        protected int mMaxRenderWidth = 16;
        protected boolean mRenderUpdating = false;
        protected static final int mMaxRenderHight = 18;
        protected Dimension mCellDim = new Dimension(this.mMaxRenderWidth, 18);

        public DbTreeCellRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.mIconLabel);
            this.add(this.mCbVisible);
            this.add(this.mColorLabel);
            this.add(Box.createHorizontalStrut(2));
            this.add(this.mDfltRenderer);
            this.add(Box.createHorizontalStrut(2));
            this.add(this.mNodeCommentLabel);
            this.add(Box.createHorizontalStrut(2));
            this.add(this.mCountCommentLabel);
            this.mCbVisible.setVisible(false);
            this.mCbVisible.setOpaque(false);
            this.mNodeCommentLabel.setForeground(Color.GRAY.darker());
            this.mCountCommentLabel.setForeground(Color.GRAY);
            this.mDfltRenderer.setLeafIcon(null);
            this.mDfltRenderer.setOpenIcon(null);
            this.mDfltRenderer.setClosedIcon(null);
            this.mDfltRenderer.setIcon(null);
            if (DbExplorerPanel.this.mScrollTree != null) {
                this.mMaxRenderWidth = Math.max(DbExplorerPanel.this.mScrollTree.getWidth(), 16);
            }
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.tree = tree;
            this.value = value;
            this.selected = selected;
            this.expanded = expanded;
            this.leaf = leaf;
            this.row = row;
            this.hasFocus = hasFocus;
            this.setPreferredSize(this.mCellDim);
            this.mRenderUpdating = false;
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setIcon(null);
            this.setFont(this.getFont().deriveFont(0));
            this.setPreferredSize(null);
            this.mCbVisible.setVisible(false);
            this.mColorLabel.setVisible(false);
            this.mDfltRenderer.getTreeCellRendererComponent(this.tree, this.value, this.selected, this.expanded, this.leaf, this.row, this.hasFocus);
            this.mNodeCommentLabel.setVisible(false);
            this.mCountCommentLabel.setVisible(false);
            this.mTextDecoration = TextDecoration.NONE;
            if (DbExplorerPanel.this.mInvalidateDevices == null || DbExplorerPanel.this.mInvalidateDevices.isEmpty()) {
                if (this.value instanceof DbObjNode) {
                    if (((DbObjNode)this.value).getDbObj().getDb() != null) {
                        ((DbObjNode)this.value).render(this);
                    } else {
                        this.setText(DbExplorerPanel.TEXT_INVALID);
                    }
                } else if (this.value instanceof DbTreeNode) {
                    ((DbTreeNode)this.value).render(this);
                }
            }
            if (this.mTextDecoration == TextDecoration.DELETE) {
                this.mDfltRenderer.setText(String.format("<html><s>%s</s></html>", AUtil.escapeHtml((String)this.mDfltRenderer.getText())));
            }
            this.validate();
            Dimension drawDim = this.getPreferredSize();
            if (drawDim.getWidth() > (double)this.mMaxRenderWidth) {
                this.mMaxRenderWidth = (int)drawDim.getWidth();
                this.mCellDim = new Dimension(this.mMaxRenderWidth, 18);
                if (!this.mRenderUpdating) {
                    this.mRenderUpdating = true;
                    EventQueue.invokeLater(DbExplorerPanel.this::refresh);
                }
            }
            super.paintComponent(g);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.mDfltRenderer != null) {
                this.mDfltRenderer.setFont(font);
            }
        }

        public void setText(String text) {
            this.mDfltRenderer.setText(text);
        }

        public void setIcon(Icon icon) {
            this.mIconLabel.setIcon(icon);
        }

        public void setColorIcon(Icon icon) {
            this.mColorLabel.setVisible(true);
            this.mColorLabel.setIcon(icon);
        }

        public void setCountCommentText(String text) {
            if (DbExplorerPanel.this.mCountCommentDisplay) {
                this.mCountCommentLabel.setVisible(true);
                this.mCountCommentLabel.setText("(" + text + ")");
            }
        }

        public void setNodeCommentText(String text) {
            this.mNodeCommentLabel.setVisible(true);
            this.mNodeCommentLabel.setText("(" + text + ")");
        }

        public void setObjectVisible(int visibleMask, boolean override) {
            this.mCbVisible.setVisible(true);
            this.mCbVisible.setEnabled(override);
            if (visibleMask == 3) {
                this.mCbVisible.setIcon(ACheckBoxIcon.getIcon((int)visibleMask, (boolean)override));
                this.mCbVisible.setSelected(false);
            } else {
                this.mCbVisible.setIcon(ACheckBoxIcon.getIcon((int)visibleMask, (boolean)override));
                this.mCbVisible.setSelectedIcon(ACheckBoxIcon.getIcon((int)visibleMask, (boolean)override));
                this.mCbVisible.setSelected(visibleMask == 1);
            }
        }

        @Override
        public void setToolTipText(String text) {
            ALog.logError((Throwable)new Exception("Not supported"), (String)"Do not use this function. Please replace with Node.getTooltipText()", (Object[])new Object[0]);
        }

        public void setTextDecoration(TextDecoration style) {
            this.mTextDecoration = style;
        }
    }

    protected static enum TextDecoration {
        NONE,
        DELETE;

    }

    public static class DetailsPanel
    extends JPanel {
        protected JScrollPane mScrollPane = new JScrollPane();

        public DetailsPanel() {
            GridBagManager c = new GridBagManager((Container)this);
            c.add((Component)this.mScrollPane, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        }

        public void setCurrentItem(Object o) {
            if (o instanceof DbTreeNode) {
                DbTreeNode dbtn = (DbTreeNode)o;
                this.mScrollPane.setViewportView(dbtn.getDetailsView());
            }
        }
    }

    public static interface ExploreNetListener {
        public void exploreNet(DevicePath var1, Net var2);
    }

    public static enum RELATION_DISPLAY {
        DISPLAY,
        GROUP,
        HIDE;

    }
}

