/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.DbTransactionUI;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;

public class DbHistoryExplorerPanel
extends JPanel {
    protected JList<DbHistory.Transaction> mHistoryList;
    protected ListSelectionListener mSelectionListener = e -> {
        ListModel<DbHistory.Transaction> m = this.mHistoryList.getModel();
        if (m instanceof HistoryListModel) {
            ((HistoryListModel)m).updateCurrentPosition();
        }
    };

    public DbHistoryExplorerPanel() {
        this.setLayout(new BorderLayout());
        this.mHistoryList = new JList();
        JScrollPane sp = new JScrollPane(this.mHistoryList);
        this.add(sp);
        this.mHistoryList.setSelectionMode(0);
        this.mHistoryList.getSelectionModel().addListSelectionListener(this.mSelectionListener);
        this.mHistoryList.setCellRenderer(new TransactionCellRenderer());
        this.mHistoryList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    Point loc = e.getPoint();
                    int index = DbHistoryExplorerPanel.this.mHistoryList.locationToIndex(loc);
                    if (index < 0) {
                        return;
                    }
                    DbHistory.Transaction trans = DbHistoryExplorerPanel.this.mHistoryList.getModel().getElementAt(index);
                    JMenuItem item = new JMenuItem(new ActionDetail(trans));
                    menu.add(item);
                    menu.add(new ActionRefresh());
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void setDb(Db db) {
        if (db == null) {
            this.mHistoryList.setModel(new DefaultListModel());
        } else {
            HistoryListModel model = new HistoryListModel(db.getHistory());
            this.mHistoryList.setModel(model);
            model.updateCurrentPosition();
        }
    }

    protected class ActionRefresh
    extends AbstractAction {
        public ActionRefresh() {
            super("Refresh");
            this.putValue("SmallIcon", OrbitIcons.REFRESH);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListModel<DbHistory.Transaction> m = DbHistoryExplorerPanel.this.mHistoryList.getModel();
            if (m instanceof HistoryListModel) {
                ((HistoryListModel)m).updateCurrentPosition();
            }
        }
    }

    protected static class ActionDetail
    extends AbstractAction {
        protected DbHistory.Transaction mTransaction;

        public ActionDetail(DbHistory.Transaction trans) {
            super("Detail...");
            this.putValue("SmallIcon", OrbitIcons.COG_EDIT);
            this.mTransaction = trans;
            if (trans == null) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbTransactionUI.show(OrbitIO.getCurDb(), OrbitIO.getMainWindow(), this.mTransaction);
        }
    }

    protected class HistoryListModel
    extends AbstractListModel<DbHistory.Transaction>
    implements DbHistory.Listener {
        protected DbHistory mHistory = null;
        boolean mRefreshAdded = false;
        int mRefreshAddedIndex;

        public HistoryListModel(DbHistory history) {
            this.mHistory = history;
            this.mHistory.addListener((DbHistory.Listener)this);
        }

        @Override
        public int getSize() {
            return this.mHistory == null ? 0 : this.mHistory.getSize();
        }

        @Override
        public DbHistory.Transaction getElementAt(int index) {
            return (DbHistory.Transaction)this.mHistory.getHistory().get(index);
        }

        public void updateCurrentPosition() {
            int position = this.getSize() - this.mHistory.getUndone() - 1;
            if (position == -1) {
                DbHistoryExplorerPanel.this.mHistoryList.clearSelection();
            } else {
                DbHistoryExplorerPanel.this.mHistoryList.setSelectedIndex(position);
            }
        }

        private void refreshAdded(int newIndex) {
            this.mRefreshAddedIndex = newIndex;
            if (this.mRefreshAdded) {
                return;
            }
            this.mRefreshAdded = true;
            EventQueue.invokeLater(() -> {
                this.fireIntervalAdded(this, this.mRefreshAddedIndex, this.mRefreshAddedIndex);
                this.mRefreshAdded = false;
            });
        }

        public void positionChanged(int newUndone) {
            this.updateCurrentPosition();
        }

        public void historyAdded() {
            int newIdx = this.mHistory.getSize() - 1;
            this.refreshAdded(newIdx);
            this.updateCurrentPosition();
        }

        public void historyRemoved(int count) {
            if (count == 0) {
                return;
            }
            if (count < 0) {
                this.fireIntervalRemoved(this, 0, Math.abs(count) - 1);
            } else {
                int firstRemoved = this.mHistory.getSize();
                this.fireIntervalRemoved(this, firstRemoved, firstRemoved + count - 1);
                this.updateCurrentPosition();
            }
        }

        public void startUndoRedo(boolean isRedo) {
        }

        public void endUndoRedo(boolean isRedo) {
        }
    }

    protected static class TransactionCellRenderer
    implements ListCellRenderer<DbHistory.Transaction> {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        protected JLabel commentLabel = new JLabel();

        protected TransactionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends DbHistory.Transaction> list, DbHistory.Transaction value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel render = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value.getName(), index, isSelected, cellHasFocus);
            render.setIcon(value.getClosed() ? OrbitIcons.ACCEPT : OrbitIcons.WAIT);
            this.commentLabel.setForeground(Color.GRAY);
            this.commentLabel.setText("(" + value.getEventCount() + ")");
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(render);
            panel.add(Box.createHorizontalStrut(2));
            panel.add(this.commentLabel);
            panel.setOpaque(false);
            return panel;
        }
    }
}

