/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.sigrity.acl.APair;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.tree.TreePath;

public class DbObjectTransferable {
    private DbObjectTransferable() {
    }

    public static class NetTransferable
    implements Transferable,
    HierInstTransferable {
        public static final DataFlavor NetFlavor = new DataFlavor("application/x-sigrity-orbit-net", "Net");
        protected static final DataFlavor[] sSupportedFlavors = new DataFlavor[]{NetFlavor};
        protected DevicePath mNetDevicePath;
        protected Net mDbNet;
        protected DevicePath mPinDevicePath;
        protected PinTemplate mPinTemplate;

        public NetTransferable(DevicePath dpath, Net dbNetObj) {
            this.mNetDevicePath = dpath;
            this.mDbNet = dbNetObj;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return sSupportedFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == NetFlavor;
        }

        @Override
        public DevicePath getDevicePath() {
            return this.mNetDevicePath;
        }

        public Net getDbObject() {
            return this.mDbNet;
        }

        public DevicePath getTargetPinPath() {
            return this.mPinDevicePath;
        }

        public PinTemplate getTargetPinTemplate() {
            return this.mPinTemplate;
        }

        public void setTargetPinPath(DevicePath pinDevicePath) {
            this.mPinDevicePath = pinDevicePath;
        }

        public void setTargetPinTemplate(PinTemplate pinTemplate) {
            this.mPinTemplate = pinTemplate;
        }
    }

    public static class NetListTransferable
    implements Transferable {
        public static final DataFlavor NetListFlavor = new DataFlavor("application/x-sigrity-orbit-nets", "Net");
        protected static final DataFlavor[] sSupportedFlavors = new DataFlavor[]{NetListFlavor};
        protected UIData mData;

        public NetListTransferable(List<Net> nets, Component c) {
            this.mData = new UIData(nets, c);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(NetListFlavor)) {
                return this.mData;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return sSupportedFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return NetListFlavor.equals(flavor);
        }

        public static final class UIData
        extends APair<List<Net>, Component> {
            public UIData(List<Net> nets, Component c) {
                super(nets, (Object)c);
            }

            public Component getSource() {
                return (Component)this.second;
            }

            public List<Net> getNets() {
                return (List)this.first;
            }
        }
    }

    public static class DeviceTransferable
    implements Transferable,
    HierInstTransferable {
        public static final DataFlavor FLAVOR = new DataFlavor(Device.class, "Device");
        protected static final DataFlavor[] FLAVORS = new DataFlavor[]{FLAVOR};
        protected DevicePath mDevicePath;
        protected TreePath mTreePath;

        public DeviceTransferable(DevicePath dpath, TreePath tpath) {
            this.mDevicePath = dpath;
            this.mTreePath = tpath;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == FLAVOR;
        }

        @Override
        public DevicePath getDevicePath() {
            return this.mDevicePath;
        }

        @Override
        public DbObject getDbObject() {
            return this.mDevicePath.getDevice();
        }
    }

    public static class HierDboTransferable
    implements Transferable,
    HierInstTransferable {
        public static final DataFlavor FLAVOR = new DataFlavor(DbObject.class, "DbObject");
        protected static final DataFlavor[] FLAVORS = new DataFlavor[]{FLAVOR};
        protected DevicePath mDevicePath;
        protected DbObject mObject;

        public HierDboTransferable(DevicePath dpath, DbObject object) {
            this.mDevicePath = dpath;
            this.mObject = object;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == FLAVOR;
        }

        @Override
        public DevicePath getDevicePath() {
            return this.mDevicePath;
        }

        @Override
        public DbObject getDbObject() {
            return this.mObject;
        }
    }

    public static interface HierInstTransferable {
        public DevicePath getDevicePath();

        public DbObject getDbObject();
    }
}

