/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.sigrity.acl.AColor;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.ANumberIcon;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.acl.ui.atree.ATreeLeaf;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.NodeIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DbSelectionPanel
extends JPanel {
    private static final int MAX_SHOW_ELEMENTS = 1000;
    public static final Icon NOICON = new AColorIcon(1, 1, AColor.CLEAR, AColor.CLEAR);
    protected static final ANumberIcon notifyIcon = new ANumberIcon(0, 14, 14);
    protected ATree mTree;
    protected Selection mSelection;
    protected SelectionTreeModel mSelTreeModel;
    protected TreeSelectionListener mTreeHighlightSelectionListener = null;

    public DbSelectionPanel() {
        GridBagManager gbm = GridBagManager.layout((Container)this);
        this.mSelTreeModel = new SelectionTreeModel(null);
        this.mTree = new ATree(this.mSelTreeModel){

            public String getToolTipText(MouseEvent event) {
                TreePath path = this.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return null;
                }
                Object node = path.getLastPathComponent();
                if (node instanceof HelperSupport) {
                    return ((HelperSupport)node).getTooltipText();
                }
                return null;
            }
        };
        this.mTreeHighlightSelectionListener = e -> {
            DesignView2D v2d;
            AAppView view = DbSelectionPanel.getCurOrbitView();
            DesignView2D designView2D = v2d = view instanceof DesignView2D ? (DesignView2D)view : null;
            if (v2d == null) {
                return;
            }
            boolean render = false;
            DbObjectHighlighter.clear(v2d);
            render |= Floorplan.setHighlightedObject(null);
            TreePath[] paths = this.mTree.getSelectionPaths();
            if (paths != null) {
                Selection sel = new Selection(v2d.getDb());
                for (TreePath path : paths) {
                    HelperSupport node;
                    Object item = path.getLastPathComponent();
                    if (item instanceof SelectedPathNode) {
                        node = (SelectedPathNode)item;
                        HierInst<DbObject> hierObj = ((SelectedPathNode)node).getHierInst();
                        if (hierObj == null) continue;
                        sel.add(hierObj);
                        continue;
                    }
                    if (!(item instanceof SelectedObjNode)) continue;
                    node = (SelectedObjNode)item;
                    for (HierInst hierObj : ((SelectedObjNode)node).getHierInstances()) {
                        sel.add(hierObj);
                    }
                }
                DbObjectHighlighter.highlight(v2d, sel);
            }
            if (render) {
                OrbitApp.getApp().refreshCurrentView(false);
            }
        };
        this.mTree.addTreeSelectionListener(this.mTreeHighlightSelectionListener);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.mTree);
        this.mTree.setToolTipText("Selected items");
        this.mTree.getSelectionModel().setSelectionMode(2);
        this.mTree.setRootVisible(false);
        this.mTree.setShowsRootHandles(true);
        this.mTree.setCellRenderer((TreeCellRenderer)new SelectionTreeCellRenderer());
        JScrollPane sp = new JScrollPane((Component)this.mTree);
        gbm.add((Component)sp, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        this.installPopupMenu();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.setDb(null);
    }

    public void setDb(Db db) {
        Selection s;
        Design design;
        if (this.mSelTreeModel != null && (design = Design.getDesign((Db)this.mSelTreeModel.getDb(), (boolean)false)) != null && (s = design.getCurSelection()) != null) {
            this.mSelTreeModel.setDb(null);
            s.removeSelectionListener((Selection.SelectionListener)this.mSelTreeModel);
        }
        if (db != null) {
            Design currentDesign = Design.getDesign((Db)db);
            if (currentDesign == null) {
                ALog.logError((String)"There is no current design");
                return;
            }
            s = currentDesign.getCurSelection();
            if (this.mSelTreeModel != null) {
                this.mSelTreeModel.setDb(db);
                this.mSelTreeModel.setSelection(s);
                s.addSelectionListener((Selection.SelectionListener)this.mSelTreeModel);
                s.fireSelectionChanged();
            }
        }
    }

    protected void updateNotifyMessage(Selection s) {
        notifyIcon.setNumber((int)s.getCountInst());
    }

    protected void installPopupMenu() {
        KeyStroke POPUP_KEYSTROKE = KeyStroke.getKeyStroke(121, 64);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath sel = DbSelectionPanel.this.mTree.getSelectionPath();
                if (sel != null) {
                    Rectangle r = DbSelectionPanel.this.mTree.getPathBounds(sel);
                    Point p = new Point();
                    if (r == null) {
                        p.x = 0;
                        p.y = 0;
                    } else {
                        p.x = r.x;
                        p.y = r.y + r.height;
                    }
                    DbSelectionPanel.this.showTreeContextMenu(sel.getLastPathComponent(), p.x, p.y);
                } else {
                    DbSelectionPanel.this.showTreeContextMenu(null, 0, 0);
                }
            }
        };
        ActionMap am = this.mTree.getActionMap();
        am.put(action, action);
        this.mTree.getInputMap().put(POPUP_KEYSTROKE, action);
        this.mTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            protected void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.getSource();
                    TreePath p = DbSelectionPanel.this.mTree.getPathForLocation(e.getX(), e.getY());
                    if (p != null) {
                        DbSelectionPanel.this.showTreeContextMenu(p.getLastPathComponent(), e.getX(), e.getY());
                    } else {
                        DbSelectionPanel.this.showTreeContextMenu(null, e.getX(), e.getY());
                    }
                }
            }
        });
    }

    protected void showTreeContextMenu(Object o, int x, int y) {
        ArrayList<JMenuItem> menuItems = new ArrayList<JMenuItem>();
        if (this.mTree.getSelectionCount() > 1) {
            Db db = OrbitIO.getCurDb();
            Selection sel = new Selection(db);
            for (TreePath treePath : this.mTree.getSelectionPaths()) {
                Object obj = treePath.getLastPathComponent();
                if (!(obj instanceof SelectedObjNode)) continue;
                for (HierInst hi : ((SelectedObjNode)obj).getHierInstances()) {
                    sel.add(hi);
                }
            }
            OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            OrbitGuiShortcutActionRegistry sar = OrbitGuiShortcutActionRegistry.get();
            menuItems.addAll(oar.getJMenuItems(sel).stream().collect(Collectors.toList()));
            OrbitGuiShortcutActionRegistry.ViewConstraint vc = OrbitGuiShortcutActionRegistry.ViewConstraint.createAll();
            vc.remove(Selection.class);
            for (Object obj : sar.getActions(db, sel, null, vc)) {
                if (obj instanceof Action) {
                    menuItems.add(ObjectActionRegistry.getJMenuItem((Action)obj));
                    continue;
                }
                if (!(obj instanceof JMenuItem)) continue;
                menuItems.add((JMenuItem)obj);
            }
        } else if (o instanceof HelperSupport) {
            HelperSupport son = (HelperSupport)o;
            son.populateMenuItems(menuItems);
        }
        if (menuItems.isEmpty()) {
            return;
        }
        JPopupMenu m = new JPopupMenu();
        for (JMenuItem mi : menuItems) {
            if (mi == null) {
                m.addSeparator();
                continue;
            }
            m.add(mi);
            UIUtil.setUniqueMnemonic((JPopupMenu)m, (AbstractButton)mi);
        }
        OrbitIO.getGuiWorkspace().beautify(m);
        m.show((Component)this.mTree, x, y);
    }

    public static AAppView getCurOrbitView() {
        OrbitIO app = OrbitIO.getOrbitIO();
        if (app == null) {
            return null;
        }
        return app.getCurrentView();
    }

    public class SelectedPathNode
    extends ATreeLeaf
    implements HelperSupport,
    RendererSupport {
        protected HierInst<DbObject> mHierInst;

        public SelectedPathNode(ATreeNode parent, HierInst<DbObject> hierInst) {
            super(parent);
            this.mHierInst = hierInst;
        }

        public String getText() {
            if (this.mHierInst == null || !this.mHierInst.isValid()) {
                return "<INVALID>";
            }
            return this.mHierInst.getPath().escapedString();
        }

        public Icon getIcon() {
            return NOICON;
        }

        public HierInst<DbObject> getHierInst() {
            return this.mHierInst;
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            OrbitIO orbitIO = OrbitIO.getOrbitIO();
            if (orbitIO == null) {
                return;
            }
            OrbitGuiWS gws = orbitIO.getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            LinkedList objItems = AMenuUtil.groupByFirstWord(oar.getJMenuItems(this.getHierInst()));
            AMenuUtil.sort((List)objItems, (boolean)true);
            items.addAll(objItems);
        }

        @Override
        public String getTooltipText() {
            return this.mHierInst.getDbObject().toString();
        }

        @Override
        public void render(SelectionTreeCellRenderer renderer) {
            renderer.setIcon(null);
            renderer.setText(this.getText());
            renderer.setCommentText(null);
        }
    }

    public class SelectedObjNode
    extends ALazyTreeNode
    implements HelperSupport,
    RendererSupport {
        protected DbObject mDbObject;
        protected String mCacheText;

        public SelectedObjNode(ATreeNode parent, DbObject o) {
            super(parent);
            this.mDbObject = o;
        }

        public IterableIterator<HierInst<DbObject>> getHierInstances() {
            if (this.getChildCount() == 0) {
                return AEmptyItr.create();
            }
            return new StreamIterableIterator(this.mChildren.stream().flatMap(node -> {
                if (node instanceof SelectedPathNode) {
                    return Stream.of(((SelectedPathNode)node).getHierInst());
                }
                return Stream.empty();
            }).filter(Objects::nonNull));
        }

        public String getText() {
            if (this.mCacheText != null) {
                return this.mCacheText;
            }
            this.mCacheText = this.mDbObject instanceof Connection ? ((Connection)this.mDbObject).getDesc() : this.mDbObject.toString();
            return this.mCacheText;
        }

        @Override
        public String getTooltipText() {
            return String.format("Key: %s", this.mDbObject.getKeyStr());
        }

        public Icon getIcon() {
            return DbExplorerPanel.getIconForDbObject(this.mDbObject);
        }

        public SelectionTreeModel getTreeModel() {
            return (SelectionTreeModel)super.getTreeModel();
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<SelectedPathNode> children = new ArrayList<SelectedPathNode>();
            Db db = this.getTreeModel().getDb();
            if (db == null || DbSelectionPanel.this.mSelection == null || DbSelectionPanel.this.mSelection.getDb() != db) {
                return children;
            }
            Selection s = DbSelectionPanel.this.mSelection;
            for (HierInst hi : s.getSelected(this.mDbObject).getInsts()) {
                children.add(new SelectedPathNode((ATreeNode)this, (HierInst<DbObject>)hi));
            }
            return children;
        }

        @Override
        public void populateMenuItems(List<JMenuItem> items) {
            if (this.mChildren != null && this.mChildren.size() == 1 && this.mChildren.get(0) instanceof SelectedPathNode) {
                ((SelectedPathNode)this.mChildren.get(0)).populateMenuItems(items);
                return;
            }
            OrbitIO orbitIO = OrbitIO.getOrbitIO();
            if (orbitIO == null) {
                return;
            }
            OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            DbObject dbo = this.mDbObject;
            LinkedList objItems = AMenuUtil.groupByFirstWord(oar.getJMenuItems(dbo));
            AMenuUtil.sort((List)objItems, (boolean)true);
            items.addAll(objItems);
        }

        @Override
        public void render(SelectionTreeCellRenderer renderer) {
            renderer.setIcon(this.getIcon());
            renderer.setText(this.getText());
            int count = this.getChildCount();
            if (count == 1) {
                renderer.setCommentText(((SelectedPathNode)this.getChildAt(0)).getText());
            } else {
                renderer.setCommentText("" + this.getChildCount());
            }
        }
    }

    public class SelectionTreeClassNode
    extends ALazyTreeNode
    implements RendererSupport {
        protected DbClass mDbClass;

        public SelectionTreeClassNode(ATreeNode parent, DbClass dbc) {
            super(parent);
            this.mDbClass = dbc;
        }

        public SelectionTreeModel getTreeModel() {
            return (SelectionTreeModel)super.getTreeModel();
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<SelectedObjNode> children = new ArrayList<SelectedObjNode>();
            Db db = this.getTreeModel().getDb();
            if (db == null || DbSelectionPanel.this.mSelection == null || DbSelectionPanel.this.mSelection.getDb() != db) {
                return children;
            }
            Selection s = DbSelectionPanel.this.mSelection;
            for (DbObject dbo : s.get(this.mDbClass)) {
                children.add(new SelectedObjNode((ATreeNode)this, dbo));
            }
            if (children.size() > 1000) {
                this.mSortChildren = false;
            }
            return children;
        }

        public String getText() {
            if (this.mDbClass == null) {
                return "DBObjects";
            }
            return String.format("%ss", this.mDbClass.getName());
        }

        @Override
        public void render(SelectionTreeCellRenderer renderer) {
            renderer.setIcon(NodeIcons.getFolderIcon());
            renderer.setText(this.getText());
            renderer.setCommentText("" + DbSelectionPanel.this.mSelection.getCount(this.mDbClass));
        }
    }

    public class SelectionTreeRootNode
    extends ALazyTreeNode
    implements RendererSupport {
        public SelectionTreeRootNode(SelectionTreeModel model) {
            super((ATreeModel)model);
        }

        public SelectionTreeModel getTreeModel() {
            return (SelectionTreeModel)super.getTreeModel();
        }

        public String getText() {
            Db db = DbSelectionPanel.this.mSelTreeModel.getDb();
            if (db == null) {
                return "No open design";
            }
            return String.format("Selection for '%s'", db.getDescription(false));
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<ALazyTreeNode> children = new ArrayList<ALazyTreeNode>();
            Db db = this.getTreeModel().getDb();
            if (db == null || DbSelectionPanel.this.mSelection == null || DbSelectionPanel.this.mSelection.getDb() != db) {
                return children;
            }
            Selection s = DbSelectionPanel.this.mSelection;
            ArrayList dbClasses = AUtil.arrayList((Iterator)s.getClasses());
            Collections.sort(dbClasses);
            if (dbClasses.size() == 1 && s.getCountTotal() < 1000L) {
                DbClass dbc = (DbClass)dbClasses.get(0);
                for (DbObject dbo : s.get(dbc)) {
                    children.add(new SelectedObjNode((ATreeNode)this, dbo));
                }
            } else {
                for (DbClass dbc : dbClasses) {
                    children.add(new SelectionTreeClassNode((ATreeNode)this, dbc));
                }
            }
            if (children.size() > 1000) {
                this.mSortChildren = false;
            }
            return children;
        }

        @Override
        public void render(SelectionTreeCellRenderer renderer) {
            renderer.setText(this.getText());
        }
    }

    protected class SelectionTreeModel
    extends ATreeModel
    implements Selection.SelectionListener {
        protected Db mDb;
        protected boolean mSelectionChangePending = false;

        public SelectionTreeModel(Db db) {
            this.setDb(db);
        }

        public void setSelection(Selection s) {
            DbSelectionPanel.this.mSelection = s;
        }

        public void setDb(Db db) {
            this.mDb = db;
            this.setRoot((TreeNode)((Object)new SelectionTreeRootNode(this)));
        }

        public Db getDb() {
            return this.mDb;
        }

        public void selectionChanged(HashMap<DbClass, Selection.SelSet> set) {
            if (this.mSelectionChangePending) {
                return;
            }
            this.mSelectionChangePending = true;
            EventQueue.invokeLater(() -> {
                if (this.mDb == null || this.mDb.closed()) {
                    return;
                }
                ((SelectionTreeRootNode)this.getRoot()).invalidateChildren();
                DbSelectionPanel.this.updateNotifyMessage(DbSelectionPanel.this.mSelection);
                this.mSelectionChangePending = false;
            });
        }
    }

    protected static interface RendererSupport {
        public void render(SelectionTreeCellRenderer var1);
    }

    protected static interface HelperSupport {
        public void populateMenuItems(List<JMenuItem> var1);

        public String getTooltipText();
    }

    public static class SelectionTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected DefaultTreeCellRenderer mDfltRenderer = new DefaultTreeCellRenderer();
        protected JLabel mIconLabel = new JLabel();
        protected JLabel mColorLabel = new JLabel();
        protected JLabel mCommentLabel = new JLabel();
        protected Object value;
        protected JTree tree;
        protected boolean selected;
        protected boolean expanded;
        protected boolean leaf;
        protected int row;
        protected boolean hasFocus;
        protected DbExplorerPanel.TextDecoration mTextDecoration = DbExplorerPanel.TextDecoration.NONE;
        protected int mMaxRenderWidth = 16;
        protected boolean mRenderUpdating = false;
        protected static final int mMaxRenderHight = 18;
        protected Dimension mCellDim = new Dimension(this.mMaxRenderWidth, 18);

        public SelectionTreeCellRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.mIconLabel);
            this.add(this.mColorLabel);
            this.add(Box.createHorizontalStrut(2));
            this.add(this.mDfltRenderer);
            this.add(Box.createHorizontalStrut(2));
            this.add(this.mCommentLabel);
            this.mCommentLabel.setForeground(Color.GRAY);
            this.mDfltRenderer.setLeafIcon(null);
            this.mDfltRenderer.setOpenIcon(null);
            this.mDfltRenderer.setClosedIcon(null);
            this.mDfltRenderer.setIcon(null);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.mDfltRenderer.getTreeCellRendererComponent(tree, null, selected, expanded, leaf, row, hasFocus);
            if (value instanceof RendererSupport) {
                ((RendererSupport)value).render(this);
            }
            this.revalidate();
            return this;
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.mDfltRenderer != null) {
                this.mDfltRenderer.setFont(font);
            }
        }

        public void setText(String text) {
            this.mDfltRenderer.setText(text);
        }

        public void setIcon(Icon icon) {
            this.mIconLabel.setIcon(icon);
        }

        public void setColorIcon(Icon icon) {
            this.mColorLabel.setVisible(true);
            this.mColorLabel.setIcon(icon);
        }

        public void setCommentText(String text) {
            this.mCommentLabel.setVisible(text != null);
            if (text != null) {
                this.mCommentLabel.setText("(" + text + ")");
            }
        }

        @Override
        public void setToolTipText(String text) {
            ALog.logError((Throwable)new Exception("Not supported"), (String)"Do not use this function. Please replace with Node.getTooltipText()", (Object[])new Object[0]);
        }

        public void setTextDecoration(DbExplorerPanel.TextDecoration style) {
            this.mTextDecoration = style;
        }
    }
}

