/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.tree.DbTreeModel;
import com.sigrity.tools.dbexplorer.tree.JitDbTreeNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeModel;

public class DbTraceExplorerPanel
extends DbExplorerPanel {
    protected Tracker mTracker = null;

    public DbTraceExplorerPanel(String name) {
        super(name, false);
        this.setRelationDisplay(DbExplorerPanel.RELATION_DISPLAY.HIDE);
        this.setCountCommentDisplay(false);
    }

    @Override
    protected void createSearchPanel(GridBagManager l) {
    }

    @Override
    protected void createSelectJumpPanel(GridBagManager l) {
    }

    @Override
    protected DbTraceExplorerPanel createTracePanel() {
        return null;
    }

    @Override
    protected boolean filterTreeNode(JitDbTreeNode node) {
        if (this.mTracker != null) {
            return this.mTracker.filterTreeNode(node);
        }
        return super.filterTreeNode(node);
    }

    public void startNetTracing(HierInst<Net> hierInst) {
        this.mTracker = new NetTracker(hierInst);
    }

    @Override
    public void updateCurDbTo(Db db) {
        this.mDb = db;
        TreeModel tm = this.mTree.getModel();
        if (tm instanceof DbTreeModel) {
            DbTreeModel dbtm = (DbTreeModel)((Object)tm);
            dbtm.dispose();
        }
        if (db != null) {
            this.mTree.setRootVisible(false);
        } else {
            this.mTree.setModel(null);
        }
        if (db != null) {
            TreeUI backupUI = this.mTree.getUI();
            this.mTree.setUI(null);
            this.mTree.setRootVisible(true);
            if (Design.getDesign((Db)db) != null) {
                DbTreeModel dbtm = new DbTreeModel();
                DbExplorerPanel.DeviceHierarchyRootNode hrn = new DbExplorerPanel.DeviceHierarchyRootNode(null);
                hrn.setModel(dbtm);
                int defaultOpenLevels = (Integer)Settings.getSettings((String)"UserPreferences").getSetting("DfltHiearchyExplorerLevels", (Object)-1);
                hrn.setDefaultOpenLevels(defaultOpenLevels);
                dbtm.setRoot(hrn);
                this.mTree.setModel((TreeModel)((Object)dbtm));
            }
            this.mTree.setUI(backupUI);
        }
    }

    @Override
    protected LinkedList<JMenuItem> createContextMenu() {
        LinkedList<JMenuItem> items = super.createContextMenu();
        items.add(0, new JMenuItem(new ActionStopTrace()));
        items.add(1, new JMenuItem(new ActionOpenWindow()));
        items.add(2, new JMenuItem(new ActionExpandAll()));
        items.add(3, new JMenuItem(new ActionCollapseAll()));
        return items;
    }

    protected class ActionCollapseAll
    extends AbstractAction {
        ActionCollapseAll() {
            super("Collapse All");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbTraceExplorerPanel.this.collapseNodes();
        }
    }

    protected class ActionExpandAll
    extends AbstractAction {
        ActionExpandAll() {
            super("Expand All");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIUtil.expandTreeAll((JTree)DbTraceExplorerPanel.this.mTree);
        }
    }

    protected class ActionOpenWindow
    extends AbstractAction {
        ActionOpenWindow() {
            super("Open Window");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbDialog dialog = new DbDialog(DbTraceExplorerPanel.this.getDb(), (Component)OrbitIO.getMainWindow(), DbTraceExplorerPanel.this.mTracker.getName());
            GridBagManager l = GridBagManager.layout((Container)dialog.getContentPane());
            DbTraceExplorerPanel panel = new DbTraceExplorerPanel("Db Explorer Tracker");
            panel.mTracker = DbTraceExplorerPanel.this.mTracker;
            panel.setDb(DbTraceExplorerPanel.this.getDb());
            l.add((Component)panel, (GridBagConstraints)GridBagManager.FILLALL);
            new ActionStopTrace().actionPerformed(null);
            dialog.setSize(400, 600);
            dialog.setVisible(true);
        }
    }

    protected class ActionStopTrace
    extends AbstractAction {
        ActionStopTrace() {
            super("Stop Tracing");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbTraceExplorerPanel.this.mTracker = null;
            DbTraceExplorerPanel.this.setDb(null);
            DbTraceExplorerPanel.this.setVisible(false);
        }
    }

    protected static class NetTracker
    implements Tracker {
        private final HierInst<Net> stNetInst;
        private Set<DevicePath> paths = new HashSet<DevicePath>();
        private Set<HierInst<Net>> hierInsts = new HashSet<HierInst<Net>>();
        private Set<HierInst<Term>> hierTerms = new HashSet<HierInst<Term>>();

        public NetTracker(HierInst<Net> netInst) {
            this.stNetInst = netInst;
            assert (netInst.getPath().getIsAbsolute());
            this.prepare(this.stNetInst);
        }

        private void prepare(HierInst<Net> stNetInst) {
            this.addTrace(stNetInst);
            for (DevicePath path : new HashSet<DevicePath>(this.paths)) {
                DevicePath c = path.copy();
                while (!c.isEmpty()) {
                    c.removeLast();
                    this.paths.add(c.copy());
                }
            }
        }

        private void addTrace(HierInst<Net> netInst) {
            if (this.hierInsts.contains(netInst)) {
                return;
            }
            for (HierInst hierNet : TermMap.getConnectedHierNets((DevicePath)netInst.getPath(), (Net)((Net)netInst.getDbObject()))) {
                if (!this.hierInsts.add((HierInst<Net>)hierNet)) continue;
                this.paths.add(hierNet.getPath());
                for (Term term : ((Net)hierNet.getDbObject()).getTerms()) {
                    this.hierTerms.add((HierInst<Term>)new HierInst(hierNet.getPath(), (DbObject)term));
                }
            }
        }

        public boolean isConnectedNet(HierInst<Net> netInst) {
            return this.hierInsts.contains(netInst);
        }

        public boolean isConnectedTerm(HierInst<Term> termInst) {
            return this.hierTerms.contains(termInst);
        }

        @Override
        public boolean filterTreeNode(JitDbTreeNode node) {
            if (node instanceof DbExplorerPanel.DisplayNode || node instanceof DbExplorerPanel.PinLabelsNode || node instanceof DbExplorerPanel.PinsNode) {
                return false;
            }
            if (node instanceof DbExplorerPanel.DeviceHierarchyNode) {
                DbExplorerPanel.DeviceHierarchyNode dNode = (DbExplorerPanel.DeviceHierarchyNode)node;
                return this.paths.contains(dNode.getDevicePath());
            }
            if (node instanceof DbExplorerPanel.NetNode) {
                DbExplorerPanel.NetNode dNode = (DbExplorerPanel.NetNode)node;
                return this.hierInsts.contains(dNode.getHierInst());
            }
            if (node instanceof DbExplorerPanel.PinTemplateNode) {
                DbExplorerPanel.PinTemplateNode dNode = (DbExplorerPanel.PinTemplateNode)node;
                return this.isConnectedNet((HierInst<Net>)HierInst.create((DevicePath)dNode.getDevicePath(), (DbObject)dNode.getPinT().getNet()));
            }
            if (node instanceof DbExplorerPanel.TermNode) {
                DbExplorerPanel.TermNode tNode = (DbExplorerPanel.TermNode)node;
                return this.isConnectedTerm(tNode.getHierInst());
            }
            return true;
        }

        @Override
        public String getName() {
            return String.format("Tracker %s (%s)", this.stNetInst.getDbObject(), this.stNetInst.getPath());
        }
    }

    static interface Tracker {
        public boolean filterTreeNode(JitDbTreeNode var1);

        public String getName();
    }
}

