/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.CoreFactory;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.UIManager;

public class NodeIcons {
    static final String kShowBumpDirection = "showBumpDirection";
    static final String kShowDeviceDirection = "showDeviceDirection";
    static final String kShowContactAttribute = "showContactAttribute";
    private static Map<DeviceTemplate, Device.BumpDir> mBumpDeviceDirection = new WeakHashMap<DeviceTemplate, Device.BumpDir>();
    private static Map<DeviceTemplate, Device.BumpDir> mBumpDeviceDirectionFlipped = new WeakHashMap<DeviceTemplate, Device.BumpDir>();

    private NodeIcons() {
    }

    public static Icon getIconForSubstrate(Substrate s) {
        return s.getInferredType(true).map(DbExplorerPanel::getIconForTemplateType).orElse(DBEResources.ICON_UNKNOWN);
    }

    public static Icon getIconForTemplate(DeviceTemplate template) {
        if (template == null || template.getDb() == null || template.getDb().closed()) {
            return null;
        }
        if (template instanceof Design) {
            return DBEResources.ICON_DESIGNDEVICES;
        }
        Icon icon = NodeIcons.getIconForTemplateType(template.getType());
        if (NodeIcons.isShowContactAttribute(OrbitIO.getCurDesign()) && template.getIsAbstractContactDevice()) {
            icon = NodeIcons.getDecoratedIconForAbstrateContact(template, icon);
        }
        return icon;
    }

    private static Icon getDecoratedIconForAbstrateContact(DeviceTemplate template, Icon originIcon) {
        Icon iconDecor = DBEResources.ICON_CONTACT_ATTRIBUTE;
        return new ADecoratedIcon(originIcon, iconDecor, ADecoratedIcon.POSX.RIGHT, ADecoratedIcon.POSY.BOTTOM);
    }

    public static Icon getIconForTemplateType(DeviceTemplate.Type type) {
        switch (type) {
            case PERSONALITY: {
                return PersonalityUI.getIconForPersonalityType(Personality.Type.DEVICE);
            }
            case COVER: {
                return DBEResources.ICON_COVER;
            }
            case CORE: {
                return DBEResources.ICON_CORE;
            }
            case PAD: {
                return DBEResources.ICON_PAD;
            }
            case PACKAGEDDIE: {
                return DBEResources.ICON_DIP;
            }
            case BUMP: {
                return DBEResources.ICON_BUMP;
            }
            case BLOCK: {
                return DBEResources.ICON_CORE;
            }
            case BONDFINGER: {
                return DBEResources.ICON_BONDFINGER;
            }
            case MACRO: {
                return DBEResources.ICON_MACRO;
            }
            case PACKAGE: {
                return DBEResources.ICON_PACKAGE;
            }
            case INTERPOSER: {
                return DBEResources.ICON_INTERPOSER;
            }
            case CONTACT_DEVICE: {
                return DBEResources.ICON_CONTACT_DEVICE;
            }
            case GROUP: {
                return DBEResources.ICON_FOLDER;
            }
            case DIE: {
                return DBEResources.ICON_DIE;
            }
            case BOARD: {
                return DBEResources.ICON_BOARD;
            }
            case ENDCAP: {
                return DBEResources.ICON_CORNER;
            }
            case LOGICAL: {
                return CoreFactory.getIcon(null);
            }
            case RING: {
                return DBEResources.ICON_RING;
            }
            case HARDMACRO: {
                return DBEResources.ICON_HARDBLOCK;
            }
            case SOFTMACRO: {
                return DBEResources.ICON_SOFTBLOCK;
            }
        }
        return DBEResources.ICON_TEMPLATE;
    }

    public static void setShowBumpDirection(boolean enable) {
        Cp.exec((String)"OrbitIO.getCurDesign().setValue(\"%s\", %s)", (Object[])new Object[]{kShowBumpDirection, enable});
    }

    public static boolean isShowBumpDirection(Design dsn) {
        if (dsn == null) {
            return true;
        }
        Boolean showBumpDirection = (Boolean)dsn.getValue(kShowBumpDirection, Boolean.class);
        return showBumpDirection == null || showBumpDirection != false;
    }

    public static void setShowDeviceDirection(boolean enable) {
        Cp.exec((String)"OrbitIO.getCurDesign().setValue(\"%s\", %s)", (Object[])new Object[]{kShowDeviceDirection, enable});
    }

    public static boolean isShowDeviceDirection(Design dsn) {
        if (dsn == null) {
            return true;
        }
        Boolean showDeviceDirection = (Boolean)dsn.getValue(kShowDeviceDirection, Boolean.class);
        return showDeviceDirection == null || showDeviceDirection != false;
    }

    public static void setShowContactAttribute(boolean enable) {
        Cp.exec((String)"OrbitIO.getCurDesign().setValue(\"%s\", %s)", (Object[])new Object[]{kShowContactAttribute, enable});
    }

    public static boolean isShowContactAttribute(Design dsn) {
        if (dsn == null) {
            return true;
        }
        Boolean showContactAttribute = (Boolean)dsn.getValue(kShowContactAttribute, Boolean.class);
        return showContactAttribute == null || showContactAttribute != false;
    }

    static void resetCache() {
        mBumpDeviceDirection = new WeakHashMap<DeviceTemplate, Device.BumpDir>();
        mBumpDeviceDirectionFlipped = new WeakHashMap<DeviceTemplate, Device.BumpDir>();
    }

    private static Icon addDecorationBumpDirection(Icon icon, DeviceTemplate template, Device device) {
        Device.BumpDir dir;
        if (!device.isDie()) {
            return icon;
        }
        Icon iconDecor = null;
        Device.BumpDir bumpDir = dir = device.getFlipped() ? mBumpDeviceDirectionFlipped.get(template) : mBumpDeviceDirection.get(template);
        if (dir == null) {
            dir = device.bumpDirection(true);
            if (device.getFlipped()) {
                mBumpDeviceDirectionFlipped.put(template, dir);
            } else {
                mBumpDeviceDirection.put(template, dir);
            }
        }
        switch (dir) {
            case BUMP_UP: {
                iconDecor = DBEResources.ICON_BUMP_UP;
                break;
            }
            case BUMP_DOWN: {
                iconDecor = DBEResources.ICON_BUMP_DOWN;
                break;
            }
            case BUMP_BOTH: {
                iconDecor = DBEResources.ICON_BUMP_BOTH;
                break;
            }
        }
        if (iconDecor != null) {
            icon = new ADecoratedIcon(icon, iconDecor, ADecoratedIcon.POSX.CENTER, ADecoratedIcon.POSY.CENTER);
        }
        return icon;
    }

    private static Icon addDecorationDeviceDirection(Icon icon, DeviceTemplate template, Device device) {
        if (!device.getIsSubstrate()) {
            return icon;
        }
        if (device.getIsDefinitelyNotSubstrate()) {
            return icon;
        }
        if (device.getFlipped()) {
            Icon iconDecor = DBEResources.ICON_DEVICE_DN;
            icon = new ADecoratedIcon(icon, iconDecor, ADecoratedIcon.POSX.CENTER, ADecoratedIcon.POSY.BOTTOM);
        } else {
            Icon iconDecor = DBEResources.ICON_DEVICE_UP;
            icon = new ADecoratedIcon(icon, iconDecor, ADecoratedIcon.POSX.CENTER, ADecoratedIcon.POSY.TOP);
        }
        return icon;
    }

    public static Icon getIconForDevice(Device device) {
        if (device == null) {
            return null;
        }
        if (device.getDb() == null) {
            return DBEResources.ICON_INVALID;
        }
        if (device.getName().equals("<Design>")) {
            return DBEResources.ICON_DESIGN;
        }
        DeviceTemplate template = device.getTemplate();
        if (template != null) {
            Db db = template.getDb();
            Design design = Design.getDesign((Db)db, (boolean)false);
            Icon icon = NodeIcons.getIconForTemplate(template);
            if (NodeIcons.isShowBumpDirection(design)) {
                icon = NodeIcons.addDecorationBumpDirection(icon, template, device);
            }
            if (NodeIcons.isShowDeviceDirection(design)) {
                icon = NodeIcons.addDecorationDeviceDirection(icon, template, device);
            }
            return icon;
        }
        return DBEResources.ICON_UNKNOWN;
    }

    public static Icon getIconForPinTemplate(PinTemplate pt) {
        if (pt == null) {
            return null;
        }
        if (pt.getType().equals((Object)PinTemplate.Type.BUMPPAD)) {
            return DBEResources.ICON_BUMP_PIN;
        }
        if (pt.getType().equals((Object)PinTemplate.Type.BALLPAD)) {
            return DBEResources.ICON_BALL_PIN;
        }
        if (pt.getType().equals((Object)PinTemplate.Type.IOPAD)) {
            return DBEResources.ICON_PAD;
        }
        if (pt.getType().equals((Object)PinTemplate.Type.BONDFINGERPAD)) {
            return DBEResources.ICON_BONDFINGER;
        }
        if (pt.getType().equals((Object)PinTemplate.Type.TSV)) {
            return DBEResources.ICON_TSV;
        }
        return DBEResources.ICON_PIN;
    }

    public static Icon getIconForNet(Net net) {
        return DBEResources.ICON_NET;
    }

    public static Icon getIconForTerm(Term term) {
        return DBEResources.ICON_NET;
    }

    public static Icon getFolderIcon() {
        return DBEResources.ICON_FOLDER;
    }

    public static Icon getIconForDbObject(DbObject dbo) {
        Icon icon;
        if (dbo instanceof Device) {
            return NodeIcons.getIconForDevice((Device)dbo);
        }
        if (dbo instanceof DeviceTemplate) {
            return NodeIcons.getIconForTemplate((DeviceTemplate)dbo);
        }
        if (dbo instanceof Net) {
            return NodeIcons.getIconForNet((Net)dbo);
        }
        if (dbo instanceof PinInstance) {
            return DBEResources.ICON_PIN;
        }
        if (dbo instanceof PinTemplate) {
            return NodeIcons.getIconForPinTemplate((PinTemplate)dbo);
        }
        if (dbo instanceof Substrate) {
            return NodeIcons.getIconForSubstrate((Substrate)dbo);
        }
        if (dbo instanceof Layer) {
            return UIUtil.getScaledIcon((Icon)OrbitIcons.LAYERS, (int)16, (int)16);
        }
        if (dbo instanceof Bundle) {
            return UIUtil.getScaledIcon((Icon)DBEResources.ICON_BUNDLE, (int)16, (int)16);
        }
        if (dbo instanceof LayerShape && (icon = UIManager.getIcon("CDNS.shapeIcon")) != null) {
            return icon;
        }
        if (dbo instanceof Term) {
            return NodeIcons.getIconForTerm((Term)dbo);
        }
        if (dbo instanceof Wire && (icon = UIManager.getIcon("CDNS.wireNarrowIcon")) != null) {
            return icon;
        }
        return DBEResources.ICON_DBOBJ;
    }

    public static class ActionEnableShowDeviceDirection
    extends AbstractAction {
        private Design mDesign;

        public ActionEnableShowDeviceDirection(Design design) {
            super("Show Device Direction");
            this.mDesign = design;
            this.putValue("SwingSelectedKey", this.isSelected());
        }

        protected boolean isSelected() {
            return NodeIcons.isShowDeviceDirection(this.mDesign);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OrbitIO.getCurDesign() == null) {
                return;
            }
            NodeIcons.setShowDeviceDirection(!this.isSelected());
            DbExplorerPanel.refreshAll();
        }
    }

    public static class ActionEnableShowContactAttribute
    extends AbstractAction {
        private Design mDesign;

        public ActionEnableShowContactAttribute(Design design) {
            super("Show Contact Attribute");
            this.mDesign = design;
            this.putValue("SwingSelectedKey", this.isSelected());
        }

        protected boolean isSelected() {
            return NodeIcons.isShowContactAttribute(this.mDesign);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OrbitIO.getCurDesign() == null) {
                return;
            }
            NodeIcons.setShowContactAttribute(!this.isSelected());
            DbExplorerPanel.refreshAll();
        }
    }

    public static class ActionEnableShowBumpDirection
    extends AbstractAction {
        private Design mDesign;

        public ActionEnableShowBumpDirection(Design design) {
            super("Show Bump Direction");
            this.mDesign = design;
            this.putValue("SwingSelectedKey", this.isSelected());
        }

        protected boolean isSelected() {
            return NodeIcons.isShowBumpDirection(this.mDesign);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OrbitIO.getCurDesign() == null) {
                return;
            }
            NodeIcons.setShowBumpDirection(!this.isSelected());
            DbExplorerPanel.refreshAll();
        }
    }
}

