/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.ui.AActionGroup;
import com.sigrity.orbit.NetFilters;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitUIMisc;
import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.AbstractAction;

public class NodeOptions {
    static final String SECTION_EXPLORER = "DbExplorerPanel";
    static final String EXPLORER_GROUP_INTERFACE = "GroupByInterface";
    static final String EXPLORER_GROUP_POWER_SIGNAL = "GroupByPowerSignal";
    static final String EXPLORER_GROUP_UNPLACED = "GroupByUnplaced";
    static final String EXPLORER_NET_SORT_POLICY = "NetSortPolicy";
    static final String EXPLORER_GROUP_PIN_BY_TYPE = "GroupPinByType";
    static final String EXPLORER_GROUP_DEVICE_TYPE = "GroupDeviceType";
    static final String EXPLORER_DISPLAY_LAYER_TYPE = "DisplayLayerType";
    private static final Layer.LayerType[] DFLT_DISPLAY_LAYERS = new Layer.LayerType[]{Layer.LayerType.Unknown, Layer.LayerType.Artwork, Layer.LayerType.Cut, Layer.LayerType.Jumper, Layer.LayerType.Mixed, Layer.LayerType.Overlap, Layer.LayerType.Power, Layer.LayerType.Route, Layer.LayerType.Signal};
    protected static DeviceTemplate.NetFilter sDefaultNetFilter = OrbitIO.getOrbitIO() != null ? OrbitIO.getOrbitIO().getDefaultNetFilter() : NetFilters.ALL;
    protected static DeviceTemplate.NetFilter mNetFilter = NodeOptions.getDefaultNetFilter();
    protected static boolean mGroupByInterface = (Boolean)Settings.get((String)"DbExplorerPanel", (String)"GroupByInterface", (Object)false);
    protected static boolean mGroupByPowerSignal = (Boolean)Settings.get((String)"DbExplorerPanel", (String)"GroupByPowerSignal", (Object)true);
    protected static SortType mSortNet = (SortType)((Object)Settings.get((String)"DbExplorerPanel", (String)"NetSortPolicy", (Object)((Object)SortType.NAME)));
    protected static boolean mGroupPinByType = (Boolean)Settings.get((String)"DbExplorerPanel", (String)"GroupPinByType", (Object)false);
    protected static Set<DeviceTemplate.Type> mDeviceGroupTypes = (Set)Settings.get((String)"DbExplorerPanel", (String)"GroupDeviceType", (Object)AUtil.hashSet((Object[])OrbitUIMisc.GroupDeviceTemplateTypes));
    protected static boolean mGroupByUnplaced = (Boolean)Settings.get((String)"DbExplorerPanel", (String)"GroupByUnplaced", (Object)false);
    protected static Set<Layer.LayerType> mDisplayLayerTypes = (Set)Settings.get((String)"DbExplorerPanel", (String)"DisplayLayerType", (Object)AUtil.hashSet((Object[])DFLT_DISPLAY_LAYERS));

    public static void setGroupNetByInterface(boolean enable) {
        mGroupByInterface = enable;
        Settings.set((String)SECTION_EXPLORER, (String)EXPLORER_GROUP_INTERFACE, (Object)enable);
        Settings.save((String)SECTION_EXPLORER);
    }

    public static void setGroupNetByPowerSignal(boolean enable) {
        mGroupByPowerSignal = enable;
        Settings.set((String)SECTION_EXPLORER, (String)EXPLORER_GROUP_POWER_SIGNAL, (Object)enable);
        Settings.save((String)SECTION_EXPLORER);
    }

    public static void setGroupPinByType(boolean enable) {
        mGroupPinByType = enable;
        Settings.set((String)SECTION_EXPLORER, (String)EXPLORER_GROUP_PIN_BY_TYPE, (Object)enable);
        Settings.save((String)SECTION_EXPLORER);
    }

    public static void setGroupUnplacedDevice(boolean enable) {
        mGroupByUnplaced = enable;
        Settings.set((String)SECTION_EXPLORER, (String)EXPLORER_GROUP_UNPLACED, (Object)enable);
        Settings.save((String)SECTION_EXPLORER);
    }

    public static SortType getSortType() {
        return mSortNet;
    }

    public static void setSortType(SortType type) {
        mSortNet = type;
        Settings.set((String)SECTION_EXPLORER, (String)EXPLORER_NET_SORT_POLICY, (Object)((Object)type));
        Settings.save((String)SECTION_EXPLORER);
    }

    public static DeviceTemplate.NetFilter getDefaultNetFilter() {
        return sDefaultNetFilter;
    }

    public static void setDefaultNetFilter(DeviceTemplate.NetFilter nf) {
        sDefaultNetFilter = nf;
    }

    public static DeviceTemplate.NetFilter getNetFilter() {
        return mNetFilter;
    }

    public static void setNetFilter(DeviceTemplate.NetFilter nf) {
        mNetFilter = nf;
    }

    public static boolean getGroupNetByInterface() {
        return mGroupByInterface;
    }

    public static boolean getGroupNetByPowerSignal() {
        return mGroupByPowerSignal;
    }

    public static boolean getGroupPinByType() {
        return mGroupPinByType;
    }

    public static boolean getGroupUnplacedDevice() {
        return mGroupByUnplaced;
    }

    public static void setDeviceGroupTypes(Set<DeviceTemplate.Type> group) {
        mDeviceGroupTypes.clear();
        mDeviceGroupTypes.addAll(group);
        Settings.set((String)SECTION_EXPLORER, (String)EXPLORER_GROUP_DEVICE_TYPE, group);
        Settings.save((String)SECTION_EXPLORER);
    }

    public static Set<DeviceTemplate.Type> getDeviceGroupTypes() {
        return mDeviceGroupTypes;
    }

    public static void setDisplayLayerTypes(Set<Layer.LayerType> displayed) {
        mDisplayLayerTypes.clear();
        mDisplayLayerTypes.addAll(displayed);
        Settings.set((String)SECTION_EXPLORER, (String)EXPLORER_DISPLAY_LAYER_TYPE, mDisplayLayerTypes);
        Settings.save((String)SECTION_EXPLORER);
    }

    public static Set<Layer.LayerType> getDisplayLayerTypes() {
        return mDisplayLayerTypes;
    }

    private static class ActionSortByNumInc
    extends AbstractAction {
        private final Runnable runnable;

        private ActionSortByNumInc(Runnable r) {
            super(SortType.NUM_INC.getName());
            this.runnable = r;
            this.putValue("SwingSelectedKey", mSortNet == SortType.NUM_INC);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NodeOptions.setSortType(SortType.NUM_INC);
            this.runnable.run();
        }
    }

    private static class ActionSortByNumDec
    extends AbstractAction {
        private final Runnable runnable;

        private ActionSortByNumDec(Runnable r) {
            super(SortType.NUM_DEC.getName());
            this.runnable = r;
            this.putValue("SwingSelectedKey", mSortNet == SortType.NUM_DEC);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NodeOptions.setSortType(SortType.NUM_DEC);
            this.runnable.run();
        }
    }

    private static class ActionSortByName
    extends AbstractAction {
        private final Runnable runnable;

        private ActionSortByName(Runnable r) {
            super(SortType.NAME.getName());
            this.runnable = r;
            this.putValue("SwingSelectedKey", mSortNet == SortType.NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NodeOptions.setSortType(SortType.NAME);
            this.runnable.run();
        }
    }

    public static class ActionSortNetMenu
    extends AActionGroup {
        public ActionSortNetMenu(Runnable r) {
            super("Sort Nets");
            this.addAction(new ActionSortByName(r));
            this.addAction(new ActionSortByNumDec(r));
            this.addAction(new ActionSortByNumInc(r));
        }
    }

    private static class ActionGroupPowerSignal
    extends AbstractAction {
        private final Runnable runnable;

        public ActionGroupPowerSignal(Runnable r) {
            super("Power Signal");
            this.putValue("SwingSelectedKey", mGroupByPowerSignal);
            this.runnable = r;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NodeOptions.setGroupNetByPowerSignal(!mGroupByPowerSignal);
            this.runnable.run();
        }
    }

    private static class ActionGroupInterface
    extends AbstractAction {
        private final Runnable runnable;

        public ActionGroupInterface(Runnable r) {
            super("Interface");
            this.putValue("SwingSelectedKey", mGroupByInterface);
            this.runnable = r;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NodeOptions.setGroupNetByInterface(!mGroupByInterface);
            this.runnable.run();
        }
    }

    public static class ActionGroupNetMenu
    extends AActionGroup {
        public ActionGroupNetMenu(Runnable r) {
            super("Group Nets");
            this.addAction(new ActionGroupInterface(r));
            this.addAction(new ActionGroupPowerSignal(r));
        }
    }

    private static class ActionSelectNetFilter
    extends AbstractAction {
        private final Consumer<DeviceTemplate.NetFilter> consumer;
        private final DeviceTemplate.NetFilter nf;

        public ActionSelectNetFilter(DeviceTemplate.NetFilter nf, Consumer<DeviceTemplate.NetFilter> consumer) {
            super(nf.getName());
            this.putValue("ShortDescription", nf.getDescription());
            this.putValue("SwingSelectedKey", NetFilters.equals((DeviceTemplate.NetFilter)mNetFilter, (DeviceTemplate.NetFilter)nf));
            this.consumer = consumer;
            this.nf = nf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.consumer.accept(this.nf);
            NodeOptions.setNetFilter(this.nf);
        }
    }

    public static class ActionFilterNetMenu
    extends AActionGroup {
        public ActionFilterNetMenu(Runnable r) {
            super("Filter Nets");
            for (DeviceTemplate.NetFilter nf : OrbitIO.getOrbitIO().getNetFilters()) {
                this.addAction(new ActionSelectNetFilter(nf, e -> r.run()));
            }
        }
    }

    public static enum SortType {
        NAME("Name", ""),
        NUM_INC("#Children \u2193", ""),
        NUM_DEC("#Children \u2191", "");

        final String mDesc;
        final String mName;

        private SortType(String name, String desc) {
            this.mDesc = desc;
            this.mName = name;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDesc;
        }
    }
}

