/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.ATreeSearcher;
import com.sigrity.acl.ui.ATreeUtil;
import com.sigrity.acl.ui.AclResources;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;

public class SearchPanel
extends JPanel {
    protected ATreeSearcher.UI mTreeSearchUI = null;
    protected JPopupMenu mMenu;

    public SearchPanel(JTree tree, JPopupMenu menu) {
        this.mMenu = menu;
        this.mMenu.add(new JMenuItem(new ActionPatternHelp()));
        this.setTree(tree);
        String ACTION_CLOSE = "CloseControl";
        this.getActionMap().put("CloseControl", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPanel.this.setVisible(false);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "CloseControl");
    }

    public void setTree(JTree tree) {
        this.removeAll();
        GridBagManager l = GridBagManager.layout((Container)this);
        ATreeUtil.TreePathFilter filter = p -> {
            Object obj = p.getLastPathComponent();
            return !(obj instanceof DbExplorerPanel.DbRelatedObjectsNode);
        };
        this.mTreeSearchUI = new ATreeSearcher.UI(tree, tree.getSelectionPath(), ATreeSearcher.DefaultNodeToString, filter);
        this.mTreeSearchUI.setButtonIcons(OrbitIcons.SRCH_PREV, OrbitIcons.SRCH_PREV_X, OrbitIcons.SRCH_NEXT, OrbitIcons.SRCH_NEXT_X);
        this.mTreeSearchUI.setButtonText(null, null);
        this.mTreeSearchUI.getSearcher().setIteration(ATreeSearcher.BREADTHFIRST);
        this.mTreeSearchUI.setCancelable(true);
        l.add((Component)this.mTreeSearchUI, (GridBagConstraints)GridBagManager.FILLX.noInsets());
        l.push((GridBagConstraints)GridBagManager.RIGHT);
        JButton btnClose = (JButton)l.add((Component)new JButton(), (GridBagConstraints)GridBagManager.RIGHT.insets(0, 0, 0, 1));
        btnClose.setIcon(AFloatWindow.ICON_CLOSE);
        btnClose.setMargin(new Insets(0, 0, 0, 0));
        btnClose.addActionListener(e -> this.setVisible(false));
        btnClose.setSize(16, 16);
        l.newline();
        final JButton btnMenu = new JButton();
        btnMenu.setAction(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
                ws.beautify(SearchPanel.this.mMenu);
                SearchPanel.this.mMenu.show(btnMenu, 0, btnMenu.getHeight());
            }
        });
        l.add((Component)btnMenu, (GridBagConstraints)GridBagManager.RIGHT.insets(0, 0, 0, 1));
        l.pop();
        UIUtil.makeToolBarButton((AbstractButton)btnClose);
        UIUtil.makeToolBarButton((AbstractButton)btnMenu);
    }

    public ATreeSearcher.UI getTreeSearchUI() {
        return this.mTreeSearchUI;
    }

    @Override
    public void requestFocus() {
        SearchPanel nf;
        Component curFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (curFocus != null && (nf = (SearchPanel)UIUtil.getAncestorOfType((Component)curFocus, SearchPanel.class)) != null && nf == this) {
            return;
        }
        this.mTreeSearchUI.requestFocus();
    }

    public static class ActionPatternHelp
    extends AbstractAction {
        public ActionPatternHelp() {
            super("Help", AclResources.ICON_UNKNOWN);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ABrowserControl.displayURL((String)"http://docs.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html#sum");
        }
    }
}

