/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.ATreeJumper;
import com.sigrity.acl.ui.ATreeSearcher;
import com.sigrity.acl.ui.ATreeUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;

public class SearchSelectedPanel
extends JPanel {
    protected ATreeJumper.UI<HierInst<DbObject>> mTreeSearchUI = null;

    public SearchSelectedPanel(JTree tree) {
        this.setTree(tree);
        String ACTION_CLOSE = "CloseControl";
        this.getActionMap().put("CloseControl", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchSelectedPanel.this.setVisible(false);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "CloseControl");
    }

    public void setTree(JTree tree) {
        this.removeAll();
        GridBagManager l = GridBagManager.layout((Container)this);
        ATreeUtil.TreePathFilter filter = p -> {
            Object obj = p.getLastPathComponent();
            return !(obj instanceof DbExplorerPanel.DbRelatedObjectsNode);
        };
        ATreeJumper.TreeNodeMapper<HierInst<DbObject>> mapper = new ATreeJumper.TreeNodeMapper<HierInst<DbObject>>(){

            public HierInst<DbObject> map(Object node) {
                if (node instanceof DbExplorerPanel.DbObjNode) {
                    return ((DbExplorerPanel.DbObjNode)node).getHierInst();
                }
                return null;
            }
        };
        Design design = Design.getDesign((Db)OrbitIO.getCurDb());
        final Selection selection = design == null ? null : design.getCurSelection();
        ATreeJumper.JumpMatcher<HierInst<DbObject>> matcher = new ATreeJumper.JumpMatcher<HierInst<DbObject>>(){

            public boolean match(HierInst<DbObject> obj) {
                if (obj == null || selection == null) {
                    return false;
                }
                if (obj.getDbObject() instanceof PinTemplate) {
                    PinTemplate pinT = (PinTemplate)obj.getDbObject();
                    if (selection.contains(obj.getPath(), (DbObject)PinInstance.getPinInstance((Device)obj.getPath().getDevice(), (PinTemplate)pinT))) {
                        return true;
                    }
                }
                return selection.contains(obj.getPath(), obj.getDbObject());
            }
        };
        this.mTreeSearchUI = new ATreeJumper.UI(tree, (ATreeJumper.TreeNodeMapper)mapper, (ATreeJumper.JumpMatcher)matcher, filter);
        this.mTreeSearchUI.setButtonIcons(OrbitIcons.SRCH_PREV, OrbitIcons.SRCH_PREV_X, OrbitIcons.SRCH_NEXT, OrbitIcons.SRCH_NEXT_X);
        this.mTreeSearchUI.setButtonText(null, null);
        this.mTreeSearchUI.getSearcher().setIteration(ATreeSearcher.BREADTHFIRST);
        this.mTreeSearchUI.setCancelable(true);
        l.add(this.mTreeSearchUI, (GridBagConstraints)GridBagManager.FILLX.noInsets());
        JButton btnClose = (JButton)l.add((Component)new JButton(), (GridBagConstraints)GridBagManager.RIGHT.insets(0, 0, 0, 1));
        btnClose.setIcon(AFloatWindow.ICON_CLOSE);
        btnClose.setMargin(new Insets(0, 0, 0, 0));
        btnClose.addActionListener(e -> this.setVisible(false));
        btnClose.setSize(16, 16);
        UIUtil.makeToolBarButton((AbstractButton)btnClose);
    }

    public ATreeJumper.UI<HierInst<DbObject>> getTreeSearchUI() {
        return this.mTreeSearchUI;
    }

    @Override
    public void requestFocus() {
        SearchSelectedPanel nf;
        Component curFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (curFocus != null && (nf = (SearchSelectedPanel)UIUtil.getAncestorOfType((Component)curFocus, SearchSelectedPanel.class)) != null && nf == this) {
            return;
        }
        this.mTreeSearchUI.requestFocus();
    }
}

