/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer.tree;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.DbObjectDetailsUI;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.tree.ContextMenuSupport;
import com.sigrity.tools.dbexplorer.tree.DbTreeModel;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class DbTreeNode
implements TreeNode,
ContextMenuSupport,
Comparable<Object> {
    protected DbTreeNode mParent = null;
    protected DbTreeModel mModel;

    public DbTreeNode(DbTreeNode parent) {
        this.mParent = parent;
        if (parent != null) {
            this.mModel = parent.getModel();
        }
    }

    public DbTreeNode(DbTreeModel model) {
        this.mModel = model;
    }

    public TreePath getTreePath() {
        LinkedList<DbTreeNode> path = new LinkedList<DbTreeNode>();
        for (DbTreeNode cur = this; cur != null; cur = cur.getParent()) {
            path.add(0, cur);
        }
        Object[] nodes = path.toArray(new DbTreeNode[0]);
        return new TreePath(nodes);
    }

    public void setParent(DbTreeNode parent) {
        this.mParent = parent;
        this.mModel = parent.getModel();
    }

    public DbTreeModel getModel() {
        assert (this.mModel != null);
        return this.mModel;
    }

    public void setModel(DbTreeModel dbtm) {
        this.mModel = dbtm;
    }

    @Override
    public DbTreeNode getParent() {
        return this.mParent;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public abstract void render(DbExplorerPanel.DbTreeCellRenderer var1);

    public abstract boolean equiv(DbTreeNode var1);

    public JComponent getDetailsView() {
        return null;
    }

    public void dispose() {
    }

    @Override
    public void populateMenuItems(List<JMenuItem> items) {
        if (this instanceof DbExplorerPanel.DbObjNode || this.getDetailsView() != null) {
            items.add(new JMenuItem(new MenuItemShowDetails()));
        }
    }

    @Override
    public int compareTo(Object o) {
        if (o.getClass().isInstance(this) || this.getClass().isInstance(o)) {
            String otherText = o instanceof DbTreeNode ? ((DbTreeNode)o).getText() : o.toString();
            AAlphaNumComp ac = AAlphaNumComp.get();
            return ac.compare((Object)this.getText(), (Object)otherText);
        }
        Integer myOrder = DbExplorerPanel.getNodeClassOrderTable().get(this.getClass());
        Integer otherOrder = DbExplorerPanel.getNodeClassOrderTable().get(o.getClass());
        if (myOrder != null && otherOrder != null) {
            return myOrder - otherOrder;
        }
        String str = this.toString();
        if (str == null) {
            return -1;
        }
        return str.compareTo(o.toString());
    }

    public String toString() {
        return this.getText();
    }

    public abstract String getText();

    public String getTooltipText() {
        return null;
    }

    protected class MenuItemShowDetails
    extends AbstractAction {
        public MenuItemShowDetails() {
            super("Details...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DbTreeNode.this instanceof DbExplorerPanel.DbObjNode) {
                DbExplorerPanel.DbObjNode node = (DbExplorerPanel.DbObjNode)DbTreeNode.this;
                Object dbo = ((DbExplorerPanel.DbObjNode)DbTreeNode.this).getDbObj();
                DbObjectDetailsUI.show(OrbitIO.getMainWindow(), dbo, node.getDevicePath(), OrbitIO.getCurView());
                return;
            }
            JComponent c = DbTreeNode.this.getDetailsView();
            if (!(c instanceof DbExplorerPanel.HTMLViewer)) {
                return;
            }
            DbExplorerPanel.HTMLViewer hv = (DbExplorerPanel.HTMLViewer)c;
            String html = hv.getText();
            final AFloatWindow fw = AFloatWindow.createInstance(AApp.getApp().getMainWin());
            fw.setRecallBounds(false);
            String title = "Details";
            fw.setTitle(title);
            fw.setHtmlContents(html);
            final DbExplorerPanel.DALinkHandler lh = new DbExplorerPanel.DALinkHandler(fw, DbTreeNode.this);
            fw.addLinkHandler(lh);
            fw.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    fw.removeLinkHandler(lh);
                }
            });
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension max = new Dimension(screen.width / 3, screen.height * 4 / 5);
            Dimension cur = fw.getSize();
            if (cur.width > max.width || cur.height > max.height) {
                fw.setSize(Math.min(cur.width, max.width), Math.min(cur.height, max.height));
            }
            UIUtil.verifyWindowOnScreen((Window)((Object)fw));
            fw.setVisible(true);
        }
    }
}

