/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.tools.dbexplorer.tree;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.tools.dbexplorer.tree.DbTreeModel;
import com.sigrity.tools.dbexplorer.tree.DbTreeNode;
import com.sigrity.tools.dbexplorer.tree.ExceptionNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.tree.TreeNode;

public abstract class JitDbTreeNode
extends DbTreeNode {
    protected List<DbTreeNode> mChildren = null;
    protected boolean mChildrenValid = false;
    protected boolean mSortChildren = true;

    public JitDbTreeNode(DbTreeNode parent) {
        super(parent);
    }

    public JitDbTreeNode(DbTreeModel model) {
        super(model);
    }

    public abstract void populateChildren();

    public boolean isChildrenValid() {
        return this.mChildrenValid;
    }

    public void setChildren(List<? extends DbTreeNode> children) {
        this.mChildren = new ArrayList<DbTreeNode>(children);
        this.mChildrenValid = true;
        this.sortChildren();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.populateChildrenAsNeeded();
        if (this.mChildren == null || childIndex < 0 || childIndex >= this.mChildren.size()) {
            return null;
        }
        return this.mChildren.get(childIndex);
    }

    @Override
    public int getChildCount() {
        this.populateChildrenAsNeeded();
        if (this.mChildren == null) {
            return 0;
        }
        return this.mChildren.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        this.populateChildrenAsNeeded();
        if (this.mChildren == null) {
            return 0;
        }
        return this.mChildren.indexOf(node);
    }

    public Enumeration<DbTreeNode> children() {
        this.populateChildrenAsNeeded();
        if (this.mChildren == null) {
            return null;
        }
        return AUtil.getEnumeration(this.mChildren.iterator());
    }

    private void sortChildren() {
        if (this.mChildren != null && this.mSortChildren) {
            try {
                this.mChildren = new ArrayList<DbTreeNode>(this.mChildren.parallelStream().sorted().collect(Collectors.toList()));
            }
            catch (Exception e) {
                ALog.logWarn((Throwable)e, (String)"Sorting DbTreeNode children failed, nodes under '%s' are unsorted.", (Object[])new Object[]{this});
            }
        }
    }

    protected void populateChildrenAsNeeded() {
        if (!this.mChildrenValid) {
            try {
                this.populateChildren();
            }
            catch (Exception e) {
                ALog.logWarn((Throwable)e, (String)"Populate DbTreeNode children failed, nodes under '%s' are reused.", (Object[])new Object[]{this});
                ArrayList<DbTreeNode> children = new ArrayList<DbTreeNode>(this.mChildren);
                ExceptionNode n = new ExceptionNode(this, e);
                children.add(n);
                this.mChildren = children;
            }
            this.sortChildren();
            this.mChildrenValid = true;
        }
    }

    public void invalidateChildren() {
        this.clearChildren();
        DbTreeModel tm = this.getModel();
        tm.fireTreeStructureChanged(this, this.getTreePath().getPath(), new int[0], new Object[0]);
    }

    @Override
    public void dispose() {
        this.clearChildren();
    }

    protected void clearChildren() {
        if (this.mChildrenValid && this.mChildren != null) {
            for (DbTreeNode n : this.mChildren) {
                n.dispose();
            }
        }
        this.mChildren = null;
        this.mChildrenValid = false;
    }
}

