/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.zexample;

import com.sigrity.acl.ALog;
import com.sigrity.acl.jni.ANativeLibrary;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class NativePlugin
extends ANativeLibrary {
    public String getNativeLibName() {
        return "JniNativeExample";
    }

    public native int exampleNativeMethod(String var1, int var2, double var3, Color var5);

    public NativePlugin() {
        OrbitIO oio = OrbitIO.getApp();
        if (oio == null) {
            return;
        }
        OrbitGuiWS ws = oio.getWorkspace();
        JMenuBar mainMenuBar = ws.getMainFrame().getJMenuBar();
        JMenu menu = mainMenuBar.getMenu(1);
        JMenuItem menuItem = menu.add("Test NativePlugin");
        UIUtil.setUniqueMnemonic((JMenu)menu, (AbstractButton)menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = NativePlugin.this.exampleNativeMethod("A Java String", 42, Math.PI, Color.BLUE);
                ALog.logInfo((String)"Result in Java: %d", (Object[])new Object[]{result});
            }
        });
    }

    public static void main(String[] args) {
        NativePlugin npi = new NativePlugin();
        int result = npi.exampleNativeMethod("A String from Java", 8, Math.E, Color.RED);
        ALog.logInfo((String)"Result in Java: %d", (Object[])new Object[]{result});
        npi.unload();
    }

    static {
        if (OrbitIO.getApp() != null) {
            new NativePlugin();
        }
    }
}

