/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.zexample;

import com.sigrity.acl.ALog;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SendMail {
    protected static String fromAddr = "someone@example.com";
    protected static String fromName = "Someone";
    protected static Properties mailSessionProps = null;
    protected static Authenticator authenticator = null;

    public static void setSessionProperties(Properties props) {
        mailSessionProps = props;
    }

    public static void setAuthInfo(final String user, final String pwd) {
        authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, pwd);
            }
        };
    }

    public static void setFrom(String name, String addr) {
        fromName = name;
        fromAddr = addr;
    }

    public static void send(String to, String subject, String body) {
        SendMail.send(to, subject, body, null, false);
    }

    public static boolean send(String to, String subject, String body, String fileName, boolean suppressErrors) {
        if (authenticator == null) {
            ALog.logError((String)"Attempt to call SendMail.send() before calling setAuthInfo(), send aborted.");
            return false;
        }
        Session session = Session.getInstance((Properties)mailSessionProps, (Authenticator)authenticator);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(fromAddr, fromName));
            msg.setRecipients(Message.RecipientType.TO, to);
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            if (fileName == null) {
                msg.setText(body);
            } else {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setContent((Object)("<h1>" + body + "</h1>"), "text/html");
                MimeBodyPart attachFilePart = new MimeBodyPart();
                File file = new File(fileName);
                try {
                    attachFilePart.attachFile(file);
                    attachFilePart.setFileName(file.getName());
                }
                catch (IOException e) {
                    ALog.logError((String)"Failed to attach file '%s' to email.", (Object[])new Object[]{fileName});
                    return false;
                }
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)textPart);
                mp.addBodyPart((BodyPart)attachFilePart);
                msg.setContent((Multipart)mp);
            }
            Transport.send((Message)msg);
        }
        catch (MessagingException e1) {
            if (!suppressErrors) {
                ALog.logError((Throwable)e1, (String)"Error sending mail message.", (Object[])new Object[0]);
            }
            return false;
        }
        catch (UnsupportedEncodingException e) {
            if (!suppressErrors) {
                ALog.logError((Throwable)e, (String)"Error sending mail message.", (Object[])new Object[0]);
            }
            return false;
        }
        if (!suppressErrors) {
            ALog.logInfo((String)"Mail message sent.");
        }
        return true;
    }

    static {
        mailSessionProps = new Properties();
        mailSessionProps.put("mail.transport.protocol", "smtp");
        mailSessionProps.put("mail.host", "smtp.gmail.com");
        mailSessionProps.put("mail.smtp.auth", "true");
        mailSessionProps.put("mail.smtp.port", "465");
        mailSessionProps.put("mail.smtp.socketFactory.port", "465");
        mailSessionProps.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        mailSessionProps.put("mail.smtp.socketFactory.fallback", "false");
        mailSessionProps.put("mail.smtp.quitwait", "false");
    }
}

