<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes" />

<xsl:template match="/DbStructure">
	<html>
	<style type="text/css">
		body {
			margin: 4px 4px 4px 4px;
			font-family: sans-serif;
		}

		h3 {
			text-decoration:underline;
			margin-bottom: 0px;
		}

		.class {
			margin-top: 8px;
			margin-bottom: 4px;
		}

		.clsName {
			font-weight: bold;
		}

		.clsDetails {
			margin-left: 8px;
		}

		.fieldsHdr {
			text-decoration:underline;
			font-weight: bold;
		}

		.fieldName {
			font-weight: bold;
		}

		.relName {
			font-weight: bold;
		}
		
		.derivedClassesHdr {
			margin-top: 4px;
			text-decoration:underline;
			font-weight: bold;
		}
	</style>
	<body>
		
	<h1>Database Structure</h1>
	<div class='fileVer'>Version: <xsl:value-of select="@version" /></div>
	<div class='filePath'>File: <xsl:value-of select="@file" /></div>
	
	<h2>Classes</h2>
	<xsl:apply-templates select="Classes/Class"/>
	
	<h2>Relations</h2>
	<xsl:apply-templates select="Relations/Relation"/>

	</body>
	</html>
</xsl:template>

<xsl:template match="Class">
	<div class="class">
		<span class="clsName"><xsl:value-of select="@name" /></span>
		<span class="clsType"> (<xsl:value-of select="@type" />)</span>
		<xsl:if test="@singleton">
			<span class="clsSingleton">; singleton</span>
		</xsl:if>
		<xsl:if test="@super">
			<span class="clsSuper">; derived from: <xsl:value-of select="@super"/></span>
		</xsl:if>
		<xsl:if test="@context">
			<span class="clsContext">; context: <xsl:value-of select="@context"/></span>
		</xsl:if>
	</div>
	<div class="clsDetails">
		<span class="fieldsHdr">Fields</span>
		<xsl:apply-templates select="Field" />

		<xsl:apply-templates select="DerivedClasses" />
	</div>
</xsl:template>

<xsl:template match="DerivedClasses">
	<div class="derivedClassesHdr">Derived Classes</div>
	<xsl:apply-templates select="DerivedClass"/>
</xsl:template>

<xsl:template match="DerivedClass">
	<div class="derivedClass">
		<span class="derivedClassName"><xsl:value-of select="@name"/></span>
	</div>
</xsl:template>

<xsl:template match="Field">
	<div class="field">
		<span class="fieldName"><xsl:value-of select="@name" /></span>
		(<xsl:for-each select="@*[name(.)!='name']">
			<span class="fieldAttrLbl"><xsl:value-of select="name()"/>: </span>
			<span class="fieldAttrVal"><xsl:value-of select="."/></span>
			<xsl:if test="position() != last()">
				<xsl:text>; </xsl:text>
			</xsl:if>
		</xsl:for-each>)
	</div>
</xsl:template>

<xsl:template match="Relation">
	<div class="relation">
		<span class="relName"><xsl:value-of select="@name" /></span>
		(<xsl:for-each select="@*[name(.)!='name']">
			<span class="fieldAttrLbl"><xsl:value-of select="name()"/>: </span>
			<span class="fieldAttrVal"><xsl:value-of select="."/></span>
			<xsl:if test="position() != last()">
				<xsl:text>; </xsl:text>
			</xsl:if>
		</xsl:for-each>)
	</div>
</xsl:template>

</xsl:stylesheet>
