/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.provider.DurationField;
import com.jrockit.mc.flightrecorder.provider.EndTimeField;
import com.jrockit.mc.flightrecorder.provider.EventStorage;
import com.jrockit.mc.flightrecorder.provider.EventTypeField;
import com.jrockit.mc.flightrecorder.provider.EventTypePathField;
import com.jrockit.mc.flightrecorder.provider.ProducerField;
import com.jrockit.mc.flightrecorder.provider.ProducerURIField;
import com.jrockit.mc.flightrecorder.provider.StartTimeField;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public final class EventType
implements IEventType {
    private final Integer m_identifier;
    private String m_path;
    private final IProducer m_producer;
    private final LinkedHashMap<String, IField> m_fields = new LinkedHashMap();
    private String m_name = "";
    private String m_description = "";
    private Color m_color = Color.RED;
    private int m_bitField = 0;
    private final ArrayList<EventStorage> m_storages = new ArrayList();
    private Integer threadValueIndex;
    private boolean hasStartTime;

    EventType(IProducer producer, int id) {
        this.m_identifier = id;
        this.m_producer = producer;
        this.addField(new StartTimeField(this));
        this.addField(new EndTimeField(this));
        this.addField(new DurationField(this));
        this.addField(new ProducerField(this));
        this.addField(new ProducerURIField(this));
        this.addField(new EventTypeField(this));
        this.addField(new EventTypePathField(this));
    }

    public List<EventStorage> getStorages() {
        return this.m_storages;
    }

    public void addField(IField field) {
        this.m_fields.put(field.getIdentifier(), field);
    }

    @Override
    public Color getColor() {
        return this.m_color;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public Integer getId() {
        return this.m_identifier;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    @Override
    public IProducer getProducer() {
        return this.m_producer;
    }

    @Override
    public IField getField(String key) {
        return this.m_fields.get(key);
    }

    @Override
    public int getBitField() {
        return this.m_bitField;
    }

    @Override
    public void setBitField(int bitSet) {
        this.m_bitField = bitSet;
    }

    @Override
    public Collection<IField> getFields() {
        return this.m_fields.values();
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void addEventStorage(EventStorage storage) {
        this.m_storages.add(storage);
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Collection<String> getFieldIdentifiers() {
        return this.m_fields.keySet();
    }

    public Integer getThreadValueIndex() {
        return this.threadValueIndex;
    }

    public void setThreadValueIndex(int threadValueIndex) {
        this.threadValueIndex = threadValueIndex;
    }

    public boolean hasStartTime() {
        return this.hasStartTime;
    }

    public void setHasStartTime(boolean hasStartTime) {
        this.hasStartTime = hasStartTime;
    }
}

