/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.setup.p2.util.P2TaskUISevices;
import org.eclipse.oomph.setup.ui.AbstractConfirmDialog;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2TaskUIServicesPrompter
extends P2TaskUISevices {
    public static Action getActionPreference() {
        OomphPlugin.Preference preference = SetupUIPlugin.INSTANCE.getInstancePreference("p2.startup.tasks");
        String value = preference.get(Action.PROMPT.name());
        return Action.valueOf(value);
    }

    public static void setActionPreference(Action action) {
        OomphPlugin.Preference preference = SetupUIPlugin.INSTANCE.getInstancePreference("p2.startup.tasks");
        preference.set(action.name());
    }

    public boolean handleUnsatisfiedRequirements(Set<Requirement> unsatisifiedRequirements, Set<IInstallableUnit> availableIUs) {
        Action action = P2TaskUIServicesPrompter.getActionPreference();
        switch (action) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
        }
        return this.promptUnsatisifiedRequirements(unsatisifiedRequirements, availableIUs);
    }

    public boolean promptUnsatisifiedRequirements(final Set<Requirement> unsatisifiedRequirements, final Set<IInstallableUnit> availableIUs) {
        final boolean[] result = new boolean[]{true};
        UIUtil.syncExec((Runnable)new Runnable(){

            public void run() {
                Shell shell = P2TaskUIServicesPrompter.this.getShell();
                if (shell != null) {
                    boolean install;
                    UnsatisifiedRequirementsPrompter unsatisifiedRequirementsPrompter = new UnsatisifiedRequirementsPrompter(shell, unsatisifiedRequirements, availableIUs);
                    int open = unsatisifiedRequirementsPrompter.open();
                    result[0] = install = open == 0;
                    if (unsatisifiedRequirementsPrompter.isRemember()) {
                        P2TaskUIServicesPrompter.setActionPreference(install ? Action.ALWAYS : Action.NEVER);
                    }
                }
            }
        });
        return result[0];
    }

    protected Shell getShell() {
        try {
            return UIUtil.getShell();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        PROMPT,
        ALWAYS,
        NEVER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnsatisifiedRequirementsPrompter
    extends AbstractConfirmDialog {
        private final Set<Requirement> unsatisifiedRequirements;
        private final Set<IInstallableUnit> availableIUs;

        public UnsatisifiedRequirementsPrompter(Shell parentShell, Set<Requirement> unsatisifiedRequirements, Set<IInstallableUnit> availableIUs) {
            super(parentShell, "Requirements Update", 700, 500, "Remember my decision");
            this.unsatisifiedRequirements = unsatisifiedRequirements;
            this.availableIUs = availableIUs;
        }

        protected String getDefaultMessage() {
            return "The installation does not satisfy the requirements list below.";
        }

        protected String getShellText() {
            return "Eclipse Update";
        }

        protected void createUI(Composite parent) {
            TreeViewer treeViewer = new TreeViewer(parent, 768);
            treeViewer.getTree().setLayoutData((Object)new GridData(1808));
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory);
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
            treeViewer.setContentProvider((IContentProvider)contentProvider);
            treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            ItemProvider input = new ItemProvider();
            EList inputChildren = input.getChildren();
            for (Requirement requirement : this.unsatisifiedRequirements) {
                if (!"org.eclipse.equinox.p2.iu".equals(requirement.getNamespace())) continue;
                String id = requirement.getName();
                ItemProvider requirementItem = new ItemProvider(labelProvider.getText((Object)requirement), (Object)labelProvider.getImage((Object)requirement));
                EList requirementChildren = requirementItem.getChildren();
                inputChildren.add((Object)requirementItem);
                for (IInstallableUnit iu : this.availableIUs) {
                    if (!id.equals(iu.getId())) continue;
                    Requirement fakeIU = P2Factory.eINSTANCE.createRequirement(id);
                    Version version = iu.getVersion();
                    String label = String.valueOf(labelProvider.getText((Object)fakeIU)) + " " + version;
                    ItemProvider iuItem = new ItemProvider(label, (Object)labelProvider.getImage((Object)fakeIU));
                    requirementChildren.add((Object)iuItem);
                }
            }
            treeViewer.setInput((Object)input);
        }

        @Override
        protected void doCreateButtons(Composite parent) {
            this.createButton(parent, 0, "Install", false);
            this.createButton(parent, 1, "Skip", true);
        }
    }
}

