/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.testsrunner.internal.model.TestItem;
import org.eclipse.cdt.testsrunner.internal.model.TestMessage;
import org.eclipse.cdt.testsrunner.internal.model.TestSuite;
import org.eclipse.cdt.testsrunner.model.IModelVisitor;
import org.eclipse.cdt.testsrunner.model.ITestCase;
import org.eclipse.cdt.testsrunner.model.ITestItem;

public class TestCase
extends TestItem
implements ITestCase {
    private ITestItem.Status status;
    private int testingTime;
    private List<TestMessage> testMessages = new ArrayList<TestMessage>();

    public TestCase(String name, TestSuite parent) {
        super(name, parent);
        this.reset();
    }

    @Override
    public ITestItem.Status getStatus() {
        return this.status;
    }

    @Override
    public int getTestingTime() {
        return this.testingTime;
    }

    public TestMessage[] getTestMessages() {
        return this.testMessages.toArray(new TestMessage[this.testMessages.size()]);
    }

    @Override
    public void visit(IModelVisitor visitor) {
        visitor.visit(this);
        for (TestMessage message : this.testMessages) {
            message.visit(visitor);
        }
        visitor.leave(this);
    }

    public void reset() {
        this.status = ITestItem.Status.Skipped;
        this.testingTime = 0;
        this.testMessages.clear();
    }

    public void setStatus(ITestItem.Status status) {
        this.status = status;
    }

    public void setTestingTime(int testingTime) {
        this.testingTime = testingTime;
    }

    public void addTestMessage(TestMessage testMessage) {
        this.testMessages.add(testMessage);
    }
}

