/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.internal.AbstractGrammarRegistryManager;
import org.osgi.service.prefs.BackingStoreException;

public class WorkingCopyGrammarRegistryManager
extends AbstractGrammarRegistryManager {
    private final IGrammarRegistryManager manager;
    private List<IGrammarDefinition> added;
    private List<IGrammarDefinition> removed;

    public WorkingCopyGrammarRegistryManager(IGrammarRegistryManager manager) {
        this.manager = manager;
        this.load();
    }

    private void load() {
        IGrammarDefinition[] definitions;
        IGrammarDefinition[] iGrammarDefinitionArray = definitions = this.manager.getDefinitions();
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<String> injections;
            IGrammarDefinition definition = iGrammarDefinitionArray[n2];
            super.registerGrammarDefinition(definition);
            String scopeName = definition.getScopeName();
            String[] contentTypes = this.manager.getContentTypesForScope(scopeName);
            if (contentTypes != null) {
                String[] stringArray = contentTypes;
                int n3 = contentTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String contentTypeId = stringArray[n4];
                    super.registerContentTypeBinding(contentTypeId, scopeName);
                    ++n4;
                }
            }
            if ((injections = this.manager.getInjections(scopeName)) != null) {
                for (String injectFrom : injections) {
                    super.registerInjection(injectFrom, scopeName);
                }
            }
            ++n2;
        }
    }

    @Override
    public void registerGrammarDefinition(IGrammarDefinition definition) {
        super.registerGrammarDefinition(definition);
        if (this.added == null) {
            this.added = new ArrayList<IGrammarDefinition>();
        }
        this.added.add(definition);
    }

    @Override
    public void unregisterGrammarDefinition(IGrammarDefinition definition) {
        super.unregisterGrammarDefinition(definition);
        if (this.added != null && this.added.contains(definition)) {
            this.added.remove(definition);
        } else {
            if (this.removed == null) {
                this.removed = new ArrayList<IGrammarDefinition>();
            }
            this.removed.add(definition);
        }
    }

    @Override
    public void save() throws BackingStoreException {
        if (this.added != null) {
            for (IGrammarDefinition definition : this.added) {
                this.manager.registerGrammarDefinition(definition);
            }
        }
        if (this.removed != null) {
            for (IGrammarDefinition definition : this.removed) {
                this.manager.unregisterGrammarDefinition(definition);
            }
        }
        if (this.added != null || this.removed != null) {
            this.manager.save();
        }
    }
}

