/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.linuxtools.docker.core.AbstractRegistry;

public class RegistryInfo
extends AbstractRegistry {
    private final String serverAddress;
    private final boolean dockerHubRegistry;

    public RegistryInfo(String serverAddress, boolean dockerHubRegistry) {
        this.serverAddress = serverAddress;
        this.dockerHubRegistry = dockerHubRegistry;
    }

    public String getRegistryId() {
        return "getServerAddress()=" + this.getServerAddress();
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public String getServerHost() {
        try {
            URL serverAddress = new URL(this.getServerAddress());
            String serverHost = String.valueOf(serverAddress.getHost()) + (serverAddress.getPort() != -1 ? ":" + serverAddress.getPort() : "");
            return serverHost;
        }
        catch (MalformedURLException e) {
            return this.getServerAddress();
        }
    }

    @Override
    public boolean isDockerHubRegistry() {
        return this.dockerHubRegistry;
    }

    @Override
    public boolean isAuthProvided() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dockerHubRegistry ? 1231 : 1237);
        result = 31 * result + (this.serverAddress == null ? 0 : this.serverAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegistryInfo other = (RegistryInfo)obj;
        if (this.dockerHubRegistry != other.dockerHubRegistry) {
            return false;
        }
        return !(this.serverAddress == null ? other.serverAddress != null : !this.serverAddress.equals(other.serverAddress));
    }

    public String toString() {
        return this.serverAddress;
    }

    @Override
    protected void enableDockerAuthenticator() {
    }

    @Override
    protected void restoreAuthenticator() {
    }
}

