/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.arduino.core.internal.LinkedProperties;
import org.eclipse.core.runtime.Platform;

public class HierarchicalProperties {
    private String value;
    private Map<String, HierarchicalProperties> children;
    private String platName;

    public HierarchicalProperties() {
        switch (Platform.getOS()) {
            case "win32": {
                this.platName = "windows";
                break;
            }
            case "macosx": {
                this.platName = "macosx";
                break;
            }
            case "linux": {
                this.platName = "linux";
            }
        }
    }

    public HierarchicalProperties(LinkedProperties properties) {
        this();
        for (Object keyObj : properties.orderedKeys()) {
            String key = (String)keyObj;
            String value = (String)properties.get(key);
            this.putProperty(key, value);
        }
    }

    public String getProperty(String qualifiedKey) {
        if (this.children == null) {
            return null;
        }
        int i = qualifiedKey.indexOf(46);
        if (i < 0) {
            HierarchicalProperties child = this.children.get(qualifiedKey);
            return child != null ? child.getValue() : null;
        }
        String key = qualifiedKey.substring(0, i);
        HierarchicalProperties child = this.children.get(key);
        if (child != null) {
            String childKey = qualifiedKey.substring(i + 1);
            return child.getProperty(childKey);
        }
        return null;
    }

    public void putProperty(String qualifiedKey, String value) {
        int i;
        if (this.children == null) {
            this.children = new LinkedHashMap<String, HierarchicalProperties>();
        }
        if ((i = qualifiedKey.indexOf(46)) < 0) {
            HierarchicalProperties child = this.children.get(qualifiedKey);
            if (child == null) {
                child = new HierarchicalProperties();
                this.children.put(qualifiedKey, child);
            }
            child.setValue(value);
        } else {
            String key = qualifiedKey.substring(0, i);
            HierarchicalProperties child = this.children.get(key);
            if (child == null) {
                child = new HierarchicalProperties();
                this.children.put(key, child);
            }
            String childKey = qualifiedKey.substring(i + 1);
            child.putProperty(childKey, value);
        }
    }

    public String getValue() {
        HierarchicalProperties child;
        if (this.platName != null && this.hasChild(this.platName) && ((child = this.getChild(this.platName)).getValue() != null || !child.hasChildren())) {
            return child.getValue();
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Map<String, HierarchicalProperties> getChildren() {
        return this.children;
    }

    private boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    private boolean hasChild(String key) {
        return this.children != null && this.children.containsKey(key);
    }

    public HierarchicalProperties getChild(String key) {
        return this.children != null ? this.children.get(key) : null;
    }

    public void putChild(String key, HierarchicalProperties node) {
        if (this.children == null) {
            this.children = new LinkedHashMap<String, HierarchicalProperties>();
        }
        this.children.put(key, node);
    }

    public List<HierarchicalProperties> listChildren() {
        int size = 0;
        for (Map.Entry<String, HierarchicalProperties> entry : this.children.entrySet()) {
            try {
                int i = Integer.parseInt(entry.getKey());
                if (i + 1 <= size) continue;
                size = i + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ArrayList<HierarchicalProperties> list = new ArrayList<HierarchicalProperties>(size);
        for (Map.Entry<String, HierarchicalProperties> entry : this.children.entrySet()) {
            try {
                int i = Integer.parseInt(entry.getKey());
                list.set(i, entry.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return list;
    }

    public void setChildren(List<HierarchicalProperties> list) {
        this.children.clear();
        int i = 0;
        while (i < list.size()) {
            HierarchicalProperties node = list.get(i);
            if (node != null) {
                this.children.put(Integer.toString(i), node);
            }
            ++i;
        }
    }

    public Properties flatten() {
        Properties properties = new Properties();
        HierarchicalProperties.flatten(null, this, properties);
        return properties;
    }

    private static void flatten(String prefix, HierarchicalProperties tree, Properties props) {
        if (tree.getValue() != null && prefix != null) {
            props.put(prefix, tree.getValue());
        }
        if (tree.getChildren() != null) {
            for (Map.Entry<String, HierarchicalProperties> entry : tree.getChildren().entrySet()) {
                String childPrefix = entry.getKey();
                if (prefix != null) {
                    childPrefix = String.valueOf(prefix) + "." + childPrefix;
                }
                HierarchicalProperties.flatten(childPrefix, entry.getValue(), props);
            }
        }
    }
}

