/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ArduinoLibrary {
    private String name;
    private String version;
    private String author;
    private String maintainer;
    private String sentence;
    private String paragraph;
    private String website;
    private String category;
    private List<String> architectures;
    private List<String> types;
    private String url;
    private String archiveFileName;
    private int size;
    private String checksum;
    private Path installPath;
    private ArduinoPlatform platform;

    public ArduinoLibrary() {
    }

    public ArduinoLibrary(Path propertiesFile) throws CoreException {
        this.installPath = propertiesFile.getParent();
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader reader = new FileReader(propertiesFile.toFile());){
                props.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw Activator.coreException(e);
        }
        this.name = props.getProperty("name");
        this.version = props.getProperty("version");
        this.author = props.getProperty("author");
        this.maintainer = props.getProperty("maintainer");
        this.sentence = props.getProperty("sentence");
        this.paragraph = props.getProperty("paragraph");
        this.category = props.getProperty("category");
        this.architectures = Arrays.asList(props.getProperty("architectures").split(","));
    }

    public ArduinoLibrary(Path propertiesFile, ArduinoPlatform platform) throws CoreException {
        this(propertiesFile);
        this.platform = platform;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    public String getSentence() {
        return this.sentence;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public void setParagraph(String paragraph) {
        this.paragraph = paragraph;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public void setArchitectures(List<String> architectures) {
        this.architectures = architectures;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public void setArchiveFileName(String archiveFileName) {
        this.archiveFileName = archiveFileName;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Path getInstallPath() {
        return this.installPath == null ? ArduinoPreferences.getArduinoHome().resolve("libraries").resolve(this.name.replaceAll("[ ()]", "_")).resolve(this.version) : this.installPath;
    }

    public ArduinoPlatform getPlatform() {
        return this.platform;
    }

    public void install(IProgressMonitor monitor) throws CoreException {
        if (Files.exists(this.getInstallPath(), new LinkOption[0])) {
            this.uninstall(monitor);
        }
        try {
            ArduinoManager.downloadAndInstall(this.url, this.archiveFileName, this.getInstallPath(), monitor);
        }
        catch (IOException e) {
            throw Activator.coreException(e);
        }
    }

    public void uninstall(IProgressMonitor monitor) throws CoreException {
        try {
            ArduinoManager.recursiveDelete(this.getInstallPath());
        }
        catch (IOException e) {
            throw Activator.coreException(e);
        }
    }

    public Collection<Path> getIncludePath() {
        Path installPath = this.getInstallPath();
        Path srcPath = installPath.resolve("src");
        if (srcPath.toFile().isDirectory()) {
            return Collections.singletonList(srcPath);
        }
        Path utilityPath = installPath.resolve("utility");
        if (utilityPath.toFile().isDirectory()) {
            return Arrays.asList(installPath, utilityPath);
        }
        return Collections.singletonList(installPath);
    }

    private void getSources(Collection<String> sources, Path dir, boolean recurse) {
        File[] fileArray = dir.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (recurse) {
                    this.getSources(sources, file.toPath(), recurse);
                }
            } else if (ArduinoBuildConfiguration.isSource(file.getName())) {
                sources.add(ArduinoBuildConfiguration.pathString(file.toPath()));
            }
            ++n2;
        }
    }

    public Collection<String> getSources() {
        ArrayList<String> sources = new ArrayList<String>();
        Path installPath = this.getInstallPath();
        Path srcPath = installPath.resolve("src");
        if (srcPath.toFile().isDirectory()) {
            this.getSources(sources, srcPath, true);
        } else {
            this.getSources(sources, installPath, false);
            Path utilityPath = installPath.resolve("utility");
            if (utilityPath.toFile().isDirectory()) {
                this.getSources(sources, utilityPath, false);
            }
        }
        return sources;
    }

    public String toString() {
        return this.getName();
    }

    private String fixText(String text) {
        String fixed = text.replaceAll("&", "&amp;");
        fixed = fixed.replaceAll("<", "&lt;");
        return fixed;
    }

    public String toFormText() {
        StringBuilder text = new StringBuilder();
        text.append("<form>");
        text.append(String.format("<p><b>%s: %s</b></p>", "Library", this.fixText(this.getName())));
        if (this.getMaintainer() != null) {
            text.append(String.format("<p>%s: %s</p>", "Maintainer", this.fixText(this.getMaintainer())));
        }
        if (this.getWebsite() != null) {
            text.append(String.format("<p><a href=\"%s\">%s</a></p>", this.getWebsite(), "Online help"));
        }
        text.append(String.format("<p>%s</p>", this.getSentence()));
        if (this.getParagraph() != null && !this.getParagraph().equals(this.getSentence())) {
            text.append(String.format("<p>%s</p>", this.getParagraph()));
        }
        text.append("</form>");
        return text.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArduinoLibrary other = (ArduinoLibrary)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.platform == null ? other.platform != null : !this.platform.equals(other.platform));
    }
}

