/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMData;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.CoreInfo;
import org.eclipse.cdt.dsf.gdb.internal.CoreList;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ProcStatCoreLoads;
import org.eclipse.cdt.dsf.gdb.internal.ProcStatParser;
import org.eclipse.cdt.dsf.gdb.internal.service.command.commands.MIMetaGetCPUInfo;
import org.eclipse.cdt.dsf.gdb.internal.service.command.output.MIMetaGetCPUInfoInfo;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIListThreadGroupsInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.internal.core.ICoreInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class GDBHardwareAndOS
extends AbstractDsfService
implements IGDBHardwareAndOS2,
ICachingService {
    static String sTempFolder;
    private Map<IDMContext, DataRequestMonitor<IGDBHardwareAndOS2.ILoadInfo>> fLoadInfoRequestCache;
    private IGDBControl fCommandControl;
    private IGDBBackend fBackend;
    private CommandFactory fCommandFactory;
    private CommandCache fFetchCPUInfoCache;
    private boolean fSessionInitializationComplete;
    private long fLastCpuLoadRefresh = 0L;
    private boolean fLoadRequestOngoing = false;
    private static final int LOAD_SAMPLE_DELAY = 250;
    private ProcStatCoreLoads fCachedLoads = null;
    private static final int LOAD_CACHE_LIFETIME = 500;

    static {
        try {
            sTempFolder = String.valueOf(Files.createTempDirectory("org.eclipse.cdt.dsf.gdb", new FileAttribute[0]).toString()) + '/';
        }
        catch (IOException | IllegalArgumentException | UnsupportedOperationException e) {
            sTempFolder = System.getProperty("java.io.tmpdir");
        }
    }

    public GDBHardwareAndOS(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            protected void handleSuccess() {
                GDBHardwareAndOS.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fSessionInitializationComplete = false;
        this.fCommandControl = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.fBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fFetchCPUInfoCache = new CommandCache(this.getSession(), (ICommandControl)new CPUInfoManager());
        this.fFetchCPUInfoCache.setContextAvailable((IDMContext)this.fCommandControl.getContext(), true);
        this.fLoadInfoRequestCache = new HashMap<IDMContext, DataRequestMonitor<IGDBHardwareAndOS2.ILoadInfo>>();
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IGDBHardwareAndOS.class.getName(), IGDBHardwareAndOS2.class.getName(), GDBHardwareAndOS.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.getSession().removeServiceEventListener((Object)this);
        this.fFetchCPUInfoCache.reset();
        this.fLoadInfoRequestCache.clear();
        this.unregister();
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    protected boolean getSessionInitializationComplete() {
        return this.fSessionInitializationComplete;
    }

    @Override
    public void getCPUs(final IGDBHardwareAndOS.IHardwareTargetDMContext dmc, final DataRequestMonitor<IGDBHardwareAndOS.ICPUDMContext[]> rm) {
        if (!this.fSessionInitializationComplete) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Debug session not initialized yet", null));
            return;
        }
        if (this.supportsProcPseudoFS()) {
            this.fFetchCPUInfoCache.execute((ICommand)new MIMetaGetCPUInfo(this.fCommandControl.getContext()), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIMetaGetCPUInfoInfo>(){

                protected void handleSuccess() {
                    rm.done((Object)GDBHardwareAndOS.this.parseCoresInfoForCPUs(dmc, ((MIMetaGetCPUInfoInfo)this.getData()).getInfo()));
                }
            });
        } else {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Operation not supported", null));
        }
    }

    private boolean supportsProcPseudoFS() {
        if (Platform.getOS().equals("linux")) {
            return true;
        }
        return SessionType.REMOTE == this.fBackend.getSessionType();
    }

    @Override
    public void getCores(IDMContext dmc, final DataRequestMonitor<IGDBHardwareAndOS.ICoreDMContext[]> rm) {
        if (!this.fSessionInitializationComplete) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Debug session not initialized yet", null));
            return;
        }
        if (dmc instanceof IGDBHardwareAndOS.ICPUDMContext) {
            final IGDBHardwareAndOS.ICPUDMContext cpuDmc = (IGDBHardwareAndOS.ICPUDMContext)dmc;
            if (this.supportsProcPseudoFS()) {
                this.fFetchCPUInfoCache.execute((ICommand)new MIMetaGetCPUInfo(this.fCommandControl.getContext()), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIMetaGetCPUInfoInfo>(){

                    protected void handleSuccess() {
                        rm.done((Object)GDBHardwareAndOS.this.parseCoresInfoForCores(cpuDmc, ((MIMetaGetCPUInfoInfo)this.getData()).getInfo()));
                    }
                });
            } else {
                rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Operation not supported", null));
            }
        } else {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid DMC type", null));
        }
    }

    IGDBHardwareAndOS.ICPUDMContext[] parseCoresInfoForCPUs(IGDBHardwareAndOS.IHardwareTargetDMContext dmc, ICoreInfo[] coresInfo) {
        HashSet<String> cpuIds = new HashSet<String>();
        ICoreInfo[] iCoreInfoArray = coresInfo;
        int n = coresInfo.length;
        int n2 = 0;
        while (n2 < n) {
            ICoreInfo core = iCoreInfoArray[n2];
            cpuIds.add(core.getPhysicalId());
            ++n2;
        }
        String[] cpuIdsArray = cpuIds.toArray(new String[cpuIds.size()]);
        IGDBHardwareAndOS.ICPUDMContext[] CPUs = new IGDBHardwareAndOS.ICPUDMContext[cpuIdsArray.length];
        int i = 0;
        while (i < cpuIdsArray.length) {
            CPUs[i] = this.createCPUContext(dmc, cpuIdsArray[i]);
            ++i;
        }
        return CPUs;
    }

    IGDBHardwareAndOS.ICoreDMContext[] parseCoresInfoForCores(IGDBHardwareAndOS.ICPUDMContext cpuDmc, ICoreInfo[] coresInfo) {
        Vector<IGDBHardwareAndOS.ICoreDMContext> coreDmcs = new Vector<IGDBHardwareAndOS.ICoreDMContext>();
        ICoreInfo[] iCoreInfoArray = coresInfo;
        int n = coresInfo.length;
        int n2 = 0;
        while (n2 < n) {
            ICoreInfo core = iCoreInfoArray[n2];
            if (core.getPhysicalId().equals(cpuDmc.getId())) {
                coreDmcs.add(this.createCoreContext(cpuDmc, core.getId()));
            }
            ++n2;
        }
        return coreDmcs.toArray(new IGDBHardwareAndOS.ICoreDMContext[coreDmcs.size()]);
    }

    @Override
    public void getExecutionData(IDMContext dmc, DataRequestMonitor<IDMData> rm) {
        if (dmc instanceof IGDBHardwareAndOS.ICoreDMContext) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Not done yet", null));
        } else if (dmc instanceof IGDBHardwareAndOS.ICPUDMContext) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Not done yet", null));
        } else {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid DMC type", null));
        }
    }

    @Override
    public IGDBHardwareAndOS.ICPUDMContext createCPUContext(IGDBHardwareAndOS.IHardwareTargetDMContext targetDmc, String CPUId) {
        return new GDBCPUDMC(this.getSession().getId(), targetDmc, CPUId);
    }

    @Override
    public IGDBHardwareAndOS.ICoreDMContext createCoreContext(IGDBHardwareAndOS.ICPUDMContext cpuDmc, String coreId) {
        return new GDBCoreDMC(this.getSession().getId(), cpuDmc, coreId);
    }

    @DsfServiceEventHandler
    public void eventDispatched(DataModelInitializedEvent e) {
        this.fSessionInitializationComplete = true;
    }

    public void flushCache(IDMContext context) {
        this.fFetchCPUInfoCache.reset(context);
    }

    @Override
    public boolean isAvailable() {
        return this.getSessionInitializationComplete();
    }

    @Override
    public void getResourceClasses(IDMContext dmc, DataRequestMonitor<IGDBHardwareAndOS2.IResourceClass[]> rm) {
        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Operation not supported", null));
    }

    @Override
    public void getResourcesInformation(IDMContext dmc, String resourceClassId, DataRequestMonitor<IGDBHardwareAndOS2.IResourcesInformation> rm) {
        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Operation not supported", null));
    }

    @Override
    public void getLoadInfo(final IDMContext context, final DataRequestMonitor<IGDBHardwareAndOS2.ILoadInfo> rm) {
        if (!(context instanceof IGDBHardwareAndOS.ICoreDMContext) && !(context instanceof IGDBHardwareAndOS.ICPUDMContext)) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Load information not supported for this context type", null));
            return;
        }
        if (!this.supportsProcPseudoFS()) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, "Operation not supported", null));
            return;
        }
        if (this.fLoadRequestOngoing) {
            this.fLoadInfoRequestCache.put(context, rm);
            return;
        }
        this.fLoadRequestOngoing = true;
        long currentTime = System.currentTimeMillis();
        if (this.fLastCpuLoadRefresh + 500L >= currentTime) {
            this.processLoads(context, rm, this.fCachedLoads);
            this.fLoadRequestOngoing = false;
            return;
        }
        this.fLastCpuLoadRefresh = currentTime;
        final ProcStatParser procStatParser = new ProcStatParser();
        final ICommandControlService.ICommandControlDMContext dmc = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)context, ICommandControlService.ICommandControlDMContext.class);
        String statFile = "/proc/stat";
        final String localFile = String.valueOf(sTempFolder) + "proc.stat." + this.getSession().getId();
        if (this.fBackend.getSessionType() == SessionType.REMOTE) {
            this.fCommandControl.queueCommand(this.fCommandFactory.createCLIRemoteGet(dmc, "/proc/stat", localFile), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        GDBHardwareAndOS.this.fLoadRequestOngoing = false;
                        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Can't get load info for CPU", null));
                        return;
                    }
                    try {
                        procStatParser.parseStatFile(localFile);
                    }
                    catch (Exception e) {
                        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Can't get load info for CPU", null));
                        GDBHardwareAndOS.this.fLoadRequestOngoing = false;
                        return;
                    }
                    new File(localFile).delete();
                    GDBHardwareAndOS.this.getExecutor().schedule(() -> GDBHardwareAndOS.this.fCommandControl.queueCommand(GDBHardwareAndOS.this.fCommandFactory.createCLIRemoteGet(dmc, "/proc/stat", localFile), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>((RequestMonitor)rm){

                        protected void handleCompleted() {
                            if (!this.isSuccess()) {
                                GDBHardwareAndOS.this.fLoadRequestOngoing = false;
                                rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Can't get load info for CPU", null));
                                return;
                            }
                            try {
                                procStatParser.parseStatFile(localFile);
                            }
                            catch (Exception e) {
                                rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Can't get load info for CPU", null));
                                GDBHardwareAndOS.this.fLoadRequestOngoing = false;
                                return;
                            }
                            new File(localFile).delete();
                            GDBHardwareAndOS.this.fCachedLoads = procStatParser.getCpuLoad();
                            GDBHardwareAndOS.this.processLoads(context, (DataRequestMonitor<IGDBHardwareAndOS2.ILoadInfo>)rm, GDBHardwareAndOS.this.fCachedLoads);
                            GDBHardwareAndOS.this.fLoadRequestOngoing = false;
                            for (Map.Entry e : GDBHardwareAndOS.this.fLoadInfoRequestCache.entrySet()) {
                                GDBHardwareAndOS.this.processLoads((IDMContext)e.getKey(), (DataRequestMonitor<IGDBHardwareAndOS2.ILoadInfo>)((DataRequestMonitor)e.getValue()), GDBHardwareAndOS.this.fCachedLoads);
                            }
                            GDBHardwareAndOS.this.fLoadInfoRequestCache.clear();
                        }
                    }), 250L, TimeUnit.MILLISECONDS);
                }
            });
        } else {
            try {
                procStatParser.parseStatFile("/proc/stat");
            }
            catch (Exception e) {
                rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Can't get load info for CPU", null));
                this.fLoadRequestOngoing = false;
                return;
            }
            this.getExecutor().schedule(() -> {
                try {
                    procStatParser.parseStatFile("/proc/stat");
                }
                catch (Exception e1) {
                    rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Can't get load info for CPU", null));
                    this.fLoadRequestOngoing = false;
                    return;
                }
                this.fCachedLoads = procStatParser.getCpuLoad();
                this.processLoads(context, rm, this.fCachedLoads);
                this.fLoadRequestOngoing = false;
                for (Map.Entry<IDMContext, DataRequestMonitor<IGDBHardwareAndOS2.ILoadInfo>> e2 : this.fLoadInfoRequestCache.entrySet()) {
                    this.processLoads(e2.getKey(), e2.getValue(), this.fCachedLoads);
                }
                this.fLoadInfoRequestCache.clear();
            }, 250L, TimeUnit.MILLISECONDS);
        }
    }

    private void processLoads(IDMContext context, final DataRequestMonitor<IGDBHardwareAndOS2.ILoadInfo> rm, final ProcStatCoreLoads loads) {
        if (loads == null) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Can't get load info", null));
            return;
        }
        if (context instanceof IGDBHardwareAndOS.ICoreDMContext) {
            String coreId = ((IGDBHardwareAndOS.ICoreDMContext)context).getId();
            float load = loads.getLoad(coreId).floatValue();
            rm.done((Object)new GDBLoadInfo(Integer.toString((int)load)));
        } else if (context instanceof IGDBHardwareAndOS.ICPUDMContext) {
            this.getCores(context, (DataRequestMonitor<IGDBHardwareAndOS.ICoreDMContext[]>)new ImmediateDataRequestMonitor<IGDBHardwareAndOS.ICoreDMContext[]>(){

                protected void handleCompleted() {
                    IGDBHardwareAndOS.ICoreDMContext[] coreContexts = (IGDBHardwareAndOS.ICoreDMContext[])this.getData();
                    if (!this.isSuccess() || coreContexts == null || coreContexts.length < 1) {
                        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Can't get load info for CPU", null));
                        return;
                    }
                    int i = 0;
                    float load = 0.0f;
                    IGDBHardwareAndOS.ICoreDMContext[] iCoreDMContextArray = coreContexts;
                    int n = coreContexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IGDBHardwareAndOS.ICoreDMContext coreCtx = iCoreDMContextArray[n2];
                        String coreId = coreCtx.getId();
                        load += loads.getLoad(coreId).floatValue();
                        ++i;
                        ++n2;
                    }
                    rm.done((Object)new GDBLoadInfo(Integer.toString((int)(load /= (float)i))));
                }
            });
        }
    }

    private class CPUInfoManager
    implements ICommandControl {
        private final List<ICommandListener> fCommandProcessors = new ArrayList<ICommandListener>();

        private CPUInfoManager() {
        }

        public <V extends ICommandResult> ICommandToken queueCommand(ICommand<V> command, DataRequestMonitor<V> rm) {
            final ICommandToken token = () -> command;
            this.processCommandSent(token);
            if (command instanceof MIMetaGetCPUInfo) {
                final DataRequestMonitor<V> drm = rm;
                final ICommandControlService.ICommandControlDMContext dmc = (ICommandControlService.ICommandControlDMContext)command.getContext();
                if (GDBHardwareAndOS.this.fBackend.getSessionType() == SessionType.REMOTE) {
                    String remoteFile = "/proc/cpuinfo";
                    final String localFile = String.valueOf(sTempFolder) + "proc.cpuinfo." + GDBHardwareAndOS.this.getSession().getId();
                    GDBHardwareAndOS.this.fCommandControl.queueCommand(GDBHardwareAndOS.this.fCommandFactory.createCLIRemoteGet(dmc, remoteFile, localFile), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                        protected void handleSuccess() {
                            ICoreInfo[] info = new CoreList(localFile).getCoreList();
                            new File(localFile).delete();
                            drm.done((Object)new MIMetaGetCPUInfoInfo(info));
                            CPUInfoManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                        }

                        protected void handleError() {
                            GDBHardwareAndOS.this.fCommandControl.queueCommand(GDBHardwareAndOS.this.fCommandFactory.createMIListThreadGroups(dmc, true), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIListThreadGroupsInfo>((RequestMonitor)drm){

                                protected void handleSuccess() {
                                    MIListThreadGroupsInfo.IThreadGroupInfo[] groups;
                                    HashSet<String> coreIds = new HashSet<String>();
                                    MIListThreadGroupsInfo.IThreadGroupInfo[] iThreadGroupInfoArray = groups = ((MIListThreadGroupsInfo)this.getData()).getGroupList();
                                    int n = groups.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        MIListThreadGroupsInfo.IThreadGroupInfo group = iThreadGroupInfoArray[n2];
                                        coreIds.addAll(Arrays.asList(group.getCores()));
                                        ++n2;
                                    }
                                    String defaultCPUId = "0";
                                    ICoreInfo[] info = new ICoreInfo[coreIds.size()];
                                    int i = 0;
                                    for (String id : coreIds) {
                                        info[i++] = new CoreInfo(id, "0");
                                    }
                                    drm.done((Object)new MIMetaGetCPUInfoInfo(info));
                                    CPUInfoManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                                }
                            });
                        }
                    });
                } else {
                    ICoreInfo[] info = new CoreList("/proc/cpuinfo").getCoreList();
                    drm.done((Object)new MIMetaGetCPUInfoInfo(info));
                    this.processCommandDone(token, (ICommandResult)drm.getData());
                }
            } else {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unexpected Meta command", null));
                rm.done();
            }
            return token;
        }

        public void addCommandListener(ICommandListener processor) {
            this.fCommandProcessors.add(processor);
        }

        public void removeCommandListener(ICommandListener processor) {
            this.fCommandProcessors.remove(processor);
        }

        private void processCommandSent(ICommandToken token) {
            for (ICommandListener processor : this.fCommandProcessors) {
                processor.commandSent(token);
            }
        }

        private void processCommandDone(ICommandToken token, ICommandResult result) {
            for (ICommandListener processor : this.fCommandProcessors) {
                processor.commandDone(token, result);
            }
        }

        public void addEventListener(IEventListener processor) {
            assert (false) : "Not supported";
        }

        public void removeEventListener(IEventListener processor) {
            assert (false) : "Not supported";
        }

        public void removeCommand(ICommandToken token) {
            assert (false) : "Not supported";
        }
    }

    @Immutable
    protected static class GDBCPUDMC
    extends AbstractDMContext
    implements IGDBHardwareAndOS.ICPUDMContext {
        private final String fId;

        protected GDBCPUDMC(String sessionId, IGDBHardwareAndOS.IHardwareTargetDMContext targetDmc, String id) {
            IDMContext[] iDMContextArray;
            if (targetDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = targetDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        @Override
        public String getId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".CPU[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && ((GDBCPUDMC)obj).fId.equals(this.fId);
        }

        public int hashCode() {
            return this.baseHashCode() ^ this.fId.hashCode();
        }
    }

    @Immutable
    protected static class GDBCPUDMData
    implements IGDBHardwareAndOS.ICPUDMData {
        final int fNumCores;

        public GDBCPUDMData(int num) {
            this.fNumCores = num;
        }

        @Override
        public int getNumCores() {
            return this.fNumCores;
        }
    }

    @Immutable
    protected static class GDBCoreDMC
    extends AbstractDMContext
    implements IGDBHardwareAndOS.ICoreDMContext {
        private final String fId;

        public GDBCoreDMC(String sessionId, IGDBHardwareAndOS.ICPUDMContext CPUDmc, String id) {
            IDMContext[] iDMContextArray;
            if (CPUDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = CPUDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        @Override
        public String getId() {
            return this.fId;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".core[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && (((GDBCoreDMC)obj).fId == null ? this.fId == null : ((GDBCoreDMC)obj).fId.equals(this.fId));
        }

        public int hashCode() {
            return this.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    protected static class GDBCoreDMData
    implements IGDBHardwareAndOS.ICoreDMData {
        final String fPhysicalId;

        public GDBCoreDMData(String id) {
            this.fPhysicalId = id;
        }

        @Override
        public String getPhysicalId() {
            return this.fPhysicalId;
        }
    }

    @Immutable
    protected class GDBLoadInfo
    implements IGDBHardwareAndOS2.ILoadInfo {
        private String fLoad;
        private Map<String, String> fDetailedLoad;

        public GDBLoadInfo(String load, Map<String, String> detailedLoad) {
            this.fLoad = load;
            this.fDetailedLoad = detailedLoad;
        }

        public GDBLoadInfo(String load) {
            this(load, null);
        }

        @Override
        public String getLoad() {
            return this.fLoad;
        }

        @Override
        public Map<String, String> getDetailedLoad() {
            return this.fDetailedLoad;
        }
    }
}

